/* do not edit automatically generated by mc from M2BasicBlock.  */
/* M2BasicBlock.mod converts a scope block into a list of basic blocks.

Copyright (C) 2001-2025 Free Software Foundation, Inc.
Contributed by Gaius Mulley <gaius.mulley@southwales.ac.uk>.

This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GNU Modula-2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Modula-2; see the file COPYING3.  If not see
<http://www.gnu.org/licenses/>.  */

#include "config.h"
#include "system.h"
#include "gcc-consolidation.h"

#include <stdbool.h>
#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif

#   if !defined (TRUE)
#      define TRUE (1==1)
#   endif

#   if !defined (FALSE)
#      define FALSE (1==0)
#   endif

#   include "GStorage.h"
#if defined(__cplusplus)
#   undef NULL
#   define NULL 0
#endif
#define _M2BasicBlock_C

#include "GM2BasicBlock.h"
#   include "GStorage.h"
#   include "GStrIO.h"
#   include "GNumberIO.h"
#   include "GM2Debug.h"
#   include "GM2Options.h"
#   include "GM2Quads.h"
#   include "GM2Scope.h"

typedef struct M2BasicBlock_BasicBlockProc_p M2BasicBlock_BasicBlockProc;

#   define Debugging false
typedef struct M2BasicBlock__T1_r M2BasicBlock__T1;

typedef M2BasicBlock__T1 *M2BasicBlock_BasicBlock__opaque;

struct M2BasicBlock__T1_r {
                            unsigned int Scope;
                            unsigned int StartQuad;
                            unsigned int EndQuad;
                            bool First;
                            M2BasicBlock_BasicBlock__opaque Right;
                            M2BasicBlock_BasicBlock__opaque Left;
                          };

static M2BasicBlock_BasicBlock__opaque FreeList;
static M2BasicBlock_BasicBlock__opaque HeadOfBasicBlock;

/*
   InitBasicBlocks - converts a list of quadruples as defined by
                     scope blocks into a set of basic blocks.
                     All quadruples within this list which are not
                     reachable are removed.
*/

extern "C" M2BasicBlock_BasicBlock M2BasicBlock_InitBasicBlocks (M2Scope_ScopeBlock sb);

/*
   InitBasicBlocksFromRange - converts a list of quadruples as defined by
                              start..end.
                              All quadruples within this list which are not
                              reachable are removed.
*/

extern "C" M2BasicBlock_BasicBlock M2BasicBlock_InitBasicBlocksFromRange (unsigned int ScopeSym, unsigned int start, unsigned int end);

/*
   KillBasicBlocks - destroys the list of Basic Blocks.
*/

extern "C" void M2BasicBlock_KillBasicBlocks (M2BasicBlock_BasicBlock *bb);

/*
   FreeBasicBlocks - destroys the list of Basic Blocks.
*/

extern "C" void M2BasicBlock_FreeBasicBlocks (M2BasicBlock_BasicBlock bb);

/*
   ForeachBasicBlockDo - for each basic block call procedure  p.
*/

extern "C" void M2BasicBlock_ForeachBasicBlockDo (M2BasicBlock_BasicBlock bb, M2BasicBlock_BasicBlockProc p);

/*
   GetBasicBlockScope - return the scope associated with the basic block.
*/

extern "C" unsigned int M2BasicBlock_GetBasicBlockScope (M2BasicBlock_BasicBlock bb);

/*
   GetBasicBlockStart - return the quad associated with the start of the basic block.
*/

extern "C" unsigned int M2BasicBlock_GetBasicBlockStart (M2BasicBlock_BasicBlock bb);

/*
   GetBasicBlockEnd - return the quad associated with the end of the basic block.
*/

extern "C" unsigned int M2BasicBlock_GetBasicBlockEnd (M2BasicBlock_BasicBlock bb);

/*
   IsBasicBlockFirst - return TRUE if this basic block is the first in the sequence.
*/

extern "C" bool M2BasicBlock_IsBasicBlockFirst (M2BasicBlock_BasicBlock bb);
static void stop (void);

/*
   New - returns a basic block.
*/

static M2BasicBlock_BasicBlock__opaque New (unsigned int Scope, bool First);

/*
   ConvertQuads2BasicBlock - converts a list of quadruples to a list of
                             Basic Blocks.
                             A Basic Block is defined as a list of quadruples
                             which has only has one entry and exit point.
*/

static void ConvertQuads2BasicBlock (unsigned int ScopeSym, unsigned int Start, unsigned int End);

/*
   StartBB - Initially fills a Basic Block, b, with a start quad Quad.
             The Basic Block is then added to the end of Basic Block list.
*/

static void StartBB (M2BasicBlock_BasicBlock__opaque b, unsigned int Quad);

/*
   EndBB - Fills a Basic Block, b, with an end quad Quad.
*/

static void EndBB (M2BasicBlock_BasicBlock__opaque b, unsigned int Quad);

/*
   Add adds a specified element to the end of a queue.
*/

static void Add (M2BasicBlock_BasicBlock__opaque *Head, M2BasicBlock_BasicBlock__opaque b);

/*
   DisplayBasicBlocks - displays the basic block data structure.
*/

static void DisplayBasicBlocks (M2BasicBlock_BasicBlock__opaque bb);

/*
   DisplayBasicBlocks - displays the basic block data structure.
*/

static void DisplayBlock (M2BasicBlock_BasicBlock__opaque b);

static void stop (void)
{
}


/*
   New - returns a basic block.
*/

static M2BasicBlock_BasicBlock__opaque New (unsigned int Scope, bool First)
{
  M2BasicBlock_BasicBlock__opaque b;

  if (FreeList == NULL)
    {
      Storage_ALLOCATE ((void **) &b, sizeof (M2BasicBlock__T1));
    }
  else
    {
      b = FreeList;
      FreeList = FreeList->Right;
    }
  M2Debug_Assert (b != NULL);
  b->Scope = Scope;
  b->First = First;
  return b;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   ConvertQuads2BasicBlock - converts a list of quadruples to a list of
                             Basic Blocks.
                             A Basic Block is defined as a list of quadruples
                             which has only has one entry and exit point.
*/

static void ConvertQuads2BasicBlock (unsigned int ScopeSym, unsigned int Start, unsigned int End)
{
  bool First;
  bool LastQuadDefMod;
  bool LastQuadConditional;
  bool LastQuadCall;
  bool LastQuadReturn;
  unsigned int Quad;
  M2BasicBlock_BasicBlock__opaque CurrentBB;
  M2BasicBlock_BasicBlock__opaque LastBB;

  if (Debugging)
    {
      StrIO_WriteString ((const char *) "Enter ConvertQuads2BasicBlock", 29);
      StrIO_WriteLn ();
      M2Quads_DisplayQuadRange (ScopeSym, Start, End);
    }
  /* 
      Algorithm to perform Basic Block:

      For every quadruple establish a set of leaders.
      A leader is defined as a quadruple which is
      either:

      (i)   The first quadruple.
      (ii)  Any quadruple which is the target of a jump or unconditional jump.
      (iii) Any statement which follows a conditional jump

      For each leader construct a basic block.
      A Basic Block starts with a leader quadruple and ends with either:

      (i)  Another leader
      (ii) An unconditional Jump.

      Any quadruples that do not fall into a Basic Block can be thrown away
      since they will never be executed.
  */
  LastBB = static_cast<M2BasicBlock_BasicBlock__opaque> (NULL);
  CurrentBB = static_cast<M2BasicBlock_BasicBlock__opaque> (NULL);
  Quad = Start;
  LastQuadConditional = true;  /* Force Rule (i).  */
  LastQuadCall = false;  /* Force Rule (i).  */
  LastQuadReturn = false;
  LastQuadDefMod = false;
  First = true;
  /* Scan all quadruples.  */
  while ((Quad <= End) && (Quad != 0))
    {
      if (Quad == 200)
        {
          stop ();
        }
      if ((((LastQuadConditional || LastQuadCall) || LastQuadReturn) || LastQuadDefMod) || (M2Quads_IsReferenced (Quad)))
        {
          /* Rule (ii)  */
          CurrentBB = New (ScopeSym, First);  /* Get a new Basic Block.  */
          /* At least one quad in this Basic Block.  */
          StartBB (CurrentBB, Quad);
          EndBB (CurrentBB, Quad);
          First = false;
        }
      else if (CurrentBB != NULL)
        {
          /* avoid dangling else.  */
          /* We have a Basic Block - therefore add quad to this Block  */
          EndBB (CurrentBB, Quad);
        }
      else if (M2Quads_IsPseudoQuad (Quad))
        {
          /* avoid dangling else.  */
          /* must not be thrown away.  */
          EndBB (LastBB, Quad);
        }
      else if ((((((((M2Quads_IsReturn (Quad)) || (M2Quads_IsKillLocalVar (Quad))) || (M2Quads_IsCatchEnd (Quad))) || (M2Quads_IsCatchBegin (Quad))) || (M2Quads_IsInitStart (Quad))) || (M2Quads_IsInitEnd (Quad))) || (M2Quads_IsFinallyStart (Quad))) || (M2Quads_IsFinallyEnd (Quad)))
        {
          /* avoid dangling else.  */
          /* We must leave these quads alone.  */
          EndBB (LastBB, Quad);
        }
      else if (M2Quads_IsConditionalBooleanQuad (Quad))
        {
          /* avoid dangling else.  */
          /* 
      ELSIF IsInitialisingConst(Quad)
      THEN
          But we leave remaining constant quads alone.  
         EndBB(LastBB, Quad)
  */
          M2Quads_SubQuad (Quad);
        }
      else
        {
          /* avoid dangling else.  */
          /* Remove this Quad since it will never be reached.  */
          M2Quads_SubQuad (Quad);
        }
      LastQuadConditional = M2Quads_IsConditional (Quad);
      LastQuadCall = M2Quads_IsCall (Quad);
      LastQuadReturn = M2Quads_IsReturn (Quad);
      LastQuadDefMod = M2Quads_IsDefOrModFile (Quad);
      if (M2Quads_IsUnConditional (Quad))
        {
          LastBB = CurrentBB;
          CurrentBB = static_cast<M2BasicBlock_BasicBlock__opaque> (NULL);
        }
      Quad = M2Quads_GetNextQuad (Quad);
    }
  if (Debugging)
    {
      StrIO_WriteString ((const char *) "Exit ConvertQuads2BasicBlock", 28);
      StrIO_WriteLn ();
      M2Quads_DisplayQuadRange (ScopeSym, Start, End);
    }
}


/*
   StartBB - Initially fills a Basic Block, b, with a start quad Quad.
             The Basic Block is then added to the end of Basic Block list.
*/

static void StartBB (M2BasicBlock_BasicBlock__opaque b, unsigned int Quad)
{
  b->StartQuad = Quad;
  b->EndQuad = Quad;
  Add (&HeadOfBasicBlock, b);  /* Add b to the end of the Basic Block list  */
}


/*
   EndBB - Fills a Basic Block, b, with an end quad Quad.
*/

static void EndBB (M2BasicBlock_BasicBlock__opaque b, unsigned int Quad)
{
  b->EndQuad = Quad;
}


/*
   Add adds a specified element to the end of a queue.
*/

static void Add (M2BasicBlock_BasicBlock__opaque *Head, M2BasicBlock_BasicBlock__opaque b)
{
  if ((*Head) == NULL)
    {
      (*Head) = b;
      b->Left = b;
      b->Right = b;
    }
  else
    {
      b->Right = (*Head);
      b->Left = (*Head)->Left;
      (*Head)->Left->Right = b;
      (*Head)->Left = b;
    }
}


/*
   DisplayBasicBlocks - displays the basic block data structure.
*/

static void DisplayBasicBlocks (M2BasicBlock_BasicBlock__opaque bb)
{
  M2BasicBlock_BasicBlock__opaque b;

  b = bb;
  StrIO_WriteString ((const char *) "quadruples", 10);
  StrIO_WriteLn ();
  if (b != NULL)
    {
      do {
        DisplayBlock (b);
        b = b->Right;
      } while (! (b == bb));
    }
}


/*
   DisplayBasicBlocks - displays the basic block data structure.
*/

static void DisplayBlock (M2BasicBlock_BasicBlock__opaque b)
{
  StrIO_WriteString ((const char *) " start ", 7);
  NumberIO_WriteCard (b->StartQuad, 6);
  StrIO_WriteString ((const char *) " end   ", 7);
  NumberIO_WriteCard (b->EndQuad, 6);
}


/*
   InitBasicBlocks - converts a list of quadruples as defined by
                     scope blocks into a set of basic blocks.
                     All quadruples within this list which are not
                     reachable are removed.
*/

extern "C" M2BasicBlock_BasicBlock M2BasicBlock_InitBasicBlocks (M2Scope_ScopeBlock sb)
{
  HeadOfBasicBlock = static_cast<M2BasicBlock_BasicBlock__opaque> (NULL);
  M2Scope_ForeachScopeBlockDo3 (sb, (M2Scope_ScopeProcedure3) {(M2Scope_ScopeProcedure3_t) ConvertQuads2BasicBlock});
  return static_cast<M2BasicBlock_BasicBlock> (HeadOfBasicBlock);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   InitBasicBlocksFromRange - converts a list of quadruples as defined by
                              start..end.
                              All quadruples within this list which are not
                              reachable are removed.
*/

extern "C" M2BasicBlock_BasicBlock M2BasicBlock_InitBasicBlocksFromRange (unsigned int ScopeSym, unsigned int start, unsigned int end)
{
  HeadOfBasicBlock = static_cast<M2BasicBlock_BasicBlock__opaque> (NULL);
  ConvertQuads2BasicBlock (ScopeSym, start, end);
  if (Debugging)
    {
      DisplayBasicBlocks (HeadOfBasicBlock);
    }
  return static_cast<M2BasicBlock_BasicBlock> (HeadOfBasicBlock);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   KillBasicBlocks - destroys the list of Basic Blocks.
*/

extern "C" void M2BasicBlock_KillBasicBlocks (M2BasicBlock_BasicBlock *bb)
{
  M2BasicBlock_FreeBasicBlocks ((*bb));
  (*bb) = static_cast<M2BasicBlock_BasicBlock> (NULL);
}


/*
   FreeBasicBlocks - destroys the list of Basic Blocks.
*/

extern "C" void M2BasicBlock_FreeBasicBlocks (M2BasicBlock_BasicBlock bb)
{
  M2BasicBlock_BasicBlock__opaque b;
  M2BasicBlock_BasicBlock__opaque c;

  if (bb != NULL)
    {
      b = static_cast<M2BasicBlock_BasicBlock__opaque> (bb);
      do {
        c = static_cast<M2BasicBlock_BasicBlock__opaque> (bb)->Right;
        static_cast<M2BasicBlock_BasicBlock__opaque> (bb)->Right = FreeList;
        FreeList = static_cast<M2BasicBlock_BasicBlock__opaque> (bb);
        bb = static_cast<M2BasicBlock_BasicBlock> (c);
      } while (! (bb == b));
    }
}


/*
   ForeachBasicBlockDo - for each basic block call procedure  p.
*/

extern "C" void M2BasicBlock_ForeachBasicBlockDo (M2BasicBlock_BasicBlock bb, M2BasicBlock_BasicBlockProc p)
{
  M2BasicBlock_BasicBlock__opaque b;

  if (bb != NULL)
    {
      b = static_cast<M2BasicBlock_BasicBlock__opaque> (bb);
      do {
        (*p.proc) (static_cast<M2BasicBlock_BasicBlock> (b));
        b = b->Right;
      } while (! (b == bb));
    }
}


/*
   GetBasicBlockScope - return the scope associated with the basic block.
*/

extern "C" unsigned int M2BasicBlock_GetBasicBlockScope (M2BasicBlock_BasicBlock bb)
{
  return static_cast<M2BasicBlock_BasicBlock__opaque> (bb)->Scope;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetBasicBlockStart - return the quad associated with the start of the basic block.
*/

extern "C" unsigned int M2BasicBlock_GetBasicBlockStart (M2BasicBlock_BasicBlock bb)
{
  return static_cast<M2BasicBlock_BasicBlock__opaque> (bb)->StartQuad;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetBasicBlockEnd - return the quad associated with the end of the basic block.
*/

extern "C" unsigned int M2BasicBlock_GetBasicBlockEnd (M2BasicBlock_BasicBlock bb)
{
  return static_cast<M2BasicBlock_BasicBlock__opaque> (bb)->EndQuad;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsBasicBlockFirst - return TRUE if this basic block is the first in the sequence.
*/

extern "C" bool M2BasicBlock_IsBasicBlockFirst (M2BasicBlock_BasicBlock bb)
{
  return static_cast<M2BasicBlock_BasicBlock__opaque> (bb)->First;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}

extern "C" void _M2_M2BasicBlock_init (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
  FreeList = static_cast<M2BasicBlock_BasicBlock__opaque> (NULL);
}

extern "C" void _M2_M2BasicBlock_fini (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
}
