/* do not edit automatically generated by mc from M2Check.  */
/* M2Check.mod perform rigerous type checking for fully declared symbols.

Copyright (C) 2020-2025 Free Software Foundation, Inc.
Contributed by Gaius Mulley <gaius.mulley@southwales.ac.uk>.

This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GNU Modula-2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Modula-2; see the file COPYING3.  If not see
<http://www.gnu.org/licenses/>.  */

#include "config.h"
#include "system.h"
#include "gcc-consolidation.h"

#include <stdbool.h>
#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif

#   if !defined (TRUE)
#      define TRUE (1==1)
#   endif

#   if !defined (FALSE)
#      define FALSE (1==0)
#   endif

#   include "GStorage.h"
#   include "Gmcrts.h"
#if defined(__cplusplus)
#   undef NULL
#   define NULL 0
#endif
#define _M2Check_C

#include "GM2Check.h"
#   include "GM2System.h"
#   include "GM2Base.h"
#   include "GIndexing.h"
#   include "GM2Error.h"
#   include "GM2MetaError.h"
#   include "GStrLib.h"
#   include "GM2Debug.h"
#   include "GSymbolTable.h"
#   include "GM2GCCDeclare.h"
#   include "GM2ALU.h"
#   include "GM2Options.h"
#   include "Gm2expr.h"
#   include "GSymbolConversion.h"
#   include "GDynamicStrings.h"
#   include "GM2LexBuf.h"
#   include "GStorage.h"
#   include "GSYSTEM.h"
#   include "Glibc.h"

#   define debugging false
#   define MaxEquvalence 20
typedef struct M2Check_typeCheckFunction_p M2Check_typeCheckFunction;

typedef struct M2Check_EquivalenceProcedure_p M2Check_EquivalenceProcedure;

typedef struct M2Check__T1_r M2Check__T1;

typedef M2Check__T1 *M2Check_errorSig;

typedef struct M2Check__T2_r M2Check__T2;

typedef M2Check__T2 *M2Check_pair;

typedef struct M2Check__T3_r M2Check__T3;

typedef M2Check__T3 *M2Check_tInfo;

typedef struct M2Check__T4_a M2Check__T4;

typedef enum {M2Check_parameter, M2Check_assignment, M2Check_expression} M2Check_checkType;

typedef enum {M2Check_true, M2Check_false, M2Check_unknown, M2Check_visited, M2Check_unused} M2Check_status;

typedef M2Check_status (*M2Check_typeCheckFunction_t) (M2Check_status, M2Check_tInfo, unsigned int, unsigned int);
struct M2Check_typeCheckFunction_p { M2Check_typeCheckFunction_t proc; };

typedef M2Check_status (*M2Check_EquivalenceProcedure_t) (M2Check_status, M2Check_tInfo, unsigned int, unsigned int);
struct M2Check_EquivalenceProcedure_p { M2Check_EquivalenceProcedure_t proc; };

struct M2Check__T1_r {
                       unsigned int token;
                       unsigned int left;
                       unsigned int right;
                     };

struct M2Check__T2_r {
                       unsigned int left;
                       unsigned int right;
                       M2Check_status pairStatus;
                       M2Check_pair next;
                     };

struct M2Check__T3_r {
                       bool reasonEnable;
                       DynamicStrings_String reason;
                       DynamicStrings_String format;
                       M2Check_checkType kind;
                       unsigned int token;
                       unsigned int actual;
                       unsigned int formal;
                       unsigned int left;
                       unsigned int right;
                       unsigned int procedure;
                       unsigned int nth;
                       bool isvar;
                       bool strict;
                       bool isin;
                       M2Error_Error error;
                       M2Check_typeCheckFunction checkFunc;
                       Indexing_Index visited;
                       Indexing_Index resolved;
                       Indexing_Index unresolved;
                       M2Check_tInfo next;
                     };

struct M2Check__T4_a { M2Check_EquivalenceProcedure array[MaxEquvalence-1+1]; };
static M2Check_pair pairFreeList;
static M2Check_tInfo tinfoFreeList;
static Indexing_Index errors;
static unsigned int HighEquivalence;
static M2Check__T4 Equivalence;

/*
   ParameterTypeCompatible - returns TRUE if the nth procedure parameter formal
                             is compatible with actual.
*/

extern "C" bool M2Check_ParameterTypeCompatible (unsigned int token, const char *format_, unsigned int _format_high, unsigned int procedure, unsigned int formal, unsigned int actual, unsigned int nth, bool isvar);

/*
   AssignmentTypeCompatible - returns TRUE if the des and the expr are assignment compatible.
*/

extern "C" bool M2Check_AssignmentTypeCompatible (unsigned int token, const char *format_, unsigned int _format_high, unsigned int des, unsigned int expr, bool enableReason);

/*
   ExpressionTypeCompatible - returns TRUE if the expressions, left and right,
                              are expression compatible.
*/

extern "C" bool M2Check_ExpressionTypeCompatible (unsigned int token, const char *format_, unsigned int _format_high, unsigned int left, unsigned int right, bool strict, bool isin);

/*
   dumpIndice -
*/

static void dumpIndice (M2Check_pair ptr);

/*
   dumpIndex -
*/

static void dumpIndex (const char *name_, unsigned int _name_high, Indexing_Index index);

/*
   dumptInfo -
*/

static void dumptInfo (M2Check_tInfo t);

/*
   falseReason2 - return false.  It also stores the message as the
                  reason for the false value.
*/

static M2Check_status falseReason2 (const char *message_, unsigned int _message_high, M2Check_tInfo tinfo, unsigned int left, unsigned int right);

/*
   falseReason1 - return false.  It also stores the message as the
                  reason for the false value.
*/

static M2Check_status falseReason1 (const char *message_, unsigned int _message_high, M2Check_tInfo tinfo, unsigned int operand);

/*
   falseReason0 - return false.  It also stores the message as the
                  reason for the false value.
*/

static M2Check_status falseReason0 (const char *message_, unsigned int _message_high, M2Check_tInfo tinfo);

/*
   isKnown - returns BOOLEAN:TRUE if result is status:true or status:false.
*/

static bool isKnown (M2Check_status result);

/*
   isFalse - returns BOOLEAN:TRUE if result is status:false
*/

static bool isFalse (M2Check_status result);

/*
   checkTypeEquivalence - returns TRUE if left and right can be skipped and found to be equal.
*/

static M2Check_status checkTypeEquivalence (M2Check_status result, M2Check_tInfo tinfo, unsigned int left, unsigned int right);

/*
   checkSubrange - check to see if subrange types left and right have the same limits.
*/

static M2Check_status checkSubrange (M2Check_status result, M2Check_tInfo tinfo, unsigned int left, unsigned int right);

/*
   checkUnboundedArray - returns status if unbounded is parameter compatible with array.
                         It checks all type equivalences of the static array for a
                         match with the dynamic (unbounded) array.
*/

static M2Check_status checkUnboundedArray (M2Check_status result, M2Check_tInfo tinfo, unsigned int unbounded, unsigned int array);

/*
   checkUnboundedUnbounded - check to see if formal and actual are compatible.
                             Both are unbounded parameters.
*/

static M2Check_status checkUnboundedUnbounded (M2Check_status result, M2Check_tInfo tinfo, unsigned int formal, unsigned int actual);

/*
   checkUnbounded - check to see if the unbounded is type compatible with right.
                    This is only allowed during parameter passing.
*/

static M2Check_status checkUnbounded (M2Check_status result, M2Check_tInfo tinfo, unsigned int unbounded, unsigned int right);

/*
   checkArrayTypeEquivalence - check array and unbounded array type equivalence.
*/

static M2Check_status checkArrayTypeEquivalence (M2Check_status result, M2Check_tInfo tinfo, unsigned int left, unsigned int right);

/*
   checkCharStringTypeEquivalence - check char and string constants for type equivalence.
*/

static M2Check_status checkCharStringTypeEquivalence (M2Check_status result, M2Check_tInfo tinfo, unsigned int left, unsigned int right);

/*
   firstTime - returns TRUE if the triple (token, left, right) has not been seen before.
*/

static bool firstTime (unsigned int token, unsigned int left, unsigned int right);

/*
   buildError4 - generate a MetaString4 error.  This is only used when checking
                 parameter compatibility.
*/

static void buildError4 (M2Check_tInfo tinfo, unsigned int left, unsigned int right);

/*
   buildError2 - generate a MetaString2 error.
*/

static void buildError2 (M2Check_tInfo tinfo, unsigned int left, unsigned int right);

/*
   issueError -
*/

static M2Check_status issueError (bool result, M2Check_tInfo tinfo, unsigned int left, unsigned int right);

/*
   checkBaseEquivalence - the catch all check for types not specifically
                          handled by this module.
*/

static M2Check_status checkBaseEquivalence (M2Check_status result, M2Check_tInfo tinfo, unsigned int left, unsigned int right);

/*
   checkPair - check whether left and right are type compatible.
               It will update the visited, unresolved list before
               calling the docheckPair for the cascaded type checking.
               Pre-condition: tinfo is initialized.
                              left and right are modula2 symbols.
               Post-condition: tinfo visited, resolved, unresolved lists
                               are updated and the result status is
                               returned.
*/

static M2Check_status checkPair (M2Check_status result, M2Check_tInfo tinfo, unsigned int left, unsigned int right);

/*
   useBaseCheck -
*/

static bool useBaseCheck (unsigned int sym);

/*
   checkBaseTypeEquivalence -
*/

static M2Check_status checkBaseTypeEquivalence (M2Check_status result, M2Check_tInfo tinfo, unsigned int left, unsigned int right);

/*
   IsTyped - returns TRUE if sym will have a type.
*/

static bool IsTyped (unsigned int sym);

/*
   IsTypeEquivalence - returns TRUE if sym is a type equivalence symbol.
*/

static bool IsTypeEquivalence (unsigned int sym);

/*
   isLValue -
*/

static bool isLValue (unsigned int sym);

/*
   checkVarTypeEquivalence -
*/

static M2Check_status checkVarTypeEquivalence (M2Check_status result, M2Check_tInfo tinfo, unsigned int left, unsigned int right);

/*
   checkVarEquivalence - this test must be done early as it checks the symbol mode.
                         An LValue is treated as a pointer during assignment and the
                         LValue is attached to a variable.  This function skips the variable
                         and checks the types - after it has considered a possible LValue.
*/

static M2Check_status checkVarEquivalence (M2Check_status result, M2Check_tInfo tinfo, unsigned int des, unsigned int expr);

/*
   checkConstMeta - performs a very course grained check against
                    obviously incompatible type kinds.
                    If left is a const string then it checks right against char.
*/

static M2Check_status checkConstMeta (M2Check_status result, M2Check_tInfo tinfo, unsigned int left, unsigned int right);

/*
   checkEnumField -
*/

static M2Check_status checkEnumField (M2Check_status result, M2Check_tInfo tinfo, unsigned int left, unsigned int right);

/*
   checkEnumFieldEquivalence -
*/

static M2Check_status checkEnumFieldEquivalence (M2Check_status result, M2Check_tInfo tinfo, unsigned int left, unsigned int right);

/*
   checkConstEquivalence - this check can be done first as it checks symbols which
                           may have no type.  Ie constant strings.  These constants
                           will likely have their type set during quadruple folding.
                           But we can check the meta type for obvious mismatches
                           early on.  For example adding a string to an enum or set.
*/

static M2Check_status checkConstEquivalence (M2Check_status result, M2Check_tInfo tinfo, unsigned int left, unsigned int right);

/*
   checkSubrangeTypeEquivalence -
*/

static M2Check_status checkSubrangeTypeEquivalence (M2Check_status result, M2Check_tInfo tinfo, unsigned int left, unsigned int right);

/*
   IsZRCType - return TRUE if type is a ZType, RType or a CType.
*/

static bool IsZRCType (unsigned int type);

/*
   isZRC - return TRUE if zrc is a ZType, RType or a CType
           and sym is either a complex type when zrc = CType
           or is not a composite type when zrc is a RType or ZType.
*/

static bool isZRC (unsigned int zrc, unsigned int sym);

/*
   isSameSizeConst -

*/

static bool isSameSizeConst (unsigned int a, unsigned int b);

/*
   isSameSize - should only be called if either a or b are WORD, BYTE, etc.
*/

static bool isSameSize (unsigned int a, unsigned int b);

/*
   checkSystemEquivalence - check whether left and right are system types and whether they have the same size.
*/

static M2Check_status checkSystemEquivalence (M2Check_status result, M2Check_tInfo tinfo __attribute__((unused)), unsigned int left, unsigned int right);

/*
   checkTypeKindViolation - returns false if one operand left or right is
                            a set, record or array.
*/

static M2Check_status checkTypeKindViolation (M2Check_status result, M2Check_tInfo tinfo, unsigned int left, unsigned int right);

/*
   doCheckPair - invoke a series of type checks checking compatibility
                 between left and right modula2 symbols.
                 Pre-condition: left and right are modula-2 symbols.
                                tinfo is configured.
                 Post-condition: status is returned determining the
                                 correctness of the type check.
                                 The tinfo resolved, unresolved, visited
                                 lists will be updated.
*/

static M2Check_status doCheckPair (M2Check_status result, M2Check_tInfo tinfo, unsigned int left, unsigned int right);

/*
   InitEquivalenceArray - populate the Equivalence array with the
                          checking procedures.
*/

static void InitEquivalenceArray (void);

/*
   addEquivalence - places proc into Equivalence array.
*/

static void addEquivalence (M2Check_EquivalenceProcedure proc);

/*
   checkProcType -
*/

static M2Check_status checkProcType (M2Check_status result, M2Check_tInfo tinfo, unsigned int left, unsigned int right);

/*
   checkProcedureProcType -
*/

static M2Check_status checkProcedureProcType (M2Check_status result, M2Check_tInfo tinfo, unsigned int left, unsigned int right);

/*
   checkProcedure -
*/

static M2Check_status checkProcedure (M2Check_status result, M2Check_tInfo tinfo, unsigned int left, unsigned int right);

/*
   checkEnumerationEquivalence -
*/

static M2Check_status checkEnumerationEquivalence (M2Check_status result, unsigned int left, unsigned int right);

/*
   checkPointerType - check whether left and right are equal or are of type ADDRESS.
*/

static M2Check_status checkPointerType (M2Check_status result, unsigned int left, unsigned int right);

/*
   checkProcTypeEquivalence - allow proctype to be compared against another
                              proctype or procedure.  It is legal to be compared
                              against an address.
*/

static M2Check_status checkProcTypeEquivalence (M2Check_status result, M2Check_tInfo tinfo, unsigned int left, unsigned int right);

/*
   checkTypeKindEquivalence -
*/

static M2Check_status checkTypeKindEquivalence (M2Check_status result, M2Check_tInfo tinfo, unsigned int left, unsigned int right);

/*
   isSkipEquivalence -
*/

static bool isSkipEquivalence (unsigned int left, unsigned int right);

/*
   checkValueEquivalence - check to see if left and right values are the same.
*/

static M2Check_status checkValueEquivalence (M2Check_status result, unsigned int left, unsigned int right);

/*
   and -
*/

static M2Check_status and_ (M2Check_status left, M2Check_status right);

/*
   checkTypeRangeEquivalence -
*/

static M2Check_status checkTypeRangeEquivalence (M2Check_status result, M2Check_tInfo tinfo, unsigned int left, unsigned int right);

/*
   include - include pair left:right into pairs with status, s.
*/

static void include (Indexing_Index pairs, unsigned int left, unsigned int right, M2Check_status s);

/*
   exclude - exclude pair left:right from pairs.
*/

static void exclude (Indexing_Index pairs, unsigned int left, unsigned int right);

/*
   getStatus -
*/

static M2Check_status getStatus (Indexing_Index pairs, unsigned int left, unsigned int right);

/*
   return -
*/

static M2Check_status return_ (M2Check_status result, M2Check_tInfo tinfo, unsigned int left, unsigned int right);

/*
   checkSkipEquivalence - return true if left right are equivalent.
*/

static M2Check_status checkSkipEquivalence (M2Check_status result, unsigned int left, unsigned int right);

/*
   checkSetEquivalent - compares set types, left and right.
*/

static M2Check_status checkSetEquivalent (M2Check_status result, M2Check_tInfo tinfo, unsigned int left, unsigned int right);

/*
   checkRecordEquivalence - compares record types, left and right.
*/

static M2Check_status checkRecordEquivalence (M2Check_status result, unsigned int left, unsigned int right);

/*
   getType - only returns the type of symbol providing it is not a procedure.
*/

static unsigned int getType (unsigned int sym);

/*
   getSType -
*/

static unsigned int getSType (unsigned int sym);

/*
   determineCompatible - check for compatibility by checking
                         equivalence, array, generic and type kind.
*/

static M2Check_status determineCompatible (M2Check_status result, M2Check_tInfo tinfo, unsigned int left, unsigned int right);

/*
   get -
*/

static bool get (Indexing_Index pairs, unsigned int *left, unsigned int *right, M2Check_status s);

/*
   isInternal - return TRUE if sym is a constant lit which was declared
                as internal.
*/

static bool isInternal (unsigned int sym);

/*
   doCheck - keep obtaining an unresolved pair and check for the
             type compatibility.  This is the main check routine used by
             parameter, assignment and expression compatibility.
             It tests all unknown pairs and calls the appropriate
             check function
*/

static bool doCheck (M2Check_tInfo tinfo);

/*
   in - returns TRUE if the pair is in the list.
*/

static bool in (Indexing_Index pairs, unsigned int left, unsigned int right);

/*
   newPair -
*/

static M2Check_pair newPair (void);

/*
   disposePair - adds pair, p, to the free list.
*/

static void disposePair (M2Check_pair p);

/*
   deconstructIndex -
*/

static Indexing_Index deconstructIndex (Indexing_Index pairs);

/*
   deconstruct - deallocate the List data structure.
*/

static void deconstruct (M2Check_tInfo tinfo);

/*
   newtInfo -
*/

static M2Check_tInfo newtInfo (void);

/*
   collapseString - if the string, a, is "" then return NIL otherwise create
                    and return a dynamic string.
*/

static DynamicStrings_String collapseString (const char *a_, unsigned int _a_high);

/*
   doExpressionTypeCompatible -
*/

static bool doExpressionTypeCompatible (unsigned int token, const char *format_, unsigned int _format_high, unsigned int left, unsigned int right, bool strict);

/*
   init - initialise all global data structures for this module.
*/

static void init (void);


/*
   dumpIndice -
*/

static void dumpIndice (M2Check_pair ptr)
{
  libc_printf ((const char *) " left (%d), right (%d), status ", 31, ptr->left, ptr->right);
  switch (ptr->pairStatus)
    {
      case M2Check_true:
        libc_printf ((const char *) "true", 4);
        break;

      case M2Check_false:
        libc_printf ((const char *) "false", 5);
        break;

      case M2Check_unknown:
        libc_printf ((const char *) "unknown", 7);
        break;

      case M2Check_visited:
        libc_printf ((const char *) "visited", 7);
        break;

      case M2Check_unused:
        libc_printf ((const char *) "unused", 6);
        break;


      default:
        CaseException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/M2Check.def", 20, 1);
        __builtin_unreachable ();
    }
  libc_printf ((const char *) "\\n", 2);
}


/*
   dumpIndex -
*/

static void dumpIndex (const char *name_, unsigned int _name_high, Indexing_Index index)
{
  char name[_name_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (name, name_, _name_high+1);

  libc_printf ((const char *) "status: %s\\n", 12, const_cast<void*> (static_cast<const void*>(name)));
  Indexing_ForeachIndiceInIndexDo (index, (Indexing_IndexProcedure) {(Indexing_IndexProcedure_t) dumpIndice});
}


/*
   dumptInfo -
*/

static void dumptInfo (M2Check_tInfo t)
{
  libc_printf ((const char *) "actual (%d), formal (%d), left (%d), right (%d), procedure (%d)\\n", 65, t->actual, t->formal, t->left, t->right, t->procedure);
  dumpIndex ((const char *) "visited", 7, t->visited);
  dumpIndex ((const char *) "resolved", 8, t->resolved);
  dumpIndex ((const char *) "unresolved", 10, t->unresolved);
}


/*
   falseReason2 - return false.  It also stores the message as the
                  reason for the false value.
*/

static M2Check_status falseReason2 (const char *message_, unsigned int _message_high, M2Check_tInfo tinfo, unsigned int left, unsigned int right)
{
  char message[_message_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (message, message_, _message_high+1);

  if (tinfo->reasonEnable && (tinfo->reason == NULL))
    {
      tinfo->reason = M2MetaError_MetaString2 (DynamicStrings_InitString ((const char *) message, _message_high), left, right);
    }
  return M2Check_false;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   falseReason1 - return false.  It also stores the message as the
                  reason for the false value.
*/

static M2Check_status falseReason1 (const char *message_, unsigned int _message_high, M2Check_tInfo tinfo, unsigned int operand)
{
  char message[_message_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (message, message_, _message_high+1);

  if (tinfo->reasonEnable && (tinfo->reason == NULL))
    {
      tinfo->reason = M2MetaError_MetaString1 (DynamicStrings_InitString ((const char *) message, _message_high), operand);
    }
  return M2Check_false;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   falseReason0 - return false.  It also stores the message as the
                  reason for the false value.
*/

static M2Check_status falseReason0 (const char *message_, unsigned int _message_high, M2Check_tInfo tinfo)
{
  char message[_message_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (message, message_, _message_high+1);

  if (tinfo->reasonEnable && (tinfo->reason == NULL))
    {
      tinfo->reason = M2MetaError_MetaString0 (DynamicStrings_InitString ((const char *) message, _message_high));
    }
  return M2Check_false;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   isKnown - returns BOOLEAN:TRUE if result is status:true or status:false.
*/

static bool isKnown (M2Check_status result)
{
  return ((result == M2Check_true) || (result == M2Check_false)) || (result == M2Check_visited);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   isFalse - returns BOOLEAN:TRUE if result is status:false
*/

static bool isFalse (M2Check_status result)
{
  return result == M2Check_false;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   checkTypeEquivalence - returns TRUE if left and right can be skipped and found to be equal.
*/

static M2Check_status checkTypeEquivalence (M2Check_status result, M2Check_tInfo tinfo, unsigned int left, unsigned int right)
{
  if (left == right)
    {
      return M2Check_true;
    }
  else if ((SymbolTable_IsType (left)) && (SymbolTable_IsType (right)))
    {
      /* avoid dangling else.  */
      if ((SymbolTable_IsHiddenType (left)) && (SymbolTable_IsHiddenType (right)))
        {
          return falseReason2 ((const char *) "opaque types {%1a} {%2a} differ", 31, tinfo, left, right);
        }
      else if (((SymbolTable_IsHiddenType (left)) && (right == M2System_Address)) || ((SymbolTable_IsHiddenType (right)) && (left == M2System_Address)))
        {
          /* avoid dangling else.  */
          return M2Check_true;
        }
    }
  else if (IsTypeEquivalence (left))
    {
      /* avoid dangling else.  */
      return checkPair (result, tinfo, SymbolTable_GetDType (left), right);
    }
  else if (IsTypeEquivalence (right))
    {
      /* avoid dangling else.  */
      return checkPair (result, tinfo, left, SymbolTable_GetDType (right));
    }
  return result;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   checkSubrange - check to see if subrange types left and right have the same limits.
*/

static M2Check_status checkSubrange (M2Check_status result, M2Check_tInfo tinfo, unsigned int left, unsigned int right)
{
  unsigned int lLow;
  unsigned int rLow;
  unsigned int lHigh;
  unsigned int rHigh;

  /* firstly check to see if we already have resolved this as false.  */
  if (isFalse (result))
    {
      return result;
    }
  else
    {
      M2Debug_Assert (SymbolTable_IsSubrange (left));
      M2Debug_Assert (SymbolTable_IsSubrange (right));
      lLow = M2GCCDeclare_GetTypeMin (left);
      lHigh = M2GCCDeclare_GetTypeMax (left);
      rLow = M2GCCDeclare_GetTypeMin (right);
      rHigh = M2GCCDeclare_GetTypeMax (right);
      M2ALU_PushIntegerTree (SymbolConversion_Mod2Gcc (lLow));
      M2ALU_PushIntegerTree (SymbolConversion_Mod2Gcc (rLow));
      if (! (M2ALU_Equ (tinfo->token)))
        {
          return falseReason2 ((const char *) "low values of the subrange types {%1a} {%2a} differ", 51, tinfo, left, right);
        }
      M2ALU_PushIntegerTree (SymbolConversion_Mod2Gcc (lHigh));
      M2ALU_PushIntegerTree (SymbolConversion_Mod2Gcc (rHigh));
      if (! (M2ALU_Equ (tinfo->token)))
        {
          return falseReason2 ((const char *) "high values of the subrange types {%1a} {%2a} differ", 52, tinfo, left, right);
        }
    }
  return M2Check_true;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   checkUnboundedArray - returns status if unbounded is parameter compatible with array.
                         It checks all type equivalences of the static array for a
                         match with the dynamic (unbounded) array.
*/

static M2Check_status checkUnboundedArray (M2Check_status result, M2Check_tInfo tinfo, unsigned int unbounded, unsigned int array)
{
  unsigned int dim;
  unsigned int ubtype;
  unsigned int type;

  /* Firstly check to see if we have resolved this as false.  */
  if (isFalse (result))
    {
      return result;
    }
  else
    {
      M2Debug_Assert (SymbolTable_IsUnbounded (unbounded));
      M2Debug_Assert (SymbolTable_IsArray (array));
      dim = SymbolTable_GetDimension (unbounded);
      ubtype = SymbolTable_GetDType (unbounded);
      type = array;
      do {
        type = SymbolTable_GetDType (type);
        dim -= 1;
        /* Check type equivalences.  */
        if ((checkTypeEquivalence (result, tinfo, type, ubtype)) == M2Check_true)
          {
            return M2Check_true;
          }
        type = SymbolTable_SkipType (type);
        /* If we have run out of dimensions we conclude false.  */
        if (dim == 0)
          {
            return falseReason0 ((const char *) "unbounded array has less dimensions than the array", 50, tinfo);
          }
      } while (! (! (SymbolTable_IsArray (type))));
    }
  return falseReason0 ((const char *) "array has less dimensions than the unbounded array", 50, tinfo);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   checkUnboundedUnbounded - check to see if formal and actual are compatible.
                             Both are unbounded parameters.
*/

static M2Check_status checkUnboundedUnbounded (M2Check_status result, M2Check_tInfo tinfo, unsigned int formal, unsigned int actual)
{
  /* Firstly check to see if we have resolved this as false.  */
  if (isFalse (result))
    {
      return result;
    }
  else
    {
      M2Debug_Assert (SymbolTable_IsUnbounded (formal));
      M2Debug_Assert (SymbolTable_IsUnbounded (actual));
      /* The actual parameter above might be a different symbol to the actual parameter
         symbol in the tinfo.  So we must compare the original actual parameter against
         the formal.
         The actual above maybe a temporary which is created after derefencing an array.
         For example 'bar[10]' where bar is defined as ARRAY OF ARRAY OF CARDINAL.
         The GetDimension for 'bar[10]' is 1 indicating that one dimension has been
         referenced.  We use GetDimension for 'bar' which is 2.  */
      if ((SymbolTable_GetDimension (formal)) != (SymbolTable_GetDimension (tinfo->actual)))
        {
          return falseReason2 ((const char *) "the formal parameter unbounded array {%1a} has a different number''  of dimensions to the actual parameter unbounded array {%2a}", 128, tinfo, formal, actual);
        }
      if ((checkTypeEquivalence (result, tinfo, SymbolTable_GetType (formal), SymbolTable_GetType (actual))) == M2Check_true)
        {
          return M2Check_true;
        }
    }
  return falseReason2 ((const char *) "the formal unbounded array type {%1a}'' and the actual unbounded array type {%2a} differ", 88, tinfo, formal, actual);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   checkUnbounded - check to see if the unbounded is type compatible with right.
                    This is only allowed during parameter passing.
*/

static M2Check_status checkUnbounded (M2Check_status result, M2Check_tInfo tinfo, unsigned int unbounded, unsigned int right)
{
  /* Firstly check to see if we have resolved this as false.  */
  if (isFalse (result))
    {
      return result;
    }
  else
    {
      M2Debug_Assert (SymbolTable_IsUnbounded (unbounded));
      if (tinfo->kind == M2Check_parameter)
        {
          /* avoid gcc warning by using compound statement even if not strictly necessary.  */
          /* Check the unbounded data type against the type of right, SYSTEM types
            are compared by the caller, so no need to test for them again.  */
          if (isSkipEquivalence (SymbolTable_GetType (unbounded), right))
            {
              return M2Check_true;
            }
          else if (SymbolTable_IsType (right))
            {
              /* avoid dangling else.  */
              if ((SymbolTable_GetType (right)) == SymbolTable_NulSym)
                {
                  /* Base type check.  */
                  return checkPair (result, tinfo, SymbolTable_GetType (unbounded), right);
                }
              else
                {
                  /* It is safe to GetType (right) and we check the pair
                  [unbounded, GetType (right)].  */
                  return checkPair (result, tinfo, unbounded, SymbolTable_GetType (right));
                }
            }
          else if (SymbolTable_IsArray (right))
            {
              /* avoid dangling else.  */
              return checkUnboundedArray (result, tinfo, unbounded, right);
            }
          else if (SymbolTable_IsUnbounded (right))
            {
              /* avoid dangling else.  */
              return checkUnboundedUnbounded (result, tinfo, unbounded, right);
            }
          else
            {
              /* avoid dangling else.  */
              return falseReason2 ((const char *) "the formal unbounded array type {%1a}'' and the actual unbounded array type {%2a} differ", 88, tinfo, unbounded, right);
            }
        }
    }
  return M2Check_false;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   checkArrayTypeEquivalence - check array and unbounded array type equivalence.
*/

static M2Check_status checkArrayTypeEquivalence (M2Check_status result, M2Check_tInfo tinfo, unsigned int left, unsigned int right)
{
  unsigned int lSub;
  unsigned int rSub;

  if (isFalse (result))
    {
      return result;
    }
  else if ((SymbolTable_IsArray (left)) && (SymbolTable_IsArray (right)))
    {
      /* avoid dangling else.  */
      lSub = SymbolTable_GetArraySubscript (left);
      rSub = SymbolTable_GetArraySubscript (right);
      result = checkPair (result, tinfo, SymbolTable_GetDType (left), SymbolTable_GetDType (right));
      if ((lSub != SymbolTable_NulSym) && (rSub != SymbolTable_NulSym))
        {
          result = checkSubrange (result, tinfo, getSType (lSub), getSType (rSub));
        }
    }
  else if ((SymbolTable_IsUnbounded (left)) && ((SymbolTable_IsArray (right)) || (SymbolTable_IsUnbounded (right))))
    {
      /* avoid dangling else.  */
      if ((M2System_IsGenericSystemType (getSType (left))) || (M2System_IsGenericSystemType (getSType (right))))
        {
          return M2Check_true;
        }
      else
        {
          result = checkUnbounded (result, tinfo, left, right);
        }
    }
  else if ((SymbolTable_IsUnbounded (right)) && ((SymbolTable_IsArray (left)) || (SymbolTable_IsUnbounded (left))))
    {
      /* avoid dangling else.  */
      if ((M2System_IsGenericSystemType (getSType (right))) || (M2System_IsGenericSystemType (getSType (left))))
        {
          return M2Check_true;
        }
      else
        {
          result = checkUnbounded (result, tinfo, right, left);
        }
    }
  else if ((SymbolTable_IsArray (left)) && (SymbolTable_IsConst (right)))
    {
      /* avoid dangling else.  */
      result = checkPair (result, tinfo, SymbolTable_GetDType (left), SymbolTable_GetDType (right));
    }
  else if ((SymbolTable_IsArray (right)) && (SymbolTable_IsConst (left)))
    {
      /* avoid dangling else.  */
      result = checkPair (result, tinfo, SymbolTable_GetDType (left), SymbolTable_GetDType (right));
    }
  return result;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   checkCharStringTypeEquivalence - check char and string constants for type equivalence.
*/

static M2Check_status checkCharStringTypeEquivalence (M2Check_status result, M2Check_tInfo tinfo, unsigned int left, unsigned int right)
{
  if (isFalse (result))
    {
      return result;
    }
  else if (left == M2Base_Char)
    {
      /* avoid dangling else.  */
      if (SymbolTable_IsConst (right))
        {
          /* We might not know the length of the string yet, in which case we return true.  */
          if ((SymbolTable_IsConstString (right)) && ((! (SymbolConversion_GccKnowsAbout (right))) || ((SymbolTable_GetStringLength (tinfo->token, right)) <= 1)))
            {
              return M2Check_true;
            }
          else
            {
              return falseReason2 ((const char *) "the string {%2a} does not fit into a {%1a}", 42, tinfo, left, right);
            }
        }
      else if (SymbolTable_IsParameter (right))
        {
          /* avoid dangling else.  */
          right = SymbolTable_GetDType (right);
          if ((right == M2Base_Char) || ((SymbolTable_IsUnbounded (right)) && ((SymbolTable_SkipType (SymbolTable_GetDType (right))) == M2Base_Char)))
            {
              return M2Check_true;
            }
        }
      else if (SymbolTable_IsArray (right))
        {
          /* avoid dangling else.  */
          if (M2Base_Char == (SymbolTable_SkipType (SymbolTable_GetDType (right))))
            {
              return M2Check_true;
            }
        }
    }
  else if (right == M2Base_Char)
    {
      /* avoid dangling else.  */
      return checkCharStringTypeEquivalence (result, tinfo, right, left);
    }
  return result;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   firstTime - returns TRUE if the triple (token, left, right) has not been seen before.
*/

static bool firstTime (unsigned int token, unsigned int left, unsigned int right)
{
  M2Check_errorSig p;
  unsigned int i;
  unsigned int n;

  i = 1;
  n = Indexing_HighIndice (errors);
  while (i <= n)
    {
      p = static_cast<M2Check_errorSig> (Indexing_GetIndice (errors, i));
      if (((p->token == token) && (p->left == left)) && (p->right == right))
        {
          return false;
        }
      i += 1;
    }
  Storage_ALLOCATE ((void **) &p, sizeof (M2Check__T1));
  p->token = token;
  p->left = left;
  p->right = right;
  Indexing_IncludeIndiceIntoIndex (errors, reinterpret_cast <void *> (p));
  return true;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   buildError4 - generate a MetaString4 error.  This is only used when checking
                 parameter compatibility.
*/

static void buildError4 (M2Check_tInfo tinfo, unsigned int left, unsigned int right)
{
  DynamicStrings_String s;

  if (firstTime (tinfo->token, left, right))
    {
      if (tinfo->error == NULL)
        {
          /* We need to create top level error message first.  */
          tinfo->error = M2Error_NewError (tinfo->token);
          /* The parameters to MetaString4 in buildError4 must match the order
            of paramters passed to ParameterTypeCompatible.  */
          s = M2MetaError_MetaString4 (tinfo->format, tinfo->procedure, tinfo->formal, tinfo->actual, tinfo->nth);
          /* Append the overall reason for the failure.  */
          if (tinfo->reason != NULL)
            {
              /* The string tinfo^.reason is given to the error handler.  */
              s = DynamicStrings_ConCat (s, DynamicStrings_Mark (DynamicStrings_InitString ((const char *) " because ", 9)));
              s = DynamicStrings_ConCat (s, tinfo->reason);
              tinfo->reason = static_cast<DynamicStrings_String> (NULL);  /* Hand over deconstructing to M2MetaError.  */
            }
          M2Error_ErrorString (tinfo->error, s);
        }
      /* And now also generate a sub error containing detail.  */
      if ((left != tinfo->left) || (right != tinfo->right))
        {
          M2MetaError_MetaError1 ((const char *) "formal parameter {%1EDad}", 25, right);
          M2MetaError_MetaError1 ((const char *) "actual parameter {%1EDad}", 25, left);
        }
    }
}


/*
   buildError2 - generate a MetaString2 error.
*/

static void buildError2 (M2Check_tInfo tinfo, unsigned int left, unsigned int right)
{
  DynamicStrings_String s;

  if (firstTime (tinfo->token, left, right))
    {
      if (tinfo->error == NULL)
        {
          /* Need to create top level error message first.  */
          tinfo->error = M2Error_NewError (tinfo->token);
          s = M2MetaError_MetaString2 (tinfo->format, tinfo->left, tinfo->right);
          M2Error_ErrorString (tinfo->error, s);
        }
      /* Also generate a sub error containing detail.  */
      if ((left != tinfo->left) || (right != tinfo->right))
        {
          tinfo->error = M2Error_ChainError (tinfo->token, tinfo->error);
          switch (tinfo->kind)
            {
              case M2Check_parameter:
                s = M2MetaError_MetaString2 (DynamicStrings_InitString ((const char *) "{%1Ead} and {%2ad} are incompatible as formal and actual procedure parameters", 77), left, right);
                break;

              case M2Check_assignment:
                s = M2MetaError_MetaString2 (DynamicStrings_InitString ((const char *) "{%1Ead} and {%2ad} are assignment incompatible", 46), left, right);
                break;

              case M2Check_expression:
                s = M2MetaError_MetaString2 (DynamicStrings_InitString ((const char *) "{%1Ead} and {%2ad} are expression incompatible", 46), left, right);
                break;


              default:
                CaseException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/M2Check.def", 20, 1);
                __builtin_unreachable ();
            }
          /* Lastly the overall reason for the failure.  */
          if (tinfo->reason != NULL)
            {
              /* The string tinfo^.reason is given to the error handler.  */
              s = DynamicStrings_ConCat (s, DynamicStrings_Mark (DynamicStrings_InitString ((const char *) " because ", 9)));
              s = DynamicStrings_ConCat (s, tinfo->reason);
              tinfo->reason = static_cast<DynamicStrings_String> (NULL);  /* Hand over deconstructing to M2MetaError.  */
            }
          M2Error_ErrorString (tinfo->error, s);
        }
    }
}


/*
   issueError -
*/

static M2Check_status issueError (bool result, M2Check_tInfo tinfo, unsigned int left, unsigned int right)
{
  if (result)
    {
      return M2Check_true;
    }
  else
    {
      /* Check whether errors are required.  */
      if (tinfo->format != NULL)
        {
          switch (tinfo->kind)
            {
              case M2Check_parameter:
                buildError4 (tinfo, left, right);
                break;

              case M2Check_assignment:
                buildError2 (tinfo, left, right);
                break;

              case M2Check_expression:
                buildError2 (tinfo, left, right);
                break;


              default:
                CaseException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/M2Check.def", 20, 1);
                __builtin_unreachable ();
            }
          tinfo->format = static_cast<DynamicStrings_String> (NULL);  /* string is used by MetaError now.  */
        }
      return M2Check_false;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   checkBaseEquivalence - the catch all check for types not specifically
                          handled by this module.
*/

static M2Check_status checkBaseEquivalence (M2Check_status result, M2Check_tInfo tinfo, unsigned int left, unsigned int right)
{
  if (isKnown (result))
    {
      return result;
    }
  else
    {
      switch (tinfo->kind)
        {
          case M2Check_parameter:
            if (tinfo->isvar)
              {
                return issueError (M2Base_IsExpressionCompatible (left, right), tinfo, left, right);
              }
            else
              {
                return issueError (M2Base_IsAssignmentCompatible (left, right), tinfo, left, right);
              }
            break;

          case M2Check_assignment:
            return issueError (M2Base_IsAssignmentCompatible (left, right), tinfo, left, right);
            break;

          case M2Check_expression:
            if (tinfo->isin)
              {
                if ((SymbolTable_IsVar (right)) || (SymbolTable_IsConst (right)))
                  {
                    right = getSType (right);
                  }
              }
            if (tinfo->strict)
              {
                return issueError (M2Base_IsComparisonCompatible (left, right), tinfo, left, right);
              }
            else
              {
                return issueError (M2Base_IsExpressionCompatible (left, right), tinfo, left, right);
              }
            break;


          default:
            M2Error_InternalError ((const char *) "unexpected kind value", 21);
            break;
        }
    }
  /* should never reach here.  */
  ReturnException ("/build/gcc/src/gcc/gcc/m2/gm2-compiler/M2Check.def", 20, 1);
  __builtin_unreachable ();
}


/*
   checkPair - check whether left and right are type compatible.
               It will update the visited, unresolved list before
               calling the docheckPair for the cascaded type checking.
               Pre-condition: tinfo is initialized.
                              left and right are modula2 symbols.
               Post-condition: tinfo visited, resolved, unresolved lists
                               are updated and the result status is
                               returned.
*/

static M2Check_status checkPair (M2Check_status result, M2Check_tInfo tinfo, unsigned int left, unsigned int right)
{
  if (isFalse (result))
    {
      exclude (tinfo->visited, left, right);
      return result;
    }
  else
    {
      if (in (tinfo->resolved, left, right))
        {
          exclude (tinfo->visited, left, right);
          return getStatus (tinfo->resolved, left, right);
        }
      else if (in (tinfo->visited, left, right))
        {
          /* avoid dangling else.  */
          return M2Check_visited;
        }
      else
        {
          /* avoid dangling else.  */
          if (debugging)
            {
              libc_printf ((const char *) "   marked as visited (%d, %d)\\n", 31, left, right);
            }
          include (tinfo->visited, left, right, M2Check_unknown);
          include (tinfo->unresolved, left, right, M2Check_unknown);
        }
      return doCheckPair (result, tinfo, left, right);
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   useBaseCheck -
*/

static bool useBaseCheck (unsigned int sym)
{
  return (((M2Base_IsBaseType (sym)) || (M2System_IsSystemType (sym))) || (M2Base_IsMathType (sym))) || (M2Base_IsComplexType (sym));
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   checkBaseTypeEquivalence -
*/

static M2Check_status checkBaseTypeEquivalence (M2Check_status result, M2Check_tInfo tinfo, unsigned int left, unsigned int right)
{
  if (isFalse (result))
    {
      return result;
    }
  else if ((useBaseCheck (left)) && (useBaseCheck (right)))
    {
      /* avoid dangling else.  */
      return checkBaseEquivalence (result, tinfo, left, right);
    }
  else
    {
      /* avoid dangling else.  */
      return result;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsTyped - returns TRUE if sym will have a type.
*/

static bool IsTyped (unsigned int sym)
{
  return (((((SymbolTable_IsVar (sym)) || (SymbolTable_IsParameter (sym))) || (SymbolTable_IsConstructor (sym))) || ((SymbolTable_IsConst (sym)) && (SymbolTable_IsConstructor (sym)))) || (SymbolTable_IsParameter (sym))) || ((SymbolTable_IsConst (sym)) && ((SymbolTable_GetDType (sym)) != SymbolTable_NulSym));
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsTypeEquivalence - returns TRUE if sym is a type equivalence symbol.
*/

static bool IsTypeEquivalence (unsigned int sym)
{
  return ((SymbolTable_IsType (sym)) && ((SymbolTable_GetDType (sym)) != SymbolTable_NulSym)) && ((SymbolTable_GetDType (sym)) != sym);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   isLValue -
*/

static bool isLValue (unsigned int sym)
{
  return (SymbolTable_IsVar (sym)) && ((SymbolTable_GetMode (sym)) == SymbolTable_LeftValue);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   checkVarTypeEquivalence -
*/

static M2Check_status checkVarTypeEquivalence (M2Check_status result, M2Check_tInfo tinfo, unsigned int left, unsigned int right)
{
  if (isFalse (result))
    {
      return result;
    }
  else if ((left == SymbolTable_NulSym) || (right == SymbolTable_NulSym))
    {
      /* avoid dangling else.  */
      return M2Check_true;
    }
  else
    {
      /* avoid dangling else.  */
      if ((SymbolTable_IsVar (left)) || (SymbolTable_IsVar (right)))
        {
          /* Either left or right will change, so we can call doCheckPair.  */
          if (SymbolTable_IsVar (left))
            {
              left = getType (left);
            }
          if (SymbolTable_IsVar (right))
            {
              right = getType (right);
            }
          return doCheckPair (result, tinfo, left, right);
        }
    }
  return result;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   checkVarEquivalence - this test must be done early as it checks the symbol mode.
                         An LValue is treated as a pointer during assignment and the
                         LValue is attached to a variable.  This function skips the variable
                         and checks the types - after it has considered a possible LValue.
*/

static M2Check_status checkVarEquivalence (M2Check_status result, M2Check_tInfo tinfo, unsigned int des, unsigned int expr)
{
  if (isFalse (result))
    {
      return result;
    }
  else if ((IsTyped (des)) || (IsTyped (expr)))
    {
      /* avoid dangling else.  */
      if (tinfo->kind == M2Check_assignment)
        {
          /* avoid gcc warning by using compound statement even if not strictly necessary.  */
          if ((SymbolTable_GetDType (des)) == (SymbolTable_GetDType (expr)))
            {
              /* LValues are only relevant during assignment.  */
              return M2Check_true;
            }
          else if ((isLValue (des)) && (! (isLValue (expr))))
            {
              /* avoid dangling else.  */
              if ((SymbolTable_SkipType (getType (expr))) == M2System_Address)
                {
                  return M2Check_true;
                }
              else if (SymbolTable_IsPointer (SymbolTable_SkipType (getType (expr))))
                {
                  /* avoid dangling else.  */
                  expr = SymbolTable_GetDType (SymbolTable_SkipType (getType (expr)));
                  return doCheckPair (result, tinfo, getType (des), expr);
                }
            }
          else if ((isLValue (expr)) && (! (isLValue (des))))
            {
              /* avoid dangling else.  */
              if ((SymbolTable_SkipType (getType (des))) == M2System_Address)
                {
                  return M2Check_true;
                }
              else if (SymbolTable_IsPointer (SymbolTable_SkipType (getType (des))))
                {
                  /* avoid dangling else.  */
                  des = SymbolTable_GetDType (SymbolTable_SkipType (getType (des)));
                  return doCheckPair (result, tinfo, des, getType (expr));
                }
            }
        }
      return doCheckPair (result, tinfo, getType (des), getType (expr));
    }
  return result;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   checkConstMeta - performs a very course grained check against
                    obviously incompatible type kinds.
                    If left is a const string then it checks right against char.
*/

static M2Check_status checkConstMeta (M2Check_status result, M2Check_tInfo tinfo, unsigned int left, unsigned int right)
{
  unsigned int typeLeft;
  unsigned int typeRight;

  M2Debug_Assert (SymbolTable_IsConst (left));
  if (isFalse (result))
    {
      return result;
    }
  else if (SymbolTable_IsConstString (left))
    {
      /* avoid dangling else.  */
      if (SymbolTable_IsConstString (right))
        {
          return M2Check_true;
        }
      else if (IsTyped (right))
        {
          /* avoid dangling else.  */
          typeRight = SymbolTable_GetDType (right);
          if (typeRight == SymbolTable_NulSym)
            {
              return result;
            }
          else if (((((SymbolTable_IsSet (typeRight)) || (SymbolTable_IsEnumeration (typeRight))) || (SymbolTable_IsProcedure (typeRight))) || (SymbolTable_IsRecord (typeRight))) || (SymbolTable_IsReallyPointer (typeRight)))
            {
              /* avoid dangling else.  */
              return falseReason1 ((const char *) "constant string is incompatible with {%1ad}", 43, tinfo, typeRight);
            }
          else if (SymbolTable_IsArray (typeRight))
            {
              /* avoid dangling else.  */
              return doCheckPair (result, tinfo, M2Base_Char, SymbolTable_GetDType (typeRight));
            }
          else if (! (SymbolConversion_GccKnowsAbout (left)))
            {
              /* avoid dangling else.  */
              /* We do not know the length of this string, so assume true.  */
              return M2Check_true;
            }
          else if ((SymbolTable_GetStringLength (tinfo->token, left)) == 1)
            {
              /* avoid dangling else.  */
              return doCheckPair (result, tinfo, M2Base_Char, typeRight);
            }
        }
    }
  else if ((IsTyped (left)) && (IsTyped (right)))
    {
      /* avoid dangling else.  */
      typeRight = SymbolTable_GetDType (right);
      typeLeft = SymbolTable_GetDType (left);
      if ((IsZRCType (typeLeft)) && (SymbolTable_IsUnbounded (typeRight)))
        {
          return falseReason2 ((const char *) "the constant {%1a} is incompatible'' with an unbounded array of {%2a}", 69, tinfo, typeLeft, typeRight);
        }
      else
        {
          return doCheckPair (result, tinfo, typeLeft, typeRight);
        }
    }
  return result;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   checkEnumField -
*/

static M2Check_status checkEnumField (M2Check_status result, M2Check_tInfo tinfo, unsigned int left, unsigned int right)
{
  unsigned int typeRight;

  M2Debug_Assert (SymbolTable_IsFieldEnumeration (left));
  if (isFalse (result))
    {
      return result;
    }
  else if (IsTyped (right))
    {
      /* avoid dangling else.  */
      typeRight = SymbolTable_GetDType (right);
      if (typeRight == SymbolTable_NulSym)
        {
          return result;
        }
      else
        {
          return doCheckPair (result, tinfo, SymbolTable_GetDType (left), typeRight);
        }
    }
  return result;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   checkEnumFieldEquivalence -
*/

static M2Check_status checkEnumFieldEquivalence (M2Check_status result, M2Check_tInfo tinfo, unsigned int left, unsigned int right)
{
  if (isFalse (result))
    {
      return result;
    }
  else if ((left == SymbolTable_NulSym) || (right == SymbolTable_NulSym))
    {
      /* avoid dangling else.  */
      /* No option but to return true.  */
      return M2Check_true;
    }
  else if (SymbolTable_IsFieldEnumeration (left))
    {
      /* avoid dangling else.  */
      return checkEnumField (result, tinfo, left, right);
    }
  else if (SymbolTable_IsFieldEnumeration (right))
    {
      /* avoid dangling else.  */
      return checkEnumField (result, tinfo, right, left);
    }
  return result;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   checkConstEquivalence - this check can be done first as it checks symbols which
                           may have no type.  Ie constant strings.  These constants
                           will likely have their type set during quadruple folding.
                           But we can check the meta type for obvious mismatches
                           early on.  For example adding a string to an enum or set.
*/

static M2Check_status checkConstEquivalence (M2Check_status result, M2Check_tInfo tinfo, unsigned int left, unsigned int right)
{
  if (isFalse (result))
    {
      return result;
    }
  else if ((left == SymbolTable_NulSym) || (right == SymbolTable_NulSym))
    {
      /* avoid dangling else.  */
      /* No option but to return true.  */
      return M2Check_true;
    }
  else if (SymbolTable_IsConst (left))
    {
      /* avoid dangling else.  */
      return checkConstMeta (result, tinfo, left, right);
    }
  else if (SymbolTable_IsConst (right))
    {
      /* avoid dangling else.  */
      return checkConstMeta (result, tinfo, right, left);
    }
  return result;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   checkSubrangeTypeEquivalence -
*/

static M2Check_status checkSubrangeTypeEquivalence (M2Check_status result, M2Check_tInfo tinfo, unsigned int left, unsigned int right)
{
  if (isFalse (result))
    {
      return result;
    }
  else
    {
      if (SymbolTable_IsSubrange (left))
        {
          return doCheckPair (result, tinfo, SymbolTable_GetDType (left), right);
        }
      if (SymbolTable_IsSubrange (right))
        {
          return doCheckPair (result, tinfo, left, SymbolTable_GetDType (right));
        }
    }
  return result;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsZRCType - return TRUE if type is a ZType, RType or a CType.
*/

static bool IsZRCType (unsigned int type)
{
  return ((type == M2Base_CType) || (type == M2Base_ZType)) || (type == M2Base_RType);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   isZRC - return TRUE if zrc is a ZType, RType or a CType
           and sym is either a complex type when zrc = CType
           or is not a composite type when zrc is a RType or ZType.
*/

static bool isZRC (unsigned int zrc, unsigned int sym)
{
  if (SymbolTable_IsConst (sym))
    {
      sym = SymbolTable_SkipType (SymbolTable_GetDType (sym));
    }
  if ((zrc == M2Base_CType) && ((M2System_IsComplexN (sym)) || (M2Base_IsComplexType (sym))))
    {
      return true;
    }
  return (zrc == sym) || ((zrc == M2Base_ZType) || ((zrc == M2Base_RType) && (! (SymbolTable_IsComposite (sym)))));
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   isSameSizeConst -

*/

static bool isSameSizeConst (unsigned int a, unsigned int b)
{
  if (SymbolTable_IsConst (a))
    {
      a = SymbolTable_SkipType (SymbolTable_GetDType (a));
      return ((isZRC (a, b)) || (a == b)) || ((a != SymbolTable_NulSym) && (isSameSize (a, b)));
    }
  else if (SymbolTable_IsConst (b))
    {
      /* avoid dangling else.  */
      b = SymbolTable_SkipType (SymbolTable_GetDType (b));
      return ((isZRC (b, a)) || (a == b)) || ((b != SymbolTable_NulSym) && (isSameSize (a, b)));
    }
  return false;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   isSameSize - should only be called if either a or b are WORD, BYTE, etc.
*/

static bool isSameSize (unsigned int a, unsigned int b)
{
  return (isSameSizeConst (a, b)) || (M2System_IsSameSize (a, b));
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   checkSystemEquivalence - check whether left and right are system types and whether they have the same size.
*/

static M2Check_status checkSystemEquivalence (M2Check_status result, M2Check_tInfo tinfo __attribute__((unused)), unsigned int left, unsigned int right)
{
  if ((isFalse (result)) || (result == M2Check_visited))
    {
      return result;
    }
  else
    {
      if (((((M2System_IsGenericSystemType (left)) || (M2System_IsGenericSystemType (right))) && (SymbolConversion_GccKnowsAbout (left))) && (SymbolConversion_GccKnowsAbout (right))) && (isSameSize (left, right)))
        {
          return M2Check_true;
        }
    }
  return result;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   checkTypeKindViolation - returns false if one operand left or right is
                            a set, record or array.
*/

static M2Check_status checkTypeKindViolation (M2Check_status result, M2Check_tInfo tinfo, unsigned int left, unsigned int right)
{
  if ((isFalse (result)) || (result == M2Check_visited))
    {
      return result;
    }
  else
    {
      /* We have checked IsSet (left) and IsSet (right) etc in doCheckPair.  */
      if ((((SymbolTable_IsSet (left)) || (SymbolTable_IsSet (right))) || ((SymbolTable_IsRecord (left)) || (SymbolTable_IsRecord (right)))) || ((SymbolTable_IsArray (left)) || (SymbolTable_IsArray (right))))
        {
          return falseReason2 ((const char *) "a {%1ad} is incompatible with a {%2ad}", 38, tinfo, left, right);
        }
    }
  return result;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   doCheckPair - invoke a series of type checks checking compatibility
                 between left and right modula2 symbols.
                 Pre-condition: left and right are modula-2 symbols.
                                tinfo is configured.
                 Post-condition: status is returned determining the
                                 correctness of the type check.
                                 The tinfo resolved, unresolved, visited
                                 lists will be updated.
*/

static M2Check_status doCheckPair (M2Check_status result, M2Check_tInfo tinfo, unsigned int left, unsigned int right)
{
  unsigned int i;

  if ((left == SymbolTable_NulSym) || (right == SymbolTable_NulSym))
    {
      /* We cannot check NulSym.  */
      return M2Check_true;
    }
  else if (isKnown (result))
    {
      /* avoid dangling else.  */
      return return_ (result, tinfo, left, right);
    }
  else if (left == right)
    {
      /* avoid dangling else.  */
      return return_ (M2Check_true, tinfo, left, right);
    }
  else
    {
      /* avoid dangling else.  */
      i = 1;
      while (i <= HighEquivalence)
        {
          result = (*Equivalence.array[i-1].proc) (result, tinfo, left, right);
          if (isKnown (result))
            {
              return return_ (result, tinfo, left, right);
            }
          i += 1;
        }
    }
  return return_ (result, tinfo, left, right);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   InitEquivalenceArray - populate the Equivalence array with the
                          checking procedures.
*/

static void InitEquivalenceArray (void)
{
  HighEquivalence = 0;
  addEquivalence ((M2Check_EquivalenceProcedure) {(M2Check_EquivalenceProcedure_t) checkVarEquivalence});
  addEquivalence ((M2Check_EquivalenceProcedure) {(M2Check_EquivalenceProcedure_t) checkVarTypeEquivalence});
  addEquivalence ((M2Check_EquivalenceProcedure) {(M2Check_EquivalenceProcedure_t) checkCharStringTypeEquivalence});
  addEquivalence ((M2Check_EquivalenceProcedure) {(M2Check_EquivalenceProcedure_t) checkConstEquivalence});
  addEquivalence ((M2Check_EquivalenceProcedure) {(M2Check_EquivalenceProcedure_t) checkEnumFieldEquivalence});
  addEquivalence ((M2Check_EquivalenceProcedure) {(M2Check_EquivalenceProcedure_t) checkSystemEquivalence});
  addEquivalence ((M2Check_EquivalenceProcedure) {(M2Check_EquivalenceProcedure_t) checkSubrangeTypeEquivalence});
  addEquivalence ((M2Check_EquivalenceProcedure) {(M2Check_EquivalenceProcedure_t) checkBaseTypeEquivalence});
  addEquivalence ((M2Check_EquivalenceProcedure) {(M2Check_EquivalenceProcedure_t) checkTypeEquivalence});
  addEquivalence ((M2Check_EquivalenceProcedure) {(M2Check_EquivalenceProcedure_t) checkArrayTypeEquivalence});
  addEquivalence ((M2Check_EquivalenceProcedure) {(M2Check_EquivalenceProcedure_t) checkTypeKindEquivalence});
  addEquivalence ((M2Check_EquivalenceProcedure) {(M2Check_EquivalenceProcedure_t) checkTypeKindViolation});
}


/*
   addEquivalence - places proc into Equivalence array.
*/

static void addEquivalence (M2Check_EquivalenceProcedure proc)
{
  HighEquivalence += 1;
  if (HighEquivalence <= MaxEquvalence)
    {
      Equivalence.array[HighEquivalence-1] = proc;
    }
  else
    {
      M2Error_InternalError ((const char *) "increase MaxEquivalence constant in M2Check.mod", 47);
    }
}


/*
   checkProcType -
*/

static M2Check_status checkProcType (M2Check_status result, M2Check_tInfo tinfo, unsigned int left, unsigned int right)
{
  unsigned int i;
  unsigned int n;
  unsigned int lt;
  unsigned int rt;

  M2Debug_Assert (SymbolTable_IsProcType (right));
  M2Debug_Assert (SymbolTable_IsProcType (left));
  if (isFalse (result))
    {
      return result;
    }
  else
    {
      lt = SymbolTable_GetDType (left);
      rt = SymbolTable_GetDType (right);
      if ((lt == SymbolTable_NulSym) && (rt == SymbolTable_NulSym))
        {
          result = M2Check_unknown;
        }
      else if (lt == SymbolTable_NulSym)
        {
          /* avoid dangling else.  */
          if (tinfo->format != NULL)
            {
              M2MetaError_MetaErrorStringT3 (tinfo->token, DynamicStrings_InitString ((const char *) "procedure type {%1a} does not have a {%kRETURN} type whereas procedure type {%2ad} has a {%kRETURN} type {%3ad}", 111), left, right, rt);
            }
          return return_ (M2Check_false, tinfo, left, right);
        }
      else if (rt == SymbolTable_NulSym)
        {
          /* avoid dangling else.  */
          if (tinfo->format != NULL)
            {
              M2MetaError_MetaErrorStringT3 (tinfo->token, DynamicStrings_InitString ((const char *) "procedure type {%1a} does not have a {%kRETURN} type whereas procedure type {%2ad} has a {%kRETURN} type {%3ad}", 111), right, left, lt);
            }
          return return_ (M2Check_false, tinfo, left, right);
        }
      else
        {
          /* avoid dangling else.  */
          /* two return type seen so we check them.  */
          result = checkPair (M2Check_unknown, tinfo, lt, rt);
        }
      if ((SymbolTable_NoOfParamAny (left)) != (SymbolTable_NoOfParamAny (right)))
        {
          if (tinfo->format != NULL)
            {
              M2MetaError_MetaErrorStringT2 (tinfo->token, DynamicStrings_InitString ((const char *) "procedure type {%1a} has a different number of parameters from procedure type {%2ad}", 84), right, left);
            }
          return return_ (M2Check_false, tinfo, left, right);
        }
      i = 1;
      n = SymbolTable_NoOfParamAny (left);
      while (i <= n)
        {
          if ((isFalse (result)) || (result == M2Check_visited))
            {
              /* Seen a mismatch therefore return.  */
              return return_ (result, tinfo, left, right);
            }
          result = M2Check_unknown;  /* Each parameter must match.  */
          if ((SymbolTable_IsVarParamAny (left, i)) != (SymbolTable_IsVarParamAny (right, i)))  /* Each parameter must match.  */
            {
              if (SymbolTable_IsVarParamAny (left, i))
                {
                  /* avoid dangling else.  */
                  if (tinfo->format != NULL)
                    {
                      M2MetaError_MetaErrorStringT3 (tinfo->token, DynamicStrings_InitString ((const char *) "procedure type {%2a} {%3n} parameter was declared as a {%kVAR} whereas procedure type {%1ad} {%3n} parameter was not", 116), right, left, i);
                    }
                }
              else
                {
                  if (tinfo->format != NULL)
                    {
                      M2MetaError_MetaErrorStringT3 (tinfo->token, DynamicStrings_InitString ((const char *) "procedure type {%1a} {%3n} parameter was declared as a {%kVAR} whereas procedure type {%2ad} {%3n} parameter was not", 116), right, left, i);
                    }
                }
              return return_ (M2Check_false, tinfo, left, right);
            }
          result = checkPair (result, tinfo, SymbolTable_GetDType (SymbolTable_GetNthParamAny (left, i)), SymbolTable_GetDType (SymbolTable_GetNthParamAny (right, i)));
          i += 1;
        }
    }
  return return_ (result, tinfo, left, right);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   checkProcedureProcType -
*/

static M2Check_status checkProcedureProcType (M2Check_status result, M2Check_tInfo tinfo, unsigned int left, unsigned int right)
{
  unsigned int i;
  unsigned int n;
  unsigned int lt;
  unsigned int rt;

  M2Debug_Assert (SymbolTable_IsProcedure (right));
  M2Debug_Assert (SymbolTable_IsProcType (left));
  if (! (isFalse (result)))
    {
      lt = SymbolTable_GetDType (left);
      rt = SymbolTable_GetDType (right);
      if ((lt == SymbolTable_NulSym) && (rt == SymbolTable_NulSym))
        {}  /* empty.  */
      else if (lt == SymbolTable_NulSym)
        {
          /* avoid dangling else.  */
          if (tinfo->format != NULL)
            {
              M2MetaError_MetaErrorStringT3 (tinfo->token, DynamicStrings_InitString ((const char *) "procedure type {%1a} does not have a {%kRETURN} type whereas procedure {%2ad} has a {%kRETURN} type {%3ad}", 106), left, right, rt);
            }
          return return_ (M2Check_false, tinfo, left, right);
        }
      else if (rt == SymbolTable_NulSym)
        {
          /* avoid dangling else.  */
          if (tinfo->format != NULL)
            {
              M2MetaError_MetaErrorStringT3 (tinfo->token, DynamicStrings_InitString ((const char *) "procedure {%1a} does not have a {%kRETURN} type whereas procedure type {%2ad} has a {%kRETURN} type {%3ad}", 106), right, left, lt);
            }
          return return_ (M2Check_false, tinfo, left, right);
        }
      else
        {
          /* avoid dangling else.  */
          /* two return type seen so we check them.  */
          result = checkPair (result, tinfo, lt, rt);
        }
      if ((SymbolTable_NoOfParamAny (left)) != (SymbolTable_NoOfParamAny (right)))
        {
          if (tinfo->format != NULL)
            {
              M2MetaError_MetaErrorStringT2 (tinfo->token, DynamicStrings_InitString ((const char *) "procedure {%1a} has a different number of parameters from procedure type {%2ad}", 79), right, left);
            }
          return return_ (M2Check_false, tinfo, left, right);
        }
      i = 1;
      n = SymbolTable_NoOfParamAny (left);
      while (i <= n)
        {
          if ((SymbolTable_IsVarParamAny (left, i)) != (SymbolTable_IsVarParamAny (right, i)))
            {
              if (SymbolTable_IsVarParamAny (left, i))
                {
                  /* avoid dangling else.  */
                  if (tinfo->format != NULL)
                    {
                      M2MetaError_MetaErrorStringT3 (tinfo->token, DynamicStrings_InitString ((const char *) "procedure type {%2a} {%3n} parameter was declared as a {%kVAR} whereas procedure {%1ad} {%3n} parameter was not", 111), right, left, i);
                    }
                }
              else
                {
                  if (tinfo->format != NULL)
                    {
                      M2MetaError_MetaErrorStringT3 (tinfo->token, DynamicStrings_InitString ((const char *) "procedure {%1a} {%3n} parameter was declared as a {%kVAR} whereas procedure type {%2ad} {%3n} parameter was not", 111), right, left, i);
                    }
                }
              return return_ (M2Check_false, tinfo, left, right);
            }
          result = checkPair (result, tinfo, SymbolTable_GetDType (SymbolTable_GetNthParamAny (left, i)), SymbolTable_GetDType (SymbolTable_GetNthParamAny (right, i)));
          i += 1;
        }
    }
  return return_ (result, tinfo, left, right);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   checkProcedure -
*/

static M2Check_status checkProcedure (M2Check_status result, M2Check_tInfo tinfo, unsigned int left, unsigned int right)
{
  M2Debug_Assert (SymbolTable_IsProcedure (right));
  if (isFalse (result))
    {
      return result;
    }
  else if (SymbolTable_IsVar (left))
    {
      /* avoid dangling else.  */
      return checkProcedure (result, tinfo, SymbolTable_GetDType (left), right);
    }
  else if (left == M2System_Address)
    {
      /* avoid dangling else.  */
      return M2Check_true;
    }
  else if (SymbolTable_IsProcType (left))
    {
      /* avoid dangling else.  */
      return checkProcedureProcType (result, tinfo, left, right);
    }
  else
    {
      /* avoid dangling else.  */
      return result;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   checkEnumerationEquivalence -
*/

static M2Check_status checkEnumerationEquivalence (M2Check_status result, unsigned int left, unsigned int right)
{
  if (isFalse (result))
    {
      return result;
    }
  else if (left == right)
    {
      /* avoid dangling else.  */
      return M2Check_true;
    }
  else
    {
      /* avoid dangling else.  */
      return M2Check_false;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   checkPointerType - check whether left and right are equal or are of type ADDRESS.
*/

static M2Check_status checkPointerType (M2Check_status result, unsigned int left, unsigned int right)
{
  if (isFalse (result))
    {
      return result;
    }
  else if (((left == right) || (left == M2System_Address)) || (right == M2System_Address))
    {
      /* avoid dangling else.  */
      return M2Check_true;
    }
  else
    {
      /* avoid dangling else.  */
      return M2Check_false;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   checkProcTypeEquivalence - allow proctype to be compared against another
                              proctype or procedure.  It is legal to be compared
                              against an address.
*/

static M2Check_status checkProcTypeEquivalence (M2Check_status result, M2Check_tInfo tinfo, unsigned int left, unsigned int right)
{
  if (isFalse (result))
    {
      return result;
    }
  else if ((SymbolTable_IsProcedure (left)) && (SymbolTable_IsProcType (right)))
    {
      /* avoid dangling else.  */
      return checkProcedure (result, tinfo, right, left);
    }
  else if ((SymbolTable_IsProcType (left)) && (SymbolTable_IsProcedure (right)))
    {
      /* avoid dangling else.  */
      return checkProcedure (result, tinfo, left, right);
    }
  else if ((SymbolTable_IsProcType (left)) && (SymbolTable_IsProcType (right)))
    {
      /* avoid dangling else.  */
      return checkProcType (result, tinfo, left, right);
    }
  else if ((left == M2System_Address) || (right == M2System_Address))
    {
      /* avoid dangling else.  */
      return M2Check_true;
    }
  else
    {
      /* avoid dangling else.  */
      return M2Check_false;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   checkTypeKindEquivalence -
*/

static M2Check_status checkTypeKindEquivalence (M2Check_status result, M2Check_tInfo tinfo, unsigned int left, unsigned int right)
{
  if (isFalse (result))
    {
      return result;
    }
  else if ((left == SymbolTable_NulSym) || (right == SymbolTable_NulSym))
    {
      /* avoid dangling else.  */
      return M2Check_true;
    }
  else
    {
      /* avoid dangling else.  */
      /* Long cascade of all type kinds.  */
      if ((SymbolTable_IsSet (left)) && (SymbolTable_IsSet (right)))
        {
          return checkSetEquivalent (result, tinfo, left, right);
        }
      else if ((SymbolTable_IsArray (left)) && (SymbolTable_IsArray (right)))
        {
          /* avoid dangling else.  */
          return checkArrayTypeEquivalence (result, tinfo, left, right);
        }
      else if ((SymbolTable_IsRecord (left)) && (SymbolTable_IsRecord (right)))
        {
          /* avoid dangling else.  */
          return checkRecordEquivalence (result, left, right);
        }
      else if ((SymbolTable_IsEnumeration (left)) && (SymbolTable_IsEnumeration (right)))
        {
          /* avoid dangling else.  */
          return checkEnumerationEquivalence (result, left, right);
        }
      else if ((SymbolTable_IsProcType (left)) || (SymbolTable_IsProcType (right)))
        {
          /* avoid dangling else.  */
          return checkProcTypeEquivalence (result, tinfo, right, left);
        }
      else if ((SymbolTable_IsReallyPointer (left)) && (SymbolTable_IsReallyPointer (right)))
        {
          /* avoid dangling else.  */
          return checkPointerType (result, left, right);
        }
      else
        {
          /* avoid dangling else.  */
          return result;
        }
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   isSkipEquivalence -
*/

static bool isSkipEquivalence (unsigned int left, unsigned int right)
{
  return (SymbolTable_SkipType (left)) == (SymbolTable_SkipType (right));
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   checkValueEquivalence - check to see if left and right values are the same.
*/

static M2Check_status checkValueEquivalence (M2Check_status result, unsigned int left, unsigned int right)
{
  if (isKnown (result))
    {
      return result;
    }
  else if (left == right)
    {
      /* avoid dangling else.  */
      return M2Check_true;
    }
  else
    {
      /* avoid dangling else.  */
      if (m2expr_AreConstantsEqual (SymbolConversion_Mod2Gcc (left), SymbolConversion_Mod2Gcc (right)))
        {
          return M2Check_true;
        }
      else
        {
          return M2Check_false;
        }
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   and -
*/

static M2Check_status and_ (M2Check_status left, M2Check_status right)
{
  if ((left == M2Check_true) && (right == M2Check_true))
    {
      return M2Check_true;
    }
  else
    {
      return M2Check_false;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   checkTypeRangeEquivalence -
*/

static M2Check_status checkTypeRangeEquivalence (M2Check_status result, M2Check_tInfo tinfo, unsigned int left, unsigned int right)
{
  M2Check_status result2;
  M2Check_status result3;

  result = checkSkipEquivalence (result, left, right);
  result2 = checkValueEquivalence (result, M2GCCDeclare_GetTypeMin (left), M2GCCDeclare_GetTypeMin (right));
  result3 = checkValueEquivalence (result, M2GCCDeclare_GetTypeMax (left), M2GCCDeclare_GetTypeMax (right));
  return return_ (and_ (result2, result3), tinfo, left, right);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   include - include pair left:right into pairs with status, s.
*/

static void include (Indexing_Index pairs, unsigned int left, unsigned int right, M2Check_status s)
{
  M2Check_pair p;

  p = newPair ();
  p->left = left;
  p->right = right;
  p->pairStatus = s;
  p->next = NULL;
  Indexing_IncludeIndiceIntoIndex (pairs, reinterpret_cast <void *> (p));
}


/*
   exclude - exclude pair left:right from pairs.
*/

static void exclude (Indexing_Index pairs, unsigned int left, unsigned int right)
{
  M2Check_pair p;
  unsigned int i;
  unsigned int n;

  i = 1;
  n = Indexing_HighIndice (pairs);
  while (i <= n)
    {
      p = static_cast<M2Check_pair> (Indexing_GetIndice (pairs, i));
      if (((p != NULL) && (p->left == left)) && (p->right == right))
        {
          Indexing_PutIndice (pairs, i, NULL);
          disposePair (p);
          return;
        }
      i += 1;
    }
}


/*
   getStatus -
*/

static M2Check_status getStatus (Indexing_Index pairs, unsigned int left, unsigned int right)
{
  M2Check_pair p;
  unsigned int i;
  unsigned int n;

  i = 1;
  n = Indexing_HighIndice (pairs);
  while (i <= n)
    {
      p = static_cast<M2Check_pair> (Indexing_GetIndice (pairs, i));
      if (((p != NULL) && (p->left == left)) && (p->right == right))
        {
          return p->pairStatus;
        }
      i += 1;
    }
  return M2Check_unknown;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   return -
*/

static M2Check_status return_ (M2Check_status result, M2Check_tInfo tinfo, unsigned int left, unsigned int right)
{
  if (result != M2Check_unknown)
    {
      if (isKnown (result))
        {
          include (tinfo->resolved, left, right, result);
          exclude (tinfo->unresolved, left, right);
          exclude (tinfo->visited, left, right);  /* no longer visiting as it is resolved.  */
        }
    }
  if (result == M2Check_false)
    {
      return issueError (false, tinfo, left, right);
    }
  return result;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   checkSkipEquivalence - return true if left right are equivalent.
*/

static M2Check_status checkSkipEquivalence (M2Check_status result, unsigned int left, unsigned int right)
{
  if (isKnown (result))
    {
      return result;
    }
  else if (isSkipEquivalence (left, right))
    {
      /* avoid dangling else.  */
      return M2Check_true;
    }
  else
    {
      /* avoid dangling else.  */
      return result;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   checkSetEquivalent - compares set types, left and right.
*/

static M2Check_status checkSetEquivalent (M2Check_status result, M2Check_tInfo tinfo, unsigned int left, unsigned int right)
{
  result = checkSkipEquivalence (result, left, right);
  result = checkTypeKindEquivalence (result, tinfo, SymbolTable_GetDType (left), SymbolTable_GetDType (right));
  result = checkTypeRangeEquivalence (result, tinfo, SymbolTable_GetDType (left), SymbolTable_GetDType (right));
  return return_ (result, tinfo, left, right);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   checkRecordEquivalence - compares record types, left and right.
*/

static M2Check_status checkRecordEquivalence (M2Check_status result, unsigned int left, unsigned int right)
{
  if (isFalse (result))
    {
      return result;
    }
  else if (left == right)
    {
      /* avoid dangling else.  */
      return M2Check_true;
    }
  else
    {
      /* avoid dangling else.  */
      return M2Check_false;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   getType - only returns the type of symbol providing it is not a procedure.
*/

static unsigned int getType (unsigned int sym)
{
  if ((sym != SymbolTable_NulSym) && (SymbolTable_IsProcedure (sym)))
    {
      return SymbolTable_GetProcedureProcType (sym);
    }
  else if (IsTyped (sym))
    {
      /* avoid dangling else.  */
      return SymbolTable_GetDType (sym);
    }
  else
    {
      /* avoid dangling else.  */
      return sym;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   getSType -
*/

static unsigned int getSType (unsigned int sym)
{
  if (SymbolTable_IsProcedure (sym))
    {
      return M2System_Address;
    }
  else
    {
      return SymbolTable_GetDType (sym);
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   determineCompatible - check for compatibility by checking
                         equivalence, array, generic and type kind.
*/

static M2Check_status determineCompatible (M2Check_status result, M2Check_tInfo tinfo, unsigned int left, unsigned int right)
{
  result = checkPair (result, tinfo, left, right);
  return return_ (result, tinfo, left, right);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   get -
*/

static bool get (Indexing_Index pairs, unsigned int *left, unsigned int *right, M2Check_status s)
{
  unsigned int i;
  unsigned int n;
  M2Check_pair p;

  i = 1;
  n = Indexing_HighIndice (pairs);
  while (i <= n)
    {
      p = static_cast<M2Check_pair> (Indexing_GetIndice (pairs, i));
      if ((p != NULL) && (p->pairStatus == s))
        {
          (*left) = p->left;
          (*right) = p->right;
          return true;
        }
      i += 1;
    }
  return false;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   isInternal - return TRUE if sym is a constant lit which was declared
                as internal.
*/

static bool isInternal (unsigned int sym)
{
  return (SymbolTable_IsConstLit (sym)) && (SymbolTable_IsConstLitInternal (sym));
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   doCheck - keep obtaining an unresolved pair and check for the
             type compatibility.  This is the main check routine used by
             parameter, assignment and expression compatibility.
             It tests all unknown pairs and calls the appropriate
             check function
*/

static bool doCheck (M2Check_tInfo tinfo)
{
  M2Check_status result;
  unsigned int left;
  unsigned int right;

  if (debugging)
    {
      dumptInfo (tinfo);
    }
  while (get (tinfo->unresolved, &left, &right, M2Check_unknown))
    {
      if (debugging)
        {
          libc_printf ((const char *) "doCheck (%d, %d)\\n", 18, left, right);
          dumptInfo (tinfo);
        }
      if ((left == SymbolTable_NulSym) || (right == SymbolTable_NulSym))
        {
          /* Cannot test if a type is NulSym, we assume true.
            It maybe that later on a symbols type is set and later
            on checking will be called and more accurately resolved.
            For example constant strings can be concatenated during
            the quadruple folding phase.  */
          return true;
        }
      else if ((isInternal (left)) || (isInternal (right)))
        {
          /* avoid dangling else.  */
          /* Do not check constants which have been generated internally.
            Currently these are generated by the default BY constant
            value in a FOR loop.  */
          return true;
        }
      /* 
      IF in (tinfo^.visited, left, right)
      THEN
         IF debugging
         THEN
            printf ("   already visited (%d, %d)
      ", left, right)
         END ;
      ELSE
         IF debugging
         THEN
            printf ("   not visited (%d, %d)
      ", left, right)
         END ;
  */
      result = (*tinfo->checkFunc.proc) (M2Check_unknown, tinfo, left, right);
      if (isKnown (result))
        {
          /* Remove this pair from the unresolved list.  */
          exclude (tinfo->unresolved, left, right);
          /* Add it to the resolved list.  */
          include (tinfo->resolved, left, right, result);
          if (result == M2Check_false)
            {
              if (debugging)
                {
                  libc_printf ((const char *) "   known (%d, %d)  false\\n", 26, left, right);
                }
              return false;
            }
          else
            {
              if (debugging)
                {
                  libc_printf ((const char *) "   known (%d, %d)  true\\n", 25, left, right);
                }
            }
        }
    }
  return true;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   in - returns TRUE if the pair is in the list.
*/

static bool in (Indexing_Index pairs, unsigned int left, unsigned int right)
{
  unsigned int i;
  unsigned int n;
  M2Check_pair p;

  i = 1;
  n = Indexing_HighIndice (pairs);
  while (i <= n)
    {
      p = static_cast<M2Check_pair> (Indexing_GetIndice (pairs, i));
      if (((p != NULL) && (p->left == left)) && (p->right == right))
        {
          return true;
        }
      i += 1;
    }
  return false;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   newPair -
*/

static M2Check_pair newPair (void)
{
  M2Check_pair p;

  if (pairFreeList == NULL)
    {
      Storage_ALLOCATE ((void **) &p, sizeof (M2Check__T2));
    }
  else
    {
      p = pairFreeList;
      pairFreeList = p->next;
    }
  M2Debug_Assert (p != NULL);
  return p;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   disposePair - adds pair, p, to the free list.
*/

static void disposePair (M2Check_pair p)
{
  p->next = pairFreeList;
  pairFreeList = p;
}


/*
   deconstructIndex -
*/

static Indexing_Index deconstructIndex (Indexing_Index pairs)
{
  M2Check_pair p;
  unsigned int i;
  unsigned int n;

  i = 1;
  n = Indexing_HighIndice (pairs);
  while (i <= n)
    {
      p = static_cast<M2Check_pair> (Indexing_GetIndice (pairs, i));
      if (p != NULL)
        {
          disposePair (p);
        }
      i += 1;
    }
  return Indexing_KillIndex (pairs);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   deconstruct - deallocate the List data structure.
*/

static void deconstruct (M2Check_tInfo tinfo)
{
  tinfo->format = DynamicStrings_KillString (tinfo->format);
  tinfo->reason = DynamicStrings_KillString (tinfo->reason);
  tinfo->visited = deconstructIndex (tinfo->visited);
  tinfo->resolved = deconstructIndex (tinfo->resolved);
  tinfo->unresolved = deconstructIndex (tinfo->unresolved);
}


/*
   newtInfo -
*/

static M2Check_tInfo newtInfo (void)
{
  M2Check_tInfo tinfo;

  if (tinfoFreeList == NULL)
    {
      Storage_ALLOCATE ((void **) &tinfo, sizeof (M2Check__T3));
    }
  else
    {
      tinfo = tinfoFreeList;
      tinfoFreeList = tinfoFreeList->next;
    }
  return tinfo;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   collapseString - if the string, a, is "" then return NIL otherwise create
                    and return a dynamic string.
*/

static DynamicStrings_String collapseString (const char *a_, unsigned int _a_high)
{
  char a[_a_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (a, a_, _a_high+1);

  if (StrLib_StrEqual ((const char *) a, _a_high, (const char *) "", 0))
    {
      return static_cast<DynamicStrings_String> (NULL);
    }
  else
    {
      return DynamicStrings_InitString ((const char *) a, _a_high);
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   doExpressionTypeCompatible -
*/

static bool doExpressionTypeCompatible (unsigned int token, const char *format_, unsigned int _format_high, unsigned int left, unsigned int right, bool strict)
{
  M2Check_tInfo tinfo;
  char format[_format_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (format, format_, _format_high+1);

  tinfo = newtInfo ();
  tinfo->reasonEnable = M2Options_StrictTypeReason;
  tinfo->reason = static_cast<DynamicStrings_String> (NULL);
  tinfo->format = collapseString ((const char *) format, _format_high);
  tinfo->token = token;
  tinfo->kind = M2Check_expression;
  tinfo->actual = SymbolTable_NulSym;
  tinfo->formal = SymbolTable_NulSym;
  tinfo->procedure = SymbolTable_NulSym;
  tinfo->nth = 0;
  tinfo->isvar = false;
  tinfo->error = static_cast<M2Error_Error> (NULL);
  tinfo->left = left;
  tinfo->right = right;
  tinfo->checkFunc.proc = static_cast<M2Check_typeCheckFunction_t> (determineCompatible);
  tinfo->visited = Indexing_InitIndex (1);
  tinfo->resolved = Indexing_InitIndex (1);
  tinfo->unresolved = Indexing_InitIndex (1);
  tinfo->strict = strict;
  tinfo->isin = false;
  include (tinfo->unresolved, left, right, M2Check_unknown);
  if (doCheck (tinfo))
    {
      deconstruct (tinfo);
      return true;
    }
  else
    {
      deconstruct (tinfo);
      return false;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   init - initialise all global data structures for this module.
*/

static void init (void)
{
  pairFreeList = NULL;
  tinfoFreeList = NULL;
  errors = Indexing_InitIndex (1);
  InitEquivalenceArray ();
}


/*
   ParameterTypeCompatible - returns TRUE if the nth procedure parameter formal
                             is compatible with actual.
*/

extern "C" bool M2Check_ParameterTypeCompatible (unsigned int token, const char *format_, unsigned int _format_high, unsigned int procedure, unsigned int formal, unsigned int actual, unsigned int nth, bool isvar)
{
  unsigned int formalT;
  unsigned int actualT;
  M2Check_tInfo tinfo;
  char format[_format_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (format, format_, _format_high+1);

  tinfo = newtInfo ();
  formalT = getSType (formal);
  actualT = getSType (actual);
  tinfo->reasonEnable = M2Options_StrictTypeReason;
  tinfo->reason = static_cast<DynamicStrings_String> (NULL);
  tinfo->format = collapseString ((const char *) format, _format_high);
  tinfo->token = token;
  tinfo->kind = M2Check_parameter;
  tinfo->actual = actual;
  tinfo->formal = formal;
  tinfo->procedure = procedure;
  tinfo->nth = nth;
  tinfo->isvar = isvar;
  tinfo->error = static_cast<M2Error_Error> (NULL);
  tinfo->left = formalT;
  tinfo->right = actualT;
  tinfo->checkFunc.proc = static_cast<M2Check_typeCheckFunction_t> (determineCompatible);
  tinfo->visited = Indexing_InitIndex (1);
  tinfo->resolved = Indexing_InitIndex (1);
  tinfo->unresolved = Indexing_InitIndex (1);
  tinfo->strict = false;
  tinfo->isin = false;
  include (tinfo->unresolved, actual, formal, M2Check_unknown);
  if (debugging)
    {
      dumptInfo (tinfo);
    }
  if (doCheck (tinfo))
    {
      deconstruct (tinfo);
      return true;
    }
  else
    {
      deconstruct (tinfo);
      return false;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   AssignmentTypeCompatible - returns TRUE if the des and the expr are assignment compatible.
*/

extern "C" bool M2Check_AssignmentTypeCompatible (unsigned int token, const char *format_, unsigned int _format_high, unsigned int des, unsigned int expr, bool enableReason)
{
  M2Check_tInfo tinfo;
  char format[_format_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (format, format_, _format_high+1);

  tinfo = newtInfo ();
  tinfo->reason = static_cast<DynamicStrings_String> (NULL);
  tinfo->reasonEnable = enableReason && M2Options_StrictTypeReason;
  tinfo->format = collapseString ((const char *) format, _format_high);
  tinfo->token = token;
  tinfo->kind = M2Check_assignment;
  tinfo->actual = SymbolTable_NulSym;
  tinfo->formal = SymbolTable_NulSym;
  tinfo->procedure = SymbolTable_NulSym;
  tinfo->nth = 0;
  tinfo->isvar = false;
  tinfo->error = static_cast<M2Error_Error> (NULL);
  tinfo->left = des;
  tinfo->right = expr;
  tinfo->checkFunc.proc = static_cast<M2Check_typeCheckFunction_t> (determineCompatible);
  tinfo->visited = Indexing_InitIndex (1);
  tinfo->resolved = Indexing_InitIndex (1);
  tinfo->unresolved = Indexing_InitIndex (1);
  include (tinfo->unresolved, des, expr, M2Check_unknown);
  tinfo->strict = false;
  tinfo->isin = false;
  if (doCheck (tinfo))
    {
      deconstruct (tinfo);
      return true;
    }
  else
    {
      deconstruct (tinfo);
      return false;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   ExpressionTypeCompatible - returns TRUE if the expressions, left and right,
                              are expression compatible.
*/

extern "C" bool M2Check_ExpressionTypeCompatible (unsigned int token, const char *format_, unsigned int _format_high, unsigned int left, unsigned int right, bool strict, bool isin)
{
  char format[_format_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (format, format_, _format_high+1);

  if ((left != SymbolTable_NulSym) && (right != SymbolTable_NulSym))
    {
      if (isin)
        {
          if ((SymbolTable_IsConst (right)) || (SymbolTable_IsVar (right)))
            {
              right = getSType (right);
            }
          if (SymbolTable_IsSet (right))
            {
              right = getSType (right);
            }
        }
    }
  return doExpressionTypeCompatible (token, (const char *) format, _format_high, left, right, strict);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}

extern "C" void _M2_M2Check_init (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
  init ();
}

extern "C" void _M2_M2Check_fini (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
}
