/* do not edit automatically generated by mc from M2ColorString.  */
/* M2ColorString.mod provides procedures for obtaining GCC color strings.

Copyright (C) 2019-2025 Free Software Foundation, Inc.
Contributed by Gaius Mulley <gaius@glam.ac.uk>.

This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GNU Modula-2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Modula-2; see the file COPYING3.  If not see
<http://www.gnu.org/licenses/>.  */

#include "config.h"
#include "system.h"
#include <stdbool.h>
#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif

#   if !defined (TRUE)
#      define TRUE (1==1)
#   endif

#define _M2ColorString_C

#include "GM2ColorString.h"
#   include "Gm2color.h"
#   include "GDynamicStrings.h"
#   include "GStrLib.h"
#   include "Glibc.h"
#   include "GSYSTEM.h"

static bool EnableColor;

/*
   SetEnableColor - sets the global variable to, b, and returns
                    the previous value.
*/

extern "C" bool M2ColorString_SetEnableColor (bool b);

/*
   quoteOpen - adds an open quote to string, s.
*/

extern "C" DynamicStrings_String M2ColorString_quoteOpen (DynamicStrings_String s);

/*
   quoteClose - adds a close quote to string, s.
*/

extern "C" DynamicStrings_String M2ColorString_quoteClose (DynamicStrings_String s);

/*
   endColor - stops using color.
*/

extern "C" DynamicStrings_String M2ColorString_endColor (DynamicStrings_String s);

/*
   quoteColor - adds quote color to string, s.
*/

extern "C" DynamicStrings_String M2ColorString_quoteColor (DynamicStrings_String s);

/*
   errorColor - adds error color to string, s.
*/

extern "C" DynamicStrings_String M2ColorString_errorColor (DynamicStrings_String s);

/*
   warningColor - adds warning color to string, s.
*/

extern "C" DynamicStrings_String M2ColorString_warningColor (DynamicStrings_String s);

/*
   noteColor - adds note color to string, s.
*/

extern "C" DynamicStrings_String M2ColorString_noteColor (DynamicStrings_String s);

/*
   locusColor - adds locus color to string, s.
*/

extern "C" DynamicStrings_String M2ColorString_locusColor (DynamicStrings_String s);

/*
   insertColor - adds fixit-insert color to string, s.
*/

extern "C" DynamicStrings_String M2ColorString_insertColor (DynamicStrings_String s);

/*
   deleteColor - adds fixit-insert color to string, s.
*/

extern "C" DynamicStrings_String M2ColorString_deleteColor (DynamicStrings_String s);

/*
   filenameColor - adds filename color to string, s.
*/

extern "C" DynamicStrings_String M2ColorString_filenameColor (DynamicStrings_String s);

/*
   typeColor - adds type color to string, s.
*/

extern "C" DynamicStrings_String M2ColorString_typeColor (DynamicStrings_String s);

/*
   range1Color - adds type color to string, s.
*/

extern "C" DynamicStrings_String M2ColorString_range1Color (DynamicStrings_String s);

/*
   range2Color - adds type color to string, s.
*/

extern "C" DynamicStrings_String M2ColorString_range2Color (DynamicStrings_String s);

/*
   append - appends color string, name, to the end of string, s,
            and returns, s.
*/

static DynamicStrings_String append (DynamicStrings_String s, const char *name_, unsigned int _name_high);


/*
   append - appends color string, name, to the end of string, s,
            and returns, s.
*/

static DynamicStrings_String append (DynamicStrings_String s, const char *name_, unsigned int _name_high)
{
  DynamicStrings_String c;
  char name[_name_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (name, name_, _name_high+1);

  c = DynamicStrings_InitStringCharStar (reinterpret_cast <void *> (m2color_colorize_start (EnableColor, const_cast<void*> (static_cast<const void*>(name)), StrLib_StrLen ((const char *) name, _name_high))));
  s = DynamicStrings_ConCat (s, c);
  c = DynamicStrings_KillString (c);
  return s;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   SetEnableColor - sets the global variable to, b, and returns
                    the previous value.
*/

extern "C" bool M2ColorString_SetEnableColor (bool b)
{
  bool previous;

  previous = EnableColor;
  EnableColor = b;
  return previous;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   quoteOpen - adds an open quote to string, s.
*/

extern "C" DynamicStrings_String M2ColorString_quoteOpen (DynamicStrings_String s)
{
  return DynamicStrings_ConCat (append (s, (const char *) "quote", 5), DynamicStrings_Mark (DynamicStrings_InitStringCharStar (reinterpret_cast <void *> (m2color_open_quote ()))));
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   quoteClose - adds a close quote to string, s.
*/

extern "C" DynamicStrings_String M2ColorString_quoteClose (DynamicStrings_String s)
{
  s = M2ColorString_endColor (s);
  s = append (s, (const char *) "quote", 5);
  s = DynamicStrings_ConCat (s, DynamicStrings_Mark (DynamicStrings_InitStringCharStar (reinterpret_cast <void *> (m2color_close_quote ()))));
  s = M2ColorString_endColor (s);
  return s;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   endColor - stops using color.
*/

extern "C" DynamicStrings_String M2ColorString_endColor (DynamicStrings_String s)
{
  DynamicStrings_String c;

  c = DynamicStrings_InitStringCharStar (reinterpret_cast <void *> (m2color_colorize_stop (EnableColor)));
  s = DynamicStrings_ConCat (s, c);
  c = DynamicStrings_KillString (c);
  return s;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   quoteColor - adds quote color to string, s.
*/

extern "C" DynamicStrings_String M2ColorString_quoteColor (DynamicStrings_String s)
{
  return append (s, (const char *) "quote", 5);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   errorColor - adds error color to string, s.
*/

extern "C" DynamicStrings_String M2ColorString_errorColor (DynamicStrings_String s)
{
  return append (s, (const char *) "error", 5);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   warningColor - adds warning color to string, s.
*/

extern "C" DynamicStrings_String M2ColorString_warningColor (DynamicStrings_String s)
{
  return append (s, (const char *) "warning", 7);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   noteColor - adds note color to string, s.
*/

extern "C" DynamicStrings_String M2ColorString_noteColor (DynamicStrings_String s)
{
  return append (s, (const char *) "note", 4);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   locusColor - adds locus color to string, s.
*/

extern "C" DynamicStrings_String M2ColorString_locusColor (DynamicStrings_String s)
{
  return append (s, (const char *) "locus", 5);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   insertColor - adds fixit-insert color to string, s.
*/

extern "C" DynamicStrings_String M2ColorString_insertColor (DynamicStrings_String s)
{
  return append (s, (const char *) "fixit-insert", 12);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   deleteColor - adds fixit-insert color to string, s.
*/

extern "C" DynamicStrings_String M2ColorString_deleteColor (DynamicStrings_String s)
{
  return append (s, (const char *) "fixit-delete", 12);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   filenameColor - adds filename color to string, s.
*/

extern "C" DynamicStrings_String M2ColorString_filenameColor (DynamicStrings_String s)
{
  return append (s, (const char *) "diff-filename", 13);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   typeColor - adds type color to string, s.
*/

extern "C" DynamicStrings_String M2ColorString_typeColor (DynamicStrings_String s)
{
  return append (s, (const char *) "type", 4);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   range1Color - adds type color to string, s.
*/

extern "C" DynamicStrings_String M2ColorString_range1Color (DynamicStrings_String s)
{
  return append (s, (const char *) "range1", 6);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   range2Color - adds type color to string, s.
*/

extern "C" DynamicStrings_String M2ColorString_range2Color (DynamicStrings_String s)
{
  return append (s, (const char *) "range2", 6);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}

extern "C" void _M2_M2ColorString_init (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
  EnableColor = true;
}

extern "C" void _M2_M2ColorString_fini (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
}
