/* do not edit automatically generated by mc from M2Options.  */
/* M2Options.mod initializes the user options.

Copyright (C) 2001-2025 Free Software Foundation, Inc.
Contributed by Gaius Mulley <gaius.mulley@southwales.ac.uk>.

This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GNU Modula-2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Modula-2; see the file COPYING3.  If not see
<http://www.gnu.org/licenses/>.  */

#include "config.h"
#include "system.h"
#include "gcc-consolidation.h"

#include <stdbool.h>
#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif

#   if !defined (TRUE)
#      define TRUE (1==1)
#   endif

#   if !defined (FALSE)
#      define FALSE (1==0)
#   endif

#if defined(__cplusplus)
#   undef NULL
#   define NULL 0
#endif
#define _M2Options_C

#include "GM2Options.h"
#   include "GCmdArgs.h"
#   include "GSArgs.h"
#   include "GM2Search.h"
#   include "GPathName.h"
#   include "GM2Printf.h"
#   include "GFIO.h"
#   include "Glibc.h"
#   include "GDebug.h"
#   include "Ggcctypes.h"
#   include "Gm2configure.h"
#   include "GM2Error.h"
#   include "GFormatStrings.h"
#   include "Gm2misc.h"
#   include "GDynamicStrings.h"

#   define Debugging false
#   define DefaultRuntimeModuleOverride "m2iso:RTentity,m2iso:Storage,m2iso:SYSTEM,m2iso:M2RTS,m2iso:RTExceptions,m2iso:IOLink"
static DynamicStrings_String DumpDeclFilename;
static DynamicStrings_String DumpQuadFilename;
static DynamicStrings_String DumpGimpleFilename;
static DynamicStrings_String M2Dump;
static DynamicStrings_String M2DumpFilter;
static DynamicStrings_String M2Prefix;
static DynamicStrings_String M2PathName;
static DynamicStrings_String Barg;
static DynamicStrings_String MFarg;
static DynamicStrings_String MTFlag;
static DynamicStrings_String MQFlag;
static DynamicStrings_String DepTarget;
static DynamicStrings_String CmdLineObj;
static DynamicStrings_String SaveTempsDir;
static DynamicStrings_String DumpDir;
static DynamicStrings_String GenModuleListFilename;
static DynamicStrings_String UselistFilename;
static DynamicStrings_String RuntimeModuleOverride;
static DynamicStrings_String CppArgs;
static bool EnableForward;
static bool DebugFunctionLineNumbers;
static bool DebugTraceQuad;
static bool DebugTraceLine;
static bool DebugTraceToken;
static bool DebugTraceTree;
static bool DumpDecl;
static bool DumpGimple;
static bool DumpQuad;
static bool MFlag;
static bool MMFlag;
static bool MPFlag;
static bool MDFlag;
static bool MMDFlag;
static bool IBMLongDouble;
static bool IEEELongDouble;
static bool UselistFlag;
static bool CC1Quiet;
static bool SeenSources;
static unsigned int OffTBits;
static location_t ForcedLocationValue;

/*
   SetM - set the MFlag.
*/

extern "C" void M2Options_SetM (bool value);

/*
   GetM - set the MFlag.
*/

extern "C" bool M2Options_GetM (void);

/*
   SetMM - set the MMFlag.
*/

extern "C" void M2Options_SetMM (bool value);

/*
   GetMM - set the MMFlag.
*/

extern "C" bool M2Options_GetMM (void);

/*
   SetMF - assigns MFarg to the filename from arg.
*/

extern "C" void M2Options_SetMF (void * arg);

/*
   GetMF - returns MFarg or NIL if never set.
*/

extern "C" void * M2Options_GetMF (void);

/*
   SetM2Prefix - assign arg to M2Prefix.
*/

extern "C" void M2Options_SetM2Prefix (void * arg);

/*
   GetM2Prefix - return M2Prefix as a C string.
*/

extern "C" void * M2Options_GetM2Prefix (void);

/*
   SetM2PathName - assign arg to M2PathName.
*/

extern "C" void M2Options_SetM2PathName (void * arg);

/*
   GetM2PathName - return M2PathName as a C string.
*/

extern "C" void * M2Options_GetM2PathName (void);

/*
   SetPPOnly - set the PPonly (preprocess only) to value.
*/

extern "C" void M2Options_SetPPOnly (bool value);

/*
   GetPPOnly - get the PPonly (preprocess only).
*/

extern "C" bool M2Options_GetPPOnly (void);

/*
   Setc - set the cflag (compile only flag -c) to value.
*/

extern "C" void M2Options_Setc (bool value);

/*
   Getc - get the cflag (compile only flag -c).
*/

extern "C" bool M2Options_Getc (void);

/*
   SetB - assigns Barg to arg.
*/

extern "C" void M2Options_SetB (void * arg);

/*
   GetB - returns Barg value as a C string or NIL if it was never set.
*/

extern "C" void * M2Options_GetB (void);

/*
   SetMD - set the MDFlag to value.
*/

extern "C" void M2Options_SetMD (bool value);

/*
   GetMD - return the MDFlag.
*/

extern "C" bool M2Options_GetMD (void);

/*
   SetMMD - set the MMDFlag to value.
*/

extern "C" void M2Options_SetMMD (bool value);

/*
   GetMMD - return the MMDFlag.
*/

extern "C" bool M2Options_GetMMD (void);

/*
   SetMQ - adds a quoted target arg to the DepTarget sentence.
*/

extern "C" void M2Options_SetMQ (void * arg);

/*
   GetMQ - returns a C string containing all the -MQ arg values.
*/

extern "C" void * M2Options_GetMQ (void);

/*
   SetMT - adds a target arg to the DepTarget sentence.
*/

extern "C" void M2Options_SetMT (void * arg);

/*
   GetMT - returns a C string containing all the -MT arg values.
*/

extern "C" void * M2Options_GetMT (void);

/*
   GetDepTarget - returns the DepTarget as a C string.
*/

extern "C" void * M2Options_GetDepTarget (void);

/*
   SetMP - set the MPflag to value.
*/

extern "C" void M2Options_SetMP (bool value);

/*
   GetMP - get the MPflag.
*/

extern "C" bool M2Options_GetMP (void);

/*
   SetObj - assigns CmdLineObj to the filename from arg.
*/

extern "C" void M2Options_SetObj (void * arg);

/*
   GetObj - returns CmdLineObj filename as a c-string or NIL if it was never set.
*/

extern "C" void * M2Options_GetObj (void);

/*
   SetCpp - enables the source to be preprocessed and enables the
            recognition of C preprocessor line directives.
*/

extern "C" bool M2Options_SetCpp (bool value);

/*
   GetCpp - returns TRUE if the C preprocessor was used.
*/

extern "C" bool M2Options_GetCpp (void);

/*
   GetLineDirectives - returns TRUE if line directives are allowed.
*/

extern "C" bool M2Options_GetLineDirectives (void);

/*
   SetScaffoldDynamic - set the -fscaffold-dynamic flag.
*/

extern "C" void M2Options_SetScaffoldDynamic (bool value);

/*
   SetScaffoldStatic - set the -fscaffold-static flag.
*/

extern "C" void M2Options_SetScaffoldStatic (bool value);

/*
   GetScaffoldDynamic - get the -fscaffold-dynamic flag.
*/

extern "C" bool M2Options_GetScaffoldDynamic (void);

/*
   GetScaffoldStatic - get the -fscaffold-static flag.
*/

extern "C" bool M2Options_GetScaffoldStatic (void);

/*
   SetScaffoldMain - set the -fscaffold-main flag.
*/

extern "C" void M2Options_SetScaffoldMain (bool value);

/*
   SetRuntimeModuleOverride - set the override sequence used for module
                              initialization and finialization.
*/

extern "C" void M2Options_SetRuntimeModuleOverride (void * override);

/*
   GetRuntimeModuleOverride - return a string containing any user override
                              or the default module initialization override
                              sequence.
*/

extern "C" void * M2Options_GetRuntimeModuleOverride (void);

/*
   SetUselist - set the uselist flag to value and remember the filename.
*/

extern "C" void M2Options_SetUselist (bool value, void * filename);

/*
   GetUselist - return the uselist flag.
*/

extern "C" bool M2Options_GetUselist (void);

/*
   GetUselistFilename - return the uselist filename as a String.
*/

extern "C" DynamicStrings_String M2Options_GetUselistFilename (void);

/*
   SetWholeProgram - sets the WholeProgram flag (-fwhole-program).
*/

extern "C" void M2Options_SetWholeProgram (bool value);

/*
   SetAutoInit - -fauto-init turns on automatic initialization of pointers to NIL.
                  TRUE is returned.
*/

extern "C" bool M2Options_SetAutoInit (bool value);

/*
   SetReturnCheck -
*/

extern "C" bool M2Options_SetReturnCheck (bool value);

/*
   SetNilCheck -
*/

extern "C" bool M2Options_SetNilCheck (bool value);

/*
   SetCaseCheck - set else case checking to, value.
*/

extern "C" bool M2Options_SetCaseCheck (bool value);

/*
   SetCheckAll - set all runtime checking to, value.
*/

extern "C" bool M2Options_SetCheckAll (bool value);

/*
   SetVerboseUnbounded - sets the VerboseUnbounded flag to, value.
*/

extern "C" bool M2Options_SetVerboseUnbounded (bool value);

/*
   SetQuiet - sets the quiet flag to, value.
*/

extern "C" bool M2Options_SetQuiet (bool value);

/*
   SetCC1Quiet - sets the cc1quiet flag to, value.
*/

extern "C" void M2Options_SetCC1Quiet (bool value);

/*
   SetM2g - set GenerateStatementNote to value and return value.
            Corresponds to the -fm2-g flag.
*/

extern "C" bool M2Options_SetM2g (bool value);

/*
   GetM2g - returns TRUE if the -fm2-g flags was used.
*/

extern "C" bool M2Options_GetM2g (void);

/*
   SetLowerCaseKeywords - set the lower case keyword flag and return the result.
*/

extern "C" bool M2Options_SetLowerCaseKeywords (bool value);

/*
   SetUnboundedByReference -
*/

extern "C" bool M2Options_SetUnboundedByReference (bool value);

/*
   SetSearchPath -
*/

extern "C" void M2Options_SetSearchPath (void * arg);

/*
   SetISO -
*/

extern "C" void M2Options_SetISO (bool value);

/*
   SetPIM -
*/

extern "C" void M2Options_SetPIM (bool value);

/*
   SetPIM2 -
*/

extern "C" void M2Options_SetPIM2 (bool value);

/*
   SetPIM3 -
*/

extern "C" void M2Options_SetPIM3 (bool value);

/*
   SetPIM4 -
*/

extern "C" void M2Options_SetPIM4 (bool value);

/*
   SetPositiveModFloor - sets the positive mod floor option.
*/

extern "C" void M2Options_SetPositiveModFloor (bool value);

/*
   SetWholeDiv - sets the whole division flag.
*/

extern "C" void M2Options_SetWholeDiv (bool value);

/*
   SetIndex - sets the runtime array index checking flag.
*/

extern "C" void M2Options_SetIndex (bool value);

/*
   SetRange -  sets the runtime range checking flag.
*/

extern "C" void M2Options_SetRange (bool value);

/*
   SetExceptions - sets the enable runtime exceptions flag.
*/

extern "C" void M2Options_SetExceptions (bool value);

/*
   SetStyle -
*/

extern "C" void M2Options_SetStyle (bool value);

/*
   SetPedantic -
*/

extern "C" void M2Options_SetPedantic (bool value);

/*
   SetPedanticParamNames - sets the pedantic parameter name flag.
*/

extern "C" void M2Options_SetPedanticParamNames (bool value);

/*
   SetPedanticCast - sets the pedantic cast flag.
*/

extern "C" void M2Options_SetPedanticCast (bool value);

/*
   SetExtendedOpaque - sets the ExtendedOpaque flag.
*/

extern "C" void M2Options_SetExtendedOpaque (bool value);

/*
   SetXCode - sets the xcode flag.
*/

extern "C" void M2Options_SetXCode (bool value);

/*
   SetCompilerDebugging - turn on internal compiler debugging.
                          Enabled via the command line option -fd.
*/

extern "C" void M2Options_SetCompilerDebugging (bool value);

/*
   SetQuadDebugging - display the quadruples (internal debugging).
*/

extern "C" void M2Options_SetQuadDebugging (bool value);

/*
   SetM2DebugTraceFilter - set internal debug flags.  The flags should be
                           specified as a comma separated list.  The full
                           list allowed is quad,line,token,all.
*/

extern "C" void M2Options_SetM2DebugTraceFilter (bool value, void * filter);

/*
   SetDebugFunctionLineNumbers - set DebugFunctionLineNumbers.
*/

extern "C" void M2Options_SetDebugFunctionLineNumbers (bool value);

/*
   SetGenerateStatementNote - turn on generation of nops if necessary
                              to generate pedalogical single stepping.
*/

extern "C" void M2Options_SetGenerateStatementNote (bool value);

/*
   SetSources -
*/

extern "C" void M2Options_SetSources (bool value);

/*
   SetDumpSystemExports -
*/

extern "C" void M2Options_SetDumpSystemExports (bool value);

/*
   SetSwig -
*/

extern "C" void M2Options_SetSwig (bool value);

/*
   SetOptimizing -
*/

extern "C" void M2Options_SetOptimizing (unsigned int value);

/*
   OverrideLocation - possibly override the location value, depending upon
                      whether the -flocation= option was used.
*/

extern "C" location_t M2Options_OverrideLocation (location_t location);

/*
   SetForcedLocation - sets the location for the lifetime of this compile to, location.
                       This is primarily an internal debugging switch.
*/

extern "C" void M2Options_SetForcedLocation (location_t location);

/*
   SetUnusedVariableChecking - assigns the UnusedVariableChecking to value.
*/

extern "C" void M2Options_SetUnusedVariableChecking (bool value);

/*
   SetUnusedParameterChecking - assigns the UnusedParameterChecking to value.
*/

extern "C" void M2Options_SetUnusedParameterChecking (bool value);

/*
   SetStrictTypeChecking - assigns the StrictTypeChecking flag to value.
*/

extern "C" void M2Options_SetStrictTypeChecking (bool value);

/*
   SetStrictTypeAssignment - assigns the StrictTypeAssignment flag to value.
*/

extern "C" void M2Options_SetStrictTypeAssignment (bool value);

/*
   SetStrictTypeReason - assigns the StrictTypeReason flag to value.
*/

extern "C" void M2Options_SetStrictTypeReason (bool value);

/*
   setdefextension - set the source file definition module extension to arg.
                     This should include the . and by default it is set to .def.
*/

extern "C" void M2Options_setdefextension (void * arg);

/*
   setmodextension - set the source file module extension to arg.
                     This should include the . and by default it is set to .mod.
*/

extern "C" void M2Options_setmodextension (void * arg);

/*
   SetStatistics - turn on/off generate of compile time statistics.
*/

extern "C" void M2Options_SetStatistics (bool on);

/*
   SetVerbose - set the Verbose flag to, value.  It returns TRUE.
*/

extern "C" bool M2Options_SetVerbose (bool value);

/*
   CppArg - sets the option and arg in the cpp command line.
*/

extern "C" void M2Options_CppArg (void * opt, void * arg, bool joined);

/*
   CppCommandLine - returns the Cpp command line and all arguments.
                    NIL is returned if the -fcpp is absent.
*/

extern "C" DynamicStrings_String M2Options_CppCommandLine (void);

/*
   CppRemember - remember a string, s, as a cpp related argument.
                 The string, s, is not garbage collected.
*/

extern "C" void M2Options_CppRemember (DynamicStrings_String s);

/*
   GetISO - return TRUE if -fiso was present on the command line.
*/

extern "C" bool M2Options_GetISO (void);

/*
   GetPIM - return TRUE if -fpim was present on the command line.
*/

extern "C" bool M2Options_GetPIM (void);

/*
   GetPIM2 - return TRUE if -fpim2 was present on the command line.
*/

extern "C" bool M2Options_GetPIM2 (void);

/*
   GetPIM3 - return TRUE if -fpim3 was present on the command line.
*/

extern "C" bool M2Options_GetPIM3 (void);

/*
   GetPIM4 - return TRUE if -fpim4 was present on the command line.
*/

extern "C" bool M2Options_GetPIM4 (void);

/*
   GetPositiveModFloor - return TRUE if -fpositive-mod-floor was present
                         on the command line.
*/

extern "C" bool M2Options_GetPositiveModFloor (void);

/*
   GetFloatValueCheck - return TRUE if -ffloatvalue was present on the
                        command line.
*/

extern "C" bool M2Options_GetFloatValueCheck (void);

/*
   SetFloatValueCheck - set depending upon the -ffloatvalue.
*/

extern "C" void M2Options_SetFloatValueCheck (bool value);

/*
   GetWholeValueCheck - return TRUE if -fwholevalue was present on the
                        command line.
*/

extern "C" bool M2Options_GetWholeValueCheck (void);

/*
   SetWholeValueCheck - set depending upon the -fwholevalue.
*/

extern "C" void M2Options_SetWholeValueCheck (bool value);

/*
   SetWall - set all warnings to, value.
*/

extern "C" void M2Options_SetWall (bool value);

/*
   SetSaveTemps - turn on/off -save-temps.
*/

extern "C" void M2Options_SetSaveTemps (bool value);

/*
   SetSaveTempsDir - turn on/off -save-temps and specify the directory.
*/

extern "C" void M2Options_SetSaveTempsDir (void * arg);

/*
   GetSaveTempsDir - return SaveTempsDir or NIL if -save-temps was not used.
*/

extern "C" DynamicStrings_String M2Options_GetSaveTempsDir (void);

/*
   SetDumpDir - Set the dump dir.
*/

extern "C" void M2Options_SetDumpDir (void * arg);

/*
   GetDumpDir - return DumpDir or NIL.
*/

extern "C" DynamicStrings_String M2Options_GetDumpDir (void);

/*
   SetGenModuleList - set the GenModuleList flag to true and pass
                      set GenModuleListFilename to filename.
*/

extern "C" void M2Options_SetGenModuleList (bool value, void * filename);

/*
   GetGenModuleFilename - returns the filename set by SetGenModuleList.
*/

extern "C" DynamicStrings_String M2Options_GetGenModuleFilename (void);

/*
   SetShared - sets the SharedFlag to value.
*/

extern "C" void M2Options_SetShared (bool value);

/*
   SetUninitVariableChecking - sets the UninitVariableChecking and
                               UninitVariableConditionalChecking flags to value
                               depending upon arg string.  The arg string
                               can be: "all", "known,cond", "cond,known", "known"
                               or "cond".
*/

extern "C" int M2Options_SetUninitVariableChecking (bool value, void * arg);

/*
   SetCaseEnumChecking - sets the CaseEnumChecking to value.
*/

extern "C" void M2Options_SetCaseEnumChecking (bool value);

/*
   SetDebugBuiltins - sets the DebugBuiltins to value.
*/

extern "C" void M2Options_SetDebugBuiltins (bool value);

/*
   SetIBMLongDouble - enable/disable LONGREAL to map onto the
                      IBM long double 128 bit data type.
                      (Only available on the ppc).
*/

extern "C" void M2Options_SetIBMLongDouble (bool value);

/*
   GetIBMLongDouble - return the value of IBMLongDouble.
*/

extern "C" bool M2Options_GetIBMLongDouble (void);

/*
   SetIEEELongDouble - enable/disable LONGREAL to map onto the
                       IEEE long double 128 bit data type.
                       (Only available on the ppc).
*/

extern "C" void M2Options_SetIEEELongDouble (bool value);

/*
   GetIEEELongDouble - return the value of IEEELongDouble.
*/

extern "C" bool M2Options_GetIEEELongDouble (void);

/*
   GetDumpDeclFilename - returns the DumpDeclFilename.
*/

extern "C" DynamicStrings_String M2Options_GetDumpDeclFilename (void);

/*
   SetDumpDeclFilename -
*/

extern "C" void M2Options_SetDumpDeclFilename (bool value, void * filename);

/*
   GetDumpQuadFilename - returns the DumpQuadFilename.
*/

extern "C" DynamicStrings_String M2Options_GetDumpQuadFilename (void);

/*
   SetDumpQuadFilename -
*/

extern "C" void M2Options_SetDumpQuadFilename (bool value, void * filename);

/*
   GetDumpGimpleFilename - returns the DumpGimpleFilename.
*/

extern "C" DynamicStrings_String M2Options_GetDumpGimpleFilename (void);

/*
   SetDumpGimpleFilename - set DumpGimpleFilename to filename.
*/

extern "C" void M2Options_SetDumpGimpleFilename (bool value, void * filename);

/*
   SetM2DumpFilter - sets the filter to a comma separated list of procedures
                     and modules.  Not to be confused with SetM2Dump below
                     which enables the class of data structures to be dumped.
*/

extern "C" void M2Options_SetM2DumpFilter (bool value, void * filter);

/*
   GetM2DumpFilter - returns the dump filter.
*/

extern "C" void * M2Options_GetM2DumpFilter (void);

/*
   SetM2Dump - sets the dump via a comma separated list: quad,decl,gimple,all.
               It returns TRUE if the comma separated list is valid.
*/

extern "C" bool M2Options_SetM2Dump (bool value, void * filter);

/*
   GetDumpGimple - return TRUE if the dump gimple flag is set from SetM2Dump.
*/

extern "C" bool M2Options_GetDumpGimple (void);

/*
   GetDumpQuad - return TRUE if the dump quad flag is set from SetM2Dump.
*/

extern "C" bool M2Options_GetDumpQuad (void);

/*
   GetDumpDecl - return TRUE if the dump decl flag is set from SetM2Dump.
*/

extern "C" bool M2Options_GetDumpDecl (void);

/*
   GetDebugTraceQuad - return DebugTraceQuad.
*/

extern "C" bool M2Options_GetDebugTraceQuad (void);

/*
   GetDebugTraceTree - return DebugTraceTree.
*/

extern "C" bool M2Options_GetDebugTraceTree (void);

/*
   GetDebugTraceToken - return DebugTraceToken.
*/

extern "C" bool M2Options_GetDebugTraceToken (void);

/*
   GetDebugTraceLine - return DebugTraceLine.
*/

extern "C" bool M2Options_GetDebugTraceLine (void);

/*
   GetDebugFunctionLineNumbers - return DebugFunctionLineNumbers.
*/

extern "C" bool M2Options_GetDebugFunctionLineNumbers (void);

/*
   GetEnableForward - return EnableForward.
*/

extern "C" bool M2Options_GetEnableForward (void);

/*
   SetEnableForward - set EnableForward to value.
*/

extern "C" void M2Options_SetEnableForward (bool value);

/*
   SetFileOffsetBits - create SYSTEM.COFF_T as a signed integer of size bits.
*/

extern "C" bool M2Options_SetFileOffsetBits (bool value, unsigned int bits);

/*
   GetFileOffsetBits - return the number of bits used to create SYSTEM.COFF_T.
*/

extern "C" unsigned int M2Options_GetFileOffsetBits (void);

/*
   FinaliseOptions - once all options have been parsed we set any inferred
                     values.
*/

extern "C" void M2Options_FinaliseOptions (void);

/*
   errors1 -
*/

static void errors1 (const char *format_, unsigned int _format_high, DynamicStrings_String arg);

/*
   AddWord - concats a word to sentence inserting a space if necessary.
             sentence is returned.  sentence will be created if it is NIL.
*/

static DynamicStrings_String AddWord (DynamicStrings_String sentence, DynamicStrings_String word);

/*
   QuoteTarget - quote the '$' character.
*/

static DynamicStrings_String QuoteTarget (DynamicStrings_String target);

/*
   SetM2DebugTrace -
*/

static void SetM2DebugTrace (DynamicStrings_String word, bool value);

/*
   InitializeLongDoubleFlags - initialize the long double related flags
                               with default values given during gcc configure.
*/

static void InitializeLongDoubleFlags (void);

/*
   MatchDump - enable/disable dump using value.  It returns TRUE if dump
               is valid.
*/

static bool MatchDump (DynamicStrings_String dump, bool value);


/*
   errors1 -
*/

static void errors1 (const char *format_, unsigned int _format_high, DynamicStrings_String arg)
{
  DynamicStrings_String message;
  void * cstr;
  char format[_format_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (format, format_, _format_high+1);

  message = FormatStrings_Sprintf1 (DynamicStrings_InitString ((const char *) format, _format_high), (const unsigned char *) &arg, (sizeof (arg)-1));
  cstr = DynamicStrings_string (message);
  m2misc_cerror (cstr);
  libc_exit (1);
}


/*
   AddWord - concats a word to sentence inserting a space if necessary.
             sentence is returned.  sentence will be created if it is NIL.
*/

static DynamicStrings_String AddWord (DynamicStrings_String sentence, DynamicStrings_String word)
{
  if (word != NULL)
    {
      /* avoid gcc warning by using compound statement even if not strictly necessary.  */
      if (sentence == NULL)
        {
          sentence = DynamicStrings_Dup (word);
        }
      else
        {
          sentence = DynamicStrings_ConCatChar (sentence, ' ');
          sentence = DynamicStrings_ConCat (sentence, word);
        }
    }
  return sentence;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   QuoteTarget - quote the '$' character.
*/

static DynamicStrings_String QuoteTarget (DynamicStrings_String target)
{
  DynamicStrings_String quoted;
  unsigned int i;
  unsigned int n;

  quoted = DynamicStrings_InitString ((const char *) "", 0);
  i = 0;
  n = DynamicStrings_Length (target);
  while (i < n)
    {
      switch (DynamicStrings_char (target, static_cast<int> (i)))
        {
          case '$':
            quoted = DynamicStrings_ConCat (quoted, DynamicStrings_Mark (DynamicStrings_InitString ((const char *) "$$", 2)));
            break;


          default:
            quoted = DynamicStrings_ConCatChar (quoted, DynamicStrings_char (target, static_cast<int> (i)));
            break;
        }
      i += 1;
    }
  return quoted;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   SetM2DebugTrace -
*/

static void SetM2DebugTrace (DynamicStrings_String word, bool value)
{
  if (DynamicStrings_EqualArray (word, (const char *) "all", 3))
    {
      /* DebugTraceTree := value ;  */
      DebugTraceQuad = value;
      DebugTraceToken = value;
      DebugTraceLine = value;
    }
  else if (DynamicStrings_EqualArray (word, (const char *) "quad", 4))
    {
      /* avoid dangling else.  */
      DebugTraceQuad = value;
    }
  else if (DynamicStrings_EqualArray (word, (const char *) "token", 5))
    {
      /* avoid dangling else.  */
      DebugTraceToken = value;
    }
  else if (DynamicStrings_EqualArray (word, (const char *) "line", 4))
    {
      /* avoid dangling else.  */
      DebugTraceLine = value;
    }
  else
    {
      /* avoid dangling else.  */
      errors1 ((const char *) "unrecognized filter %s seen in -fm2-debug-trace= option\\n", 57, word);
    }
}


/*
   InitializeLongDoubleFlags - initialize the long double related flags
                               with default values given during gcc configure.
*/

static void InitializeLongDoubleFlags (void)
{
  IBMLongDouble = false;
  IEEELongDouble = false;
  switch (m2configure_TargetIEEEQuadDefault ())
    {
      case -1:
        break;

      case 0:
        IBMLongDouble = true;
        break;

      case 1:
        IEEELongDouble = true;
        break;


      default:
        M2Error_InternalError ((const char *) "unexpected value returned from TargetIEEEQuadDefault ()", 55);
        break;
    }
}


/*
   MatchDump - enable/disable dump using value.  It returns TRUE if dump
               is valid.
*/

static bool MatchDump (DynamicStrings_String dump, bool value)
{
  if (DynamicStrings_EqualArray (dump, (const char *) "all", 3))
    {
      DumpDecl = value;
      DumpQuad = value;
      DumpGimple = value;
      return true;
    }
  else if (DynamicStrings_EqualArray (dump, (const char *) "decl", 4))
    {
      /* avoid dangling else.  */
      DumpDecl = value;
      return true;
    }
  else if (DynamicStrings_EqualArray (dump, (const char *) "gimple", 6))
    {
      /* avoid dangling else.  */
      DumpGimple = value;
      return true;
    }
  else if (DynamicStrings_EqualArray (dump, (const char *) "quad", 4))
    {
      /* avoid dangling else.  */
      DumpQuad = value;
      return true;
    }
  return false;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   SetM - set the MFlag.
*/

extern "C" void M2Options_SetM (bool value)
{
  MFlag = value;
}


/*
   GetM - set the MFlag.
*/

extern "C" bool M2Options_GetM (void)
{
  return MFlag;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   SetMM - set the MMFlag.
*/

extern "C" void M2Options_SetMM (bool value)
{
  MMFlag = value;
}


/*
   GetMM - set the MMFlag.
*/

extern "C" bool M2Options_GetMM (void)
{
  return MMFlag;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   SetMF - assigns MFarg to the filename from arg.
*/

extern "C" void M2Options_SetMF (void * arg)
{
  MFarg = DynamicStrings_KillString (MFarg);
  MFarg = DynamicStrings_InitStringCharStar (arg);
}


/*
   GetMF - returns MFarg or NIL if never set.
*/

extern "C" void * M2Options_GetMF (void)
{
  return DynamicStrings_string (MFarg);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   SetM2Prefix - assign arg to M2Prefix.
*/

extern "C" void M2Options_SetM2Prefix (void * arg)
{
  M2Prefix = DynamicStrings_KillString (M2Prefix);
  M2Prefix = DynamicStrings_InitStringCharStar (arg);
}


/*
   GetM2Prefix - return M2Prefix as a C string.
*/

extern "C" void * M2Options_GetM2Prefix (void)
{
  return DynamicStrings_string (M2Prefix);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   SetM2PathName - assign arg to M2PathName.
*/

extern "C" void M2Options_SetM2PathName (void * arg)
{
  M2PathName = DynamicStrings_KillString (M2PathName);
  M2PathName = DynamicStrings_InitStringCharStar (arg);
}


/*
   GetM2PathName - return M2PathName as a C string.
*/

extern "C" void * M2Options_GetM2PathName (void)
{
  return DynamicStrings_string (M2PathName);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   SetPPOnly - set the PPonly (preprocess only) to value.
*/

extern "C" void M2Options_SetPPOnly (bool value)
{
  M2Options_PPonly = value;
}


/*
   GetPPOnly - get the PPonly (preprocess only).
*/

extern "C" bool M2Options_GetPPOnly (void)
{
  return M2Options_PPonly;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   Setc - set the cflag (compile only flag -c) to value.
*/

extern "C" void M2Options_Setc (bool value)
{
  M2Options_cflag = value;
}


/*
   Getc - get the cflag (compile only flag -c).
*/

extern "C" bool M2Options_Getc (void)
{
  return M2Options_cflag;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   SetB - assigns Barg to arg.
*/

extern "C" void M2Options_SetB (void * arg)
{
  Barg = DynamicStrings_KillString (Barg);
  Barg = DynamicStrings_InitStringCharStar (arg);
}


/*
   GetB - returns Barg value as a C string or NIL if it was never set.
*/

extern "C" void * M2Options_GetB (void)
{
  return DynamicStrings_string (Barg);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   SetMD - set the MDFlag to value.
*/

extern "C" void M2Options_SetMD (bool value)
{
  MDFlag = value;
}


/*
   GetMD - return the MDFlag.
*/

extern "C" bool M2Options_GetMD (void)
{
  return MDFlag;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   SetMMD - set the MMDFlag to value.
*/

extern "C" void M2Options_SetMMD (bool value)
{
  MMDFlag = value;
}


/*
   GetMMD - return the MMDFlag.
*/

extern "C" bool M2Options_GetMMD (void)
{
  return MMDFlag;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   SetMQ - adds a quoted target arg to the DepTarget sentence.
*/

extern "C" void M2Options_SetMQ (void * arg)
{
  DepTarget = AddWord (DepTarget, QuoteTarget (DynamicStrings_InitStringCharStar (arg)));
  MQFlag = AddWord (MQFlag, DynamicStrings_Mark (DynamicStrings_InitString ((const char *) "-MQ", 3)));
  MQFlag = AddWord (MQFlag, DynamicStrings_Mark (DynamicStrings_InitStringCharStar (arg)));
}


/*
   GetMQ - returns a C string containing all the -MQ arg values.
*/

extern "C" void * M2Options_GetMQ (void)
{
  return DynamicStrings_string (MQFlag);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   SetMT - adds a target arg to the DepTarget sentence.
*/

extern "C" void M2Options_SetMT (void * arg)
{
  DepTarget = AddWord (DepTarget, DynamicStrings_InitStringCharStar (arg));
  MTFlag = AddWord (MTFlag, DynamicStrings_Mark (DynamicStrings_InitString ((const char *) "-MT", 3)));
  MTFlag = AddWord (MTFlag, DynamicStrings_Mark (DynamicStrings_InitStringCharStar (arg)));
}


/*
   GetMT - returns a C string containing all the -MT arg values.
*/

extern "C" void * M2Options_GetMT (void)
{
  return DynamicStrings_string (MTFlag);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetDepTarget - returns the DepTarget as a C string.
*/

extern "C" void * M2Options_GetDepTarget (void)
{
  return DynamicStrings_string (DepTarget);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   SetMP - set the MPflag to value.
*/

extern "C" void M2Options_SetMP (bool value)
{
  MPFlag = value;
}


/*
   GetMP - get the MPflag.
*/

extern "C" bool M2Options_GetMP (void)
{
  return MPFlag;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   SetObj - assigns CmdLineObj to the filename from arg.
*/

extern "C" void M2Options_SetObj (void * arg)
{
  CmdLineObj = DynamicStrings_KillString (CmdLineObj);
  CmdLineObj = DynamicStrings_InitStringCharStar (arg);
}


/*
   GetObj - returns CmdLineObj filename as a c-string or NIL if it was never set.
*/

extern "C" void * M2Options_GetObj (void)
{
  return DynamicStrings_string (CmdLineObj);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   SetCpp - enables the source to be preprocessed and enables the
            recognition of C preprocessor line directives.
*/

extern "C" bool M2Options_SetCpp (bool value)
{
  M2Options_CPreProcessor = value;
  M2Options_LineDirectives = value;
  return true;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetCpp - returns TRUE if the C preprocessor was used.
*/

extern "C" bool M2Options_GetCpp (void)
{
  return M2Options_CPreProcessor;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetLineDirectives - returns TRUE if line directives are allowed.
*/

extern "C" bool M2Options_GetLineDirectives (void)
{
  return M2Options_LineDirectives;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   SetScaffoldDynamic - set the -fscaffold-dynamic flag.
*/

extern "C" void M2Options_SetScaffoldDynamic (bool value)
{
  M2Options_ScaffoldDynamic = value;
  if (M2Options_ScaffoldDynamic)
    {
      M2Options_ScaffoldStatic = false;
    }
}


/*
   SetScaffoldStatic - set the -fscaffold-static flag.
*/

extern "C" void M2Options_SetScaffoldStatic (bool value)
{
  M2Options_ScaffoldStatic = value;
  if (M2Options_ScaffoldStatic)
    {
      M2Options_ScaffoldDynamic = false;
    }
}


/*
   GetScaffoldDynamic - get the -fscaffold-dynamic flag.
*/

extern "C" bool M2Options_GetScaffoldDynamic (void)
{
  return M2Options_ScaffoldDynamic;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetScaffoldStatic - get the -fscaffold-static flag.
*/

extern "C" bool M2Options_GetScaffoldStatic (void)
{
  return M2Options_ScaffoldStatic;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   SetScaffoldMain - set the -fscaffold-main flag.
*/

extern "C" void M2Options_SetScaffoldMain (bool value)
{
  M2Options_ScaffoldMain = value;
}


/*
   SetRuntimeModuleOverride - set the override sequence used for module
                              initialization and finialization.
*/

extern "C" void M2Options_SetRuntimeModuleOverride (void * override)
{
  RuntimeModuleOverride = DynamicStrings_KillString (RuntimeModuleOverride);
  RuntimeModuleOverride = DynamicStrings_InitStringCharStar (override);
}


/*
   GetRuntimeModuleOverride - return a string containing any user override
                              or the default module initialization override
                              sequence.
*/

extern "C" void * M2Options_GetRuntimeModuleOverride (void)
{
  return DynamicStrings_string (RuntimeModuleOverride);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   SetUselist - set the uselist flag to value and remember the filename.
*/

extern "C" void M2Options_SetUselist (bool value, void * filename)
{
  UselistFlag = value;
  UselistFilename = DynamicStrings_KillString (UselistFilename);
  if (filename != NULL)
    {
      UselistFilename = DynamicStrings_InitStringCharStar (filename);
    }
}


/*
   GetUselist - return the uselist flag.
*/

extern "C" bool M2Options_GetUselist (void)
{
  return UselistFlag;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetUselistFilename - return the uselist filename as a String.
*/

extern "C" DynamicStrings_String M2Options_GetUselistFilename (void)
{
  return UselistFilename;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   SetWholeProgram - sets the WholeProgram flag (-fwhole-program).
*/

extern "C" void M2Options_SetWholeProgram (bool value)
{
  M2Options_WholeProgram = value;
}


/*
   SetAutoInit - -fauto-init turns on automatic initialization of pointers to NIL.
                  TRUE is returned.
*/

extern "C" bool M2Options_SetAutoInit (bool value)
{
  M2Options_AutoInit = value;
  return true;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   SetReturnCheck -
*/

extern "C" bool M2Options_SetReturnCheck (bool value)
{
  M2Options_ReturnChecking = value;
  return true;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   SetNilCheck -
*/

extern "C" bool M2Options_SetNilCheck (bool value)
{
  M2Options_NilChecking = value;
  return true;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   SetCaseCheck - set else case checking to, value.
*/

extern "C" bool M2Options_SetCaseCheck (bool value)
{
  M2Options_CaseElseChecking = value;
  return true;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   SetCheckAll - set all runtime checking to, value.
*/

extern "C" bool M2Options_SetCheckAll (bool value)
{
  M2Options_NilChecking = value;
  M2Options_WholeDivChecking = value;
  M2Options_IndexChecking = value;
  M2Options_RangeChecking = value;
  M2Options_ReturnChecking = value;
  M2Options_NilChecking = value;
  M2Options_CaseElseChecking = value;
  M2Options_FloatValueChecking = value;
  M2Options_WholeValueChecking = value;
  return true;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   SetVerboseUnbounded - sets the VerboseUnbounded flag to, value.
*/

extern "C" bool M2Options_SetVerboseUnbounded (bool value)
{
  M2Options_VerboseUnbounded = value;
  return true;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   SetQuiet - sets the quiet flag to, value.
*/

extern "C" bool M2Options_SetQuiet (bool value)
{
  M2Options_Quiet = value;
  return true;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   SetCC1Quiet - sets the cc1quiet flag to, value.
*/

extern "C" void M2Options_SetCC1Quiet (bool value)
{
  CC1Quiet = value;
}


/*
   SetM2g - set GenerateStatementNote to value and return value.
            Corresponds to the -fm2-g flag.
*/

extern "C" bool M2Options_SetM2g (bool value)
{
  M2Options_GenerateStatementNote = value;
  return M2Options_GenerateStatementNote;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetM2g - returns TRUE if the -fm2-g flags was used.
*/

extern "C" bool M2Options_GetM2g (void)
{
  return M2Options_GenerateStatementNote;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   SetLowerCaseKeywords - set the lower case keyword flag and return the result.
*/

extern "C" bool M2Options_SetLowerCaseKeywords (bool value)
{
  M2Options_LowerCaseKeywords = value;
  return M2Options_LowerCaseKeywords;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   SetUnboundedByReference -
*/

extern "C" bool M2Options_SetUnboundedByReference (bool value)
{
  M2Options_UnboundedByReference = value;
  return true;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   SetSearchPath -
*/

extern "C" void M2Options_SetSearchPath (void * arg)
{
  DynamicStrings_String s;

  s = DynamicStrings_InitStringCharStar (arg);
  PathName_AddInclude (M2PathName, s);
  if (Debugging)
    {
      PathName_DumpPathName ((const char *) "path name entries: ", 19);
    }
  s = DynamicStrings_KillString (s);
}


/*
   SetISO -
*/

extern "C" void M2Options_SetISO (bool value)
{
  M2Options_Iso = value;
  M2Options_Pim = ! value;
  M2Options_Pim2 = ! value;
}


/*
   SetPIM -
*/

extern "C" void M2Options_SetPIM (bool value)
{
  M2Options_Pim = value;
  M2Options_Iso = ! value;
}


/*
   SetPIM2 -
*/

extern "C" void M2Options_SetPIM2 (bool value)
{
  M2Options_Pim = value;
  M2Options_Pim2 = value;
  M2Options_Iso = ! value;
  if (value)
    {
      /* Pim4 is the default, turn it off.  */
      M2Options_Pim4 = false;
    }
}


/*
   SetPIM3 -
*/

extern "C" void M2Options_SetPIM3 (bool value)
{
  M2Options_Pim = value;
  M2Options_Pim3 = value;
  M2Options_Iso = ! value;
  if (value)
    {
      /* Pim4 is the default, turn it off.  */
      M2Options_Pim4 = false;
    }
}


/*
   SetPIM4 -
*/

extern "C" void M2Options_SetPIM4 (bool value)
{
  M2Options_Pim = value;
  M2Options_Pim4 = value;
  M2Options_Iso = ! value;
}


/*
   SetPositiveModFloor - sets the positive mod floor option.
*/

extern "C" void M2Options_SetPositiveModFloor (bool value)
{
  M2Options_PositiveModFloorDiv = value;
}


/*
   SetWholeDiv - sets the whole division flag.
*/

extern "C" void M2Options_SetWholeDiv (bool value)
{
  M2Options_WholeDivChecking = value;
}


/*
   SetIndex - sets the runtime array index checking flag.
*/

extern "C" void M2Options_SetIndex (bool value)
{
  M2Options_IndexChecking = value;
}


/*
   SetRange -  sets the runtime range checking flag.
*/

extern "C" void M2Options_SetRange (bool value)
{
  M2Options_RangeChecking = value;
}


/*
   SetExceptions - sets the enable runtime exceptions flag.
*/

extern "C" void M2Options_SetExceptions (bool value)
{
  M2Options_Exceptions = value;
}


/*
   SetStyle -
*/

extern "C" void M2Options_SetStyle (bool value)
{
  M2Options_StyleChecking = value;
}


/*
   SetPedantic -
*/

extern "C" void M2Options_SetPedantic (bool value)
{
  M2Options_Pedantic = value;
}


/*
   SetPedanticParamNames - sets the pedantic parameter name flag.
*/

extern "C" void M2Options_SetPedanticParamNames (bool value)
{
  M2Options_PedanticParamNames = value;
}


/*
   SetPedanticCast - sets the pedantic cast flag.
*/

extern "C" void M2Options_SetPedanticCast (bool value)
{
  M2Options_PedanticCast = value;
}


/*
   SetExtendedOpaque - sets the ExtendedOpaque flag.
*/

extern "C" void M2Options_SetExtendedOpaque (bool value)
{
  M2Options_ExtendedOpaque = value;
}


/*
   SetXCode - sets the xcode flag.
*/

extern "C" void M2Options_SetXCode (bool value)
{
  M2Options_Xcode = value;
}


/*
   SetCompilerDebugging - turn on internal compiler debugging.
                          Enabled via the command line option -fd.
*/

extern "C" void M2Options_SetCompilerDebugging (bool value)
{
  M2Options_CompilerDebugging = value;
}


/*
   SetQuadDebugging - display the quadruples (internal debugging).
*/

extern "C" void M2Options_SetQuadDebugging (bool value)
{
  DumpQuad = value;
  DumpQuadFilename = DynamicStrings_KillString (DumpQuadFilename);
  DumpQuadFilename = DynamicStrings_InitString ((const char *) "-", 1);
}


/*
   SetM2DebugTraceFilter - set internal debug flags.  The flags should be
                           specified as a comma separated list.  The full
                           list allowed is quad,line,token,all.
*/

extern "C" void M2Options_SetM2DebugTraceFilter (bool value, void * filter)
{
  DynamicStrings_String word;
  DynamicStrings_String full;
  int start;
  int i;

  full = DynamicStrings_InitStringCharStar (filter);
  start = 0;
  do {
    i = DynamicStrings_Index (full, ',', static_cast<unsigned int> (start));
    if (i == -1)
      {
        word = DynamicStrings_Slice (full, start, 0);
      }
    else
      {
        word = DynamicStrings_Slice (full, start, i);
      }
    SetM2DebugTrace (word, value);
    word = DynamicStrings_KillString (word);
    start = i+1;
  } while (! (i == -1));
  full = DynamicStrings_KillString (full);
}


/*
   SetDebugFunctionLineNumbers - set DebugFunctionLineNumbers.
*/

extern "C" void M2Options_SetDebugFunctionLineNumbers (bool value)
{
  DebugFunctionLineNumbers = value;
}


/*
   SetGenerateStatementNote - turn on generation of nops if necessary
                              to generate pedalogical single stepping.
*/

extern "C" void M2Options_SetGenerateStatementNote (bool value)
{
  M2Options_GenerateStatementNote = value;
}


/*
   SetSources -
*/

extern "C" void M2Options_SetSources (bool value)
{
  M2Options_Quiet = ! value;
  SeenSources = value;
}


/*
   SetDumpSystemExports -
*/

extern "C" void M2Options_SetDumpSystemExports (bool value)
{
  M2Options_DumpSystemExports = value;
}


/*
   SetSwig -
*/

extern "C" void M2Options_SetSwig (bool value)
{
  M2Options_GenerateSwig = value;
}


/*
   SetOptimizing -
*/

extern "C" void M2Options_SetOptimizing (unsigned int value)
{
  if (value > 0)
    {
      M2Options_Optimizing = true;
      M2Options_OptimizeBasicBlock = true;
      M2Options_OptimizeUncalledProcedures = true;
      M2Options_OptimizeCommonSubExpressions = true;
    }
  else
    {
      M2Options_Optimizing = false;
      M2Options_OptimizeBasicBlock = false;
      M2Options_OptimizeUncalledProcedures = false;
      M2Options_OptimizeCommonSubExpressions = false;
    }
}


/*
   OverrideLocation - possibly override the location value, depending upon
                      whether the -flocation= option was used.
*/

extern "C" location_t M2Options_OverrideLocation (location_t location)
{
  if (M2Options_ForcedLocation)
    {
      return ForcedLocationValue;
    }
  else
    {
      return location;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   SetForcedLocation - sets the location for the lifetime of this compile to, location.
                       This is primarily an internal debugging switch.
*/

extern "C" void M2Options_SetForcedLocation (location_t location)
{
  M2Options_ForcedLocation = true;
  ForcedLocationValue = location;
}


/*
   SetUnusedVariableChecking - assigns the UnusedVariableChecking to value.
*/

extern "C" void M2Options_SetUnusedVariableChecking (bool value)
{
  M2Options_UnusedVariableChecking = value;
}


/*
   SetUnusedParameterChecking - assigns the UnusedParameterChecking to value.
*/

extern "C" void M2Options_SetUnusedParameterChecking (bool value)
{
  M2Options_UnusedParameterChecking = value;
}


/*
   SetStrictTypeChecking - assigns the StrictTypeChecking flag to value.
*/

extern "C" void M2Options_SetStrictTypeChecking (bool value)
{
  M2Options_StrictTypeChecking = value;
}


/*
   SetStrictTypeAssignment - assigns the StrictTypeAssignment flag to value.
*/

extern "C" void M2Options_SetStrictTypeAssignment (bool value)
{
  M2Options_StrictTypeAssignment = value;
}


/*
   SetStrictTypeReason - assigns the StrictTypeReason flag to value.
*/

extern "C" void M2Options_SetStrictTypeReason (bool value)
{
  M2Options_StrictTypeReason = value;
}


/*
   setdefextension - set the source file definition module extension to arg.
                     This should include the . and by default it is set to .def.
*/

extern "C" void M2Options_setdefextension (void * arg)
{
  DynamicStrings_String s;

  s = DynamicStrings_InitStringCharStar (arg);
  M2Search_SetDefExtension (s);
  s = DynamicStrings_KillString (s);
}


/*
   setmodextension - set the source file module extension to arg.
                     This should include the . and by default it is set to .mod.
*/

extern "C" void M2Options_setmodextension (void * arg)
{
  DynamicStrings_String s;

  s = DynamicStrings_InitStringCharStar (arg);
  M2Search_SetModExtension (s);
  s = DynamicStrings_KillString (s);
}


/*
   SetStatistics - turn on/off generate of compile time statistics.
*/

extern "C" void M2Options_SetStatistics (bool on)
{
  M2Options_Statistics = on;
}


/*
   SetVerbose - set the Verbose flag to, value.  It returns TRUE.
*/

extern "C" bool M2Options_SetVerbose (bool value)
{
  M2Options_Verbose = value;
  return true;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   CppArg - sets the option and arg in the cpp command line.
*/

extern "C" void M2Options_CppArg (void * opt, void * arg, bool joined)
{
  DynamicStrings_String s;

  s = DynamicStrings_InitStringCharStar (opt);
  if ((DynamicStrings_EqualArray (s, (const char *) "-fcpp-begin", 11)) || (DynamicStrings_EqualArray (s, (const char *) "-fcpp-end", 9)))
    {}  /* empty.  */
  else
    {
      /* do nothing  */
      if (! (DynamicStrings_EqualArray (CppArgs, (const char *) "", 0)))
        {
          CppArgs = DynamicStrings_ConCatChar (CppArgs, ' ');
        }
      CppArgs = DynamicStrings_ConCat (CppArgs, DynamicStrings_Mark (s));
      if (arg != NULL)
        {
          s = DynamicStrings_InitStringCharStar (arg);
          if (! joined)
            {
              CppArgs = DynamicStrings_ConCatChar (CppArgs, ' ');
            }
          CppArgs = DynamicStrings_ConCat (CppArgs, s);
        }
    }
}


/*
   CppCommandLine - returns the Cpp command line and all arguments.
                    NIL is returned if the -fcpp is absent.
*/

extern "C" DynamicStrings_String M2Options_CppCommandLine (void)
{
  DynamicStrings_String s;

  if (M2Options_CPreProcessor)
    {
      s = DynamicStrings_InitStringCharStar (m2configure_FullPathCPP ());
      s = DynamicStrings_ConCat (DynamicStrings_ConCatChar (s, ' '), CppArgs);
      if (CC1Quiet)
        {
          s = DynamicStrings_ConCat (DynamicStrings_ConCatChar (s, ' '), DynamicStrings_Mark (DynamicStrings_InitString ((const char *) "-quiet", 6)));
        }
      return s;
    }
  else
    {
      return static_cast<DynamicStrings_String> (NULL);
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   CppRemember - remember a string, s, as a cpp related argument.
                 The string, s, is not garbage collected.
*/

extern "C" void M2Options_CppRemember (DynamicStrings_String s)
{
  if ((CppArgs == NULL) || (DynamicStrings_EqualArray (CppArgs, (const char *) "", 0)))
    {
      CppArgs = DynamicStrings_Dup (s);
    }
  else
    {
      CppArgs = DynamicStrings_ConCatChar (CppArgs, ' ');
      CppArgs = DynamicStrings_ConCat (CppArgs, s);
    }
}


/*
   GetISO - return TRUE if -fiso was present on the command line.
*/

extern "C" bool M2Options_GetISO (void)
{
  return M2Options_Iso;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetPIM - return TRUE if -fpim was present on the command line.
*/

extern "C" bool M2Options_GetPIM (void)
{
  return M2Options_Pim;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetPIM2 - return TRUE if -fpim2 was present on the command line.
*/

extern "C" bool M2Options_GetPIM2 (void)
{
  return M2Options_Pim2;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetPIM3 - return TRUE if -fpim3 was present on the command line.
*/

extern "C" bool M2Options_GetPIM3 (void)
{
  return M2Options_Pim3;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetPIM4 - return TRUE if -fpim4 was present on the command line.
*/

extern "C" bool M2Options_GetPIM4 (void)
{
  return M2Options_Pim4;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetPositiveModFloor - return TRUE if -fpositive-mod-floor was present
                         on the command line.
*/

extern "C" bool M2Options_GetPositiveModFloor (void)
{
  return M2Options_PositiveModFloorDiv;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetFloatValueCheck - return TRUE if -ffloatvalue was present on the
                        command line.
*/

extern "C" bool M2Options_GetFloatValueCheck (void)
{
  return M2Options_FloatValueChecking;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   SetFloatValueCheck - set depending upon the -ffloatvalue.
*/

extern "C" void M2Options_SetFloatValueCheck (bool value)
{
  M2Options_FloatValueChecking = value;
}


/*
   GetWholeValueCheck - return TRUE if -fwholevalue was present on the
                        command line.
*/

extern "C" bool M2Options_GetWholeValueCheck (void)
{
  return M2Options_WholeValueChecking;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   SetWholeValueCheck - set depending upon the -fwholevalue.
*/

extern "C" void M2Options_SetWholeValueCheck (bool value)
{
  M2Options_WholeValueChecking = value;
}


/*
   SetWall - set all warnings to, value.
*/

extern "C" void M2Options_SetWall (bool value)
{
  M2Options_UnusedVariableChecking = value;
  M2Options_UnusedParameterChecking = value;
  M2Options_UninitVariableChecking = value;
  M2Options_PedanticCast = value;
  M2Options_PedanticParamNames = value;
  M2Options_StyleChecking = value;
  M2Options_CaseEnumChecking = value;
}


/*
   SetSaveTemps - turn on/off -save-temps.
*/

extern "C" void M2Options_SetSaveTemps (bool value)
{
  M2Options_SaveTemps = value;
}


/*
   SetSaveTempsDir - turn on/off -save-temps and specify the directory.
*/

extern "C" void M2Options_SetSaveTempsDir (void * arg)
{
  SaveTempsDir = DynamicStrings_InitStringCharStar (arg);
  M2Options_SaveTemps = true;
}


/*
   GetSaveTempsDir - return SaveTempsDir or NIL if -save-temps was not used.
*/

extern "C" DynamicStrings_String M2Options_GetSaveTempsDir (void)
{
  return SaveTempsDir;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   SetDumpDir - Set the dump dir.
*/

extern "C" void M2Options_SetDumpDir (void * arg)
{
  DumpDir = DynamicStrings_InitStringCharStar (arg);
}


/*
   GetDumpDir - return DumpDir or NIL.
*/

extern "C" DynamicStrings_String M2Options_GetDumpDir (void)
{
  return DumpDir;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   SetGenModuleList - set the GenModuleList flag to true and pass
                      set GenModuleListFilename to filename.
*/

extern "C" void M2Options_SetGenModuleList (bool value, void * filename)
{
  GenModuleListFilename = DynamicStrings_KillString (GenModuleListFilename);
  if (filename != NULL)
    {
      GenModuleListFilename = DynamicStrings_InitStringCharStar (filename);
    }
  M2Options_GenModuleList = value;
}


/*
   GetGenModuleFilename - returns the filename set by SetGenModuleList.
*/

extern "C" DynamicStrings_String M2Options_GetGenModuleFilename (void)
{
  return GenModuleListFilename;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   SetShared - sets the SharedFlag to value.
*/

extern "C" void M2Options_SetShared (bool value)
{
  M2Options_SharedFlag = value;
}


/*
   SetUninitVariableChecking - sets the UninitVariableChecking and
                               UninitVariableConditionalChecking flags to value
                               depending upon arg string.  The arg string
                               can be: "all", "known,cond", "cond,known", "known"
                               or "cond".
*/

extern "C" int M2Options_SetUninitVariableChecking (bool value, void * arg)
{
  DynamicStrings_String s;

  if (Debugging)
    {
      /* avoid gcc warning by using compound statement even if not strictly necessary.  */
      if (value)
        {
          libc_printf ((const char *) "SetUninitVariableChecking (TRUE, %s)\\n", 38, arg);
        }
      else
        {
          libc_printf ((const char *) "SetUninitVariableChecking (FALSE, %s)\\n", 39, arg);
        }
    }
  s = DynamicStrings_InitStringCharStar (arg);
  if (((DynamicStrings_EqualArray (s, (const char *) "all", 3)) || (DynamicStrings_EqualArray (s, (const char *) "known,cond", 10))) || (DynamicStrings_EqualArray (s, (const char *) "cond,known", 10)))
    {
      M2Options_UninitVariableChecking = value;
      M2Options_UninitVariableConditionalChecking = value;
      s = DynamicStrings_KillString (s);
      return 1;
    }
  else if (DynamicStrings_EqualArray (s, (const char *) "known", 5))
    {
      /* avoid dangling else.  */
      M2Options_UninitVariableChecking = value;
      s = DynamicStrings_KillString (s);
      return 1;
    }
  else if (DynamicStrings_EqualArray (s, (const char *) "cond", 4))
    {
      /* avoid dangling else.  */
      M2Options_UninitVariableConditionalChecking = value;
      s = DynamicStrings_KillString (s);
      return 1;
    }
  else
    {
      /* avoid dangling else.  */
      s = DynamicStrings_KillString (s);
      return 0;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   SetCaseEnumChecking - sets the CaseEnumChecking to value.
*/

extern "C" void M2Options_SetCaseEnumChecking (bool value)
{
  M2Options_CaseEnumChecking = value;
}


/*
   SetDebugBuiltins - sets the DebugBuiltins to value.
*/

extern "C" void M2Options_SetDebugBuiltins (bool value)
{
  M2Options_DebugBuiltins = value;
}


/*
   SetIBMLongDouble - enable/disable LONGREAL to map onto the
                      IBM long double 128 bit data type.
                      (Only available on the ppc).
*/

extern "C" void M2Options_SetIBMLongDouble (bool value)
{
  IBMLongDouble = value;
  if (value)
    {
      IEEELongDouble = false;
    }
}


/*
   GetIBMLongDouble - return the value of IBMLongDouble.
*/

extern "C" bool M2Options_GetIBMLongDouble (void)
{
  return IBMLongDouble;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   SetIEEELongDouble - enable/disable LONGREAL to map onto the
                       IEEE long double 128 bit data type.
                       (Only available on the ppc).
*/

extern "C" void M2Options_SetIEEELongDouble (bool value)
{
  IEEELongDouble = value;
  if (value)
    {
      IBMLongDouble = false;
    }
}


/*
   GetIEEELongDouble - return the value of IEEELongDouble.
*/

extern "C" bool M2Options_GetIEEELongDouble (void)
{
  return IEEELongDouble;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetDumpDeclFilename - returns the DumpDeclFilename.
*/

extern "C" DynamicStrings_String M2Options_GetDumpDeclFilename (void)
{
  return DumpDeclFilename;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   SetDumpDeclFilename -
*/

extern "C" void M2Options_SetDumpDeclFilename (bool value, void * filename)
{
  DumpDecl = value;
  DumpDeclFilename = DynamicStrings_KillString (DumpDeclFilename);
  if (filename != NULL)
    {
      DumpDeclFilename = DynamicStrings_InitStringCharStar (filename);
    }
}


/*
   GetDumpQuadFilename - returns the DumpQuadFilename.
*/

extern "C" DynamicStrings_String M2Options_GetDumpQuadFilename (void)
{
  return DumpQuadFilename;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   SetDumpQuadFilename -
*/

extern "C" void M2Options_SetDumpQuadFilename (bool value, void * filename)
{
  DumpQuad = value;
  DumpQuadFilename = DynamicStrings_KillString (DumpQuadFilename);
  if (filename != NULL)
    {
      DumpQuadFilename = DynamicStrings_InitStringCharStar (filename);
    }
}


/*
   GetDumpGimpleFilename - returns the DumpGimpleFilename.
*/

extern "C" DynamicStrings_String M2Options_GetDumpGimpleFilename (void)
{
  return DumpGimpleFilename;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   SetDumpGimpleFilename - set DumpGimpleFilename to filename.
*/

extern "C" void M2Options_SetDumpGimpleFilename (bool value, void * filename)
{
  DumpGimple = value;
  DumpGimpleFilename = DynamicStrings_KillString (DumpGimpleFilename);
  if (value && (filename != NULL))
    {
      DumpGimpleFilename = DynamicStrings_InitStringCharStar (filename);
    }
}


/*
   SetM2DumpFilter - sets the filter to a comma separated list of procedures
                     and modules.  Not to be confused with SetM2Dump below
                     which enables the class of data structures to be dumped.
*/

extern "C" void M2Options_SetM2DumpFilter (bool value, void * filter)
{
  M2DumpFilter = DynamicStrings_KillString (M2DumpFilter);
  if (value && (filter != NULL))
    {
      M2DumpFilter = DynamicStrings_InitStringCharStar (filter);
    }
}


/*
   GetM2DumpFilter - returns the dump filter.
*/

extern "C" void * M2Options_GetM2DumpFilter (void)
{
  if (M2DumpFilter == NULL)
    {
      return NULL;
    }
  else
    {
      return DynamicStrings_string (M2DumpFilter);
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   SetM2Dump - sets the dump via a comma separated list: quad,decl,gimple,all.
               It returns TRUE if the comma separated list is valid.
*/

extern "C" bool M2Options_SetM2Dump (bool value, void * filter)
{
  bool result;
  DynamicStrings_String dump;
  int start;
  int i;

  if (filter == NULL)
    {
      return false;
    }
  if (M2Dump != NULL)
    {
      M2Dump = DynamicStrings_KillString (M2Dump);
    }
  M2Dump = DynamicStrings_InitStringCharStar (filter);
  start = 0;
  do {
    i = DynamicStrings_Index (M2Dump, ',', static_cast<unsigned int> (start));
    if (i == -1)
      {
        dump = DynamicStrings_Slice (M2Dump, start, 0);
      }
    else
      {
        dump = DynamicStrings_Slice (M2Dump, start, i);
      }
    result = MatchDump (dump, value);
    dump = DynamicStrings_KillString (dump);
    if (! result)
      {
        return false;
      }
    start = i+1;
  } while (! (i == -1));
  return true;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetDumpGimple - return TRUE if the dump gimple flag is set from SetM2Dump.
*/

extern "C" bool M2Options_GetDumpGimple (void)
{
  return DumpGimple;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetDumpQuad - return TRUE if the dump quad flag is set from SetM2Dump.
*/

extern "C" bool M2Options_GetDumpQuad (void)
{
  return DumpQuad;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetDumpDecl - return TRUE if the dump decl flag is set from SetM2Dump.
*/

extern "C" bool M2Options_GetDumpDecl (void)
{
  return DumpDecl;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetDebugTraceQuad - return DebugTraceQuad.
*/

extern "C" bool M2Options_GetDebugTraceQuad (void)
{
  return DebugTraceQuad;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetDebugTraceTree - return DebugTraceTree.
*/

extern "C" bool M2Options_GetDebugTraceTree (void)
{
  return DebugTraceTree;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetDebugTraceToken - return DebugTraceToken.
*/

extern "C" bool M2Options_GetDebugTraceToken (void)
{
  return DebugTraceToken;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetDebugTraceLine - return DebugTraceLine.
*/

extern "C" bool M2Options_GetDebugTraceLine (void)
{
  return DebugTraceLine;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetDebugFunctionLineNumbers - return DebugFunctionLineNumbers.
*/

extern "C" bool M2Options_GetDebugFunctionLineNumbers (void)
{
  return DebugFunctionLineNumbers;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetEnableForward - return EnableForward.
*/

extern "C" bool M2Options_GetEnableForward (void)
{
  return EnableForward;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   SetEnableForward - set EnableForward to value.
*/

extern "C" void M2Options_SetEnableForward (bool value)
{
  EnableForward = value;
}


/*
   SetFileOffsetBits - create SYSTEM.COFF_T as a signed integer of size bits.
*/

extern "C" bool M2Options_SetFileOffsetBits (bool value, unsigned int bits)
{
  if (value)
    {
      OffTBits = bits;
    }
  return true;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   GetFileOffsetBits - return the number of bits used to create SYSTEM.COFF_T.
*/

extern "C" unsigned int M2Options_GetFileOffsetBits (void)
{
  return OffTBits;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   FinaliseOptions - once all options have been parsed we set any inferred
                     values.
*/

extern "C" void M2Options_FinaliseOptions (void)
{
  /* currently only one value, this could be make an option in the future  */
  M2Options_VariantValueChecking = M2Options_Iso;
}

extern "C" void _M2_M2Options_init (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
  M2Options_cflag = false;  /* -c.  */
  RuntimeModuleOverride = DynamicStrings_InitString ((const char *) "m2iso:RTentity,m2iso:Storage,m2iso:SYSTEM,m2iso:M2RTS,m2iso:RTExceptions,m2iso:IOLink", 85);  /* -c.  */
  CppArgs = DynamicStrings_InitString ((const char *) "", 0);
  M2Options_Pim = true;
  M2Options_Pim2 = false;
  M2Options_Pim3 = false;
  M2Options_Pim4 = true;
  M2Options_PositiveModFloorDiv = false;
  M2Options_Iso = false;
  SeenSources = false;
  M2Options_Statistics = false;
  M2Options_StyleChecking = false;
  M2Options_CompilerDebugging = false;
  M2Options_GenerateDebugging = false;
  M2Options_Optimizing = false;
  M2Options_Pedantic = false;
  M2Options_Verbose = false;
  M2Options_Quiet = true;
  CC1Quiet = true;
  M2Options_Profiling = false;
  DumpQuad = false;
  M2Options_OptimizeBasicBlock = false;
  M2Options_OptimizeUncalledProcedures = false;
  M2Options_OptimizeCommonSubExpressions = false;
  M2Options_NilChecking = false;
  M2Options_WholeDivChecking = false;
  M2Options_WholeValueChecking = false;
  M2Options_FloatValueChecking = false;
  M2Options_IndexChecking = false;
  M2Options_RangeChecking = false;
  M2Options_ReturnChecking = false;
  M2Options_CaseElseChecking = false;
  M2Options_CPreProcessor = false;
  M2Options_LineDirectives = true;
  M2Options_ExtendedOpaque = false;
  M2Options_UnboundedByReference = false;
  M2Options_VerboseUnbounded = false;
  M2Options_PedanticParamNames = false;
  M2Options_PedanticCast = false;
  M2Options_Xcode = false;
  M2Options_DumpSystemExports = false;
  M2Options_GenerateSwig = false;
  M2Options_Exceptions = true;
  M2Options_DebugBuiltins = false;
  M2Options_ForcedLocation = false;
  M2Options_WholeProgram = false;
  DebugTraceQuad = false;
  DebugTraceTree = false;
  DebugTraceLine = false;
  DebugTraceToken = false;
  DebugFunctionLineNumbers = false;
  M2Options_GenerateStatementNote = false;
  M2Options_LowerCaseKeywords = false;
  M2Options_UnusedVariableChecking = false;
  M2Options_UnusedParameterChecking = false;
  M2Options_StrictTypeChecking = true;
  M2Options_StrictTypeAssignment = true;
  M2Options_StrictTypeReason = true;
  M2Options_AutoInit = false;
  M2Options_SaveTemps = false;
  M2Options_ScaffoldDynamic = true;
  M2Options_ScaffoldStatic = false;
  M2Options_ScaffoldMain = false;
  UselistFilename = static_cast<DynamicStrings_String> (NULL);
  M2Options_GenModuleList = false;
  GenModuleListFilename = static_cast<DynamicStrings_String> (NULL);
  M2Options_SharedFlag = false;
  Barg = static_cast<DynamicStrings_String> (NULL);
  MDFlag = false;
  MMDFlag = false;
  DepTarget = static_cast<DynamicStrings_String> (NULL);
  MPFlag = false;
  SaveTempsDir = static_cast<DynamicStrings_String> (NULL);
  DumpDir = static_cast<DynamicStrings_String> (NULL);
  M2Options_UninitVariableChecking = false;
  M2Options_UninitVariableConditionalChecking = false;
  M2Options_CaseEnumChecking = false;
  MFlag = false;
  MMFlag = false;
  MFarg = static_cast<DynamicStrings_String> (NULL);
  MTFlag = static_cast<DynamicStrings_String> (NULL);
  MQFlag = static_cast<DynamicStrings_String> (NULL);
  InitializeLongDoubleFlags ();
  M2Prefix = DynamicStrings_InitString ((const char *) "", 0);
  M2PathName = DynamicStrings_InitString ((const char *) "", 0);
  DumpQuadFilename = static_cast<DynamicStrings_String> (NULL);
  DumpGimpleFilename = static_cast<DynamicStrings_String> (NULL);
  DumpDeclFilename = static_cast<DynamicStrings_String> (NULL);
  DumpDecl = false;
  DumpQuad = false;
  DumpGimple = false;
  M2Dump = static_cast<DynamicStrings_String> (NULL);
  M2DumpFilter = static_cast<DynamicStrings_String> (NULL);
  EnableForward = true;
  OffTBits = 0;  /* Default to CSSIZE_T.  */
}

extern "C" void _M2_M2Options_fini (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
}
