/* do not edit automatically generated by mc from M2SSA.  */
/* M2SSA.mod discover very obvious single assignment temporaries.

Copyright (C) 2021-2025 Free Software Foundation, Inc.
Contributed by Gaius Mulley <gaius.mulley@southwales.ac.uk>.

This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GNU Modula-2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Modula-2; see the file COPYING3.  If not see
<http://www.gnu.org/licenses/>.  */

#include "config.h"
#include "system.h"
#include "gcc-consolidation.h"

#include <stdbool.h>
#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif

#   if !defined (TRUE)
#      define TRUE (1==1)
#   endif

#   if !defined (FALSE)
#      define FALSE (1==0)
#   endif

#define _M2SSA_C

#include "GM2SSA.h"
#   include "GM2Debug.h"
#   include "GNameKey.h"
#   include "GStrIO.h"
#   include "GNumberIO.h"
#   include "GM2Error.h"
#   include "GM2Batch.h"
#   include "GM2Quiet.h"
#   include "GM2Scope.h"
#   include "GM2StackWord.h"
#   include "GM2Options.h"
#   include "GLists.h"
#   include "GM2Printf.h"
#   include "GSymbolTable.h"
#   include "GM2Quads.h"

#   define M2SSA_EnableSSA false
static M2StackWord_StackOfWord stack;
static Lists_List visited;

/*
   DiscoverSSA - perform a very simple check to determine whether a
                 temporary is a single use write.
*/

extern "C" void M2SSA_DiscoverSSA (unsigned int scope);

/*
   writtenOnce - return TRUE if variable is written to once.
*/

static bool writtenOnce (unsigned int variable);

/*
   DetermineSSA - performs a trivial check to see if the temporary is written to
                  once.
*/

static void DetermineSSA (unsigned int variable);

/*
   DiscoverSSATemporaries -
*/

static void DiscoverSSATemporaries (unsigned int scope);


/*
   writtenOnce - return TRUE if variable is written to once.
*/

static bool writtenOnce (unsigned int variable)
{
  unsigned int writeStart;
  unsigned int writeEnd;
  unsigned int readStart;
  unsigned int readEnd;

  SymbolTable_GetWriteQuads (variable, SymbolTable_GetMode (variable), &writeStart, &writeEnd);
  SymbolTable_GetReadQuads (variable, SymbolTable_GetMode (variable), &readStart, &readEnd);
  return (writeStart == writeEnd) && ((readStart > writeStart) || (readStart == 0));
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   DetermineSSA - performs a trivial check to see if the temporary is written to
                  once.
*/

static void DetermineSSA (unsigned int variable)
{
  NameKey_Name name;

  if (M2SSA_EnableSSA && (SymbolTable_IsTemporary (variable)))
    {
      name = SymbolTable_GetSymName (variable);
      if (writtenOnce (variable))
        {
          /* avoid dangling else.  */
          SymbolTable_PutVariableSSA (variable, true);
          if (M2Options_CompilerDebugging)
            {
              M2Printf_printf1 ((const char *) "  temporary:  %a  SSA found\\n", 29, (const unsigned char *) &name, (sizeof (name)-1));
            }
        }
      else
        {
          if (M2Options_CompilerDebugging)
            {
              M2Printf_printf1 ((const char *) "  temporary:  %a  not SSA\\n", 27, (const unsigned char *) &name, (sizeof (name)-1));
            }
        }
    }
}


/*
   DiscoverSSATemporaries -
*/

static void DiscoverSSATemporaries (unsigned int scope)
{
  unsigned int n;
  unsigned int variable;

  if (M2Options_CompilerDebugging)
    {
      M2Printf_printf1 ((const char *) "examining scope %d\\n", 20, (const unsigned char *) &scope, (sizeof (scope)-1));
    }
  n = 1;
  variable = SymbolTable_GetNth (scope, n);
  while (variable != SymbolTable_NulSym)
    {
      DetermineSSA (variable);
      n += 1;
      variable = SymbolTable_GetNth (scope, n);
    }
}


/*
   DiscoverSSA - perform a very simple check to determine whether a
                 temporary is a single use write.
*/

extern "C" void M2SSA_DiscoverSSA (unsigned int scope)
{
  M2Scope_ScopeBlock sb;

  if (! (Lists_IsItemInList (visited, scope)))
    {
      Lists_IncludeItemIntoList (visited, scope);
      sb = M2Scope_InitScopeBlock (scope);
      M2StackWord_PushWord (stack, scope);
      if (M2Options_CompilerDebugging)
        {
          M2Printf_printf1 ((const char *) "DiscoverSSA %d\\n", 16, (const unsigned char *) &scope, (sizeof (scope)-1));
        }
      if (M2Options_CompilerDebugging)
        {
          M2Printf_printf0 ((const char *) "ForeachInnerModuleDo\\n", 22);
        }
      SymbolTable_ForeachInnerModuleDo (scope, (SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) M2SSA_DiscoverSSA});
      if (M2Options_CompilerDebugging)
        {
          M2Printf_printf0 ((const char *) "ForeachProcedureDo\\n", 20);
        }
      SymbolTable_ForeachProcedureDo (scope, (SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) M2SSA_DiscoverSSA});
      DiscoverSSATemporaries (scope);
      M2Debug_Assert ((M2StackWord_PopWord (stack)) == scope);
      M2Scope_KillScopeBlock (&sb);
    }
}

extern "C" void _M2_M2SSA_init (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
  stack = M2StackWord_InitStackWord ();
  Lists_InitList (&visited);
}

extern "C" void _M2_M2SSA_fini (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
}
