/* do not edit automatically generated by mc from SymbolConversion.  */
/* SymbolConversion.mod mapping between m2 symbols and gcc symbols.

Copyright (C) 2001-2025 Free Software Foundation, Inc.
Contributed by Gaius Mulley <gaius.mulley@southwales.ac.uk>.

This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GNU Modula-2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Modula-2; see the file COPYING3.  If not see
<http://www.gnu.org/licenses/>.  */

#include "config.h"
#include "system.h"
#include "gcc-consolidation.h"

#include <stdbool.h>
#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif

#   if !defined (TRUE)
#      define TRUE (1==1)
#   endif

#if defined(__cplusplus)
#   undef NULL
#   define NULL 0
#endif
#define _SymbolConversion_C

#include "GSymbolConversion.h"
#   include "GNameKey.h"
#   include "GIndexing.h"
#   include "GSymbolTable.h"
#   include "GM2Error.h"
#   include "GM2ALU.h"
#   include "Gm2block.h"
#   include "Ggcctypes.h"
#   include "GM2Printf.h"
#   include "GStorage.h"
#   include "GSYSTEM.h"

#   define USEPOISON true
#   define GGCPOISON 0x0A5A5A5A5
typedef unsigned int *SymbolConversion_PtrToCardinal;

static Indexing_Index mod2gcc;
static void * PoisonedSymbol;

/*
   Mod2Gcc - given a modula-2 symbol, sym, return the gcc equivalent.
*/

extern "C" tree SymbolConversion_Mod2Gcc (unsigned int sym);

/*
   Gcc2Mod - given a gcc tree return the modula-2 symbol.
*/

extern "C" unsigned int SymbolConversion_Gcc2Mod (tree tree);

/*
   AddModGcc - adds the tuple [ sym, gcc ] into the database.
*/

extern "C" void SymbolConversion_AddModGcc (unsigned int sym, tree gcc);

/*
   RemoveMod2Gcc - removes the gcc symbol from the lookup table.
*/

extern "C" void SymbolConversion_RemoveMod2Gcc (unsigned int sym);

/*
   GccKnowsAbout - returns TRUE if gcc knows about the symbol, sym.
*/

extern "C" bool SymbolConversion_GccKnowsAbout (unsigned int sym);

/*
   AddTemporaryKnown - adds a temporary gcc symbol against the modula-2 sym.
*/

extern "C" void SymbolConversion_AddTemporaryKnown (unsigned int sym);

/*
   RemoveTemporaryKnown - removes the temporary symbol.
*/

extern "C" void SymbolConversion_RemoveTemporaryKnown (unsigned int sym);

/*
   Poison - poisons a symbol.
*/

extern "C" void SymbolConversion_Poison (unsigned int sym);

/*
   Mod2GccWithoutGCCPoison - given a modula-2 symbol, sym, return
                             the gcc equivalent, it does not check to see
                             whether the gcc symbol has been poisoned.
*/

static tree Mod2GccWithoutGCCPoison (unsigned int sym);

/*
   Init - create both binary trees.
*/

static void Init (void);


/*
   Mod2GccWithoutGCCPoison - given a modula-2 symbol, sym, return
                             the gcc equivalent, it does not check to see
                             whether the gcc symbol has been poisoned.
*/

static tree Mod2GccWithoutGCCPoison (unsigned int sym)
{
  NameKey_Name n;
  tree tr;

  if (Indexing_InBounds (mod2gcc, sym))
    {
      tr = (tree) (Indexing_GetIndice (mod2gcc, sym));
      if (tr == PoisonedSymbol)
        {
          n = SymbolTable_GetSymName (sym);
          /* not poisoned by the garbage collector, but by the gm2 front end.  */
          M2Printf_printf1 ((const char *) "the gm2 front end poisoned this symbol (%a)\\n", 45, (const unsigned char *) &n, (sizeof (n)-1));
          M2Error_InternalError ((const char *) "attempting to use a gcc symbol which is no longer in scope", 58);
        }
      return tr;
    }
  else
    {
      return NULL;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   Init - create both binary trees.
*/

static void Init (void)
{
  mod2gcc = Indexing_InitIndexTuned (1, (1024*1024) / 16, 16);
  Storage_ALLOCATE (&PoisonedSymbol, 1);
}


/*
   Mod2Gcc - given a modula-2 symbol, sym, return the gcc equivalent.
*/

extern "C" tree SymbolConversion_Mod2Gcc (unsigned int sym)
{
  NameKey_Name n;
  SymbolConversion_PtrToCardinal t;
  tree tr;

  if (USEPOISON)
    {
      if (Indexing_InBounds (mod2gcc, sym))
        {
          t = (SymbolConversion_PtrToCardinal) (Indexing_GetIndice (mod2gcc, sym));
          if ((t != NULL) && ((*t) == GGCPOISON))
            {
              M2Error_InternalError ((const char *) "gcc symbol has been poisoned", 28);
            }
        }
    }
  if (Indexing_InBounds (mod2gcc, sym))
    {
      tr = (tree) (Indexing_GetIndice (mod2gcc, sym));
      if (tr == PoisonedSymbol)
        {
          n = SymbolTable_GetSymName (sym);
          /* not poisoned by the garbage collector, but by the gm2 front end  */
          M2Printf_printf1 ((const char *) "the gm2 front end poisoned this symbol (%a)\\n", 45, (const unsigned char *) &n, (sizeof (n)-1));
          M2Error_InternalError ((const char *) "attempting to use a gcc symbol which is no longer in scope", 58);
        }
      return tr;
    }
  else
    {
      return NULL;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   Gcc2Mod - given a gcc tree return the modula-2 symbol.
*/

extern "C" unsigned int SymbolConversion_Gcc2Mod (tree tree)
{
  unsigned int high;
  unsigned int i;

  i = 1;
  high = Indexing_HighIndice (mod2gcc);
  while (i <= high)
    {
      if ((Indexing_GetIndice (mod2gcc, i)) == tree)
        {
          return i;
        }
      i += 1;
    }
  return SymbolTable_NulSym;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   AddModGcc - adds the tuple [ sym, gcc ] into the database.
*/

extern "C" void SymbolConversion_AddModGcc (unsigned int sym, tree gcc)
{
  tree old;
  SymbolConversion_PtrToCardinal t;

  if (gcc == (m2block_GetErrorNode ()))
    {
      M2Error_InternalError ((const char *) "error node generated during symbol conversion", 45);
    }
  if (USEPOISON)
    {
      t = (SymbolConversion_PtrToCardinal) (gcc);
      if ((gcc != ((tree) (NULL))) && ((*t) == GGCPOISON))
        {
          M2Error_InternalError ((const char *) "gcc symbol has been poisoned", 28);
        }
    }
  old = SymbolConversion_Mod2Gcc (sym);
  if (old == ((tree) (NULL)))
    {
      /* absent - add it  */
      Indexing_PutIndice (mod2gcc, sym, gcc);
      if ((Indexing_GetIndice (mod2gcc, sym)) != gcc)
        {
          M2Error_InternalError ((const char *) "failed to add gcc <-> mod2 symbol", 33);
        }
      gcc = m2block_RememberConstant (gcc);
    }
  /* do nothing, as it is already stored  */
  else if (old == gcc)
    {
      /* avoid dangling else.  */
    }
  else if (old == (m2block_GetErrorNode ()))
    {
      /* avoid dangling else.  */
      M2Error_InternalError ((const char *) "replacing a temporary symbol (currently unexpected)", 51);
    }
  else
    {
      /* avoid dangling else.  */
      M2Error_InternalError ((const char *) "should not be replacing a symbol", 32);
    }
  if ((SymbolTable_IsConst (sym)) && (! (SymbolTable_IsValueSolved (sym))))
    {
      M2ALU_PushTypeOfTree (sym, gcc);
      SymbolTable_PopValue (sym);
    }
}


/*
   RemoveMod2Gcc - removes the gcc symbol from the lookup table.
*/

extern "C" void SymbolConversion_RemoveMod2Gcc (unsigned int sym)
{
  Indexing_PutIndice (mod2gcc, sym, NULL);
}


/*
   GccKnowsAbout - returns TRUE if gcc knows about the symbol, sym.
*/

extern "C" bool SymbolConversion_GccKnowsAbout (unsigned int sym)
{
  return (Indexing_InBounds (mod2gcc, sym)) && ((Indexing_GetIndice (mod2gcc, sym)) != NULL);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   AddTemporaryKnown - adds a temporary gcc symbol against the modula-2 sym.
*/

extern "C" void SymbolConversion_AddTemporaryKnown (unsigned int sym)
{
  /* we add the error node against symbol, sym.  We expect it to be retacted later.  */
  Indexing_PutIndice (mod2gcc, sym, m2block_GetErrorNode ());
}


/*
   RemoveTemporaryKnown - removes the temporary symbol.
*/

extern "C" void SymbolConversion_RemoveTemporaryKnown (unsigned int sym)
{
  if ((SymbolConversion_Mod2Gcc (sym)) == (m2block_GetErrorNode ()))
    {
      Indexing_PutIndice (mod2gcc, sym, NULL);
    }
  else
    {
      M2Error_InternalError ((const char *) "attempting to remove a symbol which is not present in the tree", 62);
    }
}


/*
   Poison - poisons a symbol.
*/

extern "C" void SymbolConversion_Poison (unsigned int sym)
{
  void * a;

  if (! (SymbolTable_IsConst (sym)))
    {
      a = Mod2GccWithoutGCCPoison (sym);
      if (a != NULL)
        {
          Indexing_PutIndice (mod2gcc, sym, PoisonedSymbol);
        }
    }
}

extern "C" void _M2_SymbolConversion_init (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
  Init ();
}

extern "C" void _M2_SymbolConversion_fini (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
}
