/* do not edit automatically generated by mc from m2statement.  */
/* m2statement.def definition module for m2statement.cc.

Copyright (C) 2011-2025 Free Software Foundation, Inc.
Contributed by Gaius Mulley <gaius.mulley@southwales.ac.uk>.

This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GNU Modula-2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Modula-2; see the file COPYING3.  If not see
<http://www.gnu.org/licenses/>.  */


#if !defined (_m2statement_H)
#   define _m2statement_H

#include "config.h"
#include "system.h"
#include "gcc-consolidation.h"

#   ifdef __cplusplus
extern "C" {
#   endif
#include <stdbool.h>
#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif

#   include "Ggcctypes.h"
#   include "GCDataTypes.h"
#   include "Gm2expr.h"

#   if defined (_m2statement_C)
#      define EXTERN
#   else
#      define EXTERN extern
#   endif


/*
   DoJump - jump to the appropriate label depending whether
            result of the expression is TRUE or FALSE.
*/

EXTERN void m2statement_DoJump (location_t location, tree exp, char * falselabel, char * truelabel);

/*
   BuildStartFunctionCode - generate function entry code.
*/

EXTERN void m2statement_BuildStartFunctionCode (location_t location, tree fndecl, bool isexported, bool isinline);

/*
   BuildEndFunctionCode - generates the function epilogue.
*/

EXTERN void m2statement_BuildEndFunctionCode (location_t location, tree fndecl, bool nested);

/*
   BuildReturnValueCode - generates the code associated with: RETURN( value )
*/

EXTERN void m2statement_BuildReturnValueCode (location_t location, tree fndecl, tree value);

/*
   BuildPushFunctionContext - pushes the current function context.
                              Maps onto push_function_context in ../function.c
*/

EXTERN void m2statement_BuildPushFunctionContext (void);

/*
   BuildPopFunctionContext - pops the current function context.
                             Maps onto pop_function_context in ../function.c
*/

EXTERN void m2statement_BuildPopFunctionContext (void);

/*
   BuildAssignmentTree - builds the assignment of, des, and, expr.
                         It returns, des.
*/

EXTERN tree m2statement_BuildAssignmentTree (location_t location, tree des, tree expr);

/*
   BuildAssignmentStatement builds the assignment of, des, and, expr.
*/

EXTERN void m2statement_BuildAssignmentStatement (location_t location, tree des, tree expr);

/*
   BuildGoto - builds a goto operation.
*/

EXTERN void m2statement_BuildGoto (location_t location, char * name);

/*
   DeclareLabel - create a label, name.
*/

EXTERN void m2statement_DeclareLabel (location_t location, char * name);

/*
   BuildIfThenDoEnd - returns a tree which will only execute
                      statement, s, if, condition, is true.
*/

EXTERN tree m2statement_BuildIfThenDoEnd (tree condition, tree then_block);

/*
   BuildIfThenElseEnd - returns a tree which will execute
                        then_block or else_block depending upon,
                        condition.
*/

EXTERN tree m2statement_BuildIfThenElseEnd (tree condition, tree then_block, tree else_block);

/*
   BuildParam - build a list of parameters, ready for a subsequent procedure call.
*/

EXTERN void m2statement_BuildParam (location_t location, tree param);

/*
   BuildFunctionCallTree - creates a procedure function call from
                           a procedure and parameter list and the
                           return type, rettype.  No tree is returned
                           as the tree is held in the last_function
                           global variable.  It is expected the
                           BuildFunctValue is to be called after
                           a call to BuildFunctionCallTree.
*/

EXTERN void m2statement_BuildFunctionCallTree (location_t location, tree procedure, tree rettype);

/*
   BuildProcedureCallTree - creates a procedure call from a procedure and
                            parameter list and the return type, rettype.
*/

EXTERN tree m2statement_BuildProcedureCallTree (location_t location, tree procedure, tree rettype);

/*
   BuildIndirectProcedureCallTree - creates a procedure call from a procedure and
                                    parameter list and the return type, rettype.
*/

EXTERN tree m2statement_BuildIndirectProcedureCallTree (location_t location, tree procedure, tree rettype);

/*
   BuildFunctValue - generates code for value := last_function(foobar);
*/

EXTERN tree m2statement_BuildFunctValue (location_t location, tree value);

/*
   BuildCall2 - builds a tree representing:  function(arg1, arg2).
*/

EXTERN tree m2statement_BuildCall2 (location_t location, tree function, tree rettype, tree arg1, tree arg2);

/*
   BuildCall3 - builds a tree representing:  function(arg1, arg2, arg3).
*/

EXTERN tree m2statement_BuildCall3 (location_t location, tree function, tree rettype, tree arg1, tree arg2, tree arg3);

/*
   SetLastFunction - set the last_function to, t.
*/

EXTERN void m2statement_SetLastFunction (tree t);

/*
   GetLastFunction - returns, last_function.
*/

EXTERN tree m2statement_GetLastFunction (void);

/*
   GetParamTree - return parameter, i.
*/

EXTERN tree m2statement_GetParamTree (tree call, unsigned int i);

/*
   BuildTryFinally - returns a TRY_FINALL_EXPR with the call and cleanups
                     attached.
*/

EXTERN tree m2statement_BuildTryFinally (location_t location, tree call, tree cleanups);

/*
   BuildCleanUp - return a CLEANUP_POINT_EXPR which will clobber, param.
*/

EXTERN tree m2statement_BuildCleanUp (tree param);

/*
    BuildAsm - generates an inline assembler instruction.
*/

EXTERN void m2statement_BuildAsm (location_t location, tree instr, bool isVolatile, bool isSimple, tree inputs, tree outputs, tree trash, tree labels);

/*
    BuildUnaryForeachWordDo - provides the large set operators.
                              Each word (or less) of the set can be
                              calculated by unop.
                              This procedure iterates over each word
                              of the large set invoking the unop.
*/

EXTERN void m2statement_BuildUnaryForeachWordDo (location_t location, tree type, tree op1, tree op2, m2expr_BuildUnarySetFunction_C unop, bool is_op1lvalue, bool is_op2lvalue, bool is_op1const, bool is_op2const);

/*
    BuildExcludeVarConst - builds the EXCL(op1, 1<<op2) operation for a small sets. Large
                           sets call this routine to exclude the bit in the particular word.
                           op2 is a constant.
*/

EXTERN void m2statement_BuildExcludeVarConst (location_t location, tree type, tree op1, tree op2, bool is_lvalue, int fieldno);

/*
    BuildExcludeVarVar - builds the EXCL(varset, 1<<varel) operation for a small and large sets.
                         varel is a variable.
*/

EXTERN void m2statement_BuildExcludeVarVar (location_t location, tree type, tree varset, tree varel, bool is_lvalue, tree low);

/*
    BuildIncludeVarConst - builds the INCL(op1, 1<<op2) operation for a small sets. Large
                           sets call this routine to include the bit in the particular word.
                           op2 is a constant.
*/

EXTERN void m2statement_BuildIncludeVarConst (location_t location, tree type, tree op1, tree op2, bool is_lvalue, int fieldno);

/*
    BuildIncludeVarVar - builds the INCL(varset, 1<<varel) operation for a small and large sets.
                         op2 is a variable.
*/

EXTERN void m2statement_BuildIncludeVarVar (location_t location, tree type, tree varset, tree varel, bool is_lvalue, tree low);

/*
    BuildStart - creates a module initialization function. We make
                 this function public if it is not an inner module.
                 The linker will create a call list for all linked
                 modules which determines the initialization
                 sequence for all modules.
*/

EXTERN tree m2statement_BuildStart (location_t location, char * name, bool inner_module);

/*
    BuildEnd - complete the initialisation function for this module.
*/

EXTERN void m2statement_BuildEnd (location_t location, tree fndecl, bool nested);

/*
    BuildCallInner - call the inner module function.  It has no parameters and no return value.
*/

EXTERN void m2statement_BuildCallInner (location_t location, tree fndecl);

/*
   SetBeginLocation - sets the begin location for the function to obtain good debugging info.
*/

EXTERN void m2statement_SetBeginLocation (location_t location);

/*
   SetEndLocation - sets the end location for the function to obtain good debugging info.
*/

EXTERN void m2statement_SetEndLocation (location_t location);

/*
   BuildBuiltinCallTree - calls the builtin procedure.
*/

EXTERN tree m2statement_BuildBuiltinCallTree (tree func);

/*
   CopyByField - copy expr to des, if des is a record, union or an array
                 then check fields for GCC type equivalence and if necessary
                 call __builtin_strncpy and __builtin_memcpy.
                 This can occur if an expr contains a constant string
                 which is to be assigned into a field declared as
                 an ARRAY [0..n] OF CHAR.
*/

EXTERN void m2statement_CopyByField (location_t location, tree des, tree expr);
#   ifdef __cplusplus
}
#   endif

#   undef EXTERN
#endif
