/*
Copyright The cert-manager Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

// X509SubjectApplyConfiguration represents a declarative configuration of the X509Subject type for use
// with apply.
type X509SubjectApplyConfiguration struct {
	Organizations       []string `json:"organizations,omitempty"`
	Countries           []string `json:"countries,omitempty"`
	OrganizationalUnits []string `json:"organizationalUnits,omitempty"`
	Localities          []string `json:"localities,omitempty"`
	Provinces           []string `json:"provinces,omitempty"`
	StreetAddresses     []string `json:"streetAddresses,omitempty"`
	PostalCodes         []string `json:"postalCodes,omitempty"`
	SerialNumber        *string  `json:"serialNumber,omitempty"`
}

// X509SubjectApplyConfiguration constructs a declarative configuration of the X509Subject type for use with
// apply.
func X509Subject() *X509SubjectApplyConfiguration {
	return &X509SubjectApplyConfiguration{}
}

// WithOrganizations adds the given value to the Organizations field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Organizations field.
func (b *X509SubjectApplyConfiguration) WithOrganizations(values ...string) *X509SubjectApplyConfiguration {
	for i := range values {
		b.Organizations = append(b.Organizations, values[i])
	}
	return b
}

// WithCountries adds the given value to the Countries field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Countries field.
func (b *X509SubjectApplyConfiguration) WithCountries(values ...string) *X509SubjectApplyConfiguration {
	for i := range values {
		b.Countries = append(b.Countries, values[i])
	}
	return b
}

// WithOrganizationalUnits adds the given value to the OrganizationalUnits field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the OrganizationalUnits field.
func (b *X509SubjectApplyConfiguration) WithOrganizationalUnits(values ...string) *X509SubjectApplyConfiguration {
	for i := range values {
		b.OrganizationalUnits = append(b.OrganizationalUnits, values[i])
	}
	return b
}

// WithLocalities adds the given value to the Localities field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Localities field.
func (b *X509SubjectApplyConfiguration) WithLocalities(values ...string) *X509SubjectApplyConfiguration {
	for i := range values {
		b.Localities = append(b.Localities, values[i])
	}
	return b
}

// WithProvinces adds the given value to the Provinces field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Provinces field.
func (b *X509SubjectApplyConfiguration) WithProvinces(values ...string) *X509SubjectApplyConfiguration {
	for i := range values {
		b.Provinces = append(b.Provinces, values[i])
	}
	return b
}

// WithStreetAddresses adds the given value to the StreetAddresses field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the StreetAddresses field.
func (b *X509SubjectApplyConfiguration) WithStreetAddresses(values ...string) *X509SubjectApplyConfiguration {
	for i := range values {
		b.StreetAddresses = append(b.StreetAddresses, values[i])
	}
	return b
}

// WithPostalCodes adds the given value to the PostalCodes field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the PostalCodes field.
func (b *X509SubjectApplyConfiguration) WithPostalCodes(values ...string) *X509SubjectApplyConfiguration {
	for i := range values {
		b.PostalCodes = append(b.PostalCodes, values[i])
	}
	return b
}

// WithSerialNumber sets the SerialNumber field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the SerialNumber field is set to the value of the last call.
func (b *X509SubjectApplyConfiguration) WithSerialNumber(value string) *X509SubjectApplyConfiguration {
	b.SerialNumber = &value
	return b
}
