/* THIS FILE IS AUTOGENERATED FROM NodeFilter.webidl BY Codegen.py - DO NOT EDIT */

#include <type_traits>
#include "AtomList.h"
#include "MainThreadUtils.h"
#include "NodeFilterBinding.h"
#include "WrapperFactory.h"
#include "js/CallAndConstruct.h"
#include "js/Exception.h"
#include "js/MapAndSet.h"
#include "js/Object.h"
#include "js/PropertyAndElement.h"
#include "js/PropertyDescriptor.h"
#include "js/experimental/JitInfo.h"
#include "mozilla/Atomics.h"
#include "mozilla/OwningNonNull.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/DOMJSClass.h"
#include "mozilla/dom/NonRefcountedDOMObject.h"
#include "mozilla/dom/PrimitiveConversions.h"
#include "mozilla/dom/XrayExpandoClass.h"
#include "nsIContent.h"

namespace mozilla::dom {

namespace binding_detail {}; // Just to make sure it's known as a namespace
using namespace mozilla::dom::binding_detail;


namespace NodeFilter_Binding {

MOZ_GLOBINIT static const ConstantSpec sConstants_specs[] = {
  { "FILTER_ACCEPT", JS::Int32Value(1) },
  { "FILTER_REJECT", JS::Int32Value(2) },
  { "FILTER_SKIP", JS::Int32Value(3) },
  { "SHOW_ALL", JS::NumberValue(4294967295U) },
  { "SHOW_ELEMENT", JS::NumberValue(1U) },
  { "SHOW_ATTRIBUTE", JS::NumberValue(2U) },
  { "SHOW_TEXT", JS::NumberValue(4U) },
  { "SHOW_CDATA_SECTION", JS::NumberValue(8U) },
  { "SHOW_ENTITY_REFERENCE", JS::NumberValue(16U) },
  { "SHOW_ENTITY", JS::NumberValue(32U) },
  { "SHOW_PROCESSING_INSTRUCTION", JS::NumberValue(64U) },
  { "SHOW_COMMENT", JS::NumberValue(128U) },
  { "SHOW_DOCUMENT", JS::NumberValue(256U) },
  { "SHOW_DOCUMENT_TYPE", JS::NumberValue(512U) },
  { "SHOW_DOCUMENT_FRAGMENT", JS::NumberValue(1024U) },
  { "SHOW_NOTATION", JS::NumberValue(2048U) },
  { 0, JS::UndefinedValue() }
};


static const Prefable<const ConstantSpec> sConstants[] = {
  { nullptr, &sConstants_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(16 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");


static uint16_t sNativeProperties_sortedPropertyIndices[16];
static PropertyInfo sNativeProperties_propertyInfos[16];

static const NativePropertiesN<1> sNativeProperties = {
  false, 0,
  false, 0,
  false, 0,
  false, 0,
  false, 0,
  false, 0,
  true,  0 /* sConstants */,
  -1,
  16,
  sNativeProperties_sortedPropertyIndices,
  {
    { sConstants, &sNativeProperties_propertyInfos[0] }
  }
};
static_assert(16 < 1ull << (CHAR_BIT * sizeof(sNativeProperties.propertyInfoCount)),
    "We have a property info count that is oversized");

bool sNativePropertiesInited = false;
const NativePropertyHooks sNativePropertyHooks = {
  nullptr,
  { sNativeProperties.Upcast(), nullptr, &sNativePropertiesInited },
  prototypes::id::_ID_Count,
  constructors::id::NodeFilter,
  &DefaultXrayExpandoObjectClass
};

static const DOMInterfaceInfo sInterfaceObjectInfo = {
  { ThrowingConstructor, &sNativePropertyHooks },
  JS::GetRealmFunctionPrototypeHandle,
  0,
  prototypes::id::_ID_Count,
  false,
  0,
  "NodeFilter",
};

void
CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal)
{
  JS::Heap<JSObject*>* protoCache = nullptr;
  JS::Heap<JSObject*>* interfaceCache = &aProtoAndIfaceCache.EntrySlotOrCreate(constructors::id::NodeFilter);

  JS::Handle<JSObject*> constructorProto(JS::GetRealmFunctionPrototypeHandle(aCx));
  if (!constructorProto) {
    return;
  }

  dom::CreateInterfaceObjects(aCx, aGlobal, nullptr,
                              nullptr, protoCache,
                              constructorProto, &sInterfaceObjectInfo, 0, false, Span<const LegacyFactoryFunction, 0>{},
                              interfaceCache,
                              sNativeProperties.Upcast(),
                              nullptr,
                              "NodeFilter",
                              aDefineOnGlobal != DefineInterfaceProperty::No,
                              nullptr,
                              false,
                              nullptr);
}

JS::Handle<JSObject*>
GetConstructorObjectHandle(JSContext* aCx)
{
  /* Get the interface object for this class.  This will create the object as
     needed. */

  return GetPerInterfaceObjectHandle(aCx, constructors::id::NodeFilter,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);
}

} // namespace NodeFilter_Binding



uint16_t
NodeFilter::AcceptNode(BindingCallContext& cx, JS::Handle<JS::Value> aThisVal, nsINode& node, ErrorResult& aRv)
{
  JS::Rooted<JS::Value> rval(cx);
  JS::RootedVector<JS::Value> argv(cx);
  if (!argv.resize(1)) {
    // That threw an exception on the JSContext, and our CallSetup will do
    // the right thing with that.
    return uint16_t(0);
  }
  unsigned argc = 1;

  do {
    if (!GetOrCreateDOMReflector(cx, node, argv[0])) {
      MOZ_ASSERT(JS_IsExceptionPending(cx));
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return uint16_t(0);
    }
    break;
  } while (false);

  bool isCallable = JS::IsCallable(mCallback);
  JS::Rooted<JS::Value> callable(cx);
  if (isCallable) {
    callable = JS::ObjectValue(*mCallback);
  } else {
    NodeFilterAtoms* atomsCache = GetAtomCache<NodeFilterAtoms>(cx);
    if ((reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
         !InitIds(cx, atomsCache)) ||
        !GetCallableProperty(cx, atomsCache->acceptNode_id, &callable)) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return uint16_t(0);
    }
  }
  JS::Rooted<JS::Value> thisValue(cx, isCallable ? aThisVal.get()
                                                 : JS::ObjectValue(*mCallback));
  if (!JS::Call(cx, thisValue, callable,
                JS::HandleValueArray::subarray(argv, 0, argc), &rval)) {
    aRv.NoteJSContextException(cx);
    return uint16_t(0);
  }
  uint16_t rvalDecl;
  if (!ValueToPrimitive<uint16_t, eDefault>(cx, rval, "Return value of NodeFilter.acceptNode", &rvalDecl)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return uint16_t(0);
  }
  return rvalDecl;
}

bool
NodeFilter::InitIds(JSContext* cx, NodeFilterAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->acceptNode_id.init(cx, "acceptNode")) {
    return false;
  }
  return true;
}



} // namespace mozilla::dom
