//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/dom/PFileSystemManagerChild.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/RemoteLazyInputStream.h"
#include "mozilla/dom/FileSystemManagerChild.h"
#include "mozilla/ipc/IPCCore.h"

#include "mozilla/dom/PFileSystemAccessHandleChild.h"
#include "mozilla/dom/PFileSystemAccessHandleControlChild.h"
#include "mozilla/dom/PFileSystemWritableFileStreamChild.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace dom {


auto PFileSystemManagerChild::RecvPFileSystemWritableFileStreamConstructor(PFileSystemWritableFileStreamChild* actor) -> mozilla::ipc::IPCResult
{
    return IPC_OK();
}

auto PFileSystemManagerChild::ProcessingError(
        Result aCode,
        const char* aReason) -> void
{
}

auto PFileSystemManagerChild::ShouldContinueFromReplyTimeout() -> bool
{
    return true;
}

MOZ_IMPLICIT PFileSystemManagerChild::PFileSystemManagerChild() :
    mozilla::ipc::IToplevelProtocol("PFileSystemManagerChild", kProtocolId, mozilla::ipc::ChildSide)
{
    MOZ_COUNT_CTOR(PFileSystemManagerChild);
}

PFileSystemManagerChild::~PFileSystemManagerChild()
{
    MOZ_COUNT_DTOR(PFileSystemManagerChild);
}

auto PFileSystemManagerChild::ActorAlloc() -> void
{
    MOZ_RELEASE_ASSERT(XRE_IsParentProcess() || XRE_IsContentProcess(), "Invalid process for `PFileSystemManagerChild'");
    AddRef();
}

auto PFileSystemManagerChild::ActorDealloc() -> void
{
    Release();
}

auto PFileSystemManagerChild::ManagedPFileSystemAccessHandleChild(nsTArray<PFileSystemAccessHandleChild*>& aArr) const -> void
{
    mManagedPFileSystemAccessHandleChild.ToArray(aArr);
}

auto PFileSystemManagerChild::ManagedPFileSystemAccessHandleChild() const -> const ManagedContainer<PFileSystemAccessHandleChild>&
{
    return mManagedPFileSystemAccessHandleChild;
}

auto PFileSystemManagerChild::ManagedPFileSystemWritableFileStreamChild(nsTArray<PFileSystemWritableFileStreamChild*>& aArr) const -> void
{
    mManagedPFileSystemWritableFileStreamChild.ToArray(aArr);
}

auto PFileSystemManagerChild::ManagedPFileSystemWritableFileStreamChild() const -> const ManagedContainer<PFileSystemWritableFileStreamChild>&
{
    return mManagedPFileSystemWritableFileStreamChild;
}

auto PFileSystemManagerChild::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    static constexpr ::mozilla::ipc::ProtocolId sIds[] = {
        PFileSystemAccessHandleMsgStart,
        PFileSystemWritableFileStreamMsgStart
    };
    return sIds;
}

auto PFileSystemManagerChild::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    case PFileSystemAccessHandleMsgStart:
        return (&(mManagedPFileSystemAccessHandleChild));
    case PFileSystemWritableFileStreamMsgStart:
        return (&(mManagedPFileSystemWritableFileStreamChild));
    default:
        return nullptr;
    }
}

auto PFileSystemManagerChild::RejectPendingResponses(ResponseRejectReason aReason) -> void
{
    mAsyncCallbacks.RejectPendingResponses(aReason);
}

auto PFileSystemManagerChild::OpenPFileSystemAccessHandleEndpoint(PFileSystemAccessHandleChild* aActor) -> ManagedEndpoint<PFileSystemAccessHandleParent>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PFileSystemAccessHandleChild actor");
        return ManagedEndpoint<PFileSystemAccessHandleParent>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PFileSystemAccessHandleChild actor");
        return ManagedEndpoint<PFileSystemAccessHandleParent>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PFileSystemAccessHandleParent>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PFileSystemManagerChild::BindPFileSystemAccessHandleEndpoint(
        ManagedEndpoint<PFileSystemAccessHandleChild> aEndpoint,
        PFileSystemAccessHandleChild* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PFileSystemManagerChild::OpenPFileSystemWritableFileStreamEndpoint(PFileSystemWritableFileStreamChild* aActor) -> ManagedEndpoint<PFileSystemWritableFileStreamParent>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PFileSystemWritableFileStreamChild actor");
        return ManagedEndpoint<PFileSystemWritableFileStreamParent>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PFileSystemWritableFileStreamChild actor");
        return ManagedEndpoint<PFileSystemWritableFileStreamParent>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PFileSystemWritableFileStreamParent>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PFileSystemManagerChild::BindPFileSystemWritableFileStreamEndpoint(
        ManagedEndpoint<PFileSystemWritableFileStreamChild> aEndpoint,
        PFileSystemWritableFileStreamChild* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PFileSystemManagerChild::SendGetRootHandle(
        mozilla::ipc::ResolveCallback<FileSystemGetHandleResponse>&& aResolve,
        mozilla::ipc::RejectCallback&& aReject) -> void
{
    UniquePtr<IPC::Message> msg__ = PFileSystemManager::Msg_GetRootHandle(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};



    if (mozilla::ipc::LoggingEnabledFor("PFileSystemManager", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PFileSystemManagerChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PFileSystemManager::Msg_GetRootHandle", OTHER);

    IPC::Message::seqno_t seqno__ = 0;
    if (ChannelSend(std::move(msg__), (&(seqno__)))) {
        mAsyncCallbacks.AddCallback(seqno__, PFileSystemManager::Reply_GetRootHandle__ID, [resolve=std::move(aResolve)](IPC::MessageReader* aReader) mutable {
            auto maybe__response = IPC::ReadParam<FileSystemGetHandleResponse>(aReader);
            if (!maybe__response) {
                (aReader)->FatalError("Error deserializing 'FileSystemGetHandleResponse'");
                return MsgValueError;

            }
            auto& response = *maybe__response;
            // Sentinel = 'response'
            if ((!((aReader)->ReadSentinel(260965232)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'FileSystemGetHandleResponse'");
                return MsgValueError;
            }


            aReader->EndRead();

            resolve(std::move(response));
            return MsgProcessed;
        }, std::move(aReject));
    }
    else {
        aReject(::mozilla::ipc::ResponseRejectReason::SendError);
    }
    return;
}

auto PFileSystemManagerChild::SendGetRootHandle() -> RefPtr<GetRootHandlePromise>
{
    RefPtr<MozPromise<FileSystemGetHandleResponse, ResponseRejectReason, true>::Private> promise__ = new MozPromise<FileSystemGetHandleResponse, ResponseRejectReason, true>::Private(__func__);
    promise__->UseDirectTaskDispatch(__func__);
    SendGetRootHandle([promise__](FileSystemGetHandleResponse&& aValue) {
        promise__->Resolve(std::move(aValue), __func__);
    }, [promise__](ResponseRejectReason&& aReason) {
        promise__->Reject(std::move(aReason), __func__);
    });
    return promise__;
}

auto PFileSystemManagerChild::SendGetDirectoryHandle(
        const FileSystemGetHandleRequest& request,
        mozilla::ipc::ResolveCallback<FileSystemGetHandleResponse>&& aResolve,
        mozilla::ipc::RejectCallback&& aReject) -> void
{
    UniquePtr<IPC::Message> msg__ = PFileSystemManager::Msg_GetDirectoryHandle(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), request);
    // Sentinel = 'request'
    ((&(writer__)))->WriteSentinel(202703626);


    if (mozilla::ipc::LoggingEnabledFor("PFileSystemManager", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PFileSystemManagerChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PFileSystemManager::Msg_GetDirectoryHandle", OTHER);

    IPC::Message::seqno_t seqno__ = 0;
    if (ChannelSend(std::move(msg__), (&(seqno__)))) {
        mAsyncCallbacks.AddCallback(seqno__, PFileSystemManager::Reply_GetDirectoryHandle__ID, [resolve=std::move(aResolve)](IPC::MessageReader* aReader) mutable {
            auto maybe__handle = IPC::ReadParam<FileSystemGetHandleResponse>(aReader);
            if (!maybe__handle) {
                (aReader)->FatalError("Error deserializing 'FileSystemGetHandleResponse'");
                return MsgValueError;

            }
            auto& handle = *maybe__handle;
            // Sentinel = 'handle'
            if ((!((aReader)->ReadSentinel(142344813)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'FileSystemGetHandleResponse'");
                return MsgValueError;
            }


            aReader->EndRead();

            resolve(std::move(handle));
            return MsgProcessed;
        }, std::move(aReject));
    }
    else {
        aReject(::mozilla::ipc::ResponseRejectReason::SendError);
    }
    return;
}

auto PFileSystemManagerChild::SendGetDirectoryHandle(const FileSystemGetHandleRequest& request) -> RefPtr<GetDirectoryHandlePromise>
{
    RefPtr<MozPromise<FileSystemGetHandleResponse, ResponseRejectReason, true>::Private> promise__ = new MozPromise<FileSystemGetHandleResponse, ResponseRejectReason, true>::Private(__func__);
    promise__->UseDirectTaskDispatch(__func__);
    SendGetDirectoryHandle(std::move(request), [promise__](FileSystemGetHandleResponse&& aValue) {
        promise__->Resolve(std::move(aValue), __func__);
    }, [promise__](ResponseRejectReason&& aReason) {
        promise__->Reject(std::move(aReason), __func__);
    });
    return promise__;
}

auto PFileSystemManagerChild::SendGetFileHandle(
        const FileSystemGetHandleRequest& request,
        mozilla::ipc::ResolveCallback<FileSystemGetHandleResponse>&& aResolve,
        mozilla::ipc::RejectCallback&& aReject) -> void
{
    UniquePtr<IPC::Message> msg__ = PFileSystemManager::Msg_GetFileHandle(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), request);
    // Sentinel = 'request'
    ((&(writer__)))->WriteSentinel(202703626);


    if (mozilla::ipc::LoggingEnabledFor("PFileSystemManager", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PFileSystemManagerChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PFileSystemManager::Msg_GetFileHandle", OTHER);

    IPC::Message::seqno_t seqno__ = 0;
    if (ChannelSend(std::move(msg__), (&(seqno__)))) {
        mAsyncCallbacks.AddCallback(seqno__, PFileSystemManager::Reply_GetFileHandle__ID, [resolve=std::move(aResolve)](IPC::MessageReader* aReader) mutable {
            auto maybe__handle = IPC::ReadParam<FileSystemGetHandleResponse>(aReader);
            if (!maybe__handle) {
                (aReader)->FatalError("Error deserializing 'FileSystemGetHandleResponse'");
                return MsgValueError;

            }
            auto& handle = *maybe__handle;
            // Sentinel = 'handle'
            if ((!((aReader)->ReadSentinel(142344813)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'FileSystemGetHandleResponse'");
                return MsgValueError;
            }


            aReader->EndRead();

            resolve(std::move(handle));
            return MsgProcessed;
        }, std::move(aReject));
    }
    else {
        aReject(::mozilla::ipc::ResponseRejectReason::SendError);
    }
    return;
}

auto PFileSystemManagerChild::SendGetFileHandle(const FileSystemGetHandleRequest& request) -> RefPtr<GetFileHandlePromise>
{
    RefPtr<MozPromise<FileSystemGetHandleResponse, ResponseRejectReason, true>::Private> promise__ = new MozPromise<FileSystemGetHandleResponse, ResponseRejectReason, true>::Private(__func__);
    promise__->UseDirectTaskDispatch(__func__);
    SendGetFileHandle(std::move(request), [promise__](FileSystemGetHandleResponse&& aValue) {
        promise__->Resolve(std::move(aValue), __func__);
    }, [promise__](ResponseRejectReason&& aReason) {
        promise__->Reject(std::move(aReason), __func__);
    });
    return promise__;
}

auto PFileSystemManagerChild::SendGetFile(
        const FileSystemGetFileRequest& request,
        mozilla::ipc::ResolveCallback<FileSystemGetFileResponse>&& aResolve,
        mozilla::ipc::RejectCallback&& aReject) -> void
{
    UniquePtr<IPC::Message> msg__ = PFileSystemManager::Msg_GetFile(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), request);
    // Sentinel = 'request'
    ((&(writer__)))->WriteSentinel(202703626);


    if (mozilla::ipc::LoggingEnabledFor("PFileSystemManager", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PFileSystemManagerChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PFileSystemManager::Msg_GetFile", OTHER);

    IPC::Message::seqno_t seqno__ = 0;
    if (ChannelSend(std::move(msg__), (&(seqno__)))) {
        mAsyncCallbacks.AddCallback(seqno__, PFileSystemManager::Reply_GetFile__ID, [resolve=std::move(aResolve)](IPC::MessageReader* aReader) mutable {
            auto maybe__response = IPC::ReadParam<FileSystemGetFileResponse>(aReader);
            if (!maybe__response) {
                (aReader)->FatalError("Error deserializing 'FileSystemGetFileResponse'");
                return MsgValueError;

            }
            auto& response = *maybe__response;
            // Sentinel = 'response'
            if ((!((aReader)->ReadSentinel(260965232)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'FileSystemGetFileResponse'");
                return MsgValueError;
            }


            aReader->EndRead();

            resolve(std::move(response));
            return MsgProcessed;
        }, std::move(aReject));
    }
    else {
        aReject(::mozilla::ipc::ResponseRejectReason::SendError);
    }
    return;
}

auto PFileSystemManagerChild::SendGetFile(const FileSystemGetFileRequest& request) -> RefPtr<GetFilePromise>
{
    RefPtr<MozPromise<FileSystemGetFileResponse, ResponseRejectReason, true>::Private> promise__ = new MozPromise<FileSystemGetFileResponse, ResponseRejectReason, true>::Private(__func__);
    promise__->UseDirectTaskDispatch(__func__);
    SendGetFile(std::move(request), [promise__](FileSystemGetFileResponse&& aValue) {
        promise__->Resolve(std::move(aValue), __func__);
    }, [promise__](ResponseRejectReason&& aReason) {
        promise__->Reject(std::move(aReason), __func__);
    });
    return promise__;
}

auto PFileSystemManagerChild::SendGetAccessHandle(
        const FileSystemGetAccessHandleRequest& request,
        mozilla::ipc::ResolveCallback<FileSystemGetAccessHandleResponse>&& aResolve,
        mozilla::ipc::RejectCallback&& aReject) -> void
{
    UniquePtr<IPC::Message> msg__ = PFileSystemManager::Msg_GetAccessHandle(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), request);
    // Sentinel = 'request'
    ((&(writer__)))->WriteSentinel(202703626);


    if (mozilla::ipc::LoggingEnabledFor("PFileSystemManager", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PFileSystemManagerChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PFileSystemManager::Msg_GetAccessHandle", OTHER);

    IPC::Message::seqno_t seqno__ = 0;
    if (ChannelSend(std::move(msg__), (&(seqno__)))) {
        mAsyncCallbacks.AddCallback(seqno__, PFileSystemManager::Reply_GetAccessHandle__ID, [resolve=std::move(aResolve)](IPC::MessageReader* aReader) mutable {
            auto maybe__response = IPC::ReadParam<FileSystemGetAccessHandleResponse>(aReader);
            if (!maybe__response) {
                (aReader)->FatalError("Error deserializing 'FileSystemGetAccessHandleResponse'");
                return MsgValueError;

            }
            auto& response = *maybe__response;
            // Sentinel = 'response'
            if ((!((aReader)->ReadSentinel(260965232)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'FileSystemGetAccessHandleResponse'");
                return MsgValueError;
            }


            aReader->EndRead();

            resolve(std::move(response));
            return MsgProcessed;
        }, std::move(aReject));
    }
    else {
        aReject(::mozilla::ipc::ResponseRejectReason::SendError);
    }
    return;
}

auto PFileSystemManagerChild::SendGetAccessHandle(const FileSystemGetAccessHandleRequest& request) -> RefPtr<GetAccessHandlePromise>
{
    RefPtr<MozPromise<FileSystemGetAccessHandleResponse, ResponseRejectReason, true>::Private> promise__ = new MozPromise<FileSystemGetAccessHandleResponse, ResponseRejectReason, true>::Private(__func__);
    promise__->UseDirectTaskDispatch(__func__);
    SendGetAccessHandle(std::move(request), [promise__](FileSystemGetAccessHandleResponse&& aValue) {
        promise__->Resolve(std::move(aValue), __func__);
    }, [promise__](ResponseRejectReason&& aReason) {
        promise__->Reject(std::move(aReason), __func__);
    });
    return promise__;
}

auto PFileSystemManagerChild::SendGetWritable(
        const FileSystemGetWritableRequest& request,
        mozilla::ipc::ResolveCallback<FileSystemGetWritableFileStreamResponse>&& aResolve,
        mozilla::ipc::RejectCallback&& aReject) -> void
{
    UniquePtr<IPC::Message> msg__ = PFileSystemManager::Msg_GetWritable(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), request);
    // Sentinel = 'request'
    ((&(writer__)))->WriteSentinel(202703626);


    if (mozilla::ipc::LoggingEnabledFor("PFileSystemManager", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PFileSystemManagerChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PFileSystemManager::Msg_GetWritable", OTHER);

    IPC::Message::seqno_t seqno__ = 0;
    if (ChannelSend(std::move(msg__), (&(seqno__)))) {
        mAsyncCallbacks.AddCallback(seqno__, PFileSystemManager::Reply_GetWritable__ID, [resolve=std::move(aResolve)](IPC::MessageReader* aReader) mutable {
            auto maybe__fileData = IPC::ReadParam<FileSystemGetWritableFileStreamResponse>(aReader);
            if (!maybe__fileData) {
                (aReader)->FatalError("Error deserializing 'FileSystemGetWritableFileStreamResponse'");
                return MsgValueError;

            }
            auto& fileData = *maybe__fileData;
            // Sentinel = 'fileData'
            if ((!((aReader)->ReadSentinel(236192539)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'FileSystemGetWritableFileStreamResponse'");
                return MsgValueError;
            }


            aReader->EndRead();

            resolve(std::move(fileData));
            return MsgProcessed;
        }, std::move(aReject));
    }
    else {
        aReject(::mozilla::ipc::ResponseRejectReason::SendError);
    }
    return;
}

auto PFileSystemManagerChild::SendGetWritable(const FileSystemGetWritableRequest& request) -> RefPtr<GetWritablePromise>
{
    RefPtr<MozPromise<FileSystemGetWritableFileStreamResponse, ResponseRejectReason, true>::Private> promise__ = new MozPromise<FileSystemGetWritableFileStreamResponse, ResponseRejectReason, true>::Private(__func__);
    promise__->UseDirectTaskDispatch(__func__);
    SendGetWritable(std::move(request), [promise__](FileSystemGetWritableFileStreamResponse&& aValue) {
        promise__->Resolve(std::move(aValue), __func__);
    }, [promise__](ResponseRejectReason&& aReason) {
        promise__->Reject(std::move(aReason), __func__);
    });
    return promise__;
}

auto PFileSystemManagerChild::SendResolve(
        const FileSystemResolveRequest& request,
        mozilla::ipc::ResolveCallback<FileSystemResolveResponse>&& aResolve,
        mozilla::ipc::RejectCallback&& aReject) -> void
{
    UniquePtr<IPC::Message> msg__ = PFileSystemManager::Msg_Resolve(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), request);
    // Sentinel = 'request'
    ((&(writer__)))->WriteSentinel(202703626);


    if (mozilla::ipc::LoggingEnabledFor("PFileSystemManager", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PFileSystemManagerChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PFileSystemManager::Msg_Resolve", OTHER);

    IPC::Message::seqno_t seqno__ = 0;
    if (ChannelSend(std::move(msg__), (&(seqno__)))) {
        mAsyncCallbacks.AddCallback(seqno__, PFileSystemManager::Reply_Resolve__ID, [resolve=std::move(aResolve)](IPC::MessageReader* aReader) mutable {
            auto maybe__response = IPC::ReadParam<FileSystemResolveResponse>(aReader);
            if (!maybe__response) {
                (aReader)->FatalError("Error deserializing 'FileSystemResolveResponse'");
                return MsgValueError;

            }
            auto& response = *maybe__response;
            // Sentinel = 'response'
            if ((!((aReader)->ReadSentinel(260965232)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'FileSystemResolveResponse'");
                return MsgValueError;
            }


            aReader->EndRead();

            resolve(std::move(response));
            return MsgProcessed;
        }, std::move(aReject));
    }
    else {
        aReject(::mozilla::ipc::ResponseRejectReason::SendError);
    }
    return;
}

auto PFileSystemManagerChild::SendResolve(const FileSystemResolveRequest& request) -> RefPtr<ResolvePromise>
{
    RefPtr<MozPromise<FileSystemResolveResponse, ResponseRejectReason, true>::Private> promise__ = new MozPromise<FileSystemResolveResponse, ResponseRejectReason, true>::Private(__func__);
    promise__->UseDirectTaskDispatch(__func__);
    SendResolve(std::move(request), [promise__](FileSystemResolveResponse&& aValue) {
        promise__->Resolve(std::move(aValue), __func__);
    }, [promise__](ResponseRejectReason&& aReason) {
        promise__->Reject(std::move(aReason), __func__);
    });
    return promise__;
}

auto PFileSystemManagerChild::SendGetEntries(
        const FileSystemGetEntriesRequest& request,
        mozilla::ipc::ResolveCallback<FileSystemGetEntriesResponse>&& aResolve,
        mozilla::ipc::RejectCallback&& aReject) -> void
{
    UniquePtr<IPC::Message> msg__ = PFileSystemManager::Msg_GetEntries(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), request);
    // Sentinel = 'request'
    ((&(writer__)))->WriteSentinel(202703626);


    if (mozilla::ipc::LoggingEnabledFor("PFileSystemManager", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PFileSystemManagerChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PFileSystemManager::Msg_GetEntries", OTHER);

    IPC::Message::seqno_t seqno__ = 0;
    if (ChannelSend(std::move(msg__), (&(seqno__)))) {
        mAsyncCallbacks.AddCallback(seqno__, PFileSystemManager::Reply_GetEntries__ID, [resolve=std::move(aResolve)](IPC::MessageReader* aReader) mutable {
            auto maybe__entries = IPC::ReadParam<FileSystemGetEntriesResponse>(aReader);
            if (!maybe__entries) {
                (aReader)->FatalError("Error deserializing 'FileSystemGetEntriesResponse'");
                return MsgValueError;

            }
            auto& entries = *maybe__entries;
            // Sentinel = 'entries'
            if ((!((aReader)->ReadSentinel(199361275)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'FileSystemGetEntriesResponse'");
                return MsgValueError;
            }


            aReader->EndRead();

            resolve(std::move(entries));
            return MsgProcessed;
        }, std::move(aReject));
    }
    else {
        aReject(::mozilla::ipc::ResponseRejectReason::SendError);
    }
    return;
}

auto PFileSystemManagerChild::SendGetEntries(const FileSystemGetEntriesRequest& request) -> RefPtr<GetEntriesPromise>
{
    RefPtr<MozPromise<FileSystemGetEntriesResponse, ResponseRejectReason, true>::Private> promise__ = new MozPromise<FileSystemGetEntriesResponse, ResponseRejectReason, true>::Private(__func__);
    promise__->UseDirectTaskDispatch(__func__);
    SendGetEntries(std::move(request), [promise__](FileSystemGetEntriesResponse&& aValue) {
        promise__->Resolve(std::move(aValue), __func__);
    }, [promise__](ResponseRejectReason&& aReason) {
        promise__->Reject(std::move(aReason), __func__);
    });
    return promise__;
}

auto PFileSystemManagerChild::SendRemoveEntry(
        const FileSystemRemoveEntryRequest& request,
        mozilla::ipc::ResolveCallback<FileSystemRemoveEntryResponse>&& aResolve,
        mozilla::ipc::RejectCallback&& aReject) -> void
{
    UniquePtr<IPC::Message> msg__ = PFileSystemManager::Msg_RemoveEntry(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), request);
    // Sentinel = 'request'
    ((&(writer__)))->WriteSentinel(202703626);


    if (mozilla::ipc::LoggingEnabledFor("PFileSystemManager", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PFileSystemManagerChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PFileSystemManager::Msg_RemoveEntry", OTHER);

    IPC::Message::seqno_t seqno__ = 0;
    if (ChannelSend(std::move(msg__), (&(seqno__)))) {
        mAsyncCallbacks.AddCallback(seqno__, PFileSystemManager::Reply_RemoveEntry__ID, [resolve=std::move(aResolve)](IPC::MessageReader* aReader) mutable {
            auto maybe__response = IPC::ReadParam<FileSystemRemoveEntryResponse>(aReader);
            if (!maybe__response) {
                (aReader)->FatalError("Error deserializing 'FileSystemRemoveEntryResponse'");
                return MsgValueError;

            }
            auto& response = *maybe__response;
            // Sentinel = 'response'
            if ((!((aReader)->ReadSentinel(260965232)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'FileSystemRemoveEntryResponse'");
                return MsgValueError;
            }


            aReader->EndRead();

            resolve(std::move(response));
            return MsgProcessed;
        }, std::move(aReject));
    }
    else {
        aReject(::mozilla::ipc::ResponseRejectReason::SendError);
    }
    return;
}

auto PFileSystemManagerChild::SendRemoveEntry(const FileSystemRemoveEntryRequest& request) -> RefPtr<RemoveEntryPromise>
{
    RefPtr<MozPromise<FileSystemRemoveEntryResponse, ResponseRejectReason, true>::Private> promise__ = new MozPromise<FileSystemRemoveEntryResponse, ResponseRejectReason, true>::Private(__func__);
    promise__->UseDirectTaskDispatch(__func__);
    SendRemoveEntry(std::move(request), [promise__](FileSystemRemoveEntryResponse&& aValue) {
        promise__->Resolve(std::move(aValue), __func__);
    }, [promise__](ResponseRejectReason&& aReason) {
        promise__->Reject(std::move(aReason), __func__);
    });
    return promise__;
}

auto PFileSystemManagerChild::SendMoveEntry(
        const FileSystemMoveEntryRequest& request,
        mozilla::ipc::ResolveCallback<FileSystemMoveEntryResponse>&& aResolve,
        mozilla::ipc::RejectCallback&& aReject) -> void
{
    UniquePtr<IPC::Message> msg__ = PFileSystemManager::Msg_MoveEntry(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), request);
    // Sentinel = 'request'
    ((&(writer__)))->WriteSentinel(202703626);


    if (mozilla::ipc::LoggingEnabledFor("PFileSystemManager", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PFileSystemManagerChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PFileSystemManager::Msg_MoveEntry", OTHER);

    IPC::Message::seqno_t seqno__ = 0;
    if (ChannelSend(std::move(msg__), (&(seqno__)))) {
        mAsyncCallbacks.AddCallback(seqno__, PFileSystemManager::Reply_MoveEntry__ID, [resolve=std::move(aResolve)](IPC::MessageReader* aReader) mutable {
            auto maybe__response = IPC::ReadParam<FileSystemMoveEntryResponse>(aReader);
            if (!maybe__response) {
                (aReader)->FatalError("Error deserializing 'FileSystemMoveEntryResponse'");
                return MsgValueError;

            }
            auto& response = *maybe__response;
            // Sentinel = 'response'
            if ((!((aReader)->ReadSentinel(260965232)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'FileSystemMoveEntryResponse'");
                return MsgValueError;
            }


            aReader->EndRead();

            resolve(std::move(response));
            return MsgProcessed;
        }, std::move(aReject));
    }
    else {
        aReject(::mozilla::ipc::ResponseRejectReason::SendError);
    }
    return;
}

auto PFileSystemManagerChild::SendMoveEntry(const FileSystemMoveEntryRequest& request) -> RefPtr<MoveEntryPromise>
{
    RefPtr<MozPromise<FileSystemMoveEntryResponse, ResponseRejectReason, true>::Private> promise__ = new MozPromise<FileSystemMoveEntryResponse, ResponseRejectReason, true>::Private(__func__);
    promise__->UseDirectTaskDispatch(__func__);
    SendMoveEntry(std::move(request), [promise__](FileSystemMoveEntryResponse&& aValue) {
        promise__->Resolve(std::move(aValue), __func__);
    }, [promise__](ResponseRejectReason&& aReason) {
        promise__->Reject(std::move(aReason), __func__);
    });
    return promise__;
}

auto PFileSystemManagerChild::SendRenameEntry(
        const FileSystemRenameEntryRequest& request,
        mozilla::ipc::ResolveCallback<FileSystemMoveEntryResponse>&& aResolve,
        mozilla::ipc::RejectCallback&& aReject) -> void
{
    UniquePtr<IPC::Message> msg__ = PFileSystemManager::Msg_RenameEntry(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), request);
    // Sentinel = 'request'
    ((&(writer__)))->WriteSentinel(202703626);


    if (mozilla::ipc::LoggingEnabledFor("PFileSystemManager", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PFileSystemManagerChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PFileSystemManager::Msg_RenameEntry", OTHER);

    IPC::Message::seqno_t seqno__ = 0;
    if (ChannelSend(std::move(msg__), (&(seqno__)))) {
        mAsyncCallbacks.AddCallback(seqno__, PFileSystemManager::Reply_RenameEntry__ID, [resolve=std::move(aResolve)](IPC::MessageReader* aReader) mutable {
            auto maybe__response = IPC::ReadParam<FileSystemMoveEntryResponse>(aReader);
            if (!maybe__response) {
                (aReader)->FatalError("Error deserializing 'FileSystemMoveEntryResponse'");
                return MsgValueError;

            }
            auto& response = *maybe__response;
            // Sentinel = 'response'
            if ((!((aReader)->ReadSentinel(260965232)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'FileSystemMoveEntryResponse'");
                return MsgValueError;
            }


            aReader->EndRead();

            resolve(std::move(response));
            return MsgProcessed;
        }, std::move(aReject));
    }
    else {
        aReject(::mozilla::ipc::ResponseRejectReason::SendError);
    }
    return;
}

auto PFileSystemManagerChild::SendRenameEntry(const FileSystemRenameEntryRequest& request) -> RefPtr<RenameEntryPromise>
{
    RefPtr<MozPromise<FileSystemMoveEntryResponse, ResponseRejectReason, true>::Private> promise__ = new MozPromise<FileSystemMoveEntryResponse, ResponseRejectReason, true>::Private(__func__);
    promise__->UseDirectTaskDispatch(__func__);
    SendRenameEntry(std::move(request), [promise__](FileSystemMoveEntryResponse&& aValue) {
        promise__->Resolve(std::move(aValue), __func__);
    }, [promise__](ResponseRejectReason&& aReason) {
        promise__->Reject(std::move(aReason), __func__);
    });
    return promise__;
}

auto PFileSystemManagerChild::DeallocManagee(
        mozilla::ipc::ProtocolId aProtocolId,
        IProtocol* aListener) -> void
{
    switch (aProtocolId) {
    default:
        FatalError("unreached");
        return;
    }
}

auto PFileSystemManagerChild::OnMessageReceived(const Message& msg__) -> PFileSystemManagerChild::Result
{
    IPC::Message::routeid_t route__ = msg__.routing_id();
    if (MSG_ROUTING_CONTROL != route__) {
        IProtocol* routed__ = Lookup(route__);
        if (!routed__ || !routed__->GetLifecycleProxy()) {
            if (mozilla::ipc::LoggingEnabledFor("PFileSystemManager", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PFileSystemManagerChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Ignored message for dead actor",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eSending);
            }
            return MsgProcessed;

        }

        RefPtr<mozilla::ipc::ActorLifecycleProxy> proxy__ =
            routed__->GetLifecycleProxy();
        return proxy__->Get()->OnMessageReceived(msg__);
    }

    switch (msg__.type()) {
    case PFileSystemManager::Reply_GetRootHandle__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PFileSystemManager", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PFileSystemManagerChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }

            AUTO_PROFILER_LABEL("PFileSystemManager::Msg_GetRootHandle", OTHER);


            return mAsyncCallbacks.GotReply(this, msg__);
        }
    case PFileSystemManager::Reply_GetDirectoryHandle__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PFileSystemManager", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PFileSystemManagerChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }

            AUTO_PROFILER_LABEL("PFileSystemManager::Msg_GetDirectoryHandle", OTHER);


            return mAsyncCallbacks.GotReply(this, msg__);
        }
    case PFileSystemManager::Reply_GetFileHandle__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PFileSystemManager", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PFileSystemManagerChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }

            AUTO_PROFILER_LABEL("PFileSystemManager::Msg_GetFileHandle", OTHER);


            return mAsyncCallbacks.GotReply(this, msg__);
        }
    case PFileSystemManager::Reply_GetFile__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PFileSystemManager", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PFileSystemManagerChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }

            AUTO_PROFILER_LABEL("PFileSystemManager::Msg_GetFile", OTHER);


            return mAsyncCallbacks.GotReply(this, msg__);
        }
    case PFileSystemManager::Reply_GetAccessHandle__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PFileSystemManager", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PFileSystemManagerChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }

            AUTO_PROFILER_LABEL("PFileSystemManager::Msg_GetAccessHandle", OTHER);


            return mAsyncCallbacks.GotReply(this, msg__);
        }
    case PFileSystemManager::Reply_GetWritable__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PFileSystemManager", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PFileSystemManagerChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }

            AUTO_PROFILER_LABEL("PFileSystemManager::Msg_GetWritable", OTHER);


            return mAsyncCallbacks.GotReply(this, msg__);
        }
    case PFileSystemManager::Reply_Resolve__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PFileSystemManager", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PFileSystemManagerChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }

            AUTO_PROFILER_LABEL("PFileSystemManager::Msg_Resolve", OTHER);


            return mAsyncCallbacks.GotReply(this, msg__);
        }
    case PFileSystemManager::Reply_GetEntries__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PFileSystemManager", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PFileSystemManagerChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }

            AUTO_PROFILER_LABEL("PFileSystemManager::Msg_GetEntries", OTHER);


            return mAsyncCallbacks.GotReply(this, msg__);
        }
    case PFileSystemManager::Reply_RemoveEntry__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PFileSystemManager", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PFileSystemManagerChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }

            AUTO_PROFILER_LABEL("PFileSystemManager::Msg_RemoveEntry", OTHER);


            return mAsyncCallbacks.GotReply(this, msg__);
        }
    case PFileSystemManager::Reply_MoveEntry__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PFileSystemManager", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PFileSystemManagerChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }

            AUTO_PROFILER_LABEL("PFileSystemManager::Msg_MoveEntry", OTHER);


            return mAsyncCallbacks.GotReply(this, msg__);
        }
    case PFileSystemManager::Reply_RenameEntry__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PFileSystemManager", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PFileSystemManagerChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }

            AUTO_PROFILER_LABEL("PFileSystemManager::Msg_RenameEntry", OTHER);


            return mAsyncCallbacks.GotReply(this, msg__);
        }
    case PFileSystemManager::Msg_PFileSystemWritableFileStreamConstructor__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PFileSystemManager", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PFileSystemManagerChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PFileSystemManager::Msg_PFileSystemWritableFileStreamConstructor", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__actorid__ = IPC::ReadParam<mozilla::ipc::ActorId>((&(reader__)));
            if (!maybe__actorid__) {
                FatalError("Error deserializing 'mozilla::ipc::ActorId'");
                return MsgValueError;

            }
            auto& actorid__ = *maybe__actorid__;
            // Sentinel = 'actorid'
            if ((!(((&(reader__)))->ReadSentinel(193725159)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'mozilla::ipc::ActorId'");
                return MsgValueError;
            }
            reader__.EndRead();
            RefPtr<PFileSystemWritableFileStreamChild> actor = (static_cast<FileSystemManagerChild*>(this))->AllocPFileSystemWritableFileStreamChild();
            if (!actor) {
                NS_WARNING("Cannot bind null PFileSystemWritableFileStreamChild actor");
                return MsgValueError;
            }

            if (!actor->SetManagerAndRegister(this, actorid__)) {
                NS_WARNING("Failed to bind PFileSystemWritableFileStreamChild actor");
                return MsgValueError;
            }

            mozilla::ipc::IPCResult __ok = (static_cast<FileSystemManagerChild*>(this))->RecvPFileSystemWritableFileStreamConstructor(actor);
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PFileSystemManager::Msg_CloseAll__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PFileSystemManager", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PFileSystemManagerChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PFileSystemManager::Msg_CloseAll", OTHER);

            mozilla::ipc::ActorId id__ = MSG_ROUTING_CONTROL;
            UniquePtr<IPC::Message> reply__(PFileSystemManager::Reply_CloseAll(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            CloseAllResolver resolver = [resolver__ = std::move(resolver__)](const nsresult& aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), aParam);
                    // Sentinel = 'rv'
                    ((&(writer__)))->WriteSentinel(22806761);

                    if (mozilla::ipc::LoggingEnabledFor("PFileSystemManager", mozilla::ipc::ChildSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PFileSystemManagerChild",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (static_cast<FileSystemManagerChild*>(this))->RecvCloseAll(std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    case SHMEM_CREATED_MESSAGE_TYPE:
        {
            if (!ShmemCreated(msg__)) {
                return MsgPayloadError;
            }
            return MsgProcessed;
        }
    case SHMEM_DESTROYED_MESSAGE_TYPE:
        {
            if (!ShmemDestroyed(msg__)) {
                return MsgPayloadError;
            }
            return MsgProcessed;
        }
    }
}

auto PFileSystemManagerChild::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PFileSystemManagerChild::Result
{
    MOZ_ASSERT_UNREACHABLE("message protocol not supported");
    return MsgNotKnown;
}



} // namespace dom
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::dom::PFileSystemManagerChild*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    IPC::WriteParam(aWriter, static_cast<mozilla::ipc::IProtocol*>(aVar));
    // Sentinel = 'PFileSystemManager'
    (aWriter)->WriteSentinel(1099892497);
}

auto ParamTraits<::mozilla::dom::PFileSystemManagerChild*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    auto maybe__actor = IPC::ReadParam<mozilla::ipc::IProtocol*>(aReader);
    if (!maybe__actor) {
        aReader->FatalError("Error deserializing managed PFileSystemManager actor");
        return {};

    }
    auto& actor = *maybe__actor;
    // Sentinel = 'PFileSystemManager'
    if ((!((aReader)->ReadSentinel(1099892497)))) {
        mozilla::ipc::SentinelReadError("Error deserializing managed PFileSystemManager actor");
        return {};
    }

    if (actor && actor->GetProtocolId() != PFileSystemManagerMsgStart) {
        aReader->FatalError("Unexpected actor type (expected PFileSystemManager)");

        return {};
    }
    return static_cast<::mozilla::dom::PFileSystemManagerChild*>(actor);
}

} // namespace IPC
