
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kjobwidgets_python.h"

// main header
#include "knotificationjobuidelegate_wrapper.h"

// Wrappers providing overrides
#include "knotificationjobuidelegate_wrapper.h"

// Argument includes
#include <QString>
#include <kjob.h>
#include <qobject.h>
#include <qobjectdefs.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KNotificationJobUiDelegate_Type = nullptr;
static PyTypeObject *Sbk_KNotificationJobUiDelegate_TypeF(void)
{
    return _Sbk_KNotificationJobUiDelegate_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void KNotificationJobUiDelegateWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

KNotificationJobUiDelegateWrapper::KNotificationJobUiDelegateWrapper(::QFlags<KJobUiDelegate::Flag> flags) : KNotificationJobUiDelegate(flags)
{
}

void KNotificationJobUiDelegateWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNotificationJobUiDelegate_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    sbk_o_childEvent("KNotificationJobUiDelegate", funcName, gil, pyOverride, event);
}

void KNotificationJobUiDelegateWrapper::sbk_o_childEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QChildEvent * event)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[1] = {
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QChildEvent_IDX]), event)
    };

    const bool invalidateArg1 = Py_REFCNT(pyArgArray[0]) == 1;
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QChildEvent_IDX]), event)
    ));
    bool invalidateArg1 = Py_REFCNT(PyTuple_GetItem(pyArgs, 0)) == 1;
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 1, nullptr));
    if (invalidateArg1)
        Shiboken::Object::invalidate(pyArgArray[0]);
    Py_DECREF(pyArgArray[0]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GetItem(pyArgs, 0));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return;
    }
}

void KNotificationJobUiDelegateWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNotificationJobUiDelegate_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    sbk_o_connectNotify("KNotificationJobUiDelegate", funcName, gil, pyOverride, signal);
}

void KNotificationJobUiDelegateWrapper::sbk_o_connectNotify(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, const ::QMetaMethod & signal)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[1] = {
        Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QMetaMethod_IDX]), &signal)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
        Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QMetaMethod_IDX]), &signal)
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 1, nullptr));
    Py_DECREF(pyArgArray[0]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return;
    }
}

void KNotificationJobUiDelegateWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNotificationJobUiDelegate_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    sbk_o_customEvent("KNotificationJobUiDelegate", funcName, gil, pyOverride, event);
}

void KNotificationJobUiDelegateWrapper::sbk_o_customEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QEvent * event)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[1] = {
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QEvent_IDX]), event)
    };

    const bool invalidateArg1 = Py_REFCNT(pyArgArray[0]) == 1;
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QEvent_IDX]), event)
    ));
    bool invalidateArg1 = Py_REFCNT(PyTuple_GetItem(pyArgs, 0)) == 1;
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 1, nullptr));
    if (invalidateArg1)
        Shiboken::Object::invalidate(pyArgArray[0]);
    Py_DECREF(pyArgArray[0]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GetItem(pyArgs, 0));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return;
    }
}

void KNotificationJobUiDelegateWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNotificationJobUiDelegate_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    KNotificationJobUiDelegateWrapper::sbk_o_connectNotify("KNotificationJobUiDelegate", funcName, gil, pyOverride, signal);
}

bool KNotificationJobUiDelegateWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNotificationJobUiDelegate_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::event(event);
    }
    return sbk_o_event("KNotificationJobUiDelegate", funcName, gil, pyOverride, event);
}

bool KNotificationJobUiDelegateWrapper::sbk_o_event(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QEvent * event)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[1] = {
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QEvent_IDX]), event)
    };

    const bool invalidateArg1 = Py_REFCNT(pyArgArray[0]) == 1;
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QEvent_IDX]), event)
    ));
    bool invalidateArg1 = Py_REFCNT(PyTuple_GetItem(pyArgs, 0)) == 1;
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 1, nullptr));
    if (invalidateArg1)
        Shiboken::Object::invalidate(pyArgArray[0]);
    Py_DECREF(pyArgArray[0]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GetItem(pyArgs, 0));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return false;
    }
    // Check return type
    Shiboken::Conversions::PythonToCppConversion pythonToCpp =
        Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::Warnings::warnInvalidReturnValue(ownerClassName, funcName, "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool KNotificationJobUiDelegateWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNotificationJobUiDelegate_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return sbk_o_eventFilter("KNotificationJobUiDelegate", funcName, gil, pyOverride, watched, event);
}

bool KNotificationJobUiDelegateWrapper::sbk_o_eventFilter(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QObject * watched, ::QEvent * event)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[2] = {
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), watched),
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QEvent_IDX]), event)
    };

    const bool invalidateArg2 = Py_REFCNT(pyArgArray[1]) == 1;
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), watched),
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QEvent_IDX]), event)
    ));
    bool invalidateArg2 = Py_REFCNT(PyTuple_GetItem(pyArgs, 1)) == 1;
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 2, nullptr));
    if (invalidateArg2)
        Shiboken::Object::invalidate(pyArgArray[1]);
    Py_DECREF(pyArgArray[0]);
    Py_DECREF(pyArgArray[1]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GetItem(pyArgs, 1));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return false;
    }
    // Check return type
    Shiboken::Conversions::PythonToCppConversion pythonToCpp =
        Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::Warnings::warnInvalidReturnValue(ownerClassName, funcName, "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool KNotificationJobUiDelegateWrapper::setJob(::KJob * job)
{
    static const char *funcName = "setJob";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNotificationJobUiDelegate_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::KNotificationJobUiDelegate::setJob(job);
    }
    return sbk_o_setJob("KNotificationJobUiDelegate", funcName, gil, pyOverride, job);
}

bool KNotificationJobUiDelegateWrapper::sbk_o_setJob(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::KJob * job)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[1] = {
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), job)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), job)
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 1, nullptr));
    Py_DECREF(pyArgArray[0]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return false;
    }
    // Check return type
    Shiboken::Conversions::PythonToCppConversion pythonToCpp =
        Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::Warnings::warnInvalidReturnValue(ownerClassName, funcName, "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void KNotificationJobUiDelegateWrapper::showErrorMessage()
{
    static const char *funcName = "showErrorMessage";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNotificationJobUiDelegate_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        return this->::KNotificationJobUiDelegate::showErrorMessage();
    }
    sbk_o_showErrorMessage("KNotificationJobUiDelegate", funcName, gil, pyOverride);
}

void KNotificationJobUiDelegateWrapper::sbk_o_showErrorMessage(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if defined(PYPY_VERSION) || (defined(Py_LIMITED_API) && Py_LIMITED_API < 0x030A0000)
    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));
#endif

#if !defined(PYPY_VERSION) && ((defined(Py_LIMITED_API) && Py_LIMITED_API >= 0x030A0000) || !defined(Py_LIMITED_API))
    Shiboken::AutoDecRef pyResult(PyObject_CallNoArgs(pyOverride));
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return;
    }
}

void KNotificationJobUiDelegateWrapper::slotWarning(::KJob * job, const ::QString & message)
{
    static const char *funcName = "slotWarning";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNotificationJobUiDelegate_TypeF(), gil, funcName, m_PyMethodCache[8], nameCache));
    if (pyOverride.isNull()) {
        return this->::KNotificationJobUiDelegate::slotWarning(job, message);
    }
    sbk_o_slotWarning("KNotificationJobUiDelegate", funcName, gil, pyOverride, job, message);
}

void KNotificationJobUiDelegateWrapper::sbk_o_slotWarning(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::KJob * job, const ::QString & message)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[2] = {
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), job),
        Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &message)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), job),
        Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &message)
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 2, nullptr));
    Py_DECREF(pyArgArray[0]);
    Py_DECREF(pyArgArray[1]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return;
    }
}

void KNotificationJobUiDelegateWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KNotificationJobUiDelegate_TypeF(), gil, funcName, m_PyMethodCache[9], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    sbk_o_timerEvent("KNotificationJobUiDelegate", funcName, gil, pyOverride, event);
}

void KNotificationJobUiDelegateWrapper::sbk_o_timerEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QTimerEvent * event)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[1] = {
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QTimerEvent_IDX]), event)
    };

    const bool invalidateArg1 = Py_REFCNT(pyArgArray[0]) == 1;
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QTimerEvent_IDX]), event)
    ));
    bool invalidateArg1 = Py_REFCNT(PyTuple_GetItem(pyArgs, 0)) == 1;
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 1, nullptr));
    if (invalidateArg1)
        Shiboken::Object::invalidate(pyArgArray[0]);
    Py_DECREF(pyArgArray[0]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GetItem(pyArgs, 0));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return;
    }
}

const QMetaObject *KNotificationJobUiDelegateWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return KNotificationJobUiDelegate::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int KNotificationJobUiDelegateWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = KNotificationJobUiDelegate::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *KNotificationJobUiDelegateWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< KNotificationJobUiDelegateWrapper *>(this));
    }
    return KNotificationJobUiDelegate::qt_metacast(_clname);
}

KNotificationJobUiDelegateWrapper::~KNotificationJobUiDelegateWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_KNotificationJobUiDelegate_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KNotificationJobUiDelegate_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KNotificationJobUiDelegate >()))
        return -1;

    KNotificationJobUiDelegateWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|O:KNotificationJobUiDelegate", &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KNotificationJobUiDelegate::KNotificationJobUiDelegate(QFlags<KJobUiDelegate::Flag>=)
    if (numArgs == 0) {
        overloadId = 0; // KNotificationJobUiDelegate(QFlags<KJobUiDelegate::Flag>)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_QFlags_KJobUiDelegate_Flag_IDX])))->flagsConverter, (pyArgs[0])))) {
        overloadId = 0; // KNotificationJobUiDelegate(QFlags<KJobUiDelegate::Flag>)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKJobWidgetsTypeStructs[SBK_KNotificationJobUiDelegate_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkKJobWidgetsTypeStructs[SBK_KNotificationJobUiDelegate_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"flags", 0}};
            if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_QFlags_KJobUiDelegate_Flag_IDX])))->flagsConverter, (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKJobWidgetsTypeStructs[SBK_KNotificationJobUiDelegate_IDX]);
            }
        }
        ::QFlags<KJobUiDelegate::Flag> cppArg0({KJobUiDelegate::AutoHandlingDisabled});
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // KNotificationJobUiDelegate(QFlags<KJobUiDelegate::Flag>)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr != nullptr) {
                cptr = new (addr) KNotificationJobUiDelegateWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(nullptr);
            } else {
                cptr = new KNotificationJobUiDelegateWrapper(cppArg0);
            }

        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< KNotificationJobUiDelegate >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKJobWidgetsTypeStructs[SBK_KNotificationJobUiDelegate_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKJobWidgetsTypeStructs[SBK_KNotificationJobUiDelegate_IDX]);
    };


    return 1;
}

static PyObject *Sbk_KNotificationJobUiDelegateFunc_setJob(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNotificationJobUiDelegate *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKJobWidgetsTypeStructs[SBK_KNotificationJobUiDelegate_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KJobUiDelegate::setJob(KJob*)->bool
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), (pyArg)))) {
        overloadId = 0; // setJob(KJob*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setJob", errInfo, SbkKJobWidgetsTypeStructs[SBK_KNotificationJobUiDelegate_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::KJob *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setJob(KJob*)
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KNotificationJobUiDelegate::setJob(cppArg0)
                : cppSelf->setJob(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KNotificationJobUiDelegateFunc_showErrorMessage(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNotificationJobUiDelegate *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKJobWidgetsTypeStructs[SBK_KNotificationJobUiDelegate_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // showErrorMessage()
        Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
            ? cppSelf->::KNotificationJobUiDelegate::showErrorMessage()
            : cppSelf->showErrorMessage();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KNotificationJobUiDelegateFunc_slotWarning(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KNotificationJobUiDelegate *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKJobWidgetsTypeStructs[SBK_KNotificationJobUiDelegate_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "slotWarning", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KJobUiDelegate::slotWarning(KJob*,QString)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
        overloadId = 0; // slotWarning(KJob*,QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "slotWarning", errInfo, SbkKJobWidgetsTypeStructs[SBK_KNotificationJobUiDelegate_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::KJob *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // slotWarning(KJob*,QString)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KNotificationJobUiDelegate::slotWarning(cppArg0, cppArg1)
                : cppSelf->slotWarning(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}


static const char *Sbk_KNotificationJobUiDelegate_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_KNotificationJobUiDelegate_methods[] = {
    {"setJob", reinterpret_cast<PyCFunction>(Sbk_KNotificationJobUiDelegateFunc_setJob), METH_O, nullptr},
    {"showErrorMessage", reinterpret_cast<PyCFunction>(Sbk_KNotificationJobUiDelegateFunc_showErrorMessage), METH_NOARGS, nullptr},
    {"slotWarning", reinterpret_cast<PyCFunction>(Sbk_KNotificationJobUiDelegateFunc_slotWarning), METH_VARARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_KNotificationJobUiDelegate_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::KNotificationJobUiDelegate *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKJobWidgetsTypeStructs[SBK_KNotificationJobUiDelegate_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<KNotificationJobUiDelegateWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_KNotificationJobUiDelegate_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KNotificationJobUiDelegate_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KNotificationJobUiDelegate_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_KNotificationJobUiDelegate_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KNotificationJobUiDelegate_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KNotificationJobUiDelegate_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KNotificationJobUiDelegate_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KNotificationJobUiDelegate_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KNotificationJobUiDelegate_spec = {
    "1:KJobWidgets.KNotificationJobUiDelegate",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KNotificationJobUiDelegate_slots
};

} //extern "C"

static void *Sbk_KNotificationJobUiDelegate_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::KNotificationJobUiDelegate *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KNotificationJobUiDelegate_PythonToCpp_KNotificationJobUiDelegate_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KNotificationJobUiDelegate_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KNotificationJobUiDelegate_PythonToCpp_KNotificationJobUiDelegate_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KNotificationJobUiDelegate_TypeF()))
        return KNotificationJobUiDelegate_PythonToCpp_KNotificationJobUiDelegate_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KNotificationJobUiDelegate_PTR_CppToPython_KNotificationJobUiDelegate(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::KNotificationJobUiDelegate *>(const_cast<void *>(cppIn)), Sbk_KNotificationJobUiDelegate_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KNotificationJobUiDelegate_SignatureStrings[] = {
    "KJobWidgets.KNotificationJobUiDelegate(self,flags:KCoreAddons.KJobUiDelegate.Flag={KJobUiDelegate.AutoHandlingDisabled})",
    "KJobWidgets.KNotificationJobUiDelegate.setJob(self,job:KCoreAddons.KJob)->bool",
    "KJobWidgets.KNotificationJobUiDelegate.showErrorMessage(self)",
    "KJobWidgets.KNotificationJobUiDelegate.slotWarning(self,job:KCoreAddons.KJob,message:QString)",
    nullptr}; // Sentinel
#else
static constexpr size_t KNotificationJobUiDelegate_SignatureByteSize = 161;
static constexpr uint8_t KNotificationJobUiDelegate_SignatureBytes[161] = {
    0x78, 0xda, 0x8d, 0x8f, 0x4d, 0x0a, 0xc2, 0x30, 0x10, 0x85, 0xf7, 0x3d, 0x89, 0x85, 0xda, 0x03,
    0x08, 0x0a, 0xc5, 0x2a, 0x62, 0x50, 0x10, 0x91, 0xae, 0x27, 0x66, 0x1a, 0x47, 0xc6, 0x0c, 0x24,
    0x23, 0x2e, 0xc4, 0xbb, 0x1b, 0xe8, 0x4a, 0x45, 0xe8, 0xf6, 0xf1, 0xbd, 0x3f, 0xb3, 0x15, 0xdb,
    0x91, 0xf3, 0xa8, 0xa9, 0x36, 0x7b, 0x51, 0xea, 0xe9, 0x0c, 0x4a, 0x12, 0xb2, 0x7e, 0xa2, 0x16,
    0x19, 0x3d, 0x28, 0x4e, 0x12, 0x72, 0x5f, 0xf5, 0x0c, 0x3e, 0xcd, 0xcc, 0x52, 0x22, 0x36, 0xce,
    0x49, 0xc8, 0x8e, 0x0f, 0xaa, 0x5e, 0x67, 0x60, 0xfe, 0xfc, 0x12, 0x9b, 0xbb, 0xca, 0x06, 0x82,
    0x63, 0x0a, 0xbe, 0xa5, 0x04, 0x96, 0xd1, 0xbd, 0xca, 0xc2, 0x8c, 0x2a, 0xae, 0x13, 0x6a, 0x16,
    0x86, 0xfe, 0xab, 0xd8, 0x9f, 0xf6, 0x72, 0xba, 0xb0, 0x22, 0x3c, 0x3a, 0xee, 0x22, 0x8f, 0x55,
    0x8c, 0x12, 0x77, 0x98, 0x12, 0xf8, 0xe1, 0xd8, 0xf8, 0x31, 0x2c, 0xda, 0x41, 0x0c, 0xf9, 0xc9,
    0xff, 0x45, 0xd5, 0x6d, 0x88, 0x9e, 0x1d, 0x8e, 0x1a, 0x33, 0x59, 0x16, 0x6f, 0xfd, 0xf5, 0x83,
    0x8d
};
#endif

PyTypeObject *init_KNotificationJobUiDelegate(PyObject *module)
{
    if (SbkKJobWidgetsTypeStructs[SBK_KNotificationJobUiDelegate_IDX].type != nullptr)
        return SbkKJobWidgetsTypeStructs[SBK_KNotificationJobUiDelegate_IDX].type;

    Shiboken::AutoDecRef Sbk_KNotificationJobUiDelegate_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJobUiDelegate_IDX]))));

    _Sbk_KNotificationJobUiDelegate_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KNotificationJobUiDelegate",
        "KNotificationJobUiDelegate*",
        &Sbk_KNotificationJobUiDelegate_spec,
        &Shiboken::callCppDestructor< KNotificationJobUiDelegate >,
        Sbk_KNotificationJobUiDelegate_Type_bases.object(),
        0);
    auto *pyType = Sbk_KNotificationJobUiDelegate_TypeF(); // references _Sbk_KNotificationJobUiDelegate_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KNotificationJobUiDelegate_SignatureStrings);
#else
    InitSignatureBytes(pyType, KNotificationJobUiDelegate_SignatureBytes, KNotificationJobUiDelegate_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KNotificationJobUiDelegate_PropertyStrings);
    SbkKJobWidgetsTypeStructs[SBK_KNotificationJobUiDelegate_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KNotificationJobUiDelegate_PythonToCpp_KNotificationJobUiDelegate_PTR,
        is_KNotificationJobUiDelegate_PythonToCpp_KNotificationJobUiDelegate_PTR_Convertible,
        KNotificationJobUiDelegate_PTR_CppToPython_KNotificationJobUiDelegate);

    Shiboken::Conversions::registerConverterName(converter, "KNotificationJobUiDelegate");
    Shiboken::Conversions::registerConverterName(converter, "KNotificationJobUiDelegate*");
    Shiboken::Conversions::registerConverterName(converter, "KNotificationJobUiDelegate&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KNotificationJobUiDelegate).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(KNotificationJobUiDelegateWrapper).name());

    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_KNotificationJobUiDelegate_TypeF(), &Sbk_KNotificationJobUiDelegate_typeDiscovery);

    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::KNotificationJobUiDelegate::staticMetaObject, sizeof(KNotificationJobUiDelegateWrapper));

    return pyType;
}
