
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kwidgetsaddons_python.h"

// main header
#include "kdragwidgetdecoratorbase_wrapper.h"

// Wrappers providing overrides
#include "kxyselector_wrapper.h"
#include "ktimecombobox_wrapper.h"

// Argument includes
#include <qcoreevent.h>
#include <qmetaobject.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qwidget.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KDragWidgetDecoratorBase_Type = nullptr;
static PyTypeObject *Sbk_KDragWidgetDecoratorBase_TypeF(void)
{
    return _Sbk_KDragWidgetDecoratorBase_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void KDragWidgetDecoratorBaseWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

KDragWidgetDecoratorBaseWrapper::KDragWidgetDecoratorBaseWrapper(::QWidget * parent) : KDragWidgetDecoratorBase(parent)
{
}

void KDragWidgetDecoratorBaseWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDragWidgetDecoratorBase_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    KXYSelectorWrapper::sbk_o_childEvent("KDragWidgetDecoratorBase", funcName, gil, pyOverride, event);
}

void KDragWidgetDecoratorBaseWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDragWidgetDecoratorBase_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KDragWidgetDecoratorBase", funcName, gil, pyOverride, signal);
}

void KDragWidgetDecoratorBaseWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDragWidgetDecoratorBase_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    KXYSelectorWrapper::sbk_o_customEvent("KDragWidgetDecoratorBase", funcName, gil, pyOverride, event);
}

void KDragWidgetDecoratorBaseWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDragWidgetDecoratorBase_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KDragWidgetDecoratorBase", funcName, gil, pyOverride, signal);
}

::QDrag * KDragWidgetDecoratorBaseWrapper::dragObject()
{
    static const char *funcName = "dragObject";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDragWidgetDecoratorBase_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::KDragWidgetDecoratorBase::dragObject();
    }
    return sbk_o_dragObject("KDragWidgetDecoratorBase", funcName, gil, pyOverride);
}

::QDrag * KDragWidgetDecoratorBaseWrapper::sbk_o_dragObject(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if defined(PYPY_VERSION) || (defined(Py_LIMITED_API) && Py_LIMITED_API < 0x030A0000)
    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));
#endif

#if !defined(PYPY_VERSION) && ((defined(Py_LIMITED_API) && Py_LIMITED_API >= 0x030A0000) || !defined(Py_LIMITED_API))
    Shiboken::AutoDecRef pyResult(PyObject_CallNoArgs(pyOverride));
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return nullptr;
    }
    // Check return type
    Shiboken::Conversions::PythonToCppConversion pythonToCpp =
        Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QDrag_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::Warnings::warnInvalidReturnValue(ownerClassName, funcName, PepType_GetFullyQualifiedNameStr(Shiboken::SbkType< QDrag >()), Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::QDrag *cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool KDragWidgetDecoratorBaseWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDragWidgetDecoratorBase_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::event(event);
    }
    return KXYSelectorWrapper::sbk_o_event("KDragWidgetDecoratorBase", funcName, gil, pyOverride, event);
}

bool KDragWidgetDecoratorBaseWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDragWidgetDecoratorBase_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::KDragWidgetDecoratorBase::eventFilter(watched, event);
    }
    return KXYSelectorWrapper::sbk_o_eventFilter("KDragWidgetDecoratorBase", funcName, gil, pyOverride, watched, event);
}

void KDragWidgetDecoratorBaseWrapper::startDrag()
{
    static const char *funcName = "startDrag";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDragWidgetDecoratorBase_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        return this->::KDragWidgetDecoratorBase::startDrag();
    }
    KTimeComboBoxWrapper::sbk_o_hidePopup("KDragWidgetDecoratorBase", funcName, gil, pyOverride);
}

void KDragWidgetDecoratorBaseWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KDragWidgetDecoratorBase_TypeF(), gil, funcName, m_PyMethodCache[8], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    KXYSelectorWrapper::sbk_o_timerEvent("KDragWidgetDecoratorBase", funcName, gil, pyOverride, event);
}

const QMetaObject *KDragWidgetDecoratorBaseWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return KDragWidgetDecoratorBase::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int KDragWidgetDecoratorBaseWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = KDragWidgetDecoratorBase::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *KDragWidgetDecoratorBaseWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< KDragWidgetDecoratorBaseWrapper *>(this));
    }
    return KDragWidgetDecoratorBase::qt_metacast(_clname);
}

KDragWidgetDecoratorBaseWrapper::~KDragWidgetDecoratorBaseWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_KDragWidgetDecoratorBase_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KDragWidgetDecoratorBase_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KDragWidgetDecoratorBase >()))
        return -1;

    KDragWidgetDecoratorBaseWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|O:KDragWidgetDecoratorBase", &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KDragWidgetDecoratorBase::KDragWidgetDecoratorBase(QWidget*=)
    if (numArgs == 0) {
        overloadId = 0; // KDragWidgetDecoratorBase(QWidget*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0])))) {
        overloadId = 0; // KDragWidgetDecoratorBase(QWidget*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KDragWidgetDecoratorBase_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkKWidgetsAddonsTypeStructs[SBK_KDragWidgetDecoratorBase_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 0}};
            if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KDragWidgetDecoratorBase_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QWidget *cppArg0 = nullptr;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // KDragWidgetDecoratorBase(QWidget*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr != nullptr) {
                cptr = new (addr) KDragWidgetDecoratorBaseWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(nullptr);
            } else {
                cptr = new KDragWidgetDecoratorBaseWrapper(cppArg0);
            }

        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< KDragWidgetDecoratorBase >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KDragWidgetDecoratorBase_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KDragWidgetDecoratorBase_IDX]);
    };


    return 1;
}

static PyObject *Sbk_KDragWidgetDecoratorBaseFunc_decoratedWidget(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDragWidgetDecoratorBase *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDragWidgetDecoratorBase_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // decoratedWidget()const
        QWidget * cppResult = const_cast<const ::KDragWidgetDecoratorBase *>(cppSelf)->decoratedWidget();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KDragWidgetDecoratorBaseFunc_dragObject(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDragWidgetDecoratorBase *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDragWidgetDecoratorBase_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // dragObject()
        QDrag * cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
            ? cppSelf->::KDragWidgetDecoratorBase::dragObject()
            : cppSelf->dragObject();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QDrag_IDX]), cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KDragWidgetDecoratorBaseFunc_eventFilter(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDragWidgetDecoratorBase *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDragWidgetDecoratorBase_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "eventFilter", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: QObject::eventFilter(QObject*,QEvent*)->bool
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QEvent_IDX]), (pyArgs[1])))) {
        overloadId = 0; // eventFilter(QObject*,QEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "eventFilter", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KDragWidgetDecoratorBase_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QObject *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QEvent *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // eventFilter(QObject*,QEvent*)
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KDragWidgetDecoratorBase::eventFilter(cppArg0, cppArg1)
                : cppSelf->eventFilter(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KDragWidgetDecoratorBaseFunc_isDragEnabled(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDragWidgetDecoratorBase *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDragWidgetDecoratorBase_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isDragEnabled()const
        bool cppResult = const_cast<const ::KDragWidgetDecoratorBase *>(cppSelf)->isDragEnabled();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KDragWidgetDecoratorBaseFunc_setDragEnabled(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDragWidgetDecoratorBase *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDragWidgetDecoratorBase_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KDragWidgetDecoratorBase::setDragEnabled(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setDragEnabled(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setDragEnabled", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KDragWidgetDecoratorBase_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setDragEnabled(bool)
            cppSelf->setDragEnabled(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KDragWidgetDecoratorBaseFunc_startDrag(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KDragWidgetDecoratorBase *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDragWidgetDecoratorBase_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // startDrag()
        Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
            ? cppSelf->::KDragWidgetDecoratorBase::startDrag()
            : cppSelf->startDrag();
    }

     return Sbk_ReturnFromPython_None();
}


static const char *Sbk_KDragWidgetDecoratorBase_PropertyStrings[] = {
    "isDragEnabled::setDragEnabled",
    nullptr // Sentinel
};

static PyMethodDef Sbk_KDragWidgetDecoratorBase_methods[] = {
    {"decoratedWidget", reinterpret_cast<PyCFunction>(Sbk_KDragWidgetDecoratorBaseFunc_decoratedWidget), METH_NOARGS, nullptr},
    {"dragObject", reinterpret_cast<PyCFunction>(Sbk_KDragWidgetDecoratorBaseFunc_dragObject), METH_NOARGS, nullptr},
    {"eventFilter", reinterpret_cast<PyCFunction>(Sbk_KDragWidgetDecoratorBaseFunc_eventFilter), METH_VARARGS, nullptr},
    {"isDragEnabled", reinterpret_cast<PyCFunction>(Sbk_KDragWidgetDecoratorBaseFunc_isDragEnabled), METH_NOARGS, nullptr},
    {"setDragEnabled", reinterpret_cast<PyCFunction>(Sbk_KDragWidgetDecoratorBaseFunc_setDragEnabled), METH_O, nullptr},
    {"startDrag", reinterpret_cast<PyCFunction>(Sbk_KDragWidgetDecoratorBaseFunc_startDrag), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_KDragWidgetDecoratorBase_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::KDragWidgetDecoratorBase *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KDragWidgetDecoratorBase_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<KDragWidgetDecoratorBaseWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_KDragWidgetDecoratorBase_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KDragWidgetDecoratorBase_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KDragWidgetDecoratorBase_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_KDragWidgetDecoratorBase_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KDragWidgetDecoratorBase_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KDragWidgetDecoratorBase_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KDragWidgetDecoratorBase_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KDragWidgetDecoratorBase_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KDragWidgetDecoratorBase_spec = {
    "1:KWidgetsAddons.KDragWidgetDecoratorBase",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KDragWidgetDecoratorBase_slots
};

} //extern "C"

static void *Sbk_KDragWidgetDecoratorBase_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::KDragWidgetDecoratorBase *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KDragWidgetDecoratorBase_PythonToCpp_KDragWidgetDecoratorBase_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KDragWidgetDecoratorBase_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KDragWidgetDecoratorBase_PythonToCpp_KDragWidgetDecoratorBase_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KDragWidgetDecoratorBase_TypeF()))
        return KDragWidgetDecoratorBase_PythonToCpp_KDragWidgetDecoratorBase_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KDragWidgetDecoratorBase_PTR_CppToPython_KDragWidgetDecoratorBase(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::KDragWidgetDecoratorBase *>(const_cast<void *>(cppIn)), Sbk_KDragWidgetDecoratorBase_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KDragWidgetDecoratorBase_SignatureStrings[] = {
    "KWidgetsAddons.KDragWidgetDecoratorBase(self,parent:PySide6.QtWidgets.QWidget=nullptr,*:KeywordOnly=None,isDragEnabled:bool=None)",
    "KWidgetsAddons.KDragWidgetDecoratorBase.decoratedWidget(self)->PySide6.QtWidgets.QWidget",
    "KWidgetsAddons.KDragWidgetDecoratorBase.dragObject(self)->PySide6.QtGui.QDrag",
    "KWidgetsAddons.KDragWidgetDecoratorBase.eventFilter(self,watched:PySide6.QtCore.QObject,event:PySide6.QtCore.QEvent)->bool",
    "KWidgetsAddons.KDragWidgetDecoratorBase.isDragEnabled(self)->bool",
    "KWidgetsAddons.KDragWidgetDecoratorBase.setDragEnabled(self,enable:bool)",
    "KWidgetsAddons.KDragWidgetDecoratorBase.startDrag(self)",
    nullptr}; // Sentinel
#else
static constexpr size_t KDragWidgetDecoratorBase_SignatureByteSize = 219;
static constexpr uint8_t KDragWidgetDecoratorBase_SignatureBytes[219] = {
    0x78, 0xda, 0x95, 0x91, 0xcb, 0x0a, 0x02, 0x31, 0x0c, 0x45, 0xf7, 0x7e, 0x89, 0x4a, 0xed, 0xd2,
    0xc5, 0x80, 0x82, 0x8f, 0xd1, 0xc5, 0x80, 0x3a, 0xb8, 0x70, 0xdd, 0x99, 0xc6, 0xb1, 0x52, 0x5a,
    0x49, 0xab, 0x32, 0x7f, 0x6f, 0x1f, 0x8a, 0xf8, 0x82, 0xba, 0x6b, 0x6e, 0x9a, 0x93, 0x9b, 0xa4,
    0xd8, 0x09, 0xde, 0x80, 0x35, 0x13, 0xce, 0xb5, 0x32, 0xb4, 0x98, 0x23, 0x6b, 0xa2, 0x34, 0x87,
    0x5a, 0x23, 0xb3, 0x1a, 0xa7, 0xcc, 0x40, 0xd7, 0x80, 0xdc, 0x93, 0x13, 0x43, 0x50, 0x36, 0xdb,
    0xb4, 0x5b, 0xc1, 0x61, 0x48, 0x4b, 0x7b, 0x2f, 0xa6, 0x65, 0x7c, 0x8c, 0xd4, 0x59, 0xca, 0x93,
    0x45, 0xd2, 0xcf, 0x0a, 0x68, 0xaf, 0x1a, 0xf9, 0x5a, 0xc9, 0x76, 0xb4, 0xd2, 0x0a, 0x88, 0x30,
    0x1e, 0x9d, 0x2b, 0x56, 0x49, 0xe0, 0x59, 0xa5, 0xb5, 0x0c, 0x7a, 0xaf, 0x53, 0xa4, 0x39, 0xa0,
    0x3c, 0x46, 0xc0, 0x63, 0x32, 0x38, 0xea, 0x0d, 0xc6, 0x3f, 0xcd, 0xa4, 0x83, 0x9d, 0xbe, 0xae,
    0x8e, 0x50, 0x7f, 0x61, 0x2e, 0xcf, 0x82, 0x96, 0xbe, 0x30, 0x99, 0x06, 0x17, 0xb7, 0xa2, 0x85,
    0x90, 0x16, 0x30, 0x2e, 0xed, 0xca, 0x6c, 0x7d, 0x70, 0x23, 0x3f, 0xa1, 0x33, 0x8d, 0x40, 0xcb,
    0xd8, 0x92, 0x84, 0xff, 0x1f, 0xc9, 0xdc, 0xab, 0xce, 0x89, 0xdf, 0x53, 0x72, 0xeb, 0x97, 0x15,
    0x3f, 0x66, 0xf9, 0x8b, 0x60, 0x9c, 0xf0, 0x86, 0x20, 0x10, 0x82, 0x70, 0xb1, 0xf4, 0x63, 0x19,
    0xcb, 0x30, 0xa0, 0xa2, 0x8d, 0xce, 0x0d, 0x10, 0x21, 0xe2, 0x39
};
#endif

PyTypeObject *init_KDragWidgetDecoratorBase(PyObject *module)
{
    if (SbkKWidgetsAddonsTypeStructs[SBK_KDragWidgetDecoratorBase_IDX].type != nullptr)
        return SbkKWidgetsAddonsTypeStructs[SBK_KDragWidgetDecoratorBase_IDX].type;

    Shiboken::AutoDecRef Sbk_KDragWidgetDecoratorBase_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))));

    _Sbk_KDragWidgetDecoratorBase_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KDragWidgetDecoratorBase",
        "KDragWidgetDecoratorBase*",
        &Sbk_KDragWidgetDecoratorBase_spec,
        &Shiboken::callCppDestructor< KDragWidgetDecoratorBase >,
        Sbk_KDragWidgetDecoratorBase_Type_bases.object(),
        0);
    auto *pyType = Sbk_KDragWidgetDecoratorBase_TypeF(); // references _Sbk_KDragWidgetDecoratorBase_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KDragWidgetDecoratorBase_SignatureStrings);
#else
    InitSignatureBytes(pyType, KDragWidgetDecoratorBase_SignatureBytes, KDragWidgetDecoratorBase_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KDragWidgetDecoratorBase_PropertyStrings);
    SbkKWidgetsAddonsTypeStructs[SBK_KDragWidgetDecoratorBase_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KDragWidgetDecoratorBase_PythonToCpp_KDragWidgetDecoratorBase_PTR,
        is_KDragWidgetDecoratorBase_PythonToCpp_KDragWidgetDecoratorBase_PTR_Convertible,
        KDragWidgetDecoratorBase_PTR_CppToPython_KDragWidgetDecoratorBase);

    Shiboken::Conversions::registerConverterName(converter, "KDragWidgetDecoratorBase");
    Shiboken::Conversions::registerConverterName(converter, "KDragWidgetDecoratorBase*");
    Shiboken::Conversions::registerConverterName(converter, "KDragWidgetDecoratorBase&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KDragWidgetDecoratorBase).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(KDragWidgetDecoratorBaseWrapper).name());

    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_KDragWidgetDecoratorBase_TypeF(), &Sbk_KDragWidgetDecoratorBase_typeDiscovery);

    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::KDragWidgetDecoratorBase::staticMetaObject, sizeof(KDragWidgetDecoratorBaseWrapper));

    return pyType;
}
