{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- The t'GI.HarfBuzz.Structs.FeatureT.FeatureT' is the structure that holds information about requested
-- feature application. The feature will be applied with the given value to all
-- glyphs which are in clusters between /@start@/ (inclusive) and /@end@/ (exclusive).
-- Setting start to 'GI.HarfBuzz.Constants.FEATURE_GLOBAL_START' and end to @/HB_FEATURE_GLOBAL_END/@
-- specifies that the feature always applies to the entire buffer.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.HarfBuzz.Structs.FeatureT
    ( 

-- * Exported types
    FeatureT(..)                            ,
    newZeroFeatureT                         ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveFeatureTMethod                   ,
#endif



 -- * Properties


-- ** end #attr:end#
-- | the cluster to end applying this feature setting (exclusive).

#if defined(ENABLE_OVERLOADING)
    featureT_end                            ,
#endif
    getFeatureTEnd                          ,
    setFeatureTEnd                          ,


-- ** start #attr:start#
-- | the cluster to start applying this feature setting (inclusive).

#if defined(ENABLE_OVERLOADING)
    featureT_start                          ,
#endif
    getFeatureTStart                        ,
    setFeatureTStart                        ,


-- ** tag #attr:tag#
-- | The @/hb_tag_t/@ tag of the feature

#if defined(ENABLE_OVERLOADING)
    featureT_tag                            ,
#endif
    getFeatureTTag                          ,
    setFeatureTTag                          ,


-- ** value #attr:value#
-- | The value of the feature. 0 disables the feature, non-zero (usually
-- 1) enables the feature.  For features implemented as lookup type 3 (like
-- \'salt\') the /@value@/ is a one based index into the alternates.

#if defined(ENABLE_OVERLOADING)
    featureT_value                          ,
#endif
    getFeatureTValue                        ,
    setFeatureTValue                        ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)

#else

#endif

-- | Memory-managed wrapper type.
newtype FeatureT = FeatureT (SP.ManagedPtr FeatureT)
    deriving (Eq)

instance SP.ManagedPtrNewtype FeatureT where
    toManagedPtr (FeatureT p) = p

foreign import ccall "hb_gobject_feature_get_type" c_hb_gobject_feature_get_type :: 
    IO GType

type instance O.ParentTypes FeatureT = '[]
instance O.HasParentTypes FeatureT

instance B.Types.TypedObject FeatureT where
    glibType = c_hb_gobject_feature_get_type

instance B.Types.GBoxed FeatureT

-- | Convert t'FeatureT' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe FeatureT) where
    gvalueGType_ = c_hb_gobject_feature_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_boxed gv (FP.nullPtr :: FP.Ptr FeatureT)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_boxed gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_boxed gv :: IO (Ptr FeatureT)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newBoxed FeatureT ptr
        else return P.Nothing
        
    

-- | Construct a t'FeatureT' struct initialized to zero.
newZeroFeatureT :: MonadIO m => m FeatureT
newZeroFeatureT = liftIO $ callocBoxedBytes 16 >>= wrapBoxed FeatureT

instance tag ~ 'AttrSet => Constructible FeatureT tag where
    new _ attrs = do
        o <- newZeroFeatureT
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@tag@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' featureT #tag
-- @
getFeatureTTag :: MonadIO m => FeatureT -> m Word32
getFeatureTTag s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO Word32
    return val

-- | Set the value of the “@tag@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' featureT [ #tag 'Data.GI.Base.Attributes.:=' value ]
-- @
setFeatureTTag :: MonadIO m => FeatureT -> Word32 -> m ()
setFeatureTTag s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (val :: Word32)

#if defined(ENABLE_OVERLOADING)
data FeatureTTagFieldInfo
instance AttrInfo FeatureTTagFieldInfo where
    type AttrBaseTypeConstraint FeatureTTagFieldInfo = (~) FeatureT
    type AttrAllowedOps FeatureTTagFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint FeatureTTagFieldInfo = (~) Word32
    type AttrTransferTypeConstraint FeatureTTagFieldInfo = (~)Word32
    type AttrTransferType FeatureTTagFieldInfo = Word32
    type AttrGetType FeatureTTagFieldInfo = Word32
    type AttrLabel FeatureTTagFieldInfo = "tag"
    type AttrOrigin FeatureTTagFieldInfo = FeatureT
    attrGet = getFeatureTTag
    attrSet = setFeatureTTag
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.HarfBuzz.Structs.FeatureT.tag"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-harfbuzz-0.0.10/docs/GI-HarfBuzz-Structs-FeatureT.html#g:attr:tag"
        })

featureT_tag :: AttrLabelProxy "tag"
featureT_tag = AttrLabelProxy

#endif


-- | Get the value of the “@value@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' featureT #value
-- @
getFeatureTValue :: MonadIO m => FeatureT -> m Word32
getFeatureTValue s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 4) :: IO Word32
    return val

-- | Set the value of the “@value@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' featureT [ #value 'Data.GI.Base.Attributes.:=' value ]
-- @
setFeatureTValue :: MonadIO m => FeatureT -> Word32 -> m ()
setFeatureTValue s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 4) (val :: Word32)

#if defined(ENABLE_OVERLOADING)
data FeatureTValueFieldInfo
instance AttrInfo FeatureTValueFieldInfo where
    type AttrBaseTypeConstraint FeatureTValueFieldInfo = (~) FeatureT
    type AttrAllowedOps FeatureTValueFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint FeatureTValueFieldInfo = (~) Word32
    type AttrTransferTypeConstraint FeatureTValueFieldInfo = (~)Word32
    type AttrTransferType FeatureTValueFieldInfo = Word32
    type AttrGetType FeatureTValueFieldInfo = Word32
    type AttrLabel FeatureTValueFieldInfo = "value"
    type AttrOrigin FeatureTValueFieldInfo = FeatureT
    attrGet = getFeatureTValue
    attrSet = setFeatureTValue
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.HarfBuzz.Structs.FeatureT.value"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-harfbuzz-0.0.10/docs/GI-HarfBuzz-Structs-FeatureT.html#g:attr:value"
        })

featureT_value :: AttrLabelProxy "value"
featureT_value = AttrLabelProxy

#endif


-- | Get the value of the “@start@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' featureT #start
-- @
getFeatureTStart :: MonadIO m => FeatureT -> m Word32
getFeatureTStart s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 8) :: IO Word32
    return val

-- | Set the value of the “@start@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' featureT [ #start 'Data.GI.Base.Attributes.:=' value ]
-- @
setFeatureTStart :: MonadIO m => FeatureT -> Word32 -> m ()
setFeatureTStart s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 8) (val :: Word32)

#if defined(ENABLE_OVERLOADING)
data FeatureTStartFieldInfo
instance AttrInfo FeatureTStartFieldInfo where
    type AttrBaseTypeConstraint FeatureTStartFieldInfo = (~) FeatureT
    type AttrAllowedOps FeatureTStartFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint FeatureTStartFieldInfo = (~) Word32
    type AttrTransferTypeConstraint FeatureTStartFieldInfo = (~)Word32
    type AttrTransferType FeatureTStartFieldInfo = Word32
    type AttrGetType FeatureTStartFieldInfo = Word32
    type AttrLabel FeatureTStartFieldInfo = "start"
    type AttrOrigin FeatureTStartFieldInfo = FeatureT
    attrGet = getFeatureTStart
    attrSet = setFeatureTStart
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.HarfBuzz.Structs.FeatureT.start"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-harfbuzz-0.0.10/docs/GI-HarfBuzz-Structs-FeatureT.html#g:attr:start"
        })

featureT_start :: AttrLabelProxy "start"
featureT_start = AttrLabelProxy

#endif


-- | Get the value of the “@end@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' featureT #end
-- @
getFeatureTEnd :: MonadIO m => FeatureT -> m Word32
getFeatureTEnd s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 12) :: IO Word32
    return val

-- | Set the value of the “@end@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' featureT [ #end 'Data.GI.Base.Attributes.:=' value ]
-- @
setFeatureTEnd :: MonadIO m => FeatureT -> Word32 -> m ()
setFeatureTEnd s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 12) (val :: Word32)

#if defined(ENABLE_OVERLOADING)
data FeatureTEndFieldInfo
instance AttrInfo FeatureTEndFieldInfo where
    type AttrBaseTypeConstraint FeatureTEndFieldInfo = (~) FeatureT
    type AttrAllowedOps FeatureTEndFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint FeatureTEndFieldInfo = (~) Word32
    type AttrTransferTypeConstraint FeatureTEndFieldInfo = (~)Word32
    type AttrTransferType FeatureTEndFieldInfo = Word32
    type AttrGetType FeatureTEndFieldInfo = Word32
    type AttrLabel FeatureTEndFieldInfo = "end"
    type AttrOrigin FeatureTEndFieldInfo = FeatureT
    attrGet = getFeatureTEnd
    attrSet = setFeatureTEnd
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.HarfBuzz.Structs.FeatureT.end"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-harfbuzz-0.0.10/docs/GI-HarfBuzz-Structs-FeatureT.html#g:attr:end"
        })

featureT_end :: AttrLabelProxy "end"
featureT_end = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList FeatureT
type instance O.AttributeList FeatureT = FeatureTAttributeList
type FeatureTAttributeList = ('[ '("tag", FeatureTTagFieldInfo), '("value", FeatureTValueFieldInfo), '("start", FeatureTStartFieldInfo), '("end", FeatureTEndFieldInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveFeatureTMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveFeatureTMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveFeatureTMethod t FeatureT, O.OverloadedMethod info FeatureT p) => OL.IsLabel t (FeatureT -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveFeatureTMethod t FeatureT, O.OverloadedMethod info FeatureT p, R.HasField t FeatureT p) => R.HasField t FeatureT p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveFeatureTMethod t FeatureT, O.OverloadedMethodInfo info FeatureT) => OL.IsLabel t (O.MethodProxy info FeatureT) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


