/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* RISCVPostLegalizerCombinerImpl Combiner Match Table                        *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

#ifdef GET_GICOMBINER_DEPS
#include "llvm/ADT/SparseBitVector.h"
namespace llvm {
extern cl::OptionCategory GICombinerOptionCategory;
} // end namespace llvm
#endif // ifdef GET_GICOMBINER_DEPS

#ifdef GET_GICOMBINER_TYPES
struct RISCVPostLegalizerCombinerImplRuleConfig {
  SparseBitVector<> DisabledRules;

  bool isRuleEnabled(unsigned RuleID) const;
  bool parseCommandLineOption();
  bool setRuleEnabled(StringRef RuleIdentifier);
  bool setRuleDisabled(StringRef RuleIdentifier);
};

static std::optional<uint64_t> getRuleIdxForIdentifier(StringRef RuleIdentifier) {
  uint64_t I;
  // getAtInteger(...) returns false on success
  bool Parsed = !RuleIdentifier.getAsInteger(0, I);
  if (Parsed)
    return I;

#ifndef NDEBUG
  switch (RuleIdentifier.size()) {
  default: break;
  case 10:	 // 3 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'i':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "2p_to_p2i", 9) != 0)
        break;
      return 10;	 // "i2p_to_p2i"
    case 'p':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "2i_to_i2p", 9) != 0)
        break;
      return 9;	 // "p2i_to_i2p"
    case 's':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ub_to_add", 9) != 0)
        break;
      return 0;	 // "sub_to_add"
    }
    break;
  case 11:	 // 1 string to match.
    if (memcmp(RuleIdentifier.data()+0, "add_sub_reg", 11) != 0)
      break;
    return 15;	 // "add_sub_reg"
  case 13:	 // 2 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'l':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "oad_and_mask", 12) != 0)
        break;
      return 2;	 // "load_and_mask"
    case 'r':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "edundant_and", 12) != 0)
        break;
      return 3;	 // "redundant_and"
    }
    break;
  case 14:	 // 2 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'b':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "inop_same_val", 13) != 0)
        break;
      return 6;	 // "binop_same_val"
    case 'f':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "neg_fneg_fold", 13) != 0)
        break;
      return 12;	 // "fneg_fneg_fold"
    }
    break;
  case 15:	 // 2 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'e':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "xtending_loads", 14) != 0)
        break;
      return 1;	 // "extending_loads"
    case 's':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "elect_same_val", 14) != 0)
        break;
      return 4;	 // "select_same_val"
    }
    break;
  case 17:	 // 2 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'a':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "nyext_trunc_fold", 16) != 0)
        break;
      return 11;	 // "anyext_trunc_fold"
    case 's':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "hift_immed_chain", 16) != 0)
        break;
      return 23;	 // "shift_immed_chain"
    }
    break;
  case 18:	 // 2 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'b':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "inop_left_to_zero", 17) != 0)
        break;
      return 7;	 // "binop_left_to_zero"
    case 'f':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ptrunc_fpext_fold", 17) != 0)
        break;
      return 20;	 // "fptrunc_fpext_fold"
    }
    break;
  case 19:	 // 3 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'b':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "inop_right_to_zero", 18) != 0)
        break;
      return 8;	 // "binop_right_to_zero"
    case 'r':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ight_identity_zero", 18) != 0)
        break;
      return 5;	 // "right_identity_zero"
    case 's':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "implify_neg_minmax", 18) != 0)
        break;
      return 26;	 // "simplify_neg_minmax"
    }
    break;
  case 20:	 // 1 string to match.
    if (memcmp(RuleIdentifier.data()+0, "bitcast_bitcast_fold", 20) != 0)
      break;
    return 19;	 // "bitcast_bitcast_fold"
  case 21:	 // 1 string to match.
    if (memcmp(RuleIdentifier.data()+0, "right_identity_one_fp", 21) != 0)
      break;
    return 14;	 // "right_identity_one_fp"
  case 22:	 // 2 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'r':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ight_identity_one_int", 21) != 0)
        break;
      return 13;	 // "right_identity_one_int"
    case 't':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "runc_buildvector_fold", 21) != 0)
        break;
      return 17;	 // "trunc_buildvector_fold"
    }
    break;
  case 25:	 // 2 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'b':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "uildvector_identity_fold", 24) != 0)
        break;
      return 16;	 // "buildvector_identity_fold"
    case 'r':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ight_identity_neg_one_fp", 24) != 0)
        break;
      return 22;	 // "right_identity_neg_one_fp"
    }
    break;
  case 26:	 // 2 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'c':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ommute_fp_constant_to_rhs", 25) != 0)
        break;
      return 25;	 // "commute_fp_constant_to_rhs"
    case 'r':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ight_identity_neg_zero_fp", 25) != 0)
        break;
      return 21;	 // "right_identity_neg_zero_fp"
    }
    break;
  case 27:	 // 2 strings to match.
    switch (RuleIdentifier[0]) {
    default: break;
    case 'c':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "ommute_int_constant_to_rhs", 26) != 0)
        break;
      return 24;	 // "commute_int_constant_to_rhs"
    case 't':	 // 1 string to match.
      if (memcmp(RuleIdentifier.data()+1, "runc_lshr_buildvector_fold", 26) != 0)
        break;
      return 18;	 // "trunc_lshr_buildvector_fold"
    }
    break;
  }
#endif // ifndef NDEBUG

  return std::nullopt;
}
static std::optional<std::pair<uint64_t, uint64_t>> getRuleRangeForIdentifier(StringRef RuleIdentifier) {
  std::pair<StringRef, StringRef> RangePair = RuleIdentifier.split('-');
  if (!RangePair.second.empty()) {
    const auto First = getRuleIdxForIdentifier(RangePair.first);
    const auto Last = getRuleIdxForIdentifier(RangePair.second);
    if (!First || !Last)
      return std::nullopt;
    if (First >= Last)
      report_fatal_error("Beginning of range should be before end of range");
    return {{*First, *Last + 1}};
  }
  if (RangePair.first == "*") {
    return {{0, 27}};
  }
  const auto I = getRuleIdxForIdentifier(RangePair.first);
  if (!I)
    return std::nullopt;
  return {{*I, *I + 1}};
}

bool RISCVPostLegalizerCombinerImplRuleConfig::setRuleEnabled(StringRef RuleIdentifier) {
  auto MaybeRange = getRuleRangeForIdentifier(RuleIdentifier);
  if (!MaybeRange)
    return false;
  for (auto I = MaybeRange->first; I < MaybeRange->second; ++I)
    DisabledRules.reset(I);
  return true;
}

bool RISCVPostLegalizerCombinerImplRuleConfig::setRuleDisabled(StringRef RuleIdentifier) {
  auto MaybeRange = getRuleRangeForIdentifier(RuleIdentifier);
  if (!MaybeRange)
    return false;
  for (auto I = MaybeRange->first; I < MaybeRange->second; ++I)
    DisabledRules.set(I);
  return true;
}

static std::vector<std::string> RISCVPostLegalizerCombinerOption;
static cl::list<std::string> RISCVPostLegalizerCombinerDisableOption(
    "riscvpostlegalizercombiner-disable-rule",
    cl::desc("Disable one or more combiner rules temporarily in the RISCVPostLegalizerCombiner pass"),
    cl::CommaSeparated,
    cl::Hidden,
    cl::cat(GICombinerOptionCategory),
    cl::callback([](const std::string &Str) {
      RISCVPostLegalizerCombinerOption.push_back(Str);
    }));
static cl::list<std::string> RISCVPostLegalizerCombinerOnlyEnableOption(
    "riscvpostlegalizercombiner-only-enable-rule",
    cl::desc("Disable all rules in the RISCVPostLegalizerCombiner pass then re-enable the specified ones"),
    cl::Hidden,
    cl::cat(GICombinerOptionCategory),
    cl::callback([](const std::string &CommaSeparatedArg) {
      StringRef Str = CommaSeparatedArg;
      RISCVPostLegalizerCombinerOption.push_back("*");
      do {
        auto X = Str.split(",");
        RISCVPostLegalizerCombinerOption.push_back(("!" + X.first).str());
        Str = X.second;
      } while (!Str.empty());
    }));


bool RISCVPostLegalizerCombinerImplRuleConfig::isRuleEnabled(unsigned RuleID) const {
    return  !DisabledRules.test(RuleID);
}
bool RISCVPostLegalizerCombinerImplRuleConfig::parseCommandLineOption() {
  for (StringRef Identifier : RISCVPostLegalizerCombinerOption) {
    bool Enabled = Identifier.consume_front("!");
    if (Enabled && !setRuleEnabled(Identifier))
      return false;
    if (!Enabled && !setRuleDisabled(Identifier))
      return false;
  }
  return true;
}

#endif // ifdef GET_GICOMBINER_TYPES

#ifdef GET_GICOMBINER_TYPES
const unsigned MAX_SUBTARGET_PREDICATES = 0;
using PredicateBitset = llvm::Bitset<MAX_SUBTARGET_PREDICATES>;
#endif // ifdef GET_GICOMBINER_TYPES

#ifdef GET_GICOMBINER_CLASS_MEMBERS
PredicateBitset AvailableModuleFeatures;
mutable PredicateBitset AvailableFunctionFeatures;
PredicateBitset getAvailableFeatures() const {
  return AvailableModuleFeatures | AvailableFunctionFeatures;
}
PredicateBitset
computeAvailableModuleFeatures(const RISCVSubtarget *Subtarget) const;
PredicateBitset
computeAvailableFunctionFeatures(const RISCVSubtarget *Subtarget,
                                 const MachineFunction *MF) const;
void setupGeneratedPerFunctionState(MachineFunction &MF) override;
#endif // ifdef GET_GICOMBINER_CLASS_MEMBERS
#ifdef GET_GICOMBINER_CLASS_MEMBERS
  mutable MatcherState State;
  typedef ComplexRendererFns(RISCVPostLegalizerCombinerImpl::*ComplexMatcherMemFn)(MachineOperand &) const;
  typedef void(RISCVPostLegalizerCombinerImpl::*CustomRendererFn)(MachineInstrBuilder &, const MachineInstr &, int) const;
  const ExecInfoTy<PredicateBitset, ComplexMatcherMemFn, CustomRendererFn> ExecInfo;
  static RISCVPostLegalizerCombinerImpl::ComplexMatcherMemFn ComplexPredicateFns[];
  static RISCVPostLegalizerCombinerImpl::CustomRendererFn CustomRenderers[];
  bool testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const override;
  bool testImmPredicate_APInt(unsigned PredicateID, const APInt &Imm) const override;
  bool testImmPredicate_APFloat(unsigned PredicateID, const APFloat &Imm) const override;
  const uint8_t *getMatchTable() const override;
  bool testMIPredicate_MI(unsigned PredicateID, const MachineInstr &MI, const MatcherState &State) const override;
  bool testMOPredicate_MO(unsigned PredicateID, const MachineOperand &MO, const MatcherState &State) const override;
  bool testSimplePredicate(unsigned PredicateID) const override;
  bool runCustomAction(unsigned FnID, const MatcherState &State, NewMIVector &OutMIs) const override;
#endif // ifdef GET_GICOMBINER_CLASS_MEMBERS

#ifdef GET_GICOMBINER_IMPL
// LLT Objects.
enum {
  GILLT_s1,
};
const static size_t NumTypeObjects = 1;
const static LLT TypeObjects[] = {
  LLT::scalar(1),
};

// Bits for subtarget features that participate in instruction matching.
enum SubtargetFeatureBits : uint8_t {
};

PredicateBitset RISCVPostLegalizerCombinerImpl::
computeAvailableModuleFeatures(const RISCVSubtarget *Subtarget) const {
  PredicateBitset Features{};
  return Features;
}

void RISCVPostLegalizerCombinerImpl::setupGeneratedPerFunctionState(MachineFunction &MF) {
  AvailableFunctionFeatures = computeAvailableFunctionFeatures((const RISCVSubtarget *)&MF.getSubtarget(), &MF);
}
PredicateBitset RISCVPostLegalizerCombinerImpl::
computeAvailableFunctionFeatures(const RISCVSubtarget *Subtarget, const MachineFunction *MF) const {
  PredicateBitset Features{};
  return Features;
}

// Feature bitsets.
enum {
  GIFBS_Invalid,
};
constexpr static PredicateBitset FeatureBitsets[] {
  {}, // GIFBS_Invalid
};

// ComplexPattern predicates.
enum {
  GICP_Invalid,
};
// See constructor for table contents

RISCVPostLegalizerCombinerImpl::ComplexMatcherMemFn
RISCVPostLegalizerCombinerImpl::ComplexPredicateFns[] = {
  nullptr, // GICP_Invalid
};

enum {
  GICXXPred_MI_Predicate_GICombiner0 = GICXXPred_Invalid + 1,
  GICXXPred_MI_Predicate_GICombiner1,
  GICXXPred_MI_Predicate_GICombiner2,
};
bool RISCVPostLegalizerCombinerImpl::testMIPredicate_MI(unsigned PredicateID, const MachineInstr & MI, const MatcherState &State) const {
  switch (PredicateID) {
  case GICXXPred_MI_Predicate_GICombiner0: {
    return Helper.matchConstantFPOp(State.MIs[0]->getOperand(2), 1.0);
  }
  case GICXXPred_MI_Predicate_GICombiner1: {
    return Helper.matchConstantFPOp(State.MIs[0]->getOperand(2), -0.0);
  }
  case GICXXPred_MI_Predicate_GICombiner2: {
    return Helper.matchConstantFPOp(State.MIs[0]->getOperand(2), -1.0);
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
bool RISCVPostLegalizerCombinerImpl::testMOPredicate_MO(unsigned PredicateID, const MachineOperand & MO, const MatcherState &State) const {
  llvm_unreachable("Unknown predicate");
  return false;
}
bool RISCVPostLegalizerCombinerImpl::testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const {
  llvm_unreachable("Unknown predicate");
  return false;
}
bool RISCVPostLegalizerCombinerImpl::testImmPredicate_APFloat(unsigned PredicateID, const APFloat & Imm) const {
  llvm_unreachable("Unknown predicate");
  return false;
}
bool RISCVPostLegalizerCombinerImpl::testImmPredicate_APInt(unsigned PredicateID, const APInt & Imm) const {
  llvm_unreachable("Unknown predicate");
  return false;
}
enum {
  GICXXPred_Simple_IsRule0Enabled = GICXXPred_Invalid + 1,
  GICXXPred_Simple_IsRule1Enabled,
  GICXXPred_Simple_IsRule2Enabled,
  GICXXPred_Simple_IsRule3Enabled,
  GICXXPred_Simple_IsRule4Enabled,
  GICXXPred_Simple_IsRule5Enabled,
  GICXXPred_Simple_IsRule6Enabled,
  GICXXPred_Simple_IsRule7Enabled,
  GICXXPred_Simple_IsRule8Enabled,
  GICXXPred_Simple_IsRule9Enabled,
  GICXXPred_Simple_IsRule10Enabled,
  GICXXPred_Simple_IsRule11Enabled,
  GICXXPred_Simple_IsRule12Enabled,
  GICXXPred_Simple_IsRule13Enabled,
  GICXXPred_Simple_IsRule14Enabled,
  GICXXPred_Simple_IsRule15Enabled,
  GICXXPred_Simple_IsRule16Enabled,
  GICXXPred_Simple_IsRule17Enabled,
  GICXXPred_Simple_IsRule18Enabled,
  GICXXPred_Simple_IsRule19Enabled,
  GICXXPred_Simple_IsRule20Enabled,
  GICXXPred_Simple_IsRule21Enabled,
  GICXXPred_Simple_IsRule22Enabled,
  GICXXPred_Simple_IsRule23Enabled,
  GICXXPred_Simple_IsRule24Enabled,
  GICXXPred_Simple_IsRule25Enabled,
  GICXXPred_Simple_IsRule26Enabled,
};

bool RISCVPostLegalizerCombinerImpl::testSimplePredicate(unsigned Predicate) const {
    return RuleConfig.isRuleEnabled(Predicate - GICXXPred_Invalid - 1);
}
// Custom renderers.
enum {
  GICR_Invalid,
};
RISCVPostLegalizerCombinerImpl::CustomRendererFn
RISCVPostLegalizerCombinerImpl::CustomRenderers[] = {
  nullptr, // GICR_Invalid
};

bool RISCVPostLegalizerCombinerImpl::tryCombineAll(MachineInstr &I) const {
  const TargetSubtargetInfo &ST = MF.getSubtarget();
  const PredicateBitset AvailableFeatures = getAvailableFeatures();
  B.setInstrAndDebugLoc(I);
  State.MIs.clear();
  State.MIs.push_back(&I);
  if (executeMatchTable(*this, State, ExecInfo, B, getMatchTable(), *ST.getInstrInfo(), MRI, *MRI.getTargetRegisterInfo(), *ST.getRegBankInfo(), AvailableFeatures, /*CoverageInfo*/ nullptr)) {
    return true;
  }

  return false;
}

enum {
  GICXXCustomAction_GICombiner0 = GICXXCustomAction_Invalid + 1,
  GICXXCustomAction_GICombiner1,
  GICXXCustomAction_GICombiner2,
  GICXXCustomAction_GICombiner3,
  GICXXCustomAction_GICombiner4,
  GICXXCustomAction_GICombiner5,
  GICXXCustomAction_GICombiner6,
  GICXXCustomAction_GICombiner7,
  GICXXCustomAction_GICombiner8,
  GICXXCustomAction_GICombiner9,
  GICXXCustomAction_GICombiner10,
  GICXXCustomAction_GICombiner11,
  GICXXCustomAction_GICombiner12,
  GICXXCustomAction_GICombiner13,
  GICXXCustomAction_GICombiner14,
  GICXXCustomAction_GICombiner15,
  GICXXCustomAction_GICombiner16,
};
bool RISCVPostLegalizerCombinerImpl::runCustomAction(unsigned ApplyID, const MatcherState &State, NewMIVector &OutMIs) const {
  Helper.getBuilder().setInstrAndDebugLoc(*State.MIs[0]);
  switch(ApplyID) {
  case GICXXCustomAction_GICombiner0:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchCombineSubToAdd(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFnNoErase(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner1:{
    PreferredTuple GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchCombineExtendingLoads(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyCombineExtendingLoads(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner2:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchCombineLoadWithAndMask(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner3:{
    Register GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchRedundantAnd(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceSingleDefInstWithReg(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner4:{
    // Match Patterns
    if(![&](){return Helper.matchSelectSameVal(*State.MIs[0]);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceSingleDefInstWithOperand(*State.MIs[0], 2);
    return true;
  }
  case GICXXCustomAction_GICombiner5:{
    // Match Patterns
    if(![&](){return Helper.matchOperandIsZero(*State.MIs[0], 1);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceSingleDefInstWithOperand(*State.MIs[0], 1);
    return true;
  }
  case GICXXCustomAction_GICombiner6:{
    Register GIMatchData_info;
    // Match Patterns
    if(![&](){return Helper.matchCombineI2PToP2I(*State.MIs[0], GIMatchData_info);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyCombineI2PToP2I(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner7:{
    Register GIMatchData_info;
    // Match Patterns
    if(![&](){GIMatchData_info = State.MIs[1]->getOperand(1).getReg(); return true;}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyCombineP2IToI2P(*State.MIs[0], GIMatchData_info);
    return true;
  }
  case GICXXCustomAction_GICombiner8:{
    Register GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchCombineAnyExtTrunc(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceSingleDefInstWithReg(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner9:{
    Register GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchBuildVectorIdentityFold(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceSingleDefInstWithReg(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner10:{
    Register GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchTruncBuildVectorFold(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceSingleDefInstWithReg(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner11:{
    Register GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchTruncLshrBuildVectorFold(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceSingleDefInstWithReg(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner12:{
    // Match Patterns
    if(![&](){return MRI.getType(State.MIs[1]->getOperand(1).getReg()) == MRI.getType(State.MIs[0]->getOperand(0).getReg());}()) {
      return false;
    }
    // Apply Patterns
    Helper.replaceSingleDefInstWithReg(*State.MIs[0], State.MIs[1]->getOperand(1).getReg());
    return true;
  }
  case GICXXCustomAction_GICombiner13:{
    RegisterImmPair GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchShiftImmedChain(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyShiftImmedChain(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  case GICXXCustomAction_GICombiner14:{
    // Match Patterns
    if(![&](){return Helper.matchCommuteConstantToRHS(*State.MIs[0]);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyCommuteBinOpOperands(*State.MIs[0]);
    return true;
  }
  case GICXXCustomAction_GICombiner15:{
    // Match Patterns
    if(![&](){return Helper.matchCommuteFPConstantToRHS(*State.MIs[0]);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyCommuteBinOpOperands(*State.MIs[0]);
    return true;
  }
  case GICXXCustomAction_GICombiner16:{
    std::function<void(MachineIRBuilder &)> GIMatchData_matchinfo;
    // Match Patterns
    if(![&](){return Helper.matchSimplifyNegMinMax(*State.MIs[0], GIMatchData_matchinfo);}()) {
      return false;
    }
    // Apply Patterns
    Helper.applyBuildFn(*State.MIs[0], GIMatchData_matchinfo);
    return true;
  }
  }
  llvm_unreachable("Unknown Apply Action");
}
#if __BYTE_ORDER__ == __ORDER_LITTLE_ENDIAN__
#define GIMT_Encode2(Val) uint8_t(Val), uint8_t((uint16_t)Val >> 8)
#define GIMT_Encode4(Val) uint8_t(Val), uint8_t((uint32_t)Val >> 8), uint8_t((uint32_t)Val >> 16), uint8_t((uint32_t)Val >> 24)
#define GIMT_Encode8(Val) uint8_t(Val), uint8_t((uint64_t)Val >> 8), uint8_t((uint64_t)Val >> 16), uint8_t((uint64_t)Val >> 24),  uint8_t((uint64_t)Val >> 32), uint8_t((uint64_t)Val >> 40), uint8_t((uint64_t)Val >> 48), uint8_t((uint64_t)Val >> 56)
#else
#define GIMT_Encode2(Val) uint8_t((uint16_t)Val >> 8), uint8_t(Val)
#define GIMT_Encode4(Val) uint8_t((uint32_t)Val >> 24), uint8_t((uint32_t)Val >> 16), uint8_t((uint32_t)Val >> 8), uint8_t(Val)
#define GIMT_Encode8(Val) uint8_t((uint64_t)Val >> 56), uint8_t((uint64_t)Val >> 48), uint8_t((uint64_t)Val >> 40), uint8_t((uint64_t)Val >> 32),  uint8_t((uint64_t)Val >> 24), uint8_t((uint64_t)Val >> 16), uint8_t((uint64_t)Val >> 8), uint8_t(Val)
#endif
const uint8_t *RISCVPostLegalizerCombinerImpl::getMatchTable() const {
  constexpr static uint8_t MatchTable0[] = {
     /*    0 */ GIM_SwitchOpcode, /*MI*/0, /*[*/GIMT_Encode2(53), GIMT_Encode2(234), /*)*//*default:*//*Label 55*/ GIMT_Encode4(1954),
     /*   10 */ /*TargetOpcode::G_ADD*//*Label 0*/ GIMT_Encode4(734),
     /*   14 */ /*TargetOpcode::G_SUB*//*Label 1*/ GIMT_Encode4(837),
     /*   18 */ /*TargetOpcode::G_MUL*//*Label 2*/ GIMT_Encode4(893),
     /*   22 */ /*TargetOpcode::G_SDIV*//*Label 3*/ GIMT_Encode4(951),
     /*   26 */ /*TargetOpcode::G_UDIV*//*Label 4*/ GIMT_Encode4(963),
     /*   30 */ /*TargetOpcode::G_SREM*//*Label 5*/ GIMT_Encode4(975),
     /*   34 */ /*TargetOpcode::G_UREM*//*Label 6*/ GIMT_Encode4(987), GIMT_Encode4(0), GIMT_Encode4(0),
     /*   46 */ /*TargetOpcode::G_AND*//*Label 7*/ GIMT_Encode4(999),
     /*   50 */ /*TargetOpcode::G_OR*//*Label 8*/ GIMT_Encode4(1057),
     /*   54 */ /*TargetOpcode::G_XOR*//*Label 9*/ GIMT_Encode4(1116), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  106 */ /*TargetOpcode::G_BUILD_VECTOR*//*Label 10*/ GIMT_Encode4(1151),
     /*  110 */ /*TargetOpcode::G_BUILD_VECTOR_TRUNC*//*Label 11*/ GIMT_Encode4(1163), GIMT_Encode4(0),
     /*  118 */ /*TargetOpcode::G_PTRTOINT*//*Label 12*/ GIMT_Encode4(1175),
     /*  122 */ /*TargetOpcode::G_INTTOPTR*//*Label 13*/ GIMT_Encode4(1197),
     /*  126 */ /*TargetOpcode::G_BITCAST*//*Label 14*/ GIMT_Encode4(1209), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  170 */ /*TargetOpcode::G_LOAD*//*Label 15*/ GIMT_Encode4(1231),
     /*  174 */ /*TargetOpcode::G_SEXTLOAD*//*Label 16*/ GIMT_Encode4(1243),
     /*  178 */ /*TargetOpcode::G_ZEXTLOAD*//*Label 17*/ GIMT_Encode4(1255), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  330 */ /*TargetOpcode::G_ANYEXT*//*Label 18*/ GIMT_Encode4(1267),
     /*  334 */ /*TargetOpcode::G_TRUNC*//*Label 19*/ GIMT_Encode4(1279), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  378 */ /*TargetOpcode::G_SHL*//*Label 20*/ GIMT_Encode4(1302),
     /*  382 */ /*TargetOpcode::G_LSHR*//*Label 21*/ GIMT_Encode4(1348),
     /*  386 */ /*TargetOpcode::G_ASHR*//*Label 22*/ GIMT_Encode4(1394), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  398 */ /*TargetOpcode::G_ROTR*//*Label 23*/ GIMT_Encode4(1440),
     /*  402 */ /*TargetOpcode::G_ROTL*//*Label 24*/ GIMT_Encode4(1464), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  422 */ /*TargetOpcode::G_SELECT*//*Label 25*/ GIMT_Encode4(1488),
     /*  426 */ /*TargetOpcode::G_UADDO*//*Label 26*/ GIMT_Encode4(1500), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  442 */ /*TargetOpcode::G_SADDO*//*Label 27*/ GIMT_Encode4(1512), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  458 */ /*TargetOpcode::G_UMULO*//*Label 28*/ GIMT_Encode4(1524),
     /*  462 */ /*TargetOpcode::G_SMULO*//*Label 29*/ GIMT_Encode4(1536),
     /*  466 */ /*TargetOpcode::G_UMULH*//*Label 30*/ GIMT_Encode4(1548),
     /*  470 */ /*TargetOpcode::G_SMULH*//*Label 31*/ GIMT_Encode4(1560),
     /*  474 */ /*TargetOpcode::G_UADDSAT*//*Label 32*/ GIMT_Encode4(1572),
     /*  478 */ /*TargetOpcode::G_SADDSAT*//*Label 33*/ GIMT_Encode4(1584), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  490 */ /*TargetOpcode::G_USHLSAT*//*Label 34*/ GIMT_Encode4(1596),
     /*  494 */ /*TargetOpcode::G_SSHLSAT*//*Label 35*/ GIMT_Encode4(1608),
     /*  498 */ /*TargetOpcode::G_SMULFIX*//*Label 36*/ GIMT_Encode4(1620),
     /*  502 */ /*TargetOpcode::G_UMULFIX*//*Label 37*/ GIMT_Encode4(1632),
     /*  506 */ /*TargetOpcode::G_SMULFIXSAT*//*Label 38*/ GIMT_Encode4(1644),
     /*  510 */ /*TargetOpcode::G_UMULFIXSAT*//*Label 39*/ GIMT_Encode4(1656), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  530 */ /*TargetOpcode::G_FADD*//*Label 40*/ GIMT_Encode4(1668), GIMT_Encode4(0),
     /*  538 */ /*TargetOpcode::G_FMUL*//*Label 41*/ GIMT_Encode4(1703), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  598 */ /*TargetOpcode::G_FNEG*//*Label 42*/ GIMT_Encode4(1758), GIMT_Encode4(0),
     /*  606 */ /*TargetOpcode::G_FPTRUNC*//*Label 43*/ GIMT_Encode4(1788), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  650 */ /*TargetOpcode::G_FMINNUM*//*Label 44*/ GIMT_Encode4(1810),
     /*  654 */ /*TargetOpcode::G_FMAXNUM*//*Label 45*/ GIMT_Encode4(1822),
     /*  658 */ /*TargetOpcode::G_FMINNUM_IEEE*//*Label 46*/ GIMT_Encode4(1834),
     /*  662 */ /*TargetOpcode::G_FMAXNUM_IEEE*//*Label 47*/ GIMT_Encode4(1846),
     /*  666 */ /*TargetOpcode::G_FMINIMUM*//*Label 48*/ GIMT_Encode4(1858),
     /*  670 */ /*TargetOpcode::G_FMAXIMUM*//*Label 49*/ GIMT_Encode4(1870), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  710 */ /*TargetOpcode::G_PTR_ADD*//*Label 50*/ GIMT_Encode4(1882), GIMT_Encode4(0),
     /*  718 */ /*TargetOpcode::G_SMIN*//*Label 51*/ GIMT_Encode4(1906),
     /*  722 */ /*TargetOpcode::G_SMAX*//*Label 52*/ GIMT_Encode4(1918),
     /*  726 */ /*TargetOpcode::G_UMIN*//*Label 53*/ GIMT_Encode4(1930),
     /*  730 */ /*TargetOpcode::G_UMAX*//*Label 54*/ GIMT_Encode4(1942),
     /*  734 */ // Label 0: @734
     /*  734 */ GIM_Try, /*On fail goto*//*Label 56*/ GIMT_Encode4(745), // Rule ID 48 //
     /*  739 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule24Enabled),
     /*  742 */   // Combiner Rule #24: commute_int_constant_to_rhs; wip_match_opcode 'G_ADD'
     /*  742 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner14),
     /*  745 */ // Label 56: @745
     /*  745 */ GIM_Try, /*On fail goto*//*Label 57*/ GIMT_Encode4(779), // Rule ID 34 //
     /*  750 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule15Enabled),
     /*  753 */   // MIs[0] dst
     /*  753 */   // No operand predicates
     /*  753 */   // MIs[0] __add_sub_reg_match_0.tmp
     /*  753 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  757 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
     /*  761 */   // MIs[1] src
     /*  761 */   // No operand predicates
     /*  761 */   // MIs[1] __add_sub_reg_match_0.x
     /*  761 */   // No operand predicates
     /*  761 */   // MIs[0] __add_sub_reg_match_0.x
     /*  761 */   GIM_CheckIsSameOperandIgnoreCopies, /*MI*/0, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*  766 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/1, /*NewOpIdx*/1,
     /*  771 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  773 */   // Combiner Rule #15: add_sub_reg @ [__add_sub_reg_match_0[1]]
     /*  773 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/1, /*NewOpIdx*/1,
     /*  778 */   GIR_EraseRootFromParent_Done,
     /*  779 */ // Label 57: @779
     /*  779 */ GIM_Try, /*On fail goto*//*Label 58*/ GIMT_Encode4(813), // Rule ID 33 //
     /*  784 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule15Enabled),
     /*  787 */   // MIs[0] dst
     /*  787 */   // No operand predicates
     /*  787 */   // MIs[0] __add_sub_reg_match_0.x
     /*  787 */   // No operand predicates
     /*  787 */   // MIs[0] __add_sub_reg_match_0.tmp
     /*  787 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  791 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
     /*  795 */   // MIs[1] src
     /*  795 */   // No operand predicates
     /*  795 */   // MIs[1] __add_sub_reg_match_0.x
     /*  795 */   GIM_CheckIsSameOperandIgnoreCopies, /*MI*/1, /*OpIdx*/2, /*OtherMI*/0, /*OtherOpIdx*/1,
     /*  800 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/1, /*NewOpIdx*/1,
     /*  805 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  807 */   // Combiner Rule #15: add_sub_reg @ [__add_sub_reg_match_0[0]]
     /*  807 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/1, /*NewOpIdx*/1,
     /*  812 */   GIR_EraseRootFromParent_Done,
     /*  813 */ // Label 58: @813
     /*  813 */ GIM_Try, /*On fail goto*//*Label 59*/ GIMT_Encode4(836), // Rule ID 8 //
     /*  818 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule5Enabled),
     /*  821 */   // MIs[0] dst
     /*  821 */   // No operand predicates
     /*  821 */   // MIs[0] lhs
     /*  821 */   // No operand predicates
     /*  821 */   // MIs[0] Operand 2
     /*  821 */   GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 0,
     /*  825 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /*  830 */   // Combiner Rule #5: right_identity_zero @ [__right_identity_zero_match_0[1]]
     /*  830 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /*  835 */   GIR_EraseRootFromParent_Done,
     /*  836 */ // Label 59: @836
     /*  836 */ GIM_Reject,
     /*  837 */ // Label 1: @837
     /*  837 */ GIM_Try, /*On fail goto*//*Label 60*/ GIMT_Encode4(848), // Rule ID 77 //
     /*  842 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule26Enabled),
     /*  845 */   // Combiner Rule #26: simplify_neg_minmax; wip_match_opcode 'G_SUB'
     /*  845 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner16),
     /*  848 */ // Label 60: @848
     /*  848 */ GIM_Try, /*On fail goto*//*Label 61*/ GIMT_Encode4(871), // Rule ID 7 //
     /*  853 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule5Enabled),
     /*  856 */   // MIs[0] dst
     /*  856 */   // No operand predicates
     /*  856 */   // MIs[0] lhs
     /*  856 */   // No operand predicates
     /*  856 */   // MIs[0] Operand 2
     /*  856 */   GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 0,
     /*  860 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /*  865 */   // Combiner Rule #5: right_identity_zero @ [__right_identity_zero_match_0[0]]
     /*  865 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /*  870 */   GIR_EraseRootFromParent_Done,
     /*  871 */ // Label 61: @871
     /*  871 */ GIM_Try, /*On fail goto*//*Label 62*/ GIMT_Encode4(892), // Rule ID 0 //
     /*  876 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule0Enabled),
     /*  879 */   // MIs[0] d
     /*  879 */   // No operand predicates
     /*  879 */   // MIs[0] op1
     /*  879 */   // No operand predicates
     /*  879 */   // MIs[0] c
     /*  879 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  883 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  887 */   // MIs[1] imm
     /*  887 */   // No operand predicates
     /*  887 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  889 */   // Combiner Rule #0: sub_to_add
     /*  889 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner0),
     /*  892 */ // Label 62: @892
     /*  892 */ GIM_Reject,
     /*  893 */ // Label 2: @893
     /*  893 */ GIM_Try, /*On fail goto*//*Label 63*/ GIMT_Encode4(904), // Rule ID 49 //
     /*  898 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule24Enabled),
     /*  901 */   // Combiner Rule #24: commute_int_constant_to_rhs; wip_match_opcode 'G_MUL'
     /*  901 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner14),
     /*  904 */ // Label 63: @904
     /*  904 */ GIM_Try, /*On fail goto*//*Label 64*/ GIMT_Encode4(927), // Rule ID 26 //
     /*  909 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule8Enabled),
     /*  912 */   // MIs[0] dst
     /*  912 */   // No operand predicates
     /*  912 */   // MIs[0] lhs
     /*  912 */   // No operand predicates
     /*  912 */   // MIs[0] zero
     /*  912 */   GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 0,
     /*  916 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/2,
     /*  921 */   // Combiner Rule #8: binop_right_to_zero
     /*  921 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/2,
     /*  926 */   GIR_EraseRootFromParent_Done,
     /*  927 */ // Label 64: @927
     /*  927 */ GIM_Try, /*On fail goto*//*Label 65*/ GIMT_Encode4(950), // Rule ID 31 //
     /*  932 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule13Enabled),
     /*  935 */   // MIs[0] dst
     /*  935 */   // No operand predicates
     /*  935 */   // MIs[0] x
     /*  935 */   // No operand predicates
     /*  935 */   // MIs[0] Operand 2
     /*  935 */   GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 1,
     /*  939 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /*  944 */   // Combiner Rule #13: right_identity_one_int
     /*  944 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /*  949 */   GIR_EraseRootFromParent_Done,
     /*  950 */ // Label 65: @950
     /*  950 */ GIM_Reject,
     /*  951 */ // Label 3: @951
     /*  951 */ GIM_Try, /*On fail goto*//*Label 66*/ GIMT_Encode4(962), // Rule ID 22 //
     /*  956 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule7Enabled),
     /*  959 */   // Combiner Rule #7: binop_left_to_zero; wip_match_opcode 'G_SDIV'
     /*  959 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner5),
     /*  962 */ // Label 66: @962
     /*  962 */ GIM_Reject,
     /*  963 */ // Label 4: @963
     /*  963 */ GIM_Try, /*On fail goto*//*Label 67*/ GIMT_Encode4(974), // Rule ID 23 //
     /*  968 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule7Enabled),
     /*  971 */   // Combiner Rule #7: binop_left_to_zero; wip_match_opcode 'G_UDIV'
     /*  971 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner5),
     /*  974 */ // Label 67: @974
     /*  974 */ GIM_Reject,
     /*  975 */ // Label 5: @975
     /*  975 */ GIM_Try, /*On fail goto*//*Label 68*/ GIMT_Encode4(986), // Rule ID 24 //
     /*  980 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule7Enabled),
     /*  983 */   // Combiner Rule #7: binop_left_to_zero; wip_match_opcode 'G_SREM'
     /*  983 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner5),
     /*  986 */ // Label 68: @986
     /*  986 */ GIM_Reject,
     /*  987 */ // Label 6: @987
     /*  987 */ GIM_Try, /*On fail goto*//*Label 69*/ GIMT_Encode4(998), // Rule ID 25 //
     /*  992 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule7Enabled),
     /*  995 */   // Combiner Rule #7: binop_left_to_zero; wip_match_opcode 'G_UREM'
     /*  995 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner5),
     /*  998 */ // Label 69: @998
     /*  998 */ GIM_Reject,
     /*  999 */ // Label 7: @999
     /*  999 */ GIM_Try, /*On fail goto*//*Label 70*/ GIMT_Encode4(1010), // Rule ID 4 //
     /* 1004 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule2Enabled),
     /* 1007 */   // Combiner Rule #2: load_and_mask; wip_match_opcode 'G_AND'
     /* 1007 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner2),
     /* 1010 */ // Label 70: @1010
     /* 1010 */ GIM_Try, /*On fail goto*//*Label 71*/ GIMT_Encode4(1021), // Rule ID 5 //
     /* 1015 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule3Enabled),
     /* 1018 */   // Combiner Rule #3: redundant_and; wip_match_opcode 'G_AND'
     /* 1018 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner3),
     /* 1021 */ // Label 71: @1021
     /* 1021 */ GIM_Try, /*On fail goto*//*Label 72*/ GIMT_Encode4(1032), // Rule ID 50 //
     /* 1026 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule24Enabled),
     /* 1029 */   // Combiner Rule #24: commute_int_constant_to_rhs; wip_match_opcode 'G_AND'
     /* 1029 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner14),
     /* 1032 */ // Label 72: @1032
     /* 1032 */ GIM_Try, /*On fail goto*//*Label 73*/ GIMT_Encode4(1056), // Rule ID 17 //
     /* 1037 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule6Enabled),
     /* 1040 */   // MIs[0] dst
     /* 1040 */   // No operand predicates
     /* 1040 */   // MIs[0] src
     /* 1040 */   // No operand predicates
     /* 1040 */   // MIs[0] src
     /* 1040 */   GIM_CheckIsSameOperandIgnoreCopies, /*MI*/0, /*OpIdx*/2, /*OtherMI*/0, /*OtherOpIdx*/1,
     /* 1045 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 1050 */   // Combiner Rule #6: binop_same_val @ [__binop_same_val_match_0[0]]
     /* 1050 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 1055 */   GIR_EraseRootFromParent_Done,
     /* 1056 */ // Label 73: @1056
     /* 1056 */ GIM_Reject,
     /* 1057 */ // Label 8: @1057
     /* 1057 */ GIM_Try, /*On fail goto*//*Label 74*/ GIMT_Encode4(1068), // Rule ID 51 //
     /* 1062 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule24Enabled),
     /* 1065 */   // Combiner Rule #24: commute_int_constant_to_rhs; wip_match_opcode 'G_OR'
     /* 1065 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner14),
     /* 1068 */ // Label 74: @1068
     /* 1068 */ GIM_Try, /*On fail goto*//*Label 75*/ GIMT_Encode4(1092), // Rule ID 18 //
     /* 1073 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule6Enabled),
     /* 1076 */   // MIs[0] dst
     /* 1076 */   // No operand predicates
     /* 1076 */   // MIs[0] src
     /* 1076 */   // No operand predicates
     /* 1076 */   // MIs[0] src
     /* 1076 */   GIM_CheckIsSameOperandIgnoreCopies, /*MI*/0, /*OpIdx*/2, /*OtherMI*/0, /*OtherOpIdx*/1,
     /* 1081 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 1086 */   // Combiner Rule #6: binop_same_val @ [__binop_same_val_match_0[1]]
     /* 1086 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 1091 */   GIR_EraseRootFromParent_Done,
     /* 1092 */ // Label 75: @1092
     /* 1092 */ GIM_Try, /*On fail goto*//*Label 76*/ GIMT_Encode4(1115), // Rule ID 9 //
     /* 1097 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule5Enabled),
     /* 1100 */   // MIs[0] dst
     /* 1100 */   // No operand predicates
     /* 1100 */   // MIs[0] lhs
     /* 1100 */   // No operand predicates
     /* 1100 */   // MIs[0] Operand 2
     /* 1100 */   GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 0,
     /* 1104 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 1109 */   // Combiner Rule #5: right_identity_zero @ [__right_identity_zero_match_0[2]]
     /* 1109 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 1114 */   GIR_EraseRootFromParent_Done,
     /* 1115 */ // Label 76: @1115
     /* 1115 */ GIM_Reject,
     /* 1116 */ // Label 9: @1116
     /* 1116 */ GIM_Try, /*On fail goto*//*Label 77*/ GIMT_Encode4(1127), // Rule ID 52 //
     /* 1121 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule24Enabled),
     /* 1124 */   // Combiner Rule #24: commute_int_constant_to_rhs; wip_match_opcode 'G_XOR'
     /* 1124 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner14),
     /* 1127 */ // Label 77: @1127
     /* 1127 */ GIM_Try, /*On fail goto*//*Label 78*/ GIMT_Encode4(1150), // Rule ID 10 //
     /* 1132 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule5Enabled),
     /* 1135 */   // MIs[0] dst
     /* 1135 */   // No operand predicates
     /* 1135 */   // MIs[0] lhs
     /* 1135 */   // No operand predicates
     /* 1135 */   // MIs[0] Operand 2
     /* 1135 */   GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 0,
     /* 1139 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 1144 */   // Combiner Rule #5: right_identity_zero @ [__right_identity_zero_match_0[3]]
     /* 1144 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 1149 */   GIR_EraseRootFromParent_Done,
     /* 1150 */ // Label 78: @1150
     /* 1150 */ GIM_Reject,
     /* 1151 */ // Label 10: @1151
     /* 1151 */ GIM_Try, /*On fail goto*//*Label 79*/ GIMT_Encode4(1162), // Rule ID 36 //
     /* 1156 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule16Enabled),
     /* 1159 */   // Combiner Rule #16: buildvector_identity_fold; wip_match_opcode 'G_BUILD_VECTOR'
     /* 1159 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner9),
     /* 1162 */ // Label 79: @1162
     /* 1162 */ GIM_Reject,
     /* 1163 */ // Label 11: @1163
     /* 1163 */ GIM_Try, /*On fail goto*//*Label 80*/ GIMT_Encode4(1174), // Rule ID 35 //
     /* 1168 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule16Enabled),
     /* 1171 */   // Combiner Rule #16: buildvector_identity_fold; wip_match_opcode 'G_BUILD_VECTOR_TRUNC'
     /* 1171 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner9),
     /* 1174 */ // Label 80: @1174
     /* 1174 */ GIM_Reject,
     /* 1175 */ // Label 12: @1175
     /* 1175 */ GIM_Try, /*On fail goto*//*Label 81*/ GIMT_Encode4(1196), // Rule ID 28 //
     /* 1180 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule10Enabled),
     /* 1183 */   // MIs[0] dst
     /* 1183 */   // No operand predicates
     /* 1183 */   // MIs[0] t
     /* 1183 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 1187 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTTOPTR),
     /* 1191 */   // MIs[1] ptr
     /* 1191 */   // No operand predicates
     /* 1191 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 1193 */   // Combiner Rule #10: i2p_to_p2i
     /* 1193 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner7),
     /* 1196 */ // Label 81: @1196
     /* 1196 */ GIM_Reject,
     /* 1197 */ // Label 13: @1197
     /* 1197 */ GIM_Try, /*On fail goto*//*Label 82*/ GIMT_Encode4(1208), // Rule ID 27 //
     /* 1202 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule9Enabled),
     /* 1205 */   // Combiner Rule #9: p2i_to_i2p; wip_match_opcode 'G_INTTOPTR'
     /* 1205 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner6),
     /* 1208 */ // Label 82: @1208
     /* 1208 */ GIM_Reject,
     /* 1209 */ // Label 14: @1209
     /* 1209 */ GIM_Try, /*On fail goto*//*Label 83*/ GIMT_Encode4(1230), // Rule ID 39 //
     /* 1214 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule19Enabled),
     /* 1217 */   // MIs[0] dst
     /* 1217 */   // No operand predicates
     /* 1217 */   // MIs[0] src1
     /* 1217 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 1221 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BITCAST),
     /* 1225 */   // MIs[1] src0
     /* 1225 */   // No operand predicates
     /* 1225 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 1227 */   // Combiner Rule #19: bitcast_bitcast_fold
     /* 1227 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner12),
     /* 1230 */ // Label 83: @1230
     /* 1230 */ GIM_Reject,
     /* 1231 */ // Label 15: @1231
     /* 1231 */ GIM_Try, /*On fail goto*//*Label 84*/ GIMT_Encode4(1242), // Rule ID 1 //
     /* 1236 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule1Enabled),
     /* 1239 */   // Combiner Rule #1: extending_loads; wip_match_opcode 'G_LOAD'
     /* 1239 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner1),
     /* 1242 */ // Label 84: @1242
     /* 1242 */ GIM_Reject,
     /* 1243 */ // Label 16: @1243
     /* 1243 */ GIM_Try, /*On fail goto*//*Label 85*/ GIMT_Encode4(1254), // Rule ID 2 //
     /* 1248 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule1Enabled),
     /* 1251 */   // Combiner Rule #1: extending_loads; wip_match_opcode 'G_SEXTLOAD'
     /* 1251 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner1),
     /* 1254 */ // Label 85: @1254
     /* 1254 */ GIM_Reject,
     /* 1255 */ // Label 17: @1255
     /* 1255 */ GIM_Try, /*On fail goto*//*Label 86*/ GIMT_Encode4(1266), // Rule ID 3 //
     /* 1260 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule1Enabled),
     /* 1263 */   // Combiner Rule #1: extending_loads; wip_match_opcode 'G_ZEXTLOAD'
     /* 1263 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner1),
     /* 1266 */ // Label 86: @1266
     /* 1266 */ GIM_Reject,
     /* 1267 */ // Label 18: @1267
     /* 1267 */ GIM_Try, /*On fail goto*//*Label 87*/ GIMT_Encode4(1278), // Rule ID 29 //
     /* 1272 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule11Enabled),
     /* 1275 */   // Combiner Rule #11: anyext_trunc_fold; wip_match_opcode 'G_ANYEXT'
     /* 1275 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner8),
     /* 1278 */ // Label 87: @1278
     /* 1278 */ GIM_Reject,
     /* 1279 */ // Label 19: @1279
     /* 1279 */ GIM_Try, /*On fail goto*//*Label 88*/ GIMT_Encode4(1290), // Rule ID 37 //
     /* 1284 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule17Enabled),
     /* 1287 */   // Combiner Rule #17: trunc_buildvector_fold; wip_match_opcode 'G_TRUNC'
     /* 1287 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner10),
     /* 1290 */ // Label 88: @1290
     /* 1290 */ GIM_Try, /*On fail goto*//*Label 89*/ GIMT_Encode4(1301), // Rule ID 38 //
     /* 1295 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule18Enabled),
     /* 1298 */   // Combiner Rule #18: trunc_lshr_buildvector_fold; wip_match_opcode 'G_TRUNC'
     /* 1298 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner11),
     /* 1301 */ // Label 89: @1301
     /* 1301 */ GIM_Reject,
     /* 1302 */ // Label 20: @1302
     /* 1302 */ GIM_Try, /*On fail goto*//*Label 90*/ GIMT_Encode4(1313), // Rule ID 19 //
     /* 1307 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule7Enabled),
     /* 1310 */   // Combiner Rule #7: binop_left_to_zero; wip_match_opcode 'G_SHL'
     /* 1310 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner5),
     /* 1313 */ // Label 90: @1313
     /* 1313 */ GIM_Try, /*On fail goto*//*Label 91*/ GIMT_Encode4(1324), // Rule ID 43 //
     /* 1318 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule23Enabled),
     /* 1321 */   // Combiner Rule #23: shift_immed_chain; wip_match_opcode 'G_SHL'
     /* 1321 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner13),
     /* 1324 */ // Label 91: @1324
     /* 1324 */ GIM_Try, /*On fail goto*//*Label 92*/ GIMT_Encode4(1347), // Rule ID 11 //
     /* 1329 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule5Enabled),
     /* 1332 */   // MIs[0] dst
     /* 1332 */   // No operand predicates
     /* 1332 */   // MIs[0] lhs
     /* 1332 */   // No operand predicates
     /* 1332 */   // MIs[0] Operand 2
     /* 1332 */   GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 0,
     /* 1336 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 1341 */   // Combiner Rule #5: right_identity_zero @ [__right_identity_zero_match_0[4]]
     /* 1341 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 1346 */   GIR_EraseRootFromParent_Done,
     /* 1347 */ // Label 92: @1347
     /* 1347 */ GIM_Reject,
     /* 1348 */ // Label 21: @1348
     /* 1348 */ GIM_Try, /*On fail goto*//*Label 93*/ GIMT_Encode4(1359), // Rule ID 20 //
     /* 1353 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule7Enabled),
     /* 1356 */   // Combiner Rule #7: binop_left_to_zero; wip_match_opcode 'G_LSHR'
     /* 1356 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner5),
     /* 1359 */ // Label 93: @1359
     /* 1359 */ GIM_Try, /*On fail goto*//*Label 94*/ GIMT_Encode4(1370), // Rule ID 45 //
     /* 1364 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule23Enabled),
     /* 1367 */   // Combiner Rule #23: shift_immed_chain; wip_match_opcode 'G_LSHR'
     /* 1367 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner13),
     /* 1370 */ // Label 94: @1370
     /* 1370 */ GIM_Try, /*On fail goto*//*Label 95*/ GIMT_Encode4(1393), // Rule ID 13 //
     /* 1375 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule5Enabled),
     /* 1378 */   // MIs[0] dst
     /* 1378 */   // No operand predicates
     /* 1378 */   // MIs[0] lhs
     /* 1378 */   // No operand predicates
     /* 1378 */   // MIs[0] Operand 2
     /* 1378 */   GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 0,
     /* 1382 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 1387 */   // Combiner Rule #5: right_identity_zero @ [__right_identity_zero_match_0[6]]
     /* 1387 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 1392 */   GIR_EraseRootFromParent_Done,
     /* 1393 */ // Label 95: @1393
     /* 1393 */ GIM_Reject,
     /* 1394 */ // Label 22: @1394
     /* 1394 */ GIM_Try, /*On fail goto*//*Label 96*/ GIMT_Encode4(1405), // Rule ID 21 //
     /* 1399 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule7Enabled),
     /* 1402 */   // Combiner Rule #7: binop_left_to_zero; wip_match_opcode 'G_ASHR'
     /* 1402 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner5),
     /* 1405 */ // Label 96: @1405
     /* 1405 */ GIM_Try, /*On fail goto*//*Label 97*/ GIMT_Encode4(1416), // Rule ID 44 //
     /* 1410 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule23Enabled),
     /* 1413 */   // Combiner Rule #23: shift_immed_chain; wip_match_opcode 'G_ASHR'
     /* 1413 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner13),
     /* 1416 */ // Label 97: @1416
     /* 1416 */ GIM_Try, /*On fail goto*//*Label 98*/ GIMT_Encode4(1439), // Rule ID 12 //
     /* 1421 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule5Enabled),
     /* 1424 */   // MIs[0] dst
     /* 1424 */   // No operand predicates
     /* 1424 */   // MIs[0] lhs
     /* 1424 */   // No operand predicates
     /* 1424 */   // MIs[0] Operand 2
     /* 1424 */   GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 0,
     /* 1428 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 1433 */   // Combiner Rule #5: right_identity_zero @ [__right_identity_zero_match_0[5]]
     /* 1433 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 1438 */   GIR_EraseRootFromParent_Done,
     /* 1439 */ // Label 98: @1439
     /* 1439 */ GIM_Reject,
     /* 1440 */ // Label 23: @1440
     /* 1440 */ GIM_Try, /*On fail goto*//*Label 99*/ GIMT_Encode4(1463), // Rule ID 16 //
     /* 1445 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule5Enabled),
     /* 1448 */   // MIs[0] dst
     /* 1448 */   // No operand predicates
     /* 1448 */   // MIs[0] lhs
     /* 1448 */   // No operand predicates
     /* 1448 */   // MIs[0] Operand 2
     /* 1448 */   GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 0,
     /* 1452 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 1457 */   // Combiner Rule #5: right_identity_zero @ [__right_identity_zero_match_0[9]]
     /* 1457 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 1462 */   GIR_EraseRootFromParent_Done,
     /* 1463 */ // Label 99: @1463
     /* 1463 */ GIM_Reject,
     /* 1464 */ // Label 24: @1464
     /* 1464 */ GIM_Try, /*On fail goto*//*Label 100*/ GIMT_Encode4(1487), // Rule ID 15 //
     /* 1469 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule5Enabled),
     /* 1472 */   // MIs[0] dst
     /* 1472 */   // No operand predicates
     /* 1472 */   // MIs[0] lhs
     /* 1472 */   // No operand predicates
     /* 1472 */   // MIs[0] Operand 2
     /* 1472 */   GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 0,
     /* 1476 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 1481 */   // Combiner Rule #5: right_identity_zero @ [__right_identity_zero_match_0[8]]
     /* 1481 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 1486 */   GIR_EraseRootFromParent_Done,
     /* 1487 */ // Label 100: @1487
     /* 1487 */ GIM_Reject,
     /* 1488 */ // Label 25: @1488
     /* 1488 */ GIM_Try, /*On fail goto*//*Label 101*/ GIMT_Encode4(1499), // Rule ID 6 //
     /* 1493 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule4Enabled),
     /* 1496 */   // Combiner Rule #4: select_same_val; wip_match_opcode 'G_SELECT'
     /* 1496 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner4),
     /* 1499 */ // Label 101: @1499
     /* 1499 */ GIM_Reject,
     /* 1500 */ // Label 26: @1500
     /* 1500 */ GIM_Try, /*On fail goto*//*Label 102*/ GIMT_Encode4(1511), // Rule ID 57 //
     /* 1505 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule24Enabled),
     /* 1508 */   // Combiner Rule #24: commute_int_constant_to_rhs; wip_match_opcode 'G_UADDO'
     /* 1508 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner14),
     /* 1511 */ // Label 102: @1511
     /* 1511 */ GIM_Reject,
     /* 1512 */ // Label 27: @1512
     /* 1512 */ GIM_Try, /*On fail goto*//*Label 103*/ GIMT_Encode4(1523), // Rule ID 58 //
     /* 1517 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule24Enabled),
     /* 1520 */   // Combiner Rule #24: commute_int_constant_to_rhs; wip_match_opcode 'G_SADDO'
     /* 1520 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner14),
     /* 1523 */ // Label 103: @1523
     /* 1523 */ GIM_Reject,
     /* 1524 */ // Label 28: @1524
     /* 1524 */ GIM_Try, /*On fail goto*//*Label 104*/ GIMT_Encode4(1535), // Rule ID 59 //
     /* 1529 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule24Enabled),
     /* 1532 */   // Combiner Rule #24: commute_int_constant_to_rhs; wip_match_opcode 'G_UMULO'
     /* 1532 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner14),
     /* 1535 */ // Label 104: @1535
     /* 1535 */ GIM_Reject,
     /* 1536 */ // Label 29: @1536
     /* 1536 */ GIM_Try, /*On fail goto*//*Label 105*/ GIMT_Encode4(1547), // Rule ID 60 //
     /* 1541 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule24Enabled),
     /* 1544 */   // Combiner Rule #24: commute_int_constant_to_rhs; wip_match_opcode 'G_SMULO'
     /* 1544 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner14),
     /* 1547 */ // Label 105: @1547
     /* 1547 */ GIM_Reject,
     /* 1548 */ // Label 30: @1548
     /* 1548 */ GIM_Try, /*On fail goto*//*Label 106*/ GIMT_Encode4(1559), // Rule ID 61 //
     /* 1553 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule24Enabled),
     /* 1556 */   // Combiner Rule #24: commute_int_constant_to_rhs; wip_match_opcode 'G_UMULH'
     /* 1556 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner14),
     /* 1559 */ // Label 106: @1559
     /* 1559 */ GIM_Reject,
     /* 1560 */ // Label 31: @1560
     /* 1560 */ GIM_Try, /*On fail goto*//*Label 107*/ GIMT_Encode4(1571), // Rule ID 62 //
     /* 1565 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule24Enabled),
     /* 1568 */   // Combiner Rule #24: commute_int_constant_to_rhs; wip_match_opcode 'G_SMULH'
     /* 1568 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner14),
     /* 1571 */ // Label 107: @1571
     /* 1571 */ GIM_Reject,
     /* 1572 */ // Label 32: @1572
     /* 1572 */ GIM_Try, /*On fail goto*//*Label 108*/ GIMT_Encode4(1583), // Rule ID 63 //
     /* 1577 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule24Enabled),
     /* 1580 */   // Combiner Rule #24: commute_int_constant_to_rhs; wip_match_opcode 'G_UADDSAT'
     /* 1580 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner14),
     /* 1583 */ // Label 108: @1583
     /* 1583 */ GIM_Reject,
     /* 1584 */ // Label 33: @1584
     /* 1584 */ GIM_Try, /*On fail goto*//*Label 109*/ GIMT_Encode4(1595), // Rule ID 64 //
     /* 1589 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule24Enabled),
     /* 1592 */   // Combiner Rule #24: commute_int_constant_to_rhs; wip_match_opcode 'G_SADDSAT'
     /* 1592 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner14),
     /* 1595 */ // Label 109: @1595
     /* 1595 */ GIM_Reject,
     /* 1596 */ // Label 34: @1596
     /* 1596 */ GIM_Try, /*On fail goto*//*Label 110*/ GIMT_Encode4(1607), // Rule ID 47 //
     /* 1601 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule23Enabled),
     /* 1604 */   // Combiner Rule #23: shift_immed_chain; wip_match_opcode 'G_USHLSAT'
     /* 1604 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner13),
     /* 1607 */ // Label 110: @1607
     /* 1607 */ GIM_Reject,
     /* 1608 */ // Label 35: @1608
     /* 1608 */ GIM_Try, /*On fail goto*//*Label 111*/ GIMT_Encode4(1619), // Rule ID 46 //
     /* 1613 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule23Enabled),
     /* 1616 */   // Combiner Rule #23: shift_immed_chain; wip_match_opcode 'G_SSHLSAT'
     /* 1616 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner13),
     /* 1619 */ // Label 111: @1619
     /* 1619 */ GIM_Reject,
     /* 1620 */ // Label 36: @1620
     /* 1620 */ GIM_Try, /*On fail goto*//*Label 112*/ GIMT_Encode4(1631), // Rule ID 65 //
     /* 1625 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule24Enabled),
     /* 1628 */   // Combiner Rule #24: commute_int_constant_to_rhs; wip_match_opcode 'G_SMULFIX'
     /* 1628 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner14),
     /* 1631 */ // Label 112: @1631
     /* 1631 */ GIM_Reject,
     /* 1632 */ // Label 37: @1632
     /* 1632 */ GIM_Try, /*On fail goto*//*Label 113*/ GIMT_Encode4(1643), // Rule ID 66 //
     /* 1637 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule24Enabled),
     /* 1640 */   // Combiner Rule #24: commute_int_constant_to_rhs; wip_match_opcode 'G_UMULFIX'
     /* 1640 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner14),
     /* 1643 */ // Label 113: @1643
     /* 1643 */ GIM_Reject,
     /* 1644 */ // Label 38: @1644
     /* 1644 */ GIM_Try, /*On fail goto*//*Label 114*/ GIMT_Encode4(1655), // Rule ID 67 //
     /* 1649 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule24Enabled),
     /* 1652 */   // Combiner Rule #24: commute_int_constant_to_rhs; wip_match_opcode 'G_SMULFIXSAT'
     /* 1652 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner14),
     /* 1655 */ // Label 114: @1655
     /* 1655 */ GIM_Reject,
     /* 1656 */ // Label 39: @1656
     /* 1656 */ GIM_Try, /*On fail goto*//*Label 115*/ GIMT_Encode4(1667), // Rule ID 68 //
     /* 1661 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule24Enabled),
     /* 1664 */   // Combiner Rule #24: commute_int_constant_to_rhs; wip_match_opcode 'G_UMULFIXSAT'
     /* 1664 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner14),
     /* 1667 */ // Label 115: @1667
     /* 1667 */ GIM_Reject,
     /* 1668 */ // Label 40: @1668
     /* 1668 */ GIM_Try, /*On fail goto*//*Label 116*/ GIMT_Encode4(1679), // Rule ID 69 //
     /* 1673 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule25Enabled),
     /* 1676 */   // Combiner Rule #25: commute_fp_constant_to_rhs; wip_match_opcode 'G_FADD'
     /* 1676 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner15),
     /* 1679 */ // Label 116: @1679
     /* 1679 */ GIM_Try, /*On fail goto*//*Label 117*/ GIMT_Encode4(1702), // Rule ID 41 //
     /* 1684 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule21Enabled),
     /* 1687 */   // MIs[0] dst
     /* 1687 */   // No operand predicates
     /* 1687 */   // MIs[0] x
     /* 1687 */   // No operand predicates
     /* 1687 */   // MIs[0] y
     /* 1687 */   // No operand predicates
     /* 1687 */   GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_GICombiner1),
     /* 1691 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 1696 */   // Combiner Rule #21: right_identity_neg_zero_fp
     /* 1696 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 1701 */   GIR_EraseRootFromParent_Done,
     /* 1702 */ // Label 117: @1702
     /* 1702 */ GIM_Reject,
     /* 1703 */ // Label 41: @1703
     /* 1703 */ GIM_Try, /*On fail goto*//*Label 118*/ GIMT_Encode4(1714), // Rule ID 70 //
     /* 1708 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule25Enabled),
     /* 1711 */   // Combiner Rule #25: commute_fp_constant_to_rhs; wip_match_opcode 'G_FMUL'
     /* 1711 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner15),
     /* 1714 */ // Label 118: @1714
     /* 1714 */ GIM_Try, /*On fail goto*//*Label 119*/ GIMT_Encode4(1737), // Rule ID 32 //
     /* 1719 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule14Enabled),
     /* 1722 */   // MIs[0] dst
     /* 1722 */   // No operand predicates
     /* 1722 */   // MIs[0] x
     /* 1722 */   // No operand predicates
     /* 1722 */   // MIs[0] y
     /* 1722 */   // No operand predicates
     /* 1722 */   GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_GICombiner0),
     /* 1726 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 1731 */   // Combiner Rule #14: right_identity_one_fp
     /* 1731 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 1736 */   GIR_EraseRootFromParent_Done,
     /* 1737 */ // Label 119: @1737
     /* 1737 */ GIM_Try, /*On fail goto*//*Label 120*/ GIMT_Encode4(1757), // Rule ID 42 //
     /* 1742 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule22Enabled),
     /* 1745 */   // MIs[0] dst
     /* 1745 */   // No operand predicates
     /* 1745 */   // MIs[0] x
     /* 1745 */   // No operand predicates
     /* 1745 */   // MIs[0] y
     /* 1745 */   // No operand predicates
     /* 1745 */   GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_GICombiner2),
     /* 1749 */   // Combiner Rule #22: right_identity_neg_one_fp
     /* 1749 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::G_FNEG),
     /* 1752 */   GIR_RootToRootCopy, /*OpIdx*/0, // dst
     /* 1754 */   GIR_RootToRootCopy, /*OpIdx*/1, // x
     /* 1756 */   GIR_EraseRootFromParent_Done,
     /* 1757 */ // Label 120: @1757
     /* 1757 */ GIM_Reject,
     /* 1758 */ // Label 42: @1758
     /* 1758 */ GIM_Try, /*On fail goto*//*Label 121*/ GIMT_Encode4(1787), // Rule ID 30 //
     /* 1763 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule12Enabled),
     /* 1766 */   // MIs[0] dst
     /* 1766 */   // No operand predicates
     /* 1766 */   // MIs[0] t
     /* 1766 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 1770 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_FNEG),
     /* 1774 */   // MIs[1] src
     /* 1774 */   // No operand predicates
     /* 1774 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/1, /*NewOpIdx*/1,
     /* 1779 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 1781 */   // Combiner Rule #12: fneg_fneg_fold
     /* 1781 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/1, /*NewOpIdx*/1,
     /* 1786 */   GIR_EraseRootFromParent_Done,
     /* 1787 */ // Label 121: @1787
     /* 1787 */ GIM_Reject,
     /* 1788 */ // Label 43: @1788
     /* 1788 */ GIM_Try, /*On fail goto*//*Label 122*/ GIMT_Encode4(1809), // Rule ID 40 //
     /* 1793 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule20Enabled),
     /* 1796 */   // MIs[0] dst
     /* 1796 */   // No operand predicates
     /* 1796 */   // MIs[0] src1
     /* 1796 */   GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 1800 */   GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_FPEXT),
     /* 1804 */   // MIs[1] src0
     /* 1804 */   // No operand predicates
     /* 1804 */   GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 1806 */   // Combiner Rule #20: fptrunc_fpext_fold
     /* 1806 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner12),
     /* 1809 */ // Label 122: @1809
     /* 1809 */ GIM_Reject,
     /* 1810 */ // Label 44: @1810
     /* 1810 */ GIM_Try, /*On fail goto*//*Label 123*/ GIMT_Encode4(1821), // Rule ID 71 //
     /* 1815 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule25Enabled),
     /* 1818 */   // Combiner Rule #25: commute_fp_constant_to_rhs; wip_match_opcode 'G_FMINNUM'
     /* 1818 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner15),
     /* 1821 */ // Label 123: @1821
     /* 1821 */ GIM_Reject,
     /* 1822 */ // Label 45: @1822
     /* 1822 */ GIM_Try, /*On fail goto*//*Label 124*/ GIMT_Encode4(1833), // Rule ID 72 //
     /* 1827 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule25Enabled),
     /* 1830 */   // Combiner Rule #25: commute_fp_constant_to_rhs; wip_match_opcode 'G_FMAXNUM'
     /* 1830 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner15),
     /* 1833 */ // Label 124: @1833
     /* 1833 */ GIM_Reject,
     /* 1834 */ // Label 46: @1834
     /* 1834 */ GIM_Try, /*On fail goto*//*Label 125*/ GIMT_Encode4(1845), // Rule ID 73 //
     /* 1839 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule25Enabled),
     /* 1842 */   // Combiner Rule #25: commute_fp_constant_to_rhs; wip_match_opcode 'G_FMINNUM_IEEE'
     /* 1842 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner15),
     /* 1845 */ // Label 125: @1845
     /* 1845 */ GIM_Reject,
     /* 1846 */ // Label 47: @1846
     /* 1846 */ GIM_Try, /*On fail goto*//*Label 126*/ GIMT_Encode4(1857), // Rule ID 74 //
     /* 1851 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule25Enabled),
     /* 1854 */   // Combiner Rule #25: commute_fp_constant_to_rhs; wip_match_opcode 'G_FMAXNUM_IEEE'
     /* 1854 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner15),
     /* 1857 */ // Label 126: @1857
     /* 1857 */ GIM_Reject,
     /* 1858 */ // Label 48: @1858
     /* 1858 */ GIM_Try, /*On fail goto*//*Label 127*/ GIMT_Encode4(1869), // Rule ID 75 //
     /* 1863 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule25Enabled),
     /* 1866 */   // Combiner Rule #25: commute_fp_constant_to_rhs; wip_match_opcode 'G_FMINIMUM'
     /* 1866 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner15),
     /* 1869 */ // Label 127: @1869
     /* 1869 */ GIM_Reject,
     /* 1870 */ // Label 49: @1870
     /* 1870 */ GIM_Try, /*On fail goto*//*Label 128*/ GIMT_Encode4(1881), // Rule ID 76 //
     /* 1875 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule25Enabled),
     /* 1878 */   // Combiner Rule #25: commute_fp_constant_to_rhs; wip_match_opcode 'G_FMAXIMUM'
     /* 1878 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner15),
     /* 1881 */ // Label 128: @1881
     /* 1881 */ GIM_Reject,
     /* 1882 */ // Label 50: @1882
     /* 1882 */ GIM_Try, /*On fail goto*//*Label 129*/ GIMT_Encode4(1905), // Rule ID 14 //
     /* 1887 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule5Enabled),
     /* 1890 */   // MIs[0] dst
     /* 1890 */   // No operand predicates
     /* 1890 */   // MIs[0] lhs
     /* 1890 */   // No operand predicates
     /* 1890 */   // MIs[0] Operand 2
     /* 1890 */   GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 0,
     /* 1894 */   GIM_CheckCanReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 1899 */   // Combiner Rule #5: right_identity_zero @ [__right_identity_zero_match_0[7]]
     /* 1899 */   GIR_ReplaceReg, /*OldInsnID*/0, /*OldOpIdx*/0, /*NewInsnId*/0, /*NewOpIdx*/1,
     /* 1904 */   GIR_EraseRootFromParent_Done,
     /* 1905 */ // Label 129: @1905
     /* 1905 */ GIM_Reject,
     /* 1906 */ // Label 51: @1906
     /* 1906 */ GIM_Try, /*On fail goto*//*Label 130*/ GIMT_Encode4(1917), // Rule ID 53 //
     /* 1911 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule24Enabled),
     /* 1914 */   // Combiner Rule #24: commute_int_constant_to_rhs; wip_match_opcode 'G_SMIN'
     /* 1914 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner14),
     /* 1917 */ // Label 130: @1917
     /* 1917 */ GIM_Reject,
     /* 1918 */ // Label 52: @1918
     /* 1918 */ GIM_Try, /*On fail goto*//*Label 131*/ GIMT_Encode4(1929), // Rule ID 54 //
     /* 1923 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule24Enabled),
     /* 1926 */   // Combiner Rule #24: commute_int_constant_to_rhs; wip_match_opcode 'G_SMAX'
     /* 1926 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner14),
     /* 1929 */ // Label 131: @1929
     /* 1929 */ GIM_Reject,
     /* 1930 */ // Label 53: @1930
     /* 1930 */ GIM_Try, /*On fail goto*//*Label 132*/ GIMT_Encode4(1941), // Rule ID 55 //
     /* 1935 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule24Enabled),
     /* 1938 */   // Combiner Rule #24: commute_int_constant_to_rhs; wip_match_opcode 'G_UMIN'
     /* 1938 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner14),
     /* 1941 */ // Label 132: @1941
     /* 1941 */ GIM_Reject,
     /* 1942 */ // Label 54: @1942
     /* 1942 */ GIM_Try, /*On fail goto*//*Label 133*/ GIMT_Encode4(1953), // Rule ID 56 //
     /* 1947 */   GIM_CheckSimplePredicate, GIMT_Encode2(GICXXPred_Simple_IsRule24Enabled),
     /* 1950 */   // Combiner Rule #24: commute_int_constant_to_rhs; wip_match_opcode 'G_UMAX'
     /* 1950 */   GIR_DoneWithCustomAction, /*Fn*/GIMT_Encode2(GICXXCustomAction_GICombiner14),
     /* 1953 */ // Label 133: @1953
     /* 1953 */ GIM_Reject,
     /* 1954 */ // Label 55: @1954
     /* 1954 */ GIM_Reject,
     /* 1955 */ }; // Size: 1955 bytes
  return MatchTable0;
}
#undef GIMT_Encode2
#undef GIMT_Encode4
#undef GIMT_Encode8

#endif // ifdef GET_GICOMBINER_IMPL

#ifdef GET_GICOMBINER_CONSTRUCTOR_INITS
AvailableModuleFeatures(computeAvailableModuleFeatures(&STI)),
AvailableFunctionFeatures()
#endif // ifdef GET_GICOMBINER_CONSTRUCTOR_INITS
#ifdef GET_GICOMBINER_CONSTRUCTOR_INITS
, State(0),
ExecInfo(TypeObjects, NumTypeObjects, FeatureBitsets, ComplexPredicateFns, CustomRenderers)
#endif // ifdef GET_GICOMBINER_CONSTRUCTOR_INITS

