/* plugin_manager.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from plugin_manager.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <glib-object.h>
#include <glib.h>
#include <gio/gio.h>
#include <libpeas/peas.h>
#include <stdlib.h>
#include <string.h>
#include <girepository.h>
#include <budgie-config.h>
#include <glib/gstdio.h>
#include "plugin.h"
#include <gobject/gvaluecollector.h>

#define BUDGIE_ROOT_SCHEMA "com.solus-project.budgie-panel"
#define BUDGIE_APPLET_PREFIX "/com/solus-project/budgie-panel/applets"
#define BUDGIE_APPLET_SCHEMA "com.solus-project.budgie-panel.applet"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define BUDGIE_TYPE_PANEL_PLUGIN_MANAGER (budgie_panel_plugin_manager_get_type ())
#define BUDGIE_PANEL_PLUGIN_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_PANEL_PLUGIN_MANAGER, BudgiePanelPluginManager))
#define BUDGIE_PANEL_PLUGIN_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_PANEL_PLUGIN_MANAGER, BudgiePanelPluginManagerClass))
#define BUDGIE_IS_PANEL_PLUGIN_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_PANEL_PLUGIN_MANAGER))
#define BUDGIE_IS_PANEL_PLUGIN_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_PANEL_PLUGIN_MANAGER))
#define BUDGIE_PANEL_PLUGIN_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_PANEL_PLUGIN_MANAGER, BudgiePanelPluginManagerClass))

typedef struct _BudgiePanelPluginManager BudgiePanelPluginManager;
typedef struct _BudgiePanelPluginManagerClass BudgiePanelPluginManagerClass;
typedef struct _BudgiePanelPluginManagerPrivate BudgiePanelPluginManagerPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __vala_PeasPluginInfo_free0(var) ((var == NULL) ? NULL : (var = (_vala_PeasPluginInfo_free (var), NULL)))
typedef struct _BudgieParamSpecPanelPluginManager BudgieParamSpecPanelPluginManager;
enum  {
	BUDGIE_PANEL_PLUGIN_MANAGER_EXTENSION_LOADED_SIGNAL,
	BUDGIE_PANEL_PLUGIN_MANAGER_NUM_SIGNALS
};
static guint budgie_panel_plugin_manager_signals[BUDGIE_PANEL_PLUGIN_MANAGER_NUM_SIGNALS] = {0};

struct _BudgiePanelPluginManager {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BudgiePanelPluginManagerPrivate * priv;
	gboolean migrate_load_requirements_met;
};

struct _BudgiePanelPluginManagerClass {
	GTypeClass parent_class;
	void (*finalize) (BudgiePanelPluginManager *self);
};

struct _BudgiePanelPluginManagerPrivate {
	GSettings* settings;
	PeasEngine* engine;
	PeasExtensionSet* extensions;
	GHashTable* plugins;
};

struct _BudgieParamSpecPanelPluginManager {
	GParamSpec parent_instance;
};

static gint BudgiePanelPluginManager_private_offset;
static gpointer budgie_panel_plugin_manager_parent_class = NULL;

VALA_EXTERN gpointer budgie_panel_plugin_manager_ref (gpointer instance);
VALA_EXTERN void budgie_panel_plugin_manager_unref (gpointer instance);
VALA_EXTERN GParamSpec* budgie_param_spec_panel_plugin_manager (const gchar* name,
                                                    const gchar* nick,
                                                    const gchar* blurb,
                                                    GType object_type,
                                                    GParamFlags flags);
VALA_EXTERN void budgie_value_set_panel_plugin_manager (GValue* value,
                                            gpointer v_object);
VALA_EXTERN void budgie_value_take_panel_plugin_manager (GValue* value,
                                             gpointer v_object);
VALA_EXTERN gpointer budgie_value_get_panel_plugin_manager (const GValue* value);
VALA_EXTERN GType budgie_panel_plugin_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BudgiePanelPluginManager, budgie_panel_plugin_manager_unref)
VALA_EXTERN BudgiePanelPluginManager* budgie_panel_plugin_manager_new (void);
VALA_EXTERN BudgiePanelPluginManager* budgie_panel_plugin_manager_construct (GType object_type);
static void _g_free0_ (gpointer var);
static void _vala_PeasPluginInfo_free (PeasPluginInfo* self);
static void __vala_PeasPluginInfo_free0_ (gpointer var);
static void budgie_panel_plugin_manager_on_extension_added (BudgiePanelPluginManager* self,
                                                     PeasPluginInfo* info,
                                                     GObject* p);
static void _budgie_panel_plugin_manager_on_extension_added_peas_extension_set_extension_added (PeasExtensionSet* _sender,
                                                                                         PeasPluginInfo* info,
                                                                                         GObject* exten,
                                                                                         gpointer self);
static void __lambda4_ (BudgiePanelPluginManager* self,
                 PeasPluginInfo* i);
static void ___lambda4__peas_engine_load_plugin (PeasEngine* _sender,
                                          PeasPluginInfo* info,
                                          gpointer self);
static gchar* budgie_panel_plugin_manager_create_applet_path (BudgiePanelPluginManager* self,
                                                       const gchar* uuid);
static PeasPluginInfo* _vala_PeasPluginInfo_copy (PeasPluginInfo* self);
VALA_EXTERN gboolean budgie_panel_plugin_manager_is_extension_loaded (BudgiePanelPluginManager* self,
                                                          const gchar* name);
static gboolean _vala_string_array_contains (const gchar* * stack,
                                      gssize stack_length,
                                      const const gchar* needle);
VALA_EXTERN gboolean budgie_panel_plugin_manager_is_extension_valid (BudgiePanelPluginManager* self,
                                                         const gchar* name);
static PeasPluginInfo* budgie_panel_plugin_manager_get_plugin_info (BudgiePanelPluginManager* self,
                                                             const gchar* name);
VALA_EXTERN GList* budgie_panel_plugin_manager_get_all_plugins (BudgiePanelPluginManager* self);
VALA_EXTERN void budgie_panel_plugin_manager_rescan_plugins (BudgiePanelPluginManager* self);
VALA_EXTERN void budgie_panel_plugin_manager_modprobe (BudgiePanelPluginManager* self,
                                           const gchar* name);
VALA_EXTERN BudgieAppletInfo* budgie_panel_plugin_manager_load_applet_instance (BudgiePanelPluginManager* self,
                                                                    const gchar* uuid,
                                                                    gchar** name,
                                                                    GSettings* psettings);
VALA_EXTERN BudgieAppletInfo* budgie_panel_plugin_manager_create_new_applet (BudgiePanelPluginManager* self,
                                                                 const gchar* name,
                                                                 const gchar* uuid);
static void budgie_panel_plugin_manager_finalize (BudgiePanelPluginManager * obj);
static GType budgie_panel_plugin_manager_get_type_once (void);

VALA_EXTERN const gchar* BUDGIE_MIGRATION_1_APPLETS[2];

static inline gpointer
budgie_panel_plugin_manager_get_instance_private (BudgiePanelPluginManager* self)
{
	return G_STRUCT_MEMBER_P (self, BudgiePanelPluginManager_private_offset);
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_vala_PeasPluginInfo_free (PeasPluginInfo* self)
{
	g_boxed_free (peas_plugin_info_get_type (), self);
}

static void
__vala_PeasPluginInfo_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (_vala_PeasPluginInfo_free (var), NULL));
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_budgie_panel_plugin_manager_on_extension_added_peas_extension_set_extension_added (PeasExtensionSet* _sender,
                                                                                    PeasPluginInfo* info,
                                                                                    GObject* exten,
                                                                                    gpointer self)
{
	budgie_panel_plugin_manager_on_extension_added ((BudgiePanelPluginManager*) self, info, exten);
}

static void
__lambda4_ (BudgiePanelPluginManager* self,
            PeasPluginInfo* i)
{
	PeasExtension* e = NULL;
	PeasExtensionSet* _tmp0_;
	PeasExtension* _tmp1_;
	PeasExtension* _tmp2_;
	PeasExtension* _tmp3_;
	PeasExtension* _tmp5_;
	g_return_if_fail (i != NULL);
	_tmp0_ = self->priv->extensions;
	_tmp1_ = peas_extension_set_get_extension (_tmp0_, i);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	e = _tmp2_;
	_tmp3_ = e;
	if (_tmp3_ == NULL) {
		const gchar* _tmp4_;
		_tmp4_ = peas_plugin_info_get_name (i);
		g_critical ("plugin_manager.vala:69: Failed to find extension for: %s", _tmp4_);
		_g_object_unref0 (e);
		return;
	}
	_tmp5_ = e;
	budgie_panel_plugin_manager_on_extension_added (self, i, (GObject*) _tmp5_);
	_g_object_unref0 (e);
}

static void
___lambda4__peas_engine_load_plugin (PeasEngine* _sender,
                                     PeasPluginInfo* info,
                                     gpointer self)
{
	__lambda4_ ((BudgiePanelPluginManager*) self, info);
}

BudgiePanelPluginManager*
budgie_panel_plugin_manager_construct (GType object_type)
{
	BudgiePanelPluginManager* self = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	GSettings* _tmp3_;
	PeasEngine* _tmp4_;
	PeasEngine* _tmp5_;
	gchar* dir = NULL;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	PeasEngine* _tmp15_;
	gchar* user_mod = NULL;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* hdata = NULL;
	const gchar* _tmp19_;
	gchar* _tmp20_;
	PeasEngine* _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	gchar* hmod = NULL;
	const gchar* _tmp24_;
	gchar* _tmp25_;
	const gchar* _tmp26_;
	PeasEngine* _tmp33_;
	PeasEngine* _tmp34_;
	PeasExtensionSet* _tmp35_;
	PeasExtensionSet* _tmp36_;
	PeasEngine* _tmp37_;
	GError* _inner_error0_ = NULL;
	self = (BudgiePanelPluginManager*) g_type_create_instance (object_type);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, __vala_PeasPluginInfo_free0_);
	_g_hash_table_unref0 (self->priv->plugins);
	self->priv->plugins = _tmp2_;
	_tmp3_ = g_settings_new (BUDGIE_ROOT_SCHEMA);
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp3_;
	_tmp4_ = peas_engine_new ();
	_g_object_unref0 (self->priv->engine);
	self->priv->engine = _tmp4_;
	_tmp5_ = self->priv->engine;
	peas_engine_enable_loader (_tmp5_, "python3");
	{
		GIRepository* repo = NULL;
		GIRepository* _tmp6_;
		GIRepository* _tmp7_;
		GIRepository* _tmp8_;
		GIRepository* _tmp9_;
		GIRepository* _tmp10_;
		_tmp6_ = g_irepository_get_default ();
		_tmp7_ = _g_object_ref0 (_tmp6_);
		repo = _tmp7_;
		_tmp8_ = repo;
		g_irepository_require (_tmp8_, "Peas", "1.0", 0, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (repo);
			goto __catch0_g_error;
		}
		_tmp9_ = repo;
		g_irepository_require (_tmp9_, "PeasGtk", "1.0", 0, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (repo);
			goto __catch0_g_error;
		}
		_tmp10_ = repo;
		g_irepository_require (_tmp10_, "Budgie", "1.0", 0, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (repo);
			goto __catch0_g_error;
		}
		_g_object_unref0 (repo);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp11_;
		const gchar* _tmp12_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp11_ = e;
		_tmp12_ = _tmp11_->message;
		g_message ("plugin_manager.vala:39: Error loading typelibs: %s", _tmp12_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp13_ = g_get_user_data_dir ();
	_tmp14_ = g_strdup (_tmp13_);
	dir = _tmp14_;
	_tmp15_ = self->priv->engine;
	peas_engine_add_search_path (_tmp15_, BUDGIE_MODULE_DIRECTORY, BUDGIE_MODULE_DATA_DIRECTORY);
	if (BUDGIE_HAS_SECONDARY_PLUGIN_DIRS) {
		PeasEngine* _tmp16_;
		_tmp16_ = self->priv->engine;
		peas_engine_add_search_path (_tmp16_, BUDGIE_MODULE_DIRECTORY_SECONDARY, BUDGIE_MODULE_DATA_DIRECTORY_SECONDARY);
	}
	_tmp17_ = dir;
	_tmp18_ = g_build_path (G_DIR_SEPARATOR_S, _tmp17_, "budgie-desktop", "plugins", NULL);
	user_mod = _tmp18_;
	_tmp19_ = dir;
	_tmp20_ = g_build_path (G_DIR_SEPARATOR_S, _tmp19_, "budgie-desktop", "data", NULL);
	hdata = _tmp20_;
	_tmp21_ = self->priv->engine;
	_tmp22_ = user_mod;
	_tmp23_ = hdata;
	peas_engine_add_search_path (_tmp21_, _tmp22_, _tmp23_);
	_tmp24_ = dir;
	_tmp25_ = g_build_path (G_DIR_SEPARATOR_S, _tmp24_, "budgie-desktop", "modules", NULL);
	hmod = _tmp25_;
	_tmp26_ = hmod;
	if (g_file_test (_tmp26_, G_FILE_TEST_EXISTS)) {
		const gchar* _tmp27_;
		const gchar* _tmp28_;
		const gchar* _tmp29_;
		PeasEngine* _tmp30_;
		const gchar* _tmp31_;
		const gchar* _tmp32_;
		_tmp27_ = hmod;
		_tmp28_ = user_mod;
		g_warning ("plugin_manager.vala:57: Using legacy path %s, please migrate to %s", _tmp27_, _tmp28_);
		_tmp29_ = hmod;
		g_message ("plugin_manager.vala:58: Legacy %s path will not be supported in next m" \
"ajor version", _tmp29_);
		_tmp30_ = self->priv->engine;
		_tmp31_ = hmod;
		_tmp32_ = hdata;
		peas_engine_add_search_path (_tmp30_, _tmp31_, _tmp32_);
	}
	_tmp33_ = self->priv->engine;
	peas_engine_rescan_plugins (_tmp33_);
	_tmp34_ = self->priv->engine;
	_tmp35_ = peas_extension_set_new (_tmp34_, budgie_plugin_get_type (), NULL);
	_g_object_unref0 (self->priv->extensions);
	self->priv->extensions = _tmp35_;
	_tmp36_ = self->priv->extensions;
	g_signal_connect (_tmp36_, "extension-added", (GCallback) _budgie_panel_plugin_manager_on_extension_added_peas_extension_set_extension_added, self);
	_tmp37_ = self->priv->engine;
	g_signal_connect_after (_tmp37_, "load-plugin", (GCallback) ___lambda4__peas_engine_load_plugin, self);
	_g_free0 (hmod);
	_g_free0 (hdata);
	_g_free0 (user_mod);
	_g_free0 (dir);
	return self;
}

BudgiePanelPluginManager*
budgie_panel_plugin_manager_new (void)
{
	return budgie_panel_plugin_manager_construct (BUDGIE_TYPE_PANEL_PLUGIN_MANAGER);
}

static gchar*
budgie_panel_plugin_manager_create_applet_path (BudgiePanelPluginManager* self,
                                                const gchar* uuid)
{
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (uuid != NULL, NULL);
	_tmp0_ = g_strdup_printf ("%s/{%s}/", BUDGIE_APPLET_PREFIX, uuid);
	result = _tmp0_;
	return result;
}

/**
* Handle extension loading
*/
static PeasPluginInfo*
_vala_PeasPluginInfo_copy (PeasPluginInfo* self)
{
	return g_boxed_copy (peas_plugin_info_get_type (), self);
}

static gpointer
__vala_PeasPluginInfo_copy0 (gpointer self)
{
	return self ? _vala_PeasPluginInfo_copy (self) : NULL;
}

static void
budgie_panel_plugin_manager_on_extension_added (BudgiePanelPluginManager* self,
                                                PeasPluginInfo* info,
                                                GObject* p)
{
	GHashTable* _tmp0_;
	const gchar* _tmp1_;
	GHashTable* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	PeasPluginInfo* _tmp5_;
	const gchar* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = self->priv->plugins;
	_tmp1_ = peas_plugin_info_get_name (info);
	if (g_hash_table_contains (_tmp0_, _tmp1_)) {
		return;
	}
	_tmp2_ = self->priv->plugins;
	_tmp3_ = peas_plugin_info_get_name (info);
	_tmp4_ = g_strdup (_tmp3_);
	_tmp5_ = __vala_PeasPluginInfo_copy0 (info);
	g_hash_table_insert (_tmp2_, _tmp4_, _tmp5_);
	_tmp6_ = peas_plugin_info_get_name (info);
	g_signal_emit (self, budgie_panel_plugin_manager_signals[BUDGIE_PANEL_PLUGIN_MANAGER_EXTENSION_LOADED_SIGNAL], 0, _tmp6_);
}

static gboolean
_vala_string_array_contains (const gchar* * stack,
                             gssize stack_length,
                             const const gchar* needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}

gboolean
budgie_panel_plugin_manager_is_extension_loaded (BudgiePanelPluginManager* self,
                                                 const gchar* name)
{
	GHashTable* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	if (_vala_string_array_contains (BUDGIE_MIGRATION_1_APPLETS, G_N_ELEMENTS (BUDGIE_MIGRATION_1_APPLETS), name)) {
		self->migrate_load_requirements_met = TRUE;
	}
	_tmp0_ = self->priv->plugins;
	result = g_hash_table_contains (_tmp0_, name);
	return result;
}

/**
* Determine if the extension is known to be valid
*/
gboolean
budgie_panel_plugin_manager_is_extension_valid (BudgiePanelPluginManager* self,
                                                const gchar* name)
{
	PeasPluginInfo* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	if (_vala_string_array_contains (BUDGIE_MIGRATION_1_APPLETS, G_N_ELEMENTS (BUDGIE_MIGRATION_1_APPLETS), name)) {
		self->migrate_load_requirements_met = TRUE;
	}
	_tmp0_ = budgie_panel_plugin_manager_get_plugin_info (self, name);
	if (_tmp0_ == NULL) {
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}

GList*
budgie_panel_plugin_manager_get_all_plugins (BudgiePanelPluginManager* self)
{
	GList* ret = NULL;
	PeasEngine* _tmp0_;
	GList* _tmp1_;
	GList* result;
	g_return_val_if_fail (self != NULL, NULL);
	ret = NULL;
	_tmp0_ = self->priv->engine;
	_tmp1_ = peas_engine_get_plugin_list (_tmp0_);
	{
		GList* info_collection = NULL;
		GList* info_it = NULL;
		info_collection = _tmp1_;
		for (info_it = info_collection; info_it != NULL; info_it = info_it->next) {
			PeasPluginInfo* info = NULL;
			info = (PeasPluginInfo*) info_it->data;
			{
				PeasPluginInfo* _tmp2_;
				PeasPluginInfo* _tmp3_;
				_tmp2_ = info;
				_tmp3_ = __vala_PeasPluginInfo_copy0 (_tmp2_);
				ret = g_list_append (ret, _tmp3_);
			}
		}
	}
	result = ret;
	return result;
}

void
budgie_panel_plugin_manager_rescan_plugins (BudgiePanelPluginManager* self)
{
	PeasEngine* _tmp0_;
	PeasEngine* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->engine;
	peas_engine_garbage_collect (_tmp0_);
	_tmp1_ = self->priv->engine;
	peas_engine_rescan_plugins (_tmp1_);
}

/**
* PeasEngine.get_plugin_info == completely broken
*/
static PeasPluginInfo*
budgie_panel_plugin_manager_get_plugin_info (BudgiePanelPluginManager* self,
                                             const gchar* name)
{
	PeasEngine* _tmp0_;
	GList* _tmp1_;
	PeasPluginInfo* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = self->priv->engine;
	_tmp1_ = peas_engine_get_plugin_list (_tmp0_);
	{
		GList* info_collection = NULL;
		GList* info_it = NULL;
		info_collection = _tmp1_;
		for (info_it = info_collection; info_it != NULL; info_it = info_it->next) {
			PeasPluginInfo* info = NULL;
			info = (PeasPluginInfo*) info_it->data;
			{
				PeasPluginInfo* _tmp2_;
				const gchar* _tmp3_;
				_tmp2_ = info;
				_tmp3_ = peas_plugin_info_get_name (_tmp2_);
				if (g_strcmp0 (_tmp3_, name) == 0) {
					PeasPluginInfo* _tmp4_;
					_tmp4_ = info;
					result = _tmp4_;
					return result;
				}
			}
		}
	}
	result = NULL;
	return result;
}

void
budgie_panel_plugin_manager_modprobe (BudgiePanelPluginManager* self,
                                      const gchar* name)
{
	PeasPluginInfo* i = NULL;
	PeasPluginInfo* _tmp0_;
	PeasPluginInfo* _tmp1_;
	PeasPluginInfo* _tmp2_;
	PeasEngine* _tmp3_;
	PeasPluginInfo* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = budgie_panel_plugin_manager_get_plugin_info (self, name);
	_tmp1_ = __vala_PeasPluginInfo_copy0 (_tmp0_);
	i = _tmp1_;
	_tmp2_ = i;
	if (_tmp2_ == NULL) {
		g_warning ("plugin_manager.vala:144: budgie_panel_modprobe called for non existent" \
" module: %s", name);
		__vala_PeasPluginInfo_free0 (i);
		return;
	}
	_tmp3_ = self->priv->engine;
	_tmp4_ = i;
	peas_engine_load_plugin (_tmp3_, _tmp4_);
	__vala_PeasPluginInfo_free0 (i);
}

/**
* Attempt to load plugin, will set the plugin-name on failure
*/
BudgieAppletInfo*
budgie_panel_plugin_manager_load_applet_instance (BudgiePanelPluginManager* self,
                                                  const gchar* uuid,
                                                  gchar** name,
                                                  GSettings* psettings)
{
	gchar* _vala_name = NULL;
	gchar* path = NULL;
	gchar* _tmp0_;
	GSettings* settings = NULL;
	gchar* pname = NULL;
	GSettings* _tmp4_;
	gchar* _tmp5_;
	PeasPluginInfo* pinfo = NULL;
	GHashTable* _tmp6_;
	const gchar* _tmp7_;
	gconstpointer _tmp8_;
	PeasPluginInfo* _tmp9_;
	PeasPluginInfo* _tmp10_;
	PeasExtension* extension = NULL;
	PeasExtensionSet* _tmp20_;
	PeasPluginInfo* _tmp21_;
	PeasExtension* _tmp22_;
	PeasExtension* _tmp23_;
	PeasExtension* _tmp24_;
	BudgieApplet* applet = NULL;
	PeasExtension* _tmp27_;
	BudgieApplet* _tmp28_;
	PeasPluginInfo* _tmp29_;
	BudgieApplet* _tmp30_;
	GSettings* _tmp31_;
	BudgieAppletInfo* _tmp32_;
	BudgieAppletInfo* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = budgie_panel_plugin_manager_create_applet_path (self, uuid);
	path = _tmp0_;
	settings = NULL;
	if (psettings == NULL) {
		const gchar* _tmp1_;
		GSettings* _tmp2_;
		_tmp1_ = path;
		_tmp2_ = g_settings_new_with_path (BUDGIE_APPLET_SCHEMA, _tmp1_);
		_g_object_unref0 (settings);
		settings = _tmp2_;
	} else {
		GSettings* _tmp3_;
		_tmp3_ = _g_object_ref0 (psettings);
		_g_object_unref0 (settings);
		settings = _tmp3_;
	}
	_tmp4_ = settings;
	_tmp5_ = g_settings_get_string (_tmp4_, BUDGIE_APPLET_KEY_NAME);
	pname = _tmp5_;
	_tmp6_ = self->priv->plugins;
	_tmp7_ = pname;
	_tmp8_ = g_hash_table_lookup (_tmp6_, _tmp7_);
	_tmp9_ = __vala_PeasPluginInfo_copy0 ((PeasPluginInfo*) _tmp8_);
	pinfo = _tmp9_;
	_tmp10_ = pinfo;
	if (_tmp10_ == NULL) {
		const gchar* _tmp11_;
		PeasPluginInfo* _tmp12_;
		PeasPluginInfo* _tmp13_;
		PeasPluginInfo* _tmp14_;
		PeasEngine* _tmp16_;
		PeasPluginInfo* _tmp17_;
		const gchar* _tmp18_;
		gchar* _tmp19_;
		_tmp11_ = pname;
		_tmp12_ = budgie_panel_plugin_manager_get_plugin_info (self, _tmp11_);
		_tmp13_ = __vala_PeasPluginInfo_copy0 (_tmp12_);
		__vala_PeasPluginInfo_free0 (pinfo);
		pinfo = _tmp13_;
		_tmp14_ = pinfo;
		if (_tmp14_ == NULL) {
			const gchar* _tmp15_;
			_tmp15_ = pname;
			g_warning ("plugin_manager.vala:168: Trying to load invalid plugin: %s %s", _tmp15_, uuid);
			_g_free0 (_vala_name);
			_vala_name = NULL;
			result = NULL;
			__vala_PeasPluginInfo_free0 (pinfo);
			_g_free0 (pname);
			_g_object_unref0 (settings);
			_g_free0 (path);
			if (name) {
				*name = _vala_name;
			} else {
				_g_free0 (_vala_name);
			}
			return result;
		}
		_tmp16_ = self->priv->engine;
		_tmp17_ = pinfo;
		peas_engine_load_plugin (_tmp16_, _tmp17_);
		_tmp18_ = pname;
		_tmp19_ = g_strdup (_tmp18_);
		_g_free0 (_vala_name);
		_vala_name = _tmp19_;
		result = NULL;
		__vala_PeasPluginInfo_free0 (pinfo);
		_g_free0 (pname);
		_g_object_unref0 (settings);
		_g_free0 (path);
		if (name) {
			*name = _vala_name;
		} else {
			_g_free0 (_vala_name);
		}
		return result;
	}
	_tmp20_ = self->priv->extensions;
	_tmp21_ = pinfo;
	_tmp22_ = peas_extension_set_get_extension (_tmp20_, _tmp21_);
	_tmp23_ = _g_object_ref0 (_tmp22_);
	extension = _tmp23_;
	_tmp24_ = extension;
	if (_tmp24_ == NULL) {
		const gchar* _tmp25_;
		gchar* _tmp26_;
		_tmp25_ = pname;
		_tmp26_ = g_strdup (_tmp25_);
		_g_free0 (_vala_name);
		_vala_name = _tmp26_;
		result = NULL;
		_g_object_unref0 (extension);
		__vala_PeasPluginInfo_free0 (pinfo);
		_g_free0 (pname);
		_g_object_unref0 (settings);
		_g_free0 (path);
		if (name) {
			*name = _vala_name;
		} else {
			_g_free0 (_vala_name);
		}
		return result;
	}
	_g_free0 (_vala_name);
	_vala_name = NULL;
	_tmp27_ = extension;
	_tmp28_ = budgie_plugin_get_panel_widget (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, budgie_plugin_get_type (), BudgiePlugin), uuid);
	applet = _tmp28_;
	_tmp29_ = pinfo;
	_tmp30_ = applet;
	_tmp31_ = settings;
	_tmp32_ = budgie_applet_info_new (_tmp29_, uuid, _tmp30_, _tmp31_);
	result = _tmp32_;
	_g_object_unref0 (applet);
	_g_object_unref0 (extension);
	__vala_PeasPluginInfo_free0 (pinfo);
	_g_free0 (pname);
	_g_object_unref0 (settings);
	_g_free0 (path);
	if (name) {
		*name = _vala_name;
	} else {
		_g_free0 (_vala_name);
	}
	return result;
}

/**
* Attempt to create a fresh applet instance
*/
BudgieAppletInfo*
budgie_panel_plugin_manager_create_new_applet (BudgiePanelPluginManager* self,
                                               const gchar* name,
                                               const gchar* uuid)
{
	GHashTable* _tmp0_;
	gchar* unused = NULL;
	gchar* path = NULL;
	gchar* _tmp1_;
	GSettings* settings = NULL;
	const gchar* _tmp2_;
	GSettings* _tmp3_;
	GSettings* _tmp4_;
	GSettings* _tmp5_;
	gchar* _tmp6_ = NULL;
	BudgieAppletInfo* _tmp7_;
	BudgieAppletInfo* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (uuid != NULL, NULL);
	_tmp0_ = self->priv->plugins;
	if (!g_hash_table_contains (_tmp0_, name)) {
		result = NULL;
		return result;
	}
	unused = NULL;
	_tmp1_ = budgie_panel_plugin_manager_create_applet_path (self, uuid);
	path = _tmp1_;
	_tmp2_ = path;
	_tmp3_ = g_settings_new_with_path (BUDGIE_APPLET_SCHEMA, _tmp2_);
	settings = _tmp3_;
	_tmp4_ = settings;
	g_settings_set_string (_tmp4_, BUDGIE_APPLET_KEY_NAME, name);
	_tmp5_ = settings;
	_tmp7_ = budgie_panel_plugin_manager_load_applet_instance (self, uuid, &_tmp6_, _tmp5_);
	_g_free0 (unused);
	unused = _tmp6_;
	result = _tmp7_;
	_g_object_unref0 (settings);
	_g_free0 (path);
	_g_free0 (unused);
	return result;
}

static void
budgie_value_panel_plugin_manager_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
budgie_value_panel_plugin_manager_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		budgie_panel_plugin_manager_unref (value->data[0].v_pointer);
	}
}

static void
budgie_value_panel_plugin_manager_copy_value (const GValue* src_value,
                                              GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = budgie_panel_plugin_manager_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
budgie_value_panel_plugin_manager_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
budgie_value_panel_plugin_manager_collect_value (GValue* value,
                                                 guint n_collect_values,
                                                 GTypeCValue* collect_values,
                                                 guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		BudgiePanelPluginManager * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = budgie_panel_plugin_manager_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
budgie_value_panel_plugin_manager_lcopy_value (const GValue* value,
                                               guint n_collect_values,
                                               GTypeCValue* collect_values,
                                               guint collect_flags)
{
	BudgiePanelPluginManager ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = budgie_panel_plugin_manager_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
budgie_param_spec_panel_plugin_manager (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags)
{
	BudgieParamSpecPanelPluginManager* spec;
	g_return_val_if_fail (g_type_is_a (object_type, BUDGIE_TYPE_PANEL_PLUGIN_MANAGER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
budgie_value_get_panel_plugin_manager (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BUDGIE_TYPE_PANEL_PLUGIN_MANAGER), NULL);
	return value->data[0].v_pointer;
}

void
budgie_value_set_panel_plugin_manager (GValue* value,
                                       gpointer v_object)
{
	BudgiePanelPluginManager * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BUDGIE_TYPE_PANEL_PLUGIN_MANAGER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BUDGIE_TYPE_PANEL_PLUGIN_MANAGER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		budgie_panel_plugin_manager_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		budgie_panel_plugin_manager_unref (old);
	}
}

void
budgie_value_take_panel_plugin_manager (GValue* value,
                                        gpointer v_object)
{
	BudgiePanelPluginManager * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BUDGIE_TYPE_PANEL_PLUGIN_MANAGER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BUDGIE_TYPE_PANEL_PLUGIN_MANAGER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		budgie_panel_plugin_manager_unref (old);
	}
}

static void
budgie_panel_plugin_manager_class_init (BudgiePanelPluginManagerClass * klass,
                                        gpointer klass_data)
{
	budgie_panel_plugin_manager_parent_class = g_type_class_peek_parent (klass);
	((BudgiePanelPluginManagerClass *) klass)->finalize = budgie_panel_plugin_manager_finalize;
	g_type_class_adjust_private_offset (klass, &BudgiePanelPluginManager_private_offset);
	/**
	* Indicate that a plugin that was being waited for, is now available
	*/
	budgie_panel_plugin_manager_signals[BUDGIE_PANEL_PLUGIN_MANAGER_EXTENSION_LOADED_SIGNAL] = g_signal_new ("extension-loaded", BUDGIE_TYPE_PANEL_PLUGIN_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
}

static void
budgie_panel_plugin_manager_instance_init (BudgiePanelPluginManager * self,
                                           gpointer klass)
{
	self->priv = budgie_panel_plugin_manager_get_instance_private (self);
	self->migrate_load_requirements_met = FALSE;
	self->ref_count = 1;
}

static void
budgie_panel_plugin_manager_finalize (BudgiePanelPluginManager * obj)
{
	BudgiePanelPluginManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_PANEL_PLUGIN_MANAGER, BudgiePanelPluginManager);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->engine);
	_g_object_unref0 (self->priv->extensions);
	_g_hash_table_unref0 (self->priv->plugins);
}

static GType
budgie_panel_plugin_manager_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { budgie_value_panel_plugin_manager_init, budgie_value_panel_plugin_manager_free_value, budgie_value_panel_plugin_manager_copy_value, budgie_value_panel_plugin_manager_peek_pointer, "p", budgie_value_panel_plugin_manager_collect_value, "p", budgie_value_panel_plugin_manager_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (BudgiePanelPluginManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_panel_plugin_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgiePanelPluginManager), 0, (GInstanceInitFunc) budgie_panel_plugin_manager_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType budgie_panel_plugin_manager_type_id;
	budgie_panel_plugin_manager_type_id = g_type_register_fundamental (g_type_fundamental_next (), "BudgiePanelPluginManager", &g_define_type_info, &g_define_type_fundamental_info, 0);
	BudgiePanelPluginManager_private_offset = g_type_add_instance_private (budgie_panel_plugin_manager_type_id, sizeof (BudgiePanelPluginManagerPrivate));
	return budgie_panel_plugin_manager_type_id;
}

GType
budgie_panel_plugin_manager_get_type (void)
{
	static volatile gsize budgie_panel_plugin_manager_type_id__once = 0;
	if (g_once_init_enter (&budgie_panel_plugin_manager_type_id__once)) {
		GType budgie_panel_plugin_manager_type_id;
		budgie_panel_plugin_manager_type_id = budgie_panel_plugin_manager_get_type_once ();
		g_once_init_leave (&budgie_panel_plugin_manager_type_id__once, budgie_panel_plugin_manager_type_id);
	}
	return budgie_panel_plugin_manager_type_id__once;
}

gpointer
budgie_panel_plugin_manager_ref (gpointer instance)
{
	BudgiePanelPluginManager * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
budgie_panel_plugin_manager_unref (gpointer instance)
{
	BudgiePanelPluginManager * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		BUDGIE_PANEL_PLUGIN_MANAGER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

