#include "vtkABI.h"
#include "vtkClientServerInterpreter.h"

extern "C" { void vtkAdaptiveSubdivisionFilter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkBandedPolyDataContourFilter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkButterflySubdivisionFilter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkCollisionDetectionFilter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkContourLoopExtraction_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkCookieCutter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkDijkstraGraphGeodesicPath_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkDijkstraImageGeodesicPath_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkFillHolesFilter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkFitToHeightMapFilter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkGeodesicPath_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkGraphGeodesicPath_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkHausdorffDistancePointSetFilter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkHyperTreeGridOutlineFilter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkImageDataOutlineFilter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkImprintFilter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkLinearCellExtrusionFilter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkLinearExtrusionFilter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkLinearSubdivisionFilter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkLoopSubdivisionFilter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkOutlineFilter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkPolyDataPointSampler_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkProjectedTexture_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkQuadRotationalExtrusionFilter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkRibbonFilter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkRotationalExtrusionFilter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkRuledSurfaceFilter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkSectorSource_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkSelectEnclosedPoints_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkSelectPolyData_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkSpherePuzzle_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkSpherePuzzleArrows_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkSubdivideTetra_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkTrimmedExtrusionFilter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkVolumeOfRevolutionFilter_Init(vtkClientServerInterpreter*); }

extern "C" VTK_ABI_EXPORT void vtkFiltersModelingCS_Initialize(vtkClientServerInterpreter* csi)
{
  (void)csi;
  vtkAdaptiveSubdivisionFilter_Init(csi);
  vtkBandedPolyDataContourFilter_Init(csi);
  vtkButterflySubdivisionFilter_Init(csi);
  vtkCollisionDetectionFilter_Init(csi);
  vtkContourLoopExtraction_Init(csi);
  vtkCookieCutter_Init(csi);
  vtkDijkstraGraphGeodesicPath_Init(csi);
  vtkDijkstraImageGeodesicPath_Init(csi);
  vtkFillHolesFilter_Init(csi);
  vtkFitToHeightMapFilter_Init(csi);
  vtkGeodesicPath_Init(csi);
  vtkGraphGeodesicPath_Init(csi);
  vtkHausdorffDistancePointSetFilter_Init(csi);
  vtkHyperTreeGridOutlineFilter_Init(csi);
  vtkImageDataOutlineFilter_Init(csi);
  vtkImprintFilter_Init(csi);
  vtkLinearCellExtrusionFilter_Init(csi);
  vtkLinearExtrusionFilter_Init(csi);
  vtkLinearSubdivisionFilter_Init(csi);
  vtkLoopSubdivisionFilter_Init(csi);
  vtkOutlineFilter_Init(csi);
  vtkPolyDataPointSampler_Init(csi);
  vtkProjectedTexture_Init(csi);
  vtkQuadRotationalExtrusionFilter_Init(csi);
  vtkRibbonFilter_Init(csi);
  vtkRotationalExtrusionFilter_Init(csi);
  vtkRuledSurfaceFilter_Init(csi);
  vtkSectorSource_Init(csi);
  vtkSelectEnclosedPoints_Init(csi);
  vtkSelectPolyData_Init(csi);
  vtkSpherePuzzle_Init(csi);
  vtkSpherePuzzleArrows_Init(csi);
  vtkSubdivideTetra_Init(csi);
  vtkTrimmedExtrusionFilter_Init(csi);
  vtkVolumeOfRevolutionFilter_Init(csi);
}
