// components/schema_org/common/metadata.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SCHEMA_ORG_COMMON_METADATA_MOJOM_SHARED_H_
#define COMPONENTS_SCHEMA_ORG_COMMON_METADATA_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "components/schema_org/common/metadata.mojom-shared-internal.h"







namespace schema_org {
namespace mojom {
class PropertyDataView;

class EntityDataView;

class ValuesDataView;


}  // namespace mojom
}  // namespace schema_org

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::schema_org::mojom::PropertyDataView> {
  using Data = ::schema_org::mojom::internal::Property_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::schema_org::mojom::EntityDataView> {
  using Data = ::schema_org::mojom::internal::Entity_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::schema_org::mojom::ValuesDataView> {
  using Data = ::schema_org::mojom::internal::Values_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace schema_org {
namespace mojom {


class PropertyDataView {
 public:
  PropertyDataView() {}

  PropertyDataView(
      internal::Property_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  inline void GetValuesDataView(
      ValuesDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadValues(UserType* output) {
    
    auto* pointer = !data_->values.is_null() ? &data_->values : nullptr;
    return mojo::internal::Deserialize<::schema_org::mojom::ValuesDataView>(
        pointer, output, context_);
  }
 private:
  internal::Property_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class EntityDataView {
 public:
  EntityDataView() {}

  EntityDataView(
      internal::Entity_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetTypeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadType(UserType* output) {
    
    auto* pointer = data_->type.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  inline void GetPropertiesDataView(
      mojo::ArrayDataView<PropertyDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadProperties(UserType* output) {
    
    auto* pointer = data_->properties.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::schema_org::mojom::PropertyDataView>>(
        pointer, output, context_);
  }
 private:
  internal::Entity_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class ValuesDataView {
 public:
  using Tag = internal::Values_Data::Values_Tag;

  ValuesDataView() {}

  ValuesDataView(
      internal::Values_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_bool_values() const { return data_->tag == Tag::BOOL_VALUES; }
  inline void GetBoolValuesDataView(
      mojo::ArrayDataView<bool>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadBoolValues(UserType* output) {
    
    DCHECK(is_bool_values());
    return mojo::internal::Deserialize<mojo::ArrayDataView<bool>>(
        data_->data.f_bool_values.Get(), output, context_);
  }
  bool is_long_values() const { return data_->tag == Tag::LONG_VALUES; }
  inline void GetLongValuesDataView(
      mojo::ArrayDataView<int64_t>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadLongValues(UserType* output) {
    
    DCHECK(is_long_values());
    return mojo::internal::Deserialize<mojo::ArrayDataView<int64_t>>(
        data_->data.f_long_values.Get(), output, context_);
  }
  bool is_string_values() const { return data_->tag == Tag::STRING_VALUES; }
  inline void GetStringValuesDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadStringValues(UserType* output) {
    
    DCHECK(is_string_values());
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        data_->data.f_string_values.Get(), output, context_);
  }
  bool is_entity_values() const { return data_->tag == Tag::ENTITY_VALUES; }
  inline void GetEntityValuesDataView(
      mojo::ArrayDataView<EntityDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadEntityValues(UserType* output) {
    
    DCHECK(is_entity_values());
    return mojo::internal::Deserialize<mojo::ArrayDataView<::schema_org::mojom::EntityDataView>>(
        data_->data.f_entity_values.Get(), output, context_);
  }

 private:
  internal::Values_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace schema_org

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::schema_org::mojom::PropertyDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::schema_org::mojom::PropertyDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::schema_org::mojom::internal::Property_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::name(input)) in_name = Traits::name(input);
    typename decltype((*output)->name)::BaseType::BufferWriter
        name_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_name, buffer, &name_writer, context);
    (*output)->name.Set(
        name_writer.is_null() ? nullptr : name_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->name.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null name in Property struct");
    decltype(Traits::values(input)) in_values = Traits::values(input);
    typename decltype((*output)->values)::BufferWriter values_writer;
    values_writer.AllocateInline(buffer, &(*output)->values);
    mojo::internal::Serialize<::schema_org::mojom::ValuesDataView>(
        in_values, buffer, &values_writer, true, context);
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->values.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null values in Property struct");
  }

  static bool Deserialize(::schema_org::mojom::internal::Property_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::schema_org::mojom::PropertyDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::schema_org::mojom::EntityDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::schema_org::mojom::EntityDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::schema_org::mojom::internal::Entity_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::type(input)) in_type = Traits::type(input);
    typename decltype((*output)->type)::BaseType::BufferWriter
        type_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_type, buffer, &type_writer, context);
    (*output)->type.Set(
        type_writer.is_null() ? nullptr : type_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->type.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null type in Entity struct");
    decltype(Traits::properties(input)) in_properties = Traits::properties(input);
    typename decltype((*output)->properties)::BaseType::BufferWriter
        properties_writer;
    const mojo::internal::ContainerValidateParams properties_validate_params(
        0, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<::schema_org::mojom::PropertyDataView>>(
        in_properties, buffer, &properties_writer, &properties_validate_params,
        context);
    (*output)->properties.Set(
        properties_writer.is_null() ? nullptr : properties_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->properties.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null properties in Entity struct");
  }

  static bool Deserialize(::schema_org::mojom::internal::Entity_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::schema_org::mojom::EntityDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::schema_org::mojom::ValuesDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::schema_org::mojom::ValuesDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::schema_org::mojom::internal::Values_Data::BufferWriter* writer,
                        bool inlined,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
         writer->data()->set_null();
      return;
    }
    if (!inlined)
      writer->Allocate(buffer);

    ::schema_org::mojom::internal::Values_Data::BufferWriter& result = *writer;
    ALLOW_UNUSED_LOCAL(result);
    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
    result->size = kUnionDataSize;
    result->tag = Traits::GetTag(input);
    switch (result->tag) {
      case ::schema_org::mojom::ValuesDataView::Tag::BOOL_VALUES: {
        decltype(Traits::bool_values(input))
            in_bool_values = Traits::bool_values(input);
        typename decltype(result->data.f_bool_values)::BaseType::BufferWriter
            value_writer;
        const ContainerValidateParams bool_values_validate_params(
            0, false, nullptr);
        mojo::internal::Serialize<mojo::ArrayDataView<bool>>(
            in_bool_values, buffer, &value_writer, &bool_values_validate_params,
            context);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_writer.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null bool_values in Values union");
        result->data.f_bool_values.Set(
            value_writer.is_null() ? nullptr : value_writer.data());
        break;
      }
      case ::schema_org::mojom::ValuesDataView::Tag::LONG_VALUES: {
        decltype(Traits::long_values(input))
            in_long_values = Traits::long_values(input);
        typename decltype(result->data.f_long_values)::BaseType::BufferWriter
            value_writer;
        const ContainerValidateParams long_values_validate_params(
            0, false, nullptr);
        mojo::internal::Serialize<mojo::ArrayDataView<int64_t>>(
            in_long_values, buffer, &value_writer, &long_values_validate_params,
            context);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_writer.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null long_values in Values union");
        result->data.f_long_values.Set(
            value_writer.is_null() ? nullptr : value_writer.data());
        break;
      }
      case ::schema_org::mojom::ValuesDataView::Tag::STRING_VALUES: {
        decltype(Traits::string_values(input))
            in_string_values = Traits::string_values(input);
        typename decltype(result->data.f_string_values)::BaseType::BufferWriter
            value_writer;
        const ContainerValidateParams string_values_validate_params(
            0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
        mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
            in_string_values, buffer, &value_writer, &string_values_validate_params,
            context);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_writer.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null string_values in Values union");
        result->data.f_string_values.Set(
            value_writer.is_null() ? nullptr : value_writer.data());
        break;
      }
      case ::schema_org::mojom::ValuesDataView::Tag::ENTITY_VALUES: {
        decltype(Traits::entity_values(input))
            in_entity_values = Traits::entity_values(input);
        typename decltype(result->data.f_entity_values)::BaseType::BufferWriter
            value_writer;
        const ContainerValidateParams entity_values_validate_params(
            0, false, nullptr);
        mojo::internal::Serialize<mojo::ArrayDataView<::schema_org::mojom::EntityDataView>>(
            in_entity_values, buffer, &value_writer, &entity_values_validate_params,
            context);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_writer.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null entity_values in Values union");
        result->data.f_entity_values.Set(
            value_writer.is_null() ? nullptr : value_writer.data());
        break;
      }
    }
  }

  static bool Deserialize(::schema_org::mojom::internal::Values_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::schema_org::mojom::ValuesDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace schema_org {
namespace mojom {

inline void PropertyDataView::GetNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->name.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void PropertyDataView::GetValuesDataView(
    ValuesDataView* output) {
  auto pointer = &data_->values;
  *output = ValuesDataView(pointer, context_);
}


inline void EntityDataView::GetTypeDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->type.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void EntityDataView::GetPropertiesDataView(
    mojo::ArrayDataView<PropertyDataView>* output) {
  auto pointer = data_->properties.Get();
  *output = mojo::ArrayDataView<PropertyDataView>(pointer, context_);
}


inline void ValuesDataView::GetBoolValuesDataView(
    mojo::ArrayDataView<bool>* output) {
  DCHECK(is_bool_values());
  *output = mojo::ArrayDataView<bool>(data_->data.f_bool_values.Get(), context_);
}
inline void ValuesDataView::GetLongValuesDataView(
    mojo::ArrayDataView<int64_t>* output) {
  DCHECK(is_long_values());
  *output = mojo::ArrayDataView<int64_t>(data_->data.f_long_values.Get(), context_);
}
inline void ValuesDataView::GetStringValuesDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  DCHECK(is_string_values());
  *output = mojo::ArrayDataView<mojo::StringDataView>(data_->data.f_string_values.Get(), context_);
}
inline void ValuesDataView::GetEntityValuesDataView(
    mojo::ArrayDataView<EntityDataView>* output) {
  DCHECK(is_entity_values());
  *output = mojo::ArrayDataView<EntityDataView>(data_->data.f_entity_values.Get(), context_);
}


}  // namespace mojom
}  // namespace schema_org

#endif  // COMPONENTS_SCHEMA_ORG_COMMON_METADATA_MOJOM_SHARED_H_