// content/common/frame_sink_provider.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_COMMON_FRAME_SINK_PROVIDER_MOJOM_H_
#define CONTENT_COMMON_FRAME_SINK_PROVIDER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "content/common/frame_sink_provider.mojom-shared.h"
#include "content/common/frame_sink_provider.mojom-forward.h"
#include "cc/mojom/render_frame_metadata.mojom.h"
#include "services/viz/public/mojom/compositing/compositor_frame_sink.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"


#include "content/common/content_export.h"



// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace content {
namespace mojom {

class FrameSinkProviderProxy;

template <typename ImplRefTraits>
class FrameSinkProviderStub;

class FrameSinkProviderRequestValidator;


class CONTENT_EXPORT FrameSinkProvider
    : public FrameSinkProviderInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = FrameSinkProviderInterfaceBase;
  using Proxy_ = FrameSinkProviderProxy;

  template <typename ImplRefTraits>
  using Stub_ = FrameSinkProviderStub<ImplRefTraits>;

  using RequestValidator_ = FrameSinkProviderRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kCreateForWidgetMinVersion = 0,
    kRegisterRenderFrameMetadataObserverMinVersion = 0,
  };
  virtual ~FrameSinkProvider() {}

  
  virtual void CreateForWidget(int32_t widget_id, ::mojo::PendingReceiver<::viz::mojom::CompositorFrameSink> compositor_frame_sink_receiver, ::mojo::PendingRemote<::viz::mojom::CompositorFrameSinkClient> compositor_frame_sink_client) = 0;

  
  virtual void RegisterRenderFrameMetadataObserver(int32_t widget_id, ::mojo::PendingReceiver<::cc::mojom::RenderFrameMetadataObserverClient> render_frame_metadata_observer_client_receiver, ::mojo::PendingRemote<::cc::mojom::RenderFrameMetadataObserver> render_frame_metadata_observer) = 0;
};



class CONTENT_EXPORT FrameSinkProviderProxy
    : public FrameSinkProvider {
 public:
  using InterfaceType = FrameSinkProvider;

  explicit FrameSinkProviderProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreateForWidget(int32_t widget_id, ::mojo::PendingReceiver<::viz::mojom::CompositorFrameSink> compositor_frame_sink_receiver, ::mojo::PendingRemote<::viz::mojom::CompositorFrameSinkClient> compositor_frame_sink_client) final;
  
  void RegisterRenderFrameMetadataObserver(int32_t widget_id, ::mojo::PendingReceiver<::cc::mojom::RenderFrameMetadataObserverClient> render_frame_metadata_observer_client_receiver, ::mojo::PendingRemote<::cc::mojom::RenderFrameMetadataObserver> render_frame_metadata_observer) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class CONTENT_EXPORT FrameSinkProviderStubDispatch {
 public:
  static bool Accept(FrameSinkProvider* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      FrameSinkProvider* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<FrameSinkProvider>>
class FrameSinkProviderStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  FrameSinkProviderStub() {}
  ~FrameSinkProviderStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FrameSinkProviderStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FrameSinkProviderStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class CONTENT_EXPORT FrameSinkProviderRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // namespace mojom
}  // namespace content

namespace mojo {

}  // namespace mojo

#endif  // CONTENT_COMMON_FRAME_SINK_PROVIDER_MOJOM_H_