// services/network/public/mojom/restricted_cookie_manager.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_RESTRICTED_COOKIE_MANAGER_MOJOM_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_RESTRICTED_COOKIE_MANAGER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "services/network/public/mojom/restricted_cookie_manager.mojom-shared.h"
#include "services/network/public/mojom/restricted_cookie_manager.mojom-forward.h"
#include "services/network/public/mojom/cookie_manager.mojom.h"
#include "services/network/public/mojom/site_for_cookies.mojom.h"
#include "mojo/public/mojom/base/time.mojom-forward.h"
#include "url/mojom/url.mojom.h"
#include "url/mojom/origin.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"





// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace network {
namespace mojom {

class RestrictedCookieManagerProxy;

template <typename ImplRefTraits>
class RestrictedCookieManagerStub;

class RestrictedCookieManagerRequestValidator;
class RestrictedCookieManagerResponseValidator;


class  RestrictedCookieManager
    : public RestrictedCookieManagerInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = true;

  using Base_ = RestrictedCookieManagerInterfaceBase;
  using Proxy_ = RestrictedCookieManagerProxy;

  template <typename ImplRefTraits>
  using Stub_ = RestrictedCookieManagerStub<ImplRefTraits>;

  using RequestValidator_ = RestrictedCookieManagerRequestValidator;
  using ResponseValidator_ = RestrictedCookieManagerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetAllForUrlMinVersion = 0,
    kSetCanonicalCookieMinVersion = 0,
    kAddChangeListenerMinVersion = 0,
    kSetCookieFromStringMinVersion = 0,
    kGetCookiesStringMinVersion = 0,
    kCookiesEnabledForMinVersion = 0,
  };
  virtual ~RestrictedCookieManager() {}


  using GetAllForUrlCallback = base::OnceCallback<void(const std::vector<::net::CookieWithAccessResult>&)>;
  
  virtual void GetAllForUrl(const ::GURL& url, const ::net::SiteForCookies& site_for_cookies, const ::url::Origin& top_frame_origin, CookieManagerGetOptionsPtr options, GetAllForUrlCallback callback) = 0;


  using SetCanonicalCookieCallback = base::OnceCallback<void(bool)>;
  
  virtual void SetCanonicalCookie(const ::net::CanonicalCookie& cookie, const ::GURL& url, const ::net::SiteForCookies& site_for_cookies, const ::url::Origin& top_frame_origin, SetCanonicalCookieCallback callback) = 0;


  using AddChangeListenerCallback = base::OnceCallback<void()>;
  
  virtual void AddChangeListener(const ::GURL& url, const ::net::SiteForCookies& site_for_cookies, const ::url::Origin& top_frame_origin, ::mojo::PendingRemote<::network::mojom::CookieChangeListener> listener, AddChangeListenerCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool SetCookieFromString(const ::GURL& url, const ::net::SiteForCookies& site_for_cookies, const ::url::Origin& top_frame_origin, const std::string& cookie);

  using SetCookieFromStringCallback = base::OnceCallback<void()>;
  
  virtual void SetCookieFromString(const ::GURL& url, const ::net::SiteForCookies& site_for_cookies, const ::url::Origin& top_frame_origin, const std::string& cookie, SetCookieFromStringCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool GetCookiesString(const ::GURL& url, const ::net::SiteForCookies& site_for_cookies, const ::url::Origin& top_frame_origin, std::string* out_cookies);

  using GetCookiesStringCallback = base::OnceCallback<void(const std::string&)>;
  
  virtual void GetCookiesString(const ::GURL& url, const ::net::SiteForCookies& site_for_cookies, const ::url::Origin& top_frame_origin, GetCookiesStringCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool CookiesEnabledFor(const ::GURL& url, const ::net::SiteForCookies& site_for_cookies, const ::url::Origin& top_frame_origin, bool* out_cookies_enabled);

  using CookiesEnabledForCallback = base::OnceCallback<void(bool)>;
  
  virtual void CookiesEnabledFor(const ::GURL& url, const ::net::SiteForCookies& site_for_cookies, const ::url::Origin& top_frame_origin, CookiesEnabledForCallback callback) = 0;
};



class  RestrictedCookieManagerProxy
    : public RestrictedCookieManager {
 public:
  using InterfaceType = RestrictedCookieManager;

  explicit RestrictedCookieManagerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetAllForUrl(const ::GURL& url, const ::net::SiteForCookies& site_for_cookies, const ::url::Origin& top_frame_origin, CookieManagerGetOptionsPtr options, GetAllForUrlCallback callback) final;
  
  void SetCanonicalCookie(const ::net::CanonicalCookie& cookie, const ::GURL& url, const ::net::SiteForCookies& site_for_cookies, const ::url::Origin& top_frame_origin, SetCanonicalCookieCallback callback) final;
  
  void AddChangeListener(const ::GURL& url, const ::net::SiteForCookies& site_for_cookies, const ::url::Origin& top_frame_origin, ::mojo::PendingRemote<::network::mojom::CookieChangeListener> listener, AddChangeListenerCallback callback) final;
  
  bool SetCookieFromString(const ::GURL& url, const ::net::SiteForCookies& site_for_cookies, const ::url::Origin& top_frame_origin, const std::string& cookie) final;
  
  void SetCookieFromString(const ::GURL& url, const ::net::SiteForCookies& site_for_cookies, const ::url::Origin& top_frame_origin, const std::string& cookie, SetCookieFromStringCallback callback) final;
  
  bool GetCookiesString(const ::GURL& url, const ::net::SiteForCookies& site_for_cookies, const ::url::Origin& top_frame_origin, std::string* out_cookies) final;
  
  void GetCookiesString(const ::GURL& url, const ::net::SiteForCookies& site_for_cookies, const ::url::Origin& top_frame_origin, GetCookiesStringCallback callback) final;
  
  bool CookiesEnabledFor(const ::GURL& url, const ::net::SiteForCookies& site_for_cookies, const ::url::Origin& top_frame_origin, bool* out_cookies_enabled) final;
  
  void CookiesEnabledFor(const ::GURL& url, const ::net::SiteForCookies& site_for_cookies, const ::url::Origin& top_frame_origin, CookiesEnabledForCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  RestrictedCookieManagerStubDispatch {
 public:
  static bool Accept(RestrictedCookieManager* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      RestrictedCookieManager* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<RestrictedCookieManager>>
class RestrictedCookieManagerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  RestrictedCookieManagerStub() {}
  ~RestrictedCookieManagerStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return RestrictedCookieManagerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return RestrictedCookieManagerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  RestrictedCookieManagerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  RestrictedCookieManagerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class  CookieManagerGetOptions {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CookieManagerGetOptions, T>::value>;
  using DataView = CookieManagerGetOptionsDataView;
  using Data_ = internal::CookieManagerGetOptions_Data;

  template <typename... Args>
  static CookieManagerGetOptionsPtr New(Args&&... args) {
    return CookieManagerGetOptionsPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CookieManagerGetOptionsPtr From(const U& u) {
    return mojo::TypeConverter<CookieManagerGetOptionsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CookieManagerGetOptions>::Convert(*this);
  }


  CookieManagerGetOptions();

  CookieManagerGetOptions(
      const std::string& name,
      CookieMatchType match_type);

  ~CookieManagerGetOptions();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CookieManagerGetOptionsPtr>
  CookieManagerGetOptionsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CookieManagerGetOptions::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;
  size_t Hash(size_t seed) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CookieManagerGetOptions::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CookieManagerGetOptions::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CookieManagerGetOptions_UnserializedMessageContext<
            UserType, CookieManagerGetOptions::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<CookieManagerGetOptions::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return CookieManagerGetOptions::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CookieManagerGetOptions_UnserializedMessageContext<
            UserType, CookieManagerGetOptions::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CookieManagerGetOptions::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  std::string name;
  
  CookieMatchType match_type;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CookieManagerGetOptions::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CookieManagerGetOptions::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CookieManagerGetOptions::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CookieManagerGetOptions::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}




template <typename StructPtrType>
CookieManagerGetOptionsPtr CookieManagerGetOptions::Clone() const {
  return New(
      mojo::Clone(name),
      mojo::Clone(match_type)
  );
}

template <typename T, CookieManagerGetOptions::EnableIfSame<T>*>
bool CookieManagerGetOptions::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->match_type, other_struct.match_type))
    return false;
  return true;
}

template <typename T, CookieManagerGetOptions::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.name, rhs.name))
    return true;
  if (std::less<>{}(rhs.name, lhs.name))
    return false;
  if (std::less<>{}(lhs.match_type, rhs.match_type))
    return true;
  if (std::less<>{}(rhs.match_type, lhs.match_type))
    return false;
  return false;
}


}  // namespace mojom
}  // namespace network

namespace mojo {


template <>
struct  StructTraits<::network::mojom::CookieManagerGetOptions::DataView,
                                         ::network::mojom::CookieManagerGetOptionsPtr> {
  static bool IsNull(const ::network::mojom::CookieManagerGetOptionsPtr& input) { return !input; }
  static void SetToNull(::network::mojom::CookieManagerGetOptionsPtr* output) { output->reset(); }

  static const decltype(::network::mojom::CookieManagerGetOptions::name)& name(
      const ::network::mojom::CookieManagerGetOptionsPtr& input) {
    return input->name;
  }

  static decltype(::network::mojom::CookieManagerGetOptions::match_type) match_type(
      const ::network::mojom::CookieManagerGetOptionsPtr& input) {
    return input->match_type;
  }

  static bool Read(::network::mojom::CookieManagerGetOptions::DataView input, ::network::mojom::CookieManagerGetOptionsPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_RESTRICTED_COOKIE_MANAGER_MOJOM_H_