// services/network/public/mojom/url_response_head.mojom-shared-internal.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_URL_RESPONSE_HEAD_MOJOM_SHARED_INTERNAL_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_URL_RESPONSE_HEAD_MOJOM_SHARED_INTERNAL_H_

#include "mojo/public/cpp/bindings/lib/array_internal.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/map_data_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"
#include "mojo/public/mojom/base/time.mojom-shared-internal.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared-internal.h"
#include "services/network/public/mojom/fetch_api.mojom-shared-internal.h"
#include "services/network/public/mojom/http_raw_request_response_info.mojom-shared-internal.h"
#include "services/network/public/mojom/ip_endpoint.mojom-shared-internal.h"
#include "services/network/public/mojom/load_timing_info.mojom-shared-internal.h"
#include "services/network/public/mojom/network_param.mojom-shared-internal.h"
#include "services/network/public/mojom/network_types.mojom-shared-internal.h"
#include "services/network/public/mojom/origin_policy_manager.mojom-shared-internal.h"
#include "services/network/public/mojom/parsed_headers.mojom-shared-internal.h"
#include "services/proxy_resolver/public/mojom/proxy_resolver.mojom-shared-internal.h"
#include "url/mojom/url.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/native_enum_data.h"
#include "mojo/public/interfaces/bindings/native_struct.mojom-shared-internal.h"



namespace mojo {
namespace internal {
class ValidationContext;
}
}
namespace network {
namespace mojom {
namespace internal {
class URLResponseHead_Data;

#pragma pack(push, 1)
class  URLResponseHead_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(URLResponseHead_Data));
      new (data()) URLResponseHead_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    URLResponseHead_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<URLResponseHead_Data>(index_);
    }
    URLResponseHead_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::Time_Data> request_time;
  mojo::internal::Pointer<::mojo_base::mojom::internal::Time_Data> response_time;
  mojo::internal::Pointer<::network::mojom::internal::HttpResponseHeaders_Data> headers;
  mojo::internal::Pointer<mojo::internal::String_Data> mime_type;
  mojo::internal::Pointer<mojo::internal::String_Data> charset;
  int32_t ct_policy_compliance;
  uint8_t network_accessed : 1;
  uint8_t was_fetched_via_spdy : 1;
  uint8_t was_alpn_negotiated : 1;
  uint8_t was_alternate_protocol_available : 1;
  uint8_t was_fetched_via_cache : 1;
  uint8_t was_fetched_via_service_worker : 1;
  uint8_t was_fallback_required_by_service_worker : 1;
  uint8_t did_service_worker_navigation_preload : 1;
  uint8_t should_report_corb_blocking : 1;
  uint8_t async_revalidation_requested : 1;
  uint8_t did_mime_sniff : 1;
  uint8_t is_signed_exchange_inner_response : 1;
  uint8_t was_in_prefetch_cache : 1;
  uint8_t was_cookie_in_request : 1;
  uint8_t intercepted_by_plugin : 1;
  uint8_t is_legacy_tls_version : 1;
  uint8_t has_range_requested : 1;
  uint8_t timing_allow_passed : 1;
  uint8_t pad23_[1];
  int64_t content_length;
  int64_t encoded_data_length;
  int64_t encoded_body_length;
  int64_t appcache_id;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> appcache_manifest_url;
  mojo::internal::Pointer<::network::mojom::internal::LoadTimingInfo_Data> load_timing;
  mojo::internal::Pointer<::network::mojom::internal::HttpRawRequestResponseInfo_Data> raw_request_response_info;
  int32_t connection_info;
  int32_t service_worker_response_source;
  mojo::internal::Pointer<mojo::internal::String_Data> alpn_negotiated_protocol;
  mojo::internal::Pointer<::network::mojom::internal::IPEndPoint_Data> remote_endpoint;
  mojo::internal::Pointer<::proxy_resolver::mojom::internal::ProxyServer_Data> proxy_server;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<::url::mojom::internal::Url_Data>>> url_list_via_service_worker;
  int32_t response_type;
  uint32_t cert_status;
  int64_t padding;
  mojo::internal::Pointer<mojo::internal::String_Data> cache_storage_cache_name;
  mojo::internal::Pointer<::network::mojom::internal::SSLInfo_Data> ssl_info;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<mojo::internal::String_Data>>> cors_exposed_header_names;
  mojo::internal::Pointer<::network::mojom::internal::AuthChallengeInfo_Data> auth_challenge_info;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeTicks_Data> request_start;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeTicks_Data> response_start;
  mojo::internal::Pointer<::network::mojom::internal::ParsedHeaders_Data> parsed_headers;
  mojo::internal::Pointer<::network::mojom::internal::OriginPolicy_Data> origin_policy;
  mojo::internal::Pointer<::mojo_base::mojom::internal::UnguessableToken_Data> recursive_prefetch_token;

 private:
  URLResponseHead_Data();
  ~URLResponseHead_Data() = delete;
};
static_assert(sizeof(URLResponseHead_Data) == 240,
              "Bad sizeof(URLResponseHead_Data)");
// Used by URLResponseHead::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct URLResponseHead_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  URLResponseHead_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~URLResponseHead_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    URLResponseHead_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    URLResponseHead_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};

#pragma pack(pop)

}  // namespace internal
}  // namespace mojom
}  // namespace network

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_URL_RESPONSE_HEAD_MOJOM_SHARED_INTERNAL_H_