// services/viz/public/mojom/compositing/compositing_mode_watcher.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/viz/public/mojom/compositing/compositing_mode_watcher.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "services/viz/public/mojom/compositing/compositing_mode_watcher.mojom-params-data.h"
#include "services/viz/public/mojom/compositing/compositing_mode_watcher.mojom-shared-message-ids.h"

#include "services/viz/public/mojom/compositing/compositing_mode_watcher.mojom-import-headers.h"


#ifndef SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_COMPOSITING_MODE_WATCHER_MOJOM_JUMBO_H_
#define SERVICES_VIZ_PUBLIC_MOJOM_COMPOSITING_COMPOSITING_MODE_WATCHER_MOJOM_JUMBO_H_
#endif
namespace viz {
namespace mojom {
const char CompositingModeWatcher::Name_[] = "viz.mojom.CompositingModeWatcher";

CompositingModeWatcherProxy::CompositingModeWatcherProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void CompositingModeWatcherProxy::CompositingModeFallbackToSoftware(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "viz::mojom::CompositingModeWatcher::CompositingModeFallbackToSoftware");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCompositingModeWatcher_CompositingModeFallbackToSoftware_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::viz::mojom::internal::CompositingModeWatcher_CompositingModeFallbackToSoftware_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CompositingModeWatcher::Name_);
  message.set_method_name("CompositingModeFallbackToSoftware");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool CompositingModeWatcherStubDispatch::Accept(
    CompositingModeWatcher* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kCompositingModeWatcher_CompositingModeFallbackToSoftware_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::CompositingModeWatcher::CompositingModeFallbackToSoftware",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::CompositingModeWatcher::CompositingModeFallbackToSoftware");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::CompositingModeWatcher_CompositingModeFallbackToSoftware_Params_Data* params =
          reinterpret_cast<internal::CompositingModeWatcher_CompositingModeFallbackToSoftware_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      CompositingModeWatcher_CompositingModeFallbackToSoftware_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CompositingModeWatcher::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CompositingModeFallbackToSoftware();
      return true;
    }
  }
  return false;
}

// static
bool CompositingModeWatcherStubDispatch::AcceptWithResponder(
    CompositingModeWatcher* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kCompositingModeWatcher_CompositingModeFallbackToSoftware_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kCompositingModeWatcherValidationInfo[] = {
    {internal::kCompositingModeWatcher_CompositingModeFallbackToSoftware_Name,
     {&internal::CompositingModeWatcher_CompositingModeFallbackToSoftware_Params_Data::Validate,
      nullptr /* no response */}},
};

bool CompositingModeWatcherRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::viz::mojom::CompositingModeWatcher::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kCompositingModeWatcherValidationInfo);
}

const char CompositingModeReporter::Name_[] = "viz.mojom.CompositingModeReporter";

CompositingModeReporterProxy::CompositingModeReporterProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void CompositingModeReporterProxy::AddCompositingModeWatcher(
    ::mojo::PendingRemote<CompositingModeWatcher> in_watcher) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "viz::mojom::CompositingModeReporter::AddCompositingModeWatcher", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("watcher", in_watcher.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCompositingModeReporter_AddCompositingModeWatcher_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::viz::mojom::internal::CompositingModeReporter_AddCompositingModeWatcher_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::viz::mojom::CompositingModeWatcherInterfaceBase>>(
      in_watcher, &params->watcher, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->watcher),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid watcher in CompositingModeReporter.AddCompositingModeWatcher request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CompositingModeReporter::Name_);
  message.set_method_name("AddCompositingModeWatcher");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool CompositingModeReporterStubDispatch::Accept(
    CompositingModeReporter* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kCompositingModeReporter_AddCompositingModeWatcher_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)viz::mojom::CompositingModeReporter::AddCompositingModeWatcher",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)viz::mojom::CompositingModeReporter::AddCompositingModeWatcher");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::CompositingModeReporter_AddCompositingModeWatcher_Params_Data* params =
          reinterpret_cast<internal::CompositingModeReporter_AddCompositingModeWatcher_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingRemote<CompositingModeWatcher> p_watcher{};
      CompositingModeReporter_AddCompositingModeWatcher_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success) {
        p_watcher =
            input_data_view.TakeWatcher<decltype(p_watcher)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CompositingModeReporter::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddCompositingModeWatcher(
std::move(p_watcher));
      return true;
    }
  }
  return false;
}

// static
bool CompositingModeReporterStubDispatch::AcceptWithResponder(
    CompositingModeReporter* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kCompositingModeReporter_AddCompositingModeWatcher_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kCompositingModeReporterValidationInfo[] = {
    {internal::kCompositingModeReporter_AddCompositingModeWatcher_Name,
     {&internal::CompositingModeReporter_AddCompositingModeWatcher_Params_Data::Validate,
      nullptr /* no response */}},
};

bool CompositingModeReporterRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::viz::mojom::CompositingModeReporter::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kCompositingModeReporterValidationInfo);
}

}  // namespace mojom
}  // namespace viz

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif