// third_party/blink/public/mojom/choosers/popup_menu.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/choosers/popup_menu.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "third_party/blink/public/mojom/choosers/popup_menu.mojom-params-data.h"
#include "third_party/blink/public/mojom/choosers/popup_menu.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/choosers/popup_menu.mojom-import-headers.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_CHOOSERS_POPUP_MENU_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_CHOOSERS_POPUP_MENU_MOJOM_JUMBO_H_
#endif
namespace blink {
namespace mojom {
MenuItem::MenuItem()
    : label(),
      tool_tip(),
      type(MenuItem_Type::kOption),
      action(0U),
      text_direction(mojo::internal::ConvertEnumValue<::mojo_base::mojom::TextDirection, ::base::i18n::TextDirection>(::mojo_base::mojom::TextDirection::LEFT_TO_RIGHT)),
      has_text_direction_override(false),
      enabled(false),
      checked(false) {}

MenuItem::MenuItem(
    const base::Optional<std::string>& label_in,
    const base::Optional<std::string>& tool_tip_in,
    MenuItem::Type type_in,
    uint32_t action_in,
    ::base::i18n::TextDirection text_direction_in,
    bool has_text_direction_override_in,
    bool enabled_in,
    bool checked_in)
    : label(std::move(label_in)),
      tool_tip(std::move(tool_tip_in)),
      type(std::move(type_in)),
      action(std::move(action_in)),
      text_direction(std::move(text_direction_in)),
      has_text_direction_override(std::move(has_text_direction_override_in)),
      enabled(std::move(enabled_in)),
      checked(std::move(checked_in)) {}

MenuItem::~MenuItem() = default;

void MenuItem::AsValueInto(base::trace_event::TracedValue* value) const {
  if (this->label.has_value()) {
    value->SetString("label", this->label.value());
  } else {
    value->SetString("label", "base::nullopt");
  }
  if (this->tool_tip.has_value()) {
    value->SetString("tool_tip", this->tool_tip.value());
  } else {
    value->SetString("tool_tip", "base::nullopt");
  }
  value->SetString("type", base::trace_event::ValueToString(this->type));
  value->SetString("action", base::NumberToString(this->action));
  value->SetInteger("text_direction", static_cast<int>(this->text_direction));
  value->SetBoolean("has_text_direction_override", this->has_text_direction_override);
  value->SetBoolean("enabled", this->enabled);
  value->SetBoolean("checked", this->checked);
}

bool MenuItem::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char PopupMenuClient::Name_[] = "blink.mojom.PopupMenuClient";

PopupMenuClientProxy::PopupMenuClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PopupMenuClientProxy::DidAcceptIndices(
    const std::vector<int32_t>& in_indices) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::PopupMenuClient::DidAcceptIndices", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->BeginArray("indices");
      for (const auto& item0 : in_indices) {
        raw_value->AppendInteger(item0);
      }
      raw_value->EndArray();
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPopupMenuClient_DidAcceptIndices_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::PopupMenuClient_DidAcceptIndices_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->indices)::BaseType::BufferWriter
      indices_writer;
  const mojo::internal::ContainerValidateParams indices_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<int32_t>>(
      in_indices, buffer, &indices_writer, &indices_validate_params,
      &serialization_context);
  params->indices.Set(
      indices_writer.is_null() ? nullptr : indices_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->indices.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null indices in PopupMenuClient.DidAcceptIndices request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PopupMenuClient::Name_);
  message.set_method_name("DidAcceptIndices");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void PopupMenuClientProxy::DidCancel(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::PopupMenuClient::DidCancel");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kPopupMenuClient_DidCancel_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::PopupMenuClient_DidCancel_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PopupMenuClient::Name_);
  message.set_method_name("DidCancel");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool PopupMenuClientStubDispatch::Accept(
    PopupMenuClient* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kPopupMenuClient_DidAcceptIndices_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::PopupMenuClient::DidAcceptIndices",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::PopupMenuClient::DidAcceptIndices");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PopupMenuClient_DidAcceptIndices_Params_Data* params =
          reinterpret_cast<internal::PopupMenuClient_DidAcceptIndices_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::vector<int32_t> p_indices{};
      PopupMenuClient_DidAcceptIndices_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadIndices(&p_indices))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PopupMenuClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidAcceptIndices(
std::move(p_indices));
      return true;
    }
    case internal::kPopupMenuClient_DidCancel_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::PopupMenuClient::DidCancel",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::PopupMenuClient::DidCancel");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::PopupMenuClient_DidCancel_Params_Data* params =
          reinterpret_cast<internal::PopupMenuClient_DidCancel_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      PopupMenuClient_DidCancel_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PopupMenuClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidCancel();
      return true;
    }
  }
  return false;
}

// static
bool PopupMenuClientStubDispatch::AcceptWithResponder(
    PopupMenuClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kPopupMenuClient_DidAcceptIndices_Name: {
      break;
    }
    case internal::kPopupMenuClient_DidCancel_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kPopupMenuClientValidationInfo[] = {
    {&internal::PopupMenuClient_DidAcceptIndices_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::PopupMenuClient_DidCancel_Params_Data::Validate,
     nullptr /* no response */},
};

bool PopupMenuClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::PopupMenuClient::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kPopupMenuClientValidationInfo);
}

}  // namespace mojom
}  // namespace blink

namespace mojo {


// static
bool StructTraits<::blink::mojom::MenuItem::DataView, ::blink::mojom::MenuItemPtr>::Read(
    ::blink::mojom::MenuItem::DataView input,
    ::blink::mojom::MenuItemPtr* output) {
  bool success = true;
  ::blink::mojom::MenuItemPtr result(::blink::mojom::MenuItem::New());
  
      if (success && !input.ReadLabel(&result->label))
        success = false;
      if (success && !input.ReadToolTip(&result->tool_tip))
        success = false;
      if (success && !input.ReadType(&result->type))
        success = false;
      if (success)
        result->action = input.action();
      if (success && !input.ReadTextDirection(&result->text_direction))
        success = false;
      if (success)
        result->has_text_direction_override = input.has_text_direction_override();
      if (success)
        result->enabled = input.enabled();
      if (success)
        result->checked = input.checked();
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif