// third_party/blink/public/mojom/file_system_access/native_file_system_file_writer.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/file_system_access/native_file_system_file_writer.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "third_party/blink/public/mojom/file_system_access/native_file_system_file_writer.mojom-params-data.h"
#include "third_party/blink/public/mojom/file_system_access/native_file_system_file_writer.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/file_system_access/native_file_system_file_writer.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_FILE_SYSTEM_ACCESS_NATIVE_FILE_SYSTEM_FILE_WRITER_MOJOM_BLINK_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_FILE_SYSTEM_ACCESS_NATIVE_FILE_SYSTEM_FILE_WRITER_MOJOM_BLINK_JUMBO_H_
#endif
namespace blink {
namespace mojom {
namespace blink {
const char NativeFileSystemFileWriter::Name_[] = "blink.mojom.NativeFileSystemFileWriter";

class NativeFileSystemFileWriter_Write_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NativeFileSystemFileWriter_Write_ForwardToCallback(
      NativeFileSystemFileWriter::WriteCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  NativeFileSystemFileWriter::WriteCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(NativeFileSystemFileWriter_Write_ForwardToCallback);
};

class NativeFileSystemFileWriter_WriteStream_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NativeFileSystemFileWriter_WriteStream_ForwardToCallback(
      NativeFileSystemFileWriter::WriteStreamCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  NativeFileSystemFileWriter::WriteStreamCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(NativeFileSystemFileWriter_WriteStream_ForwardToCallback);
};

class NativeFileSystemFileWriter_Truncate_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NativeFileSystemFileWriter_Truncate_ForwardToCallback(
      NativeFileSystemFileWriter::TruncateCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  NativeFileSystemFileWriter::TruncateCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(NativeFileSystemFileWriter_Truncate_ForwardToCallback);
};

class NativeFileSystemFileWriter_Close_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NativeFileSystemFileWriter_Close_ForwardToCallback(
      NativeFileSystemFileWriter::CloseCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  NativeFileSystemFileWriter::CloseCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(NativeFileSystemFileWriter_Close_ForwardToCallback);
};

NativeFileSystemFileWriterProxy::NativeFileSystemFileWriterProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void NativeFileSystemFileWriterProxy::Write(
    uint64_t in_offset, ::mojo::PendingRemote<::blink::mojom::blink::Blob> in_data, WriteCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::NativeFileSystemFileWriter::Write", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("offset", base::NumberToString(in_offset));
      raw_value->SetBoolean("data", in_data.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNativeFileSystemFileWriter_Write_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::NativeFileSystemFileWriter_Write_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->offset = in_offset;
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::BlobInterfaceBase>>(
      in_data, &params->data, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->data),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid data in NativeFileSystemFileWriter.Write request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeFileSystemFileWriter::Name_);
  message.set_method_name("Write");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NativeFileSystemFileWriter_Write_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void NativeFileSystemFileWriterProxy::WriteStream(
    uint64_t in_offset, ::mojo::ScopedDataPipeConsumerHandle in_stream, WriteStreamCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::NativeFileSystemFileWriter::WriteStream", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("offset", base::NumberToString(in_offset));
      raw_value->SetBoolean("stream", in_stream.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNativeFileSystemFileWriter_WriteStream_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::NativeFileSystemFileWriter_WriteStream_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->offset = in_offset;
  mojo::internal::Serialize<mojo::ScopedDataPipeConsumerHandle>(
      in_stream, &params->stream, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->stream),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid stream in NativeFileSystemFileWriter.WriteStream request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeFileSystemFileWriter::Name_);
  message.set_method_name("WriteStream");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NativeFileSystemFileWriter_WriteStream_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void NativeFileSystemFileWriterProxy::Truncate(
    uint64_t in_length, TruncateCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::NativeFileSystemFileWriter::Truncate", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("length", base::NumberToString(in_length));
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNativeFileSystemFileWriter_Truncate_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::NativeFileSystemFileWriter_Truncate_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->length = in_length;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeFileSystemFileWriter::Name_);
  message.set_method_name("Truncate");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NativeFileSystemFileWriter_Truncate_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void NativeFileSystemFileWriterProxy::Close(
    CloseCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::NativeFileSystemFileWriter::Close");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNativeFileSystemFileWriter_Close_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::NativeFileSystemFileWriter_Close_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeFileSystemFileWriter::Name_);
  message.set_method_name("Close");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NativeFileSystemFileWriter_Close_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class NativeFileSystemFileWriter_Write_ProxyToResponder {
 public:
  static NativeFileSystemFileWriter::WriteCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<NativeFileSystemFileWriter_Write_ProxyToResponder> proxy(
        new NativeFileSystemFileWriter_Write_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&NativeFileSystemFileWriter_Write_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NativeFileSystemFileWriter_Write_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  NativeFileSystemFileWriter_Write_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NativeFileSystemFileWriter::WriteCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::blink::NativeFileSystemErrorPtr in_result, uint64_t in_bytes_written);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(NativeFileSystemFileWriter_Write_ProxyToResponder);
};

bool NativeFileSystemFileWriter_Write_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::NativeFileSystemFileWriter::WriteCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::NativeFileSystemFileWriter_Write_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NativeFileSystemFileWriter_Write_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  ::blink::mojom::blink::NativeFileSystemErrorPtr p_result{};
  uint64_t p_bytes_written{};
  NativeFileSystemFileWriter_Write_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (success)
    p_bytes_written = input_data_view.bytes_written();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NativeFileSystemFileWriter::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_bytes_written));
  return true;
}

void NativeFileSystemFileWriter_Write_ProxyToResponder::Run(
    ::blink::mojom::blink::NativeFileSystemErrorPtr in_result, uint64_t in_bytes_written) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::NativeFileSystemFileWriter::WriteCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_result.is_null()) {
        raw_value->SetString("result", "nullptr");
      } else {
        raw_value->BeginDictionary("result");
        in_result->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      raw_value->SetString("bytes_written", base::NumberToString(in_bytes_written));
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNativeFileSystemFileWriter_Write_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::NativeFileSystemFileWriter_Write_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->result)::BaseType::BufferWriter
      result_writer;
  mojo::internal::Serialize<::blink::mojom::NativeFileSystemErrorDataView>(
      in_result, buffer, &result_writer, &serialization_context);
  params->result.Set(
      result_writer.is_null() ? nullptr : result_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in ");
  params->bytes_written = in_bytes_written;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::NativeFileSystemFileWriter::WriteCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeFileSystemFileWriter::Name_);
  message.set_method_name("Write");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NativeFileSystemFileWriter_WriteStream_ProxyToResponder {
 public:
  static NativeFileSystemFileWriter::WriteStreamCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<NativeFileSystemFileWriter_WriteStream_ProxyToResponder> proxy(
        new NativeFileSystemFileWriter_WriteStream_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&NativeFileSystemFileWriter_WriteStream_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NativeFileSystemFileWriter_WriteStream_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  NativeFileSystemFileWriter_WriteStream_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NativeFileSystemFileWriter::WriteStreamCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::blink::NativeFileSystemErrorPtr in_result, uint64_t in_bytes_written);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(NativeFileSystemFileWriter_WriteStream_ProxyToResponder);
};

bool NativeFileSystemFileWriter_WriteStream_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::NativeFileSystemFileWriter::WriteStreamCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::NativeFileSystemFileWriter_WriteStream_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NativeFileSystemFileWriter_WriteStream_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  ::blink::mojom::blink::NativeFileSystemErrorPtr p_result{};
  uint64_t p_bytes_written{};
  NativeFileSystemFileWriter_WriteStream_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (success)
    p_bytes_written = input_data_view.bytes_written();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NativeFileSystemFileWriter::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_bytes_written));
  return true;
}

void NativeFileSystemFileWriter_WriteStream_ProxyToResponder::Run(
    ::blink::mojom::blink::NativeFileSystemErrorPtr in_result, uint64_t in_bytes_written) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::NativeFileSystemFileWriter::WriteStreamCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_result.is_null()) {
        raw_value->SetString("result", "nullptr");
      } else {
        raw_value->BeginDictionary("result");
        in_result->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      raw_value->SetString("bytes_written", base::NumberToString(in_bytes_written));
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNativeFileSystemFileWriter_WriteStream_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::NativeFileSystemFileWriter_WriteStream_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->result)::BaseType::BufferWriter
      result_writer;
  mojo::internal::Serialize<::blink::mojom::NativeFileSystemErrorDataView>(
      in_result, buffer, &result_writer, &serialization_context);
  params->result.Set(
      result_writer.is_null() ? nullptr : result_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in ");
  params->bytes_written = in_bytes_written;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::NativeFileSystemFileWriter::WriteStreamCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeFileSystemFileWriter::Name_);
  message.set_method_name("WriteStream");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NativeFileSystemFileWriter_Truncate_ProxyToResponder {
 public:
  static NativeFileSystemFileWriter::TruncateCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<NativeFileSystemFileWriter_Truncate_ProxyToResponder> proxy(
        new NativeFileSystemFileWriter_Truncate_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&NativeFileSystemFileWriter_Truncate_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NativeFileSystemFileWriter_Truncate_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  NativeFileSystemFileWriter_Truncate_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NativeFileSystemFileWriter::TruncateCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::blink::NativeFileSystemErrorPtr in_result);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(NativeFileSystemFileWriter_Truncate_ProxyToResponder);
};

bool NativeFileSystemFileWriter_Truncate_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::NativeFileSystemFileWriter::TruncateCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::NativeFileSystemFileWriter_Truncate_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NativeFileSystemFileWriter_Truncate_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  ::blink::mojom::blink::NativeFileSystemErrorPtr p_result{};
  NativeFileSystemFileWriter_Truncate_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NativeFileSystemFileWriter::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void NativeFileSystemFileWriter_Truncate_ProxyToResponder::Run(
    ::blink::mojom::blink::NativeFileSystemErrorPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::NativeFileSystemFileWriter::TruncateCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_result.is_null()) {
        raw_value->SetString("result", "nullptr");
      } else {
        raw_value->BeginDictionary("result");
        in_result->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNativeFileSystemFileWriter_Truncate_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::NativeFileSystemFileWriter_Truncate_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->result)::BaseType::BufferWriter
      result_writer;
  mojo::internal::Serialize<::blink::mojom::NativeFileSystemErrorDataView>(
      in_result, buffer, &result_writer, &serialization_context);
  params->result.Set(
      result_writer.is_null() ? nullptr : result_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in ");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::NativeFileSystemFileWriter::TruncateCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeFileSystemFileWriter::Name_);
  message.set_method_name("Truncate");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NativeFileSystemFileWriter_Close_ProxyToResponder {
 public:
  static NativeFileSystemFileWriter::CloseCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<NativeFileSystemFileWriter_Close_ProxyToResponder> proxy(
        new NativeFileSystemFileWriter_Close_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&NativeFileSystemFileWriter_Close_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NativeFileSystemFileWriter_Close_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  NativeFileSystemFileWriter_Close_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NativeFileSystemFileWriter::CloseCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::blink::NativeFileSystemErrorPtr in_result);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(NativeFileSystemFileWriter_Close_ProxyToResponder);
};

bool NativeFileSystemFileWriter_Close_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::NativeFileSystemFileWriter::CloseCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::NativeFileSystemFileWriter_Close_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NativeFileSystemFileWriter_Close_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  ::blink::mojom::blink::NativeFileSystemErrorPtr p_result{};
  NativeFileSystemFileWriter_Close_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NativeFileSystemFileWriter::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void NativeFileSystemFileWriter_Close_ProxyToResponder::Run(
    ::blink::mojom::blink::NativeFileSystemErrorPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::NativeFileSystemFileWriter::CloseCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_result.is_null()) {
        raw_value->SetString("result", "nullptr");
      } else {
        raw_value->BeginDictionary("result");
        in_result->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNativeFileSystemFileWriter_Close_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::NativeFileSystemFileWriter_Close_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->result)::BaseType::BufferWriter
      result_writer;
  mojo::internal::Serialize<::blink::mojom::NativeFileSystemErrorDataView>(
      in_result, buffer, &result_writer, &serialization_context);
  params->result.Set(
      result_writer.is_null() ? nullptr : result_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in ");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::NativeFileSystemFileWriter::CloseCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NativeFileSystemFileWriter::Name_);
  message.set_method_name("Close");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool NativeFileSystemFileWriterStubDispatch::Accept(
    NativeFileSystemFileWriter* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kNativeFileSystemFileWriter_Write_Name: {
      break;
    }
    case internal::kNativeFileSystemFileWriter_WriteStream_Name: {
      break;
    }
    case internal::kNativeFileSystemFileWriter_Truncate_Name: {
      break;
    }
    case internal::kNativeFileSystemFileWriter_Close_Name: {
      break;
    }
  }
  return false;
}

// static
bool NativeFileSystemFileWriterStubDispatch::AcceptWithResponder(
    NativeFileSystemFileWriter* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kNativeFileSystemFileWriter_Write_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::NativeFileSystemFileWriter::Write",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::NativeFileSystemFileWriter::Write");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::NativeFileSystemFileWriter_Write_Params_Data* params =
          reinterpret_cast<
              internal::NativeFileSystemFileWriter_Write_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      uint64_t p_offset{};
      ::mojo::PendingRemote<::blink::mojom::blink::Blob> p_data{};
      NativeFileSystemFileWriter_Write_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_offset = input_data_view.offset();
      if (success) {
        p_data =
            input_data_view.TakeData<decltype(p_data)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NativeFileSystemFileWriter::Name_, 0, false);
        return false;
      }
      NativeFileSystemFileWriter::WriteCallback callback =
          NativeFileSystemFileWriter_Write_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Write(
std::move(p_offset), 
std::move(p_data), std::move(callback));
      return true;
    }
    case internal::kNativeFileSystemFileWriter_WriteStream_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::NativeFileSystemFileWriter::WriteStream",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::NativeFileSystemFileWriter::WriteStream");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::NativeFileSystemFileWriter_WriteStream_Params_Data* params =
          reinterpret_cast<
              internal::NativeFileSystemFileWriter_WriteStream_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      uint64_t p_offset{};
      ::mojo::ScopedDataPipeConsumerHandle p_stream{};
      NativeFileSystemFileWriter_WriteStream_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_offset = input_data_view.offset();
      if (success)
        p_stream = input_data_view.TakeStream();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NativeFileSystemFileWriter::Name_, 1, false);
        return false;
      }
      NativeFileSystemFileWriter::WriteStreamCallback callback =
          NativeFileSystemFileWriter_WriteStream_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->WriteStream(
std::move(p_offset), 
std::move(p_stream), std::move(callback));
      return true;
    }
    case internal::kNativeFileSystemFileWriter_Truncate_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::NativeFileSystemFileWriter::Truncate",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::NativeFileSystemFileWriter::Truncate");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::NativeFileSystemFileWriter_Truncate_Params_Data* params =
          reinterpret_cast<
              internal::NativeFileSystemFileWriter_Truncate_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      uint64_t p_length{};
      NativeFileSystemFileWriter_Truncate_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_length = input_data_view.length();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NativeFileSystemFileWriter::Name_, 2, false);
        return false;
      }
      NativeFileSystemFileWriter::TruncateCallback callback =
          NativeFileSystemFileWriter_Truncate_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Truncate(
std::move(p_length), std::move(callback));
      return true;
    }
    case internal::kNativeFileSystemFileWriter_Close_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::NativeFileSystemFileWriter::Close",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::NativeFileSystemFileWriter::Close");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::NativeFileSystemFileWriter_Close_Params_Data* params =
          reinterpret_cast<
              internal::NativeFileSystemFileWriter_Close_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      NativeFileSystemFileWriter_Close_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NativeFileSystemFileWriter::Name_, 3, false);
        return false;
      }
      NativeFileSystemFileWriter::CloseCallback callback =
          NativeFileSystemFileWriter_Close_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Close(std::move(callback));
      return true;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kNativeFileSystemFileWriterValidationInfo[] = {
    {&internal::NativeFileSystemFileWriter_Write_Params_Data::Validate,
     &internal::NativeFileSystemFileWriter_Write_ResponseParams_Data::Validate},
    {&internal::NativeFileSystemFileWriter_WriteStream_Params_Data::Validate,
     &internal::NativeFileSystemFileWriter_WriteStream_ResponseParams_Data::Validate},
    {&internal::NativeFileSystemFileWriter_Truncate_Params_Data::Validate,
     &internal::NativeFileSystemFileWriter_Truncate_ResponseParams_Data::Validate},
    {&internal::NativeFileSystemFileWriter_Close_Params_Data::Validate,
     &internal::NativeFileSystemFileWriter_Close_ResponseParams_Data::Validate},
};

bool NativeFileSystemFileWriterRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::NativeFileSystemFileWriter::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kNativeFileSystemFileWriterValidationInfo);
}

bool NativeFileSystemFileWriterResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::NativeFileSystemFileWriter::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kNativeFileSystemFileWriterValidationInfo);
}
}  // namespace blink
}  // namespace mojom
}  // namespace blink

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif