// third_party/blink/public/mojom/optimization_guide/optimization_guide.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_OPTIMIZATION_GUIDE_OPTIMIZATION_GUIDE_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_OPTIMIZATION_GUIDE_OPTIMIZATION_GUIDE_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "third_party/blink/public/mojom/optimization_guide/optimization_guide.mojom-shared-internal.h"



#include "base/component_export.h"




namespace blink {
namespace mojom {
class DelayAsyncScriptExecutionHintsDataView;

class DelayCompetingLowPriorityRequestsHintsDataView;

class BlinkOptimizationGuideHintsDataView;



}  // namespace mojom
}  // namespace blink

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::DelayAsyncScriptExecutionHintsDataView> {
  using Data = ::blink::mojom::internal::DelayAsyncScriptExecutionHints_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::DelayCompetingLowPriorityRequestsHintsDataView> {
  using Data = ::blink::mojom::internal::DelayCompetingLowPriorityRequestsHints_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::BlinkOptimizationGuideHintsDataView> {
  using Data = ::blink::mojom::internal::BlinkOptimizationGuideHints_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink {
namespace mojom {


enum class DelayAsyncScriptExecutionDelayType : int32_t {
  
  kUnknown = 0,
  
  kFinishedParsing = 1,
  
  kFirstPaintOrFinishedParsing = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, DelayAsyncScriptExecutionDelayType value);
inline bool IsKnownEnumValue(DelayAsyncScriptExecutionDelayType value) {
  return internal::DelayAsyncScriptExecutionDelayType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class DelayCompetingLowPriorityRequestsDelayType : int32_t {
  
  kUnknown = 0,
  
  kFirstPaint = 1,
  
  kFirstContentfulPaint = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, DelayCompetingLowPriorityRequestsDelayType value);
inline bool IsKnownEnumValue(DelayCompetingLowPriorityRequestsDelayType value) {
  return internal::DelayCompetingLowPriorityRequestsDelayType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class DelayCompetingLowPriorityRequestsPriorityThreshold : int32_t {
  
  kUnknown = 0,
  
  kMedium = 1,
  
  kHigh = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, DelayCompetingLowPriorityRequestsPriorityThreshold value);
inline bool IsKnownEnumValue(DelayCompetingLowPriorityRequestsPriorityThreshold value) {
  return internal::DelayCompetingLowPriorityRequestsPriorityThreshold_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class DelayAsyncScriptExecutionHintsDataView {
 public:
  DelayAsyncScriptExecutionHintsDataView() {}

  DelayAsyncScriptExecutionHintsDataView(
      internal::DelayAsyncScriptExecutionHints_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadDelayType(UserType* output) const {
    auto data_value = data_->delay_type;
    return mojo::internal::Deserialize<::blink::mojom::DelayAsyncScriptExecutionDelayType>(
        data_value, output);
  }

  DelayAsyncScriptExecutionDelayType delay_type() const {
    return static_cast<DelayAsyncScriptExecutionDelayType>(data_->delay_type);
  }
 private:
  internal::DelayAsyncScriptExecutionHints_Data* data_ = nullptr;
};



class DelayCompetingLowPriorityRequestsHintsDataView {
 public:
  DelayCompetingLowPriorityRequestsHintsDataView() {}

  DelayCompetingLowPriorityRequestsHintsDataView(
      internal::DelayCompetingLowPriorityRequestsHints_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadDelayType(UserType* output) const {
    auto data_value = data_->delay_type;
    return mojo::internal::Deserialize<::blink::mojom::DelayCompetingLowPriorityRequestsDelayType>(
        data_value, output);
  }

  DelayCompetingLowPriorityRequestsDelayType delay_type() const {
    return static_cast<DelayCompetingLowPriorityRequestsDelayType>(data_->delay_type);
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadPriorityThreshold(UserType* output) const {
    auto data_value = data_->priority_threshold;
    return mojo::internal::Deserialize<::blink::mojom::DelayCompetingLowPriorityRequestsPriorityThreshold>(
        data_value, output);
  }

  DelayCompetingLowPriorityRequestsPriorityThreshold priority_threshold() const {
    return static_cast<DelayCompetingLowPriorityRequestsPriorityThreshold>(data_->priority_threshold);
  }
 private:
  internal::DelayCompetingLowPriorityRequestsHints_Data* data_ = nullptr;
};



class BlinkOptimizationGuideHintsDataView {
 public:
  BlinkOptimizationGuideHintsDataView() {}

  BlinkOptimizationGuideHintsDataView(
      internal::BlinkOptimizationGuideHints_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetDelayAsyncScriptExecutionHintsDataView(
      DelayAsyncScriptExecutionHintsDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadDelayAsyncScriptExecutionHints(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::DelayAsyncScriptExecutionHintsDataView, UserType>(),
    "Attempting to read the optional `delay_async_script_execution_hints` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDelayAsyncScriptExecutionHints` instead "
    "of `ReadDelayAsyncScriptExecutionHints if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->delay_async_script_execution_hints.Get();
    return mojo::internal::Deserialize<::blink::mojom::DelayAsyncScriptExecutionHintsDataView>(
        pointer, output, context_);
  }
  inline void GetDelayCompetingLowPriorityRequestsHintsDataView(
      DelayCompetingLowPriorityRequestsHintsDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadDelayCompetingLowPriorityRequestsHints(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::DelayCompetingLowPriorityRequestsHintsDataView, UserType>(),
    "Attempting to read the optional `delay_competing_low_priority_requests_hints` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDelayCompetingLowPriorityRequestsHints` instead "
    "of `ReadDelayCompetingLowPriorityRequestsHints if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->delay_competing_low_priority_requests_hints.Get();
    return mojo::internal::Deserialize<::blink::mojom::DelayCompetingLowPriorityRequestsHintsDataView>(
        pointer, output, context_);
  }
 private:
  internal::BlinkOptimizationGuideHints_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace blink

namespace std {

template <>
struct hash<::blink::mojom::DelayAsyncScriptExecutionDelayType>
    : public mojo::internal::EnumHashImpl<::blink::mojom::DelayAsyncScriptExecutionDelayType> {};

template <>
struct hash<::blink::mojom::DelayCompetingLowPriorityRequestsDelayType>
    : public mojo::internal::EnumHashImpl<::blink::mojom::DelayCompetingLowPriorityRequestsDelayType> {};

template <>
struct hash<::blink::mojom::DelayCompetingLowPriorityRequestsPriorityThreshold>
    : public mojo::internal::EnumHashImpl<::blink::mojom::DelayCompetingLowPriorityRequestsPriorityThreshold> {};

}  // namespace std

namespace mojo {


template <>
struct EnumTraits<::blink::mojom::DelayAsyncScriptExecutionDelayType, ::blink::mojom::DelayAsyncScriptExecutionDelayType> {
  static ::blink::mojom::DelayAsyncScriptExecutionDelayType ToMojom(::blink::mojom::DelayAsyncScriptExecutionDelayType input) { return input; }
  static bool FromMojom(::blink::mojom::DelayAsyncScriptExecutionDelayType input, ::blink::mojom::DelayAsyncScriptExecutionDelayType* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::DelayAsyncScriptExecutionDelayType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::DelayAsyncScriptExecutionDelayType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::blink::mojom::DelayAsyncScriptExecutionDelayType>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::blink::mojom::DelayCompetingLowPriorityRequestsDelayType, ::blink::mojom::DelayCompetingLowPriorityRequestsDelayType> {
  static ::blink::mojom::DelayCompetingLowPriorityRequestsDelayType ToMojom(::blink::mojom::DelayCompetingLowPriorityRequestsDelayType input) { return input; }
  static bool FromMojom(::blink::mojom::DelayCompetingLowPriorityRequestsDelayType input, ::blink::mojom::DelayCompetingLowPriorityRequestsDelayType* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::DelayCompetingLowPriorityRequestsDelayType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::DelayCompetingLowPriorityRequestsDelayType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::blink::mojom::DelayCompetingLowPriorityRequestsDelayType>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::blink::mojom::DelayCompetingLowPriorityRequestsPriorityThreshold, ::blink::mojom::DelayCompetingLowPriorityRequestsPriorityThreshold> {
  static ::blink::mojom::DelayCompetingLowPriorityRequestsPriorityThreshold ToMojom(::blink::mojom::DelayCompetingLowPriorityRequestsPriorityThreshold input) { return input; }
  static bool FromMojom(::blink::mojom::DelayCompetingLowPriorityRequestsPriorityThreshold input, ::blink::mojom::DelayCompetingLowPriorityRequestsPriorityThreshold* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::DelayCompetingLowPriorityRequestsPriorityThreshold, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::DelayCompetingLowPriorityRequestsPriorityThreshold, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::blink::mojom::DelayCompetingLowPriorityRequestsPriorityThreshold>(input), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::DelayAsyncScriptExecutionHintsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::DelayAsyncScriptExecutionHintsDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::DelayAsyncScriptExecutionHints_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    mojo::internal::Serialize<::blink::mojom::DelayAsyncScriptExecutionDelayType>(
        Traits::delay_type(input), &(*output)->delay_type);
  }

  static bool Deserialize(::blink::mojom::internal::DelayAsyncScriptExecutionHints_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::DelayAsyncScriptExecutionHintsDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::DelayCompetingLowPriorityRequestsHintsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::DelayCompetingLowPriorityRequestsHintsDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::DelayCompetingLowPriorityRequestsHints_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    mojo::internal::Serialize<::blink::mojom::DelayCompetingLowPriorityRequestsDelayType>(
        Traits::delay_type(input), &(*output)->delay_type);
    mojo::internal::Serialize<::blink::mojom::DelayCompetingLowPriorityRequestsPriorityThreshold>(
        Traits::priority_threshold(input), &(*output)->priority_threshold);
  }

  static bool Deserialize(::blink::mojom::internal::DelayCompetingLowPriorityRequestsHints_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::DelayCompetingLowPriorityRequestsHintsDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::BlinkOptimizationGuideHintsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::BlinkOptimizationGuideHintsDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::BlinkOptimizationGuideHints_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::delay_async_script_execution_hints(input)) in_delay_async_script_execution_hints = Traits::delay_async_script_execution_hints(input);
    typename decltype((*output)->delay_async_script_execution_hints)::BaseType::BufferWriter
        delay_async_script_execution_hints_writer;
    mojo::internal::Serialize<::blink::mojom::DelayAsyncScriptExecutionHintsDataView>(
        in_delay_async_script_execution_hints, buffer, &delay_async_script_execution_hints_writer, context);
    (*output)->delay_async_script_execution_hints.Set(
        delay_async_script_execution_hints_writer.is_null() ? nullptr : delay_async_script_execution_hints_writer.data());
    decltype(Traits::delay_competing_low_priority_requests_hints(input)) in_delay_competing_low_priority_requests_hints = Traits::delay_competing_low_priority_requests_hints(input);
    typename decltype((*output)->delay_competing_low_priority_requests_hints)::BaseType::BufferWriter
        delay_competing_low_priority_requests_hints_writer;
    mojo::internal::Serialize<::blink::mojom::DelayCompetingLowPriorityRequestsHintsDataView>(
        in_delay_competing_low_priority_requests_hints, buffer, &delay_competing_low_priority_requests_hints_writer, context);
    (*output)->delay_competing_low_priority_requests_hints.Set(
        delay_competing_low_priority_requests_hints_writer.is_null() ? nullptr : delay_competing_low_priority_requests_hints_writer.data());
  }

  static bool Deserialize(::blink::mojom::internal::BlinkOptimizationGuideHints_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::BlinkOptimizationGuideHintsDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink {
namespace mojom {





inline void BlinkOptimizationGuideHintsDataView::GetDelayAsyncScriptExecutionHintsDataView(
    DelayAsyncScriptExecutionHintsDataView* output) {
  auto pointer = data_->delay_async_script_execution_hints.Get();
  *output = DelayAsyncScriptExecutionHintsDataView(pointer, context_);
}
inline void BlinkOptimizationGuideHintsDataView::GetDelayCompetingLowPriorityRequestsHintsDataView(
    DelayCompetingLowPriorityRequestsHintsDataView* output) {
  auto pointer = data_->delay_competing_low_priority_requests_hints.Get();
  *output = DelayCompetingLowPriorityRequestsHintsDataView(pointer, context_);
}



}  // namespace mojom
}  // namespace blink

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_OPTIMIZATION_GUIDE_OPTIMIZATION_GUIDE_MOJOM_SHARED_H_