// third_party/blink/public/mojom/prerender/prerender.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PRERENDER_PRERENDER_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PRERENDER_PRERENDER_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "third_party/blink/public/mojom/prerender/prerender.mojom-shared-internal.h"
#include "third_party/blink/public/mojom/loader/referrer.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"


#include "base/component_export.h"




namespace blink {
namespace mojom {
class PrerenderAttributesDataView;



}  // namespace mojom
}  // namespace blink

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::PrerenderAttributesDataView> {
  using Data = ::blink::mojom::internal::PrerenderAttributes_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink {
namespace mojom {


enum class PrerenderRelType : int32_t {
  
  kPrerender = 0,
  
  kNext = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, PrerenderRelType value);
inline bool IsKnownEnumValue(PrerenderRelType value) {
  return internal::PrerenderRelType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class PrerenderProcessorClientInterfaceBase {};

using PrerenderProcessorClientPtrDataView =
    mojo::InterfacePtrDataView<PrerenderProcessorClientInterfaceBase>;
using PrerenderProcessorClientRequestDataView =
    mojo::InterfaceRequestDataView<PrerenderProcessorClientInterfaceBase>;
using PrerenderProcessorClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PrerenderProcessorClientInterfaceBase>;
using PrerenderProcessorClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PrerenderProcessorClientInterfaceBase>;
class PrerenderProcessorInterfaceBase {};

using PrerenderProcessorPtrDataView =
    mojo::InterfacePtrDataView<PrerenderProcessorInterfaceBase>;
using PrerenderProcessorRequestDataView =
    mojo::InterfaceRequestDataView<PrerenderProcessorInterfaceBase>;
using PrerenderProcessorAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PrerenderProcessorInterfaceBase>;
using PrerenderProcessorAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PrerenderProcessorInterfaceBase>;


class PrerenderAttributesDataView {
 public:
  PrerenderAttributesDataView() {}

  PrerenderAttributesDataView(
      internal::PrerenderAttributes_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, context_);
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadRelType(UserType* output) const {
    auto data_value = data_->rel_type;
    return mojo::internal::Deserialize<::blink::mojom::PrerenderRelType>(
        data_value, output);
  }

  PrerenderRelType rel_type() const {
    return static_cast<PrerenderRelType>(data_->rel_type);
  }
  inline void GetReferrerDataView(
      ::blink::mojom::ReferrerDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadReferrer(UserType* output) {
    
    auto* pointer = data_->referrer.Get();
    return mojo::internal::Deserialize<::blink::mojom::ReferrerDataView>(
        pointer, output, context_);
  }
  inline void GetViewSizeDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadViewSize(UserType* output) {
    
    auto* pointer = data_->view_size.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, context_);
  }
 private:
  internal::PrerenderAttributes_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace blink

namespace std {

template <>
struct hash<::blink::mojom::PrerenderRelType>
    : public mojo::internal::EnumHashImpl<::blink::mojom::PrerenderRelType> {};

}  // namespace std

namespace mojo {


template <>
struct EnumTraits<::blink::mojom::PrerenderRelType, ::blink::mojom::PrerenderRelType> {
  static ::blink::mojom::PrerenderRelType ToMojom(::blink::mojom::PrerenderRelType input) { return input; }
  static bool FromMojom(::blink::mojom::PrerenderRelType input, ::blink::mojom::PrerenderRelType* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::PrerenderRelType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::PrerenderRelType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::blink::mojom::PrerenderRelType>(input), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::PrerenderAttributesDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::PrerenderAttributesDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::PrerenderAttributes_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::url(input)) in_url = Traits::url(input);
    typename decltype((*output)->url)::BaseType::BufferWriter
        url_writer;
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_url, buffer, &url_writer, context);
    (*output)->url.Set(
        url_writer.is_null() ? nullptr : url_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->url.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null url in PrerenderAttributes struct");
    mojo::internal::Serialize<::blink::mojom::PrerenderRelType>(
        Traits::rel_type(input), &(*output)->rel_type);
    decltype(Traits::referrer(input)) in_referrer = Traits::referrer(input);
    typename decltype((*output)->referrer)::BaseType::BufferWriter
        referrer_writer;
    mojo::internal::Serialize<::blink::mojom::ReferrerDataView>(
        in_referrer, buffer, &referrer_writer, context);
    (*output)->referrer.Set(
        referrer_writer.is_null() ? nullptr : referrer_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->referrer.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null referrer in PrerenderAttributes struct");
    decltype(Traits::view_size(input)) in_view_size = Traits::view_size(input);
    typename decltype((*output)->view_size)::BaseType::BufferWriter
        view_size_writer;
    mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
        in_view_size, buffer, &view_size_writer, context);
    (*output)->view_size.Set(
        view_size_writer.is_null() ? nullptr : view_size_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->view_size.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null view_size in PrerenderAttributes struct");
  }

  static bool Deserialize(::blink::mojom::internal::PrerenderAttributes_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::PrerenderAttributesDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink {
namespace mojom {

inline void PrerenderAttributesDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, context_);
}
inline void PrerenderAttributesDataView::GetReferrerDataView(
    ::blink::mojom::ReferrerDataView* output) {
  auto pointer = data_->referrer.Get();
  *output = ::blink::mojom::ReferrerDataView(pointer, context_);
}
inline void PrerenderAttributesDataView::GetViewSizeDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->view_size.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, context_);
}



}  // namespace mojom
}  // namespace blink

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_PRERENDER_PRERENDER_MOJOM_SHARED_H_