// components/services/storage/privileged/mojom/indexed_db_internals_types.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/services/storage/privileged/mojom/indexed_db_internals_types.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/services/storage/privileged/mojom/indexed_db_internals_types.mojom-params-data.h"
#include "components/services/storage/privileged/mojom/indexed_db_internals_types.mojom-shared-message-ids.h"

#include "components/services/storage/privileged/mojom/indexed_db_internals_types.mojom-import-headers.h"
#include "components/services/storage/privileged/mojom/indexed_db_internals_types.mojom-test-utils.h"


namespace storage::mojom {
IdbOriginMetadata::IdbOriginMetadata()
    : origin(),
      storage_keys() {}

IdbOriginMetadata::IdbOriginMetadata(
    const ::url::Origin& origin_in,
    std::vector<IdbStorageKeyMetadataPtr> storage_keys_in)
    : origin(std::move(origin_in)),
      storage_keys(std::move(storage_keys_in)) {}

IdbOriginMetadata::~IdbOriginMetadata() = default;

void IdbOriginMetadata::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "origin"), this->origin,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::url::Origin&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "storage_keys"), this->storage_keys,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<IdbStorageKeyMetadataPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool IdbOriginMetadata::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
IdbStorageKeyMetadata::IdbStorageKeyMetadata()
    : top_level_site(),
      serialized_storage_key(),
      buckets() {}

IdbStorageKeyMetadata::IdbStorageKeyMetadata(
    const ::net::SchemefulSite& top_level_site_in,
    const std::string& serialized_storage_key_in,
    std::vector<IdbBucketMetadataPtr> buckets_in)
    : top_level_site(std::move(top_level_site_in)),
      serialized_storage_key(std::move(serialized_storage_key_in)),
      buckets(std::move(buckets_in)) {}

IdbStorageKeyMetadata::~IdbStorageKeyMetadata() = default;

void IdbStorageKeyMetadata::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "top_level_site"), this->top_level_site,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::net::SchemefulSite&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "serialized_storage_key"), this->serialized_storage_key,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "buckets"), this->buckets,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<IdbBucketMetadataPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool IdbStorageKeyMetadata::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
IdbBucketMetadata::IdbBucketMetadata()
    : bucket_locator(),
      name(),
      size(),
      last_modified(),
      paths(),
      connection_count(),
      databases(),
      clients(),
      delta_recording_start_ms() {}

IdbBucketMetadata::IdbBucketMetadata(
    const ::storage::BucketLocator& bucket_locator_in,
    const std::string& name_in,
    uint64_t size_in,
    ::base::Time last_modified_in,
    std::vector<::base::FilePath> paths_in,
    uint64_t connection_count_in,
    std::vector<IdbDatabaseMetadataPtr> databases_in,
    std::vector<::storage::BucketClientInfo> clients_in,
    uint64_t delta_recording_start_ms_in)
    : bucket_locator(std::move(bucket_locator_in)),
      name(std::move(name_in)),
      size(std::move(size_in)),
      last_modified(std::move(last_modified_in)),
      paths(std::move(paths_in)),
      connection_count(std::move(connection_count_in)),
      databases(std::move(databases_in)),
      clients(std::move(clients_in)),
      delta_recording_start_ms(std::move(delta_recording_start_ms_in)) {}

IdbBucketMetadata::~IdbBucketMetadata() = default;

void IdbBucketMetadata::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bucket_locator"), this->bucket_locator,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::storage::BucketLocator&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "size"), this->size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "last_modified"), this->last_modified,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::Time>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "paths"), this->paths,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::base::FilePath>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "connection_count"), this->connection_count,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "databases"), this->databases,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<IdbDatabaseMetadataPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "clients"), this->clients,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::storage::BucketClientInfo>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "delta_recording_start_ms"), this->delta_recording_start_ms,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool IdbBucketMetadata::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
IdbDatabaseMetadata::IdbDatabaseMetadata()
    : name(),
      connection_count(),
      active_open_delete(),
      pending_open_delete(),
      transactions() {}

IdbDatabaseMetadata::IdbDatabaseMetadata(
    const ::std::u16string& name_in,
    uint64_t connection_count_in,
    uint64_t active_open_delete_in,
    uint64_t pending_open_delete_in,
    std::vector<IdbTransactionMetadataPtr> transactions_in)
    : name(std::move(name_in)),
      connection_count(std::move(connection_count_in)),
      active_open_delete(std::move(active_open_delete_in)),
      pending_open_delete(std::move(pending_open_delete_in)),
      transactions(std::move(transactions_in)) {}

IdbDatabaseMetadata::~IdbDatabaseMetadata() = default;

void IdbDatabaseMetadata::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "connection_count"), this->connection_count,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "active_open_delete"), this->active_open_delete,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "pending_open_delete"), this->pending_open_delete,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "transactions"), this->transactions,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<IdbTransactionMetadataPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool IdbDatabaseMetadata::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
IdbTransactionMetadata::IdbTransactionMetadata()
    : mode(),
      state(),
      tid(),
      connection_id(),
      client_token(),
      age(),
      runtime(),
      tasks_scheduled(),
      tasks_completed(),
      scope(),
      state_history() {}

IdbTransactionMetadata::IdbTransactionMetadata(
    IdbTransactionMode mode_in,
    IdbTransactionState state_in,
    int64_t tid_in,
    int32_t connection_id_in,
    const std::string& client_token_in,
    double age_in,
    double runtime_in,
    double tasks_scheduled_in,
    double tasks_completed_in,
    std::vector<::std::u16string> scope_in,
    std::vector<IdbTransactionMetadataStateHistoryPtr> state_history_in)
    : mode(std::move(mode_in)),
      state(std::move(state_in)),
      tid(std::move(tid_in)),
      connection_id(std::move(connection_id_in)),
      client_token(std::move(client_token_in)),
      age(std::move(age_in)),
      runtime(std::move(runtime_in)),
      tasks_scheduled(std::move(tasks_scheduled_in)),
      tasks_completed(std::move(tasks_completed_in)),
      scope(std::move(scope_in)),
      state_history(std::move(state_history_in)) {}

IdbTransactionMetadata::~IdbTransactionMetadata() = default;

void IdbTransactionMetadata::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mode"), this->mode,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type IdbTransactionMode>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "state"), this->state,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type IdbTransactionState>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tid"), this->tid,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "connection_id"), this->connection_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "client_token"), this->client_token,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "age"), this->age,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "runtime"), this->runtime,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tasks_scheduled"), this->tasks_scheduled,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tasks_completed"), this->tasks_completed,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "scope"), this->scope,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::std::u16string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "state_history"), this->state_history,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<IdbTransactionMetadataStateHistoryPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool IdbTransactionMetadata::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
IdbTransactionMetadataStateHistory::IdbTransactionMetadataStateHistory()
    : state(),
      duration() {}

IdbTransactionMetadataStateHistory::IdbTransactionMetadataStateHistory(
    IdbTransactionState state_in,
    double duration_in)
    : state(std::move(state_in)),
      duration(std::move(duration_in)) {}

IdbTransactionMetadataStateHistory::~IdbTransactionMetadataStateHistory() = default;
size_t IdbTransactionMetadataStateHistory::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->state);
  seed = mojo::internal::Hash(seed, this->duration);
  return seed;
}

void IdbTransactionMetadataStateHistory::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "state"), this->state,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type IdbTransactionState>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "duration"), this->duration,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type double>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool IdbTransactionMetadataStateHistory::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}


}  // storage::mojom


namespace mojo {


// static
bool StructTraits<::storage::mojom::IdbOriginMetadata::DataView, ::storage::mojom::IdbOriginMetadataPtr>::Read(
    ::storage::mojom::IdbOriginMetadata::DataView input,
    ::storage::mojom::IdbOriginMetadataPtr* output) {
  bool success = true;
  ::storage::mojom::IdbOriginMetadataPtr result(::storage::mojom::IdbOriginMetadata::New());
  
      if (success && !input.ReadOrigin(&result->origin))
        success = false;
      if (success && !input.ReadStorageKeys(&result->storage_keys))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::storage::mojom::IdbStorageKeyMetadata::DataView, ::storage::mojom::IdbStorageKeyMetadataPtr>::Read(
    ::storage::mojom::IdbStorageKeyMetadata::DataView input,
    ::storage::mojom::IdbStorageKeyMetadataPtr* output) {
  bool success = true;
  ::storage::mojom::IdbStorageKeyMetadataPtr result(::storage::mojom::IdbStorageKeyMetadata::New());
  
      if (success && !input.ReadTopLevelSite(&result->top_level_site))
        success = false;
      if (success && !input.ReadSerializedStorageKey(&result->serialized_storage_key))
        success = false;
      if (success && !input.ReadBuckets(&result->buckets))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::storage::mojom::IdbBucketMetadata::DataView, ::storage::mojom::IdbBucketMetadataPtr>::Read(
    ::storage::mojom::IdbBucketMetadata::DataView input,
    ::storage::mojom::IdbBucketMetadataPtr* output) {
  bool success = true;
  ::storage::mojom::IdbBucketMetadataPtr result(::storage::mojom::IdbBucketMetadata::New());
  
      if (success && !input.ReadBucketLocator(&result->bucket_locator))
        success = false;
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success)
        result->size = input.size();
      if (success && !input.ReadLastModified(&result->last_modified))
        success = false;
      if (success && !input.ReadPaths(&result->paths))
        success = false;
      if (success)
        result->connection_count = input.connection_count();
      if (success && !input.ReadDatabases(&result->databases))
        success = false;
      if (success && !input.ReadClients(&result->clients))
        success = false;
      if (success)
        result->delta_recording_start_ms = input.delta_recording_start_ms();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::storage::mojom::IdbDatabaseMetadata::DataView, ::storage::mojom::IdbDatabaseMetadataPtr>::Read(
    ::storage::mojom::IdbDatabaseMetadata::DataView input,
    ::storage::mojom::IdbDatabaseMetadataPtr* output) {
  bool success = true;
  ::storage::mojom::IdbDatabaseMetadataPtr result(::storage::mojom::IdbDatabaseMetadata::New());
  
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success)
        result->connection_count = input.connection_count();
      if (success)
        result->active_open_delete = input.active_open_delete();
      if (success)
        result->pending_open_delete = input.pending_open_delete();
      if (success && !input.ReadTransactions(&result->transactions))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::storage::mojom::IdbTransactionMetadata::DataView, ::storage::mojom::IdbTransactionMetadataPtr>::Read(
    ::storage::mojom::IdbTransactionMetadata::DataView input,
    ::storage::mojom::IdbTransactionMetadataPtr* output) {
  bool success = true;
  ::storage::mojom::IdbTransactionMetadataPtr result(::storage::mojom::IdbTransactionMetadata::New());
  
      if (success && !input.ReadMode(&result->mode))
        success = false;
      if (success && !input.ReadState(&result->state))
        success = false;
      if (success)
        result->tid = input.tid();
      if (success)
        result->connection_id = input.connection_id();
      if (success && !input.ReadClientToken(&result->client_token))
        success = false;
      if (success)
        result->age = input.age();
      if (success)
        result->runtime = input.runtime();
      if (success)
        result->tasks_scheduled = input.tasks_scheduled();
      if (success)
        result->tasks_completed = input.tasks_completed();
      if (success && !input.ReadScope(&result->scope))
        success = false;
      if (success && !input.ReadStateHistory(&result->state_history))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::storage::mojom::IdbTransactionMetadataStateHistory::DataView, ::storage::mojom::IdbTransactionMetadataStateHistoryPtr>::Read(
    ::storage::mojom::IdbTransactionMetadataStateHistory::DataView input,
    ::storage::mojom::IdbTransactionMetadataStateHistoryPtr* output) {
  bool success = true;
  ::storage::mojom::IdbTransactionMetadataStateHistoryPtr result(::storage::mojom::IdbTransactionMetadataStateHistory::New());
  
      if (success && !input.ReadState(&result->state))
        success = false;
      if (success)
        result->duration = input.duration();
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace storage::mojom {




}  // storage::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif