// services/device/public/mojom/pressure_manager.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_DEVICE_PUBLIC_MOJOM_PRESSURE_MANAGER_MOJOM_SHARED_H_
#define SERVICES_DEVICE_PUBLIC_MOJOM_PRESSURE_MANAGER_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/device/public/mojom/pressure_manager.mojom-shared-internal.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "services/device/public/mojom/pressure_update.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"






namespace device::mojom {
class VirtualPressureSourceMetadataDataView;

class PressureManagerAddClientResultDataView;


}  // device::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::device::mojom::VirtualPressureSourceMetadataDataView> {
  using Data = ::device::mojom::internal::VirtualPressureSourceMetadata_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::PressureManagerAddClientResultDataView> {
  using Data = ::device::mojom::internal::PressureManagerAddClientResult_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace device::mojom {


enum class PressureManagerAddClientError : int32_t {
  
  kNotSupported = 0,
  kMinValue = 0,
  kMaxValue = 0,
};

 std::ostream& operator<<(std::ostream& os, PressureManagerAddClientError value);
inline bool IsKnownEnumValue(PressureManagerAddClientError value) {
  return internal::PressureManagerAddClientError_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class PressureManagerInterfaceBase {};

using PressureManagerPtrDataView =
    mojo::InterfacePtrDataView<PressureManagerInterfaceBase>;
using PressureManagerRequestDataView =
    mojo::InterfaceRequestDataView<PressureManagerInterfaceBase>;
using PressureManagerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PressureManagerInterfaceBase>;
using PressureManagerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PressureManagerInterfaceBase>;
class PressureClientInterfaceBase {};

using PressureClientPtrDataView =
    mojo::InterfacePtrDataView<PressureClientInterfaceBase>;
using PressureClientRequestDataView =
    mojo::InterfaceRequestDataView<PressureClientInterfaceBase>;
using PressureClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PressureClientInterfaceBase>;
using PressureClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PressureClientInterfaceBase>;


class VirtualPressureSourceMetadataDataView {
 public:
  VirtualPressureSourceMetadataDataView() = default;

  VirtualPressureSourceMetadataDataView(
      internal::VirtualPressureSourceMetadata_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool available() const {
    return data_->available;
  }
 private:
  internal::VirtualPressureSourceMetadata_Data* data_ = nullptr;
};


class PressureManagerAddClientResultDataView {
 public:
  using Tag = internal::PressureManagerAddClientResult_Data::PressureManagerAddClientResult_Tag;

  PressureManagerAddClientResultDataView() = default;

  PressureManagerAddClientResultDataView(
      internal::PressureManagerAddClientResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_error() const { return data_->tag == Tag::kError; }
  template <typename UserType>
  [[nodiscard]] bool ReadError(UserType* output) const {
    CHECK(is_error());
    return mojo::internal::Deserialize<::device::mojom::PressureManagerAddClientError>(
        data_->data.f_error, output);
  }
  PressureManagerAddClientError error() const {
    CHECK(is_error());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::device::mojom::PressureManagerAddClientError>(data_->data.f_error));
  }
  bool is_pressure_client() const { return data_->tag == Tag::kPressureClient; }
  template <typename UserType>
  UserType TakePressureClient() {
    CHECK(is_pressure_client());
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::device::mojom::PressureClientInterfaceBase>>(
            &data_->data.f_pressure_client, &result, message_);
    CHECK(ret);
    return result;
  }

 private:
  internal::PressureManagerAddClientResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // device::mojom

namespace std {

template <>
struct hash<::device::mojom::PressureManagerAddClientError>
    : public mojo::internal::EnumHashImpl<::device::mojom::PressureManagerAddClientError> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::PressureManagerAddClientError, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::device::mojom::PressureManagerAddClientError, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::device::mojom::PressureManagerAddClientError>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::VirtualPressureSourceMetadataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::VirtualPressureSourceMetadataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::VirtualPressureSourceMetadata_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->available = Traits::available(input);
  }

  static bool Deserialize(::device::mojom::internal::VirtualPressureSourceMetadata_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::VirtualPressureSourceMetadataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::PressureManagerAddClientResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::device::mojom::PressureManagerAddClientResultDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::device::mojom::internal::PressureManagerAddClientResult_Data>& fragment,
                        bool inlined) {
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

    if (!inlined)
      fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
    fragment->size = kUnionDataSize;
    fragment->tag = Traits::GetTag(input);
    switch (fragment->tag) {
      case ::device::mojom::PressureManagerAddClientResultDataView::Tag::kError: {
        decltype(Traits::error(input))
            in_error = Traits::error(input);
        mojo::internal::Serialize<::device::mojom::PressureManagerAddClientError>(
            in_error, &fragment->data.f_error);
        break;
      }
      case ::device::mojom::PressureManagerAddClientResultDataView::Tag::kPressureClient: {
        decltype(Traits::pressure_client(input))
            in_pressure_client = Traits::pressure_client(input);
        mojo::internal::Serialize<mojo::InterfaceRequestDataView<::device::mojom::PressureClientInterfaceBase>>(
            in_pressure_client, &fragment->data.f_pressure_client, &fragment.message());
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            !mojo::internal::IsHandleOrInterfaceValid(fragment->data.f_pressure_client),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
            "invalid pressure_client in PressureManagerAddClientResult union");
        break;
      }
    }
  }

  static bool Deserialize(::device::mojom::internal::PressureManagerAddClientResult_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::PressureManagerAddClientResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace device::mojom {





}  // device::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::device::mojom::PressureManagerAddClientError> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::device::mojom::PressureManagerAddClientError value);
};

} // namespace perfetto

#endif  // SERVICES_DEVICE_PUBLIC_MOJOM_PRESSURE_MANAGER_MOJOM_SHARED_H_