// services/network/public/mojom/device_bound_sessions.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_DEVICE_BOUND_SESSIONS_MOJOM_SHARED_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_DEVICE_BOUND_SESSIONS_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/device_bound_sessions.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "sandbox/policy/mojom/context.mojom-shared.h"
#include "services/network/public/mojom/clear_data_filter.mojom-shared.h"
#include "services/network/public/mojom/schemeful_site.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"






namespace network::mojom {
class DeviceBoundSessionKeyDataView;

class DeviceBoundSessionAccessDataView;



}  // network::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::network::mojom::DeviceBoundSessionKeyDataView> {
  using Data = ::network::mojom::internal::DeviceBoundSessionKey_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::DeviceBoundSessionAccessDataView> {
  using Data = ::network::mojom::internal::DeviceBoundSessionAccess_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace network::mojom {


enum class DeviceBoundSessionAccessType : int32_t {
  
  kCreation = 0,
  
  kUpdate = 1,
  
  kTermination = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, DeviceBoundSessionAccessType value);
inline bool IsKnownEnumValue(DeviceBoundSessionAccessType value) {
  return internal::DeviceBoundSessionAccessType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class DeviceBoundSessionManagerInterfaceBase {};

using DeviceBoundSessionManagerPtrDataView =
    mojo::InterfacePtrDataView<DeviceBoundSessionManagerInterfaceBase>;
using DeviceBoundSessionManagerRequestDataView =
    mojo::InterfaceRequestDataView<DeviceBoundSessionManagerInterfaceBase>;
using DeviceBoundSessionManagerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<DeviceBoundSessionManagerInterfaceBase>;
using DeviceBoundSessionManagerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<DeviceBoundSessionManagerInterfaceBase>;
class DeviceBoundSessionAccessObserverInterfaceBase {};

using DeviceBoundSessionAccessObserverPtrDataView =
    mojo::InterfacePtrDataView<DeviceBoundSessionAccessObserverInterfaceBase>;
using DeviceBoundSessionAccessObserverRequestDataView =
    mojo::InterfaceRequestDataView<DeviceBoundSessionAccessObserverInterfaceBase>;
using DeviceBoundSessionAccessObserverAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<DeviceBoundSessionAccessObserverInterfaceBase>;
using DeviceBoundSessionAccessObserverAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<DeviceBoundSessionAccessObserverInterfaceBase>;


class DeviceBoundSessionKeyDataView {
 public:
  DeviceBoundSessionKeyDataView() = default;

  DeviceBoundSessionKeyDataView(
      internal::DeviceBoundSessionKey_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSiteDataView(
      ::network::mojom::SchemefulSiteDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSite(UserType* output) {
    
    auto* pointer = data_->site.Get();
    return mojo::internal::Deserialize<::network::mojom::SchemefulSiteDataView>(
        pointer, output, message_);
  }
  inline void GetIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::DeviceBoundSessionKey_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class DeviceBoundSessionAccessDataView {
 public:
  DeviceBoundSessionAccessDataView() = default;

  DeviceBoundSessionAccessDataView(
      internal::DeviceBoundSessionAccess_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadAccessType(UserType* output) const {
    auto data_value = data_->access_type;
    return mojo::internal::Deserialize<::network::mojom::DeviceBoundSessionAccessType>(
        data_value, output);
  }
  DeviceBoundSessionAccessType access_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::DeviceBoundSessionAccessType>(data_->access_type));
  }
  inline void GetSessionKeyDataView(
      DeviceBoundSessionKeyDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSessionKey(UserType* output) {
    
    auto* pointer = data_->session_key.Get();
    return mojo::internal::Deserialize<::network::mojom::DeviceBoundSessionKeyDataView>(
        pointer, output, message_);
  }
 private:
  internal::DeviceBoundSessionAccess_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // network::mojom

namespace std {

template <>
struct hash<::network::mojom::DeviceBoundSessionAccessType>
    : public mojo::internal::EnumHashImpl<::network::mojom::DeviceBoundSessionAccessType> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::DeviceBoundSessionAccessType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::DeviceBoundSessionAccessType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::DeviceBoundSessionAccessType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::DeviceBoundSessionKeyDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::DeviceBoundSessionKeyDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::DeviceBoundSessionKey_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::site(input)) in_site = Traits::site(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->site)::BaseType> site_fragment(
            fragment.message());
    mojo::internal::Serialize<::network::mojom::SchemefulSiteDataView>(
        in_site, site_fragment);
    fragment->site.Set(
        site_fragment.is_null() ? nullptr : site_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->site.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null site in DeviceBoundSessionKey struct");
    decltype(Traits::id(input)) in_id = Traits::id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->id)::BaseType> id_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_id, id_fragment);
    fragment->id.Set(
        id_fragment.is_null() ? nullptr : id_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->id.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null id in DeviceBoundSessionKey struct");
  }

  static bool Deserialize(::network::mojom::internal::DeviceBoundSessionKey_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::DeviceBoundSessionKeyDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::DeviceBoundSessionAccessDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::DeviceBoundSessionAccessDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::DeviceBoundSessionAccess_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    mojo::internal::Serialize<::network::mojom::DeviceBoundSessionAccessType>(
        Traits::access_type(input), &fragment->access_type);
    decltype(Traits::session_key(input)) in_session_key = Traits::session_key(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->session_key)::BaseType> session_key_fragment(
            fragment.message());
    mojo::internal::Serialize<::network::mojom::DeviceBoundSessionKeyDataView>(
        in_session_key, session_key_fragment);
    fragment->session_key.Set(
        session_key_fragment.is_null() ? nullptr : session_key_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->session_key.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null session_key in DeviceBoundSessionAccess struct");
  }

  static bool Deserialize(::network::mojom::internal::DeviceBoundSessionAccess_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::DeviceBoundSessionAccessDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace network::mojom {

inline void DeviceBoundSessionKeyDataView::GetSiteDataView(
    ::network::mojom::SchemefulSiteDataView* output) {
  auto pointer = data_->site.Get();
  *output = ::network::mojom::SchemefulSiteDataView(pointer, message_);
}
inline void DeviceBoundSessionKeyDataView::GetIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->id.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void DeviceBoundSessionAccessDataView::GetSessionKeyDataView(
    DeviceBoundSessionKeyDataView* output) {
  auto pointer = data_->session_key.Get();
  *output = DeviceBoundSessionKeyDataView(pointer, message_);
}



}  // network::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::DeviceBoundSessionAccessType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::DeviceBoundSessionAccessType value);
};

} // namespace perfetto

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_DEVICE_BOUND_SESSIONS_MOJOM_SHARED_H_