// services/network/public/mojom/reporting_service.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/reporting_service.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/reporting_service.mojom-params-data.h"
#include "services/network/public/mojom/reporting_service.mojom-shared-message-ids.h"

#include "services/network/public/mojom/reporting_service.mojom-import-headers.h"
#include "services/network/public/mojom/reporting_service.mojom-test-utils.h"


namespace network::mojom {
ReportingApiReport::ReportingApiReport()
    : id(),
      url(),
      group(),
      type(),
      timestamp(),
      depth(),
      attempts(),
      body(),
      status() {}

ReportingApiReport::ReportingApiReport(
    const ::base::UnguessableToken& id_in,
    const ::GURL& url_in,
    const std::string& group_in,
    const std::string& type_in,
    ::base::TimeTicks timestamp_in,
    int32_t depth_in,
    int32_t attempts_in,
    ::base::Value::Dict body_in,
    ReportingApiReportStatus status_in)
    : id(std::move(id_in)),
      url(std::move(url_in)),
      group(std::move(group_in)),
      type(std::move(type_in)),
      timestamp(std::move(timestamp_in)),
      depth(std::move(depth_in)),
      attempts(std::move(attempts_in)),
      body(std::move(body_in)),
      status(std::move(status_in)) {}

ReportingApiReport::~ReportingApiReport() = default;

void ReportingApiReport::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::base::UnguessableToken&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "group"), this->group,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "type"), this->type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "timestamp"), this->timestamp,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::TimeTicks>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "depth"), this->depth,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "attempts"), this->attempts,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "body"), this->body,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::base::Value::Dict>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "status"), this->status,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ReportingApiReportStatus>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ReportingApiReport::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ReportingApiEndpoint::ReportingApiEndpoint()
    : url(),
      attempted_uploads(),
      successful_uploads(),
      attempted_reports(),
      successful_reports(),
      priority(),
      weight(),
      origin(),
      group_name(),
      network_anonymization_key(),
      reporting_source() {}

ReportingApiEndpoint::ReportingApiEndpoint(
    const ::GURL& url_in,
    int32_t attempted_uploads_in,
    int32_t successful_uploads_in,
    int32_t attempted_reports_in,
    int32_t successful_reports_in,
    int32_t priority_in,
    int32_t weight_in,
    const ::url::Origin& origin_in,
    const std::string& group_name_in,
    const ::net::NetworkAnonymizationKey& network_anonymization_key_in,
    const std::optional<::base::UnguessableToken>& reporting_source_in)
    : url(std::move(url_in)),
      attempted_uploads(std::move(attempted_uploads_in)),
      successful_uploads(std::move(successful_uploads_in)),
      attempted_reports(std::move(attempted_reports_in)),
      successful_reports(std::move(successful_reports_in)),
      priority(std::move(priority_in)),
      weight(std::move(weight_in)),
      origin(std::move(origin_in)),
      group_name(std::move(group_name_in)),
      network_anonymization_key(std::move(network_anonymization_key_in)),
      reporting_source(std::move(reporting_source_in)) {}

ReportingApiEndpoint::~ReportingApiEndpoint() = default;

void ReportingApiEndpoint::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "url"), this->url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "attempted_uploads"), this->attempted_uploads,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "successful_uploads"), this->successful_uploads,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "attempted_reports"), this->attempted_reports,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "successful_reports"), this->successful_reports,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "priority"), this->priority,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "weight"), this->weight,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "origin"), this->origin,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::url::Origin&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "group_name"), this->group_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "network_anonymization_key"), this->network_anonymization_key,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::net::NetworkAnonymizationKey&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "reporting_source"), this->reporting_source,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::base::UnguessableToken>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ReportingApiEndpoint::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char ReportingApiObserver::Name_[] = "network.mojom.ReportingApiObserver";

ReportingApiObserver::IPCStableHashFunction ReportingApiObserver::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ReportingApiObserver>(message.name())) {
    case messages::ReportingApiObserver::kOnReportAdded: {
      return &ReportingApiObserver::OnReportAdded_Sym::IPCStableHash;
    }
    case messages::ReportingApiObserver::kOnReportUpdated: {
      return &ReportingApiObserver::OnReportUpdated_Sym::IPCStableHash;
    }
    case messages::ReportingApiObserver::kOnEndpointsUpdatedForOrigin: {
      return &ReportingApiObserver::OnEndpointsUpdatedForOrigin_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ReportingApiObserver::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ReportingApiObserver>(message.name())) {
      case messages::ReportingApiObserver::kOnReportAdded:
            return "Receive network::mojom::ReportingApiObserver::OnReportAdded";
      case messages::ReportingApiObserver::kOnReportUpdated:
            return "Receive network::mojom::ReportingApiObserver::OnReportUpdated";
      case messages::ReportingApiObserver::kOnEndpointsUpdatedForOrigin:
            return "Receive network::mojom::ReportingApiObserver::OnEndpointsUpdatedForOrigin";
    }
  } else {
    switch (static_cast<messages::ReportingApiObserver>(message.name())) {
      case messages::ReportingApiObserver::kOnReportAdded:
            return "Receive reply network::mojom::ReportingApiObserver::OnReportAdded";
      case messages::ReportingApiObserver::kOnReportUpdated:
            return "Receive reply network::mojom::ReportingApiObserver::OnReportUpdated";
      case messages::ReportingApiObserver::kOnEndpointsUpdatedForOrigin:
            return "Receive reply network::mojom::ReportingApiObserver::OnEndpointsUpdatedForOrigin";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ReportingApiObserver::OnReportAdded_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)network::mojom::ReportingApiObserver::OnReportAdded");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ReportingApiObserver::OnReportUpdated_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)network::mojom::ReportingApiObserver::OnReportUpdated");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ReportingApiObserver::OnEndpointsUpdatedForOrigin_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)network::mojom::ReportingApiObserver::OnEndpointsUpdatedForOrigin");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

ReportingApiObserverProxy::ReportingApiObserverProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ReportingApiObserverProxy::OnReportAdded(
    ReportingApiReportPtr in_report) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::ReportingApiObserver::OnReportAdded", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("report"), in_report,
                        "<value of type ReportingApiReportPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ReportingApiObserver::kOnReportAdded), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::ReportingApiObserver_OnReportAdded_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->report)::BaseType> report_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::ReportingApiReportDataView>(
      in_report, report_fragment);
  params->report.Set(
      report_fragment.is_null() ? nullptr : report_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->report.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null report in ReportingApiObserver.OnReportAdded request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ReportingApiObserver::Name_);
  message.set_method_name("OnReportAdded");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ReportingApiObserverProxy::OnReportUpdated(
    ReportingApiReportPtr in_report) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::ReportingApiObserver::OnReportUpdated", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("report"), in_report,
                        "<value of type ReportingApiReportPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ReportingApiObserver::kOnReportUpdated), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::ReportingApiObserver_OnReportUpdated_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->report)::BaseType> report_fragment(
          params.message());
  mojo::internal::Serialize<::network::mojom::ReportingApiReportDataView>(
      in_report, report_fragment);
  params->report.Set(
      report_fragment.is_null() ? nullptr : report_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->report.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null report in ReportingApiObserver.OnReportUpdated request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ReportingApiObserver::Name_);
  message.set_method_name("OnReportUpdated");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ReportingApiObserverProxy::OnEndpointsUpdatedForOrigin(
    std::vector<ReportingApiEndpointPtr> in_endpoints) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send network::mojom::ReportingApiObserver::OnEndpointsUpdatedForOrigin", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("endpoints"), in_endpoints,
                        "<value of type std::vector<ReportingApiEndpointPtr>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ReportingApiObserver::kOnEndpointsUpdatedForOrigin), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::network::mojom::internal::ReportingApiObserver_OnEndpointsUpdatedForOrigin_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->endpoints)::BaseType>
      endpoints_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& endpoints_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::ReportingApiEndpointDataView>>(
      in_endpoints, endpoints_fragment, &endpoints_validate_params);
  params->endpoints.Set(
      endpoints_fragment.is_null() ? nullptr : endpoints_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->endpoints.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null endpoints in ReportingApiObserver.OnEndpointsUpdatedForOrigin request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ReportingApiObserver::Name_);
  message.set_method_name("OnEndpointsUpdatedForOrigin");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool ReportingApiObserverStubDispatch::Accept(
    ReportingApiObserver* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ReportingApiObserver>(message->header()->name)) {
    case messages::ReportingApiObserver::kOnReportAdded: {
      DCHECK(message->is_serialized());
      internal::ReportingApiObserver_OnReportAdded_Params_Data* params =
          reinterpret_cast<internal::ReportingApiObserver_OnReportAdded_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for ReportingApiObserver.0
      bool success = true;
      ReportingApiReportPtr p_report{};
      ReportingApiObserver_OnReportAdded_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadReport(&p_report))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ReportingApiObserver::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnReportAdded(        
        std::move(p_report));
      return true;
    }
    case messages::ReportingApiObserver::kOnReportUpdated: {
      DCHECK(message->is_serialized());
      internal::ReportingApiObserver_OnReportUpdated_Params_Data* params =
          reinterpret_cast<internal::ReportingApiObserver_OnReportUpdated_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for ReportingApiObserver.1
      bool success = true;
      ReportingApiReportPtr p_report{};
      ReportingApiObserver_OnReportUpdated_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadReport(&p_report))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ReportingApiObserver::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnReportUpdated(        
        std::move(p_report));
      return true;
    }
    case messages::ReportingApiObserver::kOnEndpointsUpdatedForOrigin: {
      DCHECK(message->is_serialized());
      internal::ReportingApiObserver_OnEndpointsUpdatedForOrigin_Params_Data* params =
          reinterpret_cast<internal::ReportingApiObserver_OnEndpointsUpdatedForOrigin_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for ReportingApiObserver.2
      bool success = true;
      std::vector<ReportingApiEndpointPtr> p_endpoints{};
      ReportingApiObserver_OnEndpointsUpdatedForOrigin_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadEndpoints(&p_endpoints))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ReportingApiObserver::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnEndpointsUpdatedForOrigin(        
        std::move(p_endpoints));
      return true;
    }
  }
  return false;
}

// static
bool ReportingApiObserverStubDispatch::AcceptWithResponder(
    ReportingApiObserver* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ReportingApiObserver>(message->header()->name)) {
    case messages::ReportingApiObserver::kOnReportAdded: {
      break;
    }
    case messages::ReportingApiObserver::kOnReportUpdated: {
      break;
    }
    case messages::ReportingApiObserver::kOnEndpointsUpdatedForOrigin: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kReportingApiObserverValidationInfo[] = {
    {base::to_underlying(messages::ReportingApiObserver::kOnReportAdded),
     { &internal::ReportingApiObserver_OnReportAdded_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::ReportingApiObserver::kOnReportUpdated),
     { &internal::ReportingApiObserver_OnReportUpdated_Params_Data::Validate,
      nullptr /* no response */}},
    {base::to_underlying(messages::ReportingApiObserver::kOnEndpointsUpdatedForOrigin),
     { &internal::ReportingApiObserver_OnEndpointsUpdatedForOrigin_Params_Data::Validate,
      nullptr /* no response */}},
};

bool ReportingApiObserverRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::ReportingApiObserver::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kReportingApiObserverValidationInfo);
}



}  // network::mojom


namespace mojo {


// static
bool StructTraits<::network::mojom::ReportingApiReport::DataView, ::network::mojom::ReportingApiReportPtr>::Read(
    ::network::mojom::ReportingApiReport::DataView input,
    ::network::mojom::ReportingApiReportPtr* output) {
  bool success = true;
  ::network::mojom::ReportingApiReportPtr result(::network::mojom::ReportingApiReport::New());
  
      if (success && !input.ReadId(&result->id))
        success = false;
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success && !input.ReadGroup(&result->group))
        success = false;
      if (success && !input.ReadType(&result->type))
        success = false;
      if (success && !input.ReadTimestamp(&result->timestamp))
        success = false;
      if (success)
        result->depth = input.depth();
      if (success)
        result->attempts = input.attempts();
      if (success && !input.ReadBody(&result->body))
        success = false;
      if (success && !input.ReadStatus(&result->status))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::ReportingApiEndpoint::DataView, ::network::mojom::ReportingApiEndpointPtr>::Read(
    ::network::mojom::ReportingApiEndpoint::DataView input,
    ::network::mojom::ReportingApiEndpointPtr* output) {
  bool success = true;
  ::network::mojom::ReportingApiEndpointPtr result(::network::mojom::ReportingApiEndpoint::New());
  
      if (success && !input.ReadUrl(&result->url))
        success = false;
      if (success)
        result->attempted_uploads = input.attempted_uploads();
      if (success)
        result->successful_uploads = input.successful_uploads();
      if (success)
        result->attempted_reports = input.attempted_reports();
      if (success)
        result->successful_reports = input.successful_reports();
      if (success)
        result->priority = input.priority();
      if (success)
        result->weight = input.weight();
      if (success && !input.ReadOrigin(&result->origin))
        success = false;
      if (success && !input.ReadGroupName(&result->group_name))
        success = false;
      if (success && !input.ReadNetworkAnonymizationKey(&result->network_anonymization_key))
        success = false;
      if (success && !input.ReadReportingSource(&result->reporting_source))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace network::mojom {


void ReportingApiObserverInterceptorForTesting::OnReportAdded(ReportingApiReportPtr report) {
  GetForwardingInterface()->OnReportAdded(
    std::move(report)
    );
}
void ReportingApiObserverInterceptorForTesting::OnReportUpdated(ReportingApiReportPtr report) {
  GetForwardingInterface()->OnReportUpdated(
    std::move(report)
    );
}
void ReportingApiObserverInterceptorForTesting::OnEndpointsUpdatedForOrigin(std::vector<ReportingApiEndpointPtr> endpoints) {
  GetForwardingInterface()->OnEndpointsUpdatedForOrigin(
    std::move(endpoints)
    );
}
ReportingApiObserverAsyncWaiter::ReportingApiObserverAsyncWaiter(
    ReportingApiObserver* proxy) : proxy_(proxy) {}

ReportingApiObserverAsyncWaiter::~ReportingApiObserverAsyncWaiter() = default;






}  // network::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif