// third_party/blink/public/mojom/service_worker/controller_service_worker.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/service_worker/controller_service_worker.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/service_worker/controller_service_worker.mojom-params-data.h"
namespace blink {
namespace mojom {

namespace internal {


// static
bool ServiceWorkerRouterData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ServiceWorkerRouterData_Data* object =
      static_cast<const ServiceWorkerRouterData_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->router_rules, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->router_rules, validation_context))
    return false;


  if (!::blink::mojom::internal::ServiceWorkerEmbeddedWorkerStatus_Data
        ::Validate(object->initial_running_status, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterface(object->running_status_receiver,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->remote_cache_storage, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->remote_cache_storage,
                                                 validation_context)) {
    return false;
  }

  return true;
}

ServiceWorkerRouterData_Data::ServiceWorkerRouterData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ControllerServiceWorkerInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 80, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ControllerServiceWorkerInfo_Data* object =
      static_cast<const ControllerServiceWorkerInfo_Data*>(data);


  if (!::blink::mojom::internal::ControllerServiceWorkerMode_Data
        ::Validate(object->mode, validation_context))
    return false;


  if (!::blink::mojom::internal::ServiceWorkerFetchHandlerType_Data
        ::Validate(object->fetch_handler_type, validation_context))
    return false;


  if (!::blink::mojom::internal::ServiceWorkerFetchHandlerBypassOption_Data
        ::Validate(object->fetch_handler_bypass_option, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& sha256_script_checksum_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->sha256_script_checksum, validation_context,
                                         &sha256_script_checksum_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->router_data, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterface(object->remote_controller,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->client_id, 8, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& client_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->client_id, validation_context,
                                         &client_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->fetch_request_window_id, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->object_info, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->used_features, 11, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& used_features_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<0, false, ::blink::mojom::internal::WebFeature_Data::Validate>();
  if (!mojo::internal::ValidateContainer(object->used_features, validation_context,
                                         &used_features_validate_params)) {
    return false;
  }

  return true;
}

ControllerServiceWorkerInfo_Data::ControllerServiceWorkerInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ControllerServiceWorker_DispatchFetchEventForSubresource_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ControllerServiceWorker_DispatchFetchEventForSubresource_Params_Data* object =
      static_cast<const ControllerServiceWorker_DispatchFetchEventForSubresource_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->params, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->params, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->response_callback, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->response_callback,
                                                 validation_context)) {
    return false;
  }

  return true;
}

ControllerServiceWorker_DispatchFetchEventForSubresource_Params_Data::ControllerServiceWorker_DispatchFetchEventForSubresource_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ControllerServiceWorker_DispatchFetchEventForSubresource_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ControllerServiceWorker_DispatchFetchEventForSubresource_ResponseParams_Data* object =
      static_cast<const ControllerServiceWorker_DispatchFetchEventForSubresource_ResponseParams_Data*>(data);


  if (!::blink::mojom::internal::ServiceWorkerEventStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  return true;
}

ControllerServiceWorker_DispatchFetchEventForSubresource_ResponseParams_Data::ControllerServiceWorker_DispatchFetchEventForSubresource_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ControllerServiceWorker_Clone_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ControllerServiceWorker_Clone_Params_Data* object =
      static_cast<const ControllerServiceWorker_Clone_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receiver, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cross_origin_embedder_policy, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->cross_origin_embedder_policy, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterface(object->coep_reporter,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->document_isolation_policy, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->document_isolation_policy, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterface(object->dip_reporter,
                                                 validation_context)) {
    return false;
  }

  return true;
}

ControllerServiceWorker_Clone_Params_Data::ControllerServiceWorker_Clone_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ControllerServiceWorkerConnector_UpdateController_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ControllerServiceWorkerConnector_UpdateController_Params_Data* object =
      static_cast<const ControllerServiceWorkerConnector_UpdateController_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterface(object->controller,
                                                 validation_context)) {
    return false;
  }

  return true;
}

ControllerServiceWorkerConnector_UpdateController_Params_Data::ControllerServiceWorkerConnector_UpdateController_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink