/* parser auto-generated by pidl */

#include "replace.h"
#include "bin/default/librpc/gen_ndr/ndr_bkupblobs.h"

#include "librpc/gen_ndr/ndr_misc.h"
#include "librpc/gen_ndr/ndr_security.h"
#include "librpc/gen_ndr/ndr_fscc.h"
static enum ndr_err_code ndr_push_bkup_StreamId(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum bkup_StreamId r)
{
	NDR_CHECK(ndr_push_enum_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_bkup_StreamId(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum bkup_StreamId *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_enum_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_bkup_StreamId(struct ndr_print *ndr, const char *name, enum bkup_StreamId r)
{
	const char *val = NULL;

	switch (r) {
		case STREAM_ID_DATA: val = "STREAM_ID_DATA"; break;
		case STREAM_ID_EX_DATA: val = "STREAM_ID_EX_DATA"; break;
		case STREAM_ID_SECURITY_DATA: val = "STREAM_ID_SECURITY_DATA"; break;
		case STREAM_ID_ALTERNATE_DATA: val = "STREAM_ID_ALTERNATE_DATA"; break;
		case STREAM_ID_LINK: val = "STREAM_ID_LINK"; break;
		case STREAM_ID_OBJECTID: val = "STREAM_ID_OBJECTID"; break;
		case STREAM_ID_REPARSE_DATA: val = "STREAM_ID_REPARSE_DATA"; break;
		case STREAM_ID_SPARSE_BLOCK: val = "STREAM_ID_SPARSE_BLOCK"; break;
		case STREAM_ID_TXFS_DATA: val = "STREAM_ID_TXFS_DATA"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_bkup_StreamAttribute(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum bkup_StreamAttribute r)
{
	NDR_CHECK(ndr_push_enum_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_bkup_StreamAttribute(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum bkup_StreamAttribute *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_enum_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_bkup_StreamAttribute(struct ndr_print *ndr, const char *name, enum bkup_StreamAttribute r)
{
	const char *val = NULL;

	switch (r) {
		case STREAM_ATTRIBUTE_NORMAL: val = "STREAM_ATTRIBUTE_NORMAL"; break;
		case STREAM_ATTRIBUTE_SECURITY: val = "STREAM_ATTRIBUTE_SECURITY"; break;
		case STREAM_ATTRIBUTE_SPARSE: val = "STREAM_ATTRIBUTE_SPARSE"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_bkup_StreamData(struct ndr_push *ndr, ndr_flags_type ndr_flags, const union bkup_StreamData *r)
{
	uint32_t level;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_push_union_align(ndr, 5));
		switch (level) {
			default: {
				NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->blob));
			break; }

			case STREAM_ID_SECURITY_DATA: {
				{
					libndr_flags _flags_save_security_descriptor = ndr->flags;
					ndr_set_flags(&ndr->flags, LIBNDR_FLAG_ALIGN2);
					NDR_CHECK(ndr_push_security_descriptor(ndr, NDR_SCALARS, &r->sd));
					ndr->flags = _flags_save_security_descriptor;
				}
			break; }

			case STREAM_ID_OBJECTID: {
				NDR_CHECK(ndr_push_fscc_FileObjectIdBuffer_2(ndr, NDR_SCALARS, &r->object));
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			default:
			break;

			case STREAM_ID_SECURITY_DATA:
				{
					libndr_flags _flags_save_security_descriptor = ndr->flags;
					ndr_set_flags(&ndr->flags, LIBNDR_FLAG_ALIGN2);
					NDR_CHECK(ndr_push_security_descriptor(ndr, NDR_BUFFERS, &r->sd));
					ndr->flags = _flags_save_security_descriptor;
				}
			break;

			case STREAM_ID_OBJECTID:
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_bkup_StreamData(struct ndr_pull *ndr, ndr_flags_type ndr_flags, union bkup_StreamData *r)
{
	uint32_t level;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_pull_union_align(ndr, 5));
		switch (level) {
			default: {
				NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->blob));
			break; }

			case STREAM_ID_SECURITY_DATA: {
				{
					libndr_flags _flags_save_security_descriptor = ndr->flags;
					ndr_set_flags(&ndr->flags, LIBNDR_FLAG_ALIGN2);
					NDR_CHECK(ndr_pull_security_descriptor(ndr, NDR_SCALARS, &r->sd));
					ndr->flags = _flags_save_security_descriptor;
				}
			break; }

			case STREAM_ID_OBJECTID: {
				NDR_CHECK(ndr_pull_fscc_FileObjectIdBuffer_2(ndr, NDR_SCALARS, &r->object));
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			default:
			break;

			case STREAM_ID_SECURITY_DATA:
				{
					libndr_flags _flags_save_security_descriptor = ndr->flags;
					ndr_set_flags(&ndr->flags, LIBNDR_FLAG_ALIGN2);
					NDR_CHECK(ndr_pull_security_descriptor(ndr, NDR_BUFFERS, &r->sd));
					ndr->flags = _flags_save_security_descriptor;
				}
			break;

			case STREAM_ID_OBJECTID:
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_bkup_StreamData(struct ndr_print *ndr, const char *name, const union bkup_StreamData *r)
{
	uint32_t level;
	level = ndr_print_steal_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "bkup_StreamData");
	switch (level) {
		default:
			ndr_print_DATA_BLOB(ndr, "blob", r->blob);
		break;

		case STREAM_ID_SECURITY_DATA:
			{
				libndr_flags _flags_save_security_descriptor = ndr->flags;
				ndr_set_flags(&ndr->flags, LIBNDR_FLAG_ALIGN2);
				ndr_print_security_descriptor(ndr, "sd", &r->sd);
				ndr->flags = _flags_save_security_descriptor;
			}
		break;

		case STREAM_ID_OBJECTID:
			ndr_print_fscc_FileObjectIdBuffer_2(ndr, "object", &r->object);
		break;

	}
}

_PUBLIC_ enum ndr_err_code ndr_push_bkup_Win32StreamId(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct bkup_Win32StreamId *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 8));
		NDR_CHECK(ndr_push_bkup_StreamId(ndr, NDR_SCALARS, r->id));
		NDR_CHECK(ndr_push_bkup_StreamAttribute(ndr, NDR_SCALARS, r->attribute));
		NDR_CHECK(ndr_push_hyper(ndr, NDR_SCALARS, r->size));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->stream_name_size));
		{
			libndr_flags _flags_save_uint16 = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NOTERM);
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, r->stream_name, r->stream_name_size, sizeof(uint16_t), CH_UTF16));
			ndr->flags = _flags_save_uint16;
		}
		{
			libndr_flags _flags_save_bkup_StreamData = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			{
				struct ndr_push *_ndr_data;
				NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_data, 0, r->size));
				NDR_CHECK(ndr_push_set_switch_value(_ndr_data, &r->data, r->id));
				NDR_CHECK(ndr_push_bkup_StreamData(_ndr_data, NDR_SCALARS|NDR_BUFFERS, &r->data));
				NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_data, 0, r->size));
			}
			ndr->flags = _flags_save_bkup_StreamData;
		}
		NDR_CHECK(ndr_push_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			libndr_flags _flags_save_bkup_StreamData = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			ndr->flags = _flags_save_bkup_StreamData;
		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_bkup_Win32StreamId(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct bkup_Win32StreamId *r)
{
	uint32_t size_stream_name_0 = 0;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 8));
		NDR_CHECK(ndr_pull_bkup_StreamId(ndr, NDR_SCALARS, &r->id));
		NDR_CHECK(ndr_pull_bkup_StreamAttribute(ndr, NDR_SCALARS, &r->attribute));
		NDR_CHECK(ndr_pull_hyper(ndr, NDR_SCALARS, &r->size));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->stream_name_size));
		{
			libndr_flags _flags_save_uint16 = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NOTERM);
			size_stream_name_0 = r->stream_name_size;
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->stream_name, size_stream_name_0, sizeof(uint16_t), CH_UTF16));
			ndr->flags = _flags_save_uint16;
		}
		{
			libndr_flags _flags_save_bkup_StreamData = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			{
				struct ndr_pull *_ndr_data;
				ssize_t sub_size = r->size;
				NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_data, 0, sub_size));
				NDR_CHECK(ndr_pull_set_switch_value(_ndr_data, &r->data, r->id));
				NDR_CHECK(ndr_pull_bkup_StreamData(_ndr_data, NDR_SCALARS|NDR_BUFFERS, &r->data));
				NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_data, 0, sub_size));
			}
			ndr->flags = _flags_save_bkup_StreamData;
		}
		NDR_CHECK(ndr_pull_trailer_align(ndr, 8));
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			libndr_flags _flags_save_bkup_StreamData = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			ndr->flags = _flags_save_bkup_StreamData;
		}
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_bkup_Win32StreamId(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct bkup_Win32StreamId *r)
{
	ndr_print_bkup_Win32StreamId(ndr, name, r);
}

_PUBLIC_ void ndr_print_bkup_Win32StreamId(struct ndr_print *ndr, const char *name, const struct bkup_Win32StreamId *r)
{
	ndr_print_struct(ndr, name, "bkup_Win32StreamId");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_bkup_StreamId(ndr, "id", r->id);
	ndr_print_bkup_StreamAttribute(ndr, "attribute", r->attribute);
	ndr_print_hyper(ndr, "size", r->size);
	ndr_print_uint32(ndr, "stream_name_size", r->stream_name_size);
	{
		libndr_flags _flags_save_uint16 = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_STR_NOTERM);
		ndr_print_string(ndr, "stream_name", r->stream_name);
		ndr->flags = _flags_save_uint16;
	}
	{
		libndr_flags _flags_save_bkup_StreamData = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
		ndr_print_set_switch_value(ndr, &r->data, r->id);
		ndr_print_bkup_StreamData(ndr, "data", &r->data);
		ndr->flags = _flags_save_bkup_StreamData;
	}
	ndr->depth--;
}

static void ndr_print_flags_bkup_NTBackupFile(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct bkup_NTBackupFile *r)
{
	ndr_print_bkup_NTBackupFile(ndr, name, r);
}

_PUBLIC_ void ndr_print_bkup_NTBackupFile(struct ndr_print *ndr, const char *name, const struct bkup_NTBackupFile *r)
{
	uint32_t cntr_streams_0;
	ndr_print_struct(ndr, name, "bkup_NTBackupFile");
	if (r == NULL) { ndr_print_null(ndr); return; }
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN);
		ndr->depth++;
		ndr_print_uint32(ndr, "num_stream", r->num_stream);
		ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "streams", (uint32_t)(r->num_stream));
		ndr->depth++;
		for (cntr_streams_0 = 0; cntr_streams_0 < (r->num_stream); cntr_streams_0++) {
			ndr_print_bkup_Win32StreamId(ndr, "streams", &r->streams[cntr_streams_0]);
		}
		ndr->depth--;
		ndr->depth--;
		ndr->flags = _flags_save_STRUCT;
	}
}

#ifndef SKIP_NDR_TABLE_bkupblobs
static const struct ndr_interface_public_struct bkupblobs_public_structs[] = {
	{
		.name = "bkup_Win32StreamId",
		.struct_size = sizeof(struct bkup_Win32StreamId ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_bkup_Win32StreamId,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_bkup_Win32StreamId,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_bkup_Win32StreamId,
	},
	{
		.name = "bkup_NTBackupFile",
		.struct_size = sizeof(struct bkup_NTBackupFile ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_bkup_NTBackupFile,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_bkup_NTBackupFile,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_bkup_NTBackupFile,
	},
	{ .name = NULL }
};

static const struct ndr_interface_call bkupblobs_calls[] = {
	{ .name = NULL }
};

static const char * const bkupblobs_endpoint_strings[] = {
	"ncacn_np:[\\pipe\\bkupblobs]", 
};

static const struct ndr_interface_string_array bkupblobs_endpoints = {
	.count	= 1,
	.names	= bkupblobs_endpoint_strings
};

static const char * const bkupblobs_authservice_strings[] = {
	"host", 
};

static const struct ndr_interface_string_array bkupblobs_authservices = {
	.count	= 1,
	.names	= bkupblobs_authservice_strings
};


const struct ndr_interface_table ndr_table_bkupblobs = {
	.name		= "bkupblobs",
	.num_calls	= 0,
	.calls		= bkupblobs_calls,
	.num_public_structs	= 2,
	.public_structs		= bkupblobs_public_structs,
	.endpoints	= &bkupblobs_endpoints,
	.authservices	= &bkupblobs_authservices
};

#endif /* SKIP_NDR_TABLE_bkupblobs */
