/* GamepadSlideController.c generated by valac 0.56.18, the Vala compiler
 * generated from GamepadSlideController.vala, do not modify */

/*
* Copyright (c) 2017 Felipe Escoto (https://github.com/Philip-Scott/Spice-up)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 59 Temple Place - Suite 330,
* Boston, MA 02111-1307, USA.
*
* Authored by: Felipe Escoto <felescoto95@hotmail.com>
*/

#include <glib-object.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <granite.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <json-glib/json-glib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define SPICE_TYPE_GAMEPAD_SLIDE_CONTROLLER (spice_gamepad_slide_controller_get_type ())
#define SPICE_GAMEPAD_SLIDE_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_TYPE_GAMEPAD_SLIDE_CONTROLLER, SpiceGamepadSlideController))
#define SPICE_GAMEPAD_SLIDE_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_TYPE_GAMEPAD_SLIDE_CONTROLLER, SpiceGamepadSlideControllerClass))
#define SPICE_IS_GAMEPAD_SLIDE_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_TYPE_GAMEPAD_SLIDE_CONTROLLER))
#define SPICE_IS_GAMEPAD_SLIDE_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_TYPE_GAMEPAD_SLIDE_CONTROLLER))
#define SPICE_GAMEPAD_SLIDE_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_TYPE_GAMEPAD_SLIDE_CONTROLLER, SpiceGamepadSlideControllerClass))

typedef struct _SpiceGamepadSlideController SpiceGamepadSlideController;
typedef struct _SpiceGamepadSlideControllerClass SpiceGamepadSlideControllerClass;
typedef struct _SpiceGamepadSlideControllerPrivate SpiceGamepadSlideControllerPrivate;

#define SPICE_TYPE_SLIDE_MANAGER (spice_slide_manager_get_type ())
#define SPICE_SLIDE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_TYPE_SLIDE_MANAGER, SpiceSlideManager))
#define SPICE_SLIDE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_TYPE_SLIDE_MANAGER, SpiceSlideManagerClass))
#define SPICE_IS_SLIDE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_TYPE_SLIDE_MANAGER))
#define SPICE_IS_SLIDE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_TYPE_SLIDE_MANAGER))
#define SPICE_SLIDE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_TYPE_SLIDE_MANAGER, SpiceSlideManagerClass))

typedef struct _SpiceSlideManager SpiceSlideManager;
typedef struct _SpiceSlideManagerClass SpiceSlideManagerClass;

#define SPICE_TYPE_WINDOW (spice_window_get_type ())
#define SPICE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_TYPE_WINDOW, SpiceWindow))
#define SPICE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_TYPE_WINDOW, SpiceWindowClass))
#define SPICE_IS_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_TYPE_WINDOW))
#define SPICE_IS_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_TYPE_WINDOW))
#define SPICE_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_TYPE_WINDOW, SpiceWindowClass))

typedef struct _SpiceWindow SpiceWindow;
typedef struct _SpiceWindowClass SpiceWindowClass;

#define LIB_GAMEPAD_TYPE_GAMEPAD_MONITOR (lib_gamepad_gamepad_monitor_get_type ())
#define LIB_GAMEPAD_GAMEPAD_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), LIB_GAMEPAD_TYPE_GAMEPAD_MONITOR, LibGamepadGamepadMonitor))
#define LIB_GAMEPAD_GAMEPAD_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), LIB_GAMEPAD_TYPE_GAMEPAD_MONITOR, LibGamepadGamepadMonitorClass))
#define LIB_GAMEPAD_IS_GAMEPAD_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), LIB_GAMEPAD_TYPE_GAMEPAD_MONITOR))
#define LIB_GAMEPAD_IS_GAMEPAD_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), LIB_GAMEPAD_TYPE_GAMEPAD_MONITOR))
#define LIB_GAMEPAD_GAMEPAD_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), LIB_GAMEPAD_TYPE_GAMEPAD_MONITOR, LibGamepadGamepadMonitorClass))

typedef struct _LibGamepadGamepadMonitor LibGamepadGamepadMonitor;
typedef struct _LibGamepadGamepadMonitorClass LibGamepadGamepadMonitorClass;

#define LIB_GAMEPAD_TYPE_GAMEPAD (lib_gamepad_gamepad_get_type ())
#define LIB_GAMEPAD_GAMEPAD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), LIB_GAMEPAD_TYPE_GAMEPAD, LibGamepadGamepad))
#define LIB_GAMEPAD_GAMEPAD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), LIB_GAMEPAD_TYPE_GAMEPAD, LibGamepadGamepadClass))
#define LIB_GAMEPAD_IS_GAMEPAD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), LIB_GAMEPAD_TYPE_GAMEPAD))
#define LIB_GAMEPAD_IS_GAMEPAD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), LIB_GAMEPAD_TYPE_GAMEPAD))
#define LIB_GAMEPAD_GAMEPAD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), LIB_GAMEPAD_TYPE_GAMEPAD, LibGamepadGamepadClass))

typedef struct _LibGamepadGamepad LibGamepadGamepad;
typedef struct _LibGamepadGamepadClass LibGamepadGamepadClass;

#define SPICE_GAMEPAD_SLIDE_CONTROLLER_TYPE_CONTROLER_CONFIGURATION (spice_gamepad_slide_controller_controler_configuration_get_type ())
#define SPICE_GAMEPAD_SLIDE_CONTROLLER_CONTROLER_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_GAMEPAD_SLIDE_CONTROLLER_TYPE_CONTROLER_CONFIGURATION, SpiceGamepadSlideControllerControlerConfiguration))
#define SPICE_GAMEPAD_SLIDE_CONTROLLER_CONTROLER_CONFIGURATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_GAMEPAD_SLIDE_CONTROLLER_TYPE_CONTROLER_CONFIGURATION, SpiceGamepadSlideControllerControlerConfigurationClass))
#define SPICE_GAMEPAD_SLIDE_CONTROLLER_IS_CONTROLER_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_GAMEPAD_SLIDE_CONTROLLER_TYPE_CONTROLER_CONFIGURATION))
#define SPICE_GAMEPAD_SLIDE_CONTROLLER_IS_CONTROLER_CONFIGURATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_GAMEPAD_SLIDE_CONTROLLER_TYPE_CONTROLER_CONFIGURATION))
#define SPICE_GAMEPAD_SLIDE_CONTROLLER_CONTROLER_CONFIGURATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_GAMEPAD_SLIDE_CONTROLLER_TYPE_CONTROLER_CONFIGURATION, SpiceGamepadSlideControllerControlerConfigurationClass))

typedef struct _SpiceGamepadSlideControllerControlerConfiguration SpiceGamepadSlideControllerControlerConfiguration;
typedef struct _SpiceGamepadSlideControllerControlerConfigurationClass SpiceGamepadSlideControllerControlerConfigurationClass;
enum  {
	SPICE_GAMEPAD_SLIDE_CONTROLLER_0_PROPERTY,
	SPICE_GAMEPAD_SLIDE_CONTROLLER_NUM_PROPERTIES
};
static GParamSpec* spice_gamepad_slide_controller_properties[SPICE_GAMEPAD_SLIDE_CONTROLLER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef void (*LibGamepadGamepadMonitorGamepadCallback) (LibGamepadGamepad* gamepad, gpointer user_data);
typedef struct _Block8Data Block8Data;

#define LIB_GAMEPAD_TYPE_RAW_GAMEPAD (lib_gamepad_raw_gamepad_get_type ())
#define LIB_GAMEPAD_RAW_GAMEPAD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), LIB_GAMEPAD_TYPE_RAW_GAMEPAD, LibGamepadRawGamepad))
#define LIB_GAMEPAD_IS_RAW_GAMEPAD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), LIB_GAMEPAD_TYPE_RAW_GAMEPAD))
#define LIB_GAMEPAD_RAW_GAMEPAD_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), LIB_GAMEPAD_TYPE_RAW_GAMEPAD, LibGamepadRawGamepadIface))

typedef struct _LibGamepadRawGamepad LibGamepadRawGamepad;
typedef struct _LibGamepadRawGamepadIface LibGamepadRawGamepadIface;
#define _g_free0(var) (var = (g_free (var), NULL))

#define SPICE_GAMEPAD_SLIDE_CONTROLLER_TYPE_CONTROLLER_CONFIGURATION_DIALOG (spice_gamepad_slide_controller_controller_configuration_dialog_get_type ())
#define SPICE_GAMEPAD_SLIDE_CONTROLLER_CONTROLLER_CONFIGURATION_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_GAMEPAD_SLIDE_CONTROLLER_TYPE_CONTROLLER_CONFIGURATION_DIALOG, SpiceGamepadSlideControllerControllerConfigurationDialog))
#define SPICE_GAMEPAD_SLIDE_CONTROLLER_CONTROLLER_CONFIGURATION_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_GAMEPAD_SLIDE_CONTROLLER_TYPE_CONTROLLER_CONFIGURATION_DIALOG, SpiceGamepadSlideControllerControllerConfigurationDialogClass))
#define SPICE_GAMEPAD_SLIDE_CONTROLLER_IS_CONTROLLER_CONFIGURATION_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_GAMEPAD_SLIDE_CONTROLLER_TYPE_CONTROLLER_CONFIGURATION_DIALOG))
#define SPICE_GAMEPAD_SLIDE_CONTROLLER_IS_CONTROLLER_CONFIGURATION_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_GAMEPAD_SLIDE_CONTROLLER_TYPE_CONTROLLER_CONFIGURATION_DIALOG))
#define SPICE_GAMEPAD_SLIDE_CONTROLLER_CONTROLLER_CONFIGURATION_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_GAMEPAD_SLIDE_CONTROLLER_TYPE_CONTROLLER_CONFIGURATION_DIALOG, SpiceGamepadSlideControllerControllerConfigurationDialogClass))

typedef struct _SpiceGamepadSlideControllerControllerConfigurationDialog SpiceGamepadSlideControllerControllerConfigurationDialog;
typedef struct _SpiceGamepadSlideControllerControllerConfigurationDialogClass SpiceGamepadSlideControllerControllerConfigurationDialogClass;
typedef struct _SpiceGamepadSlideControllerControlerConfigurationPrivate SpiceGamepadSlideControllerControlerConfigurationPrivate;
typedef struct _SpiceGamepadSlideControllerControllerConfigurationDialogPrivate SpiceGamepadSlideControllerControllerConfigurationDialogPrivate;
enum  {
	SPICE_GAMEPAD_SLIDE_CONTROLLER_CONTROLLER_CONFIGURATION_DIALOG_0_PROPERTY,
	SPICE_GAMEPAD_SLIDE_CONTROLLER_CONTROLLER_CONFIGURATION_DIALOG_NUM_PROPERTIES
};
static GParamSpec* spice_gamepad_slide_controller_controller_configuration_dialog_properties[SPICE_GAMEPAD_SLIDE_CONTROLLER_CONTROLLER_CONFIGURATION_DIALOG_NUM_PROPERTIES];
typedef struct _Block9Data Block9Data;
typedef struct _Block10Data Block10Data;
enum  {
	SPICE_GAMEPAD_SLIDE_CONTROLLER_CONTROLER_CONFIGURATION_0_PROPERTY,
	SPICE_GAMEPAD_SLIDE_CONTROLLER_CONTROLER_CONFIGURATION_NUM_PROPERTIES
};
static GParamSpec* spice_gamepad_slide_controller_controler_configuration_properties[SPICE_GAMEPAD_SLIDE_CONTROLLER_CONTROLER_CONFIGURATION_NUM_PROPERTIES];
#define _g_array_unref0(var) ((var == NULL) ? NULL : (var = (g_array_unref (var), NULL)))

#define SPICE_SERVICES_TYPE_SETTINGS (spice_services_settings_get_type ())
#define SPICE_SERVICES_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SPICE_SERVICES_TYPE_SETTINGS, SpiceServicesSettings))
#define SPICE_SERVICES_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SPICE_SERVICES_TYPE_SETTINGS, SpiceServicesSettingsClass))
#define SPICE_SERVICES_IS_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SPICE_SERVICES_TYPE_SETTINGS))
#define SPICE_SERVICES_IS_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SPICE_SERVICES_TYPE_SETTINGS))
#define SPICE_SERVICES_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SPICE_SERVICES_TYPE_SETTINGS, SpiceServicesSettingsClass))

typedef struct _SpiceServicesSettings SpiceServicesSettings;
typedef struct _SpiceServicesSettingsClass SpiceServicesSettingsClass;
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
enum  {
	SPICE_GAMEPAD_SLIDE_CONTROLLER_RAW_BUTTON_SIGNAL,
	SPICE_GAMEPAD_SLIDE_CONTROLLER_NUM_SIGNALS
};
static guint spice_gamepad_slide_controller_signals[SPICE_GAMEPAD_SLIDE_CONTROLLER_NUM_SIGNALS] = {0};

struct _SpiceGamepadSlideController {
	GObject parent_instance;
	SpiceGamepadSlideControllerPrivate * priv;
	gboolean editing;
};

struct _SpiceGamepadSlideControllerClass {
	GObjectClass parent_class;
};

struct _SpiceGamepadSlideControllerPrivate {
	SpiceSlideManager* slide_manager;
	SpiceWindow* window;
	LibGamepadGamepadMonitor* gamepad_monitor;
	LibGamepadGamepad** gamepads;
	gint gamepads_length1;
	gint _gamepads_size_;
	GraniteWidgetsToast* toast;
	SpiceGamepadSlideControllerControlerConfiguration* config;
};

struct _Block8Data {
	int _ref_count_;
	SpiceGamepadSlideController* self;
	LibGamepadGamepad* gamepad;
};

struct _LibGamepadRawGamepadIface {
	GTypeInterface parent_iface;
	const gchar* (*get_identifier) (LibGamepadRawGamepad* self);
	const gchar* (*get_name) (LibGamepadRawGamepad* self);
	const gchar* (*get_guid) (LibGamepadRawGamepad* self);
	guint8 (*get_axes_number) (LibGamepadRawGamepad* self);
	guint8 (*get_buttons_number) (LibGamepadRawGamepad* self);
	guint8 (*get_dpads_number) (LibGamepadRawGamepad* self);
};

struct _SpiceGamepadSlideControllerControlerConfiguration {
	GObject parent_instance;
	SpiceGamepadSlideControllerControlerConfigurationPrivate * priv;
	gint next;
	gint back;
	gint checkpoint;
	gint jump;
	gint home;
};

struct _SpiceGamepadSlideControllerControlerConfigurationClass {
	GObjectClass parent_class;
};

struct _SpiceGamepadSlideControllerControllerConfigurationDialog {
	GtkDialog parent_instance;
	SpiceGamepadSlideControllerControllerConfigurationDialogPrivate * priv;
};

struct _SpiceGamepadSlideControllerControllerConfigurationDialogClass {
	GtkDialogClass parent_class;
};

struct _SpiceGamepadSlideControllerControllerConfigurationDialogPrivate {
	SpiceGamepadSlideControllerControlerConfiguration* config;
	SpiceGamepadSlideController* monitor;
	GtkGrid* grid;
	GtkWidget* save_button;
	gboolean listening;
	gint** listening_action;
	GtkButton* listening_button;
	gint row;
};

struct _Block9Data {
	int _ref_count_;
	SpiceGamepadSlideControllerControllerConfigurationDialog* self;
	SpiceGamepadSlideController* monitor;
};

struct _Block10Data {
	int _ref_count_;
	SpiceGamepadSlideControllerControllerConfigurationDialog* self;
	GtkButton* button;
	gint* action;
};

static gint SpiceGamepadSlideController_private_offset;
static gpointer spice_gamepad_slide_controller_parent_class = NULL;
static SpiceGamepadSlideController* spice_gamepad_slide_controller_instance;
static SpiceGamepadSlideController* spice_gamepad_slide_controller_instance = NULL;
static gint SpiceGamepadSlideControllerControllerConfigurationDialog_private_offset;
static gpointer spice_gamepad_slide_controller_controller_configuration_dialog_parent_class = NULL;
static gpointer spice_gamepad_slide_controller_controler_configuration_parent_class = NULL;

VALA_EXTERN GType spice_gamepad_slide_controller_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceGamepadSlideController, g_object_unref)
VALA_EXTERN GType spice_slide_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceSlideManager, g_object_unref)
VALA_EXTERN GType spice_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceWindow, g_object_unref)
VALA_EXTERN GType lib_gamepad_gamepad_monitor_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LibGamepadGamepadMonitor, g_object_unref)
VALA_EXTERN GType lib_gamepad_gamepad_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LibGamepadGamepad, g_object_unref)
static GType spice_gamepad_slide_controller_controler_configuration_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceGamepadSlideControllerControlerConfiguration, g_object_unref)
VALA_EXTERN void spice_gamepad_slide_controller_startup (SpiceSlideManager* _slide_manager,
                                             SpiceWindow* window);
static SpiceGamepadSlideController* spice_gamepad_slide_controller_new (SpiceWindow* window);
static SpiceGamepadSlideController* spice_gamepad_slide_controller_construct (GType object_type,
                                                                       SpiceWindow* window);
VALA_EXTERN LibGamepadGamepadMonitor* lib_gamepad_gamepad_monitor_new (void);
VALA_EXTERN LibGamepadGamepadMonitor* lib_gamepad_gamepad_monitor_construct (GType object_type);
static void spice_gamepad_slide_controller_connect_gamepad (SpiceGamepadSlideController* self,
                                                     LibGamepadGamepad* gamepad);
static void _spice_gamepad_slide_controller_connect_gamepad_lib_gamepad_gamepad_monitor_gamepad_plugged (LibGamepadGamepadMonitor* _sender,
                                                                                                  LibGamepadGamepad* gamepad,
                                                                                                  gpointer self);
VALA_EXTERN void lib_gamepad_gamepad_monitor_foreach_gamepad (LibGamepadGamepadMonitor* self,
                                                  LibGamepadGamepadMonitorGamepadCallback callback,
                                                  gpointer callback_target);
static void _spice_gamepad_slide_controller_connect_gamepad_lib_gamepad_gamepad_monitor_gamepad_callback (LibGamepadGamepad* gamepad,
                                                                                                   gpointer self);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (void * _userdata_);
VALA_EXTERN GType lib_gamepad_raw_gamepad_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LibGamepadRawGamepad, g_object_unref)
VALA_EXTERN LibGamepadRawGamepad* lib_gamepad_gamepad_get_raw_gamepad (LibGamepadGamepad* self);
VALA_EXTERN const gchar* lib_gamepad_raw_gamepad_get_identifier (LibGamepadRawGamepad* self);
VALA_EXTERN const gchar* lib_gamepad_gamepad_get_raw_name (LibGamepadGamepad* self);
static void _vala_array_add1 (LibGamepadGamepad** * array,
                       gint* length,
                       gint* size,
                       LibGamepadGamepad* value);
static SpiceGamepadSlideControllerControlerConfiguration* spice_gamepad_slide_controller_controler_configuration_new (void);
static SpiceGamepadSlideControllerControlerConfiguration* spice_gamepad_slide_controller_controler_configuration_construct (GType object_type);
static void spice_gamepad_slide_controller_button_event (SpiceGamepadSlideController* self,
                                                  gint button);
static void _spice_gamepad_slide_controller_button_event_lib_gamepad_gamepad_button_event (LibGamepadGamepad* _sender,
                                                                                    gint button,
                                                                                    gpointer self);
static void __lambda138_ (Block8Data* _data8_);
static void ___lambda138__lib_gamepad_gamepad_unplugged (LibGamepadGamepad* _sender,
                                                  gpointer self);
static void spice_gamepad_slide_controller_show_controller_toast (SpiceGamepadSlideController* self);
static void ___lambda139_ (SpiceGamepadSlideController* self);
static GType spice_gamepad_slide_controller_controller_configuration_dialog_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceGamepadSlideControllerControllerConfigurationDialog, g_object_unref)
static SpiceGamepadSlideControllerControllerConfigurationDialog* spice_gamepad_slide_controller_controller_configuration_dialog_new (SpiceGamepadSlideController* monitor,
                                                                                                                              SpiceGamepadSlideControllerControlerConfiguration* _config);
static SpiceGamepadSlideControllerControllerConfigurationDialog* spice_gamepad_slide_controller_controller_configuration_dialog_construct (GType object_type,
                                                                                                                                    SpiceGamepadSlideController* monitor,
                                                                                                                                    SpiceGamepadSlideControllerControlerConfiguration* _config);
static void ____lambda139__granite_widgets_toast_default_action (GraniteWidgetsToast* _sender,
                                                          gpointer self);
VALA_EXTERN void spice_window_add_toast_notification (SpiceWindow* self,
                                          GraniteWidgetsToast* toast);
static void spice_gamepad_slide_controller_next_slide (SpiceGamepadSlideController* self);
static void spice_gamepad_slide_controller_previous_slide (SpiceGamepadSlideController* self);
static void spice_gamepad_slide_controller_set_checkpoint (SpiceGamepadSlideController* self);
static void spice_gamepad_slide_controller_jump_to_checkpoint (SpiceGamepadSlideController* self);
static void spice_gamepad_slide_controller_toggle_present (SpiceGamepadSlideController* self);
VALA_EXTERN void spice_slide_manager_jump_to_checkpoint (SpiceSlideManager* self);
VALA_EXTERN void spice_slide_manager_set_checkpoint (SpiceSlideManager* self);
VALA_EXTERN gboolean spice_window_get_is_presenting (SpiceWindow* self);
VALA_EXTERN void spice_slide_manager_next_slide (SpiceSlideManager* self);
VALA_EXTERN void spice_slide_manager_previous_slide (SpiceSlideManager* self);
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (void * _userdata_);
static void spice_gamepad_slide_controller_controller_configuration_dialog_add_row (SpiceGamepadSlideControllerControllerConfigurationDialog* self,
                                                                             const gchar* name,
                                                                             gint* action);
static void __lambda141_ (Block9Data* _data9_,
                   gint ID);
static void spice_gamepad_slide_controller_controler_configuration_save (SpiceGamepadSlideControllerControlerConfiguration* self);
static void ___lambda141__gtk_dialog_response (GtkDialog* _sender,
                                        gint response_id,
                                        gpointer self);
static void __lambda142_ (SpiceGamepadSlideControllerControllerConfigurationDialog* self,
                   gint id);
static gboolean spice_gamepad_slide_controller_controler_configuration_is_valid (SpiceGamepadSlideControllerControlerConfiguration* self);
static void ___lambda142__spice_gamepad_slide_controller_raw_button (SpiceGamepadSlideController* _sender,
                                                              gint button,
                                                              gpointer self);
static Block10Data* block10_data_ref (Block10Data* _data10_);
static void block10_data_unref (void * _userdata_);
static void __lambda140_ (Block10Data* _data10_);
static void ___lambda140__gtk_button_clicked (GtkButton* _sender,
                                       gpointer self);
static void spice_gamepad_slide_controller_controller_configuration_dialog_finalize (GObject * obj);
static GType spice_gamepad_slide_controller_controller_configuration_dialog_get_type_once (void);
static void spice_gamepad_slide_controller_controler_configuration_load (SpiceGamepadSlideControllerControlerConfiguration* self);
static gboolean _vala_int_array_contains (gint * stack,
                                   gssize stack_length,
                                   const gint needle);
VALA_EXTERN GType spice_services_settings_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SpiceServicesSettings, g_object_unref)
VALA_EXTERN SpiceServicesSettings* spice_services_settings_get_instance (void);
VALA_EXTERN const gchar* spice_services_settings_get_controler_config (SpiceServicesSettings* self);
VALA_EXTERN void spice_services_settings_set_controler_config (SpiceServicesSettings* self,
                                                   const gchar* value);
static void spice_gamepad_slide_controller_controler_configuration_finalize (GObject * obj);
static GType spice_gamepad_slide_controller_controler_configuration_get_type_once (void);
static void spice_gamepad_slide_controller_finalize (GObject * obj);
static GType spice_gamepad_slide_controller_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
spice_gamepad_slide_controller_get_instance_private (SpiceGamepadSlideController* self)
{
	return G_STRUCT_MEMBER_P (self, SpiceGamepadSlideController_private_offset);
}

void
spice_gamepad_slide_controller_startup (SpiceSlideManager* _slide_manager,
                                        SpiceWindow* window)
{
	SpiceGamepadSlideController* _tmp0_;
	SpiceGamepadSlideController* _tmp2_;
#line 37 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	g_return_if_fail (_slide_manager != NULL);
#line 37 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	g_return_if_fail (window != NULL);
#line 38 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_tmp0_ = spice_gamepad_slide_controller_instance;
#line 38 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	if (_tmp0_ == NULL) {
#line 403 "GamepadSlideController.c"
		SpiceGamepadSlideController* _tmp1_;
#line 39 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		_tmp1_ = spice_gamepad_slide_controller_new (window);
#line 39 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		_g_object_unref0 (spice_gamepad_slide_controller_instance);
#line 39 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		spice_gamepad_slide_controller_instance = _tmp1_;
#line 411 "GamepadSlideController.c"
	}
#line 42 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_tmp2_ = spice_gamepad_slide_controller_instance;
#line 42 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_tmp2_->priv->slide_manager = _slide_manager;
#line 417 "GamepadSlideController.c"
}

static void
_spice_gamepad_slide_controller_connect_gamepad_lib_gamepad_gamepad_monitor_gamepad_plugged (LibGamepadGamepadMonitor* _sender,
                                                                                             LibGamepadGamepad* gamepad,
                                                                                             gpointer self)
{
#line 49 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	spice_gamepad_slide_controller_connect_gamepad ((SpiceGamepadSlideController*) self, gamepad);
#line 427 "GamepadSlideController.c"
}

static void
_spice_gamepad_slide_controller_connect_gamepad_lib_gamepad_gamepad_monitor_gamepad_callback (LibGamepadGamepad* gamepad,
                                                                                              gpointer self)
{
#line 50 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	spice_gamepad_slide_controller_connect_gamepad ((SpiceGamepadSlideController*) self, gamepad);
#line 436 "GamepadSlideController.c"
}

static SpiceGamepadSlideController*
spice_gamepad_slide_controller_construct (GType object_type,
                                          SpiceWindow* window)
{
	SpiceGamepadSlideController * self = NULL;
	LibGamepadGamepadMonitor* _tmp0_;
	LibGamepadGamepadMonitor* _tmp1_;
	LibGamepadGamepadMonitor* _tmp2_;
#line 45 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	g_return_val_if_fail (window != NULL, NULL);
#line 45 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	self = (SpiceGamepadSlideController*) g_object_new (object_type, NULL);
#line 46 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	self->priv->window = window;
#line 47 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_tmp0_ = lib_gamepad_gamepad_monitor_new ();
#line 47 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_g_object_unref0 (self->priv->gamepad_monitor);
#line 47 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	self->priv->gamepad_monitor = _tmp0_;
#line 49 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_tmp1_ = self->priv->gamepad_monitor;
#line 49 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	g_signal_connect_object (_tmp1_, "gamepad-plugged", (GCallback) _spice_gamepad_slide_controller_connect_gamepad_lib_gamepad_gamepad_monitor_gamepad_plugged, self, 0);
#line 50 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_tmp2_ = self->priv->gamepad_monitor;
#line 50 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	lib_gamepad_gamepad_monitor_foreach_gamepad (_tmp2_, _spice_gamepad_slide_controller_connect_gamepad_lib_gamepad_gamepad_monitor_gamepad_callback, self);
#line 45 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	return self;
#line 469 "GamepadSlideController.c"
}

static SpiceGamepadSlideController*
spice_gamepad_slide_controller_new (SpiceWindow* window)
{
#line 45 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	return spice_gamepad_slide_controller_construct (SPICE_TYPE_GAMEPAD_SLIDE_CONTROLLER, window);
#line 477 "GamepadSlideController.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 53 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	return self ? g_object_ref (self) : NULL;
#line 485 "GamepadSlideController.c"
}

static Block8Data*
block8_data_ref (Block8Data* _data8_)
{
#line 53 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	g_atomic_int_inc (&_data8_->_ref_count_);
#line 53 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	return _data8_;
#line 495 "GamepadSlideController.c"
}

static void
block8_data_unref (void * _userdata_)
{
	Block8Data* _data8_;
	_data8_ = (Block8Data*) _userdata_;
#line 53 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
#line 505 "GamepadSlideController.c"
		SpiceGamepadSlideController* self;
#line 53 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		self = _data8_->self;
#line 53 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		_g_object_unref0 (_data8_->gamepad);
#line 53 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		_g_object_unref0 (self);
#line 53 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		g_slice_free (Block8Data, _data8_);
#line 515 "GamepadSlideController.c"
	}
}

static void
_vala_array_add1 (LibGamepadGamepad** * array,
                  gint* length,
                  gint* size,
                  LibGamepadGamepad* value)
{
#line 55 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	if ((*length) == (*size)) {
#line 55 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 55 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		*array = g_renew (LibGamepadGamepad*, *array, (*size) + 1);
#line 531 "GamepadSlideController.c"
	}
#line 55 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	(*array)[(*length)++] = value;
#line 55 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	(*array)[*length] = NULL;
#line 537 "GamepadSlideController.c"
}

static void
_spice_gamepad_slide_controller_button_event_lib_gamepad_gamepad_button_event (LibGamepadGamepad* _sender,
                                                                               gint button,
                                                                               gpointer self)
{
#line 59 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	spice_gamepad_slide_controller_button_event ((SpiceGamepadSlideController*) self, button);
#line 547 "GamepadSlideController.c"
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
#line 1624 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1625 "glib-2.0.vapi"
	result = self;
#line 1625 "glib-2.0.vapi"
	return result;
#line 560 "GamepadSlideController.c"
}

static void
__lambda138_ (Block8Data* _data8_)
{
	SpiceGamepadSlideController* self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
#line 60 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	self = _data8_->self;
#line 60 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_tmp0_ = lib_gamepad_gamepad_get_raw_name (_data8_->gamepad);
#line 60 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_tmp1_ = _tmp0_;
#line 60 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_tmp2_ = string_to_string (_tmp1_);
#line 60 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_tmp3_ = g_strconcat (_tmp2_, " - G Unplugged\n", NULL);
#line 60 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_tmp4_ = _tmp3_;
#line 60 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	g_debug ("GamepadSlideController.vala:60: %s", _tmp4_);
#line 60 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_g_free0 (_tmp4_);
#line 588 "GamepadSlideController.c"
}

static void
___lambda138__lib_gamepad_gamepad_unplugged (LibGamepadGamepad* _sender,
                                             gpointer self)
{
#line 60 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	__lambda138_ (self);
#line 597 "GamepadSlideController.c"
}

static void
spice_gamepad_slide_controller_connect_gamepad (SpiceGamepadSlideController* self,
                                                LibGamepadGamepad* gamepad)
{
	Block8Data* _data8_;
	LibGamepadGamepad* _tmp0_;
	LibGamepadRawGamepad* _tmp1_;
	LibGamepadRawGamepad* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	LibGamepadGamepad* _tmp7_;
	SpiceGamepadSlideControllerControlerConfiguration* _tmp8_;
#line 53 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	g_return_if_fail (self != NULL);
#line 53 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	g_return_if_fail (gamepad != NULL);
#line 53 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_data8_ = g_slice_new0 (Block8Data);
#line 53 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_data8_->_ref_count_ = 1;
#line 53 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_data8_->self = g_object_ref (self);
#line 53 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_tmp0_ = _g_object_ref0 (gamepad);
#line 53 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_g_object_unref0 (_data8_->gamepad);
#line 53 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_data8_->gamepad = _tmp0_;
#line 54 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_tmp1_ = lib_gamepad_gamepad_get_raw_gamepad (_data8_->gamepad);
#line 54 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_tmp2_ = _tmp1_;
#line 54 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_tmp3_ = lib_gamepad_raw_gamepad_get_identifier (_tmp2_);
#line 54 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_tmp4_ = _tmp3_;
#line 54 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_tmp5_ = lib_gamepad_gamepad_get_raw_name (_data8_->gamepad);
#line 54 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_tmp6_ = _tmp5_;
#line 54 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	g_debug ("GamepadSlideController.vala:54: Controler Plugged in %s, %s", _tmp4_, _tmp6_);
#line 55 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_tmp7_ = _g_object_ref0 (_data8_->gamepad);
#line 55 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_vala_array_add1 (&self->priv->gamepads, &self->priv->gamepads_length1, &self->priv->_gamepads_size_, _tmp7_);
#line 57 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_tmp8_ = spice_gamepad_slide_controller_controler_configuration_new ();
#line 57 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_g_object_unref0 (self->priv->config);
#line 57 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	self->priv->config = _tmp8_;
#line 59 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	g_signal_connect_object (_data8_->gamepad, "button-event", (GCallback) _spice_gamepad_slide_controller_button_event_lib_gamepad_gamepad_button_event, self, 0);
#line 60 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	g_signal_connect_data (_data8_->gamepad, "unplugged", (GCallback) ___lambda138__lib_gamepad_gamepad_unplugged, block8_data_ref (_data8_), (GClosureNotify) block8_data_unref, 0);
#line 61 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	spice_gamepad_slide_controller_show_controller_toast (self);
#line 53 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	block8_data_unref (_data8_);
#line 53 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_data8_ = NULL;
#line 664 "GamepadSlideController.c"
}

static void
___lambda139_ (SpiceGamepadSlideController* self)
{
	SpiceGamepadSlideControllerControllerConfigurationDialog* dialog = NULL;
	SpiceGamepadSlideControllerControlerConfiguration* _tmp0_;
	SpiceGamepadSlideControllerControllerConfigurationDialog* _tmp1_;
#line 70 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_tmp0_ = self->priv->config;
#line 70 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_tmp1_ = spice_gamepad_slide_controller_controller_configuration_dialog_new (self, _tmp0_);
#line 70 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	g_object_ref_sink (_tmp1_);
#line 70 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	dialog = _tmp1_;
#line 71 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	gtk_window_present ((GtkWindow*) dialog);
#line 69 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_g_object_unref0 (dialog);
#line 685 "GamepadSlideController.c"
}

static void
____lambda139__granite_widgets_toast_default_action (GraniteWidgetsToast* _sender,
                                                     gpointer self)
{
#line 69 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	___lambda139_ ((SpiceGamepadSlideController*) self);
#line 694 "GamepadSlideController.c"
}

static void
spice_gamepad_slide_controller_show_controller_toast (SpiceGamepadSlideController* self)
{
	GraniteWidgetsToast* _tmp0_;
	SpiceWindow* _tmp4_;
	GraniteWidgetsToast* _tmp5_;
#line 64 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	g_return_if_fail (self != NULL);
#line 65 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_tmp0_ = self->priv->toast;
#line 65 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	if (_tmp0_ == NULL) {
#line 709 "GamepadSlideController.c"
		GraniteWidgetsToast* _tmp1_;
		GraniteWidgetsToast* _tmp2_;
		GraniteWidgetsToast* _tmp3_;
#line 66 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		_tmp1_ = granite_widgets_toast_new (_ ("Controller found"));
#line 66 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		g_object_ref_sink (_tmp1_);
#line 66 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		_g_object_unref0 (self->priv->toast);
#line 66 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		self->priv->toast = _tmp1_;
#line 67 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		_tmp2_ = self->priv->toast;
#line 67 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		granite_widgets_toast_set_default_action (_tmp2_, _ ("Set up…"));
#line 69 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		_tmp3_ = self->priv->toast;
#line 69 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		g_signal_connect_object (_tmp3_, "default-action", (GCallback) ____lambda139__granite_widgets_toast_default_action, self, 0);
#line 729 "GamepadSlideController.c"
	}
#line 75 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_tmp4_ = self->priv->window;
#line 75 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_tmp5_ = self->priv->toast;
#line 75 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	spice_window_add_toast_notification (_tmp4_, _tmp5_);
#line 737 "GamepadSlideController.c"
}

static void
spice_gamepad_slide_controller_button_event (SpiceGamepadSlideController* self,
                                             gint button)
{
	SpiceGamepadSlideControllerControlerConfiguration* _tmp0_;
#line 78 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	g_return_if_fail (self != NULL);
#line 79 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	g_debug ("GamepadSlideController.vala:79: Gamepad Button event: %d\n", button);
#line 80 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	g_signal_emit (self, spice_gamepad_slide_controller_signals[SPICE_GAMEPAD_SLIDE_CONTROLLER_RAW_BUTTON_SIGNAL], 0, button);
#line 81 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	if (self->editing) {
#line 81 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		return;
#line 755 "GamepadSlideController.c"
	}
#line 83 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_tmp0_ = self->priv->config;
#line 83 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	if (button == _tmp0_->next) {
#line 84 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		spice_gamepad_slide_controller_next_slide (self);
#line 763 "GamepadSlideController.c"
	} else {
		SpiceGamepadSlideControllerControlerConfiguration* _tmp1_;
#line 85 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		_tmp1_ = self->priv->config;
#line 85 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		if (button == _tmp1_->back) {
#line 86 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
			spice_gamepad_slide_controller_previous_slide (self);
#line 772 "GamepadSlideController.c"
		} else {
			SpiceGamepadSlideControllerControlerConfiguration* _tmp2_;
#line 87 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
			_tmp2_ = self->priv->config;
#line 87 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
			if (button == _tmp2_->checkpoint) {
#line 88 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
				spice_gamepad_slide_controller_set_checkpoint (self);
#line 781 "GamepadSlideController.c"
			} else {
				SpiceGamepadSlideControllerControlerConfiguration* _tmp3_;
#line 89 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
				_tmp3_ = self->priv->config;
#line 89 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
				if (button == _tmp3_->jump) {
#line 90 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
					spice_gamepad_slide_controller_jump_to_checkpoint (self);
#line 790 "GamepadSlideController.c"
				} else {
					SpiceGamepadSlideControllerControlerConfiguration* _tmp4_;
#line 91 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
					_tmp4_ = self->priv->config;
#line 91 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
					if (button == _tmp4_->home) {
#line 92 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
						spice_gamepad_slide_controller_toggle_present (self);
#line 799 "GamepadSlideController.c"
					}
				}
			}
		}
	}
}

static void
spice_gamepad_slide_controller_jump_to_checkpoint (SpiceGamepadSlideController* self)
{
	SpiceSlideManager* _tmp0_;
#line 96 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	g_return_if_fail (self != NULL);
#line 97 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_tmp0_ = self->priv->slide_manager;
#line 97 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	spice_slide_manager_jump_to_checkpoint (_tmp0_);
#line 817 "GamepadSlideController.c"
}

static void
spice_gamepad_slide_controller_set_checkpoint (SpiceGamepadSlideController* self)
{
	SpiceSlideManager* _tmp0_;
#line 100 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	g_return_if_fail (self != NULL);
#line 101 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_tmp0_ = self->priv->slide_manager;
#line 101 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	spice_slide_manager_set_checkpoint (_tmp0_);
#line 830 "GamepadSlideController.c"
}

static void
spice_gamepad_slide_controller_next_slide (SpiceGamepadSlideController* self)
{
	SpiceWindow* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
#line 104 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	g_return_if_fail (self != NULL);
#line 105 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_tmp0_ = self->priv->window;
#line 105 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_tmp1_ = spice_window_get_is_presenting (_tmp0_);
#line 105 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_tmp2_ = _tmp1_;
#line 105 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	if (_tmp2_) {
#line 849 "GamepadSlideController.c"
		SpiceSlideManager* _tmp3_;
#line 106 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		_tmp3_ = self->priv->slide_manager;
#line 106 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		spice_slide_manager_next_slide (_tmp3_);
#line 855 "GamepadSlideController.c"
	}
}

static void
spice_gamepad_slide_controller_previous_slide (SpiceGamepadSlideController* self)
{
	SpiceWindow* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
#line 110 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	g_return_if_fail (self != NULL);
#line 111 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_tmp0_ = self->priv->window;
#line 111 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_tmp1_ = spice_window_get_is_presenting (_tmp0_);
#line 111 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_tmp2_ = _tmp1_;
#line 111 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	if (_tmp2_) {
#line 875 "GamepadSlideController.c"
		SpiceSlideManager* _tmp3_;
#line 112 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		_tmp3_ = self->priv->slide_manager;
#line 112 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		spice_slide_manager_previous_slide (_tmp3_);
#line 881 "GamepadSlideController.c"
	}
}

static void
spice_gamepad_slide_controller_toggle_present (SpiceGamepadSlideController* self)
{
	SpiceWindow* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
#line 116 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	g_return_if_fail (self != NULL);
#line 117 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_tmp0_ = self->priv->window;
#line 117 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_tmp1_ = spice_window_get_is_presenting (_tmp0_);
#line 117 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_tmp2_ = _tmp1_;
#line 117 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	if (_tmp2_) {
#line 901 "GamepadSlideController.c"
		SpiceWindow* _tmp3_;
#line 118 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		_tmp3_ = self->priv->window;
#line 118 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		gtk_window_unfullscreen ((GtkWindow*) _tmp3_);
#line 907 "GamepadSlideController.c"
	} else {
		SpiceWindow* _tmp4_;
#line 120 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		_tmp4_ = self->priv->window;
#line 120 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		gtk_window_fullscreen ((GtkWindow*) _tmp4_);
#line 914 "GamepadSlideController.c"
	}
}

static inline gpointer
spice_gamepad_slide_controller_controller_configuration_dialog_get_instance_private (SpiceGamepadSlideControllerControllerConfigurationDialog* self)
{
	return G_STRUCT_MEMBER_P (self, SpiceGamepadSlideControllerControllerConfigurationDialog_private_offset);
}

static Block9Data*
block9_data_ref (Block9Data* _data9_)
{
#line 137 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	g_atomic_int_inc (&_data9_->_ref_count_);
#line 137 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	return _data9_;
#line 931 "GamepadSlideController.c"
}

static void
block9_data_unref (void * _userdata_)
{
	Block9Data* _data9_;
	_data9_ = (Block9Data*) _userdata_;
#line 137 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	if (g_atomic_int_dec_and_test (&_data9_->_ref_count_)) {
#line 941 "GamepadSlideController.c"
		SpiceGamepadSlideControllerControllerConfigurationDialog* self;
#line 137 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		self = _data9_->self;
#line 137 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		_g_object_unref0 (_data9_->monitor);
#line 137 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		_g_object_unref0 (self);
#line 137 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		g_slice_free (Block9Data, _data9_);
#line 951 "GamepadSlideController.c"
	}
}

static void
__lambda141_ (Block9Data* _data9_,
              gint ID)
{
	SpiceGamepadSlideControllerControllerConfigurationDialog* self;
#line 169 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	self = _data9_->self;
#line 170 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	switch (ID) {
#line 170 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		case 1:
#line 966 "GamepadSlideController.c"
		{
			SpiceGamepadSlideControllerControlerConfiguration* _tmp0_;
#line 172 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
			_tmp0_ = self->priv->config;
#line 172 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
			spice_gamepad_slide_controller_controler_configuration_save (_tmp0_);
#line 173 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
			break;
#line 975 "GamepadSlideController.c"
		}
		default:
#line 170 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		break;
#line 980 "GamepadSlideController.c"
	}
#line 176 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	self->priv->listening = FALSE;
#line 177 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_data9_->monitor->editing = FALSE;
#line 178 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	g_signal_emit_by_name ((GtkDialog*) self, "close");
#line 988 "GamepadSlideController.c"
}

static void
___lambda141__gtk_dialog_response (GtkDialog* _sender,
                                   gint response_id,
                                   gpointer self)
{
#line 169 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	__lambda141_ (self, response_id);
#line 998 "GamepadSlideController.c"
}

static void
__lambda142_ (SpiceGamepadSlideControllerControllerConfigurationDialog* self,
              gint id)
{
	gint** _tmp0_;
	GtkButton* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GtkWidget* _tmp4_;
	SpiceGamepadSlideControllerControlerConfiguration* _tmp5_;
#line 182 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	if (!self->priv->listening) {
#line 182 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		return;
#line 1015 "GamepadSlideController.c"
	}
#line 183 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	self->priv->listening = FALSE;
#line 185 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	g_debug ("GamepadSlideController.vala:185: Event caught %d\n", id);
#line 187 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_tmp0_ = self->priv->listening_action;
#line 187 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	*(*_tmp0_) = id;
#line 188 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_tmp1_ = self->priv->listening_button;
#line 188 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_tmp2_ = g_strdup_printf (_ ("Button %d"), id);
#line 188 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_tmp3_ = _tmp2_;
#line 188 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	gtk_button_set_label (_tmp1_, _tmp3_);
#line 188 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_g_free0 (_tmp3_);
#line 190 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_tmp4_ = self->priv->save_button;
#line 190 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_tmp5_ = self->priv->config;
#line 190 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	gtk_widget_set_sensitive (_tmp4_, spice_gamepad_slide_controller_controler_configuration_is_valid (_tmp5_));
#line 1041 "GamepadSlideController.c"
}

static void
___lambda142__spice_gamepad_slide_controller_raw_button (SpiceGamepadSlideController* _sender,
                                                         gint button,
                                                         gpointer self)
{
#line 181 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	__lambda142_ ((SpiceGamepadSlideControllerControllerConfigurationDialog*) self, button);
#line 1051 "GamepadSlideController.c"
}

static SpiceGamepadSlideControllerControllerConfigurationDialog*
spice_gamepad_slide_controller_controller_configuration_dialog_construct (GType object_type,
                                                                          SpiceGamepadSlideController* monitor,
                                                                          SpiceGamepadSlideControllerControlerConfiguration* _config)
{
	SpiceGamepadSlideControllerControllerConfigurationDialog * self = NULL;
	Block9Data* _data9_;
	SpiceGamepadSlideController* _tmp0_;
	GtkGrid* _tmp1_;
	GtkGrid* _tmp2_;
	GtkLabel* label = NULL;
	GtkLabel* _tmp3_;
	GtkStyleContext* _tmp4_;
	GtkGrid* _tmp5_;
	GtkGrid* _tmp6_;
	GtkGrid* _tmp7_;
	GtkGrid* _tmp8_;
	GtkGrid* _tmp9_;
	GtkLabel* _tmp10_;
	gint _tmp11_;
	SpiceGamepadSlideControllerControlerConfiguration* _tmp12_;
	SpiceGamepadSlideControllerControlerConfiguration* _tmp13_;
	SpiceGamepadSlideControllerControlerConfiguration* _tmp14_;
	SpiceGamepadSlideControllerControlerConfiguration* _tmp15_;
	SpiceGamepadSlideControllerControlerConfiguration* _tmp16_;
	GtkBox* _tmp17_;
	GtkGrid* _tmp18_;
	GtkWidget* _tmp19_;
	GtkWidget* _tmp20_;
#line 137 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	g_return_val_if_fail (monitor != NULL, NULL);
#line 137 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	g_return_val_if_fail (_config != NULL, NULL);
#line 137 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_data9_ = g_slice_new0 (Block9Data);
#line 137 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_data9_->_ref_count_ = 1;
#line 137 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_tmp0_ = _g_object_ref0 (monitor);
#line 137 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_g_object_unref0 (_data9_->monitor);
#line 137 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_data9_->monitor = _tmp0_;
#line 137 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	self = (SpiceGamepadSlideControllerControllerConfigurationDialog*) g_object_new (object_type, NULL);
#line 137 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_data9_->self = g_object_ref (self);
#line 138 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	self->priv->monitor = _data9_->monitor;
#line 139 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	self->priv->config = _config;
#line 141 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_data9_->monitor->editing = TRUE;
#line 143 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	gtk_container_set_border_width ((GtkContainer*) self, (guint) 12);
#line 144 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_tmp1_ = (GtkGrid*) gtk_grid_new ();
#line 144 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	g_object_ref_sink (_tmp1_);
#line 144 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_tmp2_ = _tmp1_;
#line 144 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	gtk_window_set_titlebar ((GtkWindow*) self, (GtkWidget*) _tmp2_);
#line 144 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_g_object_unref0 (_tmp2_);
#line 145 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	gtk_window_set_keep_above ((GtkWindow*) self, TRUE);
#line 146 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	gtk_widget_set_size_request ((GtkWidget*) self, 360, 400);
#line 147 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	gtk_window_set_resizable ((GtkWindow*) self, FALSE);
#line 148 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	gtk_window_set_modal ((GtkWindow*) self, TRUE);
#line 150 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_tmp3_ = (GtkLabel*) gtk_label_new (_ ("Controller Configuration"));
#line 150 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	g_object_ref_sink (_tmp3_);
#line 150 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	label = _tmp3_;
#line 151 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_tmp4_ = gtk_widget_get_style_context ((GtkWidget*) label);
#line 151 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	gtk_style_context_add_class (_tmp4_, "h4");
#line 153 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_tmp5_ = (GtkGrid*) gtk_grid_new ();
#line 153 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	g_object_ref_sink (_tmp5_);
#line 153 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_g_object_unref0 (self->priv->grid);
#line 153 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	self->priv->grid = _tmp5_;
#line 154 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_tmp6_ = self->priv->grid;
#line 154 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	gtk_orientable_set_orientation ((GtkOrientable*) _tmp6_, GTK_ORIENTATION_VERTICAL);
#line 155 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_tmp7_ = self->priv->grid;
#line 155 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	gtk_grid_set_column_spacing (_tmp7_, 12);
#line 156 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_tmp8_ = self->priv->grid;
#line 156 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	gtk_grid_set_row_spacing (_tmp8_, 6);
#line 158 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_tmp9_ = self->priv->grid;
#line 158 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_tmp10_ = label;
#line 158 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_tmp11_ = self->priv->row;
#line 158 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	self->priv->row = _tmp11_ + 1;
#line 158 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	gtk_grid_attach (_tmp9_, (GtkWidget*) _tmp10_, 0, _tmp11_, 1, 1);
#line 159 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_tmp12_ = self->priv->config;
#line 159 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	spice_gamepad_slide_controller_controller_configuration_dialog_add_row (self, _ ("Next Slide:"), &_tmp12_->next);
#line 160 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_tmp13_ = self->priv->config;
#line 160 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	spice_gamepad_slide_controller_controller_configuration_dialog_add_row (self, _ ("Previous Slide:"), &_tmp13_->back);
#line 161 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_tmp14_ = self->priv->config;
#line 161 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	spice_gamepad_slide_controller_controller_configuration_dialog_add_row (self, _ ("Set Jump:"), &_tmp14_->checkpoint);
#line 162 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_tmp15_ = self->priv->config;
#line 162 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	spice_gamepad_slide_controller_controller_configuration_dialog_add_row (self, _ ("Jump to slide:"), &_tmp15_->jump);
#line 163 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_tmp16_ = self->priv->config;
#line 163 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	spice_gamepad_slide_controller_controller_configuration_dialog_add_row (self, _ ("Toggle Presentation:"), &_tmp16_->home);
#line 165 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_tmp17_ = gtk_dialog_get_content_area ((GtkDialog*) self);
#line 165 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_tmp18_ = self->priv->grid;
#line 165 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	gtk_container_add ((GtkContainer*) _tmp17_, (GtkWidget*) _tmp18_);
#line 166 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	gtk_dialog_add_button ((GtkDialog*) self, _ ("Cancel"), 2);
#line 167 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_tmp19_ = gtk_dialog_add_button ((GtkDialog*) self, _ ("Apply"), 1);
#line 167 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_tmp20_ = _g_object_ref0 (_tmp19_);
#line 167 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_g_object_unref0 (self->priv->save_button);
#line 167 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	self->priv->save_button = _tmp20_;
#line 169 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	g_signal_connect_data ((GtkDialog*) self, "response", (GCallback) ___lambda141__gtk_dialog_response, block9_data_ref (_data9_), (GClosureNotify) block9_data_unref, 0);
#line 181 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	g_signal_connect_object (_data9_->monitor, "raw-button", (GCallback) ___lambda142__spice_gamepad_slide_controller_raw_button, self, 0);
#line 193 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	gtk_widget_show_all ((GtkWidget*) self);
#line 137 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_g_object_unref0 (label);
#line 137 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	block9_data_unref (_data9_);
#line 137 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_data9_ = NULL;
#line 137 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	return self;
#line 1217 "GamepadSlideController.c"
}

static SpiceGamepadSlideControllerControllerConfigurationDialog*
spice_gamepad_slide_controller_controller_configuration_dialog_new (SpiceGamepadSlideController* monitor,
                                                                    SpiceGamepadSlideControllerControlerConfiguration* _config)
{
#line 137 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	return spice_gamepad_slide_controller_controller_configuration_dialog_construct (SPICE_GAMEPAD_SLIDE_CONTROLLER_TYPE_CONTROLLER_CONFIGURATION_DIALOG, monitor, _config);
#line 1226 "GamepadSlideController.c"
}

static Block10Data*
block10_data_ref (Block10Data* _data10_)
{
#line 196 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	g_atomic_int_inc (&_data10_->_ref_count_);
#line 196 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	return _data10_;
#line 1236 "GamepadSlideController.c"
}

static void
block10_data_unref (void * _userdata_)
{
	Block10Data* _data10_;
	_data10_ = (Block10Data*) _userdata_;
#line 196 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	if (g_atomic_int_dec_and_test (&_data10_->_ref_count_)) {
#line 1246 "GamepadSlideController.c"
		SpiceGamepadSlideControllerControllerConfigurationDialog* self;
#line 196 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		self = _data10_->self;
#line 196 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		_g_object_unref0 (_data10_->button);
#line 196 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		_g_object_unref0 (self);
#line 196 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		g_slice_free (Block10Data, _data10_);
#line 1256 "GamepadSlideController.c"
	}
}

static void
__lambda140_ (Block10Data* _data10_)
{
	SpiceGamepadSlideControllerControllerConfigurationDialog* self;
	gboolean _tmp4_ = FALSE;
#line 201 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	self = _data10_->self;
#line 202 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	if (self->priv->listening) {
#line 1269 "GamepadSlideController.c"
		GtkButton* _tmp0_;
		gint** _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
#line 203 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		_tmp0_ = self->priv->listening_button;
#line 203 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		_tmp1_ = self->priv->listening_action;
#line 203 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		_tmp2_ = g_strdup_printf (_ ("Button %d"), *(*_tmp1_));
#line 203 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		_tmp3_ = _tmp2_;
#line 203 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		gtk_button_set_label (_tmp0_, _tmp3_);
#line 203 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		_g_free0 (_tmp3_);
#line 1286 "GamepadSlideController.c"
	}
#line 206 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	if (!self->priv->listening) {
#line 206 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		_tmp4_ = TRUE;
#line 1292 "GamepadSlideController.c"
	} else {
		GtkButton* _tmp5_;
#line 206 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		_tmp5_ = self->priv->listening_button;
#line 206 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		_tmp4_ = _tmp5_ != _data10_->button;
#line 1299 "GamepadSlideController.c"
	}
#line 206 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	if (_tmp4_) {
#line 1303 "GamepadSlideController.c"
		GtkButton* _tmp6_;
		GtkWidget* _tmp7_;
#line 207 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		self->priv->listening = TRUE;
#line 208 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		self->priv->listening_action = &_data10_->action;
#line 209 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		_tmp6_ = _g_object_ref0 (_data10_->button);
#line 209 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		_g_object_unref0 (self->priv->listening_button);
#line 209 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		self->priv->listening_button = _tmp6_;
#line 210 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		gtk_button_set_label (_data10_->button, _ ("..."));
#line 211 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		_tmp7_ = self->priv->save_button;
#line 211 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		gtk_widget_set_sensitive (_tmp7_, FALSE);
#line 1322 "GamepadSlideController.c"
	} else {
		gboolean _tmp8_ = FALSE;
#line 212 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		if (self->priv->listening) {
#line 1327 "GamepadSlideController.c"
			GtkButton* _tmp9_;
#line 212 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
			_tmp9_ = self->priv->listening_button;
#line 212 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
			_tmp8_ = _tmp9_ == _data10_->button;
#line 1333 "GamepadSlideController.c"
		} else {
#line 212 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
			_tmp8_ = FALSE;
#line 1337 "GamepadSlideController.c"
		}
#line 212 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		if (_tmp8_) {
#line 1341 "GamepadSlideController.c"
			GtkWidget* _tmp10_;
			SpiceGamepadSlideControllerControlerConfiguration* _tmp11_;
#line 213 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
			self->priv->listening = FALSE;
#line 214 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
			_g_object_unref0 (self->priv->listening_button);
#line 214 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
			self->priv->listening_button = NULL;
#line 215 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
			_tmp10_ = self->priv->save_button;
#line 215 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
			_tmp11_ = self->priv->config;
#line 215 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
			gtk_widget_set_sensitive (_tmp10_, spice_gamepad_slide_controller_controler_configuration_is_valid (_tmp11_));
#line 1356 "GamepadSlideController.c"
		}
	}
}

static void
___lambda140__gtk_button_clicked (GtkButton* _sender,
                                  gpointer self)
{
#line 201 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	__lambda140_ (self);
#line 1367 "GamepadSlideController.c"
}

static void
spice_gamepad_slide_controller_controller_configuration_dialog_add_row (SpiceGamepadSlideControllerControllerConfigurationDialog* self,
                                                                        const gchar* name,
                                                                        gint* action)
{
	Block10Data* _data10_;
	GtkLabel* label = NULL;
	GtkLabel* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GtkButton* _tmp3_;
	GtkButton* _tmp4_;
	GtkGrid* _tmp5_;
	GtkGrid* _tmp6_;
	GtkButton* _tmp7_;
	gint _tmp8_;
#line 196 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	g_return_if_fail (self != NULL);
#line 196 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	g_return_if_fail (name != NULL);
#line 196 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_data10_ = g_slice_new0 (Block10Data);
#line 196 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_data10_->_ref_count_ = 1;
#line 196 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_data10_->self = g_object_ref (self);
#line 196 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_data10_->action = action;
#line 197 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_tmp0_ = (GtkLabel*) gtk_label_new (name);
#line 197 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	g_object_ref_sink (_tmp0_);
#line 197 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	label = _tmp0_;
#line 198 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	gtk_widget_set_halign ((GtkWidget*) label, GTK_ALIGN_END);
#line 200 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_tmp1_ = g_strdup_printf (_ ("Button %d"), *_data10_->action);
#line 200 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_tmp2_ = _tmp1_;
#line 200 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_tmp3_ = (GtkButton*) gtk_button_new_with_label (_tmp2_);
#line 200 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	g_object_ref_sink (_tmp3_);
#line 200 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_tmp4_ = _tmp3_;
#line 200 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_g_free0 (_tmp2_);
#line 200 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_data10_->button = _tmp4_;
#line 201 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	g_signal_connect_data (_data10_->button, "clicked", (GCallback) ___lambda140__gtk_button_clicked, block10_data_ref (_data10_), (GClosureNotify) block10_data_unref, 0);
#line 219 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_tmp5_ = self->priv->grid;
#line 219 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	gtk_grid_attach (_tmp5_, (GtkWidget*) label, 0, self->priv->row, 1, 1);
#line 220 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_tmp6_ = self->priv->grid;
#line 220 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_tmp7_ = _data10_->button;
#line 220 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_tmp8_ = self->priv->row;
#line 220 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	self->priv->row = _tmp8_ + 1;
#line 220 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	gtk_grid_attach (_tmp6_, (GtkWidget*) _tmp7_, 1, _tmp8_, 1, 1);
#line 196 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_g_object_unref0 (label);
#line 196 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	block10_data_unref (_data10_);
#line 196 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_data10_ = NULL;
#line 1442 "GamepadSlideController.c"
}

static void
spice_gamepad_slide_controller_controller_configuration_dialog_class_init (SpiceGamepadSlideControllerControllerConfigurationDialogClass * klass,
                                                                           gpointer klass_data)
{
#line 124 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	spice_gamepad_slide_controller_controller_configuration_dialog_parent_class = g_type_class_peek_parent (klass);
#line 124 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	g_type_class_adjust_private_offset (klass, &SpiceGamepadSlideControllerControllerConfigurationDialog_private_offset);
#line 124 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	G_OBJECT_CLASS (klass)->finalize = spice_gamepad_slide_controller_controller_configuration_dialog_finalize;
#line 1455 "GamepadSlideController.c"
}

static void
spice_gamepad_slide_controller_controller_configuration_dialog_instance_init (SpiceGamepadSlideControllerControllerConfigurationDialog * self,
                                                                              gpointer klass)
{
#line 124 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	self->priv = spice_gamepad_slide_controller_controller_configuration_dialog_get_instance_private (self);
#line 131 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	self->priv->listening = FALSE;
#line 132 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	self->priv->listening_action = NULL;
#line 135 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	self->priv->row = 0;
#line 1470 "GamepadSlideController.c"
}

static void
spice_gamepad_slide_controller_controller_configuration_dialog_finalize (GObject * obj)
{
	SpiceGamepadSlideControllerControllerConfigurationDialog * self;
#line 124 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SPICE_GAMEPAD_SLIDE_CONTROLLER_TYPE_CONTROLLER_CONFIGURATION_DIALOG, SpiceGamepadSlideControllerControllerConfigurationDialog);
#line 128 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_g_object_unref0 (self->priv->grid);
#line 129 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_g_object_unref0 (self->priv->save_button);
#line 133 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_g_object_unref0 (self->priv->listening_button);
#line 124 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	G_OBJECT_CLASS (spice_gamepad_slide_controller_controller_configuration_dialog_parent_class)->finalize (obj);
#line 1487 "GamepadSlideController.c"
}

static GType
spice_gamepad_slide_controller_controller_configuration_dialog_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SpiceGamepadSlideControllerControllerConfigurationDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) spice_gamepad_slide_controller_controller_configuration_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SpiceGamepadSlideControllerControllerConfigurationDialog), 0, (GInstanceInitFunc) spice_gamepad_slide_controller_controller_configuration_dialog_instance_init, NULL };
	GType spice_gamepad_slide_controller_controller_configuration_dialog_type_id;
	spice_gamepad_slide_controller_controller_configuration_dialog_type_id = g_type_register_static (gtk_dialog_get_type (), "SpiceGamepadSlideControllerControllerConfigurationDialog", &g_define_type_info, 0);
	SpiceGamepadSlideControllerControllerConfigurationDialog_private_offset = g_type_add_instance_private (spice_gamepad_slide_controller_controller_configuration_dialog_type_id, sizeof (SpiceGamepadSlideControllerControllerConfigurationDialogPrivate));
	return spice_gamepad_slide_controller_controller_configuration_dialog_type_id;
}

static GType
spice_gamepad_slide_controller_controller_configuration_dialog_get_type (void)
{
	static volatile gsize spice_gamepad_slide_controller_controller_configuration_dialog_type_id__once = 0;
	if (g_once_init_enter (&spice_gamepad_slide_controller_controller_configuration_dialog_type_id__once)) {
		GType spice_gamepad_slide_controller_controller_configuration_dialog_type_id;
		spice_gamepad_slide_controller_controller_configuration_dialog_type_id = spice_gamepad_slide_controller_controller_configuration_dialog_get_type_once ();
		g_once_init_leave (&spice_gamepad_slide_controller_controller_configuration_dialog_type_id__once, spice_gamepad_slide_controller_controller_configuration_dialog_type_id);
	}
	return spice_gamepad_slide_controller_controller_configuration_dialog_type_id__once;
}

static SpiceGamepadSlideControllerControlerConfiguration*
spice_gamepad_slide_controller_controler_configuration_construct (GType object_type)
{
	SpiceGamepadSlideControllerControlerConfiguration * self = NULL;
#line 232 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	self = (SpiceGamepadSlideControllerControlerConfiguration*) g_object_new (object_type, NULL);
#line 233 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	spice_gamepad_slide_controller_controler_configuration_load (self);
#line 232 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	return self;
#line 1522 "GamepadSlideController.c"
}

static SpiceGamepadSlideControllerControlerConfiguration*
spice_gamepad_slide_controller_controler_configuration_new (void)
{
#line 232 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	return spice_gamepad_slide_controller_controler_configuration_construct (SPICE_GAMEPAD_SLIDE_CONTROLLER_TYPE_CONTROLER_CONFIGURATION);
#line 1530 "GamepadSlideController.c"
}

static gboolean
_vala_int_array_contains (gint * stack,
                          gssize stack_length,
                          const gint needle)
{
	gssize i;
#line 240 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	for (i = 0; i < stack_length; i++) {
#line 240 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		if (needle == stack[i]) {
#line 240 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
			return TRUE;
#line 1545 "GamepadSlideController.c"
		}
	}
#line 240 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	return FALSE;
#line 1550 "GamepadSlideController.c"
}

static gboolean
spice_gamepad_slide_controller_controler_configuration_is_valid (SpiceGamepadSlideControllerControlerConfiguration* self)
{
	GArray* buttons = NULL;
	GArray* _tmp0_;
	GArray* _tmp1_;
	GArray* _tmp2_;
	gpointer* _tmp3_;
	gint _tmp3__length1;
	GArray* _tmp4_;
	GArray* _tmp5_;
	gpointer* _tmp6_;
	gint _tmp6__length1;
	GArray* _tmp7_;
	GArray* _tmp8_;
	gpointer* _tmp9_;
	gint _tmp9__length1;
	GArray* _tmp10_;
	GArray* _tmp11_;
	gpointer* _tmp12_;
	gint _tmp12__length1;
	GArray* _tmp13_;
	gboolean result;
#line 236 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 237 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_tmp0_ = g_array_new (TRUE, TRUE, sizeof (gint));
#line 237 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	buttons = _tmp0_;
#line 238 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_tmp1_ = buttons;
#line 238 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	g_array_append_val (_tmp1_, self->next);
#line 240 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_tmp2_ = buttons;
#line 240 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_tmp3_ = _tmp2_->data;
#line 240 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_tmp3__length1 = _tmp2_->len;
#line 240 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	if (_vala_int_array_contains (_tmp3_, _tmp3__length1, self->back)) {
#line 240 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		result = FALSE;
#line 240 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		_g_array_unref0 (buttons);
#line 240 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		return result;
#line 1600 "GamepadSlideController.c"
	}
#line 241 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_tmp4_ = buttons;
#line 241 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	g_array_append_val (_tmp4_, self->back);
#line 243 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_tmp5_ = buttons;
#line 243 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_tmp6_ = _tmp5_->data;
#line 243 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_tmp6__length1 = _tmp5_->len;
#line 243 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	if (_vala_int_array_contains (_tmp6_, _tmp6__length1, self->checkpoint)) {
#line 243 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		result = FALSE;
#line 243 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		_g_array_unref0 (buttons);
#line 243 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		return result;
#line 1620 "GamepadSlideController.c"
	}
#line 244 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_tmp7_ = buttons;
#line 244 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	g_array_append_val (_tmp7_, self->checkpoint);
#line 246 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_tmp8_ = buttons;
#line 246 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_tmp9_ = _tmp8_->data;
#line 246 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_tmp9__length1 = _tmp8_->len;
#line 246 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	if (_vala_int_array_contains (_tmp9_, _tmp9__length1, self->jump)) {
#line 246 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		result = FALSE;
#line 246 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		_g_array_unref0 (buttons);
#line 246 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		return result;
#line 1640 "GamepadSlideController.c"
	}
#line 247 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_tmp10_ = buttons;
#line 247 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	g_array_append_val (_tmp10_, self->jump);
#line 249 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_tmp11_ = buttons;
#line 249 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_tmp12_ = _tmp11_->data;
#line 249 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_tmp12__length1 = _tmp11_->len;
#line 249 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	if (_vala_int_array_contains (_tmp12_, _tmp12__length1, self->home)) {
#line 249 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		result = FALSE;
#line 249 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		_g_array_unref0 (buttons);
#line 249 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		return result;
#line 1660 "GamepadSlideController.c"
	}
#line 250 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_tmp13_ = buttons;
#line 250 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	g_array_append_val (_tmp13_, self->home);
#line 252 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	result = TRUE;
#line 252 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_g_array_unref0 (buttons);
#line 252 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	return result;
#line 1672 "GamepadSlideController.c"
}

static gpointer
_json_object_ref0 (gpointer self)
{
#line 266 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	return self ? json_object_ref (self) : NULL;
#line 1680 "GamepadSlideController.c"
}

static void
spice_gamepad_slide_controller_controler_configuration_load (SpiceGamepadSlideControllerControlerConfiguration* self)
{
	gchar* config = NULL;
	SpiceServicesSettings* _tmp0_;
	SpiceServicesSettings* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	GError* _inner_error0_ = NULL;
#line 255 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	g_return_if_fail (self != NULL);
#line 256 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_tmp0_ = spice_services_settings_get_instance ();
#line 256 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_tmp1_ = _tmp0_;
#line 256 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_tmp2_ = spice_services_settings_get_controler_config (_tmp1_);
#line 256 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_tmp3_ = _tmp2_;
#line 256 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_tmp4_ = g_strdup (_tmp3_);
#line 256 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_tmp5_ = _tmp4_;
#line 256 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_g_object_unref0 (_tmp1_);
#line 256 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	config = _tmp5_;
#line 257 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_tmp6_ = config;
#line 257 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	if (g_strcmp0 (_tmp6_, "") == 0) {
#line 258 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		spice_gamepad_slide_controller_controler_configuration_save (self);
#line 259 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		_g_free0 (config);
#line 259 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		return;
#line 1723 "GamepadSlideController.c"
	}
	{
		JsonParser* parser = NULL;
		JsonParser* _tmp7_;
		JsonParser* _tmp8_;
		const gchar* _tmp9_;
		JsonObject* root = NULL;
		JsonParser* _tmp10_;
		JsonNode* _tmp11_;
		JsonObject* _tmp12_;
		JsonObject* _tmp13_;
		JsonObject* _tmp14_;
		JsonObject* _tmp15_;
		JsonObject* _tmp16_;
		JsonObject* _tmp17_;
		JsonObject* _tmp18_;
#line 263 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		_tmp7_ = json_parser_new ();
#line 263 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		parser = _tmp7_;
#line 264 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		_tmp8_ = parser;
#line 264 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		_tmp9_ = config;
#line 264 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		json_parser_load_from_data (_tmp8_, _tmp9_, (gssize) -1, &_inner_error0_);
#line 264 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 264 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
			_g_object_unref0 (parser);
#line 1754 "GamepadSlideController.c"
			goto __catch0_g_error;
		}
#line 266 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		_tmp10_ = parser;
#line 266 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		_tmp11_ = json_parser_get_root (_tmp10_);
#line 266 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		_tmp12_ = json_node_get_object (_tmp11_);
#line 266 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		_tmp13_ = _json_object_ref0 (_tmp12_);
#line 266 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		root = _tmp13_;
#line 268 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		_tmp14_ = root;
#line 268 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		self->next = (gint) json_object_get_int_member (_tmp14_, "next");
#line 269 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		_tmp15_ = root;
#line 269 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		self->back = (gint) json_object_get_int_member (_tmp15_, "back");
#line 270 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		_tmp16_ = root;
#line 270 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		self->checkpoint = (gint) json_object_get_int_member (_tmp16_, "checkpoint");
#line 271 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		_tmp17_ = root;
#line 271 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		self->jump = (gint) json_object_get_int_member (_tmp17_, "jump");
#line 272 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		_tmp18_ = root;
#line 272 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		self->home = (gint) json_object_get_int_member (_tmp18_, "home");
#line 262 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		_json_object_unref0 (root);
#line 262 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		_g_object_unref0 (parser);
#line 1791 "GamepadSlideController.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp19_;
		const gchar* _tmp20_;
#line 262 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		e = _inner_error0_;
#line 262 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		_inner_error0_ = NULL;
#line 274 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		_tmp19_ = e;
#line 274 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		_tmp20_ = _tmp19_->message;
#line 274 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		g_warning ("GamepadSlideController.vala:274: Error loading controler config: %s", _tmp20_);
#line 275 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		spice_gamepad_slide_controller_controler_configuration_save (self);
#line 262 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		_g_error_free0 (e);
#line 1813 "GamepadSlideController.c"
	}
	__finally0:
#line 262 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 262 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		_g_free0 (config);
#line 262 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 262 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		g_clear_error (&_inner_error0_);
#line 262 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
		return;
#line 1826 "GamepadSlideController.c"
	}
#line 255 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_g_free0 (config);
#line 1830 "GamepadSlideController.c"
}

static void
spice_gamepad_slide_controller_controler_configuration_save (SpiceGamepadSlideControllerControlerConfiguration* self)
{
	gchar* config = NULL;
	gchar* _tmp0_;
	SpiceServicesSettings* _tmp1_;
	SpiceServicesSettings* _tmp2_;
#line 279 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	g_return_if_fail (self != NULL);
#line 280 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_tmp0_ = g_strdup_printf ("{\"next\":%d, \"back\":%d, \"checkpoint\":%d, \"jump\":%d, \"home\":%d" \
" }", self->next, self->back, self->checkpoint, self->jump, self->home);
#line 280 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	config = _tmp0_;
#line 281 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_tmp1_ = spice_services_settings_get_instance ();
#line 281 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_tmp2_ = _tmp1_;
#line 281 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	spice_services_settings_set_controler_config (_tmp2_, config);
#line 281 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_g_object_unref0 (_tmp2_);
#line 279 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_g_free0 (config);
#line 1856 "GamepadSlideController.c"
}

static void
spice_gamepad_slide_controller_controler_configuration_class_init (SpiceGamepadSlideControllerControlerConfigurationClass * klass,
                                                                   gpointer klass_data)
{
#line 224 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	spice_gamepad_slide_controller_controler_configuration_parent_class = g_type_class_peek_parent (klass);
#line 224 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	G_OBJECT_CLASS (klass)->finalize = spice_gamepad_slide_controller_controler_configuration_finalize;
#line 1867 "GamepadSlideController.c"
}

static void
spice_gamepad_slide_controller_controler_configuration_instance_init (SpiceGamepadSlideControllerControlerConfiguration * self,
                                                                      gpointer klass)
{
#line 226 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	self->next = 0;
#line 227 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	self->back = 2;
#line 228 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	self->checkpoint = 3;
#line 229 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	self->jump = 1;
#line 230 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	self->home = 12;
#line 1884 "GamepadSlideController.c"
}

static void
spice_gamepad_slide_controller_controler_configuration_finalize (GObject * obj)
{
	SpiceGamepadSlideControllerControlerConfiguration * self;
#line 224 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SPICE_GAMEPAD_SLIDE_CONTROLLER_TYPE_CONTROLER_CONFIGURATION, SpiceGamepadSlideControllerControlerConfiguration);
#line 224 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	G_OBJECT_CLASS (spice_gamepad_slide_controller_controler_configuration_parent_class)->finalize (obj);
#line 1895 "GamepadSlideController.c"
}

static GType
spice_gamepad_slide_controller_controler_configuration_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SpiceGamepadSlideControllerControlerConfigurationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) spice_gamepad_slide_controller_controler_configuration_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SpiceGamepadSlideControllerControlerConfiguration), 0, (GInstanceInitFunc) spice_gamepad_slide_controller_controler_configuration_instance_init, NULL };
	GType spice_gamepad_slide_controller_controler_configuration_type_id;
	spice_gamepad_slide_controller_controler_configuration_type_id = g_type_register_static (G_TYPE_OBJECT, "SpiceGamepadSlideControllerControlerConfiguration", &g_define_type_info, 0);
	return spice_gamepad_slide_controller_controler_configuration_type_id;
}

static GType
spice_gamepad_slide_controller_controler_configuration_get_type (void)
{
	static volatile gsize spice_gamepad_slide_controller_controler_configuration_type_id__once = 0;
	if (g_once_init_enter (&spice_gamepad_slide_controller_controler_configuration_type_id__once)) {
		GType spice_gamepad_slide_controller_controler_configuration_type_id;
		spice_gamepad_slide_controller_controler_configuration_type_id = spice_gamepad_slide_controller_controler_configuration_get_type_once ();
		g_once_init_leave (&spice_gamepad_slide_controller_controler_configuration_type_id__once, spice_gamepad_slide_controller_controler_configuration_type_id);
	}
	return spice_gamepad_slide_controller_controler_configuration_type_id__once;
}

static void
spice_gamepad_slide_controller_class_init (SpiceGamepadSlideControllerClass * klass,
                                           gpointer klass_data)
{
#line 22 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	spice_gamepad_slide_controller_parent_class = g_type_class_peek_parent (klass);
#line 22 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	g_type_class_adjust_private_offset (klass, &SpiceGamepadSlideController_private_offset);
#line 22 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	G_OBJECT_CLASS (klass)->finalize = spice_gamepad_slide_controller_finalize;
#line 22 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	spice_gamepad_slide_controller_signals[SPICE_GAMEPAD_SLIDE_CONTROLLER_RAW_BUTTON_SIGNAL] = g_signal_new ("raw-button", SPICE_TYPE_GAMEPAD_SLIDE_CONTROLLER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__INT, G_TYPE_NONE, 1, G_TYPE_INT);
#line 1931 "GamepadSlideController.c"
}

static void
spice_gamepad_slide_controller_instance_init (SpiceGamepadSlideController * self,
                                              gpointer klass)
{
	LibGamepadGamepad** _tmp0_;
#line 22 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	self->priv = spice_gamepad_slide_controller_get_instance_private (self);
#line 30 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_tmp0_ = g_new0 (LibGamepadGamepad*, 0 + 1);
#line 30 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	self->priv->gamepads = _tmp0_;
#line 30 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	self->priv->gamepads_length1 = 0;
#line 30 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	self->priv->_gamepads_size_ = self->priv->gamepads_length1;
#line 32 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	self->priv->toast = NULL;
#line 33 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	self->priv->config = NULL;
#line 35 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	self->editing = FALSE;
#line 1955 "GamepadSlideController.c"
}

static void
spice_gamepad_slide_controller_finalize (GObject * obj)
{
	SpiceGamepadSlideController * self;
#line 22 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SPICE_TYPE_GAMEPAD_SLIDE_CONTROLLER, SpiceGamepadSlideController);
#line 29 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_g_object_unref0 (self->priv->gamepad_monitor);
#line 30 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	self->priv->gamepads = (_vala_array_free (self->priv->gamepads, self->priv->gamepads_length1, (GDestroyNotify) g_object_unref), NULL);
#line 32 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_g_object_unref0 (self->priv->toast);
#line 33 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	_g_object_unref0 (self->priv->config);
#line 22 "../Spice-up-1.9.1/src/Services/GamepadSlideController.vala"
	G_OBJECT_CLASS (spice_gamepad_slide_controller_parent_class)->finalize (obj);
#line 1974 "GamepadSlideController.c"
}

static GType
spice_gamepad_slide_controller_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SpiceGamepadSlideControllerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) spice_gamepad_slide_controller_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SpiceGamepadSlideController), 0, (GInstanceInitFunc) spice_gamepad_slide_controller_instance_init, NULL };
	GType spice_gamepad_slide_controller_type_id;
	spice_gamepad_slide_controller_type_id = g_type_register_static (G_TYPE_OBJECT, "SpiceGamepadSlideController", &g_define_type_info, 0);
	SpiceGamepadSlideController_private_offset = g_type_add_instance_private (spice_gamepad_slide_controller_type_id, sizeof (SpiceGamepadSlideControllerPrivate));
	return spice_gamepad_slide_controller_type_id;
}

GType
spice_gamepad_slide_controller_get_type (void)
{
	static volatile gsize spice_gamepad_slide_controller_type_id__once = 0;
	if (g_once_init_enter (&spice_gamepad_slide_controller_type_id__once)) {
		GType spice_gamepad_slide_controller_type_id;
		spice_gamepad_slide_controller_type_id = spice_gamepad_slide_controller_get_type_once ();
		g_once_init_leave (&spice_gamepad_slide_controller_type_id__once, spice_gamepad_slide_controller_type_id);
	}
	return spice_gamepad_slide_controller_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

