// java wrapper for vtkOpenFOAMReader object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkOpenFOAMReader.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkMultiBlockDataSetAlgorithm_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkOpenFOAMReader_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkOpenFOAMReader",dType)) { return me; }
  if ((res= vtkMultiBlockDataSetAlgorithm_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkOpenFOAMReader_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkOpenFOAMReader* op = static_cast<vtkOpenFOAMReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkOpenFOAMReader_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkOpenFOAMReader* op = static_cast<vtkOpenFOAMReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkOpenFOAMReader_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkOpenFOAMReader* op = static_cast<vtkOpenFOAMReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkOpenFOAMReader_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkOpenFOAMReader* op = static_cast<vtkOpenFOAMReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkOpenFOAMReader_CanReadFile_14(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkOpenFOAMReader* op = static_cast<vtkOpenFOAMReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->CanReadFile(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenFOAMReader_SetFileName_15(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkOpenFOAMReader* op = static_cast<vtkOpenFOAMReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFileName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkOpenFOAMReader_GetFileName_16(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkOpenFOAMReader* op = static_cast<vtkOpenFOAMReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFileName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenFOAMReader_SetSequentialProcessing_17(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkOpenFOAMReader* op = static_cast<vtkOpenFOAMReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSequentialProcessing(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkOpenFOAMReader_GetSequentialProcessing_18(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkOpenFOAMReader* op = static_cast<vtkOpenFOAMReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSequentialProcessing();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenFOAMReader_SequentialProcessingOn_19(JNIEnv* env, jobject obj)
{

  vtkOpenFOAMReader* op = static_cast<vtkOpenFOAMReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SequentialProcessingOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenFOAMReader_SequentialProcessingOff_110(JNIEnv* env, jobject obj)
{

  vtkOpenFOAMReader* op = static_cast<vtkOpenFOAMReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SequentialProcessingOff();

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkOpenFOAMReader_GetCellDataArraySelection_111(JNIEnv* env, jobject obj)
{
  vtkDataArraySelection * temp20;

  vtkOpenFOAMReader* op = static_cast<vtkOpenFOAMReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellDataArraySelection();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkOpenFOAMReader_GetNumberOfCellArrays_112(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkOpenFOAMReader* op = static_cast<vtkOpenFOAMReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfCellArrays();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkOpenFOAMReader_GetCellArrayStatus_113(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkOpenFOAMReader* op = static_cast<vtkOpenFOAMReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellArrayStatus(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenFOAMReader_SetCellArrayStatus_114(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1)
{
  char * temp0;
  int   temp1;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;

  vtkOpenFOAMReader* op = static_cast<vtkOpenFOAMReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCellArrayStatus(temp0,temp1);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkOpenFOAMReader_GetCellArrayName_115(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkOpenFOAMReader* op = static_cast<vtkOpenFOAMReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellArrayName(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenFOAMReader_DisableAllCellArrays_116(JNIEnv* env, jobject obj)
{

  vtkOpenFOAMReader* op = static_cast<vtkOpenFOAMReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->DisableAllCellArrays();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenFOAMReader_EnableAllCellArrays_117(JNIEnv* env, jobject obj)
{

  vtkOpenFOAMReader* op = static_cast<vtkOpenFOAMReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->EnableAllCellArrays();

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkOpenFOAMReader_GetPointDataArraySelection_118(JNIEnv* env, jobject obj)
{
  vtkDataArraySelection * temp20;

  vtkOpenFOAMReader* op = static_cast<vtkOpenFOAMReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPointDataArraySelection();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkOpenFOAMReader_GetNumberOfPointArrays_119(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkOpenFOAMReader* op = static_cast<vtkOpenFOAMReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfPointArrays();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkOpenFOAMReader_GetPointArrayStatus_120(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkOpenFOAMReader* op = static_cast<vtkOpenFOAMReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPointArrayStatus(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenFOAMReader_SetPointArrayStatus_121(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1)
{
  char * temp0;
  int   temp1;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;

  vtkOpenFOAMReader* op = static_cast<vtkOpenFOAMReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPointArrayStatus(temp0,temp1);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkOpenFOAMReader_GetPointArrayName_122(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkOpenFOAMReader* op = static_cast<vtkOpenFOAMReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPointArrayName(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenFOAMReader_DisableAllPointArrays_123(JNIEnv* env, jobject obj)
{

  vtkOpenFOAMReader* op = static_cast<vtkOpenFOAMReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->DisableAllPointArrays();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenFOAMReader_EnableAllPointArrays_124(JNIEnv* env, jobject obj)
{

  vtkOpenFOAMReader* op = static_cast<vtkOpenFOAMReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->EnableAllPointArrays();

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkOpenFOAMReader_GetLagrangianDataArraySelection_125(JNIEnv* env, jobject obj)
{
  vtkDataArraySelection * temp20;

  vtkOpenFOAMReader* op = static_cast<vtkOpenFOAMReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLagrangianDataArraySelection();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkOpenFOAMReader_GetNumberOfLagrangianArrays_126(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkOpenFOAMReader* op = static_cast<vtkOpenFOAMReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfLagrangianArrays();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkOpenFOAMReader_GetLagrangianArrayStatus_127(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkOpenFOAMReader* op = static_cast<vtkOpenFOAMReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLagrangianArrayStatus(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenFOAMReader_SetLagrangianArrayStatus_128(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1)
{
  char * temp0;
  int   temp1;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;

  vtkOpenFOAMReader* op = static_cast<vtkOpenFOAMReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLagrangianArrayStatus(temp0,temp1);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkOpenFOAMReader_GetLagrangianArrayName_129(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkOpenFOAMReader* op = static_cast<vtkOpenFOAMReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLagrangianArrayName(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenFOAMReader_DisableAllLagrangianArrays_130(JNIEnv* env, jobject obj)
{

  vtkOpenFOAMReader* op = static_cast<vtkOpenFOAMReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->DisableAllLagrangianArrays();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenFOAMReader_EnableAllLagrangianArrays_131(JNIEnv* env, jobject obj)
{

  vtkOpenFOAMReader* op = static_cast<vtkOpenFOAMReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->EnableAllLagrangianArrays();

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkOpenFOAMReader_GetPatchDataArraySelection_132(JNIEnv* env, jobject obj)
{
  vtkDataArraySelection * temp20;

  vtkOpenFOAMReader* op = static_cast<vtkOpenFOAMReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPatchDataArraySelection();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkOpenFOAMReader_GetNumberOfPatchArrays_133(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkOpenFOAMReader* op = static_cast<vtkOpenFOAMReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfPatchArrays();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkOpenFOAMReader_GetPatchArrayStatus_134(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkOpenFOAMReader* op = static_cast<vtkOpenFOAMReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPatchArrayStatus(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenFOAMReader_SetPatchArrayStatus_135(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1)
{
  char * temp0;
  int   temp1;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;

  vtkOpenFOAMReader* op = static_cast<vtkOpenFOAMReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPatchArrayStatus(temp0,temp1);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkOpenFOAMReader_GetPatchArrayName_136(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkOpenFOAMReader* op = static_cast<vtkOpenFOAMReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPatchArrayName(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenFOAMReader_DisableAllPatchArrays_137(JNIEnv* env, jobject obj)
{

  vtkOpenFOAMReader* op = static_cast<vtkOpenFOAMReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->DisableAllPatchArrays();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenFOAMReader_EnableAllPatchArrays_138(JNIEnv* env, jobject obj)
{

  vtkOpenFOAMReader* op = static_cast<vtkOpenFOAMReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->EnableAllPatchArrays();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenFOAMReader_SetCreateCellToPoint_139(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkOpenFOAMReader* op = static_cast<vtkOpenFOAMReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCreateCellToPoint(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkOpenFOAMReader_GetCreateCellToPoint_140(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkOpenFOAMReader* op = static_cast<vtkOpenFOAMReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCreateCellToPoint();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenFOAMReader_CreateCellToPointOn_141(JNIEnv* env, jobject obj)
{

  vtkOpenFOAMReader* op = static_cast<vtkOpenFOAMReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->CreateCellToPointOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenFOAMReader_CreateCellToPointOff_142(JNIEnv* env, jobject obj)
{

  vtkOpenFOAMReader* op = static_cast<vtkOpenFOAMReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->CreateCellToPointOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenFOAMReader_SetSizeAverageCellToPoint_143(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkOpenFOAMReader* op = static_cast<vtkOpenFOAMReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSizeAverageCellToPoint(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkOpenFOAMReader_GetSizeAverageCellToPoint_144(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkOpenFOAMReader* op = static_cast<vtkOpenFOAMReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSizeAverageCellToPoint();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenFOAMReader_SizeAverageCellToPointOn_145(JNIEnv* env, jobject obj)
{

  vtkOpenFOAMReader* op = static_cast<vtkOpenFOAMReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SizeAverageCellToPointOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenFOAMReader_SizeAverageCellToPointOff_146(JNIEnv* env, jobject obj)
{

  vtkOpenFOAMReader* op = static_cast<vtkOpenFOAMReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SizeAverageCellToPointOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenFOAMReader_SetCacheMesh_147(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkOpenFOAMReader* op = static_cast<vtkOpenFOAMReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCacheMesh(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkOpenFOAMReader_GetCacheMesh_148(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkOpenFOAMReader* op = static_cast<vtkOpenFOAMReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCacheMesh();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenFOAMReader_CacheMeshOn_149(JNIEnv* env, jobject obj)
{

  vtkOpenFOAMReader* op = static_cast<vtkOpenFOAMReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->CacheMeshOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenFOAMReader_CacheMeshOff_150(JNIEnv* env, jobject obj)
{

  vtkOpenFOAMReader* op = static_cast<vtkOpenFOAMReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->CacheMeshOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenFOAMReader_SetPositionsIsIn13Format_151(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkOpenFOAMReader* op = static_cast<vtkOpenFOAMReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPositionsIsIn13Format(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkOpenFOAMReader_GetPositionsIsIn13Format_152(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkOpenFOAMReader* op = static_cast<vtkOpenFOAMReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPositionsIsIn13Format();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenFOAMReader_PositionsIsIn13FormatOn_153(JNIEnv* env, jobject obj)
{

  vtkOpenFOAMReader* op = static_cast<vtkOpenFOAMReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->PositionsIsIn13FormatOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenFOAMReader_PositionsIsIn13FormatOff_154(JNIEnv* env, jobject obj)
{

  vtkOpenFOAMReader* op = static_cast<vtkOpenFOAMReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->PositionsIsIn13FormatOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenFOAMReader_SetSkipZeroTime_155(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkOpenFOAMReader* op = static_cast<vtkOpenFOAMReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSkipZeroTime(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkOpenFOAMReader_GetSkipZeroTime_156(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkOpenFOAMReader* op = static_cast<vtkOpenFOAMReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSkipZeroTime();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenFOAMReader_SkipZeroTimeOn_157(JNIEnv* env, jobject obj)
{

  vtkOpenFOAMReader* op = static_cast<vtkOpenFOAMReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SkipZeroTimeOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenFOAMReader_SkipZeroTimeOff_158(JNIEnv* env, jobject obj)
{

  vtkOpenFOAMReader* op = static_cast<vtkOpenFOAMReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SkipZeroTimeOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenFOAMReader_SetListTimeStepsByControlDict_159(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkOpenFOAMReader* op = static_cast<vtkOpenFOAMReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetListTimeStepsByControlDict(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkOpenFOAMReader_GetListTimeStepsByControlDict_160(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkOpenFOAMReader* op = static_cast<vtkOpenFOAMReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetListTimeStepsByControlDict();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenFOAMReader_ListTimeStepsByControlDictOn_161(JNIEnv* env, jobject obj)
{

  vtkOpenFOAMReader* op = static_cast<vtkOpenFOAMReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->ListTimeStepsByControlDictOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenFOAMReader_ListTimeStepsByControlDictOff_162(JNIEnv* env, jobject obj)
{

  vtkOpenFOAMReader* op = static_cast<vtkOpenFOAMReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->ListTimeStepsByControlDictOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenFOAMReader_SetAddDimensionsToArrayNames_163(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkOpenFOAMReader* op = static_cast<vtkOpenFOAMReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAddDimensionsToArrayNames(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkOpenFOAMReader_GetAddDimensionsToArrayNames_164(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkOpenFOAMReader* op = static_cast<vtkOpenFOAMReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAddDimensionsToArrayNames();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenFOAMReader_AddDimensionsToArrayNamesOn_165(JNIEnv* env, jobject obj)
{

  vtkOpenFOAMReader* op = static_cast<vtkOpenFOAMReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddDimensionsToArrayNamesOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenFOAMReader_AddDimensionsToArrayNamesOff_166(JNIEnv* env, jobject obj)
{

  vtkOpenFOAMReader* op = static_cast<vtkOpenFOAMReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddDimensionsToArrayNamesOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenFOAMReader_SetReadZones_167(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkOpenFOAMReader* op = static_cast<vtkOpenFOAMReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetReadZones(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkOpenFOAMReader_GetReadZones_168(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkOpenFOAMReader* op = static_cast<vtkOpenFOAMReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetReadZones();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenFOAMReader_ReadZonesOn_169(JNIEnv* env, jobject obj)
{

  vtkOpenFOAMReader* op = static_cast<vtkOpenFOAMReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReadZonesOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenFOAMReader_ReadZonesOff_170(JNIEnv* env, jobject obj)
{

  vtkOpenFOAMReader* op = static_cast<vtkOpenFOAMReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReadZonesOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenFOAMReader_SetUse64BitLabels_171(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkOpenFOAMReader* op = static_cast<vtkOpenFOAMReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUse64BitLabels(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkOpenFOAMReader_GetUse64BitLabels_172(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkOpenFOAMReader* op = static_cast<vtkOpenFOAMReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUse64BitLabels();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenFOAMReader_Use64BitLabelsOn_173(JNIEnv* env, jobject obj)
{

  vtkOpenFOAMReader* op = static_cast<vtkOpenFOAMReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->Use64BitLabelsOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenFOAMReader_Use64BitLabelsOff_174(JNIEnv* env, jobject obj)
{

  vtkOpenFOAMReader* op = static_cast<vtkOpenFOAMReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->Use64BitLabelsOff();

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkOpenFOAMReader_GetCopyDataToCellZones_175(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkOpenFOAMReader* op = static_cast<vtkOpenFOAMReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCopyDataToCellZones();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenFOAMReader_SetCopyDataToCellZones_176(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkOpenFOAMReader* op = static_cast<vtkOpenFOAMReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCopyDataToCellZones(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenFOAMReader_CopyDataToCellZonesOn_177(JNIEnv* env, jobject obj)
{

  vtkOpenFOAMReader* op = static_cast<vtkOpenFOAMReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->CopyDataToCellZonesOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenFOAMReader_CopyDataToCellZonesOff_178(JNIEnv* env, jobject obj)
{

  vtkOpenFOAMReader* op = static_cast<vtkOpenFOAMReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->CopyDataToCellZonesOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenFOAMReader_SetUse64BitFloats_179(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkOpenFOAMReader* op = static_cast<vtkOpenFOAMReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUse64BitFloats(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkOpenFOAMReader_GetUse64BitFloats_180(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkOpenFOAMReader* op = static_cast<vtkOpenFOAMReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUse64BitFloats();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenFOAMReader_Use64BitFloatsOn_181(JNIEnv* env, jobject obj)
{

  vtkOpenFOAMReader* op = static_cast<vtkOpenFOAMReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->Use64BitFloatsOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenFOAMReader_Use64BitFloatsOff_182(JNIEnv* env, jobject obj)
{

  vtkOpenFOAMReader* op = static_cast<vtkOpenFOAMReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->Use64BitFloatsOff();

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkOpenFOAMReader_GetIgnoreRestartFiles_183(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkOpenFOAMReader* op = static_cast<vtkOpenFOAMReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetIgnoreRestartFiles();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenFOAMReader_SetIgnoreRestartFiles_184(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkOpenFOAMReader* op = static_cast<vtkOpenFOAMReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetIgnoreRestartFiles(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenFOAMReader_IgnoreRestartFilesOn_185(JNIEnv* env, jobject obj)
{

  vtkOpenFOAMReader* op = static_cast<vtkOpenFOAMReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->IgnoreRestartFilesOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenFOAMReader_IgnoreRestartFilesOff_186(JNIEnv* env, jobject obj)
{

  vtkOpenFOAMReader* op = static_cast<vtkOpenFOAMReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->IgnoreRestartFilesOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenFOAMReader_SetRefresh_187(JNIEnv* env, jobject obj)
{

  vtkOpenFOAMReader* op = static_cast<vtkOpenFOAMReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRefresh();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenFOAMReader_SetParent_188(JNIEnv* env, jobject obj,jobject id0)
{
  vtkOpenFOAMReader * temp0;
  temp0 = static_cast<vtkOpenFOAMReader*>(vtkJavaGetPointerFromObject(env, id0));

  vtkOpenFOAMReader* op = static_cast<vtkOpenFOAMReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetParent(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkOpenFOAMReader_GetTimeValue_189(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkOpenFOAMReader* op = static_cast<vtkOpenFOAMReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTimeValue();
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkOpenFOAMReader_SetTimeValue_190(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  bool   temp20;
  temp0 = id0;

  vtkOpenFOAMReader* op = static_cast<vtkOpenFOAMReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->SetTimeValue(temp0);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkOpenFOAMReader_GetTimeNames_191(JNIEnv* env, jobject obj)
{
  vtkStringArray * temp20;

  vtkOpenFOAMReader* op = static_cast<vtkOpenFOAMReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTimeNames();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkOpenFOAMReader_GetTimeValues_192(JNIEnv* env, jobject obj)
{
  vtkDoubleArray * temp20;

  vtkOpenFOAMReader* op = static_cast<vtkOpenFOAMReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTimeValues();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkOpenFOAMReader_MakeMetaDataAtTimeStep_193(JNIEnv* env, jobject obj,jboolean id0,jboolean id1)
{
  bool   temp0;
  bool   temp1;
  int   temp20;
  temp0 = (id0 != 0) ? true : false;
  temp1 = (id1 != 0) ? true : false;

  vtkOpenFOAMReader* op = static_cast<vtkOpenFOAMReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->MakeMetaDataAtTimeStep(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkOpenFOAMReader_ComputeProgress_194(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkOpenFOAMReader* op = static_cast<vtkOpenFOAMReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ComputeProgress();
  return temp20;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkOpenFOAMReader_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkOpenFOAMReader::New());
}
