// java wrapper for vtkImageBlend object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkImageBlend.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkThreadedImageAlgorithm_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkImageBlend_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkImageBlend",dType)) { return me; }
  if ((res= vtkThreadedImageAlgorithm_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageBlend_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageBlend* op = static_cast<vtkImageBlend*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageBlend_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageBlend* op = static_cast<vtkImageBlend*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageBlend_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageBlend* op = static_cast<vtkImageBlend*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageBlend_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageBlend* op = static_cast<vtkImageBlend*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageBlend_ReplaceNthInputConnection_14(JNIEnv* env, jobject obj,jint id0,jobject id1)
{
  int   temp0;
  vtkAlgorithmOutput * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkAlgorithmOutput*>(vtkJavaGetPointerFromObject(env, id1));

  vtkImageBlend* op = static_cast<vtkImageBlend*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReplaceNthInputConnection(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageBlend_SetInputData_15(JNIEnv* env, jobject obj,jint id0,jobject id1)
{
  int   temp0;
  vtkDataObject * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id1));

  vtkImageBlend* op = static_cast<vtkImageBlend*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInputData(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageBlend_SetInputData_16(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataObject * temp0;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkImageBlend* op = static_cast<vtkImageBlend*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInputData(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageBlend_GetInput_17(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkDataObject * temp20;
  temp0 = id0;

  vtkImageBlend* op = static_cast<vtkImageBlend*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInput(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageBlend_GetInput_18(JNIEnv* env, jobject obj)
{
  vtkDataObject * temp20;

  vtkImageBlend* op = static_cast<vtkImageBlend*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInput();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageBlend_GetNumberOfInputs_19(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageBlend* op = static_cast<vtkImageBlend*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfInputs();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageBlend_SetOpacity_110(JNIEnv* env, jobject obj,jint id0,jdouble id1)
{
  int   temp0;
  double   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkImageBlend* op = static_cast<vtkImageBlend*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOpacity(temp0,temp1);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkImageBlend_GetOpacity_111(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  double   temp20;
  temp0 = id0;

  vtkImageBlend* op = static_cast<vtkImageBlend*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOpacity(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageBlend_SetStencilConnection_112(JNIEnv* env, jobject obj,jobject id0)
{
  vtkAlgorithmOutput * temp0;
  temp0 = static_cast<vtkAlgorithmOutput*>(vtkJavaGetPointerFromObject(env, id0));

  vtkImageBlend* op = static_cast<vtkImageBlend*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetStencilConnection(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageBlend_SetStencilData_113(JNIEnv* env, jobject obj,jobject id0)
{
  vtkImageStencilData * temp0;
  temp0 = static_cast<vtkImageStencilData*>(vtkJavaGetPointerFromObject(env, id0));

  vtkImageBlend* op = static_cast<vtkImageBlend*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetStencilData(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageBlend_GetStencil_114(JNIEnv* env, jobject obj)
{
  vtkImageStencilData * temp20;

  vtkImageBlend* op = static_cast<vtkImageBlend*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetStencil();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageBlend_SetBlendMode_115(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkImageBlend* op = static_cast<vtkImageBlend*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBlendMode(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageBlend_GetBlendModeMinValue_116(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageBlend* op = static_cast<vtkImageBlend*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBlendModeMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageBlend_GetBlendModeMaxValue_117(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageBlend* op = static_cast<vtkImageBlend*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBlendModeMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageBlend_GetBlendMode_118(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageBlend* op = static_cast<vtkImageBlend*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBlendMode();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageBlend_SetBlendModeToNormal_119(JNIEnv* env, jobject obj)
{

  vtkImageBlend* op = static_cast<vtkImageBlend*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBlendModeToNormal();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageBlend_SetBlendModeToCompound_120(JNIEnv* env, jobject obj)
{

  vtkImageBlend* op = static_cast<vtkImageBlend*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBlendModeToCompound();

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkImageBlend_GetBlendModeAsString_121(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkImageBlend* op = static_cast<vtkImageBlend*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBlendModeAsString();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageBlend_SetBlendAlpha_122(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkImageBlend* op = static_cast<vtkImageBlend*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBlendAlpha(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageBlend_GetBlendAlpha_123(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageBlend* op = static_cast<vtkImageBlend*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBlendAlpha();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageBlend_BlendAlphaOn_124(JNIEnv* env, jobject obj)
{

  vtkImageBlend* op = static_cast<vtkImageBlend*>(vtkJavaGetPointerFromObject(env, obj));
  op->BlendAlphaOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageBlend_BlendAlphaOff_125(JNIEnv* env, jobject obj)
{

  vtkImageBlend* op = static_cast<vtkImageBlend*>(vtkJavaGetPointerFromObject(env, obj));
  op->BlendAlphaOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageBlend_SetCompoundThreshold_126(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkImageBlend* op = static_cast<vtkImageBlend*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCompoundThreshold(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkImageBlend_GetCompoundThreshold_127(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkImageBlend* op = static_cast<vtkImageBlend*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCompoundThreshold();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageBlend_SetCompoundAlpha_128(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkImageBlend* op = static_cast<vtkImageBlend*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCompoundAlpha(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageBlend_GetCompoundAlpha_129(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageBlend* op = static_cast<vtkImageBlend*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCompoundAlpha();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageBlend_CompoundAlphaOn_130(JNIEnv* env, jobject obj)
{

  vtkImageBlend* op = static_cast<vtkImageBlend*>(vtkJavaGetPointerFromObject(env, obj));
  op->CompoundAlphaOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageBlend_CompoundAlphaOff_131(JNIEnv* env, jobject obj)
{

  vtkImageBlend* op = static_cast<vtkImageBlend*>(vtkJavaGetPointerFromObject(env, obj));
  op->CompoundAlphaOff();

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkImageBlend_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkImageBlend::New());
}
