// java wrapper for vtkRandomGraphSource object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkRandomGraphSource.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkGraphAlgorithm_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkRandomGraphSource_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkRandomGraphSource",dType)) { return me; }
  if ((res= vtkGraphAlgorithm_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRandomGraphSource_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkRandomGraphSource* op = static_cast<vtkRandomGraphSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRandomGraphSource_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkRandomGraphSource* op = static_cast<vtkRandomGraphSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkRandomGraphSource_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkRandomGraphSource* op = static_cast<vtkRandomGraphSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkRandomGraphSource_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkRandomGraphSource* op = static_cast<vtkRandomGraphSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRandomGraphSource_GetNumberOfVertices_14(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkRandomGraphSource* op = static_cast<vtkRandomGraphSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfVertices();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRandomGraphSource_SetNumberOfVertices_15(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkRandomGraphSource* op = static_cast<vtkRandomGraphSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNumberOfVertices(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRandomGraphSource_GetNumberOfVerticesMinValue_16(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkRandomGraphSource* op = static_cast<vtkRandomGraphSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfVerticesMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRandomGraphSource_GetNumberOfVerticesMaxValue_17(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkRandomGraphSource* op = static_cast<vtkRandomGraphSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfVerticesMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRandomGraphSource_GetNumberOfEdges_18(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkRandomGraphSource* op = static_cast<vtkRandomGraphSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfEdges();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRandomGraphSource_SetNumberOfEdges_19(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkRandomGraphSource* op = static_cast<vtkRandomGraphSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNumberOfEdges(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRandomGraphSource_GetNumberOfEdgesMinValue_110(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkRandomGraphSource* op = static_cast<vtkRandomGraphSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfEdgesMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRandomGraphSource_GetNumberOfEdgesMaxValue_111(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkRandomGraphSource* op = static_cast<vtkRandomGraphSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfEdgesMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkRandomGraphSource_GetEdgeProbability_112(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkRandomGraphSource* op = static_cast<vtkRandomGraphSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEdgeProbability();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRandomGraphSource_SetEdgeProbability_113(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkRandomGraphSource* op = static_cast<vtkRandomGraphSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEdgeProbability(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkRandomGraphSource_GetEdgeProbabilityMinValue_114(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkRandomGraphSource* op = static_cast<vtkRandomGraphSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEdgeProbabilityMinValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkRandomGraphSource_GetEdgeProbabilityMaxValue_115(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkRandomGraphSource* op = static_cast<vtkRandomGraphSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEdgeProbabilityMaxValue();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRandomGraphSource_SetIncludeEdgeWeights_116(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkRandomGraphSource* op = static_cast<vtkRandomGraphSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetIncludeEdgeWeights(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkRandomGraphSource_GetIncludeEdgeWeights_117(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkRandomGraphSource* op = static_cast<vtkRandomGraphSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetIncludeEdgeWeights();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRandomGraphSource_IncludeEdgeWeightsOn_118(JNIEnv* env, jobject obj)
{

  vtkRandomGraphSource* op = static_cast<vtkRandomGraphSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->IncludeEdgeWeightsOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRandomGraphSource_IncludeEdgeWeightsOff_119(JNIEnv* env, jobject obj)
{

  vtkRandomGraphSource* op = static_cast<vtkRandomGraphSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->IncludeEdgeWeightsOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRandomGraphSource_SetEdgeWeightArrayName_120(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkRandomGraphSource* op = static_cast<vtkRandomGraphSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEdgeWeightArrayName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkRandomGraphSource_GetEdgeWeightArrayName_121(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkRandomGraphSource* op = static_cast<vtkRandomGraphSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEdgeWeightArrayName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRandomGraphSource_SetDirected_122(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkRandomGraphSource* op = static_cast<vtkRandomGraphSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDirected(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkRandomGraphSource_GetDirected_123(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkRandomGraphSource* op = static_cast<vtkRandomGraphSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDirected();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRandomGraphSource_DirectedOn_124(JNIEnv* env, jobject obj)
{

  vtkRandomGraphSource* op = static_cast<vtkRandomGraphSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->DirectedOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRandomGraphSource_DirectedOff_125(JNIEnv* env, jobject obj)
{

  vtkRandomGraphSource* op = static_cast<vtkRandomGraphSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->DirectedOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRandomGraphSource_SetUseEdgeProbability_126(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkRandomGraphSource* op = static_cast<vtkRandomGraphSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUseEdgeProbability(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkRandomGraphSource_GetUseEdgeProbability_127(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkRandomGraphSource* op = static_cast<vtkRandomGraphSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUseEdgeProbability();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRandomGraphSource_UseEdgeProbabilityOn_128(JNIEnv* env, jobject obj)
{

  vtkRandomGraphSource* op = static_cast<vtkRandomGraphSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseEdgeProbabilityOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRandomGraphSource_UseEdgeProbabilityOff_129(JNIEnv* env, jobject obj)
{

  vtkRandomGraphSource* op = static_cast<vtkRandomGraphSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseEdgeProbabilityOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRandomGraphSource_SetStartWithTree_130(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkRandomGraphSource* op = static_cast<vtkRandomGraphSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetStartWithTree(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkRandomGraphSource_GetStartWithTree_131(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkRandomGraphSource* op = static_cast<vtkRandomGraphSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetStartWithTree();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRandomGraphSource_StartWithTreeOn_132(JNIEnv* env, jobject obj)
{

  vtkRandomGraphSource* op = static_cast<vtkRandomGraphSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->StartWithTreeOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRandomGraphSource_StartWithTreeOff_133(JNIEnv* env, jobject obj)
{

  vtkRandomGraphSource* op = static_cast<vtkRandomGraphSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->StartWithTreeOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRandomGraphSource_SetAllowSelfLoops_134(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkRandomGraphSource* op = static_cast<vtkRandomGraphSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAllowSelfLoops(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkRandomGraphSource_GetAllowSelfLoops_135(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkRandomGraphSource* op = static_cast<vtkRandomGraphSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAllowSelfLoops();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRandomGraphSource_AllowSelfLoopsOn_136(JNIEnv* env, jobject obj)
{

  vtkRandomGraphSource* op = static_cast<vtkRandomGraphSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->AllowSelfLoopsOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRandomGraphSource_AllowSelfLoopsOff_137(JNIEnv* env, jobject obj)
{

  vtkRandomGraphSource* op = static_cast<vtkRandomGraphSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->AllowSelfLoopsOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRandomGraphSource_SetAllowParallelEdges_138(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkRandomGraphSource* op = static_cast<vtkRandomGraphSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAllowParallelEdges(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkRandomGraphSource_GetAllowParallelEdges_139(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkRandomGraphSource* op = static_cast<vtkRandomGraphSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAllowParallelEdges();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRandomGraphSource_AllowParallelEdgesOn_140(JNIEnv* env, jobject obj)
{

  vtkRandomGraphSource* op = static_cast<vtkRandomGraphSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->AllowParallelEdgesOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRandomGraphSource_AllowParallelEdgesOff_141(JNIEnv* env, jobject obj)
{

  vtkRandomGraphSource* op = static_cast<vtkRandomGraphSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->AllowParallelEdgesOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRandomGraphSource_SetGeneratePedigreeIds_142(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkRandomGraphSource* op = static_cast<vtkRandomGraphSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetGeneratePedigreeIds(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkRandomGraphSource_GetGeneratePedigreeIds_143(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkRandomGraphSource* op = static_cast<vtkRandomGraphSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGeneratePedigreeIds();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRandomGraphSource_GeneratePedigreeIdsOn_144(JNIEnv* env, jobject obj)
{

  vtkRandomGraphSource* op = static_cast<vtkRandomGraphSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->GeneratePedigreeIdsOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRandomGraphSource_GeneratePedigreeIdsOff_145(JNIEnv* env, jobject obj)
{

  vtkRandomGraphSource* op = static_cast<vtkRandomGraphSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->GeneratePedigreeIdsOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRandomGraphSource_SetVertexPedigreeIdArrayName_146(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkRandomGraphSource* op = static_cast<vtkRandomGraphSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetVertexPedigreeIdArrayName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkRandomGraphSource_GetVertexPedigreeIdArrayName_147(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkRandomGraphSource* op = static_cast<vtkRandomGraphSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetVertexPedigreeIdArrayName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRandomGraphSource_SetEdgePedigreeIdArrayName_148(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkRandomGraphSource* op = static_cast<vtkRandomGraphSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEdgePedigreeIdArrayName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkRandomGraphSource_GetEdgePedigreeIdArrayName_149(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkRandomGraphSource* op = static_cast<vtkRandomGraphSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEdgePedigreeIdArrayName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkRandomGraphSource_SetSeed_150(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkRandomGraphSource* op = static_cast<vtkRandomGraphSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSeed(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkRandomGraphSource_GetSeed_151(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkRandomGraphSource* op = static_cast<vtkRandomGraphSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSeed();
  return temp20;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkRandomGraphSource_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkRandomGraphSource::New());
}
