/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSShadowRootInit.h"

#include "JSCustomElementRegistry.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertOptional.h"
#include "JSDOMConvertStrings.h"
#include "JSShadowRootMode.h"
#include "JSSlotAssignmentMode.h"
#include "ScriptExecutionContext.h"
#include "Settings.h"
#include <JavaScriptCore/JSCInlines.h>



namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<ShadowRootInit>> convertDictionary<ShadowRootInit>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (!isNullOrUndefined && !object) [[unlikely]] {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    ShadowRootInit result;
    JSValue clonableValue;
    if (isNullOrUndefined)
        clonableValue = jsUndefined();
    else {
        clonableValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "clonable"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto clonableConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, clonableValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (clonableConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.clonable = clonableConversionResult.releaseReturnValue();
    if (jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject)->scriptExecutionContext()->settingsValues().scopedCustomElementRegistryEnabled) {
        JSValue customElementRegistryValue;
        if (isNullOrUndefined)
            customElementRegistryValue = jsUndefined();
        else {
            customElementRegistryValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "customElementRegistry"_s));
            RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
        }
        auto customElementRegistryConversionResult = convertOptionalWithDefault<IDLNullable<IDLInterface<CustomElementRegistry>>>(lexicalGlobalObject, customElementRegistryValue, [&]() -> ConversionResult<IDLNullable<IDLInterface<CustomElementRegistry>>> { return typename Converter<IDLNullable<IDLInterface<CustomElementRegistry>>>::ReturnType { nullptr }; });
        if (customElementRegistryConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.customElementRegistry = customElementRegistryConversionResult.releaseReturnValue();
    }
    JSValue delegatesFocusValue;
    if (isNullOrUndefined)
        delegatesFocusValue = jsUndefined();
    else {
        delegatesFocusValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "delegatesFocus"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto delegatesFocusConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, delegatesFocusValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (delegatesFocusConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.delegatesFocus = delegatesFocusConversionResult.releaseReturnValue();
    JSValue modeValue;
    if (isNullOrUndefined)
        modeValue = jsUndefined();
    else {
        modeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "mode"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (modeValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "mode"_s, "ShadowRootInit"_s, "ShadowRootMode"_s);
        return ConversionResultException { };
    }
    auto modeConversionResult = convert<IDLEnumeration<ShadowRootMode>>(lexicalGlobalObject, modeValue);
    if (modeConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.mode = modeConversionResult.releaseReturnValue();
    if (jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject)->scriptExecutionContext()->settingsValues().shadowRootReferenceTargetEnabled) {
        JSValue referenceTargetValue;
        if (isNullOrUndefined)
            referenceTargetValue = jsUndefined();
        else {
            referenceTargetValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "referenceTarget"_s));
            RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
        }
        if (!referenceTargetValue.isUndefined()) {
            auto referenceTargetConversionResult = convert<IDLDOMString>(lexicalGlobalObject, referenceTargetValue);
            if (referenceTargetConversionResult.hasException(throwScope)) [[unlikely]]
                return ConversionResultException { };
            result.referenceTarget = referenceTargetConversionResult.releaseReturnValue();
        }
    }
    JSValue serializableValue;
    if (isNullOrUndefined)
        serializableValue = jsUndefined();
    else {
        serializableValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "serializable"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto serializableConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, serializableValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (serializableConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.serializable = serializableConversionResult.releaseReturnValue();
    JSValue slotAssignmentValue;
    if (isNullOrUndefined)
        slotAssignmentValue = jsUndefined();
    else {
        slotAssignmentValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "slotAssignment"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto slotAssignmentConversionResult = convertOptionalWithDefault<IDLEnumeration<SlotAssignmentMode>>(lexicalGlobalObject, slotAssignmentValue, [&]() -> ConversionResult<IDLEnumeration<SlotAssignmentMode>> { return Converter<IDLEnumeration<SlotAssignmentMode>>::ReturnType { SlotAssignmentMode::Named }; });
    if (slotAssignmentConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.slotAssignment = slotAssignmentConversionResult.releaseReturnValue();
    return result;
}

} // namespace WebCore

