/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator.database.load;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.graphics.Image;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.ui.internal.UINavigatorMessages;
import org.jkiss.dbeaver.ui.navigator.database.load.TreeNodeSpecial;

public class TreeNodeChildrenLoading
extends TreeNodeSpecial {
    private static final Map<Object, Object> loadingFiles = new HashMap<Object, Object>();
    private static final Map<DBNNode, TreeNodeChildrenLoading> placeHolders = new HashMap<DBNNode, TreeNodeChildrenLoading>();
    private static final String loadingText = UINavigatorMessages.ui_navigator_loading_text_loading;
    private int viewCount = 0;

    public static synchronized TreeNodeChildrenLoading createLoadingPlaceHolder(DBNNode parent) {
        TreeNodeChildrenLoading node = placeHolders.get(parent);
        if (node == null) {
            node = new TreeNodeChildrenLoading(parent);
            placeHolders.put(parent, node);
        }
        return node;
    }

    protected TreeNodeChildrenLoading(DBNNode parent) {
        super(parent);
    }

    public String getText(Object element) {
        ++this.viewCount;
        int dotCount = this.viewCount % 10;
        return loadingText + ".".repeat(dotCount);
    }

    public Image getImage(Object element) {
        return null;
    }

    @Override
    public void dispose(DBNNode parent) {
        super.dispose();
        loadingFiles.remove(parent);
        placeHolders.remove(parent);
    }

    public static synchronized boolean canBeginLoading(Object parent) {
        if (!loadingFiles.containsKey(parent)) {
            loadingFiles.put(parent, null);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isLoading() {
        Map<Object, Object> map = loadingFiles;
        synchronized (map) {
            return !loadingFiles.isEmpty();
        }
    }
}

