/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import javax.swing.JComponent;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.view.swing.map.CloudHeightCalculator;
import org.freeplane.view.swing.map.ContentSizeCalculator;
import org.freeplane.view.swing.map.INodeViewLayout;
import org.freeplane.view.swing.map.ImmediatelyValidatingPreferredSizeCalculator;
import org.freeplane.view.swing.map.NodeView;

public class OutlineLayout
implements INodeViewLayout {
    private static final INodeViewLayout instance = new OutlineLayout();

    static INodeViewLayout getInstance() {
        return instance;
    }

    @Override
    public void layoutContainer(Container c) {
        int x;
        NodeView view = (NodeView)c;
        JComponent content = view.getContent();
        if (content == null) {
            return;
        }
        content.setVisible(view.isContentVisible());
        int y = x = view.getSpaceAround();
        Dimension contentProfSize = ContentSizeCalculator.INSTANCE.calculateContentSize(view);
        content.setBounds(x, y, contentProfSize.width, contentProfSize.height);
        this.placeChildren(view);
    }

    private void placeChildren(NodeView view) {
        int childCount = view.getComponentCount() - 1;
        for (int i = 0; i < childCount; ++i) {
            Component component = view.getComponent(i);
            ((NodeView)component).validateTree();
        }
        int spaceAround = view.getSpaceAround();
        int hgapProperty = ResourceController.getResourceController().getLengthProperty("outline_hgap");
        int hgap = view.getMap().getZoomed(hgapProperty);
        int vgapPropertyValue = ResourceController.getResourceController().getLengthProperty("outline_vgap");
        int vgap = view.getMap().getZoomed(vgapPropertyValue);
        JComponent content = view.getContent();
        int baseX = content.getX();
        int y = content.getY() + content.getHeight() - spaceAround;
        if (content.isVisible()) {
            baseX += hgap;
            y += vgap;
        } else if (view.isSummary()) {
            baseX += hgap;
        }
        int right = baseX + content.getWidth() + spaceAround;
        NodeView child = null;
        for (int i = 0; i < childCount; ++i) {
            NodeView component;
            child = component = (NodeView)view.getComponent(i);
            int additionalCloudHeight = CloudHeightCalculator.INSTANCE.getAdditionalCloudHeight(child) / 2;
            int x = baseX - child.getContent().getX();
            child.setLocation(x, y += additionalCloudHeight);
            int childHeight = child.getHeight() - 2 * spaceAround;
            if (childHeight != 0) {
                y += childHeight + vgap + additionalCloudHeight;
            }
            right = Math.max(right, x + child.getWidth() + additionalCloudHeight);
        }
        int bottom = content.getY() + content.getHeight() + spaceAround;
        if (child != null) {
            NodeView node = child;
            view.setSize(right, Math.max(bottom, child.getY() + child.getHeight() + CloudHeightCalculator.INSTANCE.getAdditionalCloudHeight(node) / 2));
        } else {
            view.setSize(right, bottom);
        }
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        return ImmediatelyValidatingPreferredSizeCalculator.INSTANCE.preferredLayoutSize(parent);
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return INodeViewLayout.ZERO_DIMENSION;
    }
}

