/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.icon.mindmapmode;

import java.awt.Component;
import java.awt.Font;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.freeplane.core.ui.components.TagIcon;
import org.freeplane.features.icon.Tag;
import org.freeplane.features.icon.TagCategories;

class TagCellRenderer
extends DefaultTreeCellRenderer {
    private final TagCategories tagCategories;

    public TagCellRenderer(TagCategories tagCategories) {
        this.tagCategories = tagCategories;
        this.setHorizontalAlignment(0);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, null, sel, expanded, leaf, row, hasFocus);
        if (value instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            Tag tag = this.tagCategories.tagWithoutCategories(node);
            if (!tag.isEmpty()) {
                this.setText(null);
                Font font = this.getFont();
                this.setIcon((Icon)new TagIcon(tag, font, this.getFontMetrics(font).getFontRenderContext()));
            } else if (node.getUserObject() != null) {
                this.setText(node.getUserObject().toString());
            }
        }
        return this;
    }
}

