/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.sql.internal;

import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.Size;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.converter.internal.EnumHelper;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.sql.DdlType;
import org.hibernate.type.descriptor.sql.spi.DdlTypeRegistry;

public class NativeOrdinalEnumDdlTypeImpl
implements DdlType {
    private final Dialect dialect;

    public NativeOrdinalEnumDdlTypeImpl(Dialect dialect) {
        this.dialect = dialect;
    }

    @Override
    public int getSqlTypeCode() {
        return 6002;
    }

    @Override
    public String getTypeName(Size columnSize, Type type, DdlTypeRegistry ddlTypeRegistry) {
        return this.dialect.getEnumTypeDeclaration(type.getReturnedClass().getSimpleName(), EnumHelper.getEnumeratedValues(type));
    }

    @Override
    public String getRawTypeName() {
        return "enum";
    }

    @Override
    public String getTypeName(Long size, Integer precision, Integer scale) {
        return "int";
    }

    @Override
    public String getCastTypeName(JdbcType jdbcType, JavaType<?> javaType) {
        return "int";
    }

    @Override
    public String getCastTypeName(JdbcType jdbcType, JavaType<?> javaType, Long length, Integer precision, Integer scale) {
        return this.getTypeName(length, precision, scale);
    }
}

