/*
 * Decompiled with CFR 0.152.
 */
package io.github.dmlloyd.classfile.instruction;

import io.github.dmlloyd.classfile.Instruction;
import io.github.dmlloyd.classfile.Label;
import io.github.dmlloyd.classfile.Opcode;
import io.github.dmlloyd.classfile.impl.AbstractInstruction;
import io.github.dmlloyd.classfile.impl.BytecodeHelpers;
import io.github.dmlloyd.classfile.impl.Util;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface DiscontinuedInstruction
extends Instruction {

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface RetInstruction
    extends DiscontinuedInstruction {
        public int slot();

        public static RetInstruction of(Opcode op, int slot) {
            BytecodeHelpers.validateRet(op, slot);
            return new AbstractInstruction.UnboundRetInstruction(op, slot);
        }

        public static RetInstruction of(int slot) {
            return RetInstruction.of(slot < 256 ? Opcode.RET : Opcode.RET_W, slot);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface JsrInstruction
    extends DiscontinuedInstruction {
        public Label target();

        public static JsrInstruction of(Opcode op, Label target) {
            Util.checkKind(op, Opcode.Kind.DISCONTINUED_JSR);
            return new AbstractInstruction.UnboundJsrInstruction(op, target);
        }

        public static JsrInstruction of(Label target) {
            return JsrInstruction.of(Opcode.JSR, target);
        }
    }
}

