/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, digital, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_digital_header_buffer = R"doc(Helper class for handling payload headers.

This class is used by the header format blocks (e.g., digital::header_format_default) to make it easier to deal with payload headers. This class functions in two different ways depending on if it is used in a transmitter or receiver. When used in a transmitter, this class helps us build headers out of the fields of the protocol. When used in a receiver, this class helps us parse the received bits into the protocol's fields.


This page describes how to work with the different modes, transmit or receive. The class is instructed as to which mode it is in by how the constructor is called. If the constructor is passed a valid array (non NULL), then it is in transmit mode and will pack this buffer with the header fields. If that buffer is NULL, the object is in receive mode.



Transmit ModeWhen passed a valid buffer in the constructor, this object is in transmit mode. We can then use the add_field[N] functions to add new fields to this header. The buffer MUST be large enough to hold the full header. As this class is meant to work mostly with the digital::header_format_default and child classes, the header length can be read from digital::header_format_default::header_nbytes().


Each field is a specific length of 8, 16, 32, or 64 bits that are to be transmitted in network byte order. We can adjust the direction of the bytes by setting the byte-swap flag, , to true or false.


The length argument () for all add_field[N] calls is the number of bytes actually accounted for in the data structure. Often, we would use the full size of the field, which is sizeof(dtype), and the add_field[N] call defaults to len=N. Occasionally, we may need to use fewer bytes than actually represented by the data type. An example would be the access code used in the header_format_default, which is a uint64_t type but may have fewer bytes used in the actual access code.


The function that calls this class is expected to handle the memory handling of the buffer  both allocating and deallocating.


As simple example of using this class in transmit mode:





In this example, the header contains four fields:





The sync word can be up to 64-bits, but the add_field64 is also passed the number of actual bytes in the sync word and so could be fewer.




Receive ModeIn receive mode, we build up the header as bits are received by inserting them with insert_bit. We can find out how long the current header is, in bits, using the call to length(). If the header is of the appropriate length, we can then start extracting the fields from it. When we are done with the current header, call clear() to reset the internal buffer to empty, which will mean that length() returns 0.


The header fields are extracted using the extract_field[N] functions. Like the add_field[N] functions, we specify the size (in bits) of the field we are extracting. We pass this function the bit-position of the expected field in the received header buffer. The extract_field[N] assumes that the number of bits for the field is N, but we can tell the function to use fewer bits if we want. Setting the length parameter of these functions greater than N is illegal, and it will throw an error.


For example, given a header of | length | seq. num. | where the length is 16 bits and the sequence number is 32 bits, we would use:





The extract_field functions are specific to data types of the field and the number of bits for each field is inferred by the data type. So extract_field16 assumes we want all 16 bits in the field represented.


Some headers have fields that are not standard sizes of integers, like a 1 bit, 4 bit, or even 12 bit fields. We can ask for fewer bits for each field. say:





We would use the following extraction functions:)doc";


static const char* __doc_gr_digital_header_buffer_header_buffer_0 = R"doc()doc";


static const char* __doc_gr_digital_header_buffer_header_buffer_1 = R"doc()doc";


static const char* __doc_gr_digital_header_buffer_clear = R"doc(Clears the header.


In transmit mode, this resets the current offset so new add_field functions start adding data to the start of the buffer.


In receive mode, this clears the buffer that we have inserted bits in to.)doc";


static const char* __doc_gr_digital_header_buffer_header = R"doc(Returns a constant pointer to the buffer.)doc";


static const char* __doc_gr_digital_header_buffer_add_field8 = R"doc(Add an 8-bit field to the header.)doc";


static const char* __doc_gr_digital_header_buffer_add_field16 = R"doc(Add an 16-bit field to the header.)doc";


static const char* __doc_gr_digital_header_buffer_add_field32 = R"doc(Add an 32-bit field to the header.)doc";


static const char* __doc_gr_digital_header_buffer_add_field64 = R"doc(Add an 64-bit field to the header.)doc";


static const char* __doc_gr_digital_header_buffer_insert_bit = R"doc(Insert a new bit on the back of the input buffer. This function is used in receive mode to add new bits as they are received for later use of the extract_field functions.)doc";


static const char* __doc_gr_digital_header_buffer_extract_field8 = R"doc(Returns up to an 8-bit field in the packet header.)doc";


static const char* __doc_gr_digital_header_buffer_extract_field16 = R"doc(Returns up to a 16-bit field in the packet header.)doc";


static const char* __doc_gr_digital_header_buffer_extract_field32 = R"doc(Returns up to a 32-bit field in the packet header.)doc";


static const char* __doc_gr_digital_header_buffer_extract_field64 = R"doc(Returns up to a 64-bit field in the packet header.)doc";
