/**
 * Copyright (c) 2014-present, The osquery authors
 *
 * This source code is licensed as defined by the LICENSE file found in the
 * root directory of this source tree.
 *
 * SPDX-License-Identifier: (Apache-2.0 OR GPL-2.0-only)
 */

/*
** This file is generated. Do not modify it manually!
*/

#include <osquery/events/eventsubscriber.h>
#include <osquery/logger/logger.h>
#include <osquery/sql/dynamic_table_row.h>
#include <osquery/core/tables.h>
#include <osquery/registry/registry_factory.h>

namespace osquery {


namespace tables {
osquery::QueryData genYumSrcs(QueryContext& context);
}

class yumSourcesTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("name", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("source", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("baseurl", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("mirrorlist", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("metalink", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("enabled", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("gpgcheck", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("gpgkey", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("pid_with_namespace", INTEGER_TYPE, ColumnOptions::ADDITIONAL | ColumnOptions::HIDDEN),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::genYumSrcs(context));


    return results;
  }

};


REGISTER(yumSourcesTablePlugin, "table", "yum_sources");


namespace tables {
osquery::QueryData genArpCache(QueryContext& context);
}

class arpCacheTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("address", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("mac", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("interface", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("permanent", TEXT_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::genArpCache(context));


    return results;
  }

};


REGISTER(arpCacheTablePlugin, "table", "arp_cache");


namespace tables {
osquery::QueryData genJetBrainsPlugins(QueryContext& context);
}

class jetbrainsPluginsTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("product_type", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("uid", BIGINT_TYPE, ColumnOptions::INDEX),
      std::make_tuple("name", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("version", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("vendor", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("path", TEXT_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::USER_BASED |      TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::genJetBrainsPlugins(context));


    return results;
  }

};


REGISTER(jetbrainsPluginsTablePlugin, "table", "jetbrains_plugins");


namespace tables {
osquery::QueryData genMDDevices(QueryContext& context);
}

class mdDevicesTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("device_name", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("status", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("raid_level", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("size", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("chunk_size", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("raid_disks", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("nr_raid_disks", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("working_disks", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("active_disks", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("failed_disks", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("spare_disks", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("superblock_state", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("superblock_version", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("superblock_update_time", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("bitmap_on_mem", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("bitmap_chunk_size", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("bitmap_external_file", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("recovery_progress", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("recovery_finish", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("recovery_speed", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("resync_progress", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("resync_finish", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("resync_speed", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("reshape_progress", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("reshape_finish", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("reshape_speed", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("check_array_progress", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("check_array_finish", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("check_array_speed", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("unused_devices", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("other", TEXT_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::genMDDevices(context));


    return results;
  }

};


REGISTER(mdDevicesTablePlugin, "table", "md_devices");


namespace tables {
osquery::QueryData genEc2InstanceTags(QueryContext& context);
}

class ec2InstanceTagsTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("instance_id", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("key", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("value", TEXT_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::CACHEABLE |      TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    if (isCached(kCacheStep, context)) {
      return getCache();
    }
    TableRows results = osquery::tableRowsFromQueryData(tables::genEc2InstanceTags(context));

    setCache(kCacheStep, kCacheInterval, context, results);

    return results;
  }

};


REGISTER(ec2InstanceTagsTablePlugin, "table", "ec2_instance_tags");


namespace tables {
osquery::QueryData genPortageKeywordSummary(QueryContext& context);
}

class portageKeywordsTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("package", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("version", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("keyword", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("mask", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("unmask", INTEGER_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::genPortageKeywordSummary(context));


    return results;
  }

};


REGISTER(portageKeywordsTablePlugin, "table", "portage_keywords");


namespace tables {
osquery::QueryData genCpuInfo(QueryContext& context);
}

class cpuInfoTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("device_id", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("model", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("manufacturer", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("processor_type", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("cpu_status", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("number_of_cores", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("logical_processors", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("address_width", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("current_clock_speed", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("max_clock_speed", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("socket_designation", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("availability", TEXT_TYPE, ColumnOptions::HIDDEN),
      std::make_tuple("load_percentage", INTEGER_TYPE, ColumnOptions::HIDDEN),
      std::make_tuple("number_of_efficiency_cores", INTEGER_TYPE, ColumnOptions::HIDDEN),
      std::make_tuple("number_of_performance_cores", INTEGER_TYPE, ColumnOptions::HIDDEN),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::genCpuInfo(context));


    return results;
  }

};


REGISTER(cpuInfoTablePlugin, "table", "cpu_info");


namespace tables {
osquery::QueryData genIptables(QueryContext& context);
}

class iptablesTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("filter_name", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("chain", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("policy", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("target", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("protocol", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("src_port", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("dst_port", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("src_ip", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("src_mask", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("iniface", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("iniface_mask", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("dst_ip", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("dst_mask", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("outiface", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("outiface_mask", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("match", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("packets", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("bytes", INTEGER_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::genIptables(context));


    return results;
  }

};


REGISTER(iptablesTablePlugin, "table", "iptables");


namespace tables {

class apparmor_events {
 public:
  void genTable(RowYield& yield, QueryContext& context);
};
}

class apparmorEventsTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("type", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("message", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("time", BIGINT_TYPE, ColumnOptions::ADDITIONAL),
      std::make_tuple("uptime", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("eid", TEXT_TYPE, ColumnOptions::HIDDEN),
      std::make_tuple("apparmor", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("operation", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("parent", UNSIGNED_BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("profile", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("name", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("pid", UNSIGNED_BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("comm", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("denied_mask", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("capname", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("fsuid", UNSIGNED_BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("ouid", UNSIGNED_BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("capability", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("requested_mask", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("info", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("error", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("namespace", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("label", TEXT_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::EVENT_BASED |      TableAttributes::NONE;
  }

  bool usesGenerator() const override { return true; }

  void generator(RowYield& yield, QueryContext& context) override {
    if (EventFactory::exists(getName())) {
      auto subscriber = EventFactory::getEventSubscriber(getName());
      return subscriber->genTable(yield, context);
    } else {
      LOG(ERROR) << "Subscriber table missing: " << getName();
    }
  }

};


REGISTER(apparmorEventsTablePlugin, "table", "apparmor_events");


namespace tables {
osquery::QueryData genLxdInstanceDevices(QueryContext& context);
}

class lxdInstanceDevicesTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("name", TEXT_TYPE, ColumnOptions::INDEX | ColumnOptions::REQUIRED),
      std::make_tuple("device", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("device_type", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("key", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("value", TEXT_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::genLxdInstanceDevices(context));


    return results;
  }

};


REGISTER(lxdInstanceDevicesTablePlugin, "table", "lxd_instance_devices");


namespace tables {
osquery::QueryData genAptSrcs(QueryContext& context);
}

class aptSourcesTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("name", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("source", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("base_uri", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("release", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("version", TEXT_TYPE, ColumnOptions::COLLATEVERSION_DPKG),
      std::make_tuple("maintainer", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("components", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("architectures", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("pid_with_namespace", INTEGER_TYPE, ColumnOptions::ADDITIONAL | ColumnOptions::HIDDEN),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::genAptSrcs(context));


    return results;
  }

};


REGISTER(aptSourcesTablePlugin, "table", "apt_sources");


namespace tables {
osquery::QueryData genVSCodeExtensions(QueryContext& context);
}

class vscodeExtensionsTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("name", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("uuid", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("version", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("path", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("publisher", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("publisher_id", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("installed_at", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("prerelease", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("uid", BIGINT_TYPE, ColumnOptions::ADDITIONAL | ColumnOptions::OPTIMIZED),
      std::make_tuple("vscode_edition", TEXT_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::USER_BASED |      TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::genVSCodeExtensions(context));


    return results;
  }

};


REGISTER(vscodeExtensionsTablePlugin, "table", "vscode_extensions");


namespace tables {
osquery::QueryData getMemoryInfo(QueryContext& context);
}

class memoryInfoTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("memory_total", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("memory_free", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("memory_available", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("buffers", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("cached", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("swap_cached", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("active", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("inactive", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("swap_total", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("swap_free", BIGINT_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::getMemoryInfo(context));


    return results;
  }

};


REGISTER(memoryInfoTablePlugin, "table", "memory_info");


namespace tables {
osquery::QueryData genLxdInstances(QueryContext& context);
}

class lxdInstancesTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("name", TEXT_TYPE, ColumnOptions::INDEX),
      std::make_tuple("status", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("stateful", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("ephemeral", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("created_at", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("base_image", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("architecture", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("os", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("description", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("pid", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("processes", INTEGER_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::genLxdInstances(context));


    return results;
  }

};


REGISTER(lxdInstancesTablePlugin, "table", "lxd_instances");


namespace tables {
osquery::QueryData genAppArmorProfiles(QueryContext& context);
}

class apparmorProfilesTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("path", TEXT_TYPE, ColumnOptions::INDEX),
      std::make_tuple("name", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("attach", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("mode", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("sha1", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("sha256", TEXT_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::genAppArmorProfiles(context));


    return results;
  }

};


REGISTER(apparmorProfilesTablePlugin, "table", "apparmor_profiles");


namespace tables {

class process_file_events {
 public:
  void genTable(RowYield& yield, QueryContext& context);
};
}

class processFileEventsTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("operation", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("pid", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("ppid", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("time", BIGINT_TYPE, ColumnOptions::ADDITIONAL),
      std::make_tuple("executable", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("partial", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("cwd", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("path", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("dest_path", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("uid", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("gid", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("auid", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("euid", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("egid", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("fsuid", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("fsgid", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("suid", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("sgid", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("uptime", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("eid", TEXT_TYPE, ColumnOptions::HIDDEN),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::EVENT_BASED |      TableAttributes::NONE;
  }

  bool usesGenerator() const override { return true; }

  void generator(RowYield& yield, QueryContext& context) override {
    if (EventFactory::exists(getName())) {
      auto subscriber = EventFactory::getEventSubscriber(getName());
      return subscriber->genTable(yield, context);
    } else {
      LOG(ERROR) << "Subscriber table missing: " << getName();
    }
  }

};


REGISTER(processFileEventsTablePlugin, "table", "process_file_events");


namespace tables {
osquery::QueryData genMemoryMap(QueryContext& context);
}

class memoryMapTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("name", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("start", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("end", TEXT_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::genMemoryMap(context));


    return results;
  }

};


REGISTER(memoryMapTablePlugin, "table", "memory_map");


namespace tables {
osquery::QueryData genLxdStoragePools(QueryContext& context);
}

class lxdStoragePoolsTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("name", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("driver", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("source", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("size", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("space_used", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("space_total", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("inodes_used", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("inodes_total", BIGINT_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::genLxdStoragePools(context));


    return results;
  }

};


REGISTER(lxdStoragePoolsTablePlugin, "table", "lxd_storage_pools");


namespace tables {
osquery::QueryData genLxdClusterMembers(QueryContext& context);
}

class lxdClusterMembersTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("server_name", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("url", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("database", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("status", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("message", TEXT_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::genLxdClusterMembers(context));


    return results;
  }

};


REGISTER(lxdClusterMembersTablePlugin, "table", "lxd_cluster_members");


namespace tables {
osquery::QueryData genKernelKeys(QueryContext& context);
}

class kernelKeysTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("serial_number", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("flags", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("usage", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("timeout", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("permissions", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("uid", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("gid", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("type", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("description", TEXT_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::genKernelKeys(context));


    return results;
  }

};


REGISTER(kernelKeysTablePlugin, "table", "kernel_keys");


namespace tables {
osquery::QueryData genKernelModules(QueryContext& context);
}

class kernelModulesTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("name", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("size", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("used_by", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("status", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("address", TEXT_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::genKernelModules(context));


    return results;
  }

};


REGISTER(kernelModulesTablePlugin, "table", "kernel_modules");


namespace tables {
osquery::QueryData genLxdInstanceConfig(QueryContext& context);
}

class lxdInstanceConfigTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("name", TEXT_TYPE, ColumnOptions::INDEX | ColumnOptions::REQUIRED),
      std::make_tuple("key", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("value", TEXT_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::genLxdInstanceConfig(context));


    return results;
  }

};


REGISTER(lxdInstanceConfigTablePlugin, "table", "lxd_instance_config");


namespace tables {
void genRpmPackageFiles(RowYield& yield, QueryContext& context);
}

class rpmPackageFilesTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("package", TEXT_TYPE, ColumnOptions::INDEX | ColumnOptions::OPTIMIZED),
      std::make_tuple("path", TEXT_TYPE, ColumnOptions::INDEX),
      std::make_tuple("username", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("groupname", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("mode", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("size", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("sha256", TEXT_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::NONE;
  }

  bool usesGenerator() const override { return true; }

  void generator(RowYield& yield, QueryContext& context) override {
    tables::genRpmPackageFiles(yield, context);
  }

};


REGISTER(rpmPackageFilesTablePlugin, "table", "rpm_package_files");


namespace tables {

class selinux_events {
 public:
  void genTable(RowYield& yield, QueryContext& context);
};
}

class selinuxEventsTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("type", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("message", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("time", BIGINT_TYPE, ColumnOptions::ADDITIONAL),
      std::make_tuple("uptime", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("eid", TEXT_TYPE, ColumnOptions::HIDDEN),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::EVENT_BASED |      TableAttributes::NONE;
  }

  bool usesGenerator() const override { return true; }

  void generator(RowYield& yield, QueryContext& context) override {
    if (EventFactory::exists(getName())) {
      auto subscriber = EventFactory::getEventSubscriber(getName());
      return subscriber->genTable(yield, context);
    } else {
      LOG(ERROR) << "Subscriber table missing: " << getName();
    }
  }

};


REGISTER(selinuxEventsTablePlugin, "table", "selinux_events");


namespace tables {
osquery::QueryData genPortageUse(QueryContext& context);
}

class portageUseTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("package", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("version", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("use", TEXT_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::genPortageUse(context));


    return results;
  }

};


REGISTER(portageUseTablePlugin, "table", "portage_use");


namespace tables {
osquery::QueryData genPipes(QueryContext& context);
}

class processOpenPipesTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("pid", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("fd", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("mode", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("inode", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("type", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("partner_pid", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("partner_fd", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("partner_mode", TEXT_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::genPipes(context));


    return results;
  }

};


REGISTER(processOpenPipesTablePlugin, "table", "process_open_pipes");


namespace tables {
osquery::QueryData genProcessNamespaces(QueryContext& context);
}

class processNamespacesTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("pid", INTEGER_TYPE, ColumnOptions::INDEX | ColumnOptions::OPTIMIZED),
      std::make_tuple("cgroup_namespace", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("ipc_namespace", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("mnt_namespace", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("net_namespace", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("pid_namespace", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("user_namespace", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("uts_namespace", TEXT_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::genProcessNamespaces(context));


    return results;
  }

};


REGISTER(processNamespacesTablePlugin, "table", "process_namespaces");


namespace tables {
osquery::QueryData genMDPersonalities(QueryContext& context);
}

class mdPersonalitiesTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("name", TEXT_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::genMDPersonalities(context));


    return results;
  }

};


REGISTER(mdPersonalitiesTablePlugin, "table", "md_personalities");


namespace tables {
osquery::QueryData genLxdNetworks(QueryContext& context);
}

class lxdNetworksTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("name", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("type", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("managed", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("ipv4_address", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("ipv6_address", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("used_by", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("bytes_received", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("bytes_sent", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("packets_received", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("packets_sent", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("hwaddr", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("state", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("mtu", INTEGER_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::genLxdNetworks(context));


    return results;
  }

};


REGISTER(lxdNetworksTablePlugin, "table", "lxd_networks");


namespace tables {
osquery::QueryData portagePackages(QueryContext& context);
}

class portagePackagesTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("package", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("version", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("slot", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("build_time", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("repository", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("eapi", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("size", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("world", INTEGER_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::portagePackages(context));


    return results;
  }

};


REGISTER(portagePackagesTablePlugin, "table", "portage_packages");


namespace tables {
osquery::QueryData genMDDrives(QueryContext& context);
}

class mdDrivesTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("md_device_name", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("drive_name", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("slot", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("state", TEXT_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::genMDDrives(context));


    return results;
  }

};


REGISTER(mdDrivesTablePlugin, "table", "md_drives");


namespace tables {

class SyslogEventSubscriber {
 public:
  void genTable(RowYield& yield, QueryContext& context);
};
}

class syslogEventsTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("time", BIGINT_TYPE, ColumnOptions::ADDITIONAL),
      std::make_tuple("datetime", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("host", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("severity", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("facility", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("tag", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("message", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("eid", TEXT_TYPE, ColumnOptions::HIDDEN),
    };
  }

  std::vector<std::string> aliases() const override {
    return {
      "syslog",
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::EVENT_BASED |      TableAttributes::NONE;
  }

  bool usesGenerator() const override { return true; }

  void generator(RowYield& yield, QueryContext& context) override {
    if (EventFactory::exists(getName())) {
      auto subscriber = EventFactory::getEventSubscriber(getName());
      return subscriber->genTable(yield, context);
    } else {
      LOG(ERROR) << "Subscriber table missing: " << getName();
    }
  }

};


REGISTER(syslogEventsTablePlugin, "table", "syslog_events");


namespace tables {
osquery::QueryData genLxdImages(QueryContext& context);
}

class lxdImagesTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("id", TEXT_TYPE, ColumnOptions::INDEX),
      std::make_tuple("architecture", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("os", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("release", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("description", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("aliases", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("filename", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("size", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("auto_update", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("cached", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("public", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("created_at", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("expires_at", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("uploaded_at", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("last_used_at", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("update_source_server", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("update_source_protocol", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("update_source_certificate", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("update_source_alias", TEXT_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::genLxdImages(context));


    return results;
  }

};


REGISTER(lxdImagesTablePlugin, "table", "lxd_images");


namespace tables {
osquery::QueryData genLxdCerts(QueryContext& context);
}

class lxdCertificatesTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("name", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("type", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("fingerprint", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("certificate", TEXT_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::genLxdCerts(context));


    return results;
  }

};


REGISTER(lxdCertificatesTablePlugin, "table", "lxd_certificates");


namespace tables {
osquery::QueryData genRpmPackages(QueryContext& context);
}

class rpmPackagesTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("name", TEXT_TYPE, ColumnOptions::INDEX | ColumnOptions::OPTIMIZED),
      std::make_tuple("version", TEXT_TYPE, ColumnOptions::INDEX | ColumnOptions::COLLATEVERSION_RHEL),
      std::make_tuple("release", TEXT_TYPE, ColumnOptions::INDEX),
      std::make_tuple("source", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("size", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("sha1", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("arch", TEXT_TYPE, ColumnOptions::INDEX),
      std::make_tuple("epoch", INTEGER_TYPE, ColumnOptions::INDEX),
      std::make_tuple("install_time", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("vendor", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("package_group", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("pid_with_namespace", INTEGER_TYPE, ColumnOptions::ADDITIONAL | ColumnOptions::HIDDEN),
      std::make_tuple("mount_namespace_id", TEXT_TYPE, ColumnOptions::HIDDEN),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::CACHEABLE |      TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    if (isCached(kCacheStep, context)) {
      return getCache();
    }
    TableRows results = osquery::tableRowsFromQueryData(tables::genRpmPackages(context));

    setCache(kCacheStep, kCacheInterval, context, results);

    return results;
  }

};


REGISTER(rpmPackagesTablePlugin, "table", "rpm_packages");


namespace tables {
osquery::QueryData genModelSpecificRegister(QueryContext& context);
}

class msrTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("processor_number", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("turbo_disabled", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("turbo_ratio_limit", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("platform_info", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("perf_ctl", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("perf_status", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("feature_control", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("rapl_power_limit", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("rapl_energy_status", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("rapl_power_units", BIGINT_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::genModelSpecificRegister(context));


    return results;
  }

};


REGISTER(msrTablePlugin, "table", "msr");


namespace tables {
osquery::QueryData genSharedMemory(QueryContext& context);
}

class sharedMemoryTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("shmid", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("owner_uid", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("creator_uid", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("pid", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("creator_pid", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("atime", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("dtime", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("ctime", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("permissions", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("size", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("attached", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("status", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("locked", INTEGER_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::genSharedMemory(context));


    return results;
  }

};


REGISTER(sharedMemoryTablePlugin, "table", "shared_memory");


namespace tables {

class seccomp_events {
 public:
  void genTable(RowYield& yield, QueryContext& context);
};
}

class seccompEventsTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("time", BIGINT_TYPE, ColumnOptions::ADDITIONAL),
      std::make_tuple("uptime", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("auid", UNSIGNED_BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("uid", UNSIGNED_BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("gid", UNSIGNED_BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("ses", UNSIGNED_BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("pid", UNSIGNED_BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("comm", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("exe", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("sig", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("arch", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("syscall", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("compat", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("ip", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("code", TEXT_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::EVENT_BASED |      TableAttributes::NONE;
  }

  bool usesGenerator() const override { return true; }

  void generator(RowYield& yield, QueryContext& context) override {
    if (EventFactory::exists(getName())) {
      auto subscriber = EventFactory::getEventSubscriber(getName());
      return subscriber->genTable(yield, context);
    } else {
      LOG(ERROR) << "Subscriber table missing: " << getName();
    }
  }

};


REGISTER(seccompEventsTablePlugin, "table", "seccomp_events");


namespace tables {
osquery::TableRows genSystemdUnits(QueryContext& context);
}

class systemdUnitsTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("id", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("description", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("load_state", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("active_state", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("sub_state", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("unit_file_state", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("following", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("object_path", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("job_id", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("job_type", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("job_path", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("fragment_path", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("user", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("source_path", TEXT_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = tables::genSystemdUnits(context);


    return results;
  }

};


REGISTER(systemdUnitsTablePlugin, "table", "systemd_units");


namespace tables {
osquery::QueryData genShadow(QueryContext& context);
}

class shadowTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("password_status", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("hash_alg", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("last_change", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("min", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("max", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("warning", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("inactive", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("expire", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("flag", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("username", TEXT_TYPE, ColumnOptions::INDEX | ColumnOptions::OPTIMIZED),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::genShadow(context));


    return results;
  }

};


REGISTER(shadowTablePlugin, "table", "shadow");


namespace tables {
osquery::QueryData genLxdCluster(QueryContext& context);
}

class lxdClusterTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("server_name", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("enabled", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("member_config_entity", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("member_config_name", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("member_config_key", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("member_config_value", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("member_config_description", TEXT_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::genLxdCluster(context));


    return results;
  }

};


REGISTER(lxdClusterTablePlugin, "table", "lxd_cluster");


namespace tables {
osquery::QueryData genSELinuxSettings(QueryContext& context);
}

class selinuxSettingsTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("scope", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("key", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("value", TEXT_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::genSELinuxSettings(context));


    return results;
  }

};


REGISTER(selinuxSettingsTablePlugin, "table", "selinux_settings");


namespace tables {
osquery::QueryData getIntelMEInfo(QueryContext& context);
}

class intelMeInfoTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("version", TEXT_TYPE, ColumnOptions::COLLATEVERSION),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::getIntelMEInfo(context));


    return results;
  }

};


REGISTER(intelMeInfoTablePlugin, "table", "intel_me_info");


namespace tables {
osquery::QueryData genCpuTime(QueryContext& context);
}

class cpuTimeTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("core", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("user", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("nice", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("system", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("idle", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("iowait", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("irq", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("softirq", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("steal", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("guest", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("guest_nice", BIGINT_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::genCpuTime(context));


    return results;
  }

};


REGISTER(cpuTimeTablePlugin, "table", "cpu_time");


namespace tables {
osquery::QueryData genXattr(QueryContext& context);
}

class extendedAttributesTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("path", TEXT_TYPE, ColumnOptions::REQUIRED | ColumnOptions::OPTIMIZED),
      std::make_tuple("directory", TEXT_TYPE, ColumnOptions::REQUIRED | ColumnOptions::OPTIMIZED),
      std::make_tuple("key", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("value", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("base64", INTEGER_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::genXattr(context));


    return results;
  }

};


REGISTER(extendedAttributesTablePlugin, "table", "extended_attributes");


namespace tables {
osquery::QueryData genAugeas(QueryContext& context);
}

class augeasTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("node", TEXT_TYPE, ColumnOptions::INDEX),
      std::make_tuple("value", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("label", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("path", TEXT_TYPE, ColumnOptions::ADDITIONAL),
    };
  }

  std::vector<std::string> aliases() const override {
    return {
      "configurations",
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::genAugeas(context));


    return results;
  }

};


REGISTER(augeasTablePlugin, "table", "augeas");


namespace tables {
osquery::QueryData genKernelInfo(QueryContext& context);
}

class kernelInfoTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("version", TEXT_TYPE, ColumnOptions::COLLATEVERSION),
      std::make_tuple("arguments", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("path", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("device", TEXT_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::CACHEABLE |      TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    if (isCached(kCacheStep, context)) {
      return getCache();
    }
    TableRows results = osquery::tableRowsFromQueryData(tables::genKernelInfo(context));

    setCache(kCacheStep, kCacheInterval, context, results);

    return results;
  }

};


REGISTER(kernelInfoTablePlugin, "table", "kernel_info");


namespace tables {
osquery::QueryData genBlockDevs(QueryContext& context);
}

class blockDevicesTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("name", TEXT_TYPE, ColumnOptions::INDEX),
      std::make_tuple("parent", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("vendor", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("model", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("serial", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("size", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("block_size", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("uuid", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("type", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("label", TEXT_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::genBlockDevs(context));


    return results;
  }

};


REGISTER(blockDevicesTablePlugin, "table", "block_devices");


namespace tables {
osquery::QueryData getAuthorizedKeys(QueryContext& context);
}

class authorizedKeysTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("uid", BIGINT_TYPE, ColumnOptions::ADDITIONAL),
      std::make_tuple("algorithm", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("key", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("options", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("comment", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("key_file", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("pid_with_namespace", INTEGER_TYPE, ColumnOptions::ADDITIONAL | ColumnOptions::HIDDEN),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::USER_BASED |      TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::getAuthorizedKeys(context));


    return results;
  }

};


REGISTER(authorizedKeysTablePlugin, "table", "authorized_keys");


namespace tables {
osquery::QueryData genCronTab(QueryContext& context);
}

class crontabTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("event", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("minute", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("hour", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("day_of_month", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("month", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("day_of_week", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("command", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("path", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("pid_with_namespace", INTEGER_TYPE, ColumnOptions::ADDITIONAL | ColumnOptions::HIDDEN),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::CACHEABLE |      TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    if (isCached(kCacheStep, context)) {
      return getCache();
    }
    TableRows results = osquery::tableRowsFromQueryData(tables::genCronTab(context));

    setCache(kCacheStep, kCacheInterval, context, results);

    return results;
  }

};


REGISTER(crontabTablePlugin, "table", "crontab");


namespace tables {
osquery::QueryData genACPITables(QueryContext& context);
}

class acpiTablesTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("name", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("size", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("md5", TEXT_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::genACPITables(context));


    return results;
  }

};


REGISTER(acpiTablesTablePlugin, "table", "acpi_tables");


namespace tables {
osquery::QueryData genContainerNetworks(QueryContext& context);
}

class dockerContainerNetworksTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("id", TEXT_TYPE, ColumnOptions::INDEX),
      std::make_tuple("name", TEXT_TYPE, ColumnOptions::INDEX),
      std::make_tuple("network_id", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("endpoint_id", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("gateway", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("ip_address", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("ip_prefix_len", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("ipv6_gateway", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("ipv6_address", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("ipv6_prefix_len", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("mac_address", TEXT_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::genContainerNetworks(context));


    return results;
  }

};


REGISTER(dockerContainerNetworksTablePlugin, "table", "docker_container_networks");


namespace tables {
osquery::QueryData genContainerEnvs(QueryContext& context);
}

class dockerContainerEnvsTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("id", TEXT_TYPE, ColumnOptions::INDEX),
      std::make_tuple("key", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("value", TEXT_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::genContainerEnvs(context));


    return results;
  }

};


REGISTER(dockerContainerEnvsTablePlugin, "table", "docker_container_envs");


namespace tables {
osquery::QueryData genDNSResolvers(QueryContext& context);
}

class dnsResolversTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("id", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("type", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("address", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("netmask", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("options", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("pid_with_namespace", INTEGER_TYPE, ColumnOptions::ADDITIONAL | ColumnOptions::HIDDEN),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::genDNSResolvers(context));


    return results;
  }

};


REGISTER(dnsResolversTablePlugin, "table", "dns_resolvers");


namespace tables {
osquery::QueryData genFDEStatus(QueryContext& context);
}

class diskEncryptionTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("name", TEXT_TYPE, ColumnOptions::INDEX),
      std::make_tuple("uuid", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("encrypted", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("type", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("encryption_status", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("uid", TEXT_TYPE, ColumnOptions::HIDDEN),
      std::make_tuple("user_uuid", TEXT_TYPE, ColumnOptions::HIDDEN),
      std::make_tuple("filevault_status", TEXT_TYPE, ColumnOptions::HIDDEN),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::genFDEStatus(context));


    return results;
  }

};


REGISTER(diskEncryptionTablePlugin, "table", "disk_encryption");


namespace tables {
osquery::QueryData genContainerPorts(QueryContext& context);
}

class dockerContainerPortsTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("id", TEXT_TYPE, ColumnOptions::ADDITIONAL),
      std::make_tuple("type", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("port", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("host_ip", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("host_port", INTEGER_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::genContainerPorts(context));


    return results;
  }

};


REGISTER(dockerContainerPortsTablePlugin, "table", "docker_container_ports");


namespace tables {
osquery::QueryData genContainerMounts(QueryContext& context);
}

class dockerContainerMountsTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("id", TEXT_TYPE, ColumnOptions::INDEX),
      std::make_tuple("type", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("name", TEXT_TYPE, ColumnOptions::INDEX),
      std::make_tuple("source", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("destination", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("driver", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("mode", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("rw", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("propagation", TEXT_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::genContainerMounts(context));


    return results;
  }

};


REGISTER(dockerContainerMountsTablePlugin, "table", "docker_container_mounts");


namespace tables {
osquery::QueryData genContainers(QueryContext& context);
}

class dockerContainersTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("id", TEXT_TYPE, ColumnOptions::INDEX),
      std::make_tuple("name", TEXT_TYPE, ColumnOptions::INDEX),
      std::make_tuple("image", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("image_id", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("command", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("created", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("state", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("status", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("pid", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("path", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("config_entrypoint", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("started_at", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("finished_at", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("privileged", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("security_options", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("env_variables", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("readonly_rootfs", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("cgroup_namespace", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("ipc_namespace", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("mnt_namespace", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("net_namespace", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("pid_namespace", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("user_namespace", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("uts_namespace", TEXT_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::genContainers(context));


    return results;
  }

};


REGISTER(dockerContainersTablePlugin, "table", "docker_containers");


namespace tables {
osquery::QueryData genContainerStats(QueryContext& context);
}

class dockerContainerStatsTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("id", TEXT_TYPE, ColumnOptions::INDEX | ColumnOptions::REQUIRED),
      std::make_tuple("name", TEXT_TYPE, ColumnOptions::INDEX),
      std::make_tuple("pids", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("read", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("preread", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("interval", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("disk_read", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("disk_write", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("num_procs", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("cpu_total_usage", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("cpu_kernelmode_usage", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("cpu_usermode_usage", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("system_cpu_usage", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("online_cpus", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("pre_cpu_total_usage", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("pre_cpu_kernelmode_usage", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("pre_cpu_usermode_usage", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("pre_system_cpu_usage", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("pre_online_cpus", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("memory_usage", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("memory_cached", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("memory_inactive_file", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("memory_total_inactive_file", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("memory_max_usage", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("memory_limit", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("network_rx_bytes", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("network_tx_bytes", BIGINT_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::genContainerStats(context));


    return results;
  }

};


REGISTER(dockerContainerStatsTablePlugin, "table", "docker_container_stats");


namespace tables {
osquery::QueryData genContainerFsChanges(QueryContext& context);
}

class dockerContainerFsChangesTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("id", TEXT_TYPE, ColumnOptions::INDEX | ColumnOptions::REQUIRED),
      std::make_tuple("path", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("change_type", TEXT_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::genContainerFsChanges(context));


    return results;
  }

};


REGISTER(dockerContainerFsChangesTablePlugin, "table", "docker_container_fs_changes");


namespace tables {
osquery::QueryData genImageLabels(QueryContext& context);
}

class dockerImageLabelsTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("id", TEXT_TYPE, ColumnOptions::INDEX),
      std::make_tuple("key", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("value", TEXT_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::genImageLabels(context));


    return results;
  }

};


REGISTER(dockerImageLabelsTablePlugin, "table", "docker_image_labels");


namespace tables {
osquery::QueryData genContainerProcesses(QueryContext& context);
}

class dockerContainerProcessesTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("id", TEXT_TYPE, ColumnOptions::INDEX | ColumnOptions::REQUIRED),
      std::make_tuple("pid", BIGINT_TYPE, ColumnOptions::INDEX),
      std::make_tuple("name", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("cmdline", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("state", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("uid", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("gid", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("euid", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("egid", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("suid", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("sgid", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("wired_size", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("resident_size", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("total_size", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("start_time", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("parent", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("pgroup", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("threads", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("nice", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("user", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("time", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("cpu", DOUBLE_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("mem", DOUBLE_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::genContainerProcesses(context));


    return results;
  }

};


REGISTER(dockerContainerProcessesTablePlugin, "table", "docker_container_processes");


namespace tables {
osquery::QueryData genInfo(QueryContext& context);
}

class dockerInfoTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("id", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("containers", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("containers_running", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("containers_paused", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("containers_stopped", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("images", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("storage_driver", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("memory_limit", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("swap_limit", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("kernel_memory", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("cpu_cfs_period", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("cpu_cfs_quota", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("cpu_shares", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("cpu_set", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("ipv4_forwarding", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("bridge_nf_iptables", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("bridge_nf_ip6tables", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("oom_kill_disable", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("logging_driver", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("cgroup_driver", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("kernel_version", TEXT_TYPE, ColumnOptions::COLLATEVERSION),
      std::make_tuple("os", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("os_type", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("architecture", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("cpus", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("memory", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("http_proxy", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("https_proxy", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("no_proxy", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("name", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("server_version", TEXT_TYPE, ColumnOptions::COLLATEVERSION),
      std::make_tuple("root_dir", TEXT_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::CACHEABLE |      TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    if (isCached(kCacheStep, context)) {
      return getCache();
    }
    TableRows results = osquery::tableRowsFromQueryData(tables::genInfo(context));

    setCache(kCacheStep, kCacheInterval, context, results);

    return results;
  }

};


REGISTER(dockerInfoTablePlugin, "table", "docker_info");


namespace tables {
osquery::QueryData genContainerLabels(QueryContext& context);
}

class dockerContainerLabelsTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("id", TEXT_TYPE, ColumnOptions::INDEX),
      std::make_tuple("key", TEXT_TYPE, ColumnOptions::INDEX),
      std::make_tuple("value", TEXT_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::genContainerLabels(context));


    return results;
  }

};


REGISTER(dockerContainerLabelsTablePlugin, "table", "docker_container_labels");


namespace tables {
osquery::QueryData genImageHistory(QueryContext& context);
}

class dockerImageHistoryTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("id", TEXT_TYPE, ColumnOptions::INDEX),
      std::make_tuple("created", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("size", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("created_by", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("tags", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("comment", TEXT_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::genImageHistory(context));


    return results;
  }

};


REGISTER(dockerImageHistoryTablePlugin, "table", "docker_image_history");


namespace tables {
osquery::QueryData genNetworkLabels(QueryContext& context);
}

class dockerNetworkLabelsTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("id", TEXT_TYPE, ColumnOptions::INDEX),
      std::make_tuple("key", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("value", TEXT_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::genNetworkLabels(context));


    return results;
  }

};


REGISTER(dockerNetworkLabelsTablePlugin, "table", "docker_network_labels");


namespace tables {
osquery::QueryData genImages(QueryContext& context);
}

class dockerImagesTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("id", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("created", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("size_bytes", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("tags", TEXT_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::genImages(context));


    return results;
  }

};


REGISTER(dockerImagesTablePlugin, "table", "docker_images");


namespace tables {
osquery::QueryData genNetworks(QueryContext& context);
}

class dockerNetworksTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("id", TEXT_TYPE, ColumnOptions::INDEX),
      std::make_tuple("name", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("driver", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("created", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("enable_ipv6", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("subnet", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("gateway", TEXT_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::genNetworks(context));


    return results;
  }

};


REGISTER(dockerNetworksTablePlugin, "table", "docker_networks");


namespace tables {
osquery::QueryData genImageLayers(QueryContext& context);
}

class dockerImageLayersTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("id", TEXT_TYPE, ColumnOptions::INDEX),
      std::make_tuple("layer_id", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("layer_order", INTEGER_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::genImageLayers(context));


    return results;
  }

};


REGISTER(dockerImageLayersTablePlugin, "table", "docker_image_layers");


namespace tables {

class file_events {
 public:
  void genTable(RowYield& yield, QueryContext& context);
};
}

class fileEventsTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("target_path", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("category", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("action", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("transaction_id", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("inode", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("uid", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("gid", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("mode", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("size", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("atime", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("mtime", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("ctime", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("md5", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("sha1", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("sha256", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("hashed", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("time", BIGINT_TYPE, ColumnOptions::ADDITIONAL),
      std::make_tuple("eid", TEXT_TYPE, ColumnOptions::HIDDEN),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::EVENT_BASED |      TableAttributes::NONE;
  }

  bool usesGenerator() const override { return true; }

  void generator(RowYield& yield, QueryContext& context) override {
    if (EventFactory::exists(getName())) {
      auto subscriber = EventFactory::getEventSubscriber(getName());
      return subscriber->genTable(yield, context);
    } else {
      LOG(ERROR) << "Subscriber table missing: " << getName();
    }
  }

};


REGISTER(fileEventsTablePlugin, "table", "file_events");


namespace tables {
osquery::QueryData getKnownHostsKeys(QueryContext& context);
}

class knownHostsTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("uid", BIGINT_TYPE, ColumnOptions::INDEX | ColumnOptions::OPTIMIZED),
      std::make_tuple("key", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("key_file", TEXT_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::USER_BASED |      TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::getKnownHostsKeys(context));


    return results;
  }

};


REGISTER(knownHostsTablePlugin, "table", "known_hosts");


namespace tables {
osquery::QueryData genMemoryArrayMappedAddresses(QueryContext& context);
}

class memoryArrayMappedAddressesTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("handle", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("memory_array_handle", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("starting_address", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("ending_address", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("partition_width", INTEGER_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::genMemoryArrayMappedAddresses(context));


    return results;
  }

};


REGISTER(memoryArrayMappedAddressesTablePlugin, "table", "memory_array_mapped_addresses");


namespace tables {
osquery::QueryData genMagicData(QueryContext& context);
}

class magicTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("path", TEXT_TYPE, ColumnOptions::REQUIRED | ColumnOptions::INDEX),
      std::make_tuple("magic_db_files", TEXT_TYPE, ColumnOptions::ADDITIONAL),
      std::make_tuple("data", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("mime_type", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("mime_encoding", TEXT_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::genMagicData(context));


    return results;
  }

};


REGISTER(magicTablePlugin, "table", "magic");


namespace tables {
osquery::QueryData genVolumes(QueryContext& context);
}

class dockerVolumesTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("name", TEXT_TYPE, ColumnOptions::INDEX),
      std::make_tuple("driver", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("mount_point", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("type", TEXT_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::genVolumes(context));


    return results;
  }

};


REGISTER(dockerVolumesTablePlugin, "table", "docker_volumes");


namespace tables {

class hardware_events {
 public:
  void genTable(RowYield& yield, QueryContext& context);
};
}

class hardwareEventsTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("action", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("path", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("type", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("driver", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("vendor", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("vendor_id", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("model", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("model_id", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("serial", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("revision", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("time", BIGINT_TYPE, ColumnOptions::ADDITIONAL),
      std::make_tuple("eid", TEXT_TYPE, ColumnOptions::HIDDEN),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::EVENT_BASED |      TableAttributes::NONE;
  }

  bool usesGenerator() const override { return true; }

  void generator(RowYield& yield, QueryContext& context) override {
    if (EventFactory::exists(getName())) {
      auto subscriber = EventFactory::getEventSubscriber(getName());
      return subscriber->genTable(yield, context);
    } else {
      LOG(ERROR) << "Subscriber table missing: " << getName();
    }
  }

};


REGISTER(hardwareEventsTablePlugin, "table", "hardware_events");


namespace tables {
osquery::QueryData genLoadAverage(QueryContext& context);
}

class loadAverageTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("period", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("average", TEXT_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::genLoadAverage(context));


    return results;
  }

};


REGISTER(loadAverageTablePlugin, "table", "load_average");


namespace tables {
osquery::QueryData genInterfaceIpv6(QueryContext& context);
}

class interfaceIpv6TablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("interface", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("hop_limit", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("forwarding_enabled", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("redirect_accept", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("rtadv_accept", INTEGER_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::genInterfaceIpv6(context));


    return results;
  }

};


REGISTER(interfaceIpv6TablePlugin, "table", "interface_ipv6");


namespace tables {
osquery::QueryData genVersion(QueryContext& context);
}

class dockerVersionTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("version", TEXT_TYPE, ColumnOptions::COLLATEVERSION),
      std::make_tuple("api_version", TEXT_TYPE, ColumnOptions::COLLATEVERSION),
      std::make_tuple("min_api_version", TEXT_TYPE, ColumnOptions::COLLATEVERSION),
      std::make_tuple("git_commit", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("go_version", TEXT_TYPE, ColumnOptions::COLLATEVERSION),
      std::make_tuple("os", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("arch", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("kernel_version", TEXT_TYPE, ColumnOptions::COLLATEVERSION),
      std::make_tuple("build_time", TEXT_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::CACHEABLE |      TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    if (isCached(kCacheStep, context)) {
      return getCache();
    }
    TableRows results = osquery::tableRowsFromQueryData(tables::genVersion(context));

    setCache(kCacheStep, kCacheInterval, context, results);

    return results;
  }

};


REGISTER(dockerVersionTablePlugin, "table", "docker_version");


namespace tables {
osquery::QueryData genVolumeLabels(QueryContext& context);
}

class dockerVolumeLabelsTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("name", TEXT_TYPE, ColumnOptions::INDEX),
      std::make_tuple("key", TEXT_TYPE, ColumnOptions::INDEX),
      std::make_tuple("value", TEXT_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::genVolumeLabels(context));


    return results;
  }

};


REGISTER(dockerVolumeLabelsTablePlugin, "table", "docker_volume_labels");


namespace tables {
osquery::QueryData genMemoryArrays(QueryContext& context);
}

class memoryArraysTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("handle", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("location", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("use", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("memory_error_correction", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("max_capacity", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("memory_error_info_handle", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("number_memory_devices", INTEGER_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::genMemoryArrays(context));


    return results;
  }

};


REGISTER(memoryArraysTablePlugin, "table", "memory_arrays");


namespace tables {
osquery::QueryData genLastAccess(QueryContext& context);
}

class lastTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("username", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("tty", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("pid", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("type", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("type_name", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("time", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("host", TEXT_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::CACHEABLE |      TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    if (isCached(kCacheStep, context)) {
      return getCache();
    }
    TableRows results = osquery::tableRowsFromQueryData(tables::genLastAccess(context));

    setCache(kCacheStep, kCacheInterval, context, results);

    return results;
  }

};


REGISTER(lastTablePlugin, "table", "last");


namespace tables {
osquery::QueryData genMemoryErrorInfo(QueryContext& context);
}

class memoryErrorInfoTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("handle", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("error_type", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("error_granularity", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("error_operation", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("vendor_syndrome", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("memory_array_error_address", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("device_error_address", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("error_resolution", TEXT_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::genMemoryErrorInfo(context));


    return results;
  }

};


REGISTER(memoryErrorInfoTablePlugin, "table", "memory_error_info");


namespace tables {
osquery::QueryData genMemoryDeviceMappedAddresses(QueryContext& context);
}

class memoryDeviceMappedAddressesTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("handle", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("memory_device_handle", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("memory_array_mapped_address_handle", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("starting_address", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("ending_address", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("partition_row_position", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("interleave_position", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("interleave_data_depth", INTEGER_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::genMemoryDeviceMappedAddresses(context));


    return results;
  }

};


REGISTER(memoryDeviceMappedAddressesTablePlugin, "table", "memory_device_mapped_addresses");


namespace tables {
osquery::QueryData genMounts(QueryContext& context);
}

class mountsTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("device", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("device_alias", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("path", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("type", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("blocks_size", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("blocks", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("blocks_free", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("blocks_available", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("inodes", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("inodes_free", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("flags", TEXT_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::genMounts(context));


    return results;
  }

};


REGISTER(mountsTablePlugin, "table", "mounts");


namespace tables {
osquery::QueryData genProcessEnvs(QueryContext& context);
}

class processEnvsTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("pid", INTEGER_TYPE, ColumnOptions::INDEX | ColumnOptions::OPTIMIZED),
      std::make_tuple("key", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("value", TEXT_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::genProcessEnvs(context));


    return results;
  }

};


REGISTER(processEnvsTablePlugin, "table", "process_envs");


namespace tables {
osquery::QueryData genPCIDevices(QueryContext& context);
}

class pciDevicesTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("pci_slot", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("pci_class", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("driver", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("vendor", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("vendor_id", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("model", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("model_id", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("pci_class_id", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("pci_subclass_id", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("pci_subclass", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("subsystem_vendor_id", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("subsystem_vendor", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("subsystem_model_id", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("subsystem_model", TEXT_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::genPCIDevices(context));


    return results;
  }

};


REGISTER(pciDevicesTablePlugin, "table", "pci_devices");


namespace tables {
osquery::QueryData genOEMStrings(QueryContext& context);
}

class oemStringsTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("handle", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("number", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("value", TEXT_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::genOEMStrings(context));


    return results;
  }

};


REGISTER(oemStringsTablePlugin, "table", "oem_strings");


namespace tables {
osquery::QueryData genSudoers(QueryContext& context);
}

class sudoersTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("source", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("header", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("rule_details", TEXT_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::genSudoers(context));


    return results;
  }

};


REGISTER(sudoersTablePlugin, "table", "sudoers");


namespace tables {
osquery::QueryData genOpenFiles(QueryContext& context);
}

class processOpenFilesTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("pid", BIGINT_TYPE, ColumnOptions::INDEX),
      std::make_tuple("fd", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("path", TEXT_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::genOpenFiles(context));


    return results;
  }

};


REGISTER(processOpenFilesTablePlugin, "table", "process_open_files");


namespace tables {

class user_events {
 public:
  void genTable(RowYield& yield, QueryContext& context);
};
}

class userEventsTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("uid", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("auid", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("pid", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("message", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("type", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("path", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("address", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("terminal", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("time", BIGINT_TYPE, ColumnOptions::ADDITIONAL),
      std::make_tuple("uptime", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("eid", TEXT_TYPE, ColumnOptions::HIDDEN),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::EVENT_BASED |      TableAttributes::NONE;
  }

  bool usesGenerator() const override { return true; }

  void generator(RowYield& yield, QueryContext& context) override {
    if (EventFactory::exists(getName())) {
      auto subscriber = EventFactory::getEventSubscriber(getName());
      return subscriber->genTable(yield, context);
    } else {
      LOG(ERROR) << "Subscriber table missing: " << getName();
    }
  }

};


REGISTER(userEventsTablePlugin, "table", "user_events");


namespace tables {
osquery::QueryData genSuidBin(QueryContext& context);
}

class suidBinTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("path", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("username", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("groupname", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("permissions", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("pid_with_namespace", INTEGER_TYPE, ColumnOptions::ADDITIONAL | ColumnOptions::HIDDEN),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::CACHEABLE |      TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    if (isCached(kCacheStep, context)) {
      return getCache();
    }
    TableRows results = osquery::tableRowsFromQueryData(tables::genSuidBin(context));

    setCache(kCacheStep, kCacheInterval, context, results);

    return results;
  }

};


REGISTER(suidBinTablePlugin, "table", "suid_bin");


namespace tables {
osquery::QueryData genDeviceFile(QueryContext& context);
}

class deviceFileTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("device", TEXT_TYPE, ColumnOptions::INDEX | ColumnOptions::REQUIRED),
      std::make_tuple("partition", TEXT_TYPE, ColumnOptions::INDEX | ColumnOptions::REQUIRED),
      std::make_tuple("path", TEXT_TYPE, ColumnOptions::ADDITIONAL),
      std::make_tuple("filename", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("inode", BIGINT_TYPE, ColumnOptions::INDEX),
      std::make_tuple("uid", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("gid", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("mode", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("size", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("block_size", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("atime", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("mtime", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("ctime", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("hard_links", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("type", TEXT_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::genDeviceFile(context));


    return results;
  }

};


REGISTER(deviceFileTablePlugin, "table", "device_file");


namespace tables {
void genShellHistory(RowYield& yield, QueryContext& context);
}

class shellHistoryTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("uid", BIGINT_TYPE, ColumnOptions::ADDITIONAL | ColumnOptions::OPTIMIZED),
      std::make_tuple("time", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("command", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("history_file", TEXT_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::USER_BASED |      TableAttributes::NONE;
  }

  bool usesGenerator() const override { return true; }

  void generator(RowYield& yield, QueryContext& context) override {
    tables::genShellHistory(yield, context);
  }

};


REGISTER(shellHistoryTablePlugin, "table", "shell_history");


namespace tables {
osquery::QueryData genSMBIOSTables(QueryContext& context);
}

class smbiosTablesTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("number", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("type", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("description", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("handle", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("header_size", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("size", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("md5", TEXT_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::genSMBIOSTables(context));


    return results;
  }

};


REGISTER(smbiosTablesTablePlugin, "table", "smbios_tables");


namespace tables {
osquery::QueryData genPrometheusMetrics(QueryContext& context);
}

class prometheusMetricsTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("target_name", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("metric_name", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("metric_value", DOUBLE_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("timestamp_ms", BIGINT_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::genPrometheusMetrics(context));


    return results;
  }

};


REGISTER(prometheusMetricsTablePlugin, "table", "prometheus_metrics");


namespace tables {
osquery::QueryData genUlimitInfo(QueryContext& context);
}

class ulimitInfoTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("type", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("soft_limit", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("hard_limit", TEXT_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::genUlimitInfo(context));


    return results;
  }

};


REGISTER(ulimitInfoTablePlugin, "table", "ulimit_info");


namespace tables {
osquery::QueryData genUSBDevices(QueryContext& context);
}

class usbDevicesTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("usb_address", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("usb_port", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("vendor", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("vendor_id", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("version", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("model", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("model_id", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("serial", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("class", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("subclass", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("protocol", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("removable", INTEGER_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::genUSBDevices(context));


    return results;
  }

};


REGISTER(usbDevicesTablePlugin, "table", "usb_devices");


namespace tables {

class process_events {
 public:
  void genTable(RowYield& yield, QueryContext& context);
};
}

class processEventsTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("pid", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("path", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("mode", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("cmdline", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("cmdline_size", BIGINT_TYPE, ColumnOptions::HIDDEN),
      std::make_tuple("env", TEXT_TYPE, ColumnOptions::HIDDEN),
      std::make_tuple("env_count", BIGINT_TYPE, ColumnOptions::HIDDEN),
      std::make_tuple("env_size", BIGINT_TYPE, ColumnOptions::HIDDEN),
      std::make_tuple("cwd", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("auid", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("uid", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("euid", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("gid", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("egid", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("owner_uid", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("owner_gid", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("atime", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("mtime", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("ctime", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("btime", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("overflows", TEXT_TYPE, ColumnOptions::HIDDEN),
      std::make_tuple("parent", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("time", BIGINT_TYPE, ColumnOptions::ADDITIONAL),
      std::make_tuple("uptime", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("eid", TEXT_TYPE, ColumnOptions::HIDDEN),
      std::make_tuple("status", BIGINT_TYPE, ColumnOptions::HIDDEN),
      std::make_tuple("fsuid", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("suid", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("fsgid", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("sgid", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("syscall", TEXT_TYPE, ColumnOptions::DEFAULT),
    };
  }


  ColumnAliasSet columnAliases() const override {
    return {
      {"env", {"environment" }},
      {"env_count", {"environment_count" }},
      {"env_size", {"environment_size" }},
      {"atime", {"access_time" }},
      {"mtime", {"modify_time" }},
      {"ctime", {"change_time" }},
      {"btime", {"create_time" }},
    };
  }

  AliasColumnMap aliasedColumns() const override {
    return {
      { "environment", "env" },
      { "environment_count", "env_count" },
      { "environment_size", "env_size" },
      { "access_time", "atime" },
      { "modify_time", "mtime" },
      { "change_time", "ctime" },
      { "create_time", "btime" },
    };
  }

  TableAttributes attributes() const override {
    return       TableAttributes::EVENT_BASED |      TableAttributes::NONE;
  }

  bool usesGenerator() const override { return true; }

  void generator(RowYield& yield, QueryContext& context) override {
    if (EventFactory::exists(getName())) {
      auto subscriber = EventFactory::getEventSubscriber(getName());
      return subscriber->genTable(yield, context);
    } else {
      LOG(ERROR) << "Subscriber table missing: " << getName();
    }
  }

};


REGISTER(processEventsTablePlugin, "table", "process_events");


namespace tables {
osquery::QueryData genDevicePartitions(QueryContext& context);
}

class devicePartitionsTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("device", TEXT_TYPE, ColumnOptions::REQUIRED),
      std::make_tuple("partition", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("label", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("type", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("offset", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("blocks_size", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("blocks", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("inodes", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("flags", INTEGER_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::genDevicePartitions(context));


    return results;
  }

};


REGISTER(devicePartitionsTablePlugin, "table", "device_partitions");


namespace tables {

class socket_events {
 public:
  void genTable(RowYield& yield, QueryContext& context);
};
}

class socketEventsTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("action", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("pid", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("path", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("fd", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("auid", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("family", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("protocol", INTEGER_TYPE, ColumnOptions::HIDDEN),
      std::make_tuple("local_address", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("remote_address", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("local_port", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("remote_port", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("socket", TEXT_TYPE, ColumnOptions::HIDDEN),
      std::make_tuple("time", BIGINT_TYPE, ColumnOptions::ADDITIONAL),
      std::make_tuple("uptime", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("eid", TEXT_TYPE, ColumnOptions::HIDDEN),
      std::make_tuple("success", INTEGER_TYPE, ColumnOptions::HIDDEN),
      std::make_tuple("status", TEXT_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::EVENT_BASED |      TableAttributes::NONE;
  }

  bool usesGenerator() const override { return true; }

  void generator(RowYield& yield, QueryContext& context) override {
    if (EventFactory::exists(getName())) {
      auto subscriber = EventFactory::getEventSubscriber(getName());
      return subscriber->genTable(yield, context);
    } else {
      LOG(ERROR) << "Subscriber table missing: " << getName();
    }
  }

};


REGISTER(socketEventsTablePlugin, "table", "socket_events");


namespace tables {
osquery::QueryData genUserGroups(QueryContext& context);
}

class userGroupsTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("uid", BIGINT_TYPE, ColumnOptions::INDEX | ColumnOptions::OPTIMIZED),
      std::make_tuple("gid", BIGINT_TYPE, ColumnOptions::INDEX),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::genUserGroups(context));


    return results;
  }

};


REGISTER(userGroupsTablePlugin, "table", "user_groups");


namespace tables {
osquery::QueryData genCarbonBlackInfo(QueryContext& context);
}

class carbonBlackInfoTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("sensor_id", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("config_name", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("collect_store_files", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("collect_module_loads", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("collect_module_info", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("collect_file_mods", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("collect_reg_mods", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("collect_net_conns", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("collect_processes", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("collect_cross_processes", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("collect_emet_events", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("collect_data_file_writes", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("collect_process_user_context", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("collect_sensor_operations", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("log_file_disk_quota_mb", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("log_file_disk_quota_percentage", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("protection_disabled", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("sensor_ip_addr", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("sensor_backend_server", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("event_queue", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("binary_queue", INTEGER_TYPE, ColumnOptions::DEFAULT),
    };
  }

  std::vector<std::string> aliases() const override {
    return {
      "cb_info",
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::genCarbonBlackInfo(context));


    return results;
  }

};


REGISTER(carbonBlackInfoTablePlugin, "table", "carbon_black_info");


namespace tables {
osquery::QueryData genChromeExtensionContentScripts(QueryContext& context);
}

class chromeExtensionContentScriptsTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("browser_type", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("uid", BIGINT_TYPE, ColumnOptions::INDEX | ColumnOptions::OPTIMIZED),
      std::make_tuple("identifier", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("version", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("script", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("match", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("profile_path", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("path", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("referenced", BIGINT_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::USER_BASED |      TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::genChromeExtensionContentScripts(context));


    return results;
  }

};


REGISTER(chromeExtensionContentScriptsTablePlugin, "table", "chrome_extension_content_scripts");


namespace tables {
osquery::QueryData genSecureBoot(QueryContext& context);
}

class securebootTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("secure_boot", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("secure_mode", INTEGER_TYPE, ColumnOptions::HIDDEN),
      std::make_tuple("description", TEXT_TYPE, ColumnOptions::HIDDEN),
      std::make_tuple("kernel_extensions", INTEGER_TYPE, ColumnOptions::HIDDEN),
      std::make_tuple("mdm_operations", INTEGER_TYPE, ColumnOptions::HIDDEN),
      std::make_tuple("setup_mode", INTEGER_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::genSecureBoot(context));


    return results;
  }

};


REGISTER(securebootTablePlugin, "table", "secureboot");


namespace tables {
osquery::QueryData genAzureTags(QueryContext& context);
}

class azureInstanceTagsTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("vm_id", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("key", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("value", TEXT_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::CACHEABLE |      TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    if (isCached(kCacheStep, context)) {
      return getCache();
    }
    TableRows results = osquery::tableRowsFromQueryData(tables::genAzureTags(context));

    setCache(kCacheStep, kCacheInterval, context, results);

    return results;
  }

};


REGISTER(azureInstanceTagsTablePlugin, "table", "azure_instance_tags");


namespace tables {
osquery::QueryData genGroups(QueryContext& context);
}

class groupsTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("gid", BIGINT_TYPE, ColumnOptions::INDEX),
      std::make_tuple("gid_signed", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("groupname", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("group_sid", TEXT_TYPE, ColumnOptions::INDEX | ColumnOptions::HIDDEN),
      std::make_tuple("comment", TEXT_TYPE, ColumnOptions::HIDDEN),
      std::make_tuple("is_hidden", INTEGER_TYPE, ColumnOptions::HIDDEN),
      std::make_tuple("pid_with_namespace", INTEGER_TYPE, ColumnOptions::ADDITIONAL | ColumnOptions::HIDDEN),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::genGroups(context));


    return results;
  }

};


REGISTER(groupsTablePlugin, "table", "groups");


namespace tables {
osquery::QueryData genCerts(QueryContext& context);
}

class certificatesTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("common_name", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("subject", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("issuer", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("ca", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("self_signed", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("not_valid_before", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("not_valid_after", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("signing_algorithm", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("key_algorithm", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("key_strength", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("key_usage", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("subject_key_id", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("authority_key_id", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("sha1", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("path", TEXT_TYPE, ColumnOptions::ADDITIONAL | ColumnOptions::OPTIMIZED),
      std::make_tuple("serial", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("sid", TEXT_TYPE, ColumnOptions::HIDDEN),
      std::make_tuple("store_location", TEXT_TYPE, ColumnOptions::HIDDEN),
      std::make_tuple("store", TEXT_TYPE, ColumnOptions::HIDDEN),
      std::make_tuple("username", TEXT_TYPE, ColumnOptions::HIDDEN),
      std::make_tuple("store_id", TEXT_TYPE, ColumnOptions::HIDDEN),
      std::make_tuple("issuer2", TEXT_TYPE, ColumnOptions::HIDDEN),
      std::make_tuple("subject2", TEXT_TYPE, ColumnOptions::HIDDEN),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::CACHEABLE |      TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    if (isCached(kCacheStep, context)) {
      return getCache();
    }
    TableRows results = osquery::tableRowsFromQueryData(tables::genCerts(context));

    setCache(kCacheStep, kCacheInterval, context, results);

    return results;
  }

};


REGISTER(certificatesTablePlugin, "table", "certificates");


namespace tables {
osquery::QueryData genCurl(QueryContext& context);
}

class curlTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("url", TEXT_TYPE, ColumnOptions::REQUIRED | ColumnOptions::INDEX | ColumnOptions::OPTIMIZED),
      std::make_tuple("method", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("user_agent", TEXT_TYPE, ColumnOptions::ADDITIONAL),
      std::make_tuple("response_code", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("round_trip_time", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("bytes", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("result", TEXT_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::genCurl(context));


    return results;
  }

};


REGISTER(curlTablePlugin, "table", "curl");


namespace tables {
osquery::QueryData genDeviceHash(QueryContext& context);
}

class deviceHashTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("device", TEXT_TYPE, ColumnOptions::REQUIRED),
      std::make_tuple("partition", TEXT_TYPE, ColumnOptions::REQUIRED),
      std::make_tuple("inode", BIGINT_TYPE, ColumnOptions::REQUIRED),
      std::make_tuple("md5", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("sha1", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("sha256", TEXT_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::genDeviceHash(context));


    return results;
  }

};


REGISTER(deviceHashTablePlugin, "table", "device_hash");


namespace tables {
osquery::QueryData genAzureMetadata(QueryContext& context);
}

class azureInstanceMetadataTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("location", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("name", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("offer", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("publisher", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("sku", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("version", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("os_type", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("platform_update_domain", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("platform_fault_domain", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("vm_id", TEXT_TYPE, ColumnOptions::INDEX),
      std::make_tuple("vm_size", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("subscription_id", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("resource_group_name", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("placement_group_id", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("vm_scale_set_name", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("zone", TEXT_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::CACHEABLE |      TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    if (isCached(kCacheStep, context)) {
      return getCache();
    }
    TableRows results = osquery::tableRowsFromQueryData(tables::genAzureMetadata(context));

    setCache(kCacheStep, kCacheInterval, context, results);

    return results;
  }

};


REGISTER(azureInstanceMetadataTablePlugin, "table", "azure_instance_metadata");


namespace tables {
osquery::QueryData genChromeExtensions(QueryContext& context);
}

class chromeExtensionsTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("browser_type", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("uid", BIGINT_TYPE, ColumnOptions::INDEX | ColumnOptions::OPTIMIZED),
      std::make_tuple("name", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("profile", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("profile_path", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("referenced_identifier", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("identifier", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("version", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("description", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("default_locale", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("current_locale", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("update_url", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("author", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("persistent", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("path", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("permissions", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("permissions_json", TEXT_TYPE, ColumnOptions::HIDDEN),
      std::make_tuple("optional_permissions", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("optional_permissions_json", TEXT_TYPE, ColumnOptions::HIDDEN),
      std::make_tuple("manifest_hash", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("referenced", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("from_webstore", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("state", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("install_time", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("install_timestamp", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("manifest_json", TEXT_TYPE, ColumnOptions::HIDDEN),
      std::make_tuple("key", TEXT_TYPE, ColumnOptions::HIDDEN),
    };
  }


  ColumnAliasSet columnAliases() const override {
    return {
      {"default_locale", {"locale" }},
    };
  }

  AliasColumnMap aliasedColumns() const override {
    return {
      { "locale", "default_locale" },
    };
  }

  TableAttributes attributes() const override {
    return       TableAttributes::USER_BASED |      TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::genChromeExtensions(context));


    return results;
  }

};


REGISTER(chromeExtensionsTablePlugin, "table", "chrome_extensions");


namespace tables {
osquery::QueryData genEtcHosts(QueryContext& context);
}

class etcHostsTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("address", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("hostnames", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("pid_with_namespace", INTEGER_TYPE, ColumnOptions::ADDITIONAL | ColumnOptions::HIDDEN),
    };
  }

  std::vector<std::string> aliases() const override {
    return {
      "hosts",
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::CACHEABLE |      TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    if (isCached(kCacheStep, context)) {
      return getCache();
    }
    TableRows results = osquery::tableRowsFromQueryData(tables::genEtcHosts(context));

    setCache(kCacheStep, kCacheInterval, context, results);

    return results;
  }

};


REGISTER(etcHostsTablePlugin, "table", "etc_hosts");


namespace tables {
osquery::QueryData genCarves(QueryContext& context);
}

class carvesTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("time", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("sha256", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("size", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("path", TEXT_TYPE, ColumnOptions::ADDITIONAL),
      std::make_tuple("status", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("carve_guid", TEXT_TYPE, ColumnOptions::INDEX),
      std::make_tuple("request_id", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("carve", INTEGER_TYPE, ColumnOptions::ADDITIONAL),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::genCarves(context));


    return results;
  }

};


REGISTER(carvesTablePlugin, "table", "carves");


namespace tables {
osquery::QueryData genTLSCertificate(QueryContext& context);
}

class curlCertificateTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("hostname", TEXT_TYPE, ColumnOptions::REQUIRED | ColumnOptions::OPTIMIZED),
      std::make_tuple("common_name", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("organization", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("organization_unit", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("serial_number", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("issuer_common_name", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("issuer_organization", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("issuer_organization_unit", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("valid_from", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("valid_to", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("sha256_fingerprint", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("sha1_fingerprint", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("version", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("signature_algorithm", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("signature", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("subject_key_identifier", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("authority_key_identifier", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("key_usage", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("extended_key_usage", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("policies", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("subject_alternative_names", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("issuer_alternative_names", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("info_access", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("subject_info_access", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("policy_mappings", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("has_expired", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("basic_constraint", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("name_constraints", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("policy_constraints", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("dump_certificate", INTEGER_TYPE, ColumnOptions::ADDITIONAL | ColumnOptions::HIDDEN),
      std::make_tuple("timeout", INTEGER_TYPE, ColumnOptions::ADDITIONAL | ColumnOptions::HIDDEN),
      std::make_tuple("pem", TEXT_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::genTLSCertificate(context));


    return results;
  }

};


REGISTER(curlCertificateTablePlugin, "table", "curl_certificate");


namespace tables {
osquery::QueryData genHash(QueryContext& context);
}

class hashTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("path", TEXT_TYPE, ColumnOptions::INDEX | ColumnOptions::OPTIMIZED | ColumnOptions::REQUIRED),
      std::make_tuple("directory", TEXT_TYPE, ColumnOptions::REQUIRED | ColumnOptions::OPTIMIZED),
      std::make_tuple("md5", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("sha1", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("sha256", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("pid_with_namespace", INTEGER_TYPE, ColumnOptions::ADDITIONAL | ColumnOptions::HIDDEN),
      std::make_tuple("mount_namespace_id", TEXT_TYPE, ColumnOptions::HIDDEN),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::genHash(context));


    return results;
  }

};


REGISTER(hashTablePlugin, "table", "hash");


namespace tables {
osquery::QueryData genEtcProtocols(QueryContext& context);
}

class etcProtocolsTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("name", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("number", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("alias", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("comment", TEXT_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::CACHEABLE |      TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    if (isCached(kCacheStep, context)) {
      return getCache();
    }
    TableRows results = osquery::tableRowsFromQueryData(tables::genEtcProtocols(context));

    setCache(kCacheStep, kCacheInterval, context, results);

    return results;
  }

};


REGISTER(etcProtocolsTablePlugin, "table", "etc_protocols");


namespace tables {
osquery::QueryData genMemoryDevices(QueryContext& context);
}

class memoryDevicesTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("handle", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("array_handle", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("form_factor", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("total_width", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("data_width", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("size", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("set", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("device_locator", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("bank_locator", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("memory_type", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("memory_type_details", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("max_speed", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("configured_clock_speed", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("manufacturer", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("serial_number", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("asset_tag", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("part_number", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("min_voltage", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("max_voltage", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("configured_voltage", INTEGER_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::genMemoryDevices(context));


    return results;
  }

};


REGISTER(memoryDevicesTablePlugin, "table", "memory_devices");


namespace tables {
osquery::QueryData genPlatformInfo(QueryContext& context);
}

class platformInfoTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("vendor", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("version", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("date", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("revision", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("extra", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("firmware_type", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("address", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("size", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("volume_size", INTEGER_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::genPlatformInfo(context));


    return results;
  }

};


REGISTER(platformInfoTablePlugin, "table", "platform_info");


namespace tables {
osquery::QueryData genProcessMemoryMap(QueryContext& context);
}

class processMemoryMapTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("pid", INTEGER_TYPE, ColumnOptions::INDEX | ColumnOptions::OPTIMIZED),
      std::make_tuple("start", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("end", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("permissions", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("offset", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("device", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("inode", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("path", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("pseudo", INTEGER_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::genProcessMemoryMap(context));


    return results;
  }

};


REGISTER(processMemoryMapTablePlugin, "table", "process_memory_map");


namespace tables {
osquery::QueryData genOpenSockets(QueryContext& context);
}

class processOpenSocketsTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("pid", INTEGER_TYPE, ColumnOptions::ADDITIONAL),
      std::make_tuple("fd", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("socket", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("family", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("protocol", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("local_address", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("remote_address", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("local_port", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("remote_port", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("path", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("state", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("net_namespace", TEXT_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::genOpenSockets(context));


    return results;
  }

};


REGISTER(processOpenSocketsTablePlugin, "table", "process_open_sockets");


namespace tables {
osquery::QueryData genNodePackages(QueryContext& context);
}

class npmPackagesTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("name", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("version", TEXT_TYPE, ColumnOptions::COLLATEVERSION),
      std::make_tuple("description", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("author", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("license", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("homepage", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("path", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("directory", TEXT_TYPE, ColumnOptions::INDEX | ColumnOptions::OPTIMIZED),
      std::make_tuple("pid_with_namespace", INTEGER_TYPE, ColumnOptions::ADDITIONAL | ColumnOptions::HIDDEN),
      std::make_tuple("mount_namespace_id", TEXT_TYPE, ColumnOptions::HIDDEN),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::genNodePackages(context));


    return results;
  }

};


REGISTER(npmPackagesTablePlugin, "table", "npm_packages");


namespace tables {
osquery::QueryData genOSVersion(QueryContext& context);
}

class osVersionTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("name", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("version", TEXT_TYPE, ColumnOptions::COLLATEVERSION),
      std::make_tuple("major", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("minor", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("patch", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("build", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("platform", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("platform_like", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("codename", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("arch", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("extra", TEXT_TYPE, ColumnOptions::HIDDEN),
      std::make_tuple("install_date", BIGINT_TYPE, ColumnOptions::HIDDEN),
      std::make_tuple("revision", INTEGER_TYPE, ColumnOptions::HIDDEN),
      std::make_tuple("pid_with_namespace", INTEGER_TYPE, ColumnOptions::ADDITIONAL | ColumnOptions::HIDDEN),
      std::make_tuple("mount_namespace_id", TEXT_TYPE, ColumnOptions::HIDDEN),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::genOSVersion(context));


    return results;
  }

};


REGISTER(osVersionTablePlugin, "table", "os_version");


namespace tables {
osquery::QueryData genInterfaceDetails(QueryContext& context);
}

class interfaceDetailsTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("interface", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("mac", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("type", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("mtu", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("metric", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("flags", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("ipackets", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("opackets", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("ibytes", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("obytes", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("ierrors", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("oerrors", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("idrops", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("odrops", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("collisions", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("last_change", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("link_speed", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("pci_slot", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("friendly_name", TEXT_TYPE, ColumnOptions::HIDDEN),
      std::make_tuple("description", TEXT_TYPE, ColumnOptions::HIDDEN),
      std::make_tuple("manufacturer", TEXT_TYPE, ColumnOptions::HIDDEN),
      std::make_tuple("connection_id", TEXT_TYPE, ColumnOptions::HIDDEN),
      std::make_tuple("connection_status", TEXT_TYPE, ColumnOptions::HIDDEN),
      std::make_tuple("enabled", INTEGER_TYPE, ColumnOptions::HIDDEN),
      std::make_tuple("physical_adapter", INTEGER_TYPE, ColumnOptions::HIDDEN),
      std::make_tuple("speed", INTEGER_TYPE, ColumnOptions::HIDDEN),
      std::make_tuple("service", TEXT_TYPE, ColumnOptions::HIDDEN),
      std::make_tuple("dhcp_enabled", INTEGER_TYPE, ColumnOptions::HIDDEN),
      std::make_tuple("dhcp_lease_expires", TEXT_TYPE, ColumnOptions::HIDDEN),
      std::make_tuple("dhcp_lease_obtained", TEXT_TYPE, ColumnOptions::HIDDEN),
      std::make_tuple("dhcp_server", TEXT_TYPE, ColumnOptions::HIDDEN),
      std::make_tuple("dns_domain", TEXT_TYPE, ColumnOptions::HIDDEN),
      std::make_tuple("dns_domain_suffix_search_order", TEXT_TYPE, ColumnOptions::HIDDEN),
      std::make_tuple("dns_host_name", TEXT_TYPE, ColumnOptions::HIDDEN),
      std::make_tuple("dns_server_search_order", TEXT_TYPE, ColumnOptions::HIDDEN),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::CACHEABLE |      TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    if (isCached(kCacheStep, context)) {
      return getCache();
    }
    TableRows results = osquery::tableRowsFromQueryData(tables::genInterfaceDetails(context));

    setCache(kCacheStep, kCacheInterval, context, results);

    return results;
  }

};


REGISTER(interfaceDetailsTablePlugin, "table", "interface_details");


namespace tables {
osquery::QueryData genInterfaceAddresses(QueryContext& context);
}

class interfaceAddressesTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("interface", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("address", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("mask", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("broadcast", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("point_to_point", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("type", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("friendly_name", TEXT_TYPE, ColumnOptions::HIDDEN),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::CACHEABLE |      TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    if (isCached(kCacheStep, context)) {
      return getCache();
    }
    TableRows results = osquery::tableRowsFromQueryData(tables::genInterfaceAddresses(context));

    setCache(kCacheStep, kCacheInterval, context, results);

    return results;
  }

};


REGISTER(interfaceAddressesTablePlugin, "table", "interface_addresses");


namespace tables {
osquery::QueryData genEtcServices(QueryContext& context);
}

class etcServicesTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("name", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("port", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("protocol", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("aliases", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("comment", TEXT_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::CACHEABLE |      TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    if (isCached(kCacheStep, context)) {
      return getCache();
    }
    TableRows results = osquery::tableRowsFromQueryData(tables::genEtcServices(context));

    setCache(kCacheStep, kCacheInterval, context, results);

    return results;
  }

};


REGISTER(etcServicesTablePlugin, "table", "etc_services");


namespace tables {
osquery::QueryData genListeningPorts(QueryContext& context);
}

class listeningPortsTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("pid", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("port", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("protocol", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("family", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("address", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("fd", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("socket", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("path", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("net_namespace", TEXT_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::CACHEABLE |      TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    if (isCached(kCacheStep, context)) {
      return getCache();
    }
    TableRows results = osquery::tableRowsFromQueryData(tables::genListeningPorts(context));

    setCache(kCacheStep, kCacheInterval, context, results);

    return results;
  }

};


REGISTER(listeningPortsTablePlugin, "table", "listening_ports");


namespace tables {
osquery::QueryData genFirefoxAddons(QueryContext& context);
}

class firefoxAddonsTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("uid", BIGINT_TYPE, ColumnOptions::ADDITIONAL | ColumnOptions::OPTIMIZED),
      std::make_tuple("name", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("identifier", TEXT_TYPE, ColumnOptions::INDEX),
      std::make_tuple("creator", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("type", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("version", TEXT_TYPE, ColumnOptions::COLLATEVERSION),
      std::make_tuple("description", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("source_url", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("visible", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("active", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("disabled", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("autoupdate", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("location", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("path", TEXT_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::USER_BASED |      TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::genFirefoxAddons(context));


    return results;
  }

};


REGISTER(firefoxAddonsTablePlugin, "table", "firefox_addons");


namespace tables {
osquery::QueryData genLoggedInUsers(QueryContext& context);
}

class loggedInUsersTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("type", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("user", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("tty", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("host", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("time", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("pid", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("sid", TEXT_TYPE, ColumnOptions::HIDDEN),
      std::make_tuple("registry_hive", TEXT_TYPE, ColumnOptions::HIDDEN),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::CACHEABLE |      TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    if (isCached(kCacheStep, context)) {
      return getCache();
    }
    TableRows results = osquery::tableRowsFromQueryData(tables::genLoggedInUsers(context));

    setCache(kCacheStep, kCacheInterval, context, results);

    return results;
  }

};


REGISTER(loggedInUsersTablePlugin, "table", "logged_in_users");


namespace tables {
osquery::QueryData genPythonPackages(QueryContext& context);
}

class pythonPackagesTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("name", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("uid", BIGINT_TYPE, ColumnOptions::INDEX),
      std::make_tuple("version", TEXT_TYPE, ColumnOptions::COLLATEVERSION),
      std::make_tuple("summary", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("author", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("license", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("path", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("directory", TEXT_TYPE, ColumnOptions::INDEX | ColumnOptions::OPTIMIZED),
      std::make_tuple("pid_with_namespace", INTEGER_TYPE, ColumnOptions::ADDITIONAL | ColumnOptions::HIDDEN),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::USER_BASED |      TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::genPythonPackages(context));


    return results;
  }

};


REGISTER(pythonPackagesTablePlugin, "table", "python_packages");


namespace tables {
osquery::QueryData genOsquerySchedule(QueryContext& context);
}

class osqueryScheduleTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("name", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("query", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("interval", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("executions", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("last_executed", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("denylisted", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("output_size", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("wall_time", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("wall_time_ms", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("last_wall_time_ms", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("user_time", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("last_user_time", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("system_time", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("last_system_time", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("average_memory", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("last_memory", BIGINT_TYPE, ColumnOptions::DEFAULT),
    };
  }


  ColumnAliasSet columnAliases() const override {
    return {
      {"denylisted", {"blacklisted" }},
    };
  }

  AliasColumnMap aliasedColumns() const override {
    return {
      { "blacklisted", "denylisted" },
    };
  }

  TableAttributes attributes() const override {
    return       TableAttributes::UTILITY |      TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::genOsquerySchedule(context));


    return results;
  }

};


REGISTER_INTERNAL(osqueryScheduleTablePlugin, "table", "osquery_schedule");


namespace tables {
osquery::QueryData getSshConfigs(QueryContext& context);
}

class sshConfigsTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("uid", BIGINT_TYPE, ColumnOptions::ADDITIONAL | ColumnOptions::OPTIMIZED),
      std::make_tuple("block", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("option", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("ssh_config_file", TEXT_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::USER_BASED |      TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::getSshConfigs(context));


    return results;
  }

};


REGISTER(sshConfigsTablePlugin, "table", "ssh_configs");


namespace tables {
osquery::TableRows genProcesses(QueryContext& context);
}

class processesTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("pid", BIGINT_TYPE, ColumnOptions::INDEX | ColumnOptions::OPTIMIZED),
      std::make_tuple("name", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("path", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("cmdline", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("state", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("cwd", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("root", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("uid", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("gid", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("euid", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("egid", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("suid", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("sgid", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("on_disk", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("wired_size", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("resident_size", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("total_size", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("user_time", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("system_time", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("disk_bytes_read", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("disk_bytes_written", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("start_time", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("parent", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("pgroup", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("threads", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("nice", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("elevated_token", INTEGER_TYPE, ColumnOptions::HIDDEN),
      std::make_tuple("secure_process", INTEGER_TYPE, ColumnOptions::HIDDEN),
      std::make_tuple("protection_type", TEXT_TYPE, ColumnOptions::HIDDEN),
      std::make_tuple("virtual_process", INTEGER_TYPE, ColumnOptions::HIDDEN),
      std::make_tuple("elapsed_time", BIGINT_TYPE, ColumnOptions::HIDDEN),
      std::make_tuple("handle_count", BIGINT_TYPE, ColumnOptions::HIDDEN),
      std::make_tuple("percent_processor_time", BIGINT_TYPE, ColumnOptions::HIDDEN),
      std::make_tuple("upid", BIGINT_TYPE, ColumnOptions::HIDDEN),
      std::make_tuple("uppid", BIGINT_TYPE, ColumnOptions::HIDDEN),
      std::make_tuple("cpu_type", INTEGER_TYPE, ColumnOptions::HIDDEN),
      std::make_tuple("cpu_subtype", INTEGER_TYPE, ColumnOptions::HIDDEN),
      std::make_tuple("translated", INTEGER_TYPE, ColumnOptions::HIDDEN),
      std::make_tuple("cgroup_path", TEXT_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::CACHEABLE |      TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    if (isCached(kCacheStep, context)) {
      return getCache();
    }
    TableRows results = tables::genProcesses(context);

    setCache(kCacheStep, kCacheInterval, context, results);

    return results;
  }

};


REGISTER(processesTablePlugin, "table", "processes");


namespace tables {
osquery::QueryData genSystemInfo(QueryContext& context);
}

class systemInfoTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("hostname", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("uuid", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("cpu_type", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("cpu_subtype", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("cpu_brand", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("cpu_physical_cores", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("cpu_logical_cores", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("cpu_sockets", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("cpu_microcode", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("physical_memory", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("hardware_vendor", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("hardware_model", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("hardware_version", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("hardware_serial", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("board_vendor", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("board_model", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("board_version", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("board_serial", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("computer_name", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("local_hostname", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("emulated_cpu_type", TEXT_TYPE, ColumnOptions::HIDDEN),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::genSystemInfo(context));


    return results;
  }

};


REGISTER(systemInfoTablePlugin, "table", "system_info");


namespace tables {
osquery::QueryData genStartupItems(QueryContext& context);
}

class startupItemsTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("name", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("path", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("args", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("type", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("source", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("status", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("username", TEXT_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::CACHEABLE |      TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    if (isCached(kCacheStep, context)) {
      return getCache();
    }
    TableRows results = osquery::tableRowsFromQueryData(tables::genStartupItems(context));

    setCache(kCacheStep, kCacheInterval, context, results);

    return results;
  }

};


REGISTER(startupItemsTablePlugin, "table", "startup_items");


namespace tables {
osquery::QueryData genUsers(QueryContext& context);
}

class usersTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("uid", BIGINT_TYPE, ColumnOptions::INDEX),
      std::make_tuple("gid", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("uid_signed", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("gid_signed", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("username", TEXT_TYPE, ColumnOptions::ADDITIONAL),
      std::make_tuple("description", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("directory", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("shell", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("uuid", TEXT_TYPE, ColumnOptions::INDEX),
      std::make_tuple("type", TEXT_TYPE, ColumnOptions::HIDDEN),
      std::make_tuple("is_hidden", INTEGER_TYPE, ColumnOptions::HIDDEN),
      std::make_tuple("pid_with_namespace", INTEGER_TYPE, ColumnOptions::ADDITIONAL | ColumnOptions::HIDDEN),
      std::make_tuple("include_remote", INTEGER_TYPE, ColumnOptions::ADDITIONAL | ColumnOptions::HIDDEN),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::genUsers(context));


    return results;
  }

};


REGISTER(usersTablePlugin, "table", "users");


namespace tables {
osquery::QueryData genOsqueryEvents(QueryContext& context);
}

class osqueryEventsTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("name", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("publisher", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("type", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("subscriptions", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("events", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("refreshes", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("active", INTEGER_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::UTILITY |      TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::genOsqueryEvents(context));


    return results;
  }

};


REGISTER_INTERNAL(osqueryEventsTablePlugin, "table", "osquery_events");


namespace tables {
osquery::QueryData genRoutes(QueryContext& context);
}

class routesTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("destination", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("netmask", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("gateway", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("source", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("flags", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("interface", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("mtu", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("metric", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("type", TEXT_TYPE, ColumnOptions::ADDITIONAL),
      std::make_tuple("hopcount", INTEGER_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::CACHEABLE |      TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    if (isCached(kCacheStep, context)) {
      return getCache();
    }
    TableRows results = osquery::tableRowsFromQueryData(tables::genRoutes(context));

    setCache(kCacheStep, kCacheInterval, context, results);

    return results;
  }

};


REGISTER(routesTablePlugin, "table", "routes");


namespace tables {
osquery::QueryData genUptime(QueryContext& context);
}

class uptimeTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("days", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("hours", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("minutes", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("seconds", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("total_seconds", BIGINT_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::genUptime(context));


    return results;
  }

};


REGISTER(uptimeTablePlugin, "table", "uptime");


namespace tables {
osquery::QueryData genTime(QueryContext& context);
}

class timeTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("weekday", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("year", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("month", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("day", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("hour", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("minutes", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("seconds", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("timezone", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("local_timezone", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("unix_time", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("timestamp", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("datetime", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("iso_8601", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("win_timestamp", BIGINT_TYPE, ColumnOptions::HIDDEN),
    };
  }


  ColumnAliasSet columnAliases() const override {
    return {
      {"datetime", {"date_time" }},
    };
  }

  AliasColumnMap aliasedColumns() const override {
    return {
      { "date_time", "datetime" },
    };
  }

  TableAttributes attributes() const override {
    return       TableAttributes::UTILITY |      TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::genTime(context));


    return results;
  }

};


REGISTER_INTERNAL(timeTablePlugin, "table", "time");


namespace tables {
osquery::QueryData genOsqueryInfo(QueryContext& context);
}

class osqueryInfoTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("pid", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("uuid", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("instance_id", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("version", TEXT_TYPE, ColumnOptions::COLLATEVERSION),
      std::make_tuple("config_hash", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("config_valid", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("extensions", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("build_platform", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("build_distro", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("start_time", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("watcher", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("platform_mask", INTEGER_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::UTILITY |      TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::genOsqueryInfo(context));


    return results;
  }

};


REGISTER_INTERNAL(osqueryInfoTablePlugin, "table", "osquery_info");


namespace tables {
osquery::QueryData genOsqueryFlags(QueryContext& context);
}

class osqueryFlagsTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("name", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("type", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("description", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("default_value", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("value", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("shell_only", INTEGER_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::UTILITY |      TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::genOsqueryFlags(context));


    return results;
  }

};


REGISTER_INTERNAL(osqueryFlagsTablePlugin, "table", "osquery_flags");


namespace tables {
osquery::QueryData getUserSshKeys(QueryContext& context);
}

class userSshKeysTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("uid", BIGINT_TYPE, ColumnOptions::ADDITIONAL | ColumnOptions::OPTIMIZED),
      std::make_tuple("path", TEXT_TYPE, ColumnOptions::INDEX),
      std::make_tuple("encrypted", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("key_type", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("key_group_name", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("key_length", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("key_security_bits", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("pid_with_namespace", INTEGER_TYPE, ColumnOptions::ADDITIONAL | ColumnOptions::HIDDEN),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::USER_BASED |      TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::getUserSshKeys(context));


    return results;
  }

};


REGISTER(userSshKeysTablePlugin, "table", "user_ssh_keys");


namespace tables {

class yara_events {
 public:
  void genTable(RowYield& yield, QueryContext& context);
};
}

class yaraEventsTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("target_path", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("category", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("action", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("matches", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("count", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("strings", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("tags", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("time", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("eid", TEXT_TYPE, ColumnOptions::HIDDEN),
      std::make_tuple("transaction_id", BIGINT_TYPE, ColumnOptions::HIDDEN),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::EVENT_BASED |      TableAttributes::NONE;
  }

  bool usesGenerator() const override { return true; }

  void generator(RowYield& yield, QueryContext& context) override {
    if (EventFactory::exists(getName())) {
      auto subscriber = EventFactory::getEventSubscriber(getName());
      return subscriber->genTable(yield, context);
    } else {
      LOG(ERROR) << "Subscriber table missing: " << getName();
    }
  }

};


REGISTER(yaraEventsTablePlugin, "table", "yara_events");


namespace tables {
osquery::QueryData genOsqueryPacks(QueryContext& context);
}

class osqueryPacksTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("name", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("platform", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("version", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("shard", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("discovery_cache_hits", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("discovery_executions", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("active", INTEGER_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::UTILITY |      TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::genOsqueryPacks(context));


    return results;
  }

};


REGISTER_INTERNAL(osqueryPacksTablePlugin, "table", "osquery_packs");


namespace tables {
osquery::QueryData genFile(QueryContext& context);
}

class fileTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("path", TEXT_TYPE, ColumnOptions::REQUIRED | ColumnOptions::INDEX | ColumnOptions::OPTIMIZED),
      std::make_tuple("directory", TEXT_TYPE, ColumnOptions::REQUIRED | ColumnOptions::OPTIMIZED),
      std::make_tuple("filename", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("inode", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("uid", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("gid", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("mode", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("device", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("size", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("block_size", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("atime", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("mtime", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("ctime", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("btime", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("hard_links", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("symlink", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("type", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("symlink_target_path", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("attributes", TEXT_TYPE, ColumnOptions::HIDDEN),
      std::make_tuple("volume_serial", TEXT_TYPE, ColumnOptions::HIDDEN),
      std::make_tuple("file_id", TEXT_TYPE, ColumnOptions::HIDDEN),
      std::make_tuple("file_version", TEXT_TYPE, ColumnOptions::COLLATEVERSION | ColumnOptions::HIDDEN),
      std::make_tuple("product_version", TEXT_TYPE, ColumnOptions::COLLATEVERSION | ColumnOptions::HIDDEN),
      std::make_tuple("original_filename", TEXT_TYPE, ColumnOptions::HIDDEN),
      std::make_tuple("shortcut_target_path", TEXT_TYPE, ColumnOptions::HIDDEN),
      std::make_tuple("shortcut_target_type", TEXT_TYPE, ColumnOptions::HIDDEN),
      std::make_tuple("shortcut_target_location", TEXT_TYPE, ColumnOptions::HIDDEN),
      std::make_tuple("shortcut_start_in", TEXT_TYPE, ColumnOptions::HIDDEN),
      std::make_tuple("shortcut_run", TEXT_TYPE, ColumnOptions::HIDDEN),
      std::make_tuple("shortcut_comment", TEXT_TYPE, ColumnOptions::HIDDEN),
      std::make_tuple("bsd_flags", TEXT_TYPE, ColumnOptions::HIDDEN),
      std::make_tuple("pid_with_namespace", INTEGER_TYPE, ColumnOptions::ADDITIONAL | ColumnOptions::HIDDEN),
      std::make_tuple("mount_namespace_id", TEXT_TYPE, ColumnOptions::HIDDEN),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::UTILITY |      TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::genFile(context));


    return results;
  }

};


REGISTER_INTERNAL(fileTablePlugin, "table", "file");


namespace tables {
osquery::QueryData genOsqueryRegistry(QueryContext& context);
}

class osqueryRegistryTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("registry", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("name", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("owner_uuid", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("internal", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("active", INTEGER_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::UTILITY |      TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::genOsqueryRegistry(context));


    return results;
  }

};


REGISTER_INTERNAL(osqueryRegistryTablePlugin, "table", "osquery_registry");


namespace tables {
osquery::QueryData genOsqueryExtensions(QueryContext& context);
}

class osqueryExtensionsTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("uuid", BIGINT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("name", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("version", TEXT_TYPE, ColumnOptions::COLLATEVERSION),
      std::make_tuple("sdk_version", TEXT_TYPE, ColumnOptions::COLLATEVERSION),
      std::make_tuple("path", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("type", TEXT_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::UTILITY |      TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::genOsqueryExtensions(context));


    return results;
  }

};


REGISTER_INTERNAL(osqueryExtensionsTablePlugin, "table", "osquery_extensions");


namespace tables {
osquery::QueryData genEc2Metadata(QueryContext& context);
}

class ec2InstanceMetadataTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("instance_id", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("instance_type", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("architecture", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("region", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("availability_zone", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("local_hostname", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("local_ipv4", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("mac", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("security_groups", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("iam_arn", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("ami_id", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("reservation_id", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("account_id", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("ssh_public_key", TEXT_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::CACHEABLE |      TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    if (isCached(kCacheStep, context)) {
      return getCache();
    }
    TableRows results = osquery::tableRowsFromQueryData(tables::genEc2Metadata(context));

    setCache(kCacheStep, kCacheInterval, context, results);

    return results;
  }

};


REGISTER(ec2InstanceMetadataTablePlugin, "table", "ec2_instance_metadata");


namespace tables {
osquery::QueryData genYara(QueryContext& context);
}

class yaraTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("path", TEXT_TYPE, ColumnOptions::INDEX | ColumnOptions::REQUIRED),
      std::make_tuple("matches", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("count", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("sig_group", TEXT_TYPE, ColumnOptions::ADDITIONAL),
      std::make_tuple("sigfile", TEXT_TYPE, ColumnOptions::ADDITIONAL),
      std::make_tuple("sigrule", TEXT_TYPE, ColumnOptions::ADDITIONAL | ColumnOptions::HIDDEN),
      std::make_tuple("strings", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("tags", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("sigurl", TEXT_TYPE, ColumnOptions::ADDITIONAL | ColumnOptions::HIDDEN),
      std::make_tuple("pid_with_namespace", INTEGER_TYPE, ColumnOptions::ADDITIONAL | ColumnOptions::HIDDEN),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::genYara(context));


    return results;
  }

};


REGISTER(yaraTablePlugin, "table", "yara");


namespace tables {
osquery::QueryData genYCloudMetadata(QueryContext& context);
}

class ycloudInstanceMetadataTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("instance_id", TEXT_TYPE, ColumnOptions::INDEX),
      std::make_tuple("folder_id", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("cloud_id", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("name", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("description", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("hostname", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("zone", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("ssh_public_key", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("serial_port_enabled", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("metadata_endpoint", TEXT_TYPE, ColumnOptions::INDEX),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::CACHEABLE |      TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    if (isCached(kCacheStep, context)) {
      return getCache();
    }
    TableRows results = osquery::tableRowsFromQueryData(tables::genYCloudMetadata(context));

    setCache(kCacheStep, kCacheInterval, context, results);

    return results;
  }

};


REGISTER(ycloudInstanceMetadataTablePlugin, "table", "ycloud_instance_metadata");


namespace tables {
osquery::QueryData genCPUID(QueryContext& context);
}

class cpuidTablePlugin : public TablePlugin {
 private:
  TableColumns columns() const override {
    return {
      std::make_tuple("feature", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("value", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("output_register", TEXT_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("output_bit", INTEGER_TYPE, ColumnOptions::DEFAULT),
      std::make_tuple("input_eax", TEXT_TYPE, ColumnOptions::DEFAULT),
    };
  }


  TableAttributes attributes() const override {
    return       TableAttributes::NONE;
  }

  TableRows generate(QueryContext& context) override {
    TableRows results = osquery::tableRowsFromQueryData(tables::genCPUID(context));


    return results;
  }

};


REGISTER(cpuidTablePlugin, "table", "cpuid");



}
