// services/media_session/public/mojom/media_session.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_MEDIA_SESSION_PUBLIC_MOJOM_MEDIA_SESSION_MOJOM_H_
#define SERVICES_MEDIA_SESSION_PUBLIC_MOJOM_MEDIA_SESSION_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "services/media_session/public/mojom/media_session.mojom-shared.h"
#include "services/media_session/public/mojom/media_session.mojom-forward.h"
#include "mojo/public/mojom/base/string16.mojom.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"


#include "services/media_session/public/cpp/media_session_mojom_traits.h"



// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace media_session {
namespace mojom {

class MediaSessionObserverProxy;

template <typename ImplRefTraits>
class MediaSessionObserverStub;

class MediaSessionObserverRequestValidator;


class  MediaSessionObserver
    : public MediaSessionObserverInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = MediaSessionObserverInterfaceBase;
  using Proxy_ = MediaSessionObserverProxy;

  template <typename ImplRefTraits>
  using Stub_ = MediaSessionObserverStub<ImplRefTraits>;

  using RequestValidator_ = MediaSessionObserverRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kMediaSessionInfoChangedMinVersion = 0,
    kMediaSessionMetadataChangedMinVersion = 0,
    kMediaSessionActionsChangedMinVersion = 0,
    kMediaSessionImagesChangedMinVersion = 0,
    kMediaSessionPositionChangedMinVersion = 0,
  };
  virtual ~MediaSessionObserver() {}

  
  virtual void MediaSessionInfoChanged(MediaSessionInfoPtr info) = 0;

  
  virtual void MediaSessionMetadataChanged(const base::Optional<::media_session::MediaMetadata>& metadata) = 0;

  
  virtual void MediaSessionActionsChanged(const std::vector<MediaSessionAction>& action) = 0;

  
  virtual void MediaSessionImagesChanged(const base::flat_map<MediaSessionImageType, std::vector<::media_session::MediaImage>>& images) = 0;

  
  virtual void MediaSessionPositionChanged(const base::Optional<::media_session::MediaPosition>& position) = 0;
};

class MediaSessionProxy;

template <typename ImplRefTraits>
class MediaSessionStub;

class MediaSessionRequestValidator;
class MediaSessionResponseValidator;


class  MediaSession
    : public MediaSessionInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = MediaSessionInterfaceBase;
  using Proxy_ = MediaSessionProxy;

  template <typename ImplRefTraits>
  using Stub_ = MediaSessionStub<ImplRefTraits>;

  using RequestValidator_ = MediaSessionRequestValidator;
  using ResponseValidator_ = MediaSessionResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetMediaSessionInfoMinVersion = 0,
    kGetDebugInfoMinVersion = 0,
    kStartDuckingMinVersion = 0,
    kStopDuckingMinVersion = 0,
    kSuspendMinVersion = 0,
    kResumeMinVersion = 0,
    kAddObserverMinVersion = 0,
    kPreviousTrackMinVersion = 0,
    kNextTrackMinVersion = 0,
    kSeekMinVersion = 0,
    kStopMinVersion = 0,
    kSkipAdMinVersion = 0,
    kGetMediaImageBitmapMinVersion = 0,
    kSeekToMinVersion = 0,
    kScrubToMinVersion = 0,
    kEnterPictureInPictureMinVersion = 0,
    kExitPictureInPictureMinVersion = 0,
    kSetAudioSinkIdMinVersion = 0,
  };
  
  using SuspendType = MediaSession_SuspendType;
  virtual ~MediaSession() {}


  using GetMediaSessionInfoCallback = base::OnceCallback<void(MediaSessionInfoPtr)>;
  
  virtual void GetMediaSessionInfo(GetMediaSessionInfoCallback callback) = 0;


  using GetDebugInfoCallback = base::OnceCallback<void(MediaSessionDebugInfoPtr)>;
  
  virtual void GetDebugInfo(GetDebugInfoCallback callback) = 0;

  
  virtual void StartDucking() = 0;

  
  virtual void StopDucking() = 0;

  
  virtual void Suspend(MediaSession::SuspendType suspend_type) = 0;

  
  virtual void Resume(MediaSession::SuspendType suspend_type) = 0;

  
  virtual void AddObserver(::mojo::PendingRemote<MediaSessionObserver> observer) = 0;

  
  virtual void PreviousTrack() = 0;

  
  virtual void NextTrack() = 0;

  
  virtual void Seek(::base::TimeDelta seek_time) = 0;

  
  virtual void Stop(MediaSession::SuspendType suspend_type) = 0;

  
  virtual void SkipAd() = 0;


  using GetMediaImageBitmapCallback = base::OnceCallback<void(const ::SkBitmap&)>;
  
  virtual void GetMediaImageBitmap(const ::media_session::MediaImage& image, int32_t minimum_size_px, int32_t desired_size_px, GetMediaImageBitmapCallback callback) = 0;

  
  virtual void SeekTo(::base::TimeDelta seek_time) = 0;

  
  virtual void ScrubTo(::base::TimeDelta seek_time) = 0;

  
  virtual void EnterPictureInPicture() = 0;

  
  virtual void ExitPictureInPicture() = 0;

  
  virtual void SetAudioSinkId(const base::Optional<std::string>& id) = 0;
};



class  MediaSessionObserverProxy
    : public MediaSessionObserver {
 public:
  using InterfaceType = MediaSessionObserver;

  explicit MediaSessionObserverProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void MediaSessionInfoChanged(MediaSessionInfoPtr info) final;
  
  void MediaSessionMetadataChanged(const base::Optional<::media_session::MediaMetadata>& metadata) final;
  
  void MediaSessionActionsChanged(const std::vector<MediaSessionAction>& action) final;
  
  void MediaSessionImagesChanged(const base::flat_map<MediaSessionImageType, std::vector<::media_session::MediaImage>>& images) final;
  
  void MediaSessionPositionChanged(const base::Optional<::media_session::MediaPosition>& position) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  MediaSessionProxy
    : public MediaSession {
 public:
  using InterfaceType = MediaSession;

  explicit MediaSessionProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetMediaSessionInfo(GetMediaSessionInfoCallback callback) final;
  
  void GetDebugInfo(GetDebugInfoCallback callback) final;
  
  void StartDucking() final;
  
  void StopDucking() final;
  
  void Suspend(MediaSession::SuspendType suspend_type) final;
  
  void Resume(MediaSession::SuspendType suspend_type) final;
  
  void AddObserver(::mojo::PendingRemote<MediaSessionObserver> observer) final;
  
  void PreviousTrack() final;
  
  void NextTrack() final;
  
  void Seek(::base::TimeDelta seek_time) final;
  
  void Stop(MediaSession::SuspendType suspend_type) final;
  
  void SkipAd() final;
  
  void GetMediaImageBitmap(const ::media_session::MediaImage& image, int32_t minimum_size_px, int32_t desired_size_px, GetMediaImageBitmapCallback callback) final;
  
  void SeekTo(::base::TimeDelta seek_time) final;
  
  void ScrubTo(::base::TimeDelta seek_time) final;
  
  void EnterPictureInPicture() final;
  
  void ExitPictureInPicture() final;
  
  void SetAudioSinkId(const base::Optional<std::string>& id) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  MediaSessionObserverStubDispatch {
 public:
  static bool Accept(MediaSessionObserver* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      MediaSessionObserver* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<MediaSessionObserver>>
class MediaSessionObserverStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  MediaSessionObserverStub() {}
  ~MediaSessionObserverStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MediaSessionObserverStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MediaSessionObserverStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  MediaSessionStubDispatch {
 public:
  static bool Accept(MediaSession* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      MediaSession* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<MediaSession>>
class MediaSessionStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  MediaSessionStub() {}
  ~MediaSessionStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MediaSessionStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MediaSessionStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  MediaSessionObserverRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  MediaSessionRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  MediaSessionResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};










class  MediaSessionDebugInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<MediaSessionDebugInfo, T>::value>;
  using DataView = MediaSessionDebugInfoDataView;
  using Data_ = internal::MediaSessionDebugInfo_Data;

  template <typename... Args>
  static MediaSessionDebugInfoPtr New(Args&&... args) {
    return MediaSessionDebugInfoPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static MediaSessionDebugInfoPtr From(const U& u) {
    return mojo::TypeConverter<MediaSessionDebugInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, MediaSessionDebugInfo>::Convert(*this);
  }


  MediaSessionDebugInfo();

  MediaSessionDebugInfo(
      const std::string& name,
      const std::string& owner,
      const std::string& state);

  ~MediaSessionDebugInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = MediaSessionDebugInfoPtr>
  MediaSessionDebugInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, MediaSessionDebugInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;
  size_t Hash(size_t seed) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        MediaSessionDebugInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        MediaSessionDebugInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::MediaSessionDebugInfo_UnserializedMessageContext<
            UserType, MediaSessionDebugInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<MediaSessionDebugInfo::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return MediaSessionDebugInfo::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::MediaSessionDebugInfo_UnserializedMessageContext<
            UserType, MediaSessionDebugInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<MediaSessionDebugInfo::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  std::string name;
  
  std::string owner;
  
  std::string state;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, MediaSessionDebugInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, MediaSessionDebugInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, MediaSessionDebugInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, MediaSessionDebugInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}







class  MediaImage {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<MediaImage, T>::value>;
  using DataView = MediaImageDataView;
  using Data_ = internal::MediaImage_Data;

  template <typename... Args>
  static MediaImagePtr New(Args&&... args) {
    return MediaImagePtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static MediaImagePtr From(const U& u) {
    return mojo::TypeConverter<MediaImagePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, MediaImage>::Convert(*this);
  }


  MediaImage();

  MediaImage(
      const ::GURL& src,
      const ::base::string16& type,
      std::vector<::gfx::Size> sizes);

  ~MediaImage();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = MediaImagePtr>
  MediaImagePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, MediaImage::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        MediaImage::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        MediaImage::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::MediaImage_UnserializedMessageContext<
            UserType, MediaImage::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<MediaImage::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return MediaImage::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::MediaImage_UnserializedMessageContext<
            UserType, MediaImage::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<MediaImage::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::GURL src;
  
  ::base::string16 type;
  
  std::vector<::gfx::Size> sizes;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, MediaImage::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, MediaImage::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, MediaImage::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, MediaImage::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  MediaMetadata {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<MediaMetadata, T>::value>;
  using DataView = MediaMetadataDataView;
  using Data_ = internal::MediaMetadata_Data;

  template <typename... Args>
  static MediaMetadataPtr New(Args&&... args) {
    return MediaMetadataPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static MediaMetadataPtr From(const U& u) {
    return mojo::TypeConverter<MediaMetadataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, MediaMetadata>::Convert(*this);
  }


  MediaMetadata();

  MediaMetadata(
      const ::base::string16& title,
      const ::base::string16& artist,
      const ::base::string16& album,
      const ::base::string16& source_title);

  ~MediaMetadata();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = MediaMetadataPtr>
  MediaMetadataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, MediaMetadata::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        MediaMetadata::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        MediaMetadata::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::MediaMetadata_UnserializedMessageContext<
            UserType, MediaMetadata::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<MediaMetadata::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return MediaMetadata::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::MediaMetadata_UnserializedMessageContext<
            UserType, MediaMetadata::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<MediaMetadata::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::base::string16 title;
  
  ::base::string16 artist;
  
  ::base::string16 album;
  
  ::base::string16 source_title;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, MediaMetadata::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, MediaMetadata::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, MediaMetadata::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, MediaMetadata::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  MediaImageBitmap {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<MediaImageBitmap, T>::value>;
  using DataView = MediaImageBitmapDataView;
  using Data_ = internal::MediaImageBitmap_Data;

  template <typename... Args>
  static MediaImageBitmapPtr New(Args&&... args) {
    return MediaImageBitmapPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static MediaImageBitmapPtr From(const U& u) {
    return mojo::TypeConverter<MediaImageBitmapPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, MediaImageBitmap>::Convert(*this);
  }


  MediaImageBitmap();

  MediaImageBitmap(
      int32_t width,
      int32_t height,
      std::vector<uint8_t> pixel_data);

  MediaImageBitmap(
      int32_t width,
      int32_t height,
      std::vector<uint8_t> pixel_data,
      MediaImageBitmapColorType color_type);

  ~MediaImageBitmap();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = MediaImageBitmapPtr>
  MediaImageBitmapPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, MediaImageBitmap::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        MediaImageBitmap::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        MediaImageBitmap::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::MediaImageBitmap_UnserializedMessageContext<
            UserType, MediaImageBitmap::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<MediaImageBitmap::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return MediaImageBitmap::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::MediaImageBitmap_UnserializedMessageContext<
            UserType, MediaImageBitmap::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<MediaImageBitmap::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  int32_t width;
  
  int32_t height;
  
  std::vector<uint8_t> pixel_data;
  
  MediaImageBitmapColorType color_type;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, MediaImageBitmap::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, MediaImageBitmap::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, MediaImageBitmap::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, MediaImageBitmap::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  MediaPosition {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<MediaPosition, T>::value>;
  using DataView = MediaPositionDataView;
  using Data_ = internal::MediaPosition_Data;

  template <typename... Args>
  static MediaPositionPtr New(Args&&... args) {
    return MediaPositionPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static MediaPositionPtr From(const U& u) {
    return mojo::TypeConverter<MediaPositionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, MediaPosition>::Convert(*this);
  }


  MediaPosition();

  MediaPosition(
      double playback_rate,
      ::base::TimeDelta duration,
      ::base::TimeDelta position,
      ::base::TimeTicks last_updated_time);

  ~MediaPosition();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = MediaPositionPtr>
  MediaPositionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, MediaPosition::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        MediaPosition::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        MediaPosition::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::MediaPosition_UnserializedMessageContext<
            UserType, MediaPosition::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<MediaPosition::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return MediaPosition::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::MediaPosition_UnserializedMessageContext<
            UserType, MediaPosition::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<MediaPosition::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  double playback_rate;
  
  ::base::TimeDelta duration;
  
  ::base::TimeDelta position;
  
  ::base::TimeTicks last_updated_time;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, MediaPosition::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, MediaPosition::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, MediaPosition::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, MediaPosition::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  MediaSessionInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<MediaSessionInfo, T>::value>;
  using DataView = MediaSessionInfoDataView;
  using Data_ = internal::MediaSessionInfo_Data;
  using SessionState = MediaSessionInfo_SessionState;

  template <typename... Args>
  static MediaSessionInfoPtr New(Args&&... args) {
    return MediaSessionInfoPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static MediaSessionInfoPtr From(const U& u) {
    return mojo::TypeConverter<MediaSessionInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, MediaSessionInfo>::Convert(*this);
  }


  MediaSessionInfo();

  MediaSessionInfo(
      MediaSessionInfo::SessionState state,
      bool force_duck);

  MediaSessionInfo(
      MediaSessionInfo::SessionState state,
      bool force_duck,
      MediaPlaybackState playback_state);

  MediaSessionInfo(
      MediaSessionInfo::SessionState state,
      bool force_duck,
      MediaPlaybackState playback_state,
      bool is_controllable);

  MediaSessionInfo(
      MediaSessionInfo::SessionState state,
      bool force_duck,
      MediaPlaybackState playback_state,
      bool is_controllable,
      bool prefer_stop_for_gain_focus_loss);

  MediaSessionInfo(
      MediaSessionInfo::SessionState state,
      bool force_duck,
      MediaPlaybackState playback_state,
      bool is_controllable,
      bool prefer_stop_for_gain_focus_loss,
      bool is_sensitive);

  MediaSessionInfo(
      MediaSessionInfo::SessionState state,
      bool force_duck,
      MediaPlaybackState playback_state,
      bool is_controllable,
      bool prefer_stop_for_gain_focus_loss,
      bool is_sensitive,
      MediaPictureInPictureState picture_in_picture_state);

  MediaSessionInfo(
      MediaSessionInfo::SessionState state,
      bool force_duck,
      MediaPlaybackState playback_state,
      bool is_controllable,
      bool prefer_stop_for_gain_focus_loss,
      bool is_sensitive,
      MediaPictureInPictureState picture_in_picture_state,
      MediaAudioVideoState audio_video_state);

  MediaSessionInfo(
      MediaSessionInfo::SessionState state,
      bool force_duck,
      MediaPlaybackState playback_state,
      bool is_controllable,
      bool prefer_stop_for_gain_focus_loss,
      bool is_sensitive,
      MediaPictureInPictureState picture_in_picture_state,
      MediaAudioVideoState audio_video_state,
      const base::Optional<std::string>& audio_sink_id);

  ~MediaSessionInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = MediaSessionInfoPtr>
  MediaSessionInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, MediaSessionInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        MediaSessionInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        MediaSessionInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::MediaSessionInfo_UnserializedMessageContext<
            UserType, MediaSessionInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<MediaSessionInfo::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return MediaSessionInfo::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::MediaSessionInfo_UnserializedMessageContext<
            UserType, MediaSessionInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<MediaSessionInfo::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  MediaSessionInfo::SessionState state;
  
  bool force_duck;
  
  MediaPlaybackState playback_state;
  
  bool is_controllable;
  
  bool prefer_stop_for_gain_focus_loss;
  
  bool is_sensitive;
  
  MediaPictureInPictureState picture_in_picture_state;
  
  MediaAudioVideoState audio_video_state;
  
  base::Optional<std::string> audio_sink_id;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, MediaSessionInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, MediaSessionInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, MediaSessionInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, MediaSessionInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}


template <typename StructPtrType>
MediaImagePtr MediaImage::Clone() const {
  return New(
      mojo::Clone(src),
      mojo::Clone(type),
      mojo::Clone(sizes)
  );
}

template <typename T, MediaImage::EnableIfSame<T>*>
bool MediaImage::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->src, other_struct.src))
    return false;
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  if (!mojo::Equals(this->sizes, other_struct.sizes))
    return false;
  return true;
}

template <typename T, MediaImage::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.src, rhs.src))
    return true;
  if (std::less<>{}(rhs.src, lhs.src))
    return false;
  if (std::less<>{}(lhs.type, rhs.type))
    return true;
  if (std::less<>{}(rhs.type, lhs.type))
    return false;
  if (std::less<>{}(lhs.sizes, rhs.sizes))
    return true;
  if (std::less<>{}(rhs.sizes, lhs.sizes))
    return false;
  return false;
}
template <typename StructPtrType>
MediaMetadataPtr MediaMetadata::Clone() const {
  return New(
      mojo::Clone(title),
      mojo::Clone(artist),
      mojo::Clone(album),
      mojo::Clone(source_title)
  );
}

template <typename T, MediaMetadata::EnableIfSame<T>*>
bool MediaMetadata::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->title, other_struct.title))
    return false;
  if (!mojo::Equals(this->artist, other_struct.artist))
    return false;
  if (!mojo::Equals(this->album, other_struct.album))
    return false;
  if (!mojo::Equals(this->source_title, other_struct.source_title))
    return false;
  return true;
}

template <typename T, MediaMetadata::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.title, rhs.title))
    return true;
  if (std::less<>{}(rhs.title, lhs.title))
    return false;
  if (std::less<>{}(lhs.artist, rhs.artist))
    return true;
  if (std::less<>{}(rhs.artist, lhs.artist))
    return false;
  if (std::less<>{}(lhs.album, rhs.album))
    return true;
  if (std::less<>{}(rhs.album, lhs.album))
    return false;
  if (std::less<>{}(lhs.source_title, rhs.source_title))
    return true;
  if (std::less<>{}(rhs.source_title, lhs.source_title))
    return false;
  return false;
}
template <typename StructPtrType>
MediaImageBitmapPtr MediaImageBitmap::Clone() const {
  return New(
      mojo::Clone(width),
      mojo::Clone(height),
      mojo::Clone(pixel_data),
      mojo::Clone(color_type)
  );
}

template <typename T, MediaImageBitmap::EnableIfSame<T>*>
bool MediaImageBitmap::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->width, other_struct.width))
    return false;
  if (!mojo::Equals(this->height, other_struct.height))
    return false;
  if (!mojo::Equals(this->pixel_data, other_struct.pixel_data))
    return false;
  if (!mojo::Equals(this->color_type, other_struct.color_type))
    return false;
  return true;
}

template <typename T, MediaImageBitmap::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.width, rhs.width))
    return true;
  if (std::less<>{}(rhs.width, lhs.width))
    return false;
  if (std::less<>{}(lhs.height, rhs.height))
    return true;
  if (std::less<>{}(rhs.height, lhs.height))
    return false;
  if (std::less<>{}(lhs.pixel_data, rhs.pixel_data))
    return true;
  if (std::less<>{}(rhs.pixel_data, lhs.pixel_data))
    return false;
  if (std::less<>{}(lhs.color_type, rhs.color_type))
    return true;
  if (std::less<>{}(rhs.color_type, lhs.color_type))
    return false;
  return false;
}
template <typename StructPtrType>
MediaPositionPtr MediaPosition::Clone() const {
  return New(
      mojo::Clone(playback_rate),
      mojo::Clone(duration),
      mojo::Clone(position),
      mojo::Clone(last_updated_time)
  );
}

template <typename T, MediaPosition::EnableIfSame<T>*>
bool MediaPosition::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->playback_rate, other_struct.playback_rate))
    return false;
  if (!mojo::Equals(this->duration, other_struct.duration))
    return false;
  if (!mojo::Equals(this->position, other_struct.position))
    return false;
  if (!mojo::Equals(this->last_updated_time, other_struct.last_updated_time))
    return false;
  return true;
}

template <typename T, MediaPosition::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.playback_rate, rhs.playback_rate))
    return true;
  if (std::less<>{}(rhs.playback_rate, lhs.playback_rate))
    return false;
  if (std::less<>{}(lhs.duration, rhs.duration))
    return true;
  if (std::less<>{}(rhs.duration, lhs.duration))
    return false;
  if (std::less<>{}(lhs.position, rhs.position))
    return true;
  if (std::less<>{}(rhs.position, lhs.position))
    return false;
  if (std::less<>{}(lhs.last_updated_time, rhs.last_updated_time))
    return true;
  if (std::less<>{}(rhs.last_updated_time, lhs.last_updated_time))
    return false;
  return false;
}
template <typename StructPtrType>
MediaSessionInfoPtr MediaSessionInfo::Clone() const {
  return New(
      mojo::Clone(state),
      mojo::Clone(force_duck),
      mojo::Clone(playback_state),
      mojo::Clone(is_controllable),
      mojo::Clone(prefer_stop_for_gain_focus_loss),
      mojo::Clone(is_sensitive),
      mojo::Clone(picture_in_picture_state),
      mojo::Clone(audio_video_state),
      mojo::Clone(audio_sink_id)
  );
}

template <typename T, MediaSessionInfo::EnableIfSame<T>*>
bool MediaSessionInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->state, other_struct.state))
    return false;
  if (!mojo::Equals(this->force_duck, other_struct.force_duck))
    return false;
  if (!mojo::Equals(this->playback_state, other_struct.playback_state))
    return false;
  if (!mojo::Equals(this->is_controllable, other_struct.is_controllable))
    return false;
  if (!mojo::Equals(this->prefer_stop_for_gain_focus_loss, other_struct.prefer_stop_for_gain_focus_loss))
    return false;
  if (!mojo::Equals(this->is_sensitive, other_struct.is_sensitive))
    return false;
  if (!mojo::Equals(this->picture_in_picture_state, other_struct.picture_in_picture_state))
    return false;
  if (!mojo::Equals(this->audio_video_state, other_struct.audio_video_state))
    return false;
  if (!mojo::Equals(this->audio_sink_id, other_struct.audio_sink_id))
    return false;
  return true;
}

template <typename T, MediaSessionInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.state, rhs.state))
    return true;
  if (std::less<>{}(rhs.state, lhs.state))
    return false;
  if (std::less<>{}(lhs.force_duck, rhs.force_duck))
    return true;
  if (std::less<>{}(rhs.force_duck, lhs.force_duck))
    return false;
  if (std::less<>{}(lhs.playback_state, rhs.playback_state))
    return true;
  if (std::less<>{}(rhs.playback_state, lhs.playback_state))
    return false;
  if (std::less<>{}(lhs.is_controllable, rhs.is_controllable))
    return true;
  if (std::less<>{}(rhs.is_controllable, lhs.is_controllable))
    return false;
  if (std::less<>{}(lhs.prefer_stop_for_gain_focus_loss, rhs.prefer_stop_for_gain_focus_loss))
    return true;
  if (std::less<>{}(rhs.prefer_stop_for_gain_focus_loss, lhs.prefer_stop_for_gain_focus_loss))
    return false;
  if (std::less<>{}(lhs.is_sensitive, rhs.is_sensitive))
    return true;
  if (std::less<>{}(rhs.is_sensitive, lhs.is_sensitive))
    return false;
  if (std::less<>{}(lhs.picture_in_picture_state, rhs.picture_in_picture_state))
    return true;
  if (std::less<>{}(rhs.picture_in_picture_state, lhs.picture_in_picture_state))
    return false;
  if (std::less<>{}(lhs.audio_video_state, rhs.audio_video_state))
    return true;
  if (std::less<>{}(rhs.audio_video_state, lhs.audio_video_state))
    return false;
  if (std::less<>{}(lhs.audio_sink_id, rhs.audio_sink_id))
    return true;
  if (std::less<>{}(rhs.audio_sink_id, lhs.audio_sink_id))
    return false;
  return false;
}
template <typename StructPtrType>
MediaSessionDebugInfoPtr MediaSessionDebugInfo::Clone() const {
  return New(
      mojo::Clone(name),
      mojo::Clone(owner),
      mojo::Clone(state)
  );
}

template <typename T, MediaSessionDebugInfo::EnableIfSame<T>*>
bool MediaSessionDebugInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->owner, other_struct.owner))
    return false;
  if (!mojo::Equals(this->state, other_struct.state))
    return false;
  return true;
}

template <typename T, MediaSessionDebugInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.name, rhs.name))
    return true;
  if (std::less<>{}(rhs.name, lhs.name))
    return false;
  if (std::less<>{}(lhs.owner, rhs.owner))
    return true;
  if (std::less<>{}(rhs.owner, lhs.owner))
    return false;
  if (std::less<>{}(lhs.state, rhs.state))
    return true;
  if (std::less<>{}(rhs.state, lhs.state))
    return false;
  return false;
}


}  // namespace mojom
}  // namespace media_session

namespace mojo {


template <>
struct  StructTraits<::media_session::mojom::MediaImage::DataView,
                                         ::media_session::mojom::MediaImagePtr> {
  static bool IsNull(const ::media_session::mojom::MediaImagePtr& input) { return !input; }
  static void SetToNull(::media_session::mojom::MediaImagePtr* output) { output->reset(); }

  static const decltype(::media_session::mojom::MediaImage::src)& src(
      const ::media_session::mojom::MediaImagePtr& input) {
    return input->src;
  }

  static const decltype(::media_session::mojom::MediaImage::type)& type(
      const ::media_session::mojom::MediaImagePtr& input) {
    return input->type;
  }

  static const decltype(::media_session::mojom::MediaImage::sizes)& sizes(
      const ::media_session::mojom::MediaImagePtr& input) {
    return input->sizes;
  }

  static bool Read(::media_session::mojom::MediaImage::DataView input, ::media_session::mojom::MediaImagePtr* output);
};


template <>
struct  StructTraits<::media_session::mojom::MediaMetadata::DataView,
                                         ::media_session::mojom::MediaMetadataPtr> {
  static bool IsNull(const ::media_session::mojom::MediaMetadataPtr& input) { return !input; }
  static void SetToNull(::media_session::mojom::MediaMetadataPtr* output) { output->reset(); }

  static const decltype(::media_session::mojom::MediaMetadata::title)& title(
      const ::media_session::mojom::MediaMetadataPtr& input) {
    return input->title;
  }

  static const decltype(::media_session::mojom::MediaMetadata::artist)& artist(
      const ::media_session::mojom::MediaMetadataPtr& input) {
    return input->artist;
  }

  static const decltype(::media_session::mojom::MediaMetadata::album)& album(
      const ::media_session::mojom::MediaMetadataPtr& input) {
    return input->album;
  }

  static const decltype(::media_session::mojom::MediaMetadata::source_title)& source_title(
      const ::media_session::mojom::MediaMetadataPtr& input) {
    return input->source_title;
  }

  static bool Read(::media_session::mojom::MediaMetadata::DataView input, ::media_session::mojom::MediaMetadataPtr* output);
};


template <>
struct  StructTraits<::media_session::mojom::MediaImageBitmap::DataView,
                                         ::media_session::mojom::MediaImageBitmapPtr> {
  static bool IsNull(const ::media_session::mojom::MediaImageBitmapPtr& input) { return !input; }
  static void SetToNull(::media_session::mojom::MediaImageBitmapPtr* output) { output->reset(); }

  static decltype(::media_session::mojom::MediaImageBitmap::width) width(
      const ::media_session::mojom::MediaImageBitmapPtr& input) {
    return input->width;
  }

  static decltype(::media_session::mojom::MediaImageBitmap::height) height(
      const ::media_session::mojom::MediaImageBitmapPtr& input) {
    return input->height;
  }

  static const decltype(::media_session::mojom::MediaImageBitmap::pixel_data)& pixel_data(
      const ::media_session::mojom::MediaImageBitmapPtr& input) {
    return input->pixel_data;
  }

  static decltype(::media_session::mojom::MediaImageBitmap::color_type) color_type(
      const ::media_session::mojom::MediaImageBitmapPtr& input) {
    return input->color_type;
  }

  static bool Read(::media_session::mojom::MediaImageBitmap::DataView input, ::media_session::mojom::MediaImageBitmapPtr* output);
};


template <>
struct  StructTraits<::media_session::mojom::MediaPosition::DataView,
                                         ::media_session::mojom::MediaPositionPtr> {
  static bool IsNull(const ::media_session::mojom::MediaPositionPtr& input) { return !input; }
  static void SetToNull(::media_session::mojom::MediaPositionPtr* output) { output->reset(); }

  static decltype(::media_session::mojom::MediaPosition::playback_rate) playback_rate(
      const ::media_session::mojom::MediaPositionPtr& input) {
    return input->playback_rate;
  }

  static const decltype(::media_session::mojom::MediaPosition::duration)& duration(
      const ::media_session::mojom::MediaPositionPtr& input) {
    return input->duration;
  }

  static const decltype(::media_session::mojom::MediaPosition::position)& position(
      const ::media_session::mojom::MediaPositionPtr& input) {
    return input->position;
  }

  static const decltype(::media_session::mojom::MediaPosition::last_updated_time)& last_updated_time(
      const ::media_session::mojom::MediaPositionPtr& input) {
    return input->last_updated_time;
  }

  static bool Read(::media_session::mojom::MediaPosition::DataView input, ::media_session::mojom::MediaPositionPtr* output);
};


template <>
struct  StructTraits<::media_session::mojom::MediaSessionInfo::DataView,
                                         ::media_session::mojom::MediaSessionInfoPtr> {
  static bool IsNull(const ::media_session::mojom::MediaSessionInfoPtr& input) { return !input; }
  static void SetToNull(::media_session::mojom::MediaSessionInfoPtr* output) { output->reset(); }

  static decltype(::media_session::mojom::MediaSessionInfo::state) state(
      const ::media_session::mojom::MediaSessionInfoPtr& input) {
    return input->state;
  }

  static decltype(::media_session::mojom::MediaSessionInfo::force_duck) force_duck(
      const ::media_session::mojom::MediaSessionInfoPtr& input) {
    return input->force_duck;
  }

  static decltype(::media_session::mojom::MediaSessionInfo::playback_state) playback_state(
      const ::media_session::mojom::MediaSessionInfoPtr& input) {
    return input->playback_state;
  }

  static decltype(::media_session::mojom::MediaSessionInfo::is_controllable) is_controllable(
      const ::media_session::mojom::MediaSessionInfoPtr& input) {
    return input->is_controllable;
  }

  static decltype(::media_session::mojom::MediaSessionInfo::prefer_stop_for_gain_focus_loss) prefer_stop_for_gain_focus_loss(
      const ::media_session::mojom::MediaSessionInfoPtr& input) {
    return input->prefer_stop_for_gain_focus_loss;
  }

  static decltype(::media_session::mojom::MediaSessionInfo::is_sensitive) is_sensitive(
      const ::media_session::mojom::MediaSessionInfoPtr& input) {
    return input->is_sensitive;
  }

  static decltype(::media_session::mojom::MediaSessionInfo::picture_in_picture_state) picture_in_picture_state(
      const ::media_session::mojom::MediaSessionInfoPtr& input) {
    return input->picture_in_picture_state;
  }

  static decltype(::media_session::mojom::MediaSessionInfo::audio_video_state) audio_video_state(
      const ::media_session::mojom::MediaSessionInfoPtr& input) {
    return input->audio_video_state;
  }

  static const decltype(::media_session::mojom::MediaSessionInfo::audio_sink_id)& audio_sink_id(
      const ::media_session::mojom::MediaSessionInfoPtr& input) {
    return input->audio_sink_id;
  }

  static bool Read(::media_session::mojom::MediaSessionInfo::DataView input, ::media_session::mojom::MediaSessionInfoPtr* output);
};


template <>
struct  StructTraits<::media_session::mojom::MediaSessionDebugInfo::DataView,
                                         ::media_session::mojom::MediaSessionDebugInfoPtr> {
  static bool IsNull(const ::media_session::mojom::MediaSessionDebugInfoPtr& input) { return !input; }
  static void SetToNull(::media_session::mojom::MediaSessionDebugInfoPtr* output) { output->reset(); }

  static const decltype(::media_session::mojom::MediaSessionDebugInfo::name)& name(
      const ::media_session::mojom::MediaSessionDebugInfoPtr& input) {
    return input->name;
  }

  static const decltype(::media_session::mojom::MediaSessionDebugInfo::owner)& owner(
      const ::media_session::mojom::MediaSessionDebugInfoPtr& input) {
    return input->owner;
  }

  static const decltype(::media_session::mojom::MediaSessionDebugInfo::state)& state(
      const ::media_session::mojom::MediaSessionDebugInfoPtr& input) {
    return input->state;
  }

  static bool Read(::media_session::mojom::MediaSessionDebugInfo::DataView input, ::media_session::mojom::MediaSessionDebugInfoPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_MEDIA_SESSION_PUBLIC_MOJOM_MEDIA_SESSION_MOJOM_H_