// third_party/blink/public/mojom/media/renderer_audio_output_stream_factory.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_MEDIA_RENDERER_AUDIO_OUTPUT_STREAM_FACTORY_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_MEDIA_RENDERER_AUDIO_OUTPUT_STREAM_FACTORY_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "third_party/blink/public/mojom/media/renderer_audio_output_stream_factory.mojom-shared.h"
#include "third_party/blink/public/mojom/media/renderer_audio_output_stream_factory.mojom-forward.h"
#include "media/mojo/mojom/audio_output_stream.mojom.h"
#include "media/mojo/mojom/audio_parameters.mojom.h"
#include "media/mojo/mojom/media_types.mojom.h"
#include "mojo/public/mojom/base/unguessable_token.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"


#include "third_party/blink/public/common/common_export.h"



// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace blink {
namespace mojom {

class RendererAudioOutputStreamFactoryProxy;

template <typename ImplRefTraits>
class RendererAudioOutputStreamFactoryStub;

class RendererAudioOutputStreamFactoryRequestValidator;
class RendererAudioOutputStreamFactoryResponseValidator;


class BLINK_COMMON_EXPORT RendererAudioOutputStreamFactory
    : public RendererAudioOutputStreamFactoryInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = RendererAudioOutputStreamFactoryInterfaceBase;
  using Proxy_ = RendererAudioOutputStreamFactoryProxy;

  template <typename ImplRefTraits>
  using Stub_ = RendererAudioOutputStreamFactoryStub<ImplRefTraits>;

  using RequestValidator_ = RendererAudioOutputStreamFactoryRequestValidator;
  using ResponseValidator_ = RendererAudioOutputStreamFactoryResponseValidator;
  enum MethodMinVersions : uint32_t {
    kRequestDeviceAuthorizationMinVersion = 0,
  };
  virtual ~RendererAudioOutputStreamFactory() {}


  using RequestDeviceAuthorizationCallback = base::OnceCallback<void(::media::OutputDeviceStatus, const ::media::AudioParameters&, const std::string&)>;
  
  virtual void RequestDeviceAuthorization(::mojo::PendingReceiver<::media::mojom::AudioOutputStreamProvider> stream_provider_receiver, const base::Optional<::base::UnguessableToken>& session_id, const std::string& device_id, RequestDeviceAuthorizationCallback callback) = 0;
};



class BLINK_COMMON_EXPORT RendererAudioOutputStreamFactoryProxy
    : public RendererAudioOutputStreamFactory {
 public:
  using InterfaceType = RendererAudioOutputStreamFactory;

  explicit RendererAudioOutputStreamFactoryProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void RequestDeviceAuthorization(::mojo::PendingReceiver<::media::mojom::AudioOutputStreamProvider> stream_provider_receiver, const base::Optional<::base::UnguessableToken>& session_id, const std::string& device_id, RequestDeviceAuthorizationCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_COMMON_EXPORT RendererAudioOutputStreamFactoryStubDispatch {
 public:
  static bool Accept(RendererAudioOutputStreamFactory* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      RendererAudioOutputStreamFactory* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<RendererAudioOutputStreamFactory>>
class RendererAudioOutputStreamFactoryStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  RendererAudioOutputStreamFactoryStub() {}
  ~RendererAudioOutputStreamFactoryStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return RendererAudioOutputStreamFactoryStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return RendererAudioOutputStreamFactoryStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT RendererAudioOutputStreamFactoryRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT RendererAudioOutputStreamFactoryResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // namespace mojom
}  // namespace blink

namespace mojo {

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_MEDIA_RENDERER_AUDIO_OUTPUT_STREAM_FACTORY_MOJOM_H_