/* Generated by wayland-scanner 1.24.0 */

#ifndef DWL_IPC_UNSTABLE_V2_CLIENT_PROTOCOL_H
#define DWL_IPC_UNSTABLE_V2_CLIENT_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-client.h"

#ifdef  __cplusplus
extern "C" {
#endif

/**
 * @page page_dwl_ipc_unstable_v2 The dwl_ipc_unstable_v2 protocol
 * inter-proccess-communication about dwl's state
 *
 * @section page_desc_dwl_ipc_unstable_v2 Description
 *
 * This protocol allows clients to update and get updates from dwl.
 *
 * Warning! The protocol described in this file is experimental and
 * backward incompatible changes may be made. Backward compatible
 * changes may be added together with the corresponding interface
 * version bump.
 * Backward incompatible changes are done by bumping the version
 * number in the protocol and interface names and resetting the
 * interface version. Once the protocol is to be declared stable,
 * the 'z' prefix and the version number in the protocol and
 * interface names are removed and the interface version number is
 * reset.
 *
 * @section page_ifaces_dwl_ipc_unstable_v2 Interfaces
 * - @subpage page_iface_zdwl_ipc_manager_v2 - manage dwl state
 * - @subpage page_iface_zdwl_ipc_output_v2 - control dwl output
 */
struct wl_output;
struct zdwl_ipc_manager_v2;
struct zdwl_ipc_output_v2;

#ifndef ZDWL_IPC_MANAGER_V2_INTERFACE
#define ZDWL_IPC_MANAGER_V2_INTERFACE
/**
 * @page page_iface_zdwl_ipc_manager_v2 zdwl_ipc_manager_v2
 * @section page_iface_zdwl_ipc_manager_v2_desc Description
 *
 * This interface is exposed as a global in wl_registry.
 *
 * Clients can use this interface to get a dwl_ipc_output.
 * After binding the client will recieve the dwl_ipc_manager.tags and dwl_ipc_manager.layout events.
 * The dwl_ipc_manager.tags and dwl_ipc_manager.layout events expose tags and layouts to the client.
 * @section page_iface_zdwl_ipc_manager_v2_api API
 * See @ref iface_zdwl_ipc_manager_v2.
 */
/**
 * @defgroup iface_zdwl_ipc_manager_v2 The zdwl_ipc_manager_v2 interface
 *
 * This interface is exposed as a global in wl_registry.
 *
 * Clients can use this interface to get a dwl_ipc_output.
 * After binding the client will recieve the dwl_ipc_manager.tags and dwl_ipc_manager.layout events.
 * The dwl_ipc_manager.tags and dwl_ipc_manager.layout events expose tags and layouts to the client.
 */
extern const struct wl_interface zdwl_ipc_manager_v2_interface;
#endif
#ifndef ZDWL_IPC_OUTPUT_V2_INTERFACE
#define ZDWL_IPC_OUTPUT_V2_INTERFACE
/**
 * @page page_iface_zdwl_ipc_output_v2 zdwl_ipc_output_v2
 * @section page_iface_zdwl_ipc_output_v2_desc Description
 *
 * Observe and control a dwl output.
 *
 * Events are double-buffered:
 * Clients should cache events and redraw when a dwl_ipc_output.frame event is sent.
 *
 * Request are not double-buffered:
 * The compositor will update immediately upon request.
 * @section page_iface_zdwl_ipc_output_v2_api API
 * See @ref iface_zdwl_ipc_output_v2.
 */
/**
 * @defgroup iface_zdwl_ipc_output_v2 The zdwl_ipc_output_v2 interface
 *
 * Observe and control a dwl output.
 *
 * Events are double-buffered:
 * Clients should cache events and redraw when a dwl_ipc_output.frame event is sent.
 *
 * Request are not double-buffered:
 * The compositor will update immediately upon request.
 */
extern const struct wl_interface zdwl_ipc_output_v2_interface;
#endif

/**
 * @ingroup iface_zdwl_ipc_manager_v2
 * @struct zdwl_ipc_manager_v2_listener
 */
struct zdwl_ipc_manager_v2_listener {
	/**
	 * Announces tag amount
	 *
	 * This event is sent after binding. A roundtrip after binding
	 * guarantees the client recieved all tags.
	 */
	void (*tags)(void *data,
		     struct zdwl_ipc_manager_v2 *zdwl_ipc_manager_v2,
		     uint32_t amount);
	/**
	 * Announces a layout
	 *
	 * This event is sent after binding. A roundtrip after binding
	 * guarantees the client recieved all layouts.
	 */
	void (*layout)(void *data,
		       struct zdwl_ipc_manager_v2 *zdwl_ipc_manager_v2,
		       const char *name);
};

/**
 * @ingroup iface_zdwl_ipc_manager_v2
 */
static inline int
zdwl_ipc_manager_v2_add_listener(struct zdwl_ipc_manager_v2 *zdwl_ipc_manager_v2,
				 const struct zdwl_ipc_manager_v2_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) zdwl_ipc_manager_v2,
				     (void (**)(void)) listener, data);
}

#define ZDWL_IPC_MANAGER_V2_RELEASE 0
#define ZDWL_IPC_MANAGER_V2_GET_OUTPUT 1

/**
 * @ingroup iface_zdwl_ipc_manager_v2
 */
#define ZDWL_IPC_MANAGER_V2_TAGS_SINCE_VERSION 1
/**
 * @ingroup iface_zdwl_ipc_manager_v2
 */
#define ZDWL_IPC_MANAGER_V2_LAYOUT_SINCE_VERSION 1

/**
 * @ingroup iface_zdwl_ipc_manager_v2
 */
#define ZDWL_IPC_MANAGER_V2_RELEASE_SINCE_VERSION 1
/**
 * @ingroup iface_zdwl_ipc_manager_v2
 */
#define ZDWL_IPC_MANAGER_V2_GET_OUTPUT_SINCE_VERSION 1

/** @ingroup iface_zdwl_ipc_manager_v2 */
static inline void
zdwl_ipc_manager_v2_set_user_data(struct zdwl_ipc_manager_v2 *zdwl_ipc_manager_v2, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) zdwl_ipc_manager_v2, user_data);
}

/** @ingroup iface_zdwl_ipc_manager_v2 */
static inline void *
zdwl_ipc_manager_v2_get_user_data(struct zdwl_ipc_manager_v2 *zdwl_ipc_manager_v2)
{
	return wl_proxy_get_user_data((struct wl_proxy *) zdwl_ipc_manager_v2);
}

static inline uint32_t
zdwl_ipc_manager_v2_get_version(struct zdwl_ipc_manager_v2 *zdwl_ipc_manager_v2)
{
	return wl_proxy_get_version((struct wl_proxy *) zdwl_ipc_manager_v2);
}

/** @ingroup iface_zdwl_ipc_manager_v2 */
static inline void
zdwl_ipc_manager_v2_destroy(struct zdwl_ipc_manager_v2 *zdwl_ipc_manager_v2)
{
	wl_proxy_destroy((struct wl_proxy *) zdwl_ipc_manager_v2);
}

/**
 * @ingroup iface_zdwl_ipc_manager_v2
 *
 * Indicates that the client will not the dwl_ipc_manager object anymore.
 * Objects created through this instance are not affected.
 */
static inline void
zdwl_ipc_manager_v2_release(struct zdwl_ipc_manager_v2 *zdwl_ipc_manager_v2)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zdwl_ipc_manager_v2,
			 ZDWL_IPC_MANAGER_V2_RELEASE, NULL, wl_proxy_get_version((struct wl_proxy *) zdwl_ipc_manager_v2), WL_MARSHAL_FLAG_DESTROY);
}

/**
 * @ingroup iface_zdwl_ipc_manager_v2
 *
 * Get a dwl_ipc_outout for the specified wl_output.
 */
static inline struct zdwl_ipc_output_v2 *
zdwl_ipc_manager_v2_get_output(struct zdwl_ipc_manager_v2 *zdwl_ipc_manager_v2, struct wl_output *output)
{
	struct wl_proxy *id;

	id = wl_proxy_marshal_flags((struct wl_proxy *) zdwl_ipc_manager_v2,
			 ZDWL_IPC_MANAGER_V2_GET_OUTPUT, &zdwl_ipc_output_v2_interface, wl_proxy_get_version((struct wl_proxy *) zdwl_ipc_manager_v2), 0, NULL, output);

	return (struct zdwl_ipc_output_v2 *) id;
}

#ifndef ZDWL_IPC_OUTPUT_V2_TAG_STATE_ENUM
#define ZDWL_IPC_OUTPUT_V2_TAG_STATE_ENUM
enum zdwl_ipc_output_v2_tag_state {
	/**
	 * no state
	 */
	ZDWL_IPC_OUTPUT_V2_TAG_STATE_NONE = 0,
	/**
	 * tag is active
	 */
	ZDWL_IPC_OUTPUT_V2_TAG_STATE_ACTIVE = 1,
	/**
	 * tag has at least one urgent client
	 */
	ZDWL_IPC_OUTPUT_V2_TAG_STATE_URGENT = 2,
};
#endif /* ZDWL_IPC_OUTPUT_V2_TAG_STATE_ENUM */

/**
 * @ingroup iface_zdwl_ipc_output_v2
 * @struct zdwl_ipc_output_v2_listener
 */
struct zdwl_ipc_output_v2_listener {
	/**
	 * Toggle client visibilty
	 *
	 * Indicates the client should hide or show themselves. If the
	 * client is visible then hide, if hidden then show.
	 */
	void (*toggle_visibility)(void *data,
				  struct zdwl_ipc_output_v2 *zdwl_ipc_output_v2);
	/**
	 * Update the selected output.
	 *
	 * Indicates if the output is active. Zero is invalid, nonzero is
	 * valid.
	 */
	void (*active)(void *data,
		       struct zdwl_ipc_output_v2 *zdwl_ipc_output_v2,
		       uint32_t active);
	/**
	 * Update the state of a tag.
	 *
	 * Indicates that a tag has been updated.
	 * @param tag Index of the tag
	 * @param state The state of the tag.
	 * @param clients The number of clients in the tag.
	 * @param focused If there is a focused client. Nonzero being valid, zero being invalid.
	 */
	void (*tag)(void *data,
		    struct zdwl_ipc_output_v2 *zdwl_ipc_output_v2,
		    uint32_t tag,
		    uint32_t state,
		    uint32_t clients,
		    uint32_t focused);
	/**
	 * Update the layout.
	 *
	 * Indicates a new layout is selected.
	 * @param layout Index of the layout.
	 */
	void (*layout)(void *data,
		       struct zdwl_ipc_output_v2 *zdwl_ipc_output_v2,
		       uint32_t layout);
	/**
	 * Update the title.
	 *
	 * Indicates the title has changed.
	 * @param title The new title name.
	 */
	void (*title)(void *data,
		      struct zdwl_ipc_output_v2 *zdwl_ipc_output_v2,
		      const char *title);
	/**
	 * Update the appid.
	 *
	 * Indicates the appid has changed.
	 * @param appid The new appid.
	 */
	void (*appid)(void *data,
		      struct zdwl_ipc_output_v2 *zdwl_ipc_output_v2,
		      const char *appid);
	/**
	 * Update the current layout symbol
	 *
	 * Indicates the layout has changed. Since layout symbols are
	 * dynamic. As opposed to the zdwl_ipc_manager.layout event, this
	 * should take precendence when displaying. You can ignore the
	 * zdwl_ipc_output.layout event.
	 * @param layout The new layout
	 */
	void (*layout_symbol)(void *data,
			      struct zdwl_ipc_output_v2 *zdwl_ipc_output_v2,
			      const char *layout);
	/**
	 * The update sequence is done.
	 *
	 * Indicates that a sequence of status updates have finished and
	 * the client should redraw.
	 */
	void (*frame)(void *data,
		      struct zdwl_ipc_output_v2 *zdwl_ipc_output_v2);
};

/**
 * @ingroup iface_zdwl_ipc_output_v2
 */
static inline int
zdwl_ipc_output_v2_add_listener(struct zdwl_ipc_output_v2 *zdwl_ipc_output_v2,
				const struct zdwl_ipc_output_v2_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) zdwl_ipc_output_v2,
				     (void (**)(void)) listener, data);
}

#define ZDWL_IPC_OUTPUT_V2_RELEASE 0
#define ZDWL_IPC_OUTPUT_V2_SET_TAGS 1
#define ZDWL_IPC_OUTPUT_V2_SET_CLIENT_TAGS 2
#define ZDWL_IPC_OUTPUT_V2_SET_LAYOUT 3

/**
 * @ingroup iface_zdwl_ipc_output_v2
 */
#define ZDWL_IPC_OUTPUT_V2_TOGGLE_VISIBILITY_SINCE_VERSION 1
/**
 * @ingroup iface_zdwl_ipc_output_v2
 */
#define ZDWL_IPC_OUTPUT_V2_ACTIVE_SINCE_VERSION 1
/**
 * @ingroup iface_zdwl_ipc_output_v2
 */
#define ZDWL_IPC_OUTPUT_V2_TAG_SINCE_VERSION 1
/**
 * @ingroup iface_zdwl_ipc_output_v2
 */
#define ZDWL_IPC_OUTPUT_V2_LAYOUT_SINCE_VERSION 1
/**
 * @ingroup iface_zdwl_ipc_output_v2
 */
#define ZDWL_IPC_OUTPUT_V2_TITLE_SINCE_VERSION 1
/**
 * @ingroup iface_zdwl_ipc_output_v2
 */
#define ZDWL_IPC_OUTPUT_V2_APPID_SINCE_VERSION 1
/**
 * @ingroup iface_zdwl_ipc_output_v2
 */
#define ZDWL_IPC_OUTPUT_V2_LAYOUT_SYMBOL_SINCE_VERSION 1
/**
 * @ingroup iface_zdwl_ipc_output_v2
 */
#define ZDWL_IPC_OUTPUT_V2_FRAME_SINCE_VERSION 1

/**
 * @ingroup iface_zdwl_ipc_output_v2
 */
#define ZDWL_IPC_OUTPUT_V2_RELEASE_SINCE_VERSION 1
/**
 * @ingroup iface_zdwl_ipc_output_v2
 */
#define ZDWL_IPC_OUTPUT_V2_SET_TAGS_SINCE_VERSION 1
/**
 * @ingroup iface_zdwl_ipc_output_v2
 */
#define ZDWL_IPC_OUTPUT_V2_SET_CLIENT_TAGS_SINCE_VERSION 1
/**
 * @ingroup iface_zdwl_ipc_output_v2
 */
#define ZDWL_IPC_OUTPUT_V2_SET_LAYOUT_SINCE_VERSION 1

/** @ingroup iface_zdwl_ipc_output_v2 */
static inline void
zdwl_ipc_output_v2_set_user_data(struct zdwl_ipc_output_v2 *zdwl_ipc_output_v2, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) zdwl_ipc_output_v2, user_data);
}

/** @ingroup iface_zdwl_ipc_output_v2 */
static inline void *
zdwl_ipc_output_v2_get_user_data(struct zdwl_ipc_output_v2 *zdwl_ipc_output_v2)
{
	return wl_proxy_get_user_data((struct wl_proxy *) zdwl_ipc_output_v2);
}

static inline uint32_t
zdwl_ipc_output_v2_get_version(struct zdwl_ipc_output_v2 *zdwl_ipc_output_v2)
{
	return wl_proxy_get_version((struct wl_proxy *) zdwl_ipc_output_v2);
}

/** @ingroup iface_zdwl_ipc_output_v2 */
static inline void
zdwl_ipc_output_v2_destroy(struct zdwl_ipc_output_v2 *zdwl_ipc_output_v2)
{
	wl_proxy_destroy((struct wl_proxy *) zdwl_ipc_output_v2);
}

/**
 * @ingroup iface_zdwl_ipc_output_v2
 *
 * Indicates to that the client no longer needs this dwl_ipc_output.
 */
static inline void
zdwl_ipc_output_v2_release(struct zdwl_ipc_output_v2 *zdwl_ipc_output_v2)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zdwl_ipc_output_v2,
			 ZDWL_IPC_OUTPUT_V2_RELEASE, NULL, wl_proxy_get_version((struct wl_proxy *) zdwl_ipc_output_v2), WL_MARSHAL_FLAG_DESTROY);
}

/**
 * @ingroup iface_zdwl_ipc_output_v2
 */
static inline void
zdwl_ipc_output_v2_set_tags(struct zdwl_ipc_output_v2 *zdwl_ipc_output_v2, uint32_t tagmask, uint32_t toggle_tagset)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zdwl_ipc_output_v2,
			 ZDWL_IPC_OUTPUT_V2_SET_TAGS, NULL, wl_proxy_get_version((struct wl_proxy *) zdwl_ipc_output_v2), 0, tagmask, toggle_tagset);
}

/**
 * @ingroup iface_zdwl_ipc_output_v2
 *
 * The tags are updated as follows:
 * new_tags = (current_tags AND and_tags) XOR xor_tags
 */
static inline void
zdwl_ipc_output_v2_set_client_tags(struct zdwl_ipc_output_v2 *zdwl_ipc_output_v2, uint32_t and_tags, uint32_t xor_tags)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zdwl_ipc_output_v2,
			 ZDWL_IPC_OUTPUT_V2_SET_CLIENT_TAGS, NULL, wl_proxy_get_version((struct wl_proxy *) zdwl_ipc_output_v2), 0, and_tags, xor_tags);
}

/**
 * @ingroup iface_zdwl_ipc_output_v2
 */
static inline void
zdwl_ipc_output_v2_set_layout(struct zdwl_ipc_output_v2 *zdwl_ipc_output_v2, uint32_t index)
{
	wl_proxy_marshal_flags((struct wl_proxy *) zdwl_ipc_output_v2,
			 ZDWL_IPC_OUTPUT_V2_SET_LAYOUT, NULL, wl_proxy_get_version((struct wl_proxy *) zdwl_ipc_output_v2), 0, index);
}

#ifdef  __cplusplus
}
#endif

#endif
