/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.feature;

import io.cucumber.core.feature.EncodingParser;
import io.cucumber.core.gherkin.Feature;
import io.cucumber.core.resource.Resource;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.UUID;
import java.util.function.Supplier;

public final class FeatureParser {
    private final EncodingParser encodingParser = new EncodingParser();
    private final Supplier<UUID> idGenerator;

    public FeatureParser(Supplier<UUID> idGenerator) {
        this.idGenerator = idGenerator;
    }

    public Optional<Feature> parseResource(Resource resource) {
        Objects.requireNonNull(resource);
        URI uri = resource.getUri();
        String source = this.encodingParser.parse(resource);
        ServiceLoader<io.cucumber.core.gherkin.FeatureParser> services = ServiceLoader.load(io.cucumber.core.gherkin.FeatureParser.class);
        Iterator<io.cucumber.core.gherkin.FeatureParser> iterator = services.iterator();
        ArrayList<io.cucumber.core.gherkin.FeatureParser> parser = new ArrayList<io.cucumber.core.gherkin.FeatureParser>();
        while (iterator.hasNext()) {
            parser.add(iterator.next());
        }
        Comparator<io.cucumber.core.gherkin.FeatureParser> version = Comparator.comparing(io.cucumber.core.gherkin.FeatureParser::version);
        return Collections.max(parser, version).parse(uri, source, this.idGenerator);
    }
}

