/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.classic;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sf.juife.NavigationPage;
import org.jsampler.CC;
import org.jsampler.HF;
import org.jsampler.JSUtils;
import org.jsampler.LSConsoleModel;
import org.jsampler.OrchestraModel;
import org.jsampler.Server;
import org.jsampler.task.Global;
import org.jsampler.view.JSChannel;
import org.jsampler.view.JSChannelsPane;
import org.jsampler.view.JSMainFrame;
import org.jsampler.view.classic.A4n;
import org.jsampler.view.classic.ChannelsBar;
import org.jsampler.view.classic.ChannelsPane;
import org.jsampler.view.classic.ClassicI18n;
import org.jsampler.view.classic.ClassicPrefs;
import org.jsampler.view.classic.LSConsoleDlg;
import org.jsampler.view.classic.LSConsolePane;
import org.jsampler.view.classic.LeftPane;
import org.jsampler.view.classic.Res;
import org.jsampler.view.classic.StandardBar;
import org.jsampler.view.classic.Statusbar;
import org.jsampler.view.std.JSBackendLogFrame;
import org.jsampler.view.std.JSConnectDlg;
import org.jsampler.view.std.JSConnectionFailurePane;
import org.jsampler.view.std.JSDetailedErrorDlg;
import org.jsampler.view.std.JSQuitDlg;
import org.jsampler.view.std.JSamplerHomeChooser;
import org.jsampler.view.std.StdUtils;

public class MainFrame
extends JSMainFrame
implements ChangeListener,
ListSelectionListener {
    public static ImageIcon applicationIcon = Res.appIcon;
    private final ChannelsBar channelsBar = new ChannelsBar();
    private final Statusbar statusbar = new Statusbar();
    private final JMenuBar menuBar = new JMenuBar();
    private final JMenu recentScriptsMenu = new JMenu(ClassicI18n.i18n.getMenuLabel("actions.recentScripts"));
    private final JMenu tabsMenu = new JMenu(ClassicI18n.i18n.getMenuLabel("channels.MoveToTab"));
    private final JSplitPane vSplitPane;
    private final JSplitPane hSplitPane;
    private final JPanel mainPane = new JPanel();
    private final StandardBar standardBar = new StandardBar();
    private final JPanel channelsPane = new JPanel(new BorderLayout());
    private final JPanel rightPane = new JPanel();
    private final JPanel bottomPane = new JPanel();
    private final LSConsolePane lsConsolePane = new LSConsolePane(this);
    private LSConsoleDlg lsConsoleDlg = null;
    private final JSBackendLogFrame backendLogFrame = new JSBackendLogFrame();
    private final JTabbedPane tabbedPane = new JTabbedPane(3, 1);
    private final Vector<JMenuItem> miList = new Vector();
    private final JCheckBoxMenuItem cbmiLeftPaneVisible = new JCheckBoxMenuItem(ClassicI18n.i18n.getMenuLabel("view.leftPane"));
    private final JCheckBoxMenuItem cbmiStandardBarVisible = new JCheckBoxMenuItem(ClassicI18n.i18n.getMenuLabel("view.toolbars.standard"));
    private final JCheckBoxMenuItem cbmiLSConsoleShown = new JCheckBoxMenuItem(ClassicI18n.i18n.getMenuLabel("view.lsconsole"));
    private boolean lsConsolePopOut;
    private final Vector<String> recentScripts = new Vector();
    private boolean processConnectionFailure = false;

    public MainFrame() {
        this.setTitle(ClassicI18n.i18n.getLabel("MainFrame.title"));
        CC.setMainFrame(this);
        this.getContentPane().add((Component)this.standardBar, "North");
        this.getContentPane().add(this.mainPane);
        this.mainPane.setLayout(new BorderLayout());
        this.mainPane.add((Component)this.statusbar, "South");
        ChannelsPane channelsPane = new ChannelsPane("Untitled");
        channelsPane.addListSelectionListener(this);
        this.getChannelsPaneList().add(channelsPane);
        this.miList.add(new JMenuItem(new A4n.MoveChannelsTo(channelsPane)));
        this.channelsPane.add(this.getChannelsPane(0));
        this.bottomPane.setLayout(new BorderLayout());
        this.rightPane.setLayout(new BorderLayout());
        this.rightPane.add((Component)this.channelsBar, "North");
        this.rightPane.add(this.channelsPane);
        this.hSplitPane = new JSplitPane(1, true, LeftPane.getLeftPane(), this.rightPane);
        this.hSplitPane.setOneTouchExpandable(true);
        if (ClassicPrefs.getSaveWindowProperties()) {
            this.hSplitPane.setDividerLocation(ClassicPrefs.getHSplitDividerLocation());
        }
        this.mainPane.add(this.hSplitPane);
        this.vSplitPane = new JSplitPane(0, true, this.channelsPane, this.bottomPane);
        this.vSplitPane.setDividerSize(3);
        this.vSplitPane.setDividerLocation(ClassicPrefs.getVSplitDividerLocation());
        this.rightPane.add(this.vSplitPane);
        if (applicationIcon != null) {
            this.setIconImage(applicationIcon.getImage());
        }
        this.initMainFrame();
        this.pack();
        if (ClassicPrefs.getSaveWindowProperties()) {
            this.setSavedSize();
        } else {
            this.setDefaultSize();
        }
        if (ClassicPrefs.getSaveLeftPaneState()) {
            NavigationPage navigationPage = LeftPane.getLeftPane().getPages()[ClassicPrefs.getLeftPanePageIndex()];
            LeftPane.getLeftPane().getModel().addPage(navigationPage);
            LeftPane.getLeftPane().getModel().clearHistory();
            int n = ClassicPrefs.getCurrentOrchestraIndex();
            if (n >= 0 && n < CC.getOrchestras().getOrchestraCount()) {
                OrchestraModel orchestraModel = CC.getOrchestras().getOrchestra(n);
                LeftPane.getLeftPane().getOrchestrasPage().setSelectedOrchestra(orchestraModel);
            }
        }
    }

    @Override
    public void onWindowClose() {
        String[] stringArray;
        boolean bl = ClassicPrefs.preferences().getBoolProperty("confirmAppQuit");
        if (bl && CC.getSamplerModel().isModified()) {
            stringArray = new JSQuitDlg(Res.iconQuestion32);
            stringArray.setVisible(true);
            if (stringArray.isCancelled()) {
                return;
            }
        }
        if (ClassicPrefs.getSaveWindowProperties()) {
            ClassicPrefs.setWindowMaximized("Mainframe", (this.getExtendedState() & 6) == 6);
            this.setVisible(false);
            if (ClassicPrefs.getWindowMaximized("MainFrame")) {
                CC.cleanExit();
                return;
            }
            StdUtils.saveWindowBounds("MainFrame", this.getBounds());
            ClassicPrefs.setHSplitDividerLocation(this.hSplitPane.getDividerLocation());
        }
        if (ClassicPrefs.getSaveLeftPaneState()) {
            int n = 0;
            for (int i = 0; i < LeftPane.getLeftPane().getPages().length; ++i) {
                if (LeftPane.getLeftPane().getPages()[i] != LeftPane.getLeftPane().getCurrentPage()) continue;
                n = i;
                break;
            }
            ClassicPrefs.setLeftPanePageIndex(n);
            n = LeftPane.getLeftPane().getOrchestrasPage().getCurrentOrchestraIndex();
            if (n >= 0 && n < CC.getOrchestras().getOrchestraCount()) {
                ClassicPrefs.setCurrentOrchestraIndex(n);
            }
        }
        stringArray = this.recentScripts.toArray(new String[this.recentScripts.size()]);
        ClassicPrefs.preferences().setStringListProperty("recentLscpScripts", stringArray);
        if (ClassicPrefs.preferences().getBoolProperty("LSConsole.saveCommandHistory")) {
            this.lsConsolePane.saveConsoleHistory();
        }
        ClassicPrefs.setShowLSConsole(this.isLSConsoleShown());
        ClassicPrefs.setLSConsolePopOut(this.isLSConsolePopOut());
        ClassicPrefs.setVSplitDividerLocation(this.vSplitPane.getDividerLocation());
        if (this.getBackendLogFrame() != null) {
            this.getBackendLogFrame().stopTimer();
        }
        if (this.lsConsolePane != null) {
            this.lsConsolePane.disconnect();
        }
        super.onWindowClose();
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl == this.isVisible()) {
            return;
        }
        super.setVisible(bl);
        if (ClassicPrefs.getWindowMaximized("MainFrame")) {
            this.setExtendedState(this.getExtendedState() | 6);
        }
    }

    private void initMainFrame() {
        this.addMenu();
        this.handleEvents();
    }

    private void setDefaultSize() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        double d = dimension.getWidth();
        double d2 = dimension.getHeight();
        this.setBounds(50, 100, (int)d - 100, (int)d2 - 200);
    }

    private void setSavedSize() {
        Rectangle rectangle = StdUtils.getWindowBounds("MainFrame");
        if (rectangle == null) {
            this.setDefaultSize();
            return;
        }
        this.setBounds(rectangle);
    }

    private void addMenu() {
        this.setJMenuBar(this.menuBar);
        JMenu jMenu = new JMenu(ClassicI18n.i18n.getMenuLabel("actions"));
        this.menuBar.add(jMenu);
        JMenuItem jMenuItem = new JMenuItem(A4n.a4n.refresh);
        jMenuItem.setIcon(null);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(116, 0));
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(A4n.samplerInfo);
        jMenuItem.setIcon(null);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(A4n.a4n.resetSampler);
        jMenuItem.setIcon(null);
        jMenu.add(jMenuItem);
        JMenu jMenu2 = new JMenu(ClassicI18n.i18n.getMenuLabel("actions.midiInstruments"));
        jMenu.add(jMenu2);
        jMenuItem = new JMenuItem(A4n.addMidiInstrumentMap);
        jMenuItem.setIcon(null);
        jMenu2.add(jMenuItem);
        jMenuItem = new JMenuItem(A4n.removeMidiInstrumentMap);
        jMenuItem.setIcon(null);
        jMenu2.add(jMenuItem);
        jMenuItem = new JMenuItem(A4n.addMidiInstrumentWizard);
        jMenuItem.setIcon(null);
        jMenu2.add(jMenuItem);
        jMenu.addSeparator();
        JMenu jMenu3 = new JMenu(ClassicI18n.i18n.getMenuLabel("actions.export"));
        jMenu.add(jMenu3);
        int n = CC.getViewConfig().getDefaultModKey();
        jMenuItem = new JMenuItem(A4n.a4n.exportSamplerConfig);
        jMenuItem.setIcon(null);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, n));
        jMenu3.add(jMenuItem);
        jMenuItem = new JMenuItem(A4n.a4n.exportMidiInstrumentMaps);
        jMenuItem.setIcon(null);
        jMenu3.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem(A4n.loadScript);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, n));
        jMenuItem.setIcon(null);
        jMenu.add(jMenuItem);
        String[] stringArray = ClassicPrefs.preferences().getStringListProperty("recentLscpScripts");
        for (String object2 : stringArray) {
            this.recentScripts.add(object2);
        }
        this.updateRecentScriptsMenu();
        jMenu.add(this.recentScriptsMenu);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem(A4n.a4n.changeBackend);
        jMenuItem.setIcon(null);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(66, n));
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem(ClassicI18n.i18n.getMenuLabel("actions.exit"));
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.onWindowClose();
            }
        });
        jMenu = new JMenu(ClassicI18n.i18n.getMenuLabel("edit"));
        this.menuBar.add(jMenu);
        jMenuItem = new JMenuItem(ClassicI18n.i18n.getMenuLabel("edit.audioDevices"));
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!MainFrame.this.isLeftPaneVisible()) {
                    MainFrame.this.cbmiLeftPaneVisible.doClick(0);
                }
                LeftPane.getLeftPane().showAudioDevicesPage();
            }
        });
        jMenuItem = new JMenuItem(ClassicI18n.i18n.getMenuLabel("edit.midiDevices"));
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!MainFrame.this.isLeftPaneVisible()) {
                    MainFrame.this.cbmiLeftPaneVisible.doClick(0);
                }
                LeftPane.getLeftPane().showMidiDevicesPage();
            }
        });
        jMenuItem = new JMenuItem(ClassicI18n.i18n.getMenuLabel("edit.orchestras"));
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!MainFrame.this.isLeftPaneVisible()) {
                    MainFrame.this.cbmiLeftPaneVisible.doClick(0);
                }
                LeftPane.getLeftPane().showManageOrchestrasPage();
            }
        });
        jMenu.addSeparator();
        jMenuItem = new JMenuItem(A4n.preferences);
        jMenuItem.setIcon(null);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(80, n | 1));
        jMenu.add(jMenuItem);
        jMenu = new JMenu(ClassicI18n.i18n.getMenuLabel("view"));
        this.menuBar.add(jMenu);
        JMenu jMenu4 = new JMenu(ClassicI18n.i18n.getMenuLabel("view.toolbars"));
        jMenu.add(jMenu4);
        jMenu4.add(this.cbmiStandardBarVisible);
        this.cbmiStandardBarVisible.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.showStandardBar(MainFrame.this.cbmiStandardBarVisible.getState());
            }
        });
        int n2 = ClassicPrefs.shouldShowStandardBar() ? 1 : 0;
        this.cbmiStandardBarVisible.setSelected(n2 != 0);
        this.showStandardBar(n2 != 0);
        final JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(ClassicI18n.i18n.getMenuLabel("view.toolbars.channels"));
        jMenu4.add(jCheckBoxMenuItem);
        jCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.showChannelsBar(jCheckBoxMenuItem.getState());
            }
        });
        n2 = ClassicPrefs.shouldShowChannelsBar();
        jCheckBoxMenuItem.setSelected(n2 != 0);
        this.showChannelsBar(n2 != 0);
        jMenu.add(this.cbmiLeftPaneVisible);
        this.cbmiLeftPaneVisible.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.showLeftPane(MainFrame.this.cbmiLeftPaneVisible.getState());
            }
        });
        n2 = ClassicPrefs.shouldShowLeftPane();
        this.cbmiLeftPaneVisible.setSelected(n2 != 0);
        this.showLeftPane(n2 != 0);
        final JCheckBoxMenuItem jCheckBoxMenuItem2 = new JCheckBoxMenuItem(ClassicI18n.i18n.getMenuLabel("view.statusbar"));
        jMenu.add(jCheckBoxMenuItem2);
        jCheckBoxMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.showStatusbar(jCheckBoxMenuItem2.getState());
            }
        });
        n2 = ClassicPrefs.shouldShowStatusbar();
        jCheckBoxMenuItem2.setSelected(n2 != 0);
        this.showStatusbar(n2 != 0);
        jMenu.addSeparator();
        this.setLSConsolePopOut(ClassicPrefs.isLSConsolePopOut());
        this.cbmiLSConsoleShown.setSelected(ClassicPrefs.shouldShowLSConsole());
        this.showLSConsole(ClassicPrefs.shouldShowLSConsole());
        this.cbmiLSConsoleShown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MainFrame.this.showLSConsole(MainFrame.this.cbmiLSConsoleShown.isSelected());
            }
        });
        jMenu.add(this.cbmiLSConsoleShown);
        this.lsConsolePane.updateLSConsoleViewMode();
        jMenu = new JMenu(ClassicI18n.i18n.getMenuLabel("channels"));
        this.menuBar.add(jMenu);
        jMenuItem = new JMenuItem(A4n.newChannel);
        jMenuItem.setIcon(null);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, n));
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(A4n.newChannelWizard);
        jMenuItem.setIcon(null);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(78, n | 1));
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(A4n.a4n.duplicateChannels);
        jMenuItem.setIcon(null);
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem(A4n.a4n.moveChannelsOnTop);
        jMenuItem.setIcon(null);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(38, 9));
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(A4n.a4n.moveChannelsUp);
        jMenuItem.setIcon(null);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(38, 8));
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(A4n.a4n.moveChannelsDown);
        jMenuItem.setIcon(null);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(40, 8));
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(A4n.a4n.moveChannelsAtBottom);
        jMenuItem.setIcon(null);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(40, 9));
        jMenu.add(jMenuItem);
        this.tabsMenu.setEnabled(false);
        jMenu.add(this.tabsMenu);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem(A4n.a4n.selectAllChannels);
        jMenuItem.setIcon(null);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(65, n));
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(A4n.a4n.deselectChannels);
        jMenuItem.setIcon(null);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(65, 1 | n));
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem(A4n.a4n.removeChannels);
        jMenuItem.setIcon(null);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(127, 1));
        jMenu.add(jMenuItem);
        jMenu = new JMenu(ClassicI18n.i18n.getMenuLabel("tabs"));
        this.menuBar.add(jMenu);
        jMenuItem = new JMenuItem(A4n.newChannelsTab);
        jMenuItem.setIcon(null);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(84, n));
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(A4n.editTabTitle);
        jMenuItem.setIcon(null);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(113, 0));
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem(A4n.moveTab2Beginning);
        jMenuItem.setIcon(null);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(37, 9));
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(A4n.moveTab2Left);
        jMenuItem.setIcon(null);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(37, 8));
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(A4n.moveTab2Right);
        jMenuItem.setIcon(null);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(39, 8));
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem(A4n.moveTab2End);
        jMenuItem.setIcon(null);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(39, 9));
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem(A4n.closeChannelsTab);
        jMenuItem.setIcon(null);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(87, n));
        jMenu.add(jMenuItem);
        jMenu = new JMenu(ClassicI18n.i18n.getMenuLabel("window"));
        this.menuBar.add(jMenu);
        jMenuItem = new JMenuItem(A4n.windowInstrumentsDb);
        jMenuItem.setIcon(null);
        jMenu.add(jMenuItem);
        final JMenuItem jMenuItem2 = new JMenuItem(ClassicI18n.i18n.getMenuLabel("window.backendLog"));
        jMenu.add(jMenuItem2);
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (MainFrame.this.getBackendLogFrame().isVisible()) {
                    MainFrame.this.getBackendLogFrame().setVisible(false);
                }
                MainFrame.this.getBackendLogFrame().setVisible(true);
            }
        });
        jMenuItem2.setEnabled(CC.getBackendProcess() != null);
        CC.addBackendProcessListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jMenuItem2.setEnabled(CC.getBackendProcess() != null);
            }
        });
        jMenu = new JMenu(ClassicI18n.i18n.getMenuLabel("help"));
        jMenuItem = new JMenuItem(A4n.helpAbout);
        jMenuItem.setIcon(null);
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem(A4n.a4n.browseOnlineTutorial);
        jMenuItem.setIcon(null);
        jMenu.add(jMenuItem);
        this.menuBar.add(jMenu);
    }

    private void handleEvents() {
        this.tabbedPane.addChangeListener(this);
    }

    private void showChannelsBar(boolean bl) {
        this.channelsBar.setVisible(bl);
        ClassicPrefs.setShowChannelsBar(bl);
        this.validate();
        this.repaint();
    }

    private void showStatusbar(boolean bl) {
        ClassicPrefs.setShowStatusbar(bl);
        this.statusbar.setVisible(bl);
    }

    protected boolean isLeftPaneVisible() {
        return this.cbmiLeftPaneVisible.isSelected();
    }

    protected void setLeftPaneVisible(boolean bl) {
        if (bl != this.cbmiLeftPaneVisible.isSelected()) {
            this.cbmiLeftPaneVisible.doClick(0);
        }
    }

    protected boolean isLSConsoleVisible() {
        return this.cbmiLSConsoleShown.isSelected();
    }

    protected void setLSConsoleVisible(boolean bl) {
        if (bl != this.cbmiLSConsoleShown.isSelected()) {
            this.cbmiLSConsoleShown.doClick(0);
        }
    }

    private void showLeftPane(boolean bl) {
        ClassicPrefs.setShowLeftPane(bl);
        this.mainPane.remove(this.hSplitPane);
        this.mainPane.remove(this.rightPane);
        if (bl) {
            this.hSplitPane.setRightComponent(this.rightPane);
            this.mainPane.add(this.hSplitPane);
            if (ClassicPrefs.getSaveWindowProperties()) {
                int n = ClassicPrefs.getHSplitDividerLocation();
                this.hSplitPane.setDividerLocation(n);
            }
        } else {
            this.mainPane.add(this.rightPane);
        }
        this.validate();
        this.repaint();
    }

    private void showStandardBar(boolean bl) {
        ClassicPrefs.setShowStandardBar(bl);
        this.standardBar.setVisible(bl);
        this.validate();
        this.repaint();
    }

    private void showBottomPane(boolean bl) {
        if (!bl) {
            ClassicPrefs.setVSplitDividerLocation(this.vSplitPane.getDividerLocation());
        }
        this.rightPane.remove(this.vSplitPane);
        this.rightPane.remove(this.channelsPane);
        if (bl) {
            this.vSplitPane.setTopComponent(this.channelsPane);
            this.rightPane.add(this.vSplitPane);
            this.vSplitPane.setDividerLocation(ClassicPrefs.getVSplitDividerLocation());
        } else {
            this.rightPane.add(this.channelsPane);
        }
        this.validate();
        this.repaint();
    }

    protected void setLSConsolePopOut(boolean bl) {
        if (bl == this.lsConsolePopOut) {
            return;
        }
        this.lsConsolePopOut = bl;
        if (this.isLSConsoleShown()) {
            this.setLSConsolePopOut0(bl);
        }
    }

    private void setLSConsolePopOut0(boolean bl) {
        if (bl) {
            this.bottomPane.remove(this.lsConsolePane);
            this.showBottomPane(false);
            this.lsConsoleDlg = new LSConsoleDlg((Frame)this, this.lsConsolePane);
            this.lsConsoleDlg.setVisible(true);
        } else {
            if (this.lsConsoleDlg != null) {
                this.lsConsoleDlg.setVisible(false);
            }
            this.lsConsoleDlg = null;
            this.bottomPane.add(this.lsConsolePane);
            this.showBottomPane(true);
        }
    }

    protected boolean isLSConsolePopOut() {
        return this.lsConsolePopOut;
    }

    protected boolean isLSConsoleShown() {
        return this.cbmiLSConsoleShown.isSelected();
    }

    protected void setLSConsoleShown(boolean bl) {
        this.cbmiLSConsoleShown.setSelected(bl);
    }

    @Override
    public LSConsoleModel getLSConsoleModel() {
        return this.lsConsolePane.getModel();
    }

    protected JSBackendLogFrame getBackendLogFrame() {
        return this.backendLogFrame;
    }

    protected void setLSConsoleTextColor(Color color) {
        this.lsConsolePane.setTextColor(color);
    }

    protected void setLSConsoleBackgroundColor(Color color) {
        this.lsConsolePane.setBackgroundColor(color);
    }

    protected void setLSConsoleNotifyColor(Color color) {
        this.lsConsolePane.setNotifyColor(color);
    }

    protected void setLSConsoleWarningColor(Color color) {
        this.lsConsolePane.setWarningColor(color);
    }

    protected void setLSConsoleErrorColor(Color color) {
        this.lsConsolePane.setErrorColor(color);
    }

    protected void showLSConsole(boolean bl) {
        if (!bl) {
            this.showBottomPane(false);
            if (this.lsConsoleDlg != null) {
                this.lsConsoleDlg.setVisible(false);
            }
            this.lsConsolePane.hideAutoCompleteWindow();
            return;
        }
        this.setLSConsolePopOut0(this.isLSConsolePopOut());
    }

    @Override
    public void addChannelsPane(JSChannelsPane jSChannelsPane) {
        this.insertChannelsPane(jSChannelsPane, this.getChannelsPaneCount());
    }

    @Override
    public void insertChannelsPane(JSChannelsPane jSChannelsPane, int n) {
        jSChannelsPane.addListSelectionListener(this);
        if (this.getChannelsPaneCount() == 1) {
            this.channelsPane.remove(this.getChannelsPane(0));
            this.channelsPane.add(this.tabbedPane);
            this.tabbedPane.addTab(this.getChannelsPane(0).getTitle(), this.getChannelsPane(0));
            A4n.closeChannelsTab.setEnabled(true);
            A4n.editTabTitle.setEnabled(true);
        }
        this.getChannelsPaneList().insertElementAt(jSChannelsPane, n);
        this.tabbedPane.insertTab(jSChannelsPane.getTitle(), null, jSChannelsPane, null, n);
        this.tabbedPane.setSelectedComponent(jSChannelsPane);
        this.miList.insertElementAt(new JMenuItem(new A4n.MoveChannelsTo(jSChannelsPane)), n);
        this.updateTabsMenu();
    }

    @Override
    public JSChannelsPane getSelectedChannelsPane() {
        if (this.getChannelsPaneList().size() == 1) {
            return this.getChannelsPane(0);
        }
        return (JSChannelsPane)this.tabbedPane.getSelectedComponent();
    }

    @Override
    public void setSelectedChannelsPane(JSChannelsPane jSChannelsPane) {
        if (this.getChannelsPaneList().size() == 1) {
            return;
        }
        this.tabbedPane.setSelectedComponent(jSChannelsPane);
        this.fireChannelsPaneSelectionChanged();
    }

    @Override
    public boolean removeChannelsPane(JSChannelsPane jSChannelsPane) {
        jSChannelsPane.removeListSelectionListener(this);
        this.tabbedPane.remove(jSChannelsPane);
        boolean bl = super.removeChannelsPane(jSChannelsPane);
        for (int i = 0; i < this.miList.size(); ++i) {
            A4n.MoveChannelsTo moveChannelsTo = (A4n.MoveChannelsTo)this.miList.get(i).getAction();
            if (!moveChannelsTo.getChannelsPane().equals(jSChannelsPane)) continue;
            this.miList.remove(i);
            break;
        }
        this.updateTabsMenu();
        if (this.getChannelsPaneCount() == 1) {
            A4n.closeChannelsTab.setEnabled(false);
            A4n.editTabTitle.setEnabled(false);
            this.tabbedPane.remove(this.getChannelsPane(0));
            this.channelsPane.remove(this.tabbedPane);
            this.channelsPane.add(this.getChannelsPane(0));
        }
        return bl;
    }

    private void updateTabsMenu() {
        this.tabsMenu.removeAll();
        for (JMenuItem jMenuItem : this.miList) {
            A4n.MoveChannelsTo moveChannelsTo = (A4n.MoveChannelsTo)jMenuItem.getAction();
            if (moveChannelsTo.getChannelsPane().equals(this.getSelectedChannelsPane())) continue;
            this.tabsMenu.add(jMenuItem);
        }
    }

    public void updateTabTitle(JSChannelsPane jSChannelsPane) {
        this.tabbedPane.setTitleAt(this.tabbedPane.getSelectedIndex(), jSChannelsPane.getTitle());
    }

    private void checkChannelSelection(JSChannelsPane jSChannelsPane) {
        int n;
        if (!jSChannelsPane.hasSelectedChannel()) {
            A4n.a4n.duplicateChannels.putValue("Name", ClassicI18n.i18n.getMenuLabel("channels.duplicate"));
            A4n.a4n.duplicateChannels.setEnabled(false);
            A4n.a4n.removeChannels.putValue("Name", ClassicI18n.i18n.getMenuLabel("channels.RemoveChannel"));
            A4n.a4n.removeChannels.setEnabled(false);
            this.tabsMenu.setEnabled(false);
            A4n.a4n.moveChannelsOnTop.setEnabled(false);
            A4n.a4n.moveChannelsUp.setEnabled(false);
            A4n.a4n.moveChannelsDown.setEnabled(false);
            A4n.a4n.moveChannelsAtBottom.setEnabled(false);
            return;
        }
        A4n.a4n.duplicateChannels.setEnabled(true);
        A4n.a4n.removeChannels.setEnabled(true);
        if (this.getChannelsPaneCount() > 1) {
            this.tabsMenu.setEnabled(true);
        }
        if (jSChannelsPane.getSelectedChannelCount() > 1) {
            A4n.a4n.duplicateChannels.putValue("Name", ClassicI18n.i18n.getMenuLabel("channels.duplicateChannels"));
            A4n.a4n.removeChannels.putValue("Name", ClassicI18n.i18n.getMenuLabel("channels.RemoveChannels"));
        } else {
            A4n.a4n.duplicateChannels.putValue("Name", ClassicI18n.i18n.getMenuLabel("channels.duplicate"));
            A4n.a4n.removeChannels.putValue("Name", ClassicI18n.i18n.getMenuLabel("channels.RemoveChannel"));
        }
        A4n.a4n.moveChannelsOnTop.setEnabled(false);
        A4n.a4n.moveChannelsUp.setEnabled(true);
        A4n.a4n.moveChannelsDown.setEnabled(true);
        A4n.a4n.moveChannelsAtBottom.setEnabled(false);
        JSChannel[] jSChannelArray = jSChannelsPane.getSelectedChannels();
        for (n = 0; n < jSChannelArray.length; ++n) {
            if (jSChannelsPane.getChannel(n) == jSChannelArray[n]) continue;
            A4n.a4n.moveChannelsOnTop.setEnabled(true);
            break;
        }
        if (jSChannelArray[0] == jSChannelsPane.getFirstChannel()) {
            A4n.a4n.moveChannelsUp.setEnabled(false);
        }
        if (jSChannelArray[jSChannelArray.length - 1] == jSChannelsPane.getLastChannel()) {
            A4n.a4n.moveChannelsDown.setEnabled(false);
        }
        n = jSChannelArray.length - 1;
        int n2 = jSChannelsPane.getChannelCount() - 1;
        while (n >= 0) {
            if (jSChannelsPane.getChannel(n2) != jSChannelArray[n]) {
                A4n.a4n.moveChannelsAtBottom.setEnabled(true);
                break;
            }
            --n;
            --n2;
        }
    }

    private void checkTabSelection() {
        int n = this.tabbedPane.getSelectedIndex();
        if (n > 0) {
            A4n.moveTab2Beginning.setEnabled(true);
            A4n.moveTab2Left.setEnabled(true);
        } else {
            A4n.moveTab2Beginning.setEnabled(false);
            A4n.moveTab2Left.setEnabled(false);
        }
        if (n != -1 && n < this.tabbedPane.getTabCount() - 1) {
            A4n.moveTab2Right.setEnabled(true);
            A4n.moveTab2End.setEnabled(true);
        } else {
            A4n.moveTab2Right.setEnabled(false);
            A4n.moveTab2End.setEnabled(false);
        }
    }

    public JMenu getTabsMenu() {
        return this.tabsMenu;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.updateTabsMenu();
        this.checkChannelSelection(this.getSelectedChannelsPane());
        this.checkTabSelection();
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        if (listSelectionEvent.getSource() != this.getSelectedChannelsPane()) {
            return;
        }
        this.checkChannelSelection(this.getSelectedChannelsPane());
    }

    public void moveTab2Beginning() {
        int n = this.tabbedPane.getSelectedIndex();
        if (n < 1) {
            CC.getLogger().info("Can't move tab to beginning");
            return;
        }
        JSChannelsPane jSChannelsPane = (JSChannelsPane)this.tabbedPane.getSelectedComponent();
        if (this.getChannelsPane(n) != jSChannelsPane) {
            CC.getLogger().warning("Channels pane indices don't match");
        }
        this.removeChannelsPane(jSChannelsPane);
        this.insertChannelsPane(jSChannelsPane, 0);
        this.tabbedPane.setSelectedComponent(jSChannelsPane);
    }

    public void moveTab2Left() {
        int n = this.tabbedPane.getSelectedIndex();
        if (n < 1) {
            CC.getLogger().info("Can't move tab to left");
            return;
        }
        JSChannelsPane jSChannelsPane = (JSChannelsPane)this.tabbedPane.getSelectedComponent();
        if (this.getChannelsPane(n) != jSChannelsPane) {
            CC.getLogger().warning("Channels pane indices don't match");
        }
        this.removeChannelsPane(jSChannelsPane);
        this.insertChannelsPane(jSChannelsPane, n - 1);
        this.tabbedPane.setSelectedComponent(jSChannelsPane);
    }

    public void moveTab2Right() {
        int n = this.tabbedPane.getSelectedIndex();
        if (n == -1 && n >= this.tabbedPane.getTabCount()) {
            CC.getLogger().info("Can't move tab to right");
            return;
        }
        JSChannelsPane jSChannelsPane = (JSChannelsPane)this.tabbedPane.getSelectedComponent();
        if (this.getChannelsPane(n) != jSChannelsPane) {
            CC.getLogger().warning("Channels pane indices don't match");
        }
        this.removeChannelsPane(jSChannelsPane);
        this.insertChannelsPane(jSChannelsPane, n + 1);
        this.tabbedPane.setSelectedComponent(jSChannelsPane);
    }

    public void moveTab2End() {
        int n = this.tabbedPane.getSelectedIndex();
        if (n == -1 && n >= this.tabbedPane.getTabCount()) {
            CC.getLogger().info("Can't move tab to right");
            return;
        }
        JSChannelsPane jSChannelsPane = (JSChannelsPane)this.tabbedPane.getSelectedComponent();
        if (this.getChannelsPane(n) != jSChannelsPane) {
            CC.getLogger().warning("Channels pane indices don't match");
        }
        this.removeChannelsPane(jSChannelsPane);
        this.addChannelsPane(jSChannelsPane);
        this.tabbedPane.setSelectedComponent(jSChannelsPane);
    }

    protected void runScript() {
        File file = StdUtils.showOpenLscpFileChooser();
        if (file == null) {
            return;
        }
        this.runScript(file);
    }

    @Override
    public void runScript(String string) {
        this.runScript(new File(string));
    }

    private void runScript(File file) {
        String string;
        FileReader fileReader;
        try {
            fileReader = new FileReader(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            HF.showErrorMessage(ClassicI18n.i18n.getError("fileNotFound!", file.getAbsolutePath()));
            return;
        }
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        try {
            string = bufferedReader.readLine();
            while (string != null) {
                this.getLSConsoleModel().setCommandLineText(string);
                this.getLSConsoleModel().execCommand();
                string = bufferedReader.readLine();
            }
        }
        catch (Exception exception) {
            HF.showErrorMessage(exception);
            return;
        }
        if (ClassicPrefs.preferences().getBoolProperty("showLSConsoleWhenRunScript") && !this.cbmiLSConsoleShown.isSelected()) {
            this.cbmiLSConsoleShown.doClick(0);
        }
        string = file.getAbsolutePath();
        this.recentScripts.remove(string);
        this.recentScripts.insertElementAt(string, 0);
        this.updateRecentScriptsMenu();
    }

    protected void clearRecentScripts() {
        this.recentScripts.removeAllElements();
        this.updateRecentScriptsMenu();
    }

    protected void updateRecentScriptsMenu() {
        int n = ClassicPrefs.preferences().getIntProperty("recentLscpScripts.maxNumber");
        while (this.recentScripts.size() > n) {
            this.recentScripts.removeElementAt(this.recentScripts.size() - 1);
        }
        this.recentScriptsMenu.removeAll();
        for (String string : this.recentScripts) {
            JMenuItem jMenuItem = new JMenuItem(string);
            this.recentScriptsMenu.add(jMenuItem);
            jMenuItem.addActionListener(new RecentScriptHandler(string));
        }
        this.recentScriptsMenu.setEnabled(this.recentScripts.size() != 0);
    }

    @Override
    public void installJSamplerHome() {
        JSamplerHomeChooser jSamplerHomeChooser = new JSamplerHomeChooser(this);
        jSamplerHomeChooser.setVisible(true);
        if (jSamplerHomeChooser.isCancelled()) {
            return;
        }
        JSUtils.changeJSamplerHome(jSamplerHomeChooser.getJSamplerHome());
    }

    @Override
    public void showDetailedErrorMessage(Frame frame, String string, String string2) {
        JSDetailedErrorDlg jSDetailedErrorDlg = new JSDetailedErrorDlg(frame, (Icon)Res.iconWarning32, ClassicI18n.i18n.getError("error"), string, string2);
        jSDetailedErrorDlg.setVisible(true);
    }

    @Override
    public void showDetailedErrorMessage(Dialog dialog, String string, String string2) {
        JSDetailedErrorDlg jSDetailedErrorDlg = new JSDetailedErrorDlg(dialog, (Icon)Res.iconWarning32, ClassicI18n.i18n.getError("error"), string, string2);
        jSDetailedErrorDlg.setVisible(true);
    }

    @Override
    public Server getServer() {
        boolean bl = ClassicPrefs.preferences().getBoolProperty("manualServerSelectOnStartup");
        return this.getServer(bl);
    }

    @Override
    public Server getServer(boolean bl) {
        if (bl) {
            JSConnectDlg jSConnectDlg = new JSConnectDlg();
            jSConnectDlg.setVisible(true);
            return jSConnectDlg.getSelectedServer();
        }
        int n = ClassicPrefs.preferences().getIntProperty("serverIndex");
        int n2 = CC.getServerList().getServerCount();
        if (n2 == 0) {
            return null;
        }
        if (n >= n2) {
            return CC.getServerList().getServer(0);
        }
        return CC.getServerList().getServer(n);
    }

    @Override
    public void handleConnectionFailure() {
        if (this.processConnectionFailure) {
            return;
        }
        this.processConnectionFailure = true;
        CC.getTaskQueue().add(new Global.Disconnect());
        JSConnectionFailurePane jSConnectionFailurePane = new JSConnectionFailurePane();
        jSConnectionFailurePane.showDialog();
        this.processConnectionFailure = false;
    }

    private class RecentScriptHandler
    implements ActionListener {
        private String script;

        RecentScriptHandler(String string) {
            this.script = string;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MainFrame.this.runScript(this.script);
        }
    }
}

