/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.agent;

import jakarta.servlet.ServletContext;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kafka.trogdor.agent.Agent;
import org.apache.kafka.trogdor.rest.AgentStatusResponse;
import org.apache.kafka.trogdor.rest.CreateWorkerRequest;
import org.apache.kafka.trogdor.rest.DestroyWorkerRequest;
import org.apache.kafka.trogdor.rest.Empty;
import org.apache.kafka.trogdor.rest.StopWorkerRequest;
import org.apache.kafka.trogdor.rest.UptimeResponse;

@Path(value="/agent")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class AgentRestResource {
    private final AtomicReference<Agent> agent = new AtomicReference<Object>(null);
    @Context
    private ServletContext context;

    public void setAgent(Agent myAgent) {
        this.agent.set(myAgent);
    }

    @GET
    @Path(value="/status")
    public AgentStatusResponse getStatus() throws Throwable {
        return this.agent().status();
    }

    @GET
    @Path(value="/uptime")
    public UptimeResponse uptime() {
        return this.agent().uptime();
    }

    @POST
    @Path(value="/worker/create")
    public Empty createWorker(CreateWorkerRequest req) throws Throwable {
        this.agent().createWorker(req);
        return Empty.INSTANCE;
    }

    @PUT
    @Path(value="/worker/stop")
    public Empty stopWorker(StopWorkerRequest req) throws Throwable {
        this.agent().stopWorker(req);
        return Empty.INSTANCE;
    }

    @DELETE
    @Path(value="/worker")
    public Empty destroyWorker(@DefaultValue(value="0") @QueryParam(value="workerId") long workerId) throws Throwable {
        this.agent().destroyWorker(new DestroyWorkerRequest(workerId));
        return Empty.INSTANCE;
    }

    @PUT
    @Path(value="/shutdown")
    public Empty shutdown() throws Throwable {
        this.agent().beginShutdown();
        return Empty.INSTANCE;
    }

    private Agent agent() {
        Agent myAgent = this.agent.get();
        if (myAgent == null) {
            throw new RuntimeException("AgentRestResource has not been initialized yet.");
        }
        return myAgent;
    }
}

