/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.engine.processor;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ml.common.utils.StringUtils;
import org.opensearch.ml.engine.annotation.Processor;
import org.opensearch.ml.engine.processor.AbstractMLProcessor;
import org.opensearch.ml.engine.processor.MLProcessorType;

@Processor(value=MLProcessorType.REGEX_CAPTURE)
public class MLRegexCaptureProcessor
extends AbstractMLProcessor {
    @Generated
    private static final Logger log = LogManager.getLogger(MLRegexCaptureProcessor.class);
    private final Pattern pattern;
    private final List<Integer> groupIndices;

    public MLRegexCaptureProcessor(Map<String, Object> config) {
        super(config);
        String patternStr = (String)config.get("pattern");
        try {
            this.pattern = Pattern.compile(patternStr, 32);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid regex pattern: " + patternStr, e);
        }
        this.groupIndices = this.parseGroups(config.getOrDefault("groups", "1"));
    }

    @Override
    protected void validateConfig() {
        if (!this.config.containsKey("pattern")) {
            throw new IllegalArgumentException("'pattern' is required for regex_capture processor");
        }
        String patternValue = (String)this.config.get("pattern");
        if (patternValue == null || patternValue.trim().isEmpty()) {
            throw new IllegalArgumentException("'pattern' cannot be empty for regex_capture processor");
        }
    }

    @Override
    public Object process(Object input) {
        String text = StringUtils.toJson((Object)input);
        try {
            Matcher matcher = this.pattern.matcher(text);
            if (matcher.find()) {
                ArrayList<String> captures = new ArrayList<String>();
                for (Integer idx : this.groupIndices) {
                    if (idx >= 0 && idx <= matcher.groupCount()) {
                        String captured = matcher.group(idx);
                        captures.add(captured);
                        continue;
                    }
                    log.debug("Group index {} is out of range (pattern has {} groups), skipping", (Object)idx, (Object)matcher.groupCount());
                }
                if (captures.isEmpty()) {
                    log.debug("No valid capture groups found, returning original input");
                    return input;
                }
                if (captures.size() == 1) {
                    return captures.get(0);
                }
                return captures;
            }
            log.debug("Pattern did not match input, returning original");
            return input;
        }
        catch (Exception e) {
            log.warn("Failed to apply regex capture with pattern '{}': {}", (Object)this.pattern.pattern(), (Object)e.getMessage());
            return input;
        }
    }

    /*
     * Unable to fully structure code
     */
    private List<Integer> parseGroups(Object groupsObj) {
        indices = new ArrayList<Integer>();
        if (groupsObj instanceof List) {
            groupsList = (List)groupsObj;
            for (E item : groupsList) {
                try {
                    indices.add(Integer.parseInt(item.toString().trim()));
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Invalid group index in list: " + String.valueOf(item), e);
                }
            }
        } else {
            try {
                groupsStr = groupsObj.toString().trim();
                if (groupsStr.startsWith("[") && groupsStr.endsWith("]")) {
                    content = groupsStr.substring(1, groupsStr.length() - 1).trim();
                    if (content.isEmpty()) ** GOTO lbl27
                    for (String part : parts = content.split(",")) {
                        indices.add(Integer.parseInt(part.trim()));
                    }
                }
                indices.add(Integer.parseInt(groupsStr));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid 'groups' format: " + String.valueOf(groupsObj) + ". Expected a number or array like '[1,2,3]'", e);
            }
        }
lbl27:
        // 4 sources

        if (indices.isEmpty()) {
            throw new IllegalArgumentException("'groups' must contain at least one group index");
        }
        return indices;
    }
}

